/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Destination;
import org.ldk.structs.MessageContext;
import org.ldk.structs.MessageForwardNode;
import org.ldk.structs.Result_CVec_BlindedMessagePathZNoneZ;
import org.ldk.structs.Result_OnionMessagePathNoneZ;
import org.ldk.util.InternalUtils;

public class MessageRouter
extends CommonBase {
    final bindings.LDKMessageRouter bindings_instance;

    MessageRouter(Object _dummy, long ptr) {
        super(ptr);
        this.bindings_instance = null;
    }

    private MessageRouter(bindings.LDKMessageRouter arg) {
        super(bindings.LDKMessageRouter_new(arg));
        this.ptrs_to.add(arg);
        this.bindings_instance = arg;
    }

    protected void finalize() throws Throwable {
        if (this.ptr != 0L) {
            bindings.MessageRouter_free(this.ptr);
        }
        super.finalize();
    }

    public void destroy() {
        if (this.ptr != 0L) {
            bindings.MessageRouter_free(this.ptr);
        }
        this.ptr = 0L;
    }

    public static MessageRouter new_impl(final MessageRouterInterface arg) {
        LDKMessageRouterHolder impl_holder = new LDKMessageRouterHolder();
        impl_holder.held = new MessageRouter(new bindings.LDKMessageRouter(){

            @Override
            public long find_path(byte[] sender, byte[][] peers, long destination) {
                Destination destination_hu_conv = Destination.constr_from_ptr(destination);
                if (destination_hu_conv != null) {
                    destination_hu_conv.ptrs_to.add(this);
                }
                Result_OnionMessagePathNoneZ ret = arg.find_path(sender, peers, destination_hu_conv);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long create_blinded_paths(byte[] recipient, long context, byte[][] peers) {
                MessageContext context_hu_conv = MessageContext.constr_from_ptr(context);
                if (context_hu_conv != null) {
                    context_hu_conv.ptrs_to.add(this);
                }
                Result_CVec_BlindedMessagePathZNoneZ ret = arg.create_blinded_paths(recipient, context_hu_conv, peers);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long create_compact_blinded_paths(byte[] recipient, long context, long[] peers) {
                MessageContext context_hu_conv = MessageContext.constr_from_ptr(context);
                if (context_hu_conv != null) {
                    context_hu_conv.ptrs_to.add(this);
                }
                int peers_conv_20_len = peers.length;
                MessageForwardNode[] peers_conv_20_arr = new MessageForwardNode[peers_conv_20_len];
                for (int u = 0; u < peers_conv_20_len; ++u) {
                    long peers_conv_20 = peers[u];
                    MessageForwardNode peers_conv_20_hu_conv = null;
                    if (peers_conv_20 < 0L || peers_conv_20 > 4096L) {
                        peers_conv_20_hu_conv = new MessageForwardNode(null, peers_conv_20);
                    }
                    if (peers_conv_20_hu_conv != null) {
                        peers_conv_20_hu_conv.ptrs_to.add(this);
                    }
                    peers_conv_20_arr[u] = peers_conv_20_hu_conv;
                }
                Result_CVec_BlindedMessagePathZNoneZ ret = arg.create_compact_blinded_paths(recipient, context_hu_conv, peers_conv_20_arr);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }
        });
        return impl_holder.held;
    }

    public Result_OnionMessagePathNoneZ find_path(byte[] sender, byte[][] peers, Destination destination) {
        long ret = bindings.MessageRouter_find_path(this.ptr, InternalUtils.check_arr_len(sender, 33), peers != null ? (byte[][])Arrays.stream(peers).map(peers_conv_8 -> InternalUtils.check_arr_len(peers_conv_8, 33)).toArray(x$0 -> new byte[x$0][]) : null, destination.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(sender);
        Reference.reachabilityFence(peers);
        Reference.reachabilityFence(destination);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_OnionMessagePathNoneZ ret_hu_conv = Result_OnionMessagePathNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_CVec_BlindedMessagePathZNoneZ create_blinded_paths(byte[] recipient, MessageContext context, byte[][] peers) {
        long ret = bindings.MessageRouter_create_blinded_paths(this.ptr, InternalUtils.check_arr_len(recipient, 33), context.ptr, peers != null ? (byte[][])Arrays.stream(peers).map(peers_conv_8 -> InternalUtils.check_arr_len(peers_conv_8, 33)).toArray(x$0 -> new byte[x$0][]) : null);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(recipient);
        Reference.reachabilityFence(context);
        Reference.reachabilityFence(peers);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_CVec_BlindedMessagePathZNoneZ ret_hu_conv = Result_CVec_BlindedMessagePathZNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_CVec_BlindedMessagePathZNoneZ create_compact_blinded_paths(byte[] recipient, MessageContext context, MessageForwardNode[] peers) {
        long ret = bindings.MessageRouter_create_compact_blinded_paths(this.ptr, InternalUtils.check_arr_len(recipient, 33), context.ptr, peers != null ? Arrays.stream(peers).mapToLong(peers_conv_20 -> peers_conv_20.ptr).toArray() : null);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(recipient);
        Reference.reachabilityFence(context);
        Reference.reachabilityFence(peers);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_CVec_BlindedMessagePathZNoneZ ret_hu_conv = Result_CVec_BlindedMessagePathZNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    private static class LDKMessageRouterHolder {
        MessageRouter held;

        private LDKMessageRouterHolder() {
        }
    }

    public static interface MessageRouterInterface {
        public Result_OnionMessagePathNoneZ find_path(byte[] var1, byte[][] var2, Destination var3);

        public Result_CVec_BlindedMessagePathZNoneZ create_blinded_paths(byte[] var1, MessageContext var2, byte[][] var3);

        public Result_CVec_BlindedMessagePathZNoneZ create_compact_blinded_paths(byte[] var1, MessageContext var2, MessageForwardNode[] var3);
    }
}

