/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.AcceptChannel;
import org.ldk.structs.AcceptChannelV2;
import org.ldk.structs.AnnouncementSignatures;
import org.ldk.structs.ChannelAnnouncement;
import org.ldk.structs.ChannelReady;
import org.ldk.structs.ChannelReestablish;
import org.ldk.structs.ChannelUpdate;
import org.ldk.structs.ClosingSigned;
import org.ldk.structs.CommitmentUpdate;
import org.ldk.structs.CommonBase;
import org.ldk.structs.ErrorAction;
import org.ldk.structs.FundingCreated;
import org.ldk.structs.FundingSigned;
import org.ldk.structs.GossipTimestampFilter;
import org.ldk.structs.NodeAnnouncement;
import org.ldk.structs.OpenChannel;
import org.ldk.structs.OpenChannelV2;
import org.ldk.structs.QueryChannelRange;
import org.ldk.structs.QueryShortChannelIds;
import org.ldk.structs.ReplyChannelRange;
import org.ldk.structs.RevokeAndACK;
import org.ldk.structs.Shutdown;
import org.ldk.structs.SpliceAck;
import org.ldk.structs.SpliceInit;
import org.ldk.structs.SpliceLocked;
import org.ldk.structs.Stfu;
import org.ldk.structs.TxAbort;
import org.ldk.structs.TxAckRbf;
import org.ldk.structs.TxAddInput;
import org.ldk.structs.TxAddOutput;
import org.ldk.structs.TxComplete;
import org.ldk.structs.TxInitRbf;
import org.ldk.structs.TxRemoveInput;
import org.ldk.structs.TxRemoveOutput;
import org.ldk.structs.TxSignatures;
import org.ldk.util.InternalUtils;

public class MessageSendEvent
extends CommonBase {
    private MessageSendEvent(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.MessageSendEvent_free(this.ptr);
        }
    }

    static MessageSendEvent constr_from_ptr(long ptr) {
        bindings.LDKMessageSendEvent raw_val = bindings.LDKMessageSendEvent_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendAcceptChannel.class) {
            return new SendAcceptChannel(ptr, (bindings.LDKMessageSendEvent.SendAcceptChannel)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendAcceptChannelV2.class) {
            return new SendAcceptChannelV2(ptr, (bindings.LDKMessageSendEvent.SendAcceptChannelV2)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendOpenChannel.class) {
            return new SendOpenChannel(ptr, (bindings.LDKMessageSendEvent.SendOpenChannel)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendOpenChannelV2.class) {
            return new SendOpenChannelV2(ptr, (bindings.LDKMessageSendEvent.SendOpenChannelV2)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendFundingCreated.class) {
            return new SendFundingCreated(ptr, (bindings.LDKMessageSendEvent.SendFundingCreated)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendFundingSigned.class) {
            return new SendFundingSigned(ptr, (bindings.LDKMessageSendEvent.SendFundingSigned)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendStfu.class) {
            return new SendStfu(ptr, (bindings.LDKMessageSendEvent.SendStfu)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendSpliceInit.class) {
            return new SendSpliceInit(ptr, (bindings.LDKMessageSendEvent.SendSpliceInit)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendSpliceAck.class) {
            return new SendSpliceAck(ptr, (bindings.LDKMessageSendEvent.SendSpliceAck)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendSpliceLocked.class) {
            return new SendSpliceLocked(ptr, (bindings.LDKMessageSendEvent.SendSpliceLocked)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendTxAddInput.class) {
            return new SendTxAddInput(ptr, (bindings.LDKMessageSendEvent.SendTxAddInput)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendTxAddOutput.class) {
            return new SendTxAddOutput(ptr, (bindings.LDKMessageSendEvent.SendTxAddOutput)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendTxRemoveInput.class) {
            return new SendTxRemoveInput(ptr, (bindings.LDKMessageSendEvent.SendTxRemoveInput)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendTxRemoveOutput.class) {
            return new SendTxRemoveOutput(ptr, (bindings.LDKMessageSendEvent.SendTxRemoveOutput)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendTxComplete.class) {
            return new SendTxComplete(ptr, (bindings.LDKMessageSendEvent.SendTxComplete)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendTxSignatures.class) {
            return new SendTxSignatures(ptr, (bindings.LDKMessageSendEvent.SendTxSignatures)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendTxInitRbf.class) {
            return new SendTxInitRbf(ptr, (bindings.LDKMessageSendEvent.SendTxInitRbf)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendTxAckRbf.class) {
            return new SendTxAckRbf(ptr, (bindings.LDKMessageSendEvent.SendTxAckRbf)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendTxAbort.class) {
            return new SendTxAbort(ptr, (bindings.LDKMessageSendEvent.SendTxAbort)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendChannelReady.class) {
            return new SendChannelReady(ptr, (bindings.LDKMessageSendEvent.SendChannelReady)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendAnnouncementSignatures.class) {
            return new SendAnnouncementSignatures(ptr, (bindings.LDKMessageSendEvent.SendAnnouncementSignatures)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.UpdateHTLCs.class) {
            return new UpdateHTLCs(ptr, (bindings.LDKMessageSendEvent.UpdateHTLCs)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendRevokeAndACK.class) {
            return new SendRevokeAndACK(ptr, (bindings.LDKMessageSendEvent.SendRevokeAndACK)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendClosingSigned.class) {
            return new SendClosingSigned(ptr, (bindings.LDKMessageSendEvent.SendClosingSigned)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendShutdown.class) {
            return new SendShutdown(ptr, (bindings.LDKMessageSendEvent.SendShutdown)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendChannelReestablish.class) {
            return new SendChannelReestablish(ptr, (bindings.LDKMessageSendEvent.SendChannelReestablish)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendChannelAnnouncement.class) {
            return new SendChannelAnnouncement(ptr, (bindings.LDKMessageSendEvent.SendChannelAnnouncement)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.BroadcastChannelAnnouncement.class) {
            return new BroadcastChannelAnnouncement(ptr, (bindings.LDKMessageSendEvent.BroadcastChannelAnnouncement)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.BroadcastChannelUpdate.class) {
            return new BroadcastChannelUpdate(ptr, (bindings.LDKMessageSendEvent.BroadcastChannelUpdate)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.BroadcastNodeAnnouncement.class) {
            return new BroadcastNodeAnnouncement(ptr, (bindings.LDKMessageSendEvent.BroadcastNodeAnnouncement)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendChannelUpdate.class) {
            return new SendChannelUpdate(ptr, (bindings.LDKMessageSendEvent.SendChannelUpdate)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.HandleError.class) {
            return new HandleError(ptr, (bindings.LDKMessageSendEvent.HandleError)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendChannelRangeQuery.class) {
            return new SendChannelRangeQuery(ptr, (bindings.LDKMessageSendEvent.SendChannelRangeQuery)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendShortIdsQuery.class) {
            return new SendShortIdsQuery(ptr, (bindings.LDKMessageSendEvent.SendShortIdsQuery)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendReplyChannelRange.class) {
            return new SendReplyChannelRange(ptr, (bindings.LDKMessageSendEvent.SendReplyChannelRange)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMessageSendEvent.SendGossipTimestampFilter.class) {
            return new SendGossipTimestampFilter(ptr, (bindings.LDKMessageSendEvent.SendGossipTimestampFilter)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.MessageSendEvent_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public MessageSendEvent clone() {
        long ret = bindings.MessageSendEvent_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_accept_channel(byte[] node_id, AcceptChannel msg) {
        long ret = bindings.MessageSendEvent_send_accept_channel(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_accept_channel_v2(byte[] node_id, AcceptChannelV2 msg) {
        long ret = bindings.MessageSendEvent_send_accept_channel_v2(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_open_channel(byte[] node_id, OpenChannel msg) {
        long ret = bindings.MessageSendEvent_send_open_channel(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_open_channel_v2(byte[] node_id, OpenChannelV2 msg) {
        long ret = bindings.MessageSendEvent_send_open_channel_v2(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_funding_created(byte[] node_id, FundingCreated msg) {
        long ret = bindings.MessageSendEvent_send_funding_created(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_funding_signed(byte[] node_id, FundingSigned msg) {
        long ret = bindings.MessageSendEvent_send_funding_signed(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_stfu(byte[] node_id, Stfu msg) {
        long ret = bindings.MessageSendEvent_send_stfu(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_splice_init(byte[] node_id, SpliceInit msg) {
        long ret = bindings.MessageSendEvent_send_splice_init(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_splice_ack(byte[] node_id, SpliceAck msg) {
        long ret = bindings.MessageSendEvent_send_splice_ack(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_splice_locked(byte[] node_id, SpliceLocked msg) {
        long ret = bindings.MessageSendEvent_send_splice_locked(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_tx_add_input(byte[] node_id, TxAddInput msg) {
        long ret = bindings.MessageSendEvent_send_tx_add_input(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_tx_add_output(byte[] node_id, TxAddOutput msg) {
        long ret = bindings.MessageSendEvent_send_tx_add_output(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_tx_remove_input(byte[] node_id, TxRemoveInput msg) {
        long ret = bindings.MessageSendEvent_send_tx_remove_input(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_tx_remove_output(byte[] node_id, TxRemoveOutput msg) {
        long ret = bindings.MessageSendEvent_send_tx_remove_output(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_tx_complete(byte[] node_id, TxComplete msg) {
        long ret = bindings.MessageSendEvent_send_tx_complete(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_tx_signatures(byte[] node_id, TxSignatures msg) {
        long ret = bindings.MessageSendEvent_send_tx_signatures(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_tx_init_rbf(byte[] node_id, TxInitRbf msg) {
        long ret = bindings.MessageSendEvent_send_tx_init_rbf(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_tx_ack_rbf(byte[] node_id, TxAckRbf msg) {
        long ret = bindings.MessageSendEvent_send_tx_ack_rbf(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_tx_abort(byte[] node_id, TxAbort msg) {
        long ret = bindings.MessageSendEvent_send_tx_abort(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_channel_ready(byte[] node_id, ChannelReady msg) {
        long ret = bindings.MessageSendEvent_send_channel_ready(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_announcement_signatures(byte[] node_id, AnnouncementSignatures msg) {
        long ret = bindings.MessageSendEvent_send_announcement_signatures(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent update_htlcs(byte[] node_id, CommitmentUpdate updates) {
        long ret = bindings.MessageSendEvent_update_htlcs(InternalUtils.check_arr_len(node_id, 33), updates.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(updates);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_revoke_and_ack(byte[] node_id, RevokeAndACK msg) {
        long ret = bindings.MessageSendEvent_send_revoke_and_ack(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_closing_signed(byte[] node_id, ClosingSigned msg) {
        long ret = bindings.MessageSendEvent_send_closing_signed(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_shutdown(byte[] node_id, Shutdown msg) {
        long ret = bindings.MessageSendEvent_send_shutdown(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_channel_reestablish(byte[] node_id, ChannelReestablish msg) {
        long ret = bindings.MessageSendEvent_send_channel_reestablish(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_channel_announcement(byte[] node_id, ChannelAnnouncement msg, ChannelUpdate update_msg) {
        long ret = bindings.MessageSendEvent_send_channel_announcement(InternalUtils.check_arr_len(node_id, 33), msg.ptr, update_msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        Reference.reachabilityFence(update_msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent broadcast_channel_announcement(ChannelAnnouncement msg, ChannelUpdate update_msg) {
        long ret = bindings.MessageSendEvent_broadcast_channel_announcement(msg.ptr, update_msg.ptr);
        Reference.reachabilityFence(msg);
        Reference.reachabilityFence(update_msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent broadcast_channel_update(ChannelUpdate msg) {
        long ret = bindings.MessageSendEvent_broadcast_channel_update(msg.ptr);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent broadcast_node_announcement(NodeAnnouncement msg) {
        long ret = bindings.MessageSendEvent_broadcast_node_announcement(msg.ptr);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_channel_update(byte[] node_id, ChannelUpdate msg) {
        long ret = bindings.MessageSendEvent_send_channel_update(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent handle_error(byte[] node_id, ErrorAction action) {
        long ret = bindings.MessageSendEvent_handle_error(InternalUtils.check_arr_len(node_id, 33), action.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(action);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_channel_range_query(byte[] node_id, QueryChannelRange msg) {
        long ret = bindings.MessageSendEvent_send_channel_range_query(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_short_ids_query(byte[] node_id, QueryShortChannelIds msg) {
        long ret = bindings.MessageSendEvent_send_short_ids_query(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_reply_channel_range(byte[] node_id, ReplyChannelRange msg) {
        long ret = bindings.MessageSendEvent_send_reply_channel_range(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MessageSendEvent send_gossip_timestamp_filter(byte[] node_id, GossipTimestampFilter msg) {
        long ret = bindings.MessageSendEvent_send_gossip_timestamp_filter(InternalUtils.check_arr_len(node_id, 33), msg.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEvent ret_hu_conv = MessageSendEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static final class SendAcceptChannel
    extends MessageSendEvent {
        public final byte[] node_id;
        public final AcceptChannel msg;

        private SendAcceptChannel(long ptr, bindings.LDKMessageSendEvent.SendAcceptChannel obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            AcceptChannel msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new AcceptChannel(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendAcceptChannelV2
    extends MessageSendEvent {
        public final byte[] node_id;
        public final AcceptChannelV2 msg;

        private SendAcceptChannelV2(long ptr, bindings.LDKMessageSendEvent.SendAcceptChannelV2 obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            AcceptChannelV2 msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new AcceptChannelV2(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendOpenChannel
    extends MessageSendEvent {
        public final byte[] node_id;
        public final OpenChannel msg;

        private SendOpenChannel(long ptr, bindings.LDKMessageSendEvent.SendOpenChannel obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            OpenChannel msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new OpenChannel(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendOpenChannelV2
    extends MessageSendEvent {
        public final byte[] node_id;
        public final OpenChannelV2 msg;

        private SendOpenChannelV2(long ptr, bindings.LDKMessageSendEvent.SendOpenChannelV2 obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            OpenChannelV2 msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new OpenChannelV2(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendFundingCreated
    extends MessageSendEvent {
        public final byte[] node_id;
        public final FundingCreated msg;

        private SendFundingCreated(long ptr, bindings.LDKMessageSendEvent.SendFundingCreated obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            FundingCreated msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new FundingCreated(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendFundingSigned
    extends MessageSendEvent {
        public final byte[] node_id;
        public final FundingSigned msg;

        private SendFundingSigned(long ptr, bindings.LDKMessageSendEvent.SendFundingSigned obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            FundingSigned msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new FundingSigned(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendStfu
    extends MessageSendEvent {
        public final byte[] node_id;
        public final Stfu msg;

        private SendStfu(long ptr, bindings.LDKMessageSendEvent.SendStfu obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            Stfu msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new Stfu(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendSpliceInit
    extends MessageSendEvent {
        public final byte[] node_id;
        public final SpliceInit msg;

        private SendSpliceInit(long ptr, bindings.LDKMessageSendEvent.SendSpliceInit obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            SpliceInit msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new SpliceInit(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendSpliceAck
    extends MessageSendEvent {
        public final byte[] node_id;
        public final SpliceAck msg;

        private SendSpliceAck(long ptr, bindings.LDKMessageSendEvent.SendSpliceAck obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            SpliceAck msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new SpliceAck(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendSpliceLocked
    extends MessageSendEvent {
        public final byte[] node_id;
        public final SpliceLocked msg;

        private SendSpliceLocked(long ptr, bindings.LDKMessageSendEvent.SendSpliceLocked obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            SpliceLocked msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new SpliceLocked(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendTxAddInput
    extends MessageSendEvent {
        public final byte[] node_id;
        public final TxAddInput msg;

        private SendTxAddInput(long ptr, bindings.LDKMessageSendEvent.SendTxAddInput obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            TxAddInput msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new TxAddInput(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendTxAddOutput
    extends MessageSendEvent {
        public final byte[] node_id;
        public final TxAddOutput msg;

        private SendTxAddOutput(long ptr, bindings.LDKMessageSendEvent.SendTxAddOutput obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            TxAddOutput msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new TxAddOutput(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendTxRemoveInput
    extends MessageSendEvent {
        public final byte[] node_id;
        public final TxRemoveInput msg;

        private SendTxRemoveInput(long ptr, bindings.LDKMessageSendEvent.SendTxRemoveInput obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            TxRemoveInput msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new TxRemoveInput(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendTxRemoveOutput
    extends MessageSendEvent {
        public final byte[] node_id;
        public final TxRemoveOutput msg;

        private SendTxRemoveOutput(long ptr, bindings.LDKMessageSendEvent.SendTxRemoveOutput obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            TxRemoveOutput msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new TxRemoveOutput(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendTxComplete
    extends MessageSendEvent {
        public final byte[] node_id;
        public final TxComplete msg;

        private SendTxComplete(long ptr, bindings.LDKMessageSendEvent.SendTxComplete obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            TxComplete msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new TxComplete(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendTxSignatures
    extends MessageSendEvent {
        public final byte[] node_id;
        public final TxSignatures msg;

        private SendTxSignatures(long ptr, bindings.LDKMessageSendEvent.SendTxSignatures obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            TxSignatures msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new TxSignatures(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendTxInitRbf
    extends MessageSendEvent {
        public final byte[] node_id;
        public final TxInitRbf msg;

        private SendTxInitRbf(long ptr, bindings.LDKMessageSendEvent.SendTxInitRbf obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            TxInitRbf msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new TxInitRbf(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendTxAckRbf
    extends MessageSendEvent {
        public final byte[] node_id;
        public final TxAckRbf msg;

        private SendTxAckRbf(long ptr, bindings.LDKMessageSendEvent.SendTxAckRbf obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            TxAckRbf msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new TxAckRbf(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendTxAbort
    extends MessageSendEvent {
        public final byte[] node_id;
        public final TxAbort msg;

        private SendTxAbort(long ptr, bindings.LDKMessageSendEvent.SendTxAbort obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            TxAbort msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new TxAbort(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendChannelReady
    extends MessageSendEvent {
        public final byte[] node_id;
        public final ChannelReady msg;

        private SendChannelReady(long ptr, bindings.LDKMessageSendEvent.SendChannelReady obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            ChannelReady msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new ChannelReady(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendAnnouncementSignatures
    extends MessageSendEvent {
        public final byte[] node_id;
        public final AnnouncementSignatures msg;

        private SendAnnouncementSignatures(long ptr, bindings.LDKMessageSendEvent.SendAnnouncementSignatures obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            AnnouncementSignatures msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new AnnouncementSignatures(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class UpdateHTLCs
    extends MessageSendEvent {
        public final byte[] node_id;
        public final CommitmentUpdate updates;

        private UpdateHTLCs(long ptr, bindings.LDKMessageSendEvent.UpdateHTLCs obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long updates = obj.updates;
            CommitmentUpdate updates_hu_conv = null;
            if (updates < 0L || updates > 4096L) {
                updates_hu_conv = new CommitmentUpdate(null, updates);
            }
            if (updates_hu_conv != null) {
                updates_hu_conv.ptrs_to.add(this);
            }
            this.updates = updates_hu_conv;
        }
    }

    public static final class SendRevokeAndACK
    extends MessageSendEvent {
        public final byte[] node_id;
        public final RevokeAndACK msg;

        private SendRevokeAndACK(long ptr, bindings.LDKMessageSendEvent.SendRevokeAndACK obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            RevokeAndACK msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new RevokeAndACK(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendClosingSigned
    extends MessageSendEvent {
        public final byte[] node_id;
        public final ClosingSigned msg;

        private SendClosingSigned(long ptr, bindings.LDKMessageSendEvent.SendClosingSigned obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            ClosingSigned msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new ClosingSigned(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendShutdown
    extends MessageSendEvent {
        public final byte[] node_id;
        public final Shutdown msg;

        private SendShutdown(long ptr, bindings.LDKMessageSendEvent.SendShutdown obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            Shutdown msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new Shutdown(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendChannelReestablish
    extends MessageSendEvent {
        public final byte[] node_id;
        public final ChannelReestablish msg;

        private SendChannelReestablish(long ptr, bindings.LDKMessageSendEvent.SendChannelReestablish obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            ChannelReestablish msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new ChannelReestablish(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendChannelAnnouncement
    extends MessageSendEvent {
        public final byte[] node_id;
        public final ChannelAnnouncement msg;
        public final ChannelUpdate update_msg;

        private SendChannelAnnouncement(long ptr, bindings.LDKMessageSendEvent.SendChannelAnnouncement obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            ChannelAnnouncement msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new ChannelAnnouncement(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
            long update_msg = obj.update_msg;
            ChannelUpdate update_msg_hu_conv = null;
            if (update_msg < 0L || update_msg > 4096L) {
                update_msg_hu_conv = new ChannelUpdate(null, update_msg);
            }
            if (update_msg_hu_conv != null) {
                update_msg_hu_conv.ptrs_to.add(this);
            }
            this.update_msg = update_msg_hu_conv;
        }
    }

    public static final class BroadcastChannelAnnouncement
    extends MessageSendEvent {
        public final ChannelAnnouncement msg;
        @Nullable
        public final ChannelUpdate update_msg;

        private BroadcastChannelAnnouncement(long ptr, bindings.LDKMessageSendEvent.BroadcastChannelAnnouncement obj) {
            super(null, ptr);
            long msg = obj.msg;
            ChannelAnnouncement msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new ChannelAnnouncement(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
            long update_msg = obj.update_msg;
            ChannelUpdate update_msg_hu_conv = null;
            if (update_msg < 0L || update_msg > 4096L) {
                update_msg_hu_conv = new ChannelUpdate(null, update_msg);
            }
            if (update_msg_hu_conv != null) {
                update_msg_hu_conv.ptrs_to.add(this);
            }
            this.update_msg = update_msg_hu_conv;
        }
    }

    public static final class BroadcastChannelUpdate
    extends MessageSendEvent {
        public final ChannelUpdate msg;

        private BroadcastChannelUpdate(long ptr, bindings.LDKMessageSendEvent.BroadcastChannelUpdate obj) {
            super(null, ptr);
            long msg = obj.msg;
            ChannelUpdate msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new ChannelUpdate(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class BroadcastNodeAnnouncement
    extends MessageSendEvent {
        public final NodeAnnouncement msg;

        private BroadcastNodeAnnouncement(long ptr, bindings.LDKMessageSendEvent.BroadcastNodeAnnouncement obj) {
            super(null, ptr);
            long msg = obj.msg;
            NodeAnnouncement msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new NodeAnnouncement(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendChannelUpdate
    extends MessageSendEvent {
        public final byte[] node_id;
        public final ChannelUpdate msg;

        private SendChannelUpdate(long ptr, bindings.LDKMessageSendEvent.SendChannelUpdate obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            ChannelUpdate msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new ChannelUpdate(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class HandleError
    extends MessageSendEvent {
        public final byte[] node_id;
        public final ErrorAction action;

        private HandleError(long ptr, bindings.LDKMessageSendEvent.HandleError obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long action = obj.action;
            ErrorAction action_hu_conv = ErrorAction.constr_from_ptr(action);
            if (action_hu_conv != null) {
                action_hu_conv.ptrs_to.add(this);
            }
            this.action = action_hu_conv;
        }
    }

    public static final class SendChannelRangeQuery
    extends MessageSendEvent {
        public final byte[] node_id;
        public final QueryChannelRange msg;

        private SendChannelRangeQuery(long ptr, bindings.LDKMessageSendEvent.SendChannelRangeQuery obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            QueryChannelRange msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new QueryChannelRange(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendShortIdsQuery
    extends MessageSendEvent {
        public final byte[] node_id;
        public final QueryShortChannelIds msg;

        private SendShortIdsQuery(long ptr, bindings.LDKMessageSendEvent.SendShortIdsQuery obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            QueryShortChannelIds msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new QueryShortChannelIds(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendReplyChannelRange
    extends MessageSendEvent {
        public final byte[] node_id;
        public final ReplyChannelRange msg;

        private SendReplyChannelRange(long ptr, bindings.LDKMessageSendEvent.SendReplyChannelRange obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            ReplyChannelRange msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new ReplyChannelRange(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendGossipTimestampFilter
    extends MessageSendEvent {
        public final byte[] node_id;
        public final GossipTimestampFilter msg;

        private SendGossipTimestampFilter(long ptr, bindings.LDKMessageSendEvent.SendGossipTimestampFilter obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long msg = obj.msg;
            GossipTimestampFilter msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new GossipTimestampFilter(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }
}

