/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.ChannelId;
import org.ldk.structs.ClosureReason;
import org.ldk.structs.CommonBase;
import org.ldk.structs.HTLCUpdate;
import org.ldk.structs.OutPoint;

public class MonitorEvent
extends CommonBase {
    private MonitorEvent(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.MonitorEvent_free(this.ptr);
        }
    }

    static MonitorEvent constr_from_ptr(long ptr) {
        bindings.LDKMonitorEvent raw_val = bindings.LDKMonitorEvent_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKMonitorEvent.HTLCEvent.class) {
            return new HTLCEvent(ptr, (bindings.LDKMonitorEvent.HTLCEvent)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMonitorEvent.HolderForceClosedWithInfo.class) {
            return new HolderForceClosedWithInfo(ptr, (bindings.LDKMonitorEvent.HolderForceClosedWithInfo)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMonitorEvent.HolderForceClosed.class) {
            return new HolderForceClosed(ptr, (bindings.LDKMonitorEvent.HolderForceClosed)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKMonitorEvent.Completed.class) {
            return new Completed(ptr, (bindings.LDKMonitorEvent.Completed)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.MonitorEvent_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public MonitorEvent clone() {
        long ret = bindings.MonitorEvent_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MonitorEvent ret_hu_conv = MonitorEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static MonitorEvent htlcevent(HTLCUpdate a) {
        long ret = bindings.MonitorEvent_htlcevent(a.ptr);
        Reference.reachabilityFence(a);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MonitorEvent ret_hu_conv = MonitorEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MonitorEvent holder_force_closed_with_info(ClosureReason reason, OutPoint outpoint, ChannelId channel_id) {
        long ret = bindings.MonitorEvent_holder_force_closed_with_info(reason.ptr, outpoint.ptr, channel_id.ptr);
        Reference.reachabilityFence(reason);
        Reference.reachabilityFence(outpoint);
        Reference.reachabilityFence(channel_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MonitorEvent ret_hu_conv = MonitorEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MonitorEvent holder_force_closed(OutPoint a) {
        long ret = bindings.MonitorEvent_holder_force_closed(a.ptr);
        Reference.reachabilityFence(a);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MonitorEvent ret_hu_conv = MonitorEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static MonitorEvent completed(OutPoint funding_txo, ChannelId channel_id, long monitor_update_id) {
        long ret = bindings.MonitorEvent_completed(funding_txo.ptr, channel_id.ptr, monitor_update_id);
        Reference.reachabilityFence(funding_txo);
        Reference.reachabilityFence(channel_id);
        Reference.reachabilityFence(monitor_update_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MonitorEvent ret_hu_conv = MonitorEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public boolean eq(MonitorEvent b) {
        boolean ret = bindings.MonitorEvent_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MonitorEvent)) {
            return false;
        }
        return this.eq((MonitorEvent)o);
    }

    public byte[] write() {
        byte[] ret = bindings.MonitorEvent_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static final class HTLCEvent
    extends MonitorEvent {
        public final HTLCUpdate htlc_event;

        private HTLCEvent(long ptr, bindings.LDKMonitorEvent.HTLCEvent obj) {
            super(null, ptr);
            long htlc_event = obj.htlc_event;
            HTLCUpdate htlc_event_hu_conv = null;
            if (htlc_event < 0L || htlc_event > 4096L) {
                htlc_event_hu_conv = new HTLCUpdate(null, htlc_event);
            }
            if (htlc_event_hu_conv != null) {
                htlc_event_hu_conv.ptrs_to.add(this);
            }
            this.htlc_event = htlc_event_hu_conv;
        }
    }

    public static final class HolderForceClosedWithInfo
    extends MonitorEvent {
        public final ClosureReason reason;
        public final OutPoint outpoint;
        public final ChannelId channel_id;

        private HolderForceClosedWithInfo(long ptr, bindings.LDKMonitorEvent.HolderForceClosedWithInfo obj) {
            super(null, ptr);
            long reason = obj.reason;
            ClosureReason reason_hu_conv = ClosureReason.constr_from_ptr(reason);
            if (reason_hu_conv != null) {
                reason_hu_conv.ptrs_to.add(this);
            }
            this.reason = reason_hu_conv;
            long outpoint = obj.outpoint;
            OutPoint outpoint_hu_conv = null;
            if (outpoint < 0L || outpoint > 4096L) {
                outpoint_hu_conv = new OutPoint(null, outpoint);
            }
            if (outpoint_hu_conv != null) {
                outpoint_hu_conv.ptrs_to.add(this);
            }
            this.outpoint = outpoint_hu_conv;
            long channel_id = obj.channel_id;
            ChannelId channel_id_hu_conv = null;
            if (channel_id < 0L || channel_id > 4096L) {
                channel_id_hu_conv = new ChannelId(null, channel_id);
            }
            if (channel_id_hu_conv != null) {
                channel_id_hu_conv.ptrs_to.add(this);
            }
            this.channel_id = channel_id_hu_conv;
        }
    }

    public static final class HolderForceClosed
    extends MonitorEvent {
        public final OutPoint holder_force_closed;

        private HolderForceClosed(long ptr, bindings.LDKMonitorEvent.HolderForceClosed obj) {
            super(null, ptr);
            long holder_force_closed = obj.holder_force_closed;
            OutPoint holder_force_closed_hu_conv = null;
            if (holder_force_closed < 0L || holder_force_closed > 4096L) {
                holder_force_closed_hu_conv = new OutPoint(null, holder_force_closed);
            }
            if (holder_force_closed_hu_conv != null) {
                holder_force_closed_hu_conv.ptrs_to.add(this);
            }
            this.holder_force_closed = holder_force_closed_hu_conv;
        }
    }

    public static final class Completed
    extends MonitorEvent {
        public final OutPoint funding_txo;
        public final ChannelId channel_id;
        public final long monitor_update_id;

        private Completed(long ptr, bindings.LDKMonitorEvent.Completed obj) {
            super(null, ptr);
            long funding_txo = obj.funding_txo;
            OutPoint funding_txo_hu_conv = null;
            if (funding_txo < 0L || funding_txo > 4096L) {
                funding_txo_hu_conv = new OutPoint(null, funding_txo);
            }
            if (funding_txo_hu_conv != null) {
                funding_txo_hu_conv.ptrs_to.add(this);
            }
            this.funding_txo = funding_txo_hu_conv;
            long channel_id = obj.channel_id;
            ChannelId channel_id_hu_conv = null;
            if (channel_id < 0L || channel_id > 4096L) {
                channel_id_hu_conv = new ChannelId(null, channel_id);
            }
            if (channel_id_hu_conv != null) {
                channel_id_hu_conv.ptrs_to.add(this);
            }
            this.channel_id = channel_id_hu_conv;
            this.monitor_update_id = obj.monitor_update_id;
        }
    }
}

