/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.enums.Network;
import org.ldk.impl.bindings;
import org.ldk.structs.ChannelAnnouncement;
import org.ldk.structs.ChannelFeatures;
import org.ldk.structs.ChannelUpdate;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Logger;
import org.ldk.structs.NetworkUpdate;
import org.ldk.structs.NodeAnnouncement;
import org.ldk.structs.Option_UtxoLookupZ;
import org.ldk.structs.Option_u32Z;
import org.ldk.structs.ReadOnlyNetworkGraph;
import org.ldk.structs.Result_NetworkGraphDecodeErrorZ;
import org.ldk.structs.Result_NoneLightningErrorZ;
import org.ldk.structs.UnsignedChannelAnnouncement;
import org.ldk.structs.UnsignedChannelUpdate;
import org.ldk.structs.UnsignedNodeAnnouncement;
import org.ldk.util.InternalUtils;

public class NetworkGraph
extends CommonBase {
    NetworkGraph(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.NetworkGraph_free(this.ptr);
        }
    }

    public void handle_network_update(NetworkUpdate network_update) {
        bindings.NetworkGraph_handle_network_update(this.ptr, network_update.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(network_update);
    }

    public byte[] get_chain_hash() {
        byte[] ret = bindings.NetworkGraph_get_chain_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public byte[] write() {
        byte[] ret = bindings.NetworkGraph_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_NetworkGraphDecodeErrorZ read(byte[] ser, Logger arg) {
        long ret = bindings.NetworkGraph_read(ser, arg.ptr);
        Reference.reachabilityFence(ser);
        Reference.reachabilityFence(arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NetworkGraphDecodeErrorZ ret_hu_conv = Result_NetworkGraphDecodeErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg);
        }
        return ret_hu_conv;
    }

    public String to_str() {
        String ret = bindings.NetworkGraph_to_str(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static NetworkGraph of(Network network, Logger logger) {
        long ret = bindings.NetworkGraph_new(network, logger.ptr);
        Reference.reachabilityFence((Object)network);
        Reference.reachabilityFence(logger);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        NetworkGraph ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new NetworkGraph(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(logger);
        }
        return ret_hu_conv;
    }

    public ReadOnlyNetworkGraph read_only() {
        long ret = bindings.NetworkGraph_read_only(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ReadOnlyNetworkGraph ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ReadOnlyNetworkGraph(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Option_u32Z get_last_rapid_gossip_sync_timestamp() {
        long ret = bindings.NetworkGraph_get_last_rapid_gossip_sync_timestamp(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u32Z ret_hu_conv = Option_u32Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_last_rapid_gossip_sync_timestamp(int last_rapid_gossip_sync_timestamp) {
        bindings.NetworkGraph_set_last_rapid_gossip_sync_timestamp(this.ptr, last_rapid_gossip_sync_timestamp);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(last_rapid_gossip_sync_timestamp);
    }

    public Result_NoneLightningErrorZ update_node_from_announcement(NodeAnnouncement msg) {
        long ret = bindings.NetworkGraph_update_node_from_announcement(this.ptr, msg.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneLightningErrorZ ret_hu_conv = Result_NoneLightningErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(msg);
        }
        return ret_hu_conv;
    }

    public Result_NoneLightningErrorZ update_node_from_unsigned_announcement(UnsignedNodeAnnouncement msg) {
        long ret = bindings.NetworkGraph_update_node_from_unsigned_announcement(this.ptr, msg.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneLightningErrorZ ret_hu_conv = Result_NoneLightningErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(msg);
        }
        return ret_hu_conv;
    }

    public Result_NoneLightningErrorZ update_channel_from_announcement(ChannelAnnouncement msg, Option_UtxoLookupZ utxo_lookup) {
        long ret = bindings.NetworkGraph_update_channel_from_announcement(this.ptr, msg.ptr, utxo_lookup.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(msg);
        Reference.reachabilityFence(utxo_lookup);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneLightningErrorZ ret_hu_conv = Result_NoneLightningErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(msg);
        }
        if (this != null) {
            this.ptrs_to.add(utxo_lookup);
        }
        return ret_hu_conv;
    }

    public Result_NoneLightningErrorZ update_channel_from_announcement_no_lookup(ChannelAnnouncement msg) {
        long ret = bindings.NetworkGraph_update_channel_from_announcement_no_lookup(this.ptr, msg.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneLightningErrorZ ret_hu_conv = Result_NoneLightningErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(msg);
        }
        return ret_hu_conv;
    }

    public Result_NoneLightningErrorZ update_channel_from_unsigned_announcement(UnsignedChannelAnnouncement msg, Option_UtxoLookupZ utxo_lookup) {
        long ret = bindings.NetworkGraph_update_channel_from_unsigned_announcement(this.ptr, msg.ptr, utxo_lookup.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(msg);
        Reference.reachabilityFence(utxo_lookup);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneLightningErrorZ ret_hu_conv = Result_NoneLightningErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(msg);
        }
        if (this != null) {
            this.ptrs_to.add(utxo_lookup);
        }
        return ret_hu_conv;
    }

    public Result_NoneLightningErrorZ add_channel_from_partial_announcement(long short_channel_id, long timestamp, ChannelFeatures features, byte[] node_id_1, byte[] node_id_2) {
        long ret = bindings.NetworkGraph_add_channel_from_partial_announcement(this.ptr, short_channel_id, timestamp, features.ptr, InternalUtils.check_arr_len(node_id_1, 33), InternalUtils.check_arr_len(node_id_2, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(short_channel_id);
        Reference.reachabilityFence(timestamp);
        Reference.reachabilityFence(features);
        Reference.reachabilityFence(node_id_1);
        Reference.reachabilityFence(node_id_2);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneLightningErrorZ ret_hu_conv = Result_NoneLightningErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public void channel_failed_permanent(long short_channel_id) {
        bindings.NetworkGraph_channel_failed_permanent(this.ptr, short_channel_id);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(short_channel_id);
    }

    public void node_failed_permanent(byte[] node_id) {
        bindings.NetworkGraph_node_failed_permanent(this.ptr, InternalUtils.check_arr_len(node_id, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(node_id);
    }

    public void remove_stale_channels_and_tracking() {
        bindings.NetworkGraph_remove_stale_channels_and_tracking(this.ptr);
        Reference.reachabilityFence(this);
    }

    public void remove_stale_channels_and_tracking_with_time(long current_time_unix) {
        bindings.NetworkGraph_remove_stale_channels_and_tracking_with_time(this.ptr, current_time_unix);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(current_time_unix);
    }

    public Result_NoneLightningErrorZ update_channel(ChannelUpdate msg) {
        long ret = bindings.NetworkGraph_update_channel(this.ptr, msg.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneLightningErrorZ ret_hu_conv = Result_NoneLightningErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(msg);
        }
        return ret_hu_conv;
    }

    public Result_NoneLightningErrorZ update_channel_unsigned(UnsignedChannelUpdate msg) {
        long ret = bindings.NetworkGraph_update_channel_unsigned(this.ptr, msg.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneLightningErrorZ ret_hu_conv = Result_NoneLightningErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(msg);
        }
        return ret_hu_conv;
    }

    public Result_NoneLightningErrorZ verify_channel_update(ChannelUpdate msg) {
        long ret = bindings.NetworkGraph_verify_channel_update(this.ptr, msg.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneLightningErrorZ ret_hu_conv = Result_NoneLightningErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(msg);
        }
        return ret_hu_conv;
    }
}

