/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.util.InternalUtils;

public class NetworkUpdate
extends CommonBase {
    private NetworkUpdate(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.NetworkUpdate_free(this.ptr);
        }
    }

    static NetworkUpdate constr_from_ptr(long ptr) {
        bindings.LDKNetworkUpdate raw_val = bindings.LDKNetworkUpdate_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKNetworkUpdate.ChannelFailure.class) {
            return new ChannelFailure(ptr, (bindings.LDKNetworkUpdate.ChannelFailure)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKNetworkUpdate.NodeFailure.class) {
            return new NodeFailure(ptr, (bindings.LDKNetworkUpdate.NodeFailure)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.NetworkUpdate_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public NetworkUpdate clone() {
        long ret = bindings.NetworkUpdate_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        NetworkUpdate ret_hu_conv = NetworkUpdate.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static NetworkUpdate channel_failure(long short_channel_id, boolean is_permanent) {
        long ret = bindings.NetworkUpdate_channel_failure(short_channel_id, is_permanent);
        Reference.reachabilityFence(short_channel_id);
        Reference.reachabilityFence(is_permanent);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        NetworkUpdate ret_hu_conv = NetworkUpdate.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static NetworkUpdate node_failure(byte[] node_id, boolean is_permanent) {
        long ret = bindings.NetworkUpdate_node_failure(InternalUtils.check_arr_len(node_id, 33), is_permanent);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(is_permanent);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        NetworkUpdate ret_hu_conv = NetworkUpdate.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public boolean eq(NetworkUpdate b) {
        boolean ret = bindings.NetworkUpdate_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NetworkUpdate)) {
            return false;
        }
        return this.eq((NetworkUpdate)o);
    }

    public byte[] write() {
        byte[] ret = bindings.NetworkUpdate_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static final class ChannelFailure
    extends NetworkUpdate {
        public final long short_channel_id;
        public final boolean is_permanent;

        private ChannelFailure(long ptr, bindings.LDKNetworkUpdate.ChannelFailure obj) {
            super(null, ptr);
            this.short_channel_id = obj.short_channel_id;
            this.is_permanent = obj.is_permanent;
        }
    }

    public static final class NodeFailure
    extends NetworkUpdate {
        public final byte[] node_id;
        public final boolean is_permanent;

        private NodeFailure(long ptr, bindings.LDKNetworkUpdate.NodeFailure obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            this.is_permanent = obj.is_permanent;
        }
    }
}

