/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Result_NodeIdDecodeErrorZ;
import org.ldk.structs.Result_PublicKeySecp256k1ErrorZ;
import org.ldk.util.InternalUtils;

public class NodeId
extends CommonBase {
    NodeId(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.NodeId_free(this.ptr);
        }
    }

    long clone_ptr() {
        long ret = bindings.NodeId_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public NodeId clone() {
        long ret = bindings.NodeId_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        NodeId ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new NodeId(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public boolean eq(NodeId b) {
        boolean ret = bindings.NodeId_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeId)) {
            return false;
        }
        return this.eq((NodeId)o);
    }

    public static NodeId from_pubkey(byte[] pubkey) {
        long ret = bindings.NodeId_from_pubkey(InternalUtils.check_arr_len(pubkey, 33));
        Reference.reachabilityFence(pubkey);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        NodeId ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new NodeId(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Result_NodeIdDecodeErrorZ from_slice(byte[] bytes) {
        long ret = bindings.NodeId_from_slice(bytes);
        Reference.reachabilityFence(bytes);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NodeIdDecodeErrorZ ret_hu_conv = Result_NodeIdDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public byte[] as_slice() {
        byte[] ret = bindings.NodeId_as_slice(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public byte[] as_array() {
        byte[] ret = bindings.NodeId_as_array(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public Result_PublicKeySecp256k1ErrorZ as_pubkey() {
        long ret = bindings.NodeId_as_pubkey(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_PublicKeySecp256k1ErrorZ ret_hu_conv = Result_PublicKeySecp256k1ErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public String to_str() {
        String ret = bindings.NodeId_to_str(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public long hash() {
        long ret = bindings.NodeId_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public byte[] write() {
        byte[] ret = bindings.NodeId_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_NodeIdDecodeErrorZ read(byte[] ser) {
        long ret = bindings.NodeId_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NodeIdDecodeErrorZ ret_hu_conv = Result_NodeIdDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }
}

