/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.enums.Recipient;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.ExpandedKey;
import org.ldk.structs.Option_BigEndianScalarZ;
import org.ldk.structs.RawBolt11Invoice;
import org.ldk.structs.Result_ECDSASignatureNoneZ;
import org.ldk.structs.Result_PublicKeyNoneZ;
import org.ldk.structs.Result_RecoverableSignatureNoneZ;
import org.ldk.structs.Result_SchnorrSignatureNoneZ;
import org.ldk.structs.Result_ThirtyTwoBytesNoneZ;
import org.ldk.structs.UnsignedBolt12Invoice;
import org.ldk.structs.UnsignedGossipMessage;
import org.ldk.util.InternalUtils;

public class NodeSigner
extends CommonBase {
    final bindings.LDKNodeSigner bindings_instance;

    NodeSigner(Object _dummy, long ptr) {
        super(ptr);
        this.bindings_instance = null;
    }

    private NodeSigner(bindings.LDKNodeSigner arg) {
        super(bindings.LDKNodeSigner_new(arg));
        this.ptrs_to.add(arg);
        this.bindings_instance = arg;
    }

    protected void finalize() throws Throwable {
        if (this.ptr != 0L) {
            bindings.NodeSigner_free(this.ptr);
        }
        super.finalize();
    }

    public void destroy() {
        if (this.ptr != 0L) {
            bindings.NodeSigner_free(this.ptr);
        }
        this.ptr = 0L;
    }

    public static NodeSigner new_impl(final NodeSignerInterface arg) {
        LDKNodeSignerHolder impl_holder = new LDKNodeSignerHolder();
        impl_holder.held = new NodeSigner(new bindings.LDKNodeSigner(){

            @Override
            public long get_inbound_payment_key() {
                ExpandedKey ret = arg.get_inbound_payment_key();
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long get_node_id(Recipient recipient) {
                Result_PublicKeyNoneZ ret = arg.get_node_id(recipient);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long ecdh(Recipient recipient, byte[] other_key, long tweak) {
                Option_BigEndianScalarZ tweak_hu_conv = Option_BigEndianScalarZ.constr_from_ptr(tweak);
                if (tweak_hu_conv != null) {
                    tweak_hu_conv.ptrs_to.add(this);
                }
                Result_ThirtyTwoBytesNoneZ ret = arg.ecdh(recipient, other_key, tweak_hu_conv);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long sign_invoice(long invoice, Recipient recipient) {
                RawBolt11Invoice invoice_hu_conv = null;
                if (invoice < 0L || invoice > 4096L) {
                    invoice_hu_conv = new RawBolt11Invoice(null, invoice);
                }
                Result_RecoverableSignatureNoneZ ret = arg.sign_invoice(invoice_hu_conv, recipient);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long sign_bolt12_invoice(long invoice) {
                UnsignedBolt12Invoice invoice_hu_conv = null;
                if (invoice < 0L || invoice > 4096L) {
                    invoice_hu_conv = new UnsignedBolt12Invoice(null, invoice);
                }
                Result_SchnorrSignatureNoneZ ret = arg.sign_bolt12_invoice(invoice_hu_conv);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long sign_gossip_message(long msg) {
                UnsignedGossipMessage msg_hu_conv = UnsignedGossipMessage.constr_from_ptr(msg);
                if (msg_hu_conv != null) {
                    msg_hu_conv.ptrs_to.add(this);
                }
                Result_ECDSASignatureNoneZ ret = arg.sign_gossip_message(msg_hu_conv);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }
        });
        return impl_holder.held;
    }

    public ExpandedKey get_inbound_payment_key() {
        long ret = bindings.NodeSigner_get_inbound_payment_key(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ExpandedKey ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ExpandedKey(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Result_PublicKeyNoneZ get_node_id(Recipient recipient) {
        long ret = bindings.NodeSigner_get_node_id(this.ptr, recipient);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence((Object)recipient);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_PublicKeyNoneZ ret_hu_conv = Result_PublicKeyNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_ThirtyTwoBytesNoneZ ecdh(Recipient recipient, byte[] other_key, Option_BigEndianScalarZ tweak) {
        long ret = bindings.NodeSigner_ecdh(this.ptr, recipient, InternalUtils.check_arr_len(other_key, 33), tweak.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence((Object)recipient);
        Reference.reachabilityFence(other_key);
        Reference.reachabilityFence(tweak);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ThirtyTwoBytesNoneZ ret_hu_conv = Result_ThirtyTwoBytesNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_RecoverableSignatureNoneZ sign_invoice(RawBolt11Invoice invoice, Recipient recipient) {
        long ret = bindings.NodeSigner_sign_invoice(this.ptr, invoice.ptr, recipient);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(invoice);
        Reference.reachabilityFence((Object)recipient);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_RecoverableSignatureNoneZ ret_hu_conv = Result_RecoverableSignatureNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(invoice);
        }
        return ret_hu_conv;
    }

    public Result_SchnorrSignatureNoneZ sign_bolt12_invoice(UnsignedBolt12Invoice invoice) {
        long ret = bindings.NodeSigner_sign_bolt12_invoice(this.ptr, invoice.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(invoice);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_SchnorrSignatureNoneZ ret_hu_conv = Result_SchnorrSignatureNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(invoice);
        }
        return ret_hu_conv;
    }

    public Result_ECDSASignatureNoneZ sign_gossip_message(UnsignedGossipMessage msg) {
        long ret = bindings.NodeSigner_sign_gossip_message(this.ptr, msg.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ECDSASignatureNoneZ ret_hu_conv = Result_ECDSASignatureNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    private static class LDKNodeSignerHolder {
        NodeSigner held;

        private LDKNodeSignerHolder() {
        }
    }

    public static interface NodeSignerInterface {
        public ExpandedKey get_inbound_payment_key();

        public Result_PublicKeyNoneZ get_node_id(Recipient var1);

        public Result_ThirtyTwoBytesNoneZ ecdh(Recipient var1, byte[] var2, Option_BigEndianScalarZ var3);

        public Result_RecoverableSignatureNoneZ sign_invoice(RawBolt11Invoice var1, Recipient var2);

        public Result_SchnorrSignatureNoneZ sign_bolt12_invoice(UnsignedBolt12Invoice var1);

        public Result_ECDSASignatureNoneZ sign_gossip_message(UnsignedGossipMessage var1);
    }
}

