/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Nonce;
import org.ldk.structs.Result_OffersContextDecodeErrorZ;
import org.ldk.util.InternalUtils;

public class OffersContext
extends CommonBase {
    private OffersContext(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.OffersContext_free(this.ptr);
        }
    }

    static OffersContext constr_from_ptr(long ptr) {
        bindings.LDKOffersContext raw_val = bindings.LDKOffersContext_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKOffersContext.InvoiceRequest.class) {
            return new InvoiceRequest(ptr, (bindings.LDKOffersContext.InvoiceRequest)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKOffersContext.OutboundPayment.class) {
            return new OutboundPayment(ptr, (bindings.LDKOffersContext.OutboundPayment)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKOffersContext.InboundPayment.class) {
            return new InboundPayment(ptr, (bindings.LDKOffersContext.InboundPayment)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.OffersContext_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public OffersContext clone() {
        long ret = bindings.OffersContext_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OffersContext ret_hu_conv = OffersContext.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static OffersContext invoice_request(Nonce nonce) {
        long ret = bindings.OffersContext_invoice_request(nonce.ptr);
        Reference.reachabilityFence(nonce);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OffersContext ret_hu_conv = OffersContext.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static OffersContext outbound_payment(byte[] payment_id, Nonce nonce, byte[] hmac) {
        long ret = bindings.OffersContext_outbound_payment(InternalUtils.check_arr_len(payment_id, 32), nonce.ptr, InternalUtils.check_arr_len(hmac, 32));
        Reference.reachabilityFence(payment_id);
        Reference.reachabilityFence(nonce);
        Reference.reachabilityFence(hmac);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OffersContext ret_hu_conv = OffersContext.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static OffersContext inbound_payment(byte[] payment_hash, Nonce nonce, byte[] hmac) {
        long ret = bindings.OffersContext_inbound_payment(InternalUtils.check_arr_len(payment_hash, 32), nonce.ptr, InternalUtils.check_arr_len(hmac, 32));
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(nonce);
        Reference.reachabilityFence(hmac);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OffersContext ret_hu_conv = OffersContext.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public boolean eq(OffersContext b) {
        boolean ret = bindings.OffersContext_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OffersContext)) {
            return false;
        }
        return this.eq((OffersContext)o);
    }

    public byte[] write() {
        byte[] ret = bindings.OffersContext_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_OffersContextDecodeErrorZ read(byte[] ser) {
        long ret = bindings.OffersContext_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_OffersContextDecodeErrorZ ret_hu_conv = Result_OffersContextDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static final class InvoiceRequest
    extends OffersContext {
        public final Nonce nonce;

        private InvoiceRequest(long ptr, bindings.LDKOffersContext.InvoiceRequest obj) {
            super(null, ptr);
            long nonce = obj.nonce;
            Nonce nonce_hu_conv = null;
            if (nonce < 0L || nonce > 4096L) {
                nonce_hu_conv = new Nonce(null, nonce);
            }
            if (nonce_hu_conv != null) {
                nonce_hu_conv.ptrs_to.add(this);
            }
            this.nonce = nonce_hu_conv;
        }
    }

    public static final class OutboundPayment
    extends OffersContext {
        public final byte[] payment_id;
        public final Nonce nonce;
        @Nullable
        public final byte[] hmac;

        private OutboundPayment(long ptr, bindings.LDKOffersContext.OutboundPayment obj) {
            super(null, ptr);
            this.payment_id = obj.payment_id;
            long nonce = obj.nonce;
            Nonce nonce_hu_conv = null;
            if (nonce < 0L || nonce > 4096L) {
                nonce_hu_conv = new Nonce(null, nonce);
            }
            if (nonce_hu_conv != null) {
                nonce_hu_conv.ptrs_to.add(this);
            }
            this.nonce = nonce_hu_conv;
            this.hmac = obj.hmac;
        }
    }

    public static final class InboundPayment
    extends OffersContext {
        public final byte[] payment_hash;
        public final Nonce nonce;
        public final byte[] hmac;

        private InboundPayment(long ptr, bindings.LDKOffersContext.InboundPayment obj) {
            super(null, ptr);
            this.payment_hash = obj.payment_hash;
            long nonce = obj.nonce;
            Nonce nonce_hu_conv = null;
            if (nonce < 0L || nonce > 4096L) {
                nonce_hu_conv = new Nonce(null, nonce);
            }
            if (nonce_hu_conv != null) {
                nonce_hu_conv.ptrs_to.add(this);
            }
            this.nonce = nonce_hu_conv;
            this.hmac = obj.hmac;
        }
    }
}

