/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Init;
import org.ldk.structs.InitFeatures;
import org.ldk.structs.NodeFeatures;
import org.ldk.structs.OnionMessage;
import org.ldk.structs.Result_NoneNoneZ;
import org.ldk.util.InternalUtils;

public class OnionMessageHandler
extends CommonBase {
    final bindings.LDKOnionMessageHandler bindings_instance;

    OnionMessageHandler(Object _dummy, long ptr) {
        super(ptr);
        this.bindings_instance = null;
    }

    private OnionMessageHandler(bindings.LDKOnionMessageHandler arg) {
        super(bindings.LDKOnionMessageHandler_new(arg));
        this.ptrs_to.add(arg);
        this.bindings_instance = arg;
    }

    protected void finalize() throws Throwable {
        if (this.ptr != 0L) {
            bindings.OnionMessageHandler_free(this.ptr);
        }
        super.finalize();
    }

    public void destroy() {
        if (this.ptr != 0L) {
            bindings.OnionMessageHandler_free(this.ptr);
        }
        this.ptr = 0L;
    }

    public static OnionMessageHandler new_impl(final OnionMessageHandlerInterface arg) {
        LDKOnionMessageHandlerHolder impl_holder = new LDKOnionMessageHandlerHolder();
        impl_holder.held = new OnionMessageHandler(new bindings.LDKOnionMessageHandler(){

            @Override
            public void handle_onion_message(byte[] peer_node_id, long msg) {
                OnionMessage msg_hu_conv = null;
                if (msg < 0L || msg > 4096L) {
                    msg_hu_conv = new OnionMessage(null, msg);
                }
                arg.handle_onion_message(peer_node_id, msg_hu_conv);
                Reference.reachabilityFence(arg);
            }

            @Override
            public long next_onion_message_for_peer(byte[] peer_node_id) {
                OnionMessage ret = arg.next_onion_message_for_peer(peer_node_id);
                Reference.reachabilityFence(arg);
                long result = ret == null ? 0L : ret.clone_ptr();
                return result;
            }

            @Override
            public long peer_connected(byte[] their_node_id, long init, boolean inbound) {
                Init init_hu_conv = null;
                if (init < 0L || init > 4096L) {
                    init_hu_conv = new Init(null, init);
                }
                Result_NoneNoneZ ret = arg.peer_connected(their_node_id, init_hu_conv, inbound);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public void peer_disconnected(byte[] their_node_id) {
                arg.peer_disconnected(their_node_id);
                Reference.reachabilityFence(arg);
            }

            @Override
            public void timer_tick_occurred() {
                arg.timer_tick_occurred();
                Reference.reachabilityFence(arg);
            }

            @Override
            public long provided_node_features() {
                NodeFeatures ret = arg.provided_node_features();
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long provided_init_features(byte[] their_node_id) {
                InitFeatures ret = arg.provided_init_features(their_node_id);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }
        });
        return impl_holder.held;
    }

    public void handle_onion_message(byte[] peer_node_id, OnionMessage msg) {
        bindings.OnionMessageHandler_handle_onion_message(this.ptr, InternalUtils.check_arr_len(peer_node_id, 33), msg.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(peer_node_id);
        Reference.reachabilityFence(msg);
        if (this != null) {
            this.ptrs_to.add(msg);
        }
    }

    @Nullable
    public OnionMessage next_onion_message_for_peer(byte[] peer_node_id) {
        long ret = bindings.OnionMessageHandler_next_onion_message_for_peer(this.ptr, InternalUtils.check_arr_len(peer_node_id, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(peer_node_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OnionMessage ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new OnionMessage(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Result_NoneNoneZ peer_connected(byte[] their_node_id, Init init, boolean inbound) {
        long ret = bindings.OnionMessageHandler_peer_connected(this.ptr, InternalUtils.check_arr_len(their_node_id, 33), init.ptr, inbound);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(their_node_id);
        Reference.reachabilityFence(init);
        Reference.reachabilityFence(inbound);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneNoneZ ret_hu_conv = Result_NoneNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(init);
        }
        return ret_hu_conv;
    }

    public void peer_disconnected(byte[] their_node_id) {
        bindings.OnionMessageHandler_peer_disconnected(this.ptr, InternalUtils.check_arr_len(their_node_id, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(their_node_id);
    }

    public void timer_tick_occurred() {
        bindings.OnionMessageHandler_timer_tick_occurred(this.ptr);
        Reference.reachabilityFence(this);
    }

    public NodeFeatures provided_node_features() {
        long ret = bindings.OnionMessageHandler_provided_node_features(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        NodeFeatures ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new NodeFeatures(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public InitFeatures provided_init_features(byte[] their_node_id) {
        long ret = bindings.OnionMessageHandler_provided_init_features(this.ptr, InternalUtils.check_arr_len(their_node_id, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(their_node_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        InitFeatures ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new InitFeatures(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    private static class LDKOnionMessageHandlerHolder {
        OnionMessageHandler held;

        private LDKOnionMessageHandlerHolder() {
        }
    }

    public static interface OnionMessageHandlerInterface {
        public void handle_onion_message(byte[] var1, OnionMessage var2);

        public OnionMessage next_onion_message_for_peer(byte[] var1);

        public Result_NoneNoneZ peer_connected(byte[] var1, Init var2, boolean var3);

        public void peer_disconnected(byte[] var1);

        public void timer_tick_occurred();

        public NodeFeatures provided_node_features();

        public InitFeatures provided_init_features(byte[] var1);
    }
}

