/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.AsyncPaymentsMessageHandler;
import org.ldk.structs.CommonBase;
import org.ldk.structs.CustomOnionMessageHandler;
import org.ldk.structs.DNSResolverMessageHandler;
import org.ldk.structs.EntropySource;
import org.ldk.structs.EventsProvider;
import org.ldk.structs.Future;
import org.ldk.structs.Logger;
import org.ldk.structs.MessageRouter;
import org.ldk.structs.MessageSendInstructions;
import org.ldk.structs.NodeIdLookUp;
import org.ldk.structs.NodeSigner;
import org.ldk.structs.OffersMessageHandler;
import org.ldk.structs.OnionMessage;
import org.ldk.structs.OnionMessageContents;
import org.ldk.structs.OnionMessageHandler;
import org.ldk.structs.ResponseInstruction;
import org.ldk.structs.Result_NoneSendErrorZ;
import org.ldk.structs.Result_SendSuccessSendErrorZ;
import org.ldk.util.InternalUtils;

public class OnionMessenger
extends CommonBase {
    OnionMessenger(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.OnionMessenger_free(this.ptr);
        }
    }

    public static OnionMessenger of(EntropySource entropy_source, NodeSigner node_signer, Logger logger, NodeIdLookUp node_id_lookup, MessageRouter message_router, OffersMessageHandler offers_handler, AsyncPaymentsMessageHandler async_payments_handler, DNSResolverMessageHandler dns_resolver, CustomOnionMessageHandler custom_handler) {
        long ret = bindings.OnionMessenger_new(entropy_source.ptr, node_signer.ptr, logger.ptr, node_id_lookup.ptr, message_router.ptr, offers_handler.ptr, async_payments_handler.ptr, dns_resolver.ptr, custom_handler.ptr);
        Reference.reachabilityFence(entropy_source);
        Reference.reachabilityFence(node_signer);
        Reference.reachabilityFence(logger);
        Reference.reachabilityFence(node_id_lookup);
        Reference.reachabilityFence(message_router);
        Reference.reachabilityFence(offers_handler);
        Reference.reachabilityFence(async_payments_handler);
        Reference.reachabilityFence(dns_resolver);
        Reference.reachabilityFence(custom_handler);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OnionMessenger ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new OnionMessenger(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(entropy_source);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(node_signer);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(logger);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(node_id_lookup);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(message_router);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(offers_handler);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(async_payments_handler);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(dns_resolver);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(custom_handler);
        }
        return ret_hu_conv;
    }

    public static OnionMessenger new_with_offline_peer_interception(EntropySource entropy_source, NodeSigner node_signer, Logger logger, NodeIdLookUp node_id_lookup, MessageRouter message_router, OffersMessageHandler offers_handler, AsyncPaymentsMessageHandler async_payments_handler, DNSResolverMessageHandler dns_resolver, CustomOnionMessageHandler custom_handler) {
        long ret = bindings.OnionMessenger_new_with_offline_peer_interception(entropy_source.ptr, node_signer.ptr, logger.ptr, node_id_lookup.ptr, message_router.ptr, offers_handler.ptr, async_payments_handler.ptr, dns_resolver.ptr, custom_handler.ptr);
        Reference.reachabilityFence(entropy_source);
        Reference.reachabilityFence(node_signer);
        Reference.reachabilityFence(logger);
        Reference.reachabilityFence(node_id_lookup);
        Reference.reachabilityFence(message_router);
        Reference.reachabilityFence(offers_handler);
        Reference.reachabilityFence(async_payments_handler);
        Reference.reachabilityFence(dns_resolver);
        Reference.reachabilityFence(custom_handler);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OnionMessenger ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new OnionMessenger(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(entropy_source);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(node_signer);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(logger);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(node_id_lookup);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(message_router);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(offers_handler);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(async_payments_handler);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(dns_resolver);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(custom_handler);
        }
        return ret_hu_conv;
    }

    public Result_SendSuccessSendErrorZ send_onion_message(OnionMessageContents contents, MessageSendInstructions instructions) {
        long ret = bindings.OnionMessenger_send_onion_message(this.ptr, contents.ptr, instructions.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(contents);
        Reference.reachabilityFence(instructions);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_SendSuccessSendErrorZ ret_hu_conv = Result_SendSuccessSendErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(contents);
        }
        return ret_hu_conv;
    }

    public Result_NoneSendErrorZ forward_onion_message(OnionMessage message, byte[] peer_node_id) {
        long ret = bindings.OnionMessenger_forward_onion_message(this.ptr, message.ptr, InternalUtils.check_arr_len(peer_node_id, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(message);
        Reference.reachabilityFence(peer_node_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneSendErrorZ ret_hu_conv = Result_NoneSendErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_SendSuccessSendErrorZ handle_onion_message_response(OnionMessageContents response, ResponseInstruction instructions) {
        long ret = bindings.OnionMessenger_handle_onion_message_response(this.ptr, response.ptr, instructions.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(response);
        Reference.reachabilityFence(instructions);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_SendSuccessSendErrorZ ret_hu_conv = Result_SendSuccessSendErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(response);
        }
        return ret_hu_conv;
    }

    public Future get_update_future() {
        long ret = bindings.OnionMessenger_get_update_future(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Future ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Future(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public EventsProvider as_EventsProvider() {
        long ret = bindings.OnionMessenger_as_EventsProvider(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EventsProvider ret_hu_conv = new EventsProvider(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public OnionMessageHandler as_OnionMessageHandler() {
        long ret = bindings.OnionMessenger_as_OnionMessageHandler(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OnionMessageHandler ret_hu_conv = new OnionMessageHandler(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }
}

