/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Result_OnionPacketDecodeErrorZ;
import org.ldk.structs.Result_PublicKeySecp256k1ErrorZ;
import org.ldk.util.InternalUtils;

public class OnionPacket
extends CommonBase {
    OnionPacket(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.OnionPacket_free(this.ptr);
        }
    }

    public byte get_version() {
        byte ret = bindings.OnionPacket_get_version(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_version(byte val) {
        bindings.OnionPacket_set_version(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Result_PublicKeySecp256k1ErrorZ get_public_key() {
        long ret = bindings.OnionPacket_get_public_key(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_PublicKeySecp256k1ErrorZ ret_hu_conv = Result_PublicKeySecp256k1ErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public void set_public_key(Result_PublicKeySecp256k1ErrorZ val) {
        bindings.OnionPacket_set_public_key(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_hmac() {
        byte[] ret = bindings.OnionPacket_get_hmac(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_hmac(byte[] val) {
        bindings.OnionPacket_set_hmac(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    long clone_ptr() {
        long ret = bindings.OnionPacket_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public OnionPacket clone() {
        long ret = bindings.OnionPacket_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OnionPacket ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new OnionPacket(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.OnionPacket_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean eq(OnionPacket b) {
        boolean ret = bindings.OnionPacket_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OnionPacket)) {
            return false;
        }
        return this.eq((OnionPacket)o);
    }

    public byte[] write() {
        byte[] ret = bindings.OnionPacket_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_OnionPacketDecodeErrorZ read(byte[] ser) {
        long ret = bindings.OnionPacket_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_OnionPacketDecodeErrorZ ret_hu_conv = Result_OnionPacketDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }
}

