/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Option_OutboundHTLCStateDetailsZ;
import org.ldk.structs.Option_u64Z;
import org.ldk.structs.Result_OutboundHTLCDetailsDecodeErrorZ;
import org.ldk.util.InternalUtils;

public class OutboundHTLCDetails
extends CommonBase {
    OutboundHTLCDetails(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.OutboundHTLCDetails_free(this.ptr);
        }
    }

    public Option_u64Z get_htlc_id() {
        long ret = bindings.OutboundHTLCDetails_get_htlc_id(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_htlc_id(Option_u64Z val) {
        bindings.OutboundHTLCDetails_set_htlc_id(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_amount_msat() {
        long ret = bindings.OutboundHTLCDetails_get_amount_msat(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_amount_msat(long val) {
        bindings.OutboundHTLCDetails_set_amount_msat(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public int get_cltv_expiry() {
        int ret = bindings.OutboundHTLCDetails_get_cltv_expiry(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_cltv_expiry(int val) {
        bindings.OutboundHTLCDetails_set_cltv_expiry(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_payment_hash() {
        byte[] ret = bindings.OutboundHTLCDetails_get_payment_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_payment_hash(byte[] val) {
        bindings.OutboundHTLCDetails_set_payment_hash(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_OutboundHTLCStateDetailsZ get_state() {
        long ret = bindings.OutboundHTLCDetails_get_state(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_OutboundHTLCStateDetailsZ ret_hu_conv = Option_OutboundHTLCStateDetailsZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_state(Option_OutboundHTLCStateDetailsZ val) {
        bindings.OutboundHTLCDetails_set_state(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u64Z get_skimmed_fee_msat() {
        long ret = bindings.OutboundHTLCDetails_get_skimmed_fee_msat(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_skimmed_fee_msat(Option_u64Z val) {
        bindings.OutboundHTLCDetails_set_skimmed_fee_msat(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public boolean get_is_dust() {
        boolean ret = bindings.OutboundHTLCDetails_get_is_dust(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_is_dust(boolean val) {
        bindings.OutboundHTLCDetails_set_is_dust(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public static OutboundHTLCDetails of(Option_u64Z htlc_id_arg, long amount_msat_arg, int cltv_expiry_arg, byte[] payment_hash_arg, Option_OutboundHTLCStateDetailsZ state_arg, Option_u64Z skimmed_fee_msat_arg, boolean is_dust_arg) {
        long ret = bindings.OutboundHTLCDetails_new(htlc_id_arg.ptr, amount_msat_arg, cltv_expiry_arg, InternalUtils.check_arr_len(payment_hash_arg, 32), state_arg.ptr, skimmed_fee_msat_arg.ptr, is_dust_arg);
        Reference.reachabilityFence(htlc_id_arg);
        Reference.reachabilityFence(amount_msat_arg);
        Reference.reachabilityFence(cltv_expiry_arg);
        Reference.reachabilityFence(payment_hash_arg);
        Reference.reachabilityFence(state_arg);
        Reference.reachabilityFence(skimmed_fee_msat_arg);
        Reference.reachabilityFence(is_dust_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OutboundHTLCDetails ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new OutboundHTLCDetails(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    long clone_ptr() {
        long ret = bindings.OutboundHTLCDetails_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public OutboundHTLCDetails clone() {
        long ret = bindings.OutboundHTLCDetails_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OutboundHTLCDetails ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new OutboundHTLCDetails(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public byte[] write() {
        byte[] ret = bindings.OutboundHTLCDetails_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_OutboundHTLCDetailsDecodeErrorZ read(byte[] ser) {
        long ret = bindings.OutboundHTLCDetails_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_OutboundHTLCDetailsDecodeErrorZ ret_hu_conv = Result_OutboundHTLCDetailsDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }
}

