/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Option_u32Z;
import org.ldk.structs.Result_OutputSpendStatusDecodeErrorZ;
import org.ldk.util.InternalUtils;

public class OutputSpendStatus
extends CommonBase {
    private OutputSpendStatus(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.OutputSpendStatus_free(this.ptr);
        }
    }

    static OutputSpendStatus constr_from_ptr(long ptr) {
        bindings.LDKOutputSpendStatus raw_val = bindings.LDKOutputSpendStatus_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKOutputSpendStatus.PendingInitialBroadcast.class) {
            return new PendingInitialBroadcast(ptr, (bindings.LDKOutputSpendStatus.PendingInitialBroadcast)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKOutputSpendStatus.PendingFirstConfirmation.class) {
            return new PendingFirstConfirmation(ptr, (bindings.LDKOutputSpendStatus.PendingFirstConfirmation)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKOutputSpendStatus.PendingThresholdConfirmations.class) {
            return new PendingThresholdConfirmations(ptr, (bindings.LDKOutputSpendStatus.PendingThresholdConfirmations)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.OutputSpendStatus_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public OutputSpendStatus clone() {
        long ret = bindings.OutputSpendStatus_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OutputSpendStatus ret_hu_conv = OutputSpendStatus.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static OutputSpendStatus pending_initial_broadcast(Option_u32Z delayed_until_height) {
        long ret = bindings.OutputSpendStatus_pending_initial_broadcast(delayed_until_height.ptr);
        Reference.reachabilityFence(delayed_until_height);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OutputSpendStatus ret_hu_conv = OutputSpendStatus.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static OutputSpendStatus pending_first_confirmation(byte[] first_broadcast_hash, int latest_broadcast_height, byte[] latest_spending_tx) {
        long ret = bindings.OutputSpendStatus_pending_first_confirmation(InternalUtils.check_arr_len(first_broadcast_hash, 32), latest_broadcast_height, latest_spending_tx);
        Reference.reachabilityFence(first_broadcast_hash);
        Reference.reachabilityFence(latest_broadcast_height);
        Reference.reachabilityFence(latest_spending_tx);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OutputSpendStatus ret_hu_conv = OutputSpendStatus.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static OutputSpendStatus pending_threshold_confirmations(byte[] first_broadcast_hash, int latest_broadcast_height, byte[] latest_spending_tx, int confirmation_height, byte[] confirmation_hash) {
        long ret = bindings.OutputSpendStatus_pending_threshold_confirmations(InternalUtils.check_arr_len(first_broadcast_hash, 32), latest_broadcast_height, latest_spending_tx, confirmation_height, InternalUtils.check_arr_len(confirmation_hash, 32));
        Reference.reachabilityFence(first_broadcast_hash);
        Reference.reachabilityFence(latest_broadcast_height);
        Reference.reachabilityFence(latest_spending_tx);
        Reference.reachabilityFence(confirmation_height);
        Reference.reachabilityFence(confirmation_hash);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OutputSpendStatus ret_hu_conv = OutputSpendStatus.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public boolean eq(OutputSpendStatus b) {
        boolean ret = bindings.OutputSpendStatus_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OutputSpendStatus)) {
            return false;
        }
        return this.eq((OutputSpendStatus)o);
    }

    public byte[] write() {
        byte[] ret = bindings.OutputSpendStatus_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_OutputSpendStatusDecodeErrorZ read(byte[] ser) {
        long ret = bindings.OutputSpendStatus_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_OutputSpendStatusDecodeErrorZ ret_hu_conv = Result_OutputSpendStatusDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static final class PendingInitialBroadcast
    extends OutputSpendStatus {
        public final Option_u32Z delayed_until_height;

        private PendingInitialBroadcast(long ptr, bindings.LDKOutputSpendStatus.PendingInitialBroadcast obj) {
            super(null, ptr);
            long delayed_until_height = obj.delayed_until_height;
            Option_u32Z delayed_until_height_hu_conv = Option_u32Z.constr_from_ptr(delayed_until_height);
            if (delayed_until_height_hu_conv != null) {
                delayed_until_height_hu_conv.ptrs_to.add(this);
            }
            this.delayed_until_height = delayed_until_height_hu_conv;
        }
    }

    public static final class PendingFirstConfirmation
    extends OutputSpendStatus {
        public final byte[] first_broadcast_hash;
        public final int latest_broadcast_height;
        public final byte[] latest_spending_tx;

        private PendingFirstConfirmation(long ptr, bindings.LDKOutputSpendStatus.PendingFirstConfirmation obj) {
            super(null, ptr);
            this.first_broadcast_hash = obj.first_broadcast_hash;
            this.latest_broadcast_height = obj.latest_broadcast_height;
            this.latest_spending_tx = obj.latest_spending_tx;
        }
    }

    public static final class PendingThresholdConfirmations
    extends OutputSpendStatus {
        public final byte[] first_broadcast_hash;
        public final int latest_broadcast_height;
        public final byte[] latest_spending_tx;
        public final int confirmation_height;
        public final byte[] confirmation_hash;

        private PendingThresholdConfirmations(long ptr, bindings.LDKOutputSpendStatus.PendingThresholdConfirmations obj) {
            super(null, ptr);
            this.first_broadcast_hash = obj.first_broadcast_hash;
            this.latest_broadcast_height = obj.latest_broadcast_height;
            this.latest_spending_tx = obj.latest_spending_tx;
            this.confirmation_height = obj.confirmation_height;
            this.confirmation_hash = obj.confirmation_hash;
        }
    }
}

