/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.BestBlock;
import org.ldk.structs.BroadcasterInterface;
import org.ldk.structs.ChangeDestinationSource;
import org.ldk.structs.ChannelId;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Confirm;
import org.ldk.structs.FeeEstimator;
import org.ldk.structs.KVStore;
import org.ldk.structs.Listen;
import org.ldk.structs.Logger;
import org.ldk.structs.Option_FilterZ;
import org.ldk.structs.Option_u32Z;
import org.ldk.structs.OutputSpender;
import org.ldk.structs.Result_NoneNoneZ;
import org.ldk.structs.Result_OutputSweeperDecodeErrorZ;
import org.ldk.structs.SpendableOutputDescriptor;
import org.ldk.structs.TrackedSpendableOutput;

public class OutputSweeper
extends CommonBase {
    OutputSweeper(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.OutputSweeper_free(this.ptr);
        }
    }

    public static OutputSweeper of(BestBlock best_block, BroadcasterInterface broadcaster, FeeEstimator fee_estimator, Option_FilterZ chain_data_source, OutputSpender output_spender, ChangeDestinationSource change_destination_source, KVStore kv_store, Logger logger) {
        long ret = bindings.OutputSweeper_new(best_block.ptr, broadcaster.ptr, fee_estimator.ptr, chain_data_source.ptr, output_spender.ptr, change_destination_source.ptr, kv_store.ptr, logger.ptr);
        Reference.reachabilityFence(best_block);
        Reference.reachabilityFence(broadcaster);
        Reference.reachabilityFence(fee_estimator);
        Reference.reachabilityFence(chain_data_source);
        Reference.reachabilityFence(output_spender);
        Reference.reachabilityFence(change_destination_source);
        Reference.reachabilityFence(kv_store);
        Reference.reachabilityFence(logger);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OutputSweeper ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new OutputSweeper(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(broadcaster);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(fee_estimator);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(chain_data_source);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(output_spender);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(change_destination_source);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(kv_store);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(logger);
        }
        return ret_hu_conv;
    }

    public Result_NoneNoneZ track_spendable_outputs(SpendableOutputDescriptor[] output_descriptors, @Nullable ChannelId channel_id, boolean exclude_static_outputs, Option_u32Z delay_until_height) {
        long ret = bindings.OutputSweeper_track_spendable_outputs(this.ptr, output_descriptors != null ? Arrays.stream(output_descriptors).mapToLong(output_descriptors_conv_27 -> output_descriptors_conv_27.ptr).toArray() : null, channel_id == null ? 0L : channel_id.ptr, exclude_static_outputs, delay_until_height.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(output_descriptors);
        Reference.reachabilityFence(channel_id);
        Reference.reachabilityFence(exclude_static_outputs);
        Reference.reachabilityFence(delay_until_height);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneNoneZ ret_hu_conv = Result_NoneNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public TrackedSpendableOutput[] tracked_spendable_outputs() {
        long[] ret = bindings.OutputSweeper_tracked_spendable_outputs(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_24_len = ret.length;
        TrackedSpendableOutput[] ret_conv_24_arr = new TrackedSpendableOutput[ret_conv_24_len];
        for (int y = 0; y < ret_conv_24_len; ++y) {
            long ret_conv_24 = ret[y];
            TrackedSpendableOutput ret_conv_24_hu_conv = null;
            if (ret_conv_24 < 0L || ret_conv_24 > 4096L) {
                ret_conv_24_hu_conv = new TrackedSpendableOutput(null, ret_conv_24);
            }
            if (ret_conv_24_hu_conv != null) {
                ret_conv_24_hu_conv.ptrs_to.add(this);
            }
            ret_conv_24_arr[y] = ret_conv_24_hu_conv;
        }
        return ret_conv_24_arr;
    }

    public BestBlock current_best_block() {
        long ret = bindings.OutputSweeper_current_best_block(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        BestBlock ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new BestBlock(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Listen as_Listen() {
        long ret = bindings.OutputSweeper_as_Listen(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Listen ret_hu_conv = new Listen(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Confirm as_Confirm() {
        long ret = bindings.OutputSweeper_as_Confirm(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Confirm ret_hu_conv = new Confirm(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static Result_OutputSweeperDecodeErrorZ read(byte[] ser, BroadcasterInterface arg_a, FeeEstimator arg_b, Option_FilterZ arg_c, OutputSpender arg_d, ChangeDestinationSource arg_e, KVStore arg_f, Logger arg_g) {
        long ret = bindings.OutputSweeper_read(ser, arg_a.ptr, arg_b.ptr, arg_c.ptr, arg_d.ptr, arg_e.ptr, arg_f.ptr, arg_g.ptr);
        Reference.reachabilityFence(ser);
        Reference.reachabilityFence(arg_a);
        Reference.reachabilityFence(arg_b);
        Reference.reachabilityFence(arg_c);
        Reference.reachabilityFence(arg_d);
        Reference.reachabilityFence(arg_e);
        Reference.reachabilityFence(arg_f);
        Reference.reachabilityFence(arg_g);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_OutputSweeperDecodeErrorZ ret_hu_conv = Result_OutputSweeperDecodeErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_a);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_b);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_c);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_d);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_e);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_f);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_g);
        }
        return ret_hu_conv;
    }
}

