/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.util.InternalUtils;

public class Packet
extends CommonBase {
    Packet(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.Packet_free(this.ptr);
        }
    }

    public byte get_version() {
        byte ret = bindings.Packet_get_version(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_version(byte val) {
        bindings.Packet_set_version(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_public_key() {
        byte[] ret = bindings.Packet_get_public_key(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_public_key(byte[] val) {
        bindings.Packet_set_public_key(this.ptr, InternalUtils.check_arr_len(val, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_hop_data() {
        byte[] ret = bindings.Packet_get_hop_data(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_hop_data(byte[] val) {
        bindings.Packet_set_hop_data(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_hmac() {
        byte[] ret = bindings.Packet_get_hmac(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_hmac(byte[] val) {
        bindings.Packet_set_hmac(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public static Packet of(byte version_arg, byte[] public_key_arg, byte[] hop_data_arg, byte[] hmac_arg) {
        long ret = bindings.Packet_new(version_arg, InternalUtils.check_arr_len(public_key_arg, 33), hop_data_arg, InternalUtils.check_arr_len(hmac_arg, 32));
        Reference.reachabilityFence(version_arg);
        Reference.reachabilityFence(public_key_arg);
        Reference.reachabilityFence(hop_data_arg);
        Reference.reachabilityFence(hmac_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Packet ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Packet(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    long clone_ptr() {
        long ret = bindings.Packet_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public Packet clone() {
        long ret = bindings.Packet_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Packet ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Packet(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.Packet_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean eq(Packet b) {
        boolean ret = bindings.Packet_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Packet)) {
            return false;
        }
        return this.eq((Packet)o);
    }

    public byte[] write() {
        byte[] ret = bindings.Packet_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }
}

