/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.BlindedPaymentPath;
import org.ldk.structs.Bolt11InvoiceFeatures;
import org.ldk.structs.Bolt12InvoiceFeatures;
import org.ldk.structs.CommonBase;
import org.ldk.structs.RouteHint;
import org.ldk.util.InternalUtils;

public class Payee
extends CommonBase {
    private Payee(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.Payee_free(this.ptr);
        }
    }

    static Payee constr_from_ptr(long ptr) {
        bindings.LDKPayee raw_val = bindings.LDKPayee_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKPayee.Blinded.class) {
            return new Blinded(ptr, (bindings.LDKPayee.Blinded)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKPayee.Clear.class) {
            return new Clear(ptr, (bindings.LDKPayee.Clear)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.Payee_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public Payee clone() {
        long ret = bindings.Payee_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Payee ret_hu_conv = Payee.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static Payee blinded(BlindedPaymentPath[] route_hints, Bolt12InvoiceFeatures features) {
        long ret = bindings.Payee_blinded(route_hints != null ? Arrays.stream(route_hints).mapToLong(route_hints_conv_20 -> route_hints_conv_20.ptr).toArray() : null, features.ptr);
        Reference.reachabilityFence(route_hints);
        Reference.reachabilityFence(features);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Payee ret_hu_conv = Payee.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Payee clear(byte[] node_id, RouteHint[] route_hints, Bolt11InvoiceFeatures features, int final_cltv_expiry_delta) {
        long ret = bindings.Payee_clear(InternalUtils.check_arr_len(node_id, 33), route_hints != null ? Arrays.stream(route_hints).mapToLong(route_hints_conv_11 -> route_hints_conv_11.ptr).toArray() : null, features.ptr, final_cltv_expiry_delta);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(route_hints);
        Reference.reachabilityFence(features);
        Reference.reachabilityFence(final_cltv_expiry_delta);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Payee ret_hu_conv = Payee.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.Payee_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean eq(Payee b) {
        boolean ret = bindings.Payee_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Payee)) {
            return false;
        }
        return this.eq((Payee)o);
    }

    public static final class Blinded
    extends Payee {
        public final BlindedPaymentPath[] route_hints;
        @Nullable
        public final Bolt12InvoiceFeatures features;

        private Blinded(long ptr, bindings.LDKPayee.Blinded obj) {
            super(null, ptr);
            long[] route_hints = obj.route_hints;
            int route_hints_conv_20_len = route_hints.length;
            BlindedPaymentPath[] route_hints_conv_20_arr = new BlindedPaymentPath[route_hints_conv_20_len];
            for (int u = 0; u < route_hints_conv_20_len; ++u) {
                long route_hints_conv_20 = route_hints[u];
                BlindedPaymentPath route_hints_conv_20_hu_conv = null;
                if (route_hints_conv_20 < 0L || route_hints_conv_20 > 4096L) {
                    route_hints_conv_20_hu_conv = new BlindedPaymentPath(null, route_hints_conv_20);
                }
                if (route_hints_conv_20_hu_conv != null) {
                    route_hints_conv_20_hu_conv.ptrs_to.add(this);
                }
                route_hints_conv_20_arr[u] = route_hints_conv_20_hu_conv;
            }
            this.route_hints = route_hints_conv_20_arr;
            long features = obj.features;
            Bolt12InvoiceFeatures features_hu_conv = null;
            if (features < 0L || features > 4096L) {
                features_hu_conv = new Bolt12InvoiceFeatures(null, features);
            }
            if (features_hu_conv != null) {
                features_hu_conv.ptrs_to.add(this);
            }
            this.features = features_hu_conv;
        }
    }

    public static final class Clear
    extends Payee {
        public final byte[] node_id;
        public final RouteHint[] route_hints;
        @Nullable
        public final Bolt11InvoiceFeatures features;
        public final int final_cltv_expiry_delta;

        private Clear(long ptr, bindings.LDKPayee.Clear obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long[] route_hints = obj.route_hints;
            int route_hints_conv_11_len = route_hints.length;
            RouteHint[] route_hints_conv_11_arr = new RouteHint[route_hints_conv_11_len];
            for (int l = 0; l < route_hints_conv_11_len; ++l) {
                long route_hints_conv_11 = route_hints[l];
                RouteHint route_hints_conv_11_hu_conv = null;
                if (route_hints_conv_11 < 0L || route_hints_conv_11 > 4096L) {
                    route_hints_conv_11_hu_conv = new RouteHint(null, route_hints_conv_11);
                }
                if (route_hints_conv_11_hu_conv != null) {
                    route_hints_conv_11_hu_conv.ptrs_to.add(this);
                }
                route_hints_conv_11_arr[l] = route_hints_conv_11_hu_conv;
            }
            this.route_hints = route_hints_conv_11_arr;
            long features = obj.features;
            Bolt11InvoiceFeatures features_hu_conv = null;
            if (features < 0L || features > 4096L) {
                features_hu_conv = new Bolt11InvoiceFeatures(null, features);
            }
            if (features_hu_conv != null) {
                features_hu_conv.ptrs_to.add(this);
            }
            this.features = features_hu_conv;
            this.final_cltv_expiry_delta = obj.final_cltv_expiry_delta;
        }
    }
}

