/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import org.ldk.impl.bindings;
import org.ldk.structs.BlindedPaymentPath;
import org.ldk.structs.Bolt12Invoice;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Option_u64Z;
import org.ldk.structs.Payee;
import org.ldk.structs.Result_PaymentParametersDecodeErrorZ;
import org.ldk.util.InternalUtils;

public class PaymentParameters
extends CommonBase {
    PaymentParameters(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.PaymentParameters_free(this.ptr);
        }
    }

    public Payee get_payee() {
        long ret = bindings.PaymentParameters_get_payee(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Payee ret_hu_conv = Payee.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_payee(Payee val) {
        bindings.PaymentParameters_set_payee(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u64Z get_expiry_time() {
        long ret = bindings.PaymentParameters_get_expiry_time(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_expiry_time(Option_u64Z val) {
        bindings.PaymentParameters_set_expiry_time(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public int get_max_total_cltv_expiry_delta() {
        int ret = bindings.PaymentParameters_get_max_total_cltv_expiry_delta(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_max_total_cltv_expiry_delta(int val) {
        bindings.PaymentParameters_set_max_total_cltv_expiry_delta(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte get_max_path_count() {
        byte ret = bindings.PaymentParameters_get_max_path_count(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_max_path_count(byte val) {
        bindings.PaymentParameters_set_max_path_count(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte get_max_path_length() {
        byte ret = bindings.PaymentParameters_get_max_path_length(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_max_path_length(byte val) {
        bindings.PaymentParameters_set_max_path_length(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte get_max_channel_saturation_power_of_half() {
        byte ret = bindings.PaymentParameters_get_max_channel_saturation_power_of_half(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_max_channel_saturation_power_of_half(byte val) {
        bindings.PaymentParameters_set_max_channel_saturation_power_of_half(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long[] get_previously_failed_channels() {
        long[] ret = bindings.PaymentParameters_get_previously_failed_channels(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_previously_failed_channels(long[] val) {
        bindings.PaymentParameters_set_previously_failed_channels(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long[] get_previously_failed_blinded_path_idxs() {
        long[] ret = bindings.PaymentParameters_get_previously_failed_blinded_path_idxs(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_previously_failed_blinded_path_idxs(long[] val) {
        bindings.PaymentParameters_set_previously_failed_blinded_path_idxs(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public static PaymentParameters of(Payee payee_arg, Option_u64Z expiry_time_arg, int max_total_cltv_expiry_delta_arg, byte max_path_count_arg, byte max_path_length_arg, byte max_channel_saturation_power_of_half_arg, long[] previously_failed_channels_arg, long[] previously_failed_blinded_path_idxs_arg) {
        long ret = bindings.PaymentParameters_new(payee_arg.ptr, expiry_time_arg.ptr, max_total_cltv_expiry_delta_arg, max_path_count_arg, max_path_length_arg, max_channel_saturation_power_of_half_arg, previously_failed_channels_arg, previously_failed_blinded_path_idxs_arg);
        Reference.reachabilityFence(payee_arg);
        Reference.reachabilityFence(expiry_time_arg);
        Reference.reachabilityFence(max_total_cltv_expiry_delta_arg);
        Reference.reachabilityFence(max_path_count_arg);
        Reference.reachabilityFence(max_path_length_arg);
        Reference.reachabilityFence(max_channel_saturation_power_of_half_arg);
        Reference.reachabilityFence(previously_failed_channels_arg);
        Reference.reachabilityFence(previously_failed_blinded_path_idxs_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PaymentParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new PaymentParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    long clone_ptr() {
        long ret = bindings.PaymentParameters_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public PaymentParameters clone() {
        long ret = bindings.PaymentParameters_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PaymentParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new PaymentParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.PaymentParameters_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean eq(PaymentParameters b) {
        boolean ret = bindings.PaymentParameters_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PaymentParameters)) {
            return false;
        }
        return this.eq((PaymentParameters)o);
    }

    public byte[] write() {
        byte[] ret = bindings.PaymentParameters_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_PaymentParametersDecodeErrorZ read(byte[] ser, int arg) {
        long ret = bindings.PaymentParameters_read(ser, arg);
        Reference.reachabilityFence(ser);
        Reference.reachabilityFence(arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_PaymentParametersDecodeErrorZ ret_hu_conv = Result_PaymentParametersDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static PaymentParameters from_node_id(byte[] payee_pubkey, int final_cltv_expiry_delta) {
        long ret = bindings.PaymentParameters_from_node_id(InternalUtils.check_arr_len(payee_pubkey, 33), final_cltv_expiry_delta);
        Reference.reachabilityFence(payee_pubkey);
        Reference.reachabilityFence(final_cltv_expiry_delta);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PaymentParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new PaymentParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static PaymentParameters for_keysend(byte[] payee_pubkey, int final_cltv_expiry_delta, boolean allow_mpp) {
        long ret = bindings.PaymentParameters_for_keysend(InternalUtils.check_arr_len(payee_pubkey, 33), final_cltv_expiry_delta, allow_mpp);
        Reference.reachabilityFence(payee_pubkey);
        Reference.reachabilityFence(final_cltv_expiry_delta);
        Reference.reachabilityFence(allow_mpp);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PaymentParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new PaymentParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static PaymentParameters from_bolt12_invoice(Bolt12Invoice invoice) {
        long ret = bindings.PaymentParameters_from_bolt12_invoice(invoice.ptr);
        Reference.reachabilityFence(invoice);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PaymentParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new PaymentParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(invoice);
        }
        return ret_hu_conv;
    }

    public static PaymentParameters blinded(BlindedPaymentPath[] blinded_route_hints) {
        long ret = bindings.PaymentParameters_blinded(blinded_route_hints != null ? Arrays.stream(blinded_route_hints).mapToLong(blinded_route_hints_conv_20 -> blinded_route_hints_conv_20.ptr).toArray() : null);
        Reference.reachabilityFence(blinded_route_hints);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PaymentParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new PaymentParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }
}

