/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.Bolt12OfferContext;
import org.ldk.structs.Bolt12RefundContext;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Option_ThirtyTwoBytesZ;
import org.ldk.structs.Result_PaymentPurposeDecodeErrorZ;
import org.ldk.util.InternalUtils;

public class PaymentPurpose
extends CommonBase {
    private PaymentPurpose(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.PaymentPurpose_free(this.ptr);
        }
    }

    static PaymentPurpose constr_from_ptr(long ptr) {
        bindings.LDKPaymentPurpose raw_val = bindings.LDKPaymentPurpose_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKPaymentPurpose.Bolt11InvoicePayment.class) {
            return new Bolt11InvoicePayment(ptr, (bindings.LDKPaymentPurpose.Bolt11InvoicePayment)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKPaymentPurpose.Bolt12OfferPayment.class) {
            return new Bolt12OfferPayment(ptr, (bindings.LDKPaymentPurpose.Bolt12OfferPayment)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKPaymentPurpose.Bolt12RefundPayment.class) {
            return new Bolt12RefundPayment(ptr, (bindings.LDKPaymentPurpose.Bolt12RefundPayment)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKPaymentPurpose.SpontaneousPayment.class) {
            return new SpontaneousPayment(ptr, (bindings.LDKPaymentPurpose.SpontaneousPayment)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.PaymentPurpose_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public PaymentPurpose clone() {
        long ret = bindings.PaymentPurpose_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PaymentPurpose ret_hu_conv = PaymentPurpose.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static PaymentPurpose bolt11_invoice_payment(Option_ThirtyTwoBytesZ payment_preimage, byte[] payment_secret) {
        long ret = bindings.PaymentPurpose_bolt11_invoice_payment(payment_preimage.ptr, InternalUtils.check_arr_len(payment_secret, 32));
        Reference.reachabilityFence(payment_preimage);
        Reference.reachabilityFence(payment_secret);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PaymentPurpose ret_hu_conv = PaymentPurpose.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static PaymentPurpose bolt12_offer_payment(Option_ThirtyTwoBytesZ payment_preimage, byte[] payment_secret, Bolt12OfferContext payment_context) {
        long ret = bindings.PaymentPurpose_bolt12_offer_payment(payment_preimage.ptr, InternalUtils.check_arr_len(payment_secret, 32), payment_context.ptr);
        Reference.reachabilityFence(payment_preimage);
        Reference.reachabilityFence(payment_secret);
        Reference.reachabilityFence(payment_context);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PaymentPurpose ret_hu_conv = PaymentPurpose.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static PaymentPurpose bolt12_refund_payment(Option_ThirtyTwoBytesZ payment_preimage, byte[] payment_secret, Bolt12RefundContext payment_context) {
        long ret = bindings.PaymentPurpose_bolt12_refund_payment(payment_preimage.ptr, InternalUtils.check_arr_len(payment_secret, 32), payment_context.ptr);
        Reference.reachabilityFence(payment_preimage);
        Reference.reachabilityFence(payment_secret);
        Reference.reachabilityFence(payment_context);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PaymentPurpose ret_hu_conv = PaymentPurpose.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static PaymentPurpose spontaneous_payment(byte[] a) {
        long ret = bindings.PaymentPurpose_spontaneous_payment(InternalUtils.check_arr_len(a, 32));
        Reference.reachabilityFence(a);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PaymentPurpose ret_hu_conv = PaymentPurpose.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public boolean eq(PaymentPurpose b) {
        boolean ret = bindings.PaymentPurpose_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PaymentPurpose)) {
            return false;
        }
        return this.eq((PaymentPurpose)o);
    }

    public Option_ThirtyTwoBytesZ preimage() {
        long ret = bindings.PaymentPurpose_preimage(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_ThirtyTwoBytesZ ret_hu_conv = Option_ThirtyTwoBytesZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public byte[] write() {
        byte[] ret = bindings.PaymentPurpose_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_PaymentPurposeDecodeErrorZ read(byte[] ser) {
        long ret = bindings.PaymentPurpose_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_PaymentPurposeDecodeErrorZ ret_hu_conv = Result_PaymentPurposeDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static final class Bolt11InvoicePayment
    extends PaymentPurpose {
        public final Option_ThirtyTwoBytesZ payment_preimage;
        public final byte[] payment_secret;

        private Bolt11InvoicePayment(long ptr, bindings.LDKPaymentPurpose.Bolt11InvoicePayment obj) {
            super(null, ptr);
            long payment_preimage = obj.payment_preimage;
            Option_ThirtyTwoBytesZ payment_preimage_hu_conv = Option_ThirtyTwoBytesZ.constr_from_ptr(payment_preimage);
            if (payment_preimage_hu_conv != null) {
                payment_preimage_hu_conv.ptrs_to.add(this);
            }
            this.payment_preimage = payment_preimage_hu_conv;
            this.payment_secret = obj.payment_secret;
        }
    }

    public static final class Bolt12OfferPayment
    extends PaymentPurpose {
        public final Option_ThirtyTwoBytesZ payment_preimage;
        public final byte[] payment_secret;
        public final Bolt12OfferContext payment_context;

        private Bolt12OfferPayment(long ptr, bindings.LDKPaymentPurpose.Bolt12OfferPayment obj) {
            super(null, ptr);
            long payment_preimage = obj.payment_preimage;
            Option_ThirtyTwoBytesZ payment_preimage_hu_conv = Option_ThirtyTwoBytesZ.constr_from_ptr(payment_preimage);
            if (payment_preimage_hu_conv != null) {
                payment_preimage_hu_conv.ptrs_to.add(this);
            }
            this.payment_preimage = payment_preimage_hu_conv;
            this.payment_secret = obj.payment_secret;
            long payment_context = obj.payment_context;
            Bolt12OfferContext payment_context_hu_conv = null;
            if (payment_context < 0L || payment_context > 4096L) {
                payment_context_hu_conv = new Bolt12OfferContext(null, payment_context);
            }
            if (payment_context_hu_conv != null) {
                payment_context_hu_conv.ptrs_to.add(this);
            }
            this.payment_context = payment_context_hu_conv;
        }
    }

    public static final class Bolt12RefundPayment
    extends PaymentPurpose {
        public final Option_ThirtyTwoBytesZ payment_preimage;
        public final byte[] payment_secret;
        public final Bolt12RefundContext payment_context;

        private Bolt12RefundPayment(long ptr, bindings.LDKPaymentPurpose.Bolt12RefundPayment obj) {
            super(null, ptr);
            long payment_preimage = obj.payment_preimage;
            Option_ThirtyTwoBytesZ payment_preimage_hu_conv = Option_ThirtyTwoBytesZ.constr_from_ptr(payment_preimage);
            if (payment_preimage_hu_conv != null) {
                payment_preimage_hu_conv.ptrs_to.add(this);
            }
            this.payment_preimage = payment_preimage_hu_conv;
            this.payment_secret = obj.payment_secret;
            long payment_context = obj.payment_context;
            Bolt12RefundContext payment_context_hu_conv = null;
            if (payment_context < 0L || payment_context > 4096L) {
                payment_context_hu_conv = new Bolt12RefundContext(null, payment_context);
            }
            if (payment_context_hu_conv != null) {
                payment_context_hu_conv.ptrs_to.add(this);
            }
            this.payment_context = payment_context_hu_conv;
        }
    }

    public static final class SpontaneousPayment
    extends PaymentPurpose {
        public final byte[] spontaneous_payment;

        private SpontaneousPayment(long ptr, bindings.LDKPaymentPurpose.SpontaneousPayment obj) {
            super(null, ptr);
            this.spontaneous_payment = obj.spontaneous_payment;
        }
    }
}

