/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.ChannelMessageHandler;
import org.ldk.structs.CommonBase;
import org.ldk.structs.CustomMessageHandler;
import org.ldk.structs.Logger;
import org.ldk.structs.NodeSigner;
import org.ldk.structs.OnionMessageHandler;
import org.ldk.structs.Option_SocketAddressZ;
import org.ldk.structs.PeerDetails;
import org.ldk.structs.Result_CVec_u8ZPeerHandleErrorZ;
import org.ldk.structs.Result_NonePeerHandleErrorZ;
import org.ldk.structs.Result_boolPeerHandleErrorZ;
import org.ldk.structs.RoutingMessageHandler;
import org.ldk.structs.SocketAddress;
import org.ldk.structs.SocketDescriptor;
import org.ldk.util.InternalUtils;

public class PeerManager
extends CommonBase {
    PeerManager(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.PeerManager_free(this.ptr);
        }
    }

    public static PeerManager of(ChannelMessageHandler message_handler_chan_handler_arg, RoutingMessageHandler message_handler_route_handler_arg, OnionMessageHandler message_handler_onion_message_handler_arg, CustomMessageHandler message_handler_custom_message_handler_arg, int current_time, byte[] ephemeral_random_data, Logger logger, NodeSigner node_signer) {
        long ret = bindings.PeerManager_new(bindings.MessageHandler_new(message_handler_chan_handler_arg.ptr, message_handler_route_handler_arg.ptr, message_handler_onion_message_handler_arg.ptr, message_handler_custom_message_handler_arg.ptr), current_time, InternalUtils.check_arr_len(ephemeral_random_data, 32), logger.ptr, node_signer.ptr);
        Reference.reachabilityFence(message_handler_chan_handler_arg);
        Reference.reachabilityFence(message_handler_route_handler_arg);
        Reference.reachabilityFence(message_handler_onion_message_handler_arg);
        Reference.reachabilityFence(message_handler_custom_message_handler_arg);
        Reference.reachabilityFence(current_time);
        Reference.reachabilityFence(ephemeral_random_data);
        Reference.reachabilityFence(logger);
        Reference.reachabilityFence(node_signer);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PeerManager ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new PeerManager(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(message_handler_chan_handler_arg);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(message_handler_route_handler_arg);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(message_handler_onion_message_handler_arg);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(message_handler_custom_message_handler_arg);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(logger);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(node_signer);
        }
        return ret_hu_conv;
    }

    public PeerDetails[] list_peers() {
        long[] ret = bindings.PeerManager_list_peers(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_13_len = ret.length;
        PeerDetails[] ret_conv_13_arr = new PeerDetails[ret_conv_13_len];
        for (int n = 0; n < ret_conv_13_len; ++n) {
            long ret_conv_13 = ret[n];
            PeerDetails ret_conv_13_hu_conv = null;
            if (ret_conv_13 < 0L || ret_conv_13 > 4096L) {
                ret_conv_13_hu_conv = new PeerDetails(null, ret_conv_13);
            }
            if (ret_conv_13_hu_conv != null) {
                ret_conv_13_hu_conv.ptrs_to.add(this);
            }
            ret_conv_13_arr[n] = ret_conv_13_hu_conv;
        }
        return ret_conv_13_arr;
    }

    @Nullable
    public PeerDetails peer_by_node_id(byte[] their_node_id) {
        long ret = bindings.PeerManager_peer_by_node_id(this.ptr, InternalUtils.check_arr_len(their_node_id, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(their_node_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PeerDetails ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new PeerDetails(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Result_CVec_u8ZPeerHandleErrorZ new_outbound_connection(byte[] their_node_id, SocketDescriptor descriptor, Option_SocketAddressZ remote_network_address) {
        long ret = bindings.PeerManager_new_outbound_connection(this.ptr, InternalUtils.check_arr_len(their_node_id, 33), descriptor.ptr, remote_network_address.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(their_node_id);
        Reference.reachabilityFence(descriptor);
        Reference.reachabilityFence(remote_network_address);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_CVec_u8ZPeerHandleErrorZ ret_hu_conv = Result_CVec_u8ZPeerHandleErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(descriptor);
        }
        return ret_hu_conv;
    }

    public Result_NonePeerHandleErrorZ new_inbound_connection(SocketDescriptor descriptor, Option_SocketAddressZ remote_network_address) {
        long ret = bindings.PeerManager_new_inbound_connection(this.ptr, descriptor.ptr, remote_network_address.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(descriptor);
        Reference.reachabilityFence(remote_network_address);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NonePeerHandleErrorZ ret_hu_conv = Result_NonePeerHandleErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(descriptor);
        }
        return ret_hu_conv;
    }

    public Result_NonePeerHandleErrorZ write_buffer_space_avail(SocketDescriptor descriptor) {
        long ret = bindings.PeerManager_write_buffer_space_avail(this.ptr, descriptor.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(descriptor);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NonePeerHandleErrorZ ret_hu_conv = Result_NonePeerHandleErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_boolPeerHandleErrorZ read_event(SocketDescriptor peer_descriptor, byte[] data) {
        long ret = bindings.PeerManager_read_event(this.ptr, peer_descriptor.ptr, data);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(peer_descriptor);
        Reference.reachabilityFence(data);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_boolPeerHandleErrorZ ret_hu_conv = Result_boolPeerHandleErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public void process_events() {
        bindings.PeerManager_process_events(this.ptr);
        Reference.reachabilityFence(this);
    }

    public void socket_disconnected(SocketDescriptor descriptor) {
        bindings.PeerManager_socket_disconnected(this.ptr, descriptor.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(descriptor);
    }

    public void disconnect_by_node_id(byte[] node_id) {
        bindings.PeerManager_disconnect_by_node_id(this.ptr, InternalUtils.check_arr_len(node_id, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(node_id);
    }

    public void disconnect_all_peers() {
        bindings.PeerManager_disconnect_all_peers(this.ptr);
        Reference.reachabilityFence(this);
    }

    public void timer_tick_occurred() {
        bindings.PeerManager_timer_tick_occurred(this.ptr);
        Reference.reachabilityFence(this);
    }

    public void broadcast_node_announcement(byte[] rgb, byte[] alias, SocketAddress[] addresses) {
        bindings.PeerManager_broadcast_node_announcement(this.ptr, InternalUtils.check_arr_len(rgb, 3), InternalUtils.check_arr_len(alias, 32), addresses != null ? Arrays.stream(addresses).mapToLong(addresses_conv_15 -> addresses_conv_15.ptr).toArray() : null);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(rgb);
        Reference.reachabilityFence(alias);
        Reference.reachabilityFence(addresses);
    }
}

