/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Option_u64Z;
import org.ldk.structs.PendingHTLCRouting;
import org.ldk.structs.Result_PendingHTLCInfoDecodeErrorZ;
import org.ldk.util.InternalUtils;

public class PendingHTLCInfo
extends CommonBase {
    PendingHTLCInfo(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.PendingHTLCInfo_free(this.ptr);
        }
    }

    public PendingHTLCRouting get_routing() {
        long ret = bindings.PendingHTLCInfo_get_routing(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PendingHTLCRouting ret_hu_conv = PendingHTLCRouting.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_routing(PendingHTLCRouting val) {
        bindings.PendingHTLCInfo_set_routing(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_incoming_shared_secret() {
        byte[] ret = bindings.PendingHTLCInfo_get_incoming_shared_secret(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_incoming_shared_secret(byte[] val) {
        bindings.PendingHTLCInfo_set_incoming_shared_secret(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_payment_hash() {
        byte[] ret = bindings.PendingHTLCInfo_get_payment_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_payment_hash(byte[] val) {
        bindings.PendingHTLCInfo_set_payment_hash(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u64Z get_incoming_amt_msat() {
        long ret = bindings.PendingHTLCInfo_get_incoming_amt_msat(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_incoming_amt_msat(Option_u64Z val) {
        bindings.PendingHTLCInfo_set_incoming_amt_msat(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_outgoing_amt_msat() {
        long ret = bindings.PendingHTLCInfo_get_outgoing_amt_msat(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_outgoing_amt_msat(long val) {
        bindings.PendingHTLCInfo_set_outgoing_amt_msat(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public int get_outgoing_cltv_value() {
        int ret = bindings.PendingHTLCInfo_get_outgoing_cltv_value(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_outgoing_cltv_value(int val) {
        bindings.PendingHTLCInfo_set_outgoing_cltv_value(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u64Z get_skimmed_fee_msat() {
        long ret = bindings.PendingHTLCInfo_get_skimmed_fee_msat(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_skimmed_fee_msat(Option_u64Z val) {
        bindings.PendingHTLCInfo_set_skimmed_fee_msat(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public static PendingHTLCInfo of(PendingHTLCRouting routing_arg, byte[] incoming_shared_secret_arg, byte[] payment_hash_arg, Option_u64Z incoming_amt_msat_arg, long outgoing_amt_msat_arg, int outgoing_cltv_value_arg, Option_u64Z skimmed_fee_msat_arg) {
        long ret = bindings.PendingHTLCInfo_new(routing_arg.ptr, InternalUtils.check_arr_len(incoming_shared_secret_arg, 32), InternalUtils.check_arr_len(payment_hash_arg, 32), incoming_amt_msat_arg.ptr, outgoing_amt_msat_arg, outgoing_cltv_value_arg, skimmed_fee_msat_arg.ptr);
        Reference.reachabilityFence(routing_arg);
        Reference.reachabilityFence(incoming_shared_secret_arg);
        Reference.reachabilityFence(payment_hash_arg);
        Reference.reachabilityFence(incoming_amt_msat_arg);
        Reference.reachabilityFence(outgoing_amt_msat_arg);
        Reference.reachabilityFence(outgoing_cltv_value_arg);
        Reference.reachabilityFence(skimmed_fee_msat_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PendingHTLCInfo ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new PendingHTLCInfo(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    long clone_ptr() {
        long ret = bindings.PendingHTLCInfo_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public PendingHTLCInfo clone() {
        long ret = bindings.PendingHTLCInfo_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PendingHTLCInfo ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new PendingHTLCInfo(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public byte[] write() {
        byte[] ret = bindings.PendingHTLCInfo_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_PendingHTLCInfoDecodeErrorZ read(byte[] ser) {
        long ret = bindings.PendingHTLCInfo_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_PendingHTLCInfoDecodeErrorZ ret_hu_conv = Result_PendingHTLCInfoDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }
}

