/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.BlindedForward;
import org.ldk.structs.CommonBase;
import org.ldk.structs.FinalOnionHopData;
import org.ldk.structs.OnionPacket;
import org.ldk.structs.Option_CVec_u8ZZ;
import org.ldk.structs.Option_PaymentContextZ;
import org.ldk.structs.Option_u32Z;
import org.ldk.structs.Result_PendingHTLCRoutingDecodeErrorZ;
import org.ldk.structs.TwoTuple_u64CVec_u8ZZ;
import org.ldk.util.InternalUtils;

public class PendingHTLCRouting
extends CommonBase {
    private PendingHTLCRouting(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.PendingHTLCRouting_free(this.ptr);
        }
    }

    static PendingHTLCRouting constr_from_ptr(long ptr) {
        bindings.LDKPendingHTLCRouting raw_val = bindings.LDKPendingHTLCRouting_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKPendingHTLCRouting.Forward.class) {
            return new Forward(ptr, (bindings.LDKPendingHTLCRouting.Forward)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKPendingHTLCRouting.Receive.class) {
            return new Receive(ptr, (bindings.LDKPendingHTLCRouting.Receive)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKPendingHTLCRouting.ReceiveKeysend.class) {
            return new ReceiveKeysend(ptr, (bindings.LDKPendingHTLCRouting.ReceiveKeysend)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.PendingHTLCRouting_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public PendingHTLCRouting clone() {
        long ret = bindings.PendingHTLCRouting_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PendingHTLCRouting ret_hu_conv = PendingHTLCRouting.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static PendingHTLCRouting forward(OnionPacket onion_packet, long short_channel_id, BlindedForward blinded, Option_u32Z incoming_cltv_expiry) {
        long ret = bindings.PendingHTLCRouting_forward(onion_packet.ptr, short_channel_id, blinded.ptr, incoming_cltv_expiry.ptr);
        Reference.reachabilityFence(onion_packet);
        Reference.reachabilityFence(short_channel_id);
        Reference.reachabilityFence(blinded);
        Reference.reachabilityFence(incoming_cltv_expiry);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PendingHTLCRouting ret_hu_conv = PendingHTLCRouting.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static PendingHTLCRouting receive(FinalOnionHopData payment_data, Option_CVec_u8ZZ payment_metadata, Option_PaymentContextZ payment_context, int incoming_cltv_expiry, byte[] phantom_shared_secret, TwoTuple_u64CVec_u8ZZ[] custom_tlvs, boolean requires_blinded_error) {
        long ret = bindings.PendingHTLCRouting_receive(payment_data.ptr, payment_metadata.ptr, payment_context.ptr, incoming_cltv_expiry, InternalUtils.check_arr_len(phantom_shared_secret, 32), custom_tlvs != null ? Arrays.stream(custom_tlvs).mapToLong(custom_tlvs_conv_23 -> custom_tlvs_conv_23.ptr).toArray() : null, requires_blinded_error);
        Reference.reachabilityFence(payment_data);
        Reference.reachabilityFence(payment_metadata);
        Reference.reachabilityFence(payment_context);
        Reference.reachabilityFence(incoming_cltv_expiry);
        Reference.reachabilityFence(phantom_shared_secret);
        Reference.reachabilityFence(custom_tlvs);
        Reference.reachabilityFence(requires_blinded_error);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PendingHTLCRouting ret_hu_conv = PendingHTLCRouting.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static PendingHTLCRouting receive_keysend(FinalOnionHopData payment_data, byte[] payment_preimage, Option_CVec_u8ZZ payment_metadata, int incoming_cltv_expiry, TwoTuple_u64CVec_u8ZZ[] custom_tlvs, boolean requires_blinded_error, boolean has_recipient_created_payment_secret) {
        long ret = bindings.PendingHTLCRouting_receive_keysend(payment_data.ptr, InternalUtils.check_arr_len(payment_preimage, 32), payment_metadata.ptr, incoming_cltv_expiry, custom_tlvs != null ? Arrays.stream(custom_tlvs).mapToLong(custom_tlvs_conv_23 -> custom_tlvs_conv_23.ptr).toArray() : null, requires_blinded_error, has_recipient_created_payment_secret);
        Reference.reachabilityFence(payment_data);
        Reference.reachabilityFence(payment_preimage);
        Reference.reachabilityFence(payment_metadata);
        Reference.reachabilityFence(incoming_cltv_expiry);
        Reference.reachabilityFence(custom_tlvs);
        Reference.reachabilityFence(requires_blinded_error);
        Reference.reachabilityFence(has_recipient_created_payment_secret);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PendingHTLCRouting ret_hu_conv = PendingHTLCRouting.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public byte[] write() {
        byte[] ret = bindings.PendingHTLCRouting_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_PendingHTLCRoutingDecodeErrorZ read(byte[] ser) {
        long ret = bindings.PendingHTLCRouting_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_PendingHTLCRoutingDecodeErrorZ ret_hu_conv = Result_PendingHTLCRoutingDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static final class Forward
    extends PendingHTLCRouting {
        public final OnionPacket onion_packet;
        public final long short_channel_id;
        @Nullable
        public final BlindedForward blinded;
        public final Option_u32Z incoming_cltv_expiry;

        private Forward(long ptr, bindings.LDKPendingHTLCRouting.Forward obj) {
            super(null, ptr);
            long onion_packet = obj.onion_packet;
            OnionPacket onion_packet_hu_conv = null;
            if (onion_packet < 0L || onion_packet > 4096L) {
                onion_packet_hu_conv = new OnionPacket(null, onion_packet);
            }
            if (onion_packet_hu_conv != null) {
                onion_packet_hu_conv.ptrs_to.add(this);
            }
            this.onion_packet = onion_packet_hu_conv;
            this.short_channel_id = obj.short_channel_id;
            long blinded = obj.blinded;
            BlindedForward blinded_hu_conv = null;
            if (blinded < 0L || blinded > 4096L) {
                blinded_hu_conv = new BlindedForward(null, blinded);
            }
            if (blinded_hu_conv != null) {
                blinded_hu_conv.ptrs_to.add(this);
            }
            this.blinded = blinded_hu_conv;
            long incoming_cltv_expiry = obj.incoming_cltv_expiry;
            Option_u32Z incoming_cltv_expiry_hu_conv = Option_u32Z.constr_from_ptr(incoming_cltv_expiry);
            if (incoming_cltv_expiry_hu_conv != null) {
                incoming_cltv_expiry_hu_conv.ptrs_to.add(this);
            }
            this.incoming_cltv_expiry = incoming_cltv_expiry_hu_conv;
        }
    }

    public static final class Receive
    extends PendingHTLCRouting {
        public final FinalOnionHopData payment_data;
        public final Option_CVec_u8ZZ payment_metadata;
        public final Option_PaymentContextZ payment_context;
        public final int incoming_cltv_expiry;
        @Nullable
        public final byte[] phantom_shared_secret;
        public final TwoTuple_u64CVec_u8ZZ[] custom_tlvs;
        public final boolean requires_blinded_error;

        private Receive(long ptr, bindings.LDKPendingHTLCRouting.Receive obj) {
            super(null, ptr);
            long payment_data = obj.payment_data;
            FinalOnionHopData payment_data_hu_conv = null;
            if (payment_data < 0L || payment_data > 4096L) {
                payment_data_hu_conv = new FinalOnionHopData(null, payment_data);
            }
            if (payment_data_hu_conv != null) {
                payment_data_hu_conv.ptrs_to.add(this);
            }
            this.payment_data = payment_data_hu_conv;
            long payment_metadata = obj.payment_metadata;
            Option_CVec_u8ZZ payment_metadata_hu_conv = Option_CVec_u8ZZ.constr_from_ptr(payment_metadata);
            if (payment_metadata_hu_conv != null) {
                payment_metadata_hu_conv.ptrs_to.add(this);
            }
            this.payment_metadata = payment_metadata_hu_conv;
            long payment_context = obj.payment_context;
            Option_PaymentContextZ payment_context_hu_conv = Option_PaymentContextZ.constr_from_ptr(payment_context);
            if (payment_context_hu_conv != null) {
                payment_context_hu_conv.ptrs_to.add(this);
            }
            this.payment_context = payment_context_hu_conv;
            this.incoming_cltv_expiry = obj.incoming_cltv_expiry;
            this.phantom_shared_secret = obj.phantom_shared_secret;
            long[] custom_tlvs = obj.custom_tlvs;
            int custom_tlvs_conv_23_len = custom_tlvs.length;
            TwoTuple_u64CVec_u8ZZ[] custom_tlvs_conv_23_arr = new TwoTuple_u64CVec_u8ZZ[custom_tlvs_conv_23_len];
            for (int x = 0; x < custom_tlvs_conv_23_len; ++x) {
                long custom_tlvs_conv_23 = custom_tlvs[x];
                TwoTuple_u64CVec_u8ZZ custom_tlvs_conv_23_hu_conv = new TwoTuple_u64CVec_u8ZZ(null, custom_tlvs_conv_23);
                if (custom_tlvs_conv_23_hu_conv != null) {
                    custom_tlvs_conv_23_hu_conv.ptrs_to.add(this);
                }
                custom_tlvs_conv_23_arr[x] = custom_tlvs_conv_23_hu_conv;
            }
            this.custom_tlvs = custom_tlvs_conv_23_arr;
            this.requires_blinded_error = obj.requires_blinded_error;
        }
    }

    public static final class ReceiveKeysend
    extends PendingHTLCRouting {
        @Nullable
        public final FinalOnionHopData payment_data;
        public final byte[] payment_preimage;
        public final Option_CVec_u8ZZ payment_metadata;
        public final int incoming_cltv_expiry;
        public final TwoTuple_u64CVec_u8ZZ[] custom_tlvs;
        public final boolean requires_blinded_error;
        public final boolean has_recipient_created_payment_secret;

        private ReceiveKeysend(long ptr, bindings.LDKPendingHTLCRouting.ReceiveKeysend obj) {
            super(null, ptr);
            long payment_data = obj.payment_data;
            FinalOnionHopData payment_data_hu_conv = null;
            if (payment_data < 0L || payment_data > 4096L) {
                payment_data_hu_conv = new FinalOnionHopData(null, payment_data);
            }
            if (payment_data_hu_conv != null) {
                payment_data_hu_conv.ptrs_to.add(this);
            }
            this.payment_data = payment_data_hu_conv;
            this.payment_preimage = obj.payment_preimage;
            long payment_metadata = obj.payment_metadata;
            Option_CVec_u8ZZ payment_metadata_hu_conv = Option_CVec_u8ZZ.constr_from_ptr(payment_metadata);
            if (payment_metadata_hu_conv != null) {
                payment_metadata_hu_conv.ptrs_to.add(this);
            }
            this.payment_metadata = payment_metadata_hu_conv;
            this.incoming_cltv_expiry = obj.incoming_cltv_expiry;
            long[] custom_tlvs = obj.custom_tlvs;
            int custom_tlvs_conv_23_len = custom_tlvs.length;
            TwoTuple_u64CVec_u8ZZ[] custom_tlvs_conv_23_arr = new TwoTuple_u64CVec_u8ZZ[custom_tlvs_conv_23_len];
            for (int x = 0; x < custom_tlvs_conv_23_len; ++x) {
                long custom_tlvs_conv_23 = custom_tlvs[x];
                TwoTuple_u64CVec_u8ZZ custom_tlvs_conv_23_hu_conv = new TwoTuple_u64CVec_u8ZZ(null, custom_tlvs_conv_23);
                if (custom_tlvs_conv_23_hu_conv != null) {
                    custom_tlvs_conv_23_hu_conv.ptrs_to.add(this);
                }
                custom_tlvs_conv_23_arr[x] = custom_tlvs_conv_23_hu_conv;
            }
            this.custom_tlvs = custom_tlvs_conv_23_arr;
            this.requires_blinded_error = obj.requires_blinded_error;
            this.has_recipient_created_payment_secret = obj.has_recipient_created_payment_secret;
        }
    }
}

