/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.EntropySource;
import org.ldk.structs.InMemorySigner;
import org.ldk.structs.NodeSigner;
import org.ldk.structs.OutputSpender;
import org.ldk.structs.SignerProvider;
import org.ldk.util.InternalUtils;

public class PhantomKeysManager
extends CommonBase {
    PhantomKeysManager(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.PhantomKeysManager_free(this.ptr);
        }
    }

    public EntropySource as_EntropySource() {
        long ret = bindings.PhantomKeysManager_as_EntropySource(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EntropySource ret_hu_conv = new EntropySource(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public NodeSigner as_NodeSigner() {
        long ret = bindings.PhantomKeysManager_as_NodeSigner(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        NodeSigner ret_hu_conv = new NodeSigner(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public OutputSpender as_OutputSpender() {
        long ret = bindings.PhantomKeysManager_as_OutputSpender(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OutputSpender ret_hu_conv = new OutputSpender(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public SignerProvider as_SignerProvider() {
        long ret = bindings.PhantomKeysManager_as_SignerProvider(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SignerProvider ret_hu_conv = new SignerProvider(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static PhantomKeysManager of(byte[] seed, long starting_time_secs, int starting_time_nanos, byte[] cross_node_seed) {
        long ret = bindings.PhantomKeysManager_new(InternalUtils.check_arr_len(seed, 32), starting_time_secs, starting_time_nanos, InternalUtils.check_arr_len(cross_node_seed, 32));
        Reference.reachabilityFence(seed);
        Reference.reachabilityFence(starting_time_secs);
        Reference.reachabilityFence(starting_time_nanos);
        Reference.reachabilityFence(cross_node_seed);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PhantomKeysManager ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new PhantomKeysManager(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public InMemorySigner derive_channel_keys(long channel_value_satoshis, byte[] params) {
        long ret = bindings.PhantomKeysManager_derive_channel_keys(this.ptr, channel_value_satoshis, InternalUtils.check_arr_len(params, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(channel_value_satoshis);
        Reference.reachabilityFence(params);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        InMemorySigner ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new InMemorySigner(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public byte[] get_node_secret_key() {
        byte[] ret = bindings.PhantomKeysManager_get_node_secret_key(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public byte[] get_phantom_node_secret_key() {
        byte[] ret = bindings.PhantomKeysManager_get_phantom_node_secret_key(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }
}

