/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Logger;
import org.ldk.structs.NetworkGraph;
import org.ldk.structs.NodeId;
import org.ldk.structs.Option_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ;
import org.ldk.structs.Option_C2Tuple_u64u64ZZ;
import org.ldk.structs.Option_f64Z;
import org.ldk.structs.ProbabilisticScoringDecayParameters;
import org.ldk.structs.ProbabilisticScoringFeeParameters;
import org.ldk.structs.Result_ProbabilisticScorerDecodeErrorZ;
import org.ldk.structs.Score;
import org.ldk.structs.ScoreLookUp;
import org.ldk.structs.ScoreUpdate;

public class ProbabilisticScorer
extends CommonBase {
    ProbabilisticScorer(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.ProbabilisticScorer_free(this.ptr);
        }
    }

    public static ProbabilisticScorer of(ProbabilisticScoringDecayParameters decay_params, NetworkGraph network_graph, Logger logger) {
        long ret = bindings.ProbabilisticScorer_new(decay_params.ptr, network_graph.ptr, logger.ptr);
        Reference.reachabilityFence(decay_params);
        Reference.reachabilityFence(network_graph);
        Reference.reachabilityFence(logger);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ProbabilisticScorer ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ProbabilisticScorer(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(network_graph);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(logger);
        }
        return ret_hu_conv;
    }

    public void debug_log_liquidity_stats() {
        bindings.ProbabilisticScorer_debug_log_liquidity_stats(this.ptr);
        Reference.reachabilityFence(this);
    }

    public Option_C2Tuple_u64u64ZZ estimated_channel_liquidity_range(long scid, NodeId target) {
        long ret = bindings.ProbabilisticScorer_estimated_channel_liquidity_range(this.ptr, scid, target.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(scid);
        Reference.reachabilityFence(target);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_C2Tuple_u64u64ZZ ret_hu_conv = Option_C2Tuple_u64u64ZZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        if (this != null) {
            this.ptrs_to.add(target);
        }
        return ret_hu_conv;
    }

    public Option_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ historical_estimated_channel_liquidity_probabilities(long scid, NodeId target) {
        long ret = bindings.ProbabilisticScorer_historical_estimated_channel_liquidity_probabilities(this.ptr, scid, target.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(scid);
        Reference.reachabilityFence(target);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ ret_hu_conv = Option_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        if (this != null) {
            this.ptrs_to.add(target);
        }
        return ret_hu_conv;
    }

    public Option_f64Z historical_estimated_payment_success_probability(long scid, NodeId target, long amount_msat, ProbabilisticScoringFeeParameters params, boolean allow_fallback_estimation) {
        long ret = bindings.ProbabilisticScorer_historical_estimated_payment_success_probability(this.ptr, scid, target.ptr, amount_msat, params.ptr, allow_fallback_estimation);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(scid);
        Reference.reachabilityFence(target);
        Reference.reachabilityFence(amount_msat);
        Reference.reachabilityFence(params);
        Reference.reachabilityFence(allow_fallback_estimation);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_f64Z ret_hu_conv = Option_f64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        if (this != null) {
            this.ptrs_to.add(target);
        }
        if (this != null) {
            this.ptrs_to.add(params);
        }
        return ret_hu_conv;
    }

    public Option_f64Z live_estimated_payment_success_probability(long scid, NodeId target, long amount_msat, ProbabilisticScoringFeeParameters params) {
        long ret = bindings.ProbabilisticScorer_live_estimated_payment_success_probability(this.ptr, scid, target.ptr, amount_msat, params.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(scid);
        Reference.reachabilityFence(target);
        Reference.reachabilityFence(amount_msat);
        Reference.reachabilityFence(params);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_f64Z ret_hu_conv = Option_f64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        if (this != null) {
            this.ptrs_to.add(target);
        }
        if (this != null) {
            this.ptrs_to.add(params);
        }
        return ret_hu_conv;
    }

    public ScoreLookUp as_ScoreLookUp() {
        long ret = bindings.ProbabilisticScorer_as_ScoreLookUp(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ScoreLookUp ret_hu_conv = new ScoreLookUp(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public ScoreUpdate as_ScoreUpdate() {
        long ret = bindings.ProbabilisticScorer_as_ScoreUpdate(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ScoreUpdate ret_hu_conv = new ScoreUpdate(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Score as_Score() {
        long ret = bindings.ProbabilisticScorer_as_Score(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Score ret_hu_conv = new Score(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public byte[] write() {
        byte[] ret = bindings.ProbabilisticScorer_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_ProbabilisticScorerDecodeErrorZ read(byte[] ser, ProbabilisticScoringDecayParameters arg_a, NetworkGraph arg_b, Logger arg_c) {
        long ret = bindings.ProbabilisticScorer_read(ser, arg_a.ptr, arg_b.ptr, arg_c.ptr);
        Reference.reachabilityFence(ser);
        Reference.reachabilityFence(arg_a);
        Reference.reachabilityFence(arg_b);
        Reference.reachabilityFence(arg_c);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ProbabilisticScorerDecodeErrorZ ret_hu_conv = Result_ProbabilisticScorerDecodeErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_b);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_c);
        }
        return ret_hu_conv;
    }
}

