/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import javax.annotation.Nullable;
import org.ldk.enums.Currency;
import org.ldk.impl.bindings;
import org.ldk.structs.Bolt11InvoiceFeatures;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Description;
import org.ldk.structs.ExpiryTime;
import org.ldk.structs.MinFinalCltvExpiryDelta;
import org.ldk.structs.Option_CVec_u8ZZ;
import org.ldk.structs.Option_ThirtyTwoBytesZ;
import org.ldk.structs.Option_u64Z;
import org.ldk.structs.PayeePubKey;
import org.ldk.structs.PrivateRoute;
import org.ldk.structs.RawDataPart;
import org.ldk.structs.Sha256;

public class RawBolt11Invoice
extends CommonBase {
    RawBolt11Invoice(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.RawBolt11Invoice_free(this.ptr);
        }
    }

    public RawDataPart get_data() {
        long ret = bindings.RawBolt11Invoice_get_data(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        RawDataPart ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new RawDataPart(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_data(RawDataPart val) {
        bindings.RawBolt11Invoice_set_data(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public boolean eq(RawBolt11Invoice b) {
        boolean ret = bindings.RawBolt11Invoice_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RawBolt11Invoice)) {
            return false;
        }
        return this.eq((RawBolt11Invoice)o);
    }

    long clone_ptr() {
        long ret = bindings.RawBolt11Invoice_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public RawBolt11Invoice clone() {
        long ret = bindings.RawBolt11Invoice_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        RawBolt11Invoice ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new RawBolt11Invoice(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.RawBolt11Invoice_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public byte[] signable_hash() {
        byte[] ret = bindings.RawBolt11Invoice_signable_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    @Nullable
    public Sha256 payment_hash() {
        long ret = bindings.RawBolt11Invoice_payment_hash(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Sha256 ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Sha256(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    @Nullable
    public Description description() {
        long ret = bindings.RawBolt11Invoice_description(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Description ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Description(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    @Nullable
    public PayeePubKey payee_pub_key() {
        long ret = bindings.RawBolt11Invoice_payee_pub_key(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PayeePubKey ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new PayeePubKey(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    @Nullable
    public Sha256 description_hash() {
        long ret = bindings.RawBolt11Invoice_description_hash(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Sha256 ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Sha256(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    @Nullable
    public ExpiryTime expiry_time() {
        long ret = bindings.RawBolt11Invoice_expiry_time(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ExpiryTime ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ExpiryTime(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    @Nullable
    public MinFinalCltvExpiryDelta min_final_cltv_expiry_delta() {
        long ret = bindings.RawBolt11Invoice_min_final_cltv_expiry_delta(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MinFinalCltvExpiryDelta ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new MinFinalCltvExpiryDelta(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Option_ThirtyTwoBytesZ payment_secret() {
        long ret = bindings.RawBolt11Invoice_payment_secret(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_ThirtyTwoBytesZ ret_hu_conv = Option_ThirtyTwoBytesZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Option_CVec_u8ZZ payment_metadata() {
        long ret = bindings.RawBolt11Invoice_payment_metadata(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_CVec_u8ZZ ret_hu_conv = Option_CVec_u8ZZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    @Nullable
    public Bolt11InvoiceFeatures features() {
        long ret = bindings.RawBolt11Invoice_features(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Bolt11InvoiceFeatures ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Bolt11InvoiceFeatures(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public PrivateRoute[] private_routes() {
        long[] ret = bindings.RawBolt11Invoice_private_routes(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_14_len = ret.length;
        PrivateRoute[] ret_conv_14_arr = new PrivateRoute[ret_conv_14_len];
        for (int o = 0; o < ret_conv_14_len; ++o) {
            long ret_conv_14 = ret[o];
            PrivateRoute ret_conv_14_hu_conv = null;
            if (ret_conv_14 < 0L || ret_conv_14 > 4096L) {
                ret_conv_14_hu_conv = new PrivateRoute(null, ret_conv_14);
            }
            if (ret_conv_14_hu_conv != null) {
                ret_conv_14_hu_conv.ptrs_to.add(this);
            }
            ret_conv_14_arr[o] = ret_conv_14_hu_conv;
        }
        return ret_conv_14_arr;
    }

    public Option_u64Z amount_pico_btc() {
        long ret = bindings.RawBolt11Invoice_amount_pico_btc(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Currency currency() {
        Currency ret = bindings.RawBolt11Invoice_currency(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }
}

