/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.ChannelInfo;
import org.ldk.structs.CommonBase;
import org.ldk.structs.NodeId;
import org.ldk.structs.NodeInfo;
import org.ldk.structs.Option_CVec_SocketAddressZZ;
import org.ldk.util.InternalUtils;

public class ReadOnlyNetworkGraph
extends CommonBase
implements AutoCloseable {
    ReadOnlyNetworkGraph(Object _dummy, long ptr) {
        super(ptr);
    }

    @Override
    public void close() {
        if (this.ptr != 0L) {
            bindings.ReadOnlyNetworkGraph_free(this.ptr);
        }
    }

    @Nullable
    public ChannelInfo channel(long short_channel_id) {
        long ret = bindings.ReadOnlyNetworkGraph_channel(this.ptr, short_channel_id);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(short_channel_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelInfo ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelInfo(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public long[] list_channels() {
        long[] ret = bindings.ReadOnlyNetworkGraph_list_channels(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    @Nullable
    public NodeInfo node(NodeId node_id) {
        long ret = bindings.ReadOnlyNetworkGraph_node(this.ptr, node_id.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(node_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        NodeInfo ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new NodeInfo(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        if (this != null) {
            this.ptrs_to.add(node_id);
        }
        return ret_hu_conv;
    }

    public NodeId[] list_nodes() {
        long[] ret = bindings.ReadOnlyNetworkGraph_list_nodes(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_8_len = ret.length;
        NodeId[] ret_conv_8_arr = new NodeId[ret_conv_8_len];
        for (int i = 0; i < ret_conv_8_len; ++i) {
            long ret_conv_8 = ret[i];
            NodeId ret_conv_8_hu_conv = null;
            if (ret_conv_8 < 0L || ret_conv_8 > 4096L) {
                ret_conv_8_hu_conv = new NodeId(null, ret_conv_8);
            }
            if (ret_conv_8_hu_conv != null) {
                ret_conv_8_hu_conv.ptrs_to.add(this);
            }
            ret_conv_8_arr[i] = ret_conv_8_hu_conv;
        }
        return ret_conv_8_arr;
    }

    public Option_CVec_SocketAddressZZ get_addresses(byte[] pubkey) {
        long ret = bindings.ReadOnlyNetworkGraph_get_addresses(this.ptr, InternalUtils.check_arr_len(pubkey, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(pubkey);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_CVec_SocketAddressZZ ret_hu_conv = Option_CVec_SocketAddressZZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }
}

