/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Option_u64Z;
import org.ldk.structs.PaymentParameters;
import org.ldk.structs.RecipientOnionFields;
import org.ldk.structs.Result_NoneNoneZ;
import org.ldk.structs.Result_RouteParametersDecodeErrorZ;

public class RouteParameters
extends CommonBase {
    RouteParameters(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.RouteParameters_free(this.ptr);
        }
    }

    public PaymentParameters get_payment_params() {
        long ret = bindings.RouteParameters_get_payment_params(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PaymentParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new PaymentParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_payment_params(PaymentParameters val) {
        bindings.RouteParameters_set_payment_params(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_final_value_msat() {
        long ret = bindings.RouteParameters_get_final_value_msat(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_final_value_msat(long val) {
        bindings.RouteParameters_set_final_value_msat(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u64Z get_max_total_routing_fee_msat() {
        long ret = bindings.RouteParameters_get_max_total_routing_fee_msat(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_max_total_routing_fee_msat(Option_u64Z val) {
        bindings.RouteParameters_set_max_total_routing_fee_msat(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public static RouteParameters of(PaymentParameters payment_params_arg, long final_value_msat_arg, Option_u64Z max_total_routing_fee_msat_arg) {
        long ret = bindings.RouteParameters_new(payment_params_arg.ptr, final_value_msat_arg, max_total_routing_fee_msat_arg.ptr);
        Reference.reachabilityFence(payment_params_arg);
        Reference.reachabilityFence(final_value_msat_arg);
        Reference.reachabilityFence(max_total_routing_fee_msat_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        RouteParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new RouteParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    long clone_ptr() {
        long ret = bindings.RouteParameters_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public RouteParameters clone() {
        long ret = bindings.RouteParameters_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        RouteParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new RouteParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.RouteParameters_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean eq(RouteParameters b) {
        boolean ret = bindings.RouteParameters_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RouteParameters)) {
            return false;
        }
        return this.eq((RouteParameters)o);
    }

    public static RouteParameters from_payment_params_and_value(PaymentParameters payment_params, long final_value_msat) {
        long ret = bindings.RouteParameters_from_payment_params_and_value(payment_params.ptr, final_value_msat);
        Reference.reachabilityFence(payment_params);
        Reference.reachabilityFence(final_value_msat);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        RouteParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new RouteParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public Result_NoneNoneZ set_max_path_length(RecipientOnionFields recipient_onion, boolean is_keysend, int best_block_height) {
        long ret = bindings.RouteParameters_set_max_path_length(this.ptr, recipient_onion.ptr, is_keysend, best_block_height);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(recipient_onion);
        Reference.reachabilityFence(is_keysend);
        Reference.reachabilityFence(best_block_height);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneNoneZ ret_hu_conv = Result_NoneNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(recipient_onion);
        }
        return ret_hu_conv;
    }

    public byte[] write() {
        byte[] ret = bindings.RouteParameters_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_RouteParametersDecodeErrorZ read(byte[] ser) {
        long ret = bindings.RouteParameters_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_RouteParametersDecodeErrorZ ret_hu_conv = Result_RouteParametersDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }
}

