/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.enums.Secp256k1Error;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.util.InternalUtils;

public class SendError
extends CommonBase {
    private SendError(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.SendError_free(this.ptr);
        }
    }

    static SendError constr_from_ptr(long ptr) {
        bindings.LDKSendError raw_val = bindings.LDKSendError_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKSendError.Secp256k1.class) {
            return new Secp256k1(ptr, (bindings.LDKSendError.Secp256k1)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSendError.TooBigPacket.class) {
            return new TooBigPacket(ptr, (bindings.LDKSendError.TooBigPacket)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSendError.TooFewBlindedHops.class) {
            return new TooFewBlindedHops(ptr, (bindings.LDKSendError.TooFewBlindedHops)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSendError.InvalidFirstHop.class) {
            return new InvalidFirstHop(ptr, (bindings.LDKSendError.InvalidFirstHop)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSendError.PathNotFound.class) {
            return new PathNotFound(ptr, (bindings.LDKSendError.PathNotFound)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSendError.InvalidMessage.class) {
            return new InvalidMessage(ptr, (bindings.LDKSendError.InvalidMessage)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSendError.BufferFull.class) {
            return new BufferFull(ptr, (bindings.LDKSendError.BufferFull)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSendError.GetNodeIdFailed.class) {
            return new GetNodeIdFailed(ptr, (bindings.LDKSendError.GetNodeIdFailed)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSendError.UnresolvedIntroductionNode.class) {
            return new UnresolvedIntroductionNode(ptr, (bindings.LDKSendError.UnresolvedIntroductionNode)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSendError.BlindedPathAdvanceFailed.class) {
            return new BlindedPathAdvanceFailed(ptr, (bindings.LDKSendError.BlindedPathAdvanceFailed)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.SendError_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public SendError clone() {
        long ret = bindings.SendError_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SendError ret_hu_conv = SendError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static SendError secp256k1(Secp256k1Error a) {
        long ret = bindings.SendError_secp256k1(a);
        Reference.reachabilityFence((Object)a);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SendError ret_hu_conv = SendError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SendError too_big_packet() {
        long ret = bindings.SendError_too_big_packet();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SendError ret_hu_conv = SendError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SendError too_few_blinded_hops() {
        long ret = bindings.SendError_too_few_blinded_hops();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SendError ret_hu_conv = SendError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SendError invalid_first_hop(byte[] a) {
        long ret = bindings.SendError_invalid_first_hop(InternalUtils.check_arr_len(a, 33));
        Reference.reachabilityFence(a);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SendError ret_hu_conv = SendError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SendError path_not_found() {
        long ret = bindings.SendError_path_not_found();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SendError ret_hu_conv = SendError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SendError invalid_message() {
        long ret = bindings.SendError_invalid_message();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SendError ret_hu_conv = SendError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SendError buffer_full() {
        long ret = bindings.SendError_buffer_full();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SendError ret_hu_conv = SendError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SendError get_node_id_failed() {
        long ret = bindings.SendError_get_node_id_failed();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SendError ret_hu_conv = SendError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SendError unresolved_introduction_node() {
        long ret = bindings.SendError_unresolved_introduction_node();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SendError ret_hu_conv = SendError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SendError blinded_path_advance_failed() {
        long ret = bindings.SendError_blinded_path_advance_failed();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SendError ret_hu_conv = SendError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.SendError_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean eq(SendError b) {
        boolean ret = bindings.SendError_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SendError)) {
            return false;
        }
        return this.eq((SendError)o);
    }

    public static final class Secp256k1
    extends SendError {
        public final Secp256k1Error secp256k1;

        private Secp256k1(long ptr, bindings.LDKSendError.Secp256k1 obj) {
            super(null, ptr);
            this.secp256k1 = obj.secp256k1;
        }
    }

    public static final class TooBigPacket
    extends SendError {
        private TooBigPacket(long ptr, bindings.LDKSendError.TooBigPacket obj) {
            super(null, ptr);
        }
    }

    public static final class TooFewBlindedHops
    extends SendError {
        private TooFewBlindedHops(long ptr, bindings.LDKSendError.TooFewBlindedHops obj) {
            super(null, ptr);
        }
    }

    public static final class InvalidFirstHop
    extends SendError {
        public final byte[] invalid_first_hop;

        private InvalidFirstHop(long ptr, bindings.LDKSendError.InvalidFirstHop obj) {
            super(null, ptr);
            this.invalid_first_hop = obj.invalid_first_hop;
        }
    }

    public static final class PathNotFound
    extends SendError {
        private PathNotFound(long ptr, bindings.LDKSendError.PathNotFound obj) {
            super(null, ptr);
        }
    }

    public static final class InvalidMessage
    extends SendError {
        private InvalidMessage(long ptr, bindings.LDKSendError.InvalidMessage obj) {
            super(null, ptr);
        }
    }

    public static final class BufferFull
    extends SendError {
        private BufferFull(long ptr, bindings.LDKSendError.BufferFull obj) {
            super(null, ptr);
        }
    }

    public static final class GetNodeIdFailed
    extends SendError {
        private GetNodeIdFailed(long ptr, bindings.LDKSendError.GetNodeIdFailed obj) {
            super(null, ptr);
        }
    }

    public static final class UnresolvedIntroductionNode
    extends SendError {
        private UnresolvedIntroductionNode(long ptr, bindings.LDKSendError.UnresolvedIntroductionNode obj) {
            super(null, ptr);
        }
    }

    public static final class BlindedPathAdvanceFailed
    extends SendError {
        private BlindedPathAdvanceFailed(long ptr, bindings.LDKSendError.BlindedPathAdvanceFailed obj) {
            super(null, ptr);
        }
    }
}

