/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.util.InternalUtils;

public class Sha256
extends CommonBase {
    Sha256(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.Sha256_free(this.ptr);
        }
    }

    long clone_ptr() {
        long ret = bindings.Sha256_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public Sha256 clone() {
        long ret = bindings.Sha256_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Sha256 ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Sha256(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.Sha256_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean eq(Sha256 b) {
        boolean ret = bindings.Sha256_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Sha256)) {
            return false;
        }
        return this.eq((Sha256)o);
    }

    public static Sha256 from_bytes(byte[] bytes) {
        long ret = bindings.Sha256_from_bytes(InternalUtils.check_arr_len(bytes, 32));
        Reference.reachabilityFence(bytes);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Sha256 ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Sha256(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }
}

