/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.EcdsaChannelSigner;
import org.ldk.structs.Result_CVec_u8ZNoneZ;
import org.ldk.structs.Result_EcdsaChannelSignerDecodeErrorZ;
import org.ldk.structs.Result_ShutdownScriptNoneZ;
import org.ldk.util.InternalUtils;
import org.ldk.util.UInt128;

public class SignerProvider
extends CommonBase {
    final bindings.LDKSignerProvider bindings_instance;

    SignerProvider(Object _dummy, long ptr) {
        super(ptr);
        this.bindings_instance = null;
    }

    private SignerProvider(bindings.LDKSignerProvider arg) {
        super(bindings.LDKSignerProvider_new(arg));
        this.ptrs_to.add(arg);
        this.bindings_instance = arg;
    }

    protected void finalize() throws Throwable {
        if (this.ptr != 0L) {
            bindings.SignerProvider_free(this.ptr);
        }
        super.finalize();
    }

    public void destroy() {
        if (this.ptr != 0L) {
            bindings.SignerProvider_free(this.ptr);
        }
        this.ptr = 0L;
    }

    public static SignerProvider new_impl(final SignerProviderInterface arg) {
        final LDKSignerProviderHolder impl_holder = new LDKSignerProviderHolder();
        impl_holder.held = new SignerProvider(new bindings.LDKSignerProvider(){

            @Override
            public byte[] generate_channel_keys_id(boolean inbound, long channel_value_satoshis, byte[] user_channel_id) {
                UInt128 user_channel_id_conv = new UInt128(user_channel_id);
                byte[] ret = arg.generate_channel_keys_id(inbound, channel_value_satoshis, user_channel_id_conv);
                Reference.reachabilityFence(arg);
                byte[] result = InternalUtils.check_arr_len(ret, 32);
                return result;
            }

            @Override
            public long derive_channel_signer(long channel_value_satoshis, byte[] channel_keys_id) {
                EcdsaChannelSigner ret = arg.derive_channel_signer(channel_value_satoshis, channel_keys_id);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                if (impl_holder.held != null) {
                    impl_holder.held.ptrs_to.add(ret);
                }
                return result;
            }

            @Override
            public long read_chan_signer(byte[] reader) {
                Result_EcdsaChannelSignerDecodeErrorZ ret = arg.read_chan_signer(reader);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long get_destination_script(byte[] channel_keys_id) {
                Result_CVec_u8ZNoneZ ret = arg.get_destination_script(channel_keys_id);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long get_shutdown_scriptpubkey() {
                Result_ShutdownScriptNoneZ ret = arg.get_shutdown_scriptpubkey();
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }
        });
        return impl_holder.held;
    }

    public byte[] generate_channel_keys_id(boolean inbound, long channel_value_satoshis, UInt128 user_channel_id) {
        byte[] ret = bindings.SignerProvider_generate_channel_keys_id(this.ptr, inbound, channel_value_satoshis, user_channel_id.getLEBytes());
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(inbound);
        Reference.reachabilityFence(channel_value_satoshis);
        Reference.reachabilityFence(user_channel_id);
        return ret;
    }

    public EcdsaChannelSigner derive_channel_signer(long channel_value_satoshis, byte[] channel_keys_id) {
        long ret = bindings.SignerProvider_derive_channel_signer(this.ptr, channel_value_satoshis, InternalUtils.check_arr_len(channel_keys_id, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(channel_value_satoshis);
        Reference.reachabilityFence(channel_keys_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EcdsaChannelSigner ret_hu_conv = new EcdsaChannelSigner(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Result_EcdsaChannelSignerDecodeErrorZ read_chan_signer(byte[] reader) {
        long ret = bindings.SignerProvider_read_chan_signer(this.ptr, reader);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(reader);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_EcdsaChannelSignerDecodeErrorZ ret_hu_conv = Result_EcdsaChannelSignerDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_CVec_u8ZNoneZ get_destination_script(byte[] channel_keys_id) {
        long ret = bindings.SignerProvider_get_destination_script(this.ptr, InternalUtils.check_arr_len(channel_keys_id, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(channel_keys_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_CVec_u8ZNoneZ ret_hu_conv = Result_CVec_u8ZNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_ShutdownScriptNoneZ get_shutdown_scriptpubkey() {
        long ret = bindings.SignerProvider_get_shutdown_scriptpubkey(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ShutdownScriptNoneZ ret_hu_conv = Result_ShutdownScriptNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    private static class LDKSignerProviderHolder {
        SignerProvider held;

        private LDKSignerProviderHolder() {
        }
    }

    public static interface SignerProviderInterface {
        public byte[] generate_channel_keys_id(boolean var1, long var2, UInt128 var4);

        public EcdsaChannelSigner derive_channel_signer(long var1, byte[] var3);

        public Result_EcdsaChannelSignerDecodeErrorZ read_chan_signer(byte[] var1);

        public Result_CVec_u8ZNoneZ get_destination_script(byte[] var1);

        public Result_ShutdownScriptNoneZ get_shutdown_scriptpubkey();
    }
}

