/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Result_SocketAddressDecodeErrorZ;
import org.ldk.structs.Result_SocketAddressSocketAddressParseErrorZ;
import org.ldk.util.InternalUtils;

public class SocketAddress
extends CommonBase {
    private SocketAddress(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.SocketAddress_free(this.ptr);
        }
    }

    static SocketAddress constr_from_ptr(long ptr) {
        bindings.LDKSocketAddress raw_val = bindings.LDKSocketAddress_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKSocketAddress.TcpIpV4.class) {
            return new TcpIpV4(ptr, (bindings.LDKSocketAddress.TcpIpV4)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSocketAddress.TcpIpV6.class) {
            return new TcpIpV6(ptr, (bindings.LDKSocketAddress.TcpIpV6)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSocketAddress.OnionV2.class) {
            return new OnionV2(ptr, (bindings.LDKSocketAddress.OnionV2)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSocketAddress.OnionV3.class) {
            return new OnionV3(ptr, (bindings.LDKSocketAddress.OnionV3)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSocketAddress.Hostname.class) {
            return new Hostname(ptr, (bindings.LDKSocketAddress.Hostname)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.SocketAddress_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public SocketAddress clone() {
        long ret = bindings.SocketAddress_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SocketAddress ret_hu_conv = SocketAddress.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static SocketAddress tcp_ip_v4(byte[] addr, short port) {
        long ret = bindings.SocketAddress_tcp_ip_v4(InternalUtils.check_arr_len(addr, 4), port);
        Reference.reachabilityFence(addr);
        Reference.reachabilityFence(port);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SocketAddress ret_hu_conv = SocketAddress.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SocketAddress tcp_ip_v6(byte[] addr, short port) {
        long ret = bindings.SocketAddress_tcp_ip_v6(InternalUtils.check_arr_len(addr, 16), port);
        Reference.reachabilityFence(addr);
        Reference.reachabilityFence(port);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SocketAddress ret_hu_conv = SocketAddress.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SocketAddress onion_v2(byte[] a) {
        long ret = bindings.SocketAddress_onion_v2(InternalUtils.check_arr_len(a, 12));
        Reference.reachabilityFence(a);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SocketAddress ret_hu_conv = SocketAddress.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SocketAddress onion_v3(byte[] ed25519_pubkey, short checksum, byte version2, short port) {
        long ret = bindings.SocketAddress_onion_v3(InternalUtils.check_arr_len(ed25519_pubkey, 32), checksum, version2, port);
        Reference.reachabilityFence(ed25519_pubkey);
        Reference.reachabilityFence(checksum);
        Reference.reachabilityFence(version2);
        Reference.reachabilityFence(port);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SocketAddress ret_hu_conv = SocketAddress.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SocketAddress hostname(org.ldk.structs.Hostname hostname, short port) {
        long ret = bindings.SocketAddress_hostname(hostname.ptr, port);
        Reference.reachabilityFence(hostname);
        Reference.reachabilityFence(port);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SocketAddress ret_hu_conv = SocketAddress.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.SocketAddress_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean eq(SocketAddress b) {
        boolean ret = bindings.SocketAddress_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SocketAddress)) {
            return false;
        }
        return this.eq((SocketAddress)o);
    }

    public byte[] write() {
        byte[] ret = bindings.SocketAddress_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_SocketAddressDecodeErrorZ read(byte[] ser) {
        long ret = bindings.SocketAddress_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_SocketAddressDecodeErrorZ ret_hu_conv = Result_SocketAddressDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public String to_str() {
        String ret = bindings.SocketAddress_to_str(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_SocketAddressSocketAddressParseErrorZ from_str(String s) {
        long ret = bindings.SocketAddress_from_str(s);
        Reference.reachabilityFence(s);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_SocketAddressSocketAddressParseErrorZ ret_hu_conv = Result_SocketAddressSocketAddressParseErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static final class TcpIpV4
    extends SocketAddress {
        public final byte[] addr;
        public final short port;

        private TcpIpV4(long ptr, bindings.LDKSocketAddress.TcpIpV4 obj) {
            super(null, ptr);
            this.addr = obj.addr;
            this.port = obj.port;
        }
    }

    public static final class TcpIpV6
    extends SocketAddress {
        public final byte[] addr;
        public final short port;

        private TcpIpV6(long ptr, bindings.LDKSocketAddress.TcpIpV6 obj) {
            super(null, ptr);
            this.addr = obj.addr;
            this.port = obj.port;
        }
    }

    public static final class OnionV2
    extends SocketAddress {
        public final byte[] onion_v2;

        private OnionV2(long ptr, bindings.LDKSocketAddress.OnionV2 obj) {
            super(null, ptr);
            this.onion_v2 = obj.onion_v2;
        }
    }

    public static final class OnionV3
    extends SocketAddress {
        public final byte[] ed25519_pubkey;
        public final short checksum;
        public final byte version;
        public final short port;

        private OnionV3(long ptr, bindings.LDKSocketAddress.OnionV3 obj) {
            super(null, ptr);
            this.ed25519_pubkey = obj.ed25519_pubkey;
            this.checksum = obj.checksum;
            this.version = obj.version;
            this.port = obj.port;
        }
    }

    public static final class Hostname
    extends SocketAddress {
        public final org.ldk.structs.Hostname hostname;
        public final short port;

        private Hostname(long ptr, bindings.LDKSocketAddress.Hostname obj) {
            super(null, ptr);
            long hostname = obj.hostname;
            org.ldk.structs.Hostname hostname_hu_conv = null;
            if (hostname < 0L || hostname > 4096L) {
                hostname_hu_conv = new org.ldk.structs.Hostname(null, hostname);
            }
            if (hostname_hu_conv != null) {
                hostname_hu_conv.ptrs_to.add(this);
            }
            this.hostname = hostname_hu_conv;
            this.port = obj.port;
        }
    }
}

