/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.DelayedPaymentOutputDescriptor;
import org.ldk.structs.OutPoint;
import org.ldk.structs.Result_SpendableOutputDescriptorDecodeErrorZ;
import org.ldk.structs.StaticPaymentOutputDescriptor;
import org.ldk.structs.TxOut;
import org.ldk.util.InternalUtils;

public class SpendableOutputDescriptor
extends CommonBase {
    private SpendableOutputDescriptor(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.SpendableOutputDescriptor_free(this.ptr);
        }
    }

    static SpendableOutputDescriptor constr_from_ptr(long ptr) {
        bindings.LDKSpendableOutputDescriptor raw_val = bindings.LDKSpendableOutputDescriptor_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKSpendableOutputDescriptor.StaticOutput.class) {
            return new StaticOutput(ptr, (bindings.LDKSpendableOutputDescriptor.StaticOutput)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSpendableOutputDescriptor.DelayedPaymentOutput.class) {
            return new DelayedPaymentOutput(ptr, (bindings.LDKSpendableOutputDescriptor.DelayedPaymentOutput)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKSpendableOutputDescriptor.StaticPaymentOutput.class) {
            return new StaticPaymentOutput(ptr, (bindings.LDKSpendableOutputDescriptor.StaticPaymentOutput)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.SpendableOutputDescriptor_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public SpendableOutputDescriptor clone() {
        long ret = bindings.SpendableOutputDescriptor_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SpendableOutputDescriptor ret_hu_conv = SpendableOutputDescriptor.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static SpendableOutputDescriptor static_output(OutPoint outpoint, TxOut output, byte[] channel_keys_id) {
        long ret = bindings.SpendableOutputDescriptor_static_output(outpoint.ptr, output.ptr, InternalUtils.check_arr_len(channel_keys_id, 32));
        Reference.reachabilityFence(outpoint);
        Reference.reachabilityFence(output);
        Reference.reachabilityFence(channel_keys_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SpendableOutputDescriptor ret_hu_conv = SpendableOutputDescriptor.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SpendableOutputDescriptor delayed_payment_output(DelayedPaymentOutputDescriptor a) {
        long ret = bindings.SpendableOutputDescriptor_delayed_payment_output(a.ptr);
        Reference.reachabilityFence(a);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SpendableOutputDescriptor ret_hu_conv = SpendableOutputDescriptor.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static SpendableOutputDescriptor static_payment_output(StaticPaymentOutputDescriptor a) {
        long ret = bindings.SpendableOutputDescriptor_static_payment_output(a.ptr);
        Reference.reachabilityFence(a);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SpendableOutputDescriptor ret_hu_conv = SpendableOutputDescriptor.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.SpendableOutputDescriptor_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean eq(SpendableOutputDescriptor b) {
        boolean ret = bindings.SpendableOutputDescriptor_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SpendableOutputDescriptor)) {
            return false;
        }
        return this.eq((SpendableOutputDescriptor)o);
    }

    public byte[] write() {
        byte[] ret = bindings.SpendableOutputDescriptor_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_SpendableOutputDescriptorDecodeErrorZ read(byte[] ser) {
        long ret = bindings.SpendableOutputDescriptor_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_SpendableOutputDescriptorDecodeErrorZ ret_hu_conv = Result_SpendableOutputDescriptorDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public OutPoint spendable_outpoint() {
        long ret = bindings.SpendableOutputDescriptor_spendable_outpoint(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OutPoint ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new OutPoint(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static final class StaticOutput
    extends SpendableOutputDescriptor {
        public final OutPoint outpoint;
        public final TxOut output;
        @Nullable
        public final byte[] channel_keys_id;

        private StaticOutput(long ptr, bindings.LDKSpendableOutputDescriptor.StaticOutput obj) {
            super(null, ptr);
            TxOut output_conv;
            long outpoint = obj.outpoint;
            OutPoint outpoint_hu_conv = null;
            if (outpoint < 0L || outpoint > 4096L) {
                outpoint_hu_conv = new OutPoint(null, outpoint);
            }
            if (outpoint_hu_conv != null) {
                outpoint_hu_conv.ptrs_to.add(this);
            }
            this.outpoint = outpoint_hu_conv;
            long output = obj.output;
            this.output = output_conv = new TxOut(null, output);
            this.channel_keys_id = obj.channel_keys_id;
        }
    }

    public static final class DelayedPaymentOutput
    extends SpendableOutputDescriptor {
        public final DelayedPaymentOutputDescriptor delayed_payment_output;

        private DelayedPaymentOutput(long ptr, bindings.LDKSpendableOutputDescriptor.DelayedPaymentOutput obj) {
            super(null, ptr);
            long delayed_payment_output = obj.delayed_payment_output;
            DelayedPaymentOutputDescriptor delayed_payment_output_hu_conv = null;
            if (delayed_payment_output < 0L || delayed_payment_output > 4096L) {
                delayed_payment_output_hu_conv = new DelayedPaymentOutputDescriptor(null, delayed_payment_output);
            }
            if (delayed_payment_output_hu_conv != null) {
                delayed_payment_output_hu_conv.ptrs_to.add(this);
            }
            this.delayed_payment_output = delayed_payment_output_hu_conv;
        }
    }

    public static final class StaticPaymentOutput
    extends SpendableOutputDescriptor {
        public final StaticPaymentOutputDescriptor static_payment_output;

        private StaticPaymentOutput(long ptr, bindings.LDKSpendableOutputDescriptor.StaticPaymentOutput obj) {
            super(null, ptr);
            long static_payment_output = obj.static_payment_output;
            StaticPaymentOutputDescriptor static_payment_output_hu_conv = null;
            if (static_payment_output < 0L || static_payment_output > 4096L) {
                static_payment_output_hu_conv = new StaticPaymentOutputDescriptor(null, static_payment_output);
            }
            if (static_payment_output_hu_conv != null) {
                static_payment_output_hu_conv.ptrs_to.add(this);
            }
            this.static_payment_output = static_payment_output_hu_conv;
        }
    }
}

