/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.ChannelId;
import org.ldk.structs.CommonBase;
import org.ldk.structs.OnionPacket;
import org.ldk.structs.Option_u64Z;
import org.ldk.structs.Result_UpdateAddHTLCDecodeErrorZ;
import org.ldk.util.InternalUtils;

public class UpdateAddHTLC
extends CommonBase {
    UpdateAddHTLC(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.UpdateAddHTLC_free(this.ptr);
        }
    }

    public ChannelId get_channel_id() {
        long ret = bindings.UpdateAddHTLC_get_channel_id(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelId ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelId(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_channel_id(ChannelId val) {
        bindings.UpdateAddHTLC_set_channel_id(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_htlc_id() {
        long ret = bindings.UpdateAddHTLC_get_htlc_id(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_htlc_id(long val) {
        bindings.UpdateAddHTLC_set_htlc_id(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_amount_msat() {
        long ret = bindings.UpdateAddHTLC_get_amount_msat(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_amount_msat(long val) {
        bindings.UpdateAddHTLC_set_amount_msat(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_payment_hash() {
        byte[] ret = bindings.UpdateAddHTLC_get_payment_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_payment_hash(byte[] val) {
        bindings.UpdateAddHTLC_set_payment_hash(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public int get_cltv_expiry() {
        int ret = bindings.UpdateAddHTLC_get_cltv_expiry(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_cltv_expiry(int val) {
        bindings.UpdateAddHTLC_set_cltv_expiry(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u64Z get_skimmed_fee_msat() {
        long ret = bindings.UpdateAddHTLC_get_skimmed_fee_msat(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_skimmed_fee_msat(Option_u64Z val) {
        bindings.UpdateAddHTLC_set_skimmed_fee_msat(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public OnionPacket get_onion_routing_packet() {
        long ret = bindings.UpdateAddHTLC_get_onion_routing_packet(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OnionPacket ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new OnionPacket(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_onion_routing_packet(OnionPacket val) {
        bindings.UpdateAddHTLC_set_onion_routing_packet(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    @Nullable
    public byte[] get_blinding_point() {
        byte[] ret = bindings.UpdateAddHTLC_get_blinding_point(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_blinding_point(@Nullable byte[] val) {
        bindings.UpdateAddHTLC_set_blinding_point(this.ptr, InternalUtils.check_arr_len(val, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public static UpdateAddHTLC of(ChannelId channel_id_arg, long htlc_id_arg, long amount_msat_arg, byte[] payment_hash_arg, int cltv_expiry_arg, Option_u64Z skimmed_fee_msat_arg, OnionPacket onion_routing_packet_arg, @Nullable byte[] blinding_point_arg) {
        long ret = bindings.UpdateAddHTLC_new(channel_id_arg.ptr, htlc_id_arg, amount_msat_arg, InternalUtils.check_arr_len(payment_hash_arg, 32), cltv_expiry_arg, skimmed_fee_msat_arg.ptr, onion_routing_packet_arg.ptr, InternalUtils.check_arr_len(blinding_point_arg, 33));
        Reference.reachabilityFence(channel_id_arg);
        Reference.reachabilityFence(htlc_id_arg);
        Reference.reachabilityFence(amount_msat_arg);
        Reference.reachabilityFence(payment_hash_arg);
        Reference.reachabilityFence(cltv_expiry_arg);
        Reference.reachabilityFence(skimmed_fee_msat_arg);
        Reference.reachabilityFence(onion_routing_packet_arg);
        Reference.reachabilityFence(blinding_point_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        UpdateAddHTLC ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new UpdateAddHTLC(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    long clone_ptr() {
        long ret = bindings.UpdateAddHTLC_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public UpdateAddHTLC clone() {
        long ret = bindings.UpdateAddHTLC_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        UpdateAddHTLC ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new UpdateAddHTLC(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.UpdateAddHTLC_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean eq(UpdateAddHTLC b) {
        boolean ret = bindings.UpdateAddHTLC_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UpdateAddHTLC)) {
            return false;
        }
        return this.eq((UpdateAddHTLC)o);
    }

    public byte[] write() {
        byte[] ret = bindings.UpdateAddHTLC_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_UpdateAddHTLCDecodeErrorZ read(byte[] ser) {
        long ret = bindings.UpdateAddHTLC_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_UpdateAddHTLCDecodeErrorZ ret_hu_conv = Result_UpdateAddHTLCDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }
}

