/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.ldk.enums.COption_NoneZ;
import org.ldk.enums.Currency;
import org.ldk.impl.bindings;
import org.ldk.structs.BlindedMessagePath;
import org.ldk.structs.Bolt11Invoice;
import org.ldk.structs.BroadcasterInterface;
import org.ldk.structs.ChangeDestinationSource;
import org.ldk.structs.ChannelAnnouncement;
import org.ldk.structs.ChannelDetails;
import org.ldk.structs.ChannelManager;
import org.ldk.structs.ChannelMonitor;
import org.ldk.structs.ChannelTypeFeatures;
import org.ldk.structs.CustomOnionMessageHandler;
import org.ldk.structs.DelayedPaymentKey;
import org.ldk.structs.EntropySource;
import org.ldk.structs.ExpandedKey;
import org.ldk.structs.FeeEstimator;
import org.ldk.structs.HTLCOutputInCommitment;
import org.ldk.structs.InitFeatures;
import org.ldk.structs.KVStore;
import org.ldk.structs.Logger;
import org.ldk.structs.MessageRouter;
import org.ldk.structs.MigratableKVStore;
import org.ldk.structs.NetworkGraph;
import org.ldk.structs.NodeAnnouncement;
import org.ldk.structs.NodeIdLookUp;
import org.ldk.structs.NodeSigner;
import org.ldk.structs.OnionMessage;
import org.ldk.structs.OnionMessageContents;
import org.ldk.structs.OnionMessagePath;
import org.ldk.structs.Option_FilterZ;
import org.ldk.structs.Option_HTLCClaimZ;
import org.ldk.structs.Option_ThirtyTwoBytesZ;
import org.ldk.structs.Option_u16Z;
import org.ldk.structs.Option_u32Z;
import org.ldk.structs.Option_u64Z;
import org.ldk.structs.OutPoint;
import org.ldk.structs.OutputSpender;
import org.ldk.structs.PhantomRouteHints;
import org.ldk.structs.ProbabilisticScoringFeeParameters;
import org.ldk.structs.ReadOnlyNetworkGraph;
import org.ldk.structs.Result_Bolt11InvoiceSignOrCreationErrorZ;
import org.ldk.structs.Result_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ;
import org.ldk.structs.Result_C2Tuple_CVec_u8Zu64ZNoneZ;
import org.ldk.structs.Result_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ;
import org.ldk.structs.Result_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ;
import org.ldk.structs.Result_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ;
import org.ldk.structs.Result_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ;
import org.ldk.structs.Result_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ;
import org.ldk.structs.Result_COption_APIErrorZDecodeErrorZ;
import org.ldk.structs.Result_COption_ClosureReasonZDecodeErrorZ;
import org.ldk.structs.Result_COption_EventZDecodeErrorZ;
import org.ldk.structs.Result_COption_HTLCDestinationZDecodeErrorZ;
import org.ldk.structs.Result_COption_InboundHTLCStateDetailsZDecodeErrorZ;
import org.ldk.structs.Result_COption_MonitorEventZDecodeErrorZ;
import org.ldk.structs.Result_COption_NetworkUpdateZDecodeErrorZ;
import org.ldk.structs.Result_COption_OutboundHTLCStateDetailsZDecodeErrorZ;
import org.ldk.structs.Result_COption_PathFailureZDecodeErrorZ;
import org.ldk.structs.Result_COption_PaymentFailureReasonZDecodeErrorZ;
import org.ldk.structs.Result_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ;
import org.ldk.structs.Result_NoneIOErrorZ;
import org.ldk.structs.Result_NoneLightningErrorZ;
import org.ldk.structs.Result_PeeledOnionNoneZ;
import org.ldk.structs.Result_PendingHTLCInfoInboundHTLCErrZ;
import org.ldk.structs.Result_PublicKeySecp256k1ErrorZ;
import org.ldk.structs.Result_RouteLightningErrorZ;
import org.ldk.structs.Result_SocketAddressSocketAddressParseErrorZ;
import org.ldk.structs.Result_ThirtyTwoBytesNoneZ;
import org.ldk.structs.Result_u64ShortChannelIdErrorZ;
import org.ldk.structs.RevocationKey;
import org.ldk.structs.RouteParameters;
import org.ldk.structs.Router;
import org.ldk.structs.ScoreLookUp;
import org.ldk.structs.Sha256;
import org.ldk.structs.SignerProvider;
import org.ldk.structs.SpendableOutputDescriptor;
import org.ldk.structs.TxCreationKeys;
import org.ldk.structs.TxOut;
import org.ldk.structs.UpdateAddHTLC;
import org.ldk.structs.UserConfig;
import org.ldk.structs.Watch;
import org.ldk.util.InternalUtils;
import org.ldk.util.UInt128;

public class UtilMethods {
    public static byte[] U128_le_bytes(UInt128 val) {
        byte[] ret = bindings.U128_le_bytes(val.getLEBytes());
        Reference.reachabilityFence(val);
        return ret;
    }

    public static UInt128 U128_new(byte[] le_bytes) {
        byte[] ret = bindings.U128_new(InternalUtils.check_arr_len(le_bytes, 16));
        Reference.reachabilityFence(le_bytes);
        UInt128 ret_conv = new UInt128(ret);
        return ret_conv;
    }

    public static COption_NoneZ COption_NoneZ_some() {
        COption_NoneZ ret = bindings.COption_NoneZ_some();
        return ret;
    }

    public static COption_NoneZ COption_NoneZ_none() {
        COption_NoneZ ret = bindings.COption_NoneZ_none();
        return ret;
    }

    public static Result_COption_APIErrorZDecodeErrorZ APIError_read(byte[] ser) {
        long ret = bindings.APIError_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_COption_APIErrorZDecodeErrorZ ret_hu_conv = Result_COption_APIErrorZDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static String sign(byte[] msg, byte[] sk) {
        String ret = bindings.sign(msg, InternalUtils.check_arr_len(sk, 32));
        Reference.reachabilityFence(msg);
        Reference.reachabilityFence(sk);
        return ret;
    }

    public static Result_PublicKeySecp256k1ErrorZ recover_pk(byte[] msg, String sig) {
        long ret = bindings.recover_pk(msg, sig);
        Reference.reachabilityFence(msg);
        Reference.reachabilityFence(sig);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_PublicKeySecp256k1ErrorZ ret_hu_conv = Result_PublicKeySecp256k1ErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static boolean verify(byte[] msg, String sig, byte[] pk) {
        boolean ret = bindings.verify(msg, sig, InternalUtils.check_arr_len(pk, 33));
        Reference.reachabilityFence(msg);
        Reference.reachabilityFence(sig);
        Reference.reachabilityFence(pk);
        return ret;
    }

    public static Result_NoneIOErrorZ migrate_kv_store_data(MigratableKVStore source_store, MigratableKVStore target_store) {
        long ret = bindings.migrate_kv_store_data(source_store.ptr, target_store.ptr);
        Reference.reachabilityFence(source_store);
        Reference.reachabilityFence(target_store);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneIOErrorZ ret_hu_conv = Result_NoneIOErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(source_store);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(target_store);
        }
        return ret_hu_conv;
    }

    public static Result_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ read_channel_monitors(KVStore kv_store, EntropySource entropy_source, SignerProvider signer_provider) {
        long ret = bindings.read_channel_monitors(kv_store.ptr, entropy_source.ptr, signer_provider.ptr);
        Reference.reachabilityFence(kv_store);
        Reference.reachabilityFence(entropy_source);
        Reference.reachabilityFence(signer_provider);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ ret_hu_conv = Result_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(kv_store);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(entropy_source);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(signer_provider);
        }
        return ret_hu_conv;
    }

    public static int block_from_scid(long short_channel_id) {
        int ret = bindings.block_from_scid(short_channel_id);
        Reference.reachabilityFence(short_channel_id);
        return ret;
    }

    public static int tx_index_from_scid(long short_channel_id) {
        int ret = bindings.tx_index_from_scid(short_channel_id);
        Reference.reachabilityFence(short_channel_id);
        return ret;
    }

    public static short vout_from_scid(long short_channel_id) {
        short ret = bindings.vout_from_scid(short_channel_id);
        Reference.reachabilityFence(short_channel_id);
        return ret;
    }

    public static Result_u64ShortChannelIdErrorZ scid_from_parts(long block, long tx_index, long vout_index) {
        long ret = bindings.scid_from_parts(block, tx_index, vout_index);
        Reference.reachabilityFence(block);
        Reference.reachabilityFence(tx_index);
        Reference.reachabilityFence(vout_index);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_u64ShortChannelIdErrorZ ret_hu_conv = Result_u64ShortChannelIdErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static Result_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ C2Tuple_BestBlockOutputSweeperZ_read(byte[] ser, BroadcasterInterface arg_a, FeeEstimator arg_b, Option_FilterZ arg_c, OutputSpender arg_d, ChangeDestinationSource arg_e, KVStore arg_f, Logger arg_g) {
        long ret = bindings.C2Tuple_BestBlockOutputSweeperZ_read(ser, arg_a.ptr, arg_b.ptr, arg_c.ptr, arg_d.ptr, arg_e.ptr, arg_f.ptr, arg_g.ptr);
        Reference.reachabilityFence(ser);
        Reference.reachabilityFence(arg_a);
        Reference.reachabilityFence(arg_b);
        Reference.reachabilityFence(arg_c);
        Reference.reachabilityFence(arg_d);
        Reference.reachabilityFence(arg_e);
        Reference.reachabilityFence(arg_f);
        Reference.reachabilityFence(arg_g);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ ret_hu_conv = Result_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_a);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_b);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_c);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_d);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_e);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_f);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_g);
        }
        return ret_hu_conv;
    }

    public static Result_COption_MonitorEventZDecodeErrorZ MonitorEvent_read(byte[] ser) {
        long ret = bindings.MonitorEvent_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_COption_MonitorEventZDecodeErrorZ ret_hu_conv = Result_COption_MonitorEventZDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static Result_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ C2Tuple_ThirtyTwoBytesChannelMonitorZ_read(byte[] ser, EntropySource arg_a, SignerProvider arg_b) {
        long ret = bindings.C2Tuple_ThirtyTwoBytesChannelMonitorZ_read(ser, arg_a.ptr, arg_b.ptr);
        Reference.reachabilityFence(ser);
        Reference.reachabilityFence(arg_a);
        Reference.reachabilityFence(arg_b);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ ret_hu_conv = Result_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_a);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_b);
        }
        return ret_hu_conv;
    }

    public static Result_PendingHTLCInfoInboundHTLCErrZ peel_payment_onion(UpdateAddHTLC msg, NodeSigner node_signer, Logger logger, int cur_height, boolean allow_skimmed_fees) {
        long ret = bindings.peel_payment_onion(msg.ptr, node_signer.ptr, logger.ptr, cur_height, allow_skimmed_fees);
        Reference.reachabilityFence(msg);
        Reference.reachabilityFence(node_signer);
        Reference.reachabilityFence(logger);
        Reference.reachabilityFence(cur_height);
        Reference.reachabilityFence(allow_skimmed_fees);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_PendingHTLCInfoInboundHTLCErrZ ret_hu_conv = Result_PendingHTLCInfoInboundHTLCErrZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(msg);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(node_signer);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(logger);
        }
        return ret_hu_conv;
    }

    public static InitFeatures provided_init_features(UserConfig config) {
        long ret = bindings.provided_init_features(config.ptr);
        Reference.reachabilityFence(config);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        InitFeatures ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new InitFeatures(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(config);
        }
        return ret_hu_conv;
    }

    public static Result_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ C2Tuple_ThirtyTwoBytesChannelManagerZ_read(byte[] ser, EntropySource arg_entropy_source, NodeSigner arg_node_signer, SignerProvider arg_signer_provider, FeeEstimator arg_fee_estimator, Watch arg_chain_monitor, BroadcasterInterface arg_tx_broadcaster, Router arg_router, MessageRouter arg_message_router, Logger arg_logger, UserConfig arg_default_config, ChannelMonitor[] arg_channel_monitors) {
        long ret = bindings.C2Tuple_ThirtyTwoBytesChannelManagerZ_read(ser, bindings.ChannelManagerReadArgs_new(arg_entropy_source.ptr, arg_node_signer.ptr, arg_signer_provider.ptr, arg_fee_estimator.ptr, arg_chain_monitor.ptr, arg_tx_broadcaster.ptr, arg_router.ptr, arg_message_router.ptr, arg_logger.ptr, arg_default_config.ptr, arg_channel_monitors != null ? Arrays.stream(arg_channel_monitors).mapToLong(arg_channel_monitors_conv_16 -> arg_channel_monitors_conv_16.ptr).toArray() : null));
        Reference.reachabilityFence(ser);
        Reference.reachabilityFence(arg_entropy_source);
        Reference.reachabilityFence(arg_node_signer);
        Reference.reachabilityFence(arg_signer_provider);
        Reference.reachabilityFence(arg_fee_estimator);
        Reference.reachabilityFence(arg_chain_monitor);
        Reference.reachabilityFence(arg_tx_broadcaster);
        Reference.reachabilityFence(arg_router);
        Reference.reachabilityFence(arg_message_router);
        Reference.reachabilityFence(arg_logger);
        Reference.reachabilityFence(arg_default_config);
        Reference.reachabilityFence(arg_channel_monitors);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ ret_hu_conv = Result_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_entropy_source);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_node_signer);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_signer_provider);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_fee_estimator);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_chain_monitor);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_tx_broadcaster);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_router);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_message_router);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg_logger);
        }
        for (ChannelMonitor arg_channel_monitors_conv_162 : arg_channel_monitors) {
            if (ret_hu_conv == null) continue;
            ret_hu_conv.ptrs_to.add(arg_channel_monitors_conv_162);
        }
        return ret_hu_conv;
    }

    public static byte[] add_public_key_tweak(byte[] base_point, byte[] tweak) {
        byte[] ret = bindings.add_public_key_tweak(InternalUtils.check_arr_len(base_point, 33), InternalUtils.check_arr_len(tweak, 32));
        Reference.reachabilityFence(base_point);
        Reference.reachabilityFence(tweak);
        return ret;
    }

    public static Result_COption_InboundHTLCStateDetailsZDecodeErrorZ InboundHTLCStateDetails_read(byte[] ser) {
        long ret = bindings.InboundHTLCStateDetails_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_COption_InboundHTLCStateDetailsZDecodeErrorZ ret_hu_conv = Result_COption_InboundHTLCStateDetailsZDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static Result_COption_OutboundHTLCStateDetailsZDecodeErrorZ OutboundHTLCStateDetails_read(byte[] ser) {
        long ret = bindings.OutboundHTLCStateDetails_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_COption_OutboundHTLCStateDetailsZDecodeErrorZ ret_hu_conv = Result_COption_OutboundHTLCStateDetailsZDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static Result_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ create(ExpandedKey keys, Option_u64Z min_value_msat, int invoice_expiry_delta_secs, EntropySource entropy_source, long current_time, Option_u16Z min_final_cltv_expiry_delta) {
        long ret = bindings.create(keys.ptr, min_value_msat.ptr, invoice_expiry_delta_secs, entropy_source.ptr, current_time, min_final_cltv_expiry_delta.ptr);
        Reference.reachabilityFence(keys);
        Reference.reachabilityFence(min_value_msat);
        Reference.reachabilityFence(invoice_expiry_delta_secs);
        Reference.reachabilityFence(entropy_source);
        Reference.reachabilityFence(current_time);
        Reference.reachabilityFence(min_final_cltv_expiry_delta);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ ret_hu_conv = Result_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(keys);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(entropy_source);
        }
        return ret_hu_conv;
    }

    public static Result_ThirtyTwoBytesNoneZ create_from_hash(ExpandedKey keys, Option_u64Z min_value_msat, byte[] payment_hash, int invoice_expiry_delta_secs, long current_time, Option_u16Z min_final_cltv_expiry_delta) {
        long ret = bindings.create_from_hash(keys.ptr, min_value_msat.ptr, InternalUtils.check_arr_len(payment_hash, 32), invoice_expiry_delta_secs, current_time, min_final_cltv_expiry_delta.ptr);
        Reference.reachabilityFence(keys);
        Reference.reachabilityFence(min_value_msat);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(invoice_expiry_delta_secs);
        Reference.reachabilityFence(current_time);
        Reference.reachabilityFence(min_final_cltv_expiry_delta);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ThirtyTwoBytesNoneZ ret_hu_conv = Result_ThirtyTwoBytesNoneZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(keys);
        }
        return ret_hu_conv;
    }

    public static Result_SocketAddressSocketAddressParseErrorZ parse_onion_address(String host, short port) {
        long ret = bindings.parse_onion_address(host, port);
        Reference.reachabilityFence(host);
        Reference.reachabilityFence(port);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_SocketAddressSocketAddressParseErrorZ ret_hu_conv = Result_SocketAddressSocketAddressParseErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static long htlc_success_tx_weight(ChannelTypeFeatures channel_type_features) {
        long ret = bindings.htlc_success_tx_weight(channel_type_features.ptr);
        Reference.reachabilityFence(channel_type_features);
        return ret;
    }

    public static long htlc_timeout_tx_weight(ChannelTypeFeatures channel_type_features) {
        long ret = bindings.htlc_timeout_tx_weight(channel_type_features.ptr);
        Reference.reachabilityFence(channel_type_features);
        return ret;
    }

    public static Option_HTLCClaimZ HTLCClaim_from_witness(byte[] witness) {
        long ret = bindings.HTLCClaim_from_witness(witness);
        Reference.reachabilityFence(witness);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_HTLCClaimZ ret_hu_conv = Option_HTLCClaimZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static byte[] build_commitment_secret(byte[] commitment_seed, long idx) {
        byte[] ret = bindings.build_commitment_secret(InternalUtils.check_arr_len(commitment_seed, 32), idx);
        Reference.reachabilityFence(commitment_seed);
        Reference.reachabilityFence(idx);
        return ret;
    }

    public static byte[] build_closing_transaction(long to_holder_value_sat, long to_counterparty_value_sat, byte[] to_holder_script, byte[] to_counterparty_script, OutPoint funding_outpoint) {
        byte[] ret = bindings.build_closing_transaction(to_holder_value_sat, to_counterparty_value_sat, to_holder_script, to_counterparty_script, funding_outpoint.ptr);
        Reference.reachabilityFence(to_holder_value_sat);
        Reference.reachabilityFence(to_counterparty_value_sat);
        Reference.reachabilityFence(to_holder_script);
        Reference.reachabilityFence(to_counterparty_script);
        Reference.reachabilityFence(funding_outpoint);
        return ret;
    }

    public static byte[] derive_private_key(byte[] per_commitment_point, byte[] base_secret) {
        byte[] ret = bindings.derive_private_key(InternalUtils.check_arr_len(per_commitment_point, 33), InternalUtils.check_arr_len(base_secret, 32));
        Reference.reachabilityFence(per_commitment_point);
        Reference.reachabilityFence(base_secret);
        return ret;
    }

    public static byte[] derive_private_revocation_key(byte[] per_commitment_secret, byte[] countersignatory_revocation_base_secret) {
        byte[] ret = bindings.derive_private_revocation_key(InternalUtils.check_arr_len(per_commitment_secret, 32), InternalUtils.check_arr_len(countersignatory_revocation_base_secret, 32));
        Reference.reachabilityFence(per_commitment_secret);
        Reference.reachabilityFence(countersignatory_revocation_base_secret);
        return ret;
    }

    public static byte[] get_revokeable_redeemscript(RevocationKey revocation_key, short contest_delay, DelayedPaymentKey broadcaster_delayed_payment_key) {
        byte[] ret = bindings.get_revokeable_redeemscript(revocation_key.ptr, contest_delay, broadcaster_delayed_payment_key.ptr);
        Reference.reachabilityFence(revocation_key);
        Reference.reachabilityFence(contest_delay);
        Reference.reachabilityFence(broadcaster_delayed_payment_key);
        return ret;
    }

    public static byte[] get_counterparty_payment_script(ChannelTypeFeatures channel_type_features, byte[] payment_key) {
        byte[] ret = bindings.get_counterparty_payment_script(channel_type_features.ptr, InternalUtils.check_arr_len(payment_key, 33));
        Reference.reachabilityFence(channel_type_features);
        Reference.reachabilityFence(payment_key);
        return ret;
    }

    public static byte[] get_htlc_redeemscript(HTLCOutputInCommitment htlc, ChannelTypeFeatures channel_type_features, TxCreationKeys keys) {
        byte[] ret = bindings.get_htlc_redeemscript(htlc.ptr, channel_type_features.ptr, keys.ptr);
        Reference.reachabilityFence(htlc);
        Reference.reachabilityFence(channel_type_features);
        Reference.reachabilityFence(keys);
        return ret;
    }

    public static byte[] make_funding_redeemscript(byte[] broadcaster, byte[] countersignatory) {
        byte[] ret = bindings.make_funding_redeemscript(InternalUtils.check_arr_len(broadcaster, 33), InternalUtils.check_arr_len(countersignatory, 33));
        Reference.reachabilityFence(broadcaster);
        Reference.reachabilityFence(countersignatory);
        return ret;
    }

    public static byte[] build_htlc_transaction(byte[] commitment_txid, int feerate_per_kw, short contest_delay, HTLCOutputInCommitment htlc, ChannelTypeFeatures channel_type_features, DelayedPaymentKey broadcaster_delayed_payment_key, RevocationKey revocation_key) {
        byte[] ret = bindings.build_htlc_transaction(InternalUtils.check_arr_len(commitment_txid, 32), feerate_per_kw, contest_delay, htlc.ptr, channel_type_features.ptr, broadcaster_delayed_payment_key.ptr, revocation_key.ptr);
        Reference.reachabilityFence(commitment_txid);
        Reference.reachabilityFence(feerate_per_kw);
        Reference.reachabilityFence(contest_delay);
        Reference.reachabilityFence(htlc);
        Reference.reachabilityFence(channel_type_features);
        Reference.reachabilityFence(broadcaster_delayed_payment_key);
        Reference.reachabilityFence(revocation_key);
        return ret;
    }

    public static byte[] build_htlc_input_witness(byte[] local_sig, byte[] remote_sig, Option_ThirtyTwoBytesZ preimage, byte[] redeem_script, ChannelTypeFeatures channel_type_features) {
        byte[] ret = bindings.build_htlc_input_witness(InternalUtils.check_arr_len(local_sig, 64), InternalUtils.check_arr_len(remote_sig, 64), preimage.ptr, redeem_script, channel_type_features.ptr);
        Reference.reachabilityFence(local_sig);
        Reference.reachabilityFence(remote_sig);
        Reference.reachabilityFence(preimage);
        Reference.reachabilityFence(redeem_script);
        Reference.reachabilityFence(channel_type_features);
        return ret;
    }

    public static byte[] get_to_countersignatory_with_anchors_redeemscript(byte[] payment_point) {
        byte[] ret = bindings.get_to_countersignatory_with_anchors_redeemscript(InternalUtils.check_arr_len(payment_point, 33));
        Reference.reachabilityFence(payment_point);
        return ret;
    }

    public static byte[] get_anchor_redeemscript(byte[] funding_pubkey) {
        byte[] ret = bindings.get_anchor_redeemscript(InternalUtils.check_arr_len(funding_pubkey, 33));
        Reference.reachabilityFence(funding_pubkey);
        return ret;
    }

    public static byte[] build_anchor_input_witness(byte[] funding_key, byte[] funding_sig) {
        byte[] ret = bindings.build_anchor_input_witness(InternalUtils.check_arr_len(funding_key, 33), InternalUtils.check_arr_len(funding_sig, 64));
        Reference.reachabilityFence(funding_key);
        Reference.reachabilityFence(funding_sig);
        return ret;
    }

    public static long get_commitment_transaction_number_obscure_factor(byte[] broadcaster_payment_basepoint, byte[] countersignatory_payment_basepoint, boolean outbound_from_broadcaster) {
        long ret = bindings.get_commitment_transaction_number_obscure_factor(InternalUtils.check_arr_len(broadcaster_payment_basepoint, 33), InternalUtils.check_arr_len(countersignatory_payment_basepoint, 33), outbound_from_broadcaster);
        Reference.reachabilityFence(broadcaster_payment_basepoint);
        Reference.reachabilityFence(countersignatory_payment_basepoint);
        Reference.reachabilityFence(outbound_from_broadcaster);
        return ret;
    }

    public static Result_Bolt11InvoiceSignOrCreationErrorZ create_phantom_invoice(Option_u64Z amt_msat, Option_ThirtyTwoBytesZ payment_hash, String description, int invoice_expiry_delta_secs, PhantomRouteHints[] phantom_route_hints, EntropySource entropy_source, NodeSigner node_signer, Logger logger, Currency network, Option_u16Z min_final_cltv_expiry_delta, long duration_since_epoch) {
        long ret = bindings.create_phantom_invoice(amt_msat.ptr, payment_hash.ptr, description, invoice_expiry_delta_secs, phantom_route_hints != null ? Arrays.stream(phantom_route_hints).mapToLong(phantom_route_hints_conv_19 -> phantom_route_hints_conv_19.ptr).toArray() : null, entropy_source.ptr, node_signer.ptr, logger.ptr, network, min_final_cltv_expiry_delta.ptr, duration_since_epoch);
        Reference.reachabilityFence(amt_msat);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(description);
        Reference.reachabilityFence(invoice_expiry_delta_secs);
        Reference.reachabilityFence(phantom_route_hints);
        Reference.reachabilityFence(entropy_source);
        Reference.reachabilityFence(node_signer);
        Reference.reachabilityFence(logger);
        Reference.reachabilityFence((Object)network);
        Reference.reachabilityFence(min_final_cltv_expiry_delta);
        Reference.reachabilityFence(duration_since_epoch);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_Bolt11InvoiceSignOrCreationErrorZ ret_hu_conv = Result_Bolt11InvoiceSignOrCreationErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(entropy_source);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(node_signer);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(logger);
        }
        return ret_hu_conv;
    }

    public static Result_Bolt11InvoiceSignOrCreationErrorZ create_phantom_invoice_with_description_hash(Option_u64Z amt_msat, Option_ThirtyTwoBytesZ payment_hash, int invoice_expiry_delta_secs, Sha256 description_hash, PhantomRouteHints[] phantom_route_hints, EntropySource entropy_source, NodeSigner node_signer, Logger logger, Currency network, Option_u16Z min_final_cltv_expiry_delta, long duration_since_epoch) {
        long ret = bindings.create_phantom_invoice_with_description_hash(amt_msat.ptr, payment_hash.ptr, invoice_expiry_delta_secs, description_hash.ptr, phantom_route_hints != null ? Arrays.stream(phantom_route_hints).mapToLong(phantom_route_hints_conv_19 -> phantom_route_hints_conv_19.ptr).toArray() : null, entropy_source.ptr, node_signer.ptr, logger.ptr, network, min_final_cltv_expiry_delta.ptr, duration_since_epoch);
        Reference.reachabilityFence(amt_msat);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(invoice_expiry_delta_secs);
        Reference.reachabilityFence(description_hash);
        Reference.reachabilityFence(phantom_route_hints);
        Reference.reachabilityFence(entropy_source);
        Reference.reachabilityFence(node_signer);
        Reference.reachabilityFence(logger);
        Reference.reachabilityFence((Object)network);
        Reference.reachabilityFence(min_final_cltv_expiry_delta);
        Reference.reachabilityFence(duration_since_epoch);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_Bolt11InvoiceSignOrCreationErrorZ ret_hu_conv = Result_Bolt11InvoiceSignOrCreationErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(entropy_source);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(node_signer);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(logger);
        }
        return ret_hu_conv;
    }

    public static Result_Bolt11InvoiceSignOrCreationErrorZ create_invoice_from_channelmanager(ChannelManager channelmanager, Option_u64Z amt_msat, String description, int invoice_expiry_delta_secs, Option_u16Z min_final_cltv_expiry_delta) {
        long ret = bindings.create_invoice_from_channelmanager(channelmanager.ptr, amt_msat.ptr, description, invoice_expiry_delta_secs, min_final_cltv_expiry_delta.ptr);
        Reference.reachabilityFence(channelmanager);
        Reference.reachabilityFence(amt_msat);
        Reference.reachabilityFence(description);
        Reference.reachabilityFence(invoice_expiry_delta_secs);
        Reference.reachabilityFence(min_final_cltv_expiry_delta);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_Bolt11InvoiceSignOrCreationErrorZ ret_hu_conv = Result_Bolt11InvoiceSignOrCreationErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(channelmanager);
        }
        return ret_hu_conv;
    }

    public static Result_Bolt11InvoiceSignOrCreationErrorZ create_invoice_from_channelmanager_with_description_hash(ChannelManager channelmanager, Option_u64Z amt_msat, Sha256 description_hash, int invoice_expiry_delta_secs, Option_u16Z min_final_cltv_expiry_delta) {
        long ret = bindings.create_invoice_from_channelmanager_with_description_hash(channelmanager.ptr, amt_msat.ptr, description_hash.ptr, invoice_expiry_delta_secs, min_final_cltv_expiry_delta.ptr);
        Reference.reachabilityFence(channelmanager);
        Reference.reachabilityFence(amt_msat);
        Reference.reachabilityFence(description_hash);
        Reference.reachabilityFence(invoice_expiry_delta_secs);
        Reference.reachabilityFence(min_final_cltv_expiry_delta);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_Bolt11InvoiceSignOrCreationErrorZ ret_hu_conv = Result_Bolt11InvoiceSignOrCreationErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(channelmanager);
        }
        return ret_hu_conv;
    }

    public static Result_Bolt11InvoiceSignOrCreationErrorZ create_invoice_from_channelmanager_with_description_hash_and_payment_hash(ChannelManager channelmanager, Option_u64Z amt_msat, Sha256 description_hash, int invoice_expiry_delta_secs, byte[] payment_hash, Option_u16Z min_final_cltv_expiry_delta) {
        long ret = bindings.create_invoice_from_channelmanager_with_description_hash_and_payment_hash(channelmanager.ptr, amt_msat.ptr, description_hash.ptr, invoice_expiry_delta_secs, InternalUtils.check_arr_len(payment_hash, 32), min_final_cltv_expiry_delta.ptr);
        Reference.reachabilityFence(channelmanager);
        Reference.reachabilityFence(amt_msat);
        Reference.reachabilityFence(description_hash);
        Reference.reachabilityFence(invoice_expiry_delta_secs);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(min_final_cltv_expiry_delta);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_Bolt11InvoiceSignOrCreationErrorZ ret_hu_conv = Result_Bolt11InvoiceSignOrCreationErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(channelmanager);
        }
        return ret_hu_conv;
    }

    public static Result_Bolt11InvoiceSignOrCreationErrorZ create_invoice_from_channelmanager_with_payment_hash(ChannelManager channelmanager, Option_u64Z amt_msat, String description, int invoice_expiry_delta_secs, byte[] payment_hash, Option_u16Z min_final_cltv_expiry_delta) {
        long ret = bindings.create_invoice_from_channelmanager_with_payment_hash(channelmanager.ptr, amt_msat.ptr, description, invoice_expiry_delta_secs, InternalUtils.check_arr_len(payment_hash, 32), min_final_cltv_expiry_delta.ptr);
        Reference.reachabilityFence(channelmanager);
        Reference.reachabilityFence(amt_msat);
        Reference.reachabilityFence(description);
        Reference.reachabilityFence(invoice_expiry_delta_secs);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(min_final_cltv_expiry_delta);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_Bolt11InvoiceSignOrCreationErrorZ ret_hu_conv = Result_Bolt11InvoiceSignOrCreationErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(channelmanager);
        }
        return ret_hu_conv;
    }

    public static Result_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ payment_parameters_from_variable_amount_invoice(Bolt11Invoice invoice, long amount_msat) {
        long ret = bindings.payment_parameters_from_variable_amount_invoice(invoice.ptr, amount_msat);
        Reference.reachabilityFence(invoice);
        Reference.reachabilityFence(amount_msat);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ ret_hu_conv = Result_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(invoice);
        }
        return ret_hu_conv;
    }

    public static Result_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ payment_parameters_from_invoice(Bolt11Invoice invoice) {
        long ret = bindings.payment_parameters_from_invoice(invoice.ptr);
        Reference.reachabilityFence(invoice);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ ret_hu_conv = Result_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(invoice);
        }
        return ret_hu_conv;
    }

    public static Result_COption_NetworkUpdateZDecodeErrorZ NetworkUpdate_read(byte[] ser) {
        long ret = bindings.NetworkUpdate_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_COption_NetworkUpdateZDecodeErrorZ ret_hu_conv = Result_COption_NetworkUpdateZDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static Result_NoneLightningErrorZ verify_node_announcement(NodeAnnouncement msg) {
        long ret = bindings.verify_node_announcement(msg.ptr);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneLightningErrorZ ret_hu_conv = Result_NoneLightningErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(msg);
        }
        return ret_hu_conv;
    }

    public static Result_NoneLightningErrorZ verify_channel_announcement(ChannelAnnouncement msg) {
        long ret = bindings.verify_channel_announcement(msg.ptr);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneLightningErrorZ ret_hu_conv = Result_NoneLightningErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(msg);
        }
        return ret_hu_conv;
    }

    public static Result_RouteLightningErrorZ find_route(byte[] our_node_pubkey, RouteParameters route_params, NetworkGraph network_graph, @Nullable ChannelDetails[] first_hops, Logger logger, ScoreLookUp scorer, ProbabilisticScoringFeeParameters score_params, byte[] random_seed_bytes) {
        long ret = bindings.find_route(InternalUtils.check_arr_len(our_node_pubkey, 33), route_params.ptr, network_graph.ptr, first_hops != null ? Arrays.stream(first_hops).mapToLong(first_hops_conv_16 -> first_hops_conv_16.ptr).toArray() : null, logger.ptr, scorer.ptr, score_params.ptr, InternalUtils.check_arr_len(random_seed_bytes, 32));
        Reference.reachabilityFence(our_node_pubkey);
        Reference.reachabilityFence(route_params);
        Reference.reachabilityFence(network_graph);
        Reference.reachabilityFence(first_hops);
        Reference.reachabilityFence(logger);
        Reference.reachabilityFence(scorer);
        Reference.reachabilityFence(score_params);
        Reference.reachabilityFence(random_seed_bytes);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_RouteLightningErrorZ ret_hu_conv = Result_RouteLightningErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(route_params);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(network_graph);
        }
        if (first_hops != null) {
            for (ChannelDetails first_hops_conv_162 : first_hops) {
                if (ret_hu_conv == null) continue;
                ret_hu_conv.ptrs_to.add(first_hops_conv_162);
            }
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(logger);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(scorer);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(score_params);
        }
        return ret_hu_conv;
    }

    public static Result_RouteLightningErrorZ build_route_from_hops(byte[] our_node_pubkey, byte[][] hops, RouteParameters route_params, NetworkGraph network_graph, Logger logger, byte[] random_seed_bytes) {
        long ret = bindings.build_route_from_hops(InternalUtils.check_arr_len(our_node_pubkey, 33), hops != null ? (byte[][])Arrays.stream(hops).map(hops_conv_8 -> InternalUtils.check_arr_len(hops_conv_8, 33)).toArray(x$0 -> new byte[x$0][]) : null, route_params.ptr, network_graph.ptr, logger.ptr, InternalUtils.check_arr_len(random_seed_bytes, 32));
        Reference.reachabilityFence(our_node_pubkey);
        Reference.reachabilityFence(hops);
        Reference.reachabilityFence(route_params);
        Reference.reachabilityFence(network_graph);
        Reference.reachabilityFence(logger);
        Reference.reachabilityFence(random_seed_bytes);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_RouteLightningErrorZ ret_hu_conv = Result_RouteLightningErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(route_params);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(network_graph);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(logger);
        }
        return ret_hu_conv;
    }

    public static Result_C2Tuple_CVec_u8Zu64ZNoneZ SpendableOutputDescriptor_create_spendable_outputs_psbt(SpendableOutputDescriptor[] descriptors, TxOut[] outputs, byte[] change_destination_script, int feerate_sat_per_1000_weight, Option_u32Z locktime) {
        long ret = bindings.SpendableOutputDescriptor_create_spendable_outputs_psbt(descriptors != null ? Arrays.stream(descriptors).mapToLong(descriptors_conv_27 -> descriptors_conv_27.ptr).toArray() : null, outputs != null ? Arrays.stream(outputs).mapToLong(outputs_conv_7 -> outputs_conv_7.ptr).toArray() : null, change_destination_script, feerate_sat_per_1000_weight, locktime.ptr);
        Reference.reachabilityFence(descriptors);
        Reference.reachabilityFence(outputs);
        Reference.reachabilityFence(change_destination_script);
        Reference.reachabilityFence(feerate_sat_per_1000_weight);
        Reference.reachabilityFence(locktime);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_C2Tuple_CVec_u8Zu64ZNoneZ ret_hu_conv = Result_C2Tuple_CVec_u8Zu64ZNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static boolean AsyncPaymentsMessage_is_known_type(long tlv_type) {
        boolean ret = bindings.AsyncPaymentsMessage_is_known_type(tlv_type);
        Reference.reachabilityFence(tlv_type);
        return ret;
    }

    public static boolean DNSResolverMessage_is_known_type(long tlv_type) {
        boolean ret = bindings.DNSResolverMessage_is_known_type(tlv_type);
        Reference.reachabilityFence(tlv_type);
        return ret;
    }

    public static Result_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ create_onion_message_resolving_destination(EntropySource entropy_source, NodeSigner node_signer, NodeIdLookUp node_id_lookup, ReadOnlyNetworkGraph network_graph, OnionMessagePath path, OnionMessageContents contents, @Nullable BlindedMessagePath reply_path) {
        long ret = bindings.create_onion_message_resolving_destination(entropy_source.ptr, node_signer.ptr, node_id_lookup.ptr, network_graph.ptr, path.ptr, contents.ptr, reply_path == null ? 0L : reply_path.ptr);
        Reference.reachabilityFence(entropy_source);
        Reference.reachabilityFence(node_signer);
        Reference.reachabilityFence(node_id_lookup);
        Reference.reachabilityFence(network_graph);
        Reference.reachabilityFence(path);
        Reference.reachabilityFence(contents);
        Reference.reachabilityFence(reply_path);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ ret_hu_conv = Result_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(entropy_source);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(node_signer);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(node_id_lookup);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(network_graph);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(contents);
        }
        return ret_hu_conv;
    }

    public static Result_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ create_onion_message(EntropySource entropy_source, NodeSigner node_signer, NodeIdLookUp node_id_lookup, OnionMessagePath path, OnionMessageContents contents, @Nullable BlindedMessagePath reply_path) {
        long ret = bindings.create_onion_message(entropy_source.ptr, node_signer.ptr, node_id_lookup.ptr, path.ptr, contents.ptr, reply_path == null ? 0L : reply_path.ptr);
        Reference.reachabilityFence(entropy_source);
        Reference.reachabilityFence(node_signer);
        Reference.reachabilityFence(node_id_lookup);
        Reference.reachabilityFence(path);
        Reference.reachabilityFence(contents);
        Reference.reachabilityFence(reply_path);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ ret_hu_conv = Result_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(entropy_source);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(node_signer);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(node_id_lookup);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(contents);
        }
        return ret_hu_conv;
    }

    public static Result_PeeledOnionNoneZ peel_onion_message(OnionMessage msg, NodeSigner node_signer, Logger logger, CustomOnionMessageHandler custom_handler) {
        long ret = bindings.peel_onion_message(msg.ptr, node_signer.ptr, logger.ptr, custom_handler.ptr);
        Reference.reachabilityFence(msg);
        Reference.reachabilityFence(node_signer);
        Reference.reachabilityFence(logger);
        Reference.reachabilityFence(custom_handler);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_PeeledOnionNoneZ ret_hu_conv = Result_PeeledOnionNoneZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(msg);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(node_signer);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(logger);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(custom_handler);
        }
        return ret_hu_conv;
    }

    public static boolean OffersMessage_is_known_type(long tlv_type) {
        boolean ret = bindings.OffersMessage_is_known_type(tlv_type);
        Reference.reachabilityFence(tlv_type);
        return ret;
    }

    public static Result_COption_PathFailureZDecodeErrorZ PathFailure_read(byte[] ser) {
        long ret = bindings.PathFailure_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_COption_PathFailureZDecodeErrorZ ret_hu_conv = Result_COption_PathFailureZDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static Result_COption_ClosureReasonZDecodeErrorZ ClosureReason_read(byte[] ser) {
        long ret = bindings.ClosureReason_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_COption_ClosureReasonZDecodeErrorZ ret_hu_conv = Result_COption_ClosureReasonZDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static Result_COption_HTLCDestinationZDecodeErrorZ HTLCDestination_read(byte[] ser) {
        long ret = bindings.HTLCDestination_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_COption_HTLCDestinationZDecodeErrorZ ret_hu_conv = Result_COption_HTLCDestinationZDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static Result_COption_PaymentFailureReasonZDecodeErrorZ PaymentFailureReason_read(byte[] ser) {
        long ret = bindings.PaymentFailureReason_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_COption_PaymentFailureReasonZDecodeErrorZ ret_hu_conv = Result_COption_PaymentFailureReasonZDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static Result_COption_EventZDecodeErrorZ Event_read(byte[] ser) {
        long ret = bindings.Event_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_COption_EventZDecodeErrorZ ret_hu_conv = Result_COption_EventZDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }
}

