/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.ExpandedKey;
import org.ldk.structs.Nonce;
import org.ldk.structs.Result_NoneNoneZ;
import org.ldk.util.InternalUtils;

public class Verification
extends CommonBase {
    final bindings.LDKVerification bindings_instance;

    Verification(Object _dummy, long ptr) {
        super(ptr);
        this.bindings_instance = null;
    }

    private Verification(bindings.LDKVerification arg) {
        super(bindings.LDKVerification_new(arg));
        this.ptrs_to.add(arg);
        this.bindings_instance = arg;
    }

    protected void finalize() throws Throwable {
        if (this.ptr != 0L) {
            bindings.Verification_free(this.ptr);
        }
        super.finalize();
    }

    public void destroy() {
        if (this.ptr != 0L) {
            bindings.Verification_free(this.ptr);
        }
        this.ptr = 0L;
    }

    public static Verification new_impl(final VerificationInterface arg) {
        LDKVerificationHolder impl_holder = new LDKVerificationHolder();
        impl_holder.held = new Verification(new bindings.LDKVerification(){

            @Override
            public byte[] hmac_for_offer_payment(long nonce, long expanded_key) {
                Nonce nonce_hu_conv = null;
                if (nonce < 0L || nonce > 4096L) {
                    nonce_hu_conv = new Nonce(null, nonce);
                }
                if (nonce_hu_conv != null) {
                    nonce_hu_conv.ptrs_to.add(this);
                }
                ExpandedKey expanded_key_hu_conv = null;
                if (expanded_key < 0L || expanded_key > 4096L) {
                    expanded_key_hu_conv = new ExpandedKey(null, expanded_key);
                }
                byte[] ret = arg.hmac_for_offer_payment(nonce_hu_conv, expanded_key_hu_conv);
                Reference.reachabilityFence(arg);
                byte[] result = InternalUtils.check_arr_len(ret, 32);
                return result;
            }

            @Override
            public long verify_for_offer_payment(byte[] hmac, long nonce, long expanded_key) {
                Nonce nonce_hu_conv = null;
                if (nonce < 0L || nonce > 4096L) {
                    nonce_hu_conv = new Nonce(null, nonce);
                }
                if (nonce_hu_conv != null) {
                    nonce_hu_conv.ptrs_to.add(this);
                }
                ExpandedKey expanded_key_hu_conv = null;
                if (expanded_key < 0L || expanded_key > 4096L) {
                    expanded_key_hu_conv = new ExpandedKey(null, expanded_key);
                }
                Result_NoneNoneZ ret = arg.verify_for_offer_payment(hmac, nonce_hu_conv, expanded_key_hu_conv);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }
        });
        return impl_holder.held;
    }

    public byte[] hmac_for_offer_payment(Nonce nonce, ExpandedKey expanded_key) {
        byte[] ret = bindings.Verification_hmac_for_offer_payment(this.ptr, nonce.ptr, expanded_key.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(nonce);
        Reference.reachabilityFence(expanded_key);
        if (this != null) {
            this.ptrs_to.add(expanded_key);
        }
        return ret;
    }

    public Result_NoneNoneZ verify_for_offer_payment(byte[] hmac, Nonce nonce, ExpandedKey expanded_key) {
        long ret = bindings.Verification_verify_for_offer_payment(this.ptr, InternalUtils.check_arr_len(hmac, 32), nonce.ptr, expanded_key.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(hmac);
        Reference.reachabilityFence(nonce);
        Reference.reachabilityFence(expanded_key);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneNoneZ ret_hu_conv = Result_NoneNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(expanded_key);
        }
        return ret_hu_conv;
    }

    private static class LDKVerificationHolder {
        Verification held;

        private LDKVerificationHolder() {
        }
    }

    public static interface VerificationInterface {
        public byte[] hmac_for_offer_payment(Nonce var1, ExpandedKey var2);

        public Result_NoneNoneZ verify_for_offer_payment(byte[] var1, Nonce var2, ExpandedKey var3);
    }
}

