package org.ldk.impl;
import org.ldk.enums.*;
import org.ldk.impl.version;
import java.io.File;
import java.io.InputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class bindings {
	static {
		try {
			// Try to load natively first, this works on Android and in testing.
			System.loadLibrary("lightningjni");
		} catch (UnsatisfiedLinkError system_load_err) {
			// Otherwise try to load from the library jar.
			File tmpdir = new File(System.getProperty("java.io.tmpdir"), "ldk-java-nativelib");
			tmpdir.mkdir(); // If it fails to create, assume it was there already
			tmpdir.deleteOnExit();
			String libname = "liblightningjni_" + System.getProperty("os.name").replaceAll(" ", "") +
				"-" + System.getProperty("os.arch").replaceAll(" ", "") + ".nativelib";
			try (InputStream is = bindings.class.getResourceAsStream("/" + libname)) {
				Path libpath = new File(tmpdir.toPath().toString(), "liblightningjni.so").toPath();
				Files.copy(is, libpath, StandardCopyOption.REPLACE_EXISTING);
				Runtime.getRuntime().load(libpath.toString());
			} catch (Exception e) {
				System.err.println("Failed to load LDK native library.");
				System.err.println("System LDK native library load failed with: " + system_load_err);
				System.err.println("Resource-based LDK native library load failed with: " + e);
				throw new IllegalArgumentException(e);
			}
		}
		init(java.lang.Enum.class);
		init_class_cache();
		if (!get_lib_version_string().equals(version.get_ldk_java_bindings_version()))
			throw new IllegalArgumentException("Compiled LDK library and LDK class failes do not match");
		// Fetching the LDK versions from C also checks that the header and binaries match
		System.err.println("Loaded LDK-Java Bindings " + version.get_ldk_java_bindings_version() + " with LDK " + get_ldk_version() + " and LDK-C-Bindings " + get_ldk_c_bindings_version());
	}
	public static void run_statics() { /* Useful to force the statics to run */ }
	static native void init(java.lang.Class c);
	static native void init_class_cache();
	static native String get_lib_version_string();

	public static native String get_ldk_c_bindings_version();
	public static native String get_ldk_version();

	static { BalanceSource.values(); /* Force enum statics to run */ }
	static { BlindedFailure.values(); /* Force enum statics to run */ }
	static { Bolt11SemanticError.values(); /* Force enum statics to run */ }
	static { Bolt12SemanticError.values(); /* Force enum statics to run */ }
	static { COption_NoneZ.values(); /* Force enum statics to run */ }
	static { ChannelMonitorUpdateStatus.values(); /* Force enum statics to run */ }
	static { ChannelShutdownState.values(); /* Force enum statics to run */ }
	static { ConfirmationTarget.values(); /* Force enum statics to run */ }
	static { CreationError.values(); /* Force enum statics to run */ }
	static { Currency.values(); /* Force enum statics to run */ }
	static { Direction.values(); /* Force enum statics to run */ }
	static { HTLCClaim.values(); /* Force enum statics to run */ }
	static { IOError.values(); /* Force enum statics to run */ }
	static { InboundHTLCStateDetails.values(); /* Force enum statics to run */ }
	static { LSPS1OrderState.values(); /* Force enum statics to run */ }
	static { LSPS1PaymentState.values(); /* Force enum statics to run */ }
	static { Level.values(); /* Force enum statics to run */ }
	static { Network.values(); /* Force enum statics to run */ }
	static { OutboundHTLCStateDetails.values(); /* Force enum statics to run */ }
	static { PaymentFailureReason.values(); /* Force enum statics to run */ }
	static { Recipient.values(); /* Force enum statics to run */ }
	static { RetryableSendFailure.values(); /* Force enum statics to run */ }
	static { Secp256k1Error.values(); /* Force enum statics to run */ }
	static { ShortChannelIdError.values(); /* Force enum statics to run */ }
	static { SiPrefix.values(); /* Force enum statics to run */ }
	static { SocketAddressParseError.values(); /* Force enum statics to run */ }
	static { UtxoLookupError.values(); /* Force enum statics to run */ }
	public static class LDKCOption_AddressZ {
		private LDKCOption_AddressZ() {}
		public final static class Some extends LDKCOption_AddressZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_AddressZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_AddressZ.init(); }
	public static native LDKCOption_AddressZ LDKCOption_AddressZ_ref_from_ptr(long ptr);
	// struct LDKThirtyTwoBytes BigEndianScalar_get_bytes (struct LDKBigEndianScalar* thing)
	public static native byte[] BigEndianScalar_get_bytes(long thing);
	// static void BigEndianScalar_free (struct LDKBigEndianScalar thing)
	public static native void BigEndianScalar_free(long thing);
	public static class LDKBech32Error {
		private LDKBech32Error() {}
		public final static class MissingSeparator extends LDKBech32Error {
			MissingSeparator() { }
		}
		public final static class InvalidChecksum extends LDKBech32Error {
			InvalidChecksum() { }
		}
		public final static class InvalidLength extends LDKBech32Error {
			InvalidLength() { }
		}
		public final static class InvalidChar extends LDKBech32Error {
			public int invalid_char;
			InvalidChar(int invalid_char) { this.invalid_char = invalid_char; }
		}
		public final static class InvalidData extends LDKBech32Error {
			public byte invalid_data;
			InvalidData(byte invalid_data) { this.invalid_data = invalid_data; }
		}
		public final static class InvalidPadding extends LDKBech32Error {
			InvalidPadding() { }
		}
		public final static class MixedCase extends LDKBech32Error {
			MixedCase() { }
		}
		static native void init();
	}
	static { LDKBech32Error.init(); }
	public static native LDKBech32Error LDKBech32Error_ref_from_ptr(long ptr);
	// struct LDKRefundMaybeWithDerivedMetadataBuilder CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_get_ok(LDKCResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native long CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_get_ok(long owner);
	// enum LDKBolt12SemanticError CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_get_err(LDKCResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native Bolt12SemanticError CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_get_err(long owner);
	// struct LDKRefund CResult_RefundBolt12SemanticErrorZ_get_ok(LDKCResult_RefundBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native long CResult_RefundBolt12SemanticErrorZ_get_ok(long owner);
	// enum LDKBolt12SemanticError CResult_RefundBolt12SemanticErrorZ_get_err(LDKCResult_RefundBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native Bolt12SemanticError CResult_RefundBolt12SemanticErrorZ_get_err(long owner);
	public static class LDKCOption_u64Z {
		private LDKCOption_u64Z() {}
		public final static class Some extends LDKCOption_u64Z {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_u64Z {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_u64Z.init(); }
	public static native LDKCOption_u64Z LDKCOption_u64Z_ref_from_ptr(long ptr);
	public static class LDKDecodeError {
		private LDKDecodeError() {}
		public final static class UnknownVersion extends LDKDecodeError {
			UnknownVersion() { }
		}
		public final static class UnknownRequiredFeature extends LDKDecodeError {
			UnknownRequiredFeature() { }
		}
		public final static class InvalidValue extends LDKDecodeError {
			InvalidValue() { }
		}
		public final static class ShortRead extends LDKDecodeError {
			ShortRead() { }
		}
		public final static class BadLengthDescriptor extends LDKDecodeError {
			BadLengthDescriptor() { }
		}
		public final static class Io extends LDKDecodeError {
			public org.ldk.enums.IOError io;
			Io(org.ldk.enums.IOError io) { this.io = io; }
		}
		public final static class UnsupportedCompression extends LDKDecodeError {
			UnsupportedCompression() { }
		}
		public final static class DangerousValue extends LDKDecodeError {
			DangerousValue() { }
		}
		static native void init();
	}
	static { LDKDecodeError.init(); }
	public static native LDKDecodeError LDKDecodeError_ref_from_ptr(long ptr);
	// struct LDKRefund CResult_RefundDecodeErrorZ_get_ok(LDKCResult_RefundDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RefundDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_RefundDecodeErrorZ_get_err(LDKCResult_RefundDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RefundDecodeErrorZ_get_err(long owner);
	// struct LDKRefund CResult_RefundBolt12ParseErrorZ_get_ok(LDKCResult_RefundBolt12ParseErrorZ *NONNULL_PTR owner);
	public static native long CResult_RefundBolt12ParseErrorZ_get_ok(long owner);
	// struct LDKBolt12ParseError CResult_RefundBolt12ParseErrorZ_get_err(LDKCResult_RefundBolt12ParseErrorZ *NONNULL_PTR owner);
	public static native long CResult_RefundBolt12ParseErrorZ_get_err(long owner);
	public static class LDKRetry {
		private LDKRetry() {}
		public final static class Attempts extends LDKRetry {
			public int attempts;
			Attempts(int attempts) { this.attempts = attempts; }
		}
		public final static class Timeout extends LDKRetry {
			public long timeout;
			Timeout(long timeout) { this.timeout = timeout; }
		}
		static native void init();
	}
	static { LDKRetry.init(); }
	public static native LDKRetry LDKRetry_ref_from_ptr(long ptr);
	// struct LDKRetry CResult_RetryDecodeErrorZ_get_ok(LDKCResult_RetryDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RetryDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_RetryDecodeErrorZ_get_err(LDKCResult_RetryDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RetryDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_ThirtyTwoBytesZ {
		private LDKCOption_ThirtyTwoBytesZ() {}
		public final static class Some extends LDKCOption_ThirtyTwoBytesZ {
			public byte[] some;
			Some(byte[] some) { this.some = some; }
		}
		public final static class None extends LDKCOption_ThirtyTwoBytesZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_ThirtyTwoBytesZ.init(); }
	public static native LDKCOption_ThirtyTwoBytesZ LDKCOption_ThirtyTwoBytesZ_ref_from_ptr(long ptr);
	public static class LDKCOption_CVec_u8ZZ {
		private LDKCOption_CVec_u8ZZ() {}
		public final static class Some extends LDKCOption_CVec_u8ZZ {
			public byte[] some;
			Some(byte[] some) { this.some = some; }
		}
		public final static class None extends LDKCOption_CVec_u8ZZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_CVec_u8ZZ.init(); }
	public static native LDKCOption_CVec_u8ZZ LDKCOption_CVec_u8ZZ_ref_from_ptr(long ptr);
	// struct LDKRecipientOnionFields CResult_RecipientOnionFieldsDecodeErrorZ_get_ok(LDKCResult_RecipientOnionFieldsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RecipientOnionFieldsDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_RecipientOnionFieldsDecodeErrorZ_get_err(LDKCResult_RecipientOnionFieldsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RecipientOnionFieldsDecodeErrorZ_get_err(long owner);
	// uint64_t C2Tuple_u64CVec_u8ZZ_get_a(LDKC2Tuple_u64CVec_u8ZZ *NONNULL_PTR owner);
	public static native long C2Tuple_u64CVec_u8ZZ_get_a(long owner);
	// struct LDKCVec_u8Z C2Tuple_u64CVec_u8ZZ_get_b(LDKC2Tuple_u64CVec_u8ZZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_u64CVec_u8ZZ_get_b(long owner);
	// struct LDKRecipientOnionFields CResult_RecipientOnionFieldsNoneZ_get_ok(LDKCResult_RecipientOnionFieldsNoneZ *NONNULL_PTR owner);
	public static native long CResult_RecipientOnionFieldsNoneZ_get_ok(long owner);
	// void CResult_RecipientOnionFieldsNoneZ_get_err(LDKCResult_RecipientOnionFieldsNoneZ *NONNULL_PTR owner);
	public static native void CResult_RecipientOnionFieldsNoneZ_get_err(long owner);
	public static class LDKDNSResolverMessage {
		private LDKDNSResolverMessage() {}
		public final static class DNSSECQuery extends LDKDNSResolverMessage {
			public long dnssec_query;
			DNSSECQuery(long dnssec_query) { this.dnssec_query = dnssec_query; }
		}
		public final static class DNSSECProof extends LDKDNSResolverMessage {
			public long dnssec_proof;
			DNSSECProof(long dnssec_proof) { this.dnssec_proof = dnssec_proof; }
		}
		static native void init();
	}
	static { LDKDNSResolverMessage.init(); }
	public static native LDKDNSResolverMessage LDKDNSResolverMessage_ref_from_ptr(long ptr);
	// struct LDKDNSResolverMessage C2Tuple_DNSResolverMessageResponseInstructionZ_get_a(LDKC2Tuple_DNSResolverMessageResponseInstructionZ *NONNULL_PTR owner);
	public static native long C2Tuple_DNSResolverMessageResponseInstructionZ_get_a(long owner);
	// struct LDKResponseInstruction C2Tuple_DNSResolverMessageResponseInstructionZ_get_b(LDKC2Tuple_DNSResolverMessageResponseInstructionZ *NONNULL_PTR owner);
	public static native long C2Tuple_DNSResolverMessageResponseInstructionZ_get_b(long owner);
	public static class LDKCOption_C2Tuple_DNSResolverMessageResponseInstructionZZ {
		private LDKCOption_C2Tuple_DNSResolverMessageResponseInstructionZZ() {}
		public final static class Some extends LDKCOption_C2Tuple_DNSResolverMessageResponseInstructionZZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_C2Tuple_DNSResolverMessageResponseInstructionZZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_C2Tuple_DNSResolverMessageResponseInstructionZZ.init(); }
	public static native LDKCOption_C2Tuple_DNSResolverMessageResponseInstructionZZ LDKCOption_C2Tuple_DNSResolverMessageResponseInstructionZZ_ref_from_ptr(long ptr);
	public static class LDKDestination {
		private LDKDestination() {}
		public final static class Node extends LDKDestination {
			public byte[] node;
			Node(byte[] node) { this.node = node; }
		}
		public final static class BlindedPath extends LDKDestination {
			public long blinded_path;
			BlindedPath(long blinded_path) { this.blinded_path = blinded_path; }
		}
		static native void init();
	}
	static { LDKDestination.init(); }
	public static native LDKDestination LDKDestination_ref_from_ptr(long ptr);
	public static class LDKOffersContext {
		private LDKOffersContext() {}
		public final static class InvoiceRequest extends LDKOffersContext {
			public long nonce;
			InvoiceRequest(long nonce) { this.nonce = nonce; }
		}
		public final static class OutboundPayment extends LDKOffersContext {
			public byte[] payment_id;
			public long nonce;
			public byte[] hmac;
			OutboundPayment(byte[] payment_id, long nonce, byte[] hmac) { this.payment_id = payment_id; this.nonce = nonce; this.hmac = hmac; }
		}
		public final static class InboundPayment extends LDKOffersContext {
			public byte[] payment_hash;
			public long nonce;
			public byte[] hmac;
			InboundPayment(byte[] payment_hash, long nonce, byte[] hmac) { this.payment_hash = payment_hash; this.nonce = nonce; this.hmac = hmac; }
		}
		static native void init();
	}
	static { LDKOffersContext.init(); }
	public static native LDKOffersContext LDKOffersContext_ref_from_ptr(long ptr);
	public static class LDKAsyncPaymentsContext {
		private LDKAsyncPaymentsContext() {}
		public final static class OutboundPayment extends LDKAsyncPaymentsContext {
			public byte[] payment_id;
			public long nonce;
			public byte[] hmac;
			OutboundPayment(byte[] payment_id, long nonce, byte[] hmac) { this.payment_id = payment_id; this.nonce = nonce; this.hmac = hmac; }
		}
		static native void init();
	}
	static { LDKAsyncPaymentsContext.init(); }
	public static native LDKAsyncPaymentsContext LDKAsyncPaymentsContext_ref_from_ptr(long ptr);
	public static class LDKMessageContext {
		private LDKMessageContext() {}
		public final static class Offers extends LDKMessageContext {
			public long offers;
			Offers(long offers) { this.offers = offers; }
		}
		public final static class AsyncPayments extends LDKMessageContext {
			public long async_payments;
			AsyncPayments(long async_payments) { this.async_payments = async_payments; }
		}
		public final static class DNSResolver extends LDKMessageContext {
			public long dns_resolver;
			DNSResolver(long dns_resolver) { this.dns_resolver = dns_resolver; }
		}
		public final static class Custom extends LDKMessageContext {
			public byte[] custom;
			Custom(byte[] custom) { this.custom = custom; }
		}
		static native void init();
	}
	static { LDKMessageContext.init(); }
	public static native LDKMessageContext LDKMessageContext_ref_from_ptr(long ptr);
	public static class LDKMessageSendInstructions {
		private LDKMessageSendInstructions() {}
		public final static class WithSpecifiedReplyPath extends LDKMessageSendInstructions {
			public long destination;
			public long reply_path;
			WithSpecifiedReplyPath(long destination, long reply_path) { this.destination = destination; this.reply_path = reply_path; }
		}
		public final static class WithReplyPath extends LDKMessageSendInstructions {
			public long destination;
			public long context;
			WithReplyPath(long destination, long context) { this.destination = destination; this.context = context; }
		}
		public final static class WithoutReplyPath extends LDKMessageSendInstructions {
			public long destination;
			WithoutReplyPath(long destination) { this.destination = destination; }
		}
		public final static class ForReply extends LDKMessageSendInstructions {
			public long instructions;
			ForReply(long instructions) { this.instructions = instructions; }
		}
		static native void init();
	}
	static { LDKMessageSendInstructions.init(); }
	public static native LDKMessageSendInstructions LDKMessageSendInstructions_ref_from_ptr(long ptr);
	// struct LDKDNSResolverMessage C2Tuple_DNSResolverMessageMessageSendInstructionsZ_get_a(LDKC2Tuple_DNSResolverMessageMessageSendInstructionsZ *NONNULL_PTR owner);
	public static native long C2Tuple_DNSResolverMessageMessageSendInstructionsZ_get_a(long owner);
	// struct LDKMessageSendInstructions C2Tuple_DNSResolverMessageMessageSendInstructionsZ_get_b(LDKC2Tuple_DNSResolverMessageMessageSendInstructionsZ *NONNULL_PTR owner);
	public static native long C2Tuple_DNSResolverMessageMessageSendInstructionsZ_get_b(long owner);
	// struct LDKDNSResolverMessage CResult_DNSResolverMessageDecodeErrorZ_get_ok(LDKCResult_DNSResolverMessageDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_DNSResolverMessageDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_DNSResolverMessageDecodeErrorZ_get_err(LDKCResult_DNSResolverMessageDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_DNSResolverMessageDecodeErrorZ_get_err(long owner);
	// struct LDKHumanReadableName CResult_HumanReadableNameNoneZ_get_ok(LDKCResult_HumanReadableNameNoneZ *NONNULL_PTR owner);
	public static native long CResult_HumanReadableNameNoneZ_get_ok(long owner);
	// void CResult_HumanReadableNameNoneZ_get_err(LDKCResult_HumanReadableNameNoneZ *NONNULL_PTR owner);
	public static native void CResult_HumanReadableNameNoneZ_get_err(long owner);
	// struct LDKHumanReadableName CResult_HumanReadableNameDecodeErrorZ_get_ok(LDKCResult_HumanReadableNameDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HumanReadableNameDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_HumanReadableNameDecodeErrorZ_get_err(LDKCResult_HumanReadableNameDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HumanReadableNameDecodeErrorZ_get_err(long owner);
	// struct LDKDNSSECQuery C2Tuple_DNSSECQueryDNSResolverContextZ_get_a(LDKC2Tuple_DNSSECQueryDNSResolverContextZ *NONNULL_PTR owner);
	public static native long C2Tuple_DNSSECQueryDNSResolverContextZ_get_a(long owner);
	// struct LDKDNSResolverContext C2Tuple_DNSSECQueryDNSResolverContextZ_get_b(LDKC2Tuple_DNSSECQueryDNSResolverContextZ *NONNULL_PTR owner);
	public static native long C2Tuple_DNSSECQueryDNSResolverContextZ_get_b(long owner);
	// struct LDKC2Tuple_DNSSECQueryDNSResolverContextZ CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_get_ok(LDKCResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ *NONNULL_PTR owner);
	public static native long CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_get_ok(long owner);
	// void CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_get_err(LDKCResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ *NONNULL_PTR owner);
	public static native void CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_get_err(long owner);
	// struct LDKHumanReadableName C2Tuple_HumanReadableNameThirtyTwoBytesZ_get_a(LDKC2Tuple_HumanReadableNameThirtyTwoBytesZ *NONNULL_PTR owner);
	public static native long C2Tuple_HumanReadableNameThirtyTwoBytesZ_get_a(long owner);
	// struct LDKThirtyTwoBytes C2Tuple_HumanReadableNameThirtyTwoBytesZ_get_b(LDKC2Tuple_HumanReadableNameThirtyTwoBytesZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_HumanReadableNameThirtyTwoBytesZ_get_b(long owner);
	// struct LDKCVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZ C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ_get_a(LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ *NONNULL_PTR owner);
	public static native long[] C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ_get_a(long owner);
	// struct LDKOffer C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ_get_b(LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ *NONNULL_PTR owner);
	public static native long C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ_get_b(long owner);
	public static class LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ {
		private LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ() {}
		public final static class Some extends LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ.init(); }
	public static native LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ_ref_from_ptr(long ptr);
	// struct LDKCVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZ C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ_get_a(LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ *NONNULL_PTR owner);
	public static native long[] C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ_get_a(long owner);
	// struct LDKStr C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ_get_b(LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ *NONNULL_PTR owner);
	public static native String C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ_get_b(long owner);
	public static class LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ {
		private LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ() {}
		public final static class Some extends LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ.init(); }
	public static native LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ_ref_from_ptr(long ptr);
	// struct LDKUnsignedBolt12Invoice CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_get_ok(LDKCResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native long CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_get_ok(long owner);
	// enum LDKBolt12SemanticError CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_get_err(LDKCResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native Bolt12SemanticError CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_get_err(long owner);
	// struct LDKBolt12Invoice CResult_Bolt12InvoiceBolt12SemanticErrorZ_get_ok(LDKCResult_Bolt12InvoiceBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt12InvoiceBolt12SemanticErrorZ_get_ok(long owner);
	// enum LDKBolt12SemanticError CResult_Bolt12InvoiceBolt12SemanticErrorZ_get_err(LDKCResult_Bolt12InvoiceBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native Bolt12SemanticError CResult_Bolt12InvoiceBolt12SemanticErrorZ_get_err(long owner);
	// struct LDKSchnorrSignature CResult_SchnorrSignatureNoneZ_get_ok(LDKCResult_SchnorrSignatureNoneZ *NONNULL_PTR owner);
	public static native byte[] CResult_SchnorrSignatureNoneZ_get_ok(long owner);
	// void CResult_SchnorrSignatureNoneZ_get_err(LDKCResult_SchnorrSignatureNoneZ *NONNULL_PTR owner);
	public static native void CResult_SchnorrSignatureNoneZ_get_err(long owner);
	public static class LDKCOption_CVec_ThirtyTwoBytesZZ {
		private LDKCOption_CVec_ThirtyTwoBytesZZ() {}
		public final static class Some extends LDKCOption_CVec_ThirtyTwoBytesZZ {
			public byte[][] some;
			Some(byte[][] some) { this.some = some; }
		}
		public final static class None extends LDKCOption_CVec_ThirtyTwoBytesZZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_CVec_ThirtyTwoBytesZZ.init(); }
	public static native LDKCOption_CVec_ThirtyTwoBytesZZ LDKCOption_CVec_ThirtyTwoBytesZZ_ref_from_ptr(long ptr);
	public static class LDKAmount {
		private LDKAmount() {}
		public final static class Bitcoin extends LDKAmount {
			public long amount_msats;
			Bitcoin(long amount_msats) { this.amount_msats = amount_msats; }
		}
		public final static class Currency extends LDKAmount {
			public byte[] iso4217_code;
			public long amount;
			Currency(byte[] iso4217_code, long amount) { this.iso4217_code = iso4217_code; this.amount = amount; }
		}
		static native void init();
	}
	static { LDKAmount.init(); }
	public static native LDKAmount LDKAmount_ref_from_ptr(long ptr);
	public static class LDKCOption_AmountZ {
		private LDKCOption_AmountZ() {}
		public final static class Some extends LDKCOption_AmountZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_AmountZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_AmountZ.init(); }
	public static native LDKCOption_AmountZ LDKCOption_AmountZ_ref_from_ptr(long ptr);
	public static class LDKQuantity {
		private LDKQuantity() {}
		public final static class Bounded extends LDKQuantity {
			public long bounded;
			Bounded(long bounded) { this.bounded = bounded; }
		}
		public final static class Unbounded extends LDKQuantity {
			Unbounded() { }
		}
		public final static class One extends LDKQuantity {
			One() { }
		}
		static native void init();
	}
	static { LDKQuantity.init(); }
	public static native LDKQuantity LDKQuantity_ref_from_ptr(long ptr);
	public static class LDKCOption_QuantityZ {
		private LDKCOption_QuantityZ() {}
		public final static class Some extends LDKCOption_QuantityZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_QuantityZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_QuantityZ.init(); }
	public static native LDKCOption_QuantityZ LDKCOption_QuantityZ_ref_from_ptr(long ptr);
	// struct LDKThirtyTwoBytes CResult_ThirtyTwoBytesNoneZ_get_ok(LDKCResult_ThirtyTwoBytesNoneZ *NONNULL_PTR owner);
	public static native byte[] CResult_ThirtyTwoBytesNoneZ_get_ok(long owner);
	// void CResult_ThirtyTwoBytesNoneZ_get_err(LDKCResult_ThirtyTwoBytesNoneZ *NONNULL_PTR owner);
	public static native void CResult_ThirtyTwoBytesNoneZ_get_err(long owner);
	// struct LDKBolt12Invoice CResult_Bolt12InvoiceDecodeErrorZ_get_ok(LDKCResult_Bolt12InvoiceDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt12InvoiceDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_Bolt12InvoiceDecodeErrorZ_get_err(LDKCResult_Bolt12InvoiceDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt12InvoiceDecodeErrorZ_get_err(long owner);
	// struct LDKDelayedPaymentOutputDescriptor CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_get_ok(LDKCResult_DelayedPaymentOutputDescriptorDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_get_err(LDKCResult_DelayedPaymentOutputDescriptorDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_get_err(long owner);
	// struct LDKStaticPaymentOutputDescriptor CResult_StaticPaymentOutputDescriptorDecodeErrorZ_get_ok(LDKCResult_StaticPaymentOutputDescriptorDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_StaticPaymentOutputDescriptorDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_StaticPaymentOutputDescriptorDecodeErrorZ_get_err(LDKCResult_StaticPaymentOutputDescriptorDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_StaticPaymentOutputDescriptorDecodeErrorZ_get_err(long owner);
	public static class LDKSpendableOutputDescriptor {
		private LDKSpendableOutputDescriptor() {}
		public final static class StaticOutput extends LDKSpendableOutputDescriptor {
			public long outpoint;
			public long output;
			public byte[] channel_keys_id;
			StaticOutput(long outpoint, long output, byte[] channel_keys_id) { this.outpoint = outpoint; this.output = output; this.channel_keys_id = channel_keys_id; }
		}
		public final static class DelayedPaymentOutput extends LDKSpendableOutputDescriptor {
			public long delayed_payment_output;
			DelayedPaymentOutput(long delayed_payment_output) { this.delayed_payment_output = delayed_payment_output; }
		}
		public final static class StaticPaymentOutput extends LDKSpendableOutputDescriptor {
			public long static_payment_output;
			StaticPaymentOutput(long static_payment_output) { this.static_payment_output = static_payment_output; }
		}
		static native void init();
	}
	static { LDKSpendableOutputDescriptor.init(); }
	public static native LDKSpendableOutputDescriptor LDKSpendableOutputDescriptor_ref_from_ptr(long ptr);
	// struct LDKSpendableOutputDescriptor CResult_SpendableOutputDescriptorDecodeErrorZ_get_ok(LDKCResult_SpendableOutputDescriptorDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_SpendableOutputDescriptorDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_SpendableOutputDescriptorDecodeErrorZ_get_err(LDKCResult_SpendableOutputDescriptorDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_SpendableOutputDescriptorDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_u32Z {
		private LDKCOption_u32Z() {}
		public final static class Some extends LDKCOption_u32Z {
			public int some;
			Some(int some) { this.some = some; }
		}
		public final static class None extends LDKCOption_u32Z {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_u32Z.init(); }
	public static native LDKCOption_u32Z LDKCOption_u32Z_ref_from_ptr(long ptr);
	// struct LDKCVec_u8Z C2Tuple_CVec_u8Zu64Z_get_a(LDKC2Tuple_CVec_u8Zu64Z *NONNULL_PTR owner);
	public static native byte[] C2Tuple_CVec_u8Zu64Z_get_a(long owner);
	// uint64_t C2Tuple_CVec_u8Zu64Z_get_b(LDKC2Tuple_CVec_u8Zu64Z *NONNULL_PTR owner);
	public static native long C2Tuple_CVec_u8Zu64Z_get_b(long owner);
	// struct LDKC2Tuple_CVec_u8Zu64Z CResult_C2Tuple_CVec_u8Zu64ZNoneZ_get_ok(LDKCResult_C2Tuple_CVec_u8Zu64ZNoneZ *NONNULL_PTR owner);
	public static native long CResult_C2Tuple_CVec_u8Zu64ZNoneZ_get_ok(long owner);
	// void CResult_C2Tuple_CVec_u8Zu64ZNoneZ_get_err(LDKCResult_C2Tuple_CVec_u8Zu64ZNoneZ *NONNULL_PTR owner);
	public static native void CResult_C2Tuple_CVec_u8Zu64ZNoneZ_get_err(long owner);
	// struct LDKChannelDerivationParameters CResult_ChannelDerivationParametersDecodeErrorZ_get_ok(LDKCResult_ChannelDerivationParametersDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelDerivationParametersDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelDerivationParametersDecodeErrorZ_get_err(LDKCResult_ChannelDerivationParametersDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelDerivationParametersDecodeErrorZ_get_err(long owner);
	// struct LDKHTLCDescriptor CResult_HTLCDescriptorDecodeErrorZ_get_ok(LDKCResult_HTLCDescriptorDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HTLCDescriptorDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_HTLCDescriptorDecodeErrorZ_get_err(LDKCResult_HTLCDescriptorDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HTLCDescriptorDecodeErrorZ_get_err(long owner);
	// struct LDKPublicKey CResult_PublicKeyNoneZ_get_ok(LDKCResult_PublicKeyNoneZ *NONNULL_PTR owner);
	public static native byte[] CResult_PublicKeyNoneZ_get_ok(long owner);
	// void CResult_PublicKeyNoneZ_get_err(LDKCResult_PublicKeyNoneZ *NONNULL_PTR owner);
	public static native void CResult_PublicKeyNoneZ_get_err(long owner);
	// struct LDKThirtyTwoBytes CResult__u832NoneZ_get_ok(LDKCResult__u832NoneZ *NONNULL_PTR owner);
	public static native byte[] CResult__u832NoneZ_get_ok(long owner);
	// void CResult__u832NoneZ_get_err(LDKCResult__u832NoneZ *NONNULL_PTR owner);
	public static native void CResult__u832NoneZ_get_err(long owner);
	// void CResult_NoneNoneZ_get_ok(LDKCResult_NoneNoneZ *NONNULL_PTR owner);
	public static native void CResult_NoneNoneZ_get_ok(long owner);
	// void CResult_NoneNoneZ_get_err(LDKCResult_NoneNoneZ *NONNULL_PTR owner);
	public static native void CResult_NoneNoneZ_get_err(long owner);
	public static class LDKCOption_BigEndianScalarZ {
		private LDKCOption_BigEndianScalarZ() {}
		public final static class Some extends LDKCOption_BigEndianScalarZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_BigEndianScalarZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_BigEndianScalarZ.init(); }
	public static native LDKCOption_BigEndianScalarZ LDKCOption_BigEndianScalarZ_ref_from_ptr(long ptr);
	// struct LDKRecoverableSignature CResult_RecoverableSignatureNoneZ_get_ok(LDKCResult_RecoverableSignatureNoneZ *NONNULL_PTR owner);
	public static native byte[] CResult_RecoverableSignatureNoneZ_get_ok(long owner);
	// void CResult_RecoverableSignatureNoneZ_get_err(LDKCResult_RecoverableSignatureNoneZ *NONNULL_PTR owner);
	public static native void CResult_RecoverableSignatureNoneZ_get_err(long owner);
	// struct LDKECDSASignature CResult_ECDSASignatureNoneZ_get_ok(LDKCResult_ECDSASignatureNoneZ *NONNULL_PTR owner);
	public static native byte[] CResult_ECDSASignatureNoneZ_get_ok(long owner);
	// void CResult_ECDSASignatureNoneZ_get_err(LDKCResult_ECDSASignatureNoneZ *NONNULL_PTR owner);
	public static native void CResult_ECDSASignatureNoneZ_get_err(long owner);
	// struct LDKTransaction CResult_TransactionNoneZ_get_ok(LDKCResult_TransactionNoneZ *NONNULL_PTR owner);
	public static native byte[] CResult_TransactionNoneZ_get_ok(long owner);
	// void CResult_TransactionNoneZ_get_err(LDKCResult_TransactionNoneZ *NONNULL_PTR owner);
	public static native void CResult_TransactionNoneZ_get_err(long owner);
	// struct LDKECDSASignature C2Tuple_ECDSASignatureCVec_ECDSASignatureZZ_get_a(LDKC2Tuple_ECDSASignatureCVec_ECDSASignatureZZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_ECDSASignatureCVec_ECDSASignatureZZ_get_a(long owner);
	// struct LDKCVec_ECDSASignatureZ C2Tuple_ECDSASignatureCVec_ECDSASignatureZZ_get_b(LDKC2Tuple_ECDSASignatureCVec_ECDSASignatureZZ *NONNULL_PTR owner);
	public static native byte[][] C2Tuple_ECDSASignatureCVec_ECDSASignatureZZ_get_b(long owner);
	// struct LDKC2Tuple_ECDSASignatureCVec_ECDSASignatureZZ CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_get_ok(LDKCResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ *NONNULL_PTR owner);
	public static native long CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_get_ok(long owner);
	// void CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_get_err(LDKCResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ *NONNULL_PTR owner);
	public static native void CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_get_err(long owner);
	public interface LDKChannelSigner {
		 long get_per_commitment_point(long idx);
		 long release_commitment_secret(long idx);
		 long validate_holder_commitment(long holder_tx, byte[][] outbound_htlc_preimages);
		 long validate_counterparty_revocation(long idx, byte[] secret);
		 byte[] channel_keys_id();
		 void provide_channel_parameters(long channel_parameters);
	}
	public static native long LDKChannelSigner_new(LDKChannelSigner impl, long pubkeys);
	// LDKCResult_PublicKeyNoneZ ChannelSigner_get_per_commitment_point LDKChannelSigner *NONNULL_PTR this_arg, uint64_t idx
	public static native long ChannelSigner_get_per_commitment_point(long this_arg, long idx);
	// LDKCResult__u832NoneZ ChannelSigner_release_commitment_secret LDKChannelSigner *NONNULL_PTR this_arg, uint64_t idx
	public static native long ChannelSigner_release_commitment_secret(long this_arg, long idx);
	// LDKCResult_NoneNoneZ ChannelSigner_validate_holder_commitment LDKChannelSigner *NONNULL_PTR this_arg, const struct LDKHolderCommitmentTransaction *NONNULL_PTR holder_tx, struct LDKCVec_ThirtyTwoBytesZ outbound_htlc_preimages
	public static native long ChannelSigner_validate_holder_commitment(long this_arg, long holder_tx, byte[][] outbound_htlc_preimages);
	// LDKCResult_NoneNoneZ ChannelSigner_validate_counterparty_revocation LDKChannelSigner *NONNULL_PTR this_arg, uint64_t idx, const uint8_t (*secret)[32]
	public static native long ChannelSigner_validate_counterparty_revocation(long this_arg, long idx, byte[] secret);
	// LDKThirtyTwoBytes ChannelSigner_channel_keys_id LDKChannelSigner *NONNULL_PTR this_arg
	public static native byte[] ChannelSigner_channel_keys_id(long this_arg);
	// void ChannelSigner_provide_channel_parameters LDKChannelSigner *NONNULL_PTR this_arg, const struct LDKChannelTransactionParameters *NONNULL_PTR channel_parameters
	public static native void ChannelSigner_provide_channel_parameters(long this_arg, long channel_parameters);
	// LDKChannelPublicKeys ChannelSigner_get_pubkeys LDKChannelSigner *NONNULL_PTR this_arg
	public static native long ChannelSigner_get_pubkeys(long this_arg);
	public interface LDKEcdsaChannelSigner {
		 long sign_counterparty_commitment(long commitment_tx, byte[][] inbound_htlc_preimages, byte[][] outbound_htlc_preimages);
		 long sign_holder_commitment(long commitment_tx);
		 long sign_justice_revoked_output(byte[] justice_tx, long input, long amount, byte[] per_commitment_key);
		 long sign_justice_revoked_htlc(byte[] justice_tx, long input, long amount, byte[] per_commitment_key, long htlc);
		 long sign_holder_htlc_transaction(byte[] htlc_tx, long input, long htlc_descriptor);
		 long sign_counterparty_htlc_transaction(byte[] htlc_tx, long input, long amount, byte[] per_commitment_point, long htlc);
		 long sign_closing_transaction(long closing_tx);
		 long sign_holder_anchor_input(byte[] anchor_tx, long input);
		 long sign_channel_announcement_with_funding_key(long msg);
		 long sign_splicing_funding_input(byte[] tx, long input_index, long input_value);
	}
	public static native long LDKEcdsaChannelSigner_new(LDKEcdsaChannelSigner impl, LDKChannelSigner ChannelSigner, long pubkeys);
	public static native long LDKEcdsaChannelSigner_get_ChannelSigner(long arg);
	// LDKCResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ EcdsaChannelSigner_sign_counterparty_commitment LDKEcdsaChannelSigner *NONNULL_PTR this_arg, const struct LDKCommitmentTransaction *NONNULL_PTR commitment_tx, struct LDKCVec_ThirtyTwoBytesZ inbound_htlc_preimages, struct LDKCVec_ThirtyTwoBytesZ outbound_htlc_preimages
	public static native long EcdsaChannelSigner_sign_counterparty_commitment(long this_arg, long commitment_tx, byte[][] inbound_htlc_preimages, byte[][] outbound_htlc_preimages);
	// LDKCResult_ECDSASignatureNoneZ EcdsaChannelSigner_sign_holder_commitment LDKEcdsaChannelSigner *NONNULL_PTR this_arg, const struct LDKHolderCommitmentTransaction *NONNULL_PTR commitment_tx
	public static native long EcdsaChannelSigner_sign_holder_commitment(long this_arg, long commitment_tx);
	// LDKCResult_ECDSASignatureNoneZ EcdsaChannelSigner_sign_justice_revoked_output LDKEcdsaChannelSigner *NONNULL_PTR this_arg, struct LDKTransaction justice_tx, uintptr_t input, uint64_t amount, const uint8_t (*per_commitment_key)[32]
	public static native long EcdsaChannelSigner_sign_justice_revoked_output(long this_arg, byte[] justice_tx, long input, long amount, byte[] per_commitment_key);
	// LDKCResult_ECDSASignatureNoneZ EcdsaChannelSigner_sign_justice_revoked_htlc LDKEcdsaChannelSigner *NONNULL_PTR this_arg, struct LDKTransaction justice_tx, uintptr_t input, uint64_t amount, const uint8_t (*per_commitment_key)[32], const struct LDKHTLCOutputInCommitment *NONNULL_PTR htlc
	public static native long EcdsaChannelSigner_sign_justice_revoked_htlc(long this_arg, byte[] justice_tx, long input, long amount, byte[] per_commitment_key, long htlc);
	// LDKCResult_ECDSASignatureNoneZ EcdsaChannelSigner_sign_holder_htlc_transaction LDKEcdsaChannelSigner *NONNULL_PTR this_arg, struct LDKTransaction htlc_tx, uintptr_t input, const struct LDKHTLCDescriptor *NONNULL_PTR htlc_descriptor
	public static native long EcdsaChannelSigner_sign_holder_htlc_transaction(long this_arg, byte[] htlc_tx, long input, long htlc_descriptor);
	// LDKCResult_ECDSASignatureNoneZ EcdsaChannelSigner_sign_counterparty_htlc_transaction LDKEcdsaChannelSigner *NONNULL_PTR this_arg, struct LDKTransaction htlc_tx, uintptr_t input, uint64_t amount, struct LDKPublicKey per_commitment_point, const struct LDKHTLCOutputInCommitment *NONNULL_PTR htlc
	public static native long EcdsaChannelSigner_sign_counterparty_htlc_transaction(long this_arg, byte[] htlc_tx, long input, long amount, byte[] per_commitment_point, long htlc);
	// LDKCResult_ECDSASignatureNoneZ EcdsaChannelSigner_sign_closing_transaction LDKEcdsaChannelSigner *NONNULL_PTR this_arg, const struct LDKClosingTransaction *NONNULL_PTR closing_tx
	public static native long EcdsaChannelSigner_sign_closing_transaction(long this_arg, long closing_tx);
	// LDKCResult_ECDSASignatureNoneZ EcdsaChannelSigner_sign_holder_anchor_input LDKEcdsaChannelSigner *NONNULL_PTR this_arg, struct LDKTransaction anchor_tx, uintptr_t input
	public static native long EcdsaChannelSigner_sign_holder_anchor_input(long this_arg, byte[] anchor_tx, long input);
	// LDKCResult_ECDSASignatureNoneZ EcdsaChannelSigner_sign_channel_announcement_with_funding_key LDKEcdsaChannelSigner *NONNULL_PTR this_arg, const struct LDKUnsignedChannelAnnouncement *NONNULL_PTR msg
	public static native long EcdsaChannelSigner_sign_channel_announcement_with_funding_key(long this_arg, long msg);
	// LDKCResult_ECDSASignatureNoneZ EcdsaChannelSigner_sign_splicing_funding_input LDKEcdsaChannelSigner *NONNULL_PTR this_arg, struct LDKTransaction tx, uintptr_t input_index, uint64_t input_value
	public static native long EcdsaChannelSigner_sign_splicing_funding_input(long this_arg, byte[] tx, long input_index, long input_value);
	// struct LDKEcdsaChannelSigner CResult_EcdsaChannelSignerDecodeErrorZ_get_ok(LDKCResult_EcdsaChannelSignerDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_EcdsaChannelSignerDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_EcdsaChannelSignerDecodeErrorZ_get_err(LDKCResult_EcdsaChannelSignerDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_EcdsaChannelSignerDecodeErrorZ_get_err(long owner);
	// struct LDKCVec_u8Z CResult_CVec_u8ZNoneZ_get_ok(LDKCResult_CVec_u8ZNoneZ *NONNULL_PTR owner);
	public static native byte[] CResult_CVec_u8ZNoneZ_get_ok(long owner);
	// void CResult_CVec_u8ZNoneZ_get_err(LDKCResult_CVec_u8ZNoneZ *NONNULL_PTR owner);
	public static native void CResult_CVec_u8ZNoneZ_get_err(long owner);
	// struct LDKShutdownScript CResult_ShutdownScriptNoneZ_get_ok(LDKCResult_ShutdownScriptNoneZ *NONNULL_PTR owner);
	public static native long CResult_ShutdownScriptNoneZ_get_ok(long owner);
	// void CResult_ShutdownScriptNoneZ_get_err(LDKCResult_ShutdownScriptNoneZ *NONNULL_PTR owner);
	public static native void CResult_ShutdownScriptNoneZ_get_err(long owner);
	public static class LDKCOption_u16Z {
		private LDKCOption_u16Z() {}
		public final static class Some extends LDKCOption_u16Z {
			public short some;
			Some(short some) { this.some = some; }
		}
		public final static class None extends LDKCOption_u16Z {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_u16Z.init(); }
	public static native LDKCOption_u16Z LDKCOption_u16Z_ref_from_ptr(long ptr);
	public static class LDKCOption_boolZ {
		private LDKCOption_boolZ() {}
		public final static class Some extends LDKCOption_boolZ {
			public boolean some;
			Some(boolean some) { this.some = some; }
		}
		public final static class None extends LDKCOption_boolZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_boolZ.init(); }
	public static native LDKCOption_boolZ LDKCOption_boolZ_ref_from_ptr(long ptr);
	// struct LDKWitness CResult_WitnessNoneZ_get_ok(LDKCResult_WitnessNoneZ *NONNULL_PTR owner);
	public static native byte[] CResult_WitnessNoneZ_get_ok(long owner);
	// void CResult_WitnessNoneZ_get_err(LDKCResult_WitnessNoneZ *NONNULL_PTR owner);
	public static native void CResult_WitnessNoneZ_get_err(long owner);
	// struct LDKInMemorySigner CResult_InMemorySignerDecodeErrorZ_get_ok(LDKCResult_InMemorySignerDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InMemorySignerDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_InMemorySignerDecodeErrorZ_get_err(LDKCResult_InMemorySignerDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InMemorySignerDecodeErrorZ_get_err(long owner);
	public static class LDKCandidateRouteHop {
		private LDKCandidateRouteHop() {}
		public final static class FirstHop extends LDKCandidateRouteHop {
			public long first_hop;
			FirstHop(long first_hop) { this.first_hop = first_hop; }
		}
		public final static class PublicHop extends LDKCandidateRouteHop {
			public long public_hop;
			PublicHop(long public_hop) { this.public_hop = public_hop; }
		}
		public final static class PrivateHop extends LDKCandidateRouteHop {
			public long private_hop;
			PrivateHop(long private_hop) { this.private_hop = private_hop; }
		}
		public final static class Blinded extends LDKCandidateRouteHop {
			public long blinded;
			Blinded(long blinded) { this.blinded = blinded; }
		}
		public final static class OneHopBlinded extends LDKCandidateRouteHop {
			public long one_hop_blinded;
			OneHopBlinded(long one_hop_blinded) { this.one_hop_blinded = one_hop_blinded; }
		}
		static native void init();
	}
	static { LDKCandidateRouteHop.init(); }
	public static native LDKCandidateRouteHop LDKCandidateRouteHop_ref_from_ptr(long ptr);
	public interface LDKScoreLookUp {
		 long channel_penalty_msat(long candidate, long usage, long score_params);
	}
	public static native long LDKScoreLookUp_new(LDKScoreLookUp impl);
	// uint64_t ScoreLookUp_channel_penalty_msat LDKScoreLookUp *NONNULL_PTR this_arg, const struct LDKCandidateRouteHop *NONNULL_PTR candidate, struct LDKChannelUsage usage, const struct LDKProbabilisticScoringFeeParameters *NONNULL_PTR score_params
	public static native long ScoreLookUp_channel_penalty_msat(long this_arg, long candidate, long usage, long score_params);
	public interface LDKScoreUpdate {
		 void payment_path_failed(long path, long short_channel_id, long duration_since_epoch);
		 void payment_path_successful(long path, long duration_since_epoch);
		 void probe_failed(long path, long short_channel_id, long duration_since_epoch);
		 void probe_successful(long path, long duration_since_epoch);
		 void time_passed(long duration_since_epoch);
	}
	public static native long LDKScoreUpdate_new(LDKScoreUpdate impl);
	// void ScoreUpdate_payment_path_failed LDKScoreUpdate *NONNULL_PTR this_arg, const struct LDKPath *NONNULL_PTR path, uint64_t short_channel_id, uint64_t duration_since_epoch
	public static native void ScoreUpdate_payment_path_failed(long this_arg, long path, long short_channel_id, long duration_since_epoch);
	// void ScoreUpdate_payment_path_successful LDKScoreUpdate *NONNULL_PTR this_arg, const struct LDKPath *NONNULL_PTR path, uint64_t duration_since_epoch
	public static native void ScoreUpdate_payment_path_successful(long this_arg, long path, long duration_since_epoch);
	// void ScoreUpdate_probe_failed LDKScoreUpdate *NONNULL_PTR this_arg, const struct LDKPath *NONNULL_PTR path, uint64_t short_channel_id, uint64_t duration_since_epoch
	public static native void ScoreUpdate_probe_failed(long this_arg, long path, long short_channel_id, long duration_since_epoch);
	// void ScoreUpdate_probe_successful LDKScoreUpdate *NONNULL_PTR this_arg, const struct LDKPath *NONNULL_PTR path, uint64_t duration_since_epoch
	public static native void ScoreUpdate_probe_successful(long this_arg, long path, long duration_since_epoch);
	// void ScoreUpdate_time_passed LDKScoreUpdate *NONNULL_PTR this_arg, uint64_t duration_since_epoch
	public static native void ScoreUpdate_time_passed(long this_arg, long duration_since_epoch);
	public interface LDKLockableScore {
		 long read_lock();
		 long write_lock();
	}
	public static native long LDKLockableScore_new(LDKLockableScore impl);
	// LDKScoreLookUp LockableScore_read_lock LDKLockableScore *NONNULL_PTR this_arg
	public static native long LockableScore_read_lock(long this_arg);
	// LDKScoreUpdate LockableScore_write_lock LDKLockableScore *NONNULL_PTR this_arg
	public static native long LockableScore_write_lock(long this_arg);
	public interface LDKWriteableScore {
		 byte[] write();
	}
	public static native long LDKWriteableScore_new(LDKWriteableScore impl, LDKLockableScore LockableScore);
	public static native long LDKWriteableScore_get_LockableScore(long arg);
	// LDKCVec_u8Z WriteableScore_write LDKWriteableScore *NONNULL_PTR this_arg
	public static native byte[] WriteableScore_write(long this_arg);
	public static class LDKCOption_WriteableScoreZ {
		private LDKCOption_WriteableScoreZ() {}
		public final static class Some extends LDKCOption_WriteableScoreZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_WriteableScoreZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_WriteableScoreZ.init(); }
	public static native LDKCOption_WriteableScoreZ LDKCOption_WriteableScoreZ_ref_from_ptr(long ptr);
	// void CResult_NoneIOErrorZ_get_ok(LDKCResult_NoneIOErrorZ *NONNULL_PTR owner);
	public static native void CResult_NoneIOErrorZ_get_ok(long owner);
	// enum LDKIOError CResult_NoneIOErrorZ_get_err(LDKCResult_NoneIOErrorZ *NONNULL_PTR owner);
	public static native IOError CResult_NoneIOErrorZ_get_err(long owner);
	// struct LDKThirtyTwoBytes C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ_get_a(LDKC3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ *NONNULL_PTR owner);
	public static native byte[] C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ_get_a(long owner);
	// struct LDKRecipientOnionFields C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ_get_b(LDKC3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ *NONNULL_PTR owner);
	public static native long C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ_get_b(long owner);
	// struct LDKRouteParameters C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ_get_c(LDKC3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ *NONNULL_PTR owner);
	public static native long C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ_get_c(long owner);
	// struct LDKC3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_get_ok(LDKCResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ *NONNULL_PTR owner);
	public static native long CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_get_ok(long owner);
	// void CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_get_err(LDKCResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ *NONNULL_PTR owner);
	public static native void CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_get_err(long owner);
	// struct LDKRoute CResult_RouteLightningErrorZ_get_ok(LDKCResult_RouteLightningErrorZ *NONNULL_PTR owner);
	public static native long CResult_RouteLightningErrorZ_get_ok(long owner);
	// struct LDKLightningError CResult_RouteLightningErrorZ_get_err(LDKCResult_RouteLightningErrorZ *NONNULL_PTR owner);
	public static native long CResult_RouteLightningErrorZ_get_err(long owner);
	// struct LDKCVec_BlindedPaymentPathZ CResult_CVec_BlindedPaymentPathZNoneZ_get_ok(LDKCResult_CVec_BlindedPaymentPathZNoneZ *NONNULL_PTR owner);
	public static native long[] CResult_CVec_BlindedPaymentPathZNoneZ_get_ok(long owner);
	// void CResult_CVec_BlindedPaymentPathZNoneZ_get_err(LDKCResult_CVec_BlindedPaymentPathZNoneZ *NONNULL_PTR owner);
	public static native void CResult_CVec_BlindedPaymentPathZNoneZ_get_err(long owner);
	// struct LDKInFlightHtlcs CResult_InFlightHtlcsDecodeErrorZ_get_ok(LDKCResult_InFlightHtlcsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InFlightHtlcsDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_InFlightHtlcsDecodeErrorZ_get_err(LDKCResult_InFlightHtlcsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InFlightHtlcsDecodeErrorZ_get_err(long owner);
	// struct LDKRouteHop CResult_RouteHopDecodeErrorZ_get_ok(LDKCResult_RouteHopDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RouteHopDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_RouteHopDecodeErrorZ_get_err(LDKCResult_RouteHopDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RouteHopDecodeErrorZ_get_err(long owner);
	// struct LDKBlindedTail CResult_BlindedTailDecodeErrorZ_get_ok(LDKCResult_BlindedTailDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BlindedTailDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_BlindedTailDecodeErrorZ_get_err(LDKCResult_BlindedTailDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BlindedTailDecodeErrorZ_get_err(long owner);
	// struct LDKRoute CResult_RouteDecodeErrorZ_get_ok(LDKCResult_RouteDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RouteDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_RouteDecodeErrorZ_get_err(LDKCResult_RouteDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RouteDecodeErrorZ_get_err(long owner);
	// struct LDKRouteParameters CResult_RouteParametersDecodeErrorZ_get_ok(LDKCResult_RouteParametersDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RouteParametersDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_RouteParametersDecodeErrorZ_get_err(LDKCResult_RouteParametersDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RouteParametersDecodeErrorZ_get_err(long owner);
	// struct LDKPaymentParameters CResult_PaymentParametersDecodeErrorZ_get_ok(LDKCResult_PaymentParametersDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PaymentParametersDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_PaymentParametersDecodeErrorZ_get_err(LDKCResult_PaymentParametersDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PaymentParametersDecodeErrorZ_get_err(long owner);
	// struct LDKRouteHint CResult_RouteHintDecodeErrorZ_get_ok(LDKCResult_RouteHintDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RouteHintDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_RouteHintDecodeErrorZ_get_err(LDKCResult_RouteHintDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RouteHintDecodeErrorZ_get_err(long owner);
	// struct LDKRouteHintHop CResult_RouteHintHopDecodeErrorZ_get_ok(LDKCResult_RouteHintHopDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RouteHintHopDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_RouteHintHopDecodeErrorZ_get_err(LDKCResult_RouteHintHopDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RouteHintHopDecodeErrorZ_get_err(long owner);
	// struct LDKFixedPenaltyScorer CResult_FixedPenaltyScorerDecodeErrorZ_get_ok(LDKCResult_FixedPenaltyScorerDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_FixedPenaltyScorerDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_FixedPenaltyScorerDecodeErrorZ_get_err(LDKCResult_FixedPenaltyScorerDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_FixedPenaltyScorerDecodeErrorZ_get_err(long owner);
	// uint64_t C2Tuple_u64u64Z_get_a(LDKC2Tuple_u64u64Z *NONNULL_PTR owner);
	public static native long C2Tuple_u64u64Z_get_a(long owner);
	// uint64_t C2Tuple_u64u64Z_get_b(LDKC2Tuple_u64u64Z *NONNULL_PTR owner);
	public static native long C2Tuple_u64u64Z_get_b(long owner);
	public static class LDKCOption_C2Tuple_u64u64ZZ {
		private LDKCOption_C2Tuple_u64u64ZZ() {}
		public final static class Some extends LDKCOption_C2Tuple_u64u64ZZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_C2Tuple_u64u64ZZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_C2Tuple_u64u64ZZ.init(); }
	public static native LDKCOption_C2Tuple_u64u64ZZ LDKCOption_C2Tuple_u64u64ZZ_ref_from_ptr(long ptr);
	// struct LDKThirtyTwoU16s C2Tuple_Z_get_a(LDKC2Tuple_Z *NONNULL_PTR owner);
	public static native short[] C2Tuple_Z_get_a(long owner);
	// struct LDKThirtyTwoU16s C2Tuple_Z_get_b(LDKC2Tuple_Z *NONNULL_PTR owner);
	public static native short[] C2Tuple_Z_get_b(long owner);
	// struct LDKThirtyTwoU16s C2Tuple__u1632_u1632Z_get_a(LDKC2Tuple__u1632_u1632Z *NONNULL_PTR owner);
	public static native short[] C2Tuple__u1632_u1632Z_get_a(long owner);
	// struct LDKThirtyTwoU16s C2Tuple__u1632_u1632Z_get_b(LDKC2Tuple__u1632_u1632Z *NONNULL_PTR owner);
	public static native short[] C2Tuple__u1632_u1632Z_get_b(long owner);
	public static class LDKCOption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ {
		private LDKCOption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ() {}
		public final static class Some extends LDKCOption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ.init(); }
	public static native LDKCOption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ LDKCOption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ_ref_from_ptr(long ptr);
	public static class LDKCOption_f64Z {
		private LDKCOption_f64Z() {}
		public final static class Some extends LDKCOption_f64Z {
			public double some;
			Some(double some) { this.some = some; }
		}
		public final static class None extends LDKCOption_f64Z {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_f64Z.init(); }
	public static native LDKCOption_f64Z LDKCOption_f64Z_ref_from_ptr(long ptr);
	public interface LDKLogger {
		 void log(long record);
	}
	public static native long LDKLogger_new(LDKLogger impl);
	// struct LDKProbabilisticScorer CResult_ProbabilisticScorerDecodeErrorZ_get_ok(LDKCResult_ProbabilisticScorerDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ProbabilisticScorerDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ProbabilisticScorerDecodeErrorZ_get_err(LDKCResult_ProbabilisticScorerDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ProbabilisticScorerDecodeErrorZ_get_err(long owner);
	// struct LDKBestBlock CResult_BestBlockDecodeErrorZ_get_ok(LDKCResult_BestBlockDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BestBlockDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_BestBlockDecodeErrorZ_get_err(LDKCResult_BestBlockDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BestBlockDecodeErrorZ_get_err(long owner);
	// uintptr_t C2Tuple_usizeTransactionZ_get_a(LDKC2Tuple_usizeTransactionZ *NONNULL_PTR owner);
	public static native long C2Tuple_usizeTransactionZ_get_a(long owner);
	// struct LDKTransaction C2Tuple_usizeTransactionZ_get_b(LDKC2Tuple_usizeTransactionZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_usizeTransactionZ_get_b(long owner);
	// struct LDKThirtyTwoBytes C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ_get_a(LDKC3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ *NONNULL_PTR owner);
	public static native byte[] C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ_get_a(long owner);
	// uint32_t C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ_get_b(LDKC3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ *NONNULL_PTR owner);
	public static native int C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ_get_b(long owner);
	// struct LDKCOption_ThirtyTwoBytesZ C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ_get_c(LDKC3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ *NONNULL_PTR owner);
	public static native long C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ_get_c(long owner);
	// enum LDKChannelMonitorUpdateStatus CResult_ChannelMonitorUpdateStatusNoneZ_get_ok(LDKCResult_ChannelMonitorUpdateStatusNoneZ *NONNULL_PTR owner);
	public static native ChannelMonitorUpdateStatus CResult_ChannelMonitorUpdateStatusNoneZ_get_ok(long owner);
	// void CResult_ChannelMonitorUpdateStatusNoneZ_get_err(LDKCResult_ChannelMonitorUpdateStatusNoneZ *NONNULL_PTR owner);
	public static native void CResult_ChannelMonitorUpdateStatusNoneZ_get_err(long owner);
	public static class LDKClosureReason {
		private LDKClosureReason() {}
		public final static class CounterpartyForceClosed extends LDKClosureReason {
			public long peer_msg;
			CounterpartyForceClosed(long peer_msg) { this.peer_msg = peer_msg; }
		}
		public final static class HolderForceClosed extends LDKClosureReason {
			public long broadcasted_latest_txn;
			HolderForceClosed(long broadcasted_latest_txn) { this.broadcasted_latest_txn = broadcasted_latest_txn; }
		}
		public final static class LegacyCooperativeClosure extends LDKClosureReason {
			LegacyCooperativeClosure() { }
		}
		public final static class CounterpartyInitiatedCooperativeClosure extends LDKClosureReason {
			CounterpartyInitiatedCooperativeClosure() { }
		}
		public final static class LocallyInitiatedCooperativeClosure extends LDKClosureReason {
			LocallyInitiatedCooperativeClosure() { }
		}
		public final static class CommitmentTxConfirmed extends LDKClosureReason {
			CommitmentTxConfirmed() { }
		}
		public final static class FundingTimedOut extends LDKClosureReason {
			FundingTimedOut() { }
		}
		public final static class ProcessingError extends LDKClosureReason {
			public java.lang.String err;
			ProcessingError(java.lang.String err) { this.err = err; }
		}
		public final static class DisconnectedPeer extends LDKClosureReason {
			DisconnectedPeer() { }
		}
		public final static class OutdatedChannelManager extends LDKClosureReason {
			OutdatedChannelManager() { }
		}
		public final static class CounterpartyCoopClosedUnfundedChannel extends LDKClosureReason {
			CounterpartyCoopClosedUnfundedChannel() { }
		}
		public final static class FundingBatchClosure extends LDKClosureReason {
			FundingBatchClosure() { }
		}
		public final static class HTLCsTimedOut extends LDKClosureReason {
			HTLCsTimedOut() { }
		}
		public final static class PeerFeerateTooLow extends LDKClosureReason {
			public int peer_feerate_sat_per_kw;
			public int required_feerate_sat_per_kw;
			PeerFeerateTooLow(int peer_feerate_sat_per_kw, int required_feerate_sat_per_kw) { this.peer_feerate_sat_per_kw = peer_feerate_sat_per_kw; this.required_feerate_sat_per_kw = required_feerate_sat_per_kw; }
		}
		static native void init();
	}
	static { LDKClosureReason.init(); }
	public static native LDKClosureReason LDKClosureReason_ref_from_ptr(long ptr);
	public static class LDKMonitorEvent {
		private LDKMonitorEvent() {}
		public final static class HTLCEvent extends LDKMonitorEvent {
			public long htlc_event;
			HTLCEvent(long htlc_event) { this.htlc_event = htlc_event; }
		}
		public final static class HolderForceClosedWithInfo extends LDKMonitorEvent {
			public long reason;
			public long outpoint;
			public long channel_id;
			HolderForceClosedWithInfo(long reason, long outpoint, long channel_id) { this.reason = reason; this.outpoint = outpoint; this.channel_id = channel_id; }
		}
		public final static class HolderForceClosed extends LDKMonitorEvent {
			public long holder_force_closed;
			HolderForceClosed(long holder_force_closed) { this.holder_force_closed = holder_force_closed; }
		}
		public final static class Completed extends LDKMonitorEvent {
			public long funding_txo;
			public long channel_id;
			public long monitor_update_id;
			Completed(long funding_txo, long channel_id, long monitor_update_id) { this.funding_txo = funding_txo; this.channel_id = channel_id; this.monitor_update_id = monitor_update_id; }
		}
		static native void init();
	}
	static { LDKMonitorEvent.init(); }
	public static native LDKMonitorEvent LDKMonitorEvent_ref_from_ptr(long ptr);
	// struct LDKOutPoint C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_get_a(LDKC4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ *NONNULL_PTR owner);
	public static native long C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_get_a(long owner);
	// struct LDKChannelId C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_get_b(LDKC4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ *NONNULL_PTR owner);
	public static native long C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_get_b(long owner);
	// struct LDKCVec_MonitorEventZ C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_get_c(LDKC4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ *NONNULL_PTR owner);
	public static native long[] C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_get_c(long owner);
	// struct LDKPublicKey C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_get_d(LDKC4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ *NONNULL_PTR owner);
	public static native byte[] C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_get_d(long owner);
	public static class LDKCOption_StrZ {
		private LDKCOption_StrZ() {}
		public final static class Some extends LDKCOption_StrZ {
			public java.lang.String some;
			Some(java.lang.String some) { this.some = some; }
		}
		public final static class None extends LDKCOption_StrZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_StrZ.init(); }
	public static native LDKCOption_StrZ LDKCOption_StrZ_ref_from_ptr(long ptr);
	public static class LDKAPIError {
		private LDKAPIError() {}
		public final static class APIMisuseError extends LDKAPIError {
			public java.lang.String err;
			APIMisuseError(java.lang.String err) { this.err = err; }
		}
		public final static class FeeRateTooHigh extends LDKAPIError {
			public java.lang.String err;
			public int feerate;
			FeeRateTooHigh(java.lang.String err, int feerate) { this.err = err; this.feerate = feerate; }
		}
		public final static class InvalidRoute extends LDKAPIError {
			public java.lang.String err;
			InvalidRoute(java.lang.String err) { this.err = err; }
		}
		public final static class ChannelUnavailable extends LDKAPIError {
			public java.lang.String err;
			ChannelUnavailable(java.lang.String err) { this.err = err; }
		}
		public final static class MonitorUpdateInProgress extends LDKAPIError {
			MonitorUpdateInProgress() { }
		}
		public final static class IncompatibleShutdownScript extends LDKAPIError {
			public long script;
			IncompatibleShutdownScript(long script) { this.script = script; }
		}
		static native void init();
	}
	static { LDKAPIError.init(); }
	public static native LDKAPIError LDKAPIError_ref_from_ptr(long ptr);
	// struct LDKLSPSRequestId CResult_LSPSRequestIdAPIErrorZ_get_ok(LDKCResult_LSPSRequestIdAPIErrorZ *NONNULL_PTR owner);
	public static native long CResult_LSPSRequestIdAPIErrorZ_get_ok(long owner);
	// struct LDKAPIError CResult_LSPSRequestIdAPIErrorZ_get_err(LDKCResult_LSPSRequestIdAPIErrorZ *NONNULL_PTR owner);
	public static native long CResult_LSPSRequestIdAPIErrorZ_get_err(long owner);
	// struct LDKOfferId CResult_OfferIdDecodeErrorZ_get_ok(LDKCResult_OfferIdDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OfferIdDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_OfferIdDecodeErrorZ_get_err(LDKCResult_OfferIdDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OfferIdDecodeErrorZ_get_err(long owner);
	// void CResult_NoneBolt12SemanticErrorZ_get_ok(LDKCResult_NoneBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native void CResult_NoneBolt12SemanticErrorZ_get_ok(long owner);
	// enum LDKBolt12SemanticError CResult_NoneBolt12SemanticErrorZ_get_err(LDKCResult_NoneBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native Bolt12SemanticError CResult_NoneBolt12SemanticErrorZ_get_err(long owner);
	// struct LDKOffer CResult_OfferBolt12SemanticErrorZ_get_ok(LDKCResult_OfferBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native long CResult_OfferBolt12SemanticErrorZ_get_ok(long owner);
	// enum LDKBolt12SemanticError CResult_OfferBolt12SemanticErrorZ_get_err(LDKCResult_OfferBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native Bolt12SemanticError CResult_OfferBolt12SemanticErrorZ_get_err(long owner);
	// struct LDKInvoiceRequestWithDerivedPayerSigningPubkeyBuilder CResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ_get_ok(LDKCResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native long CResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ_get_ok(long owner);
	// enum LDKBolt12SemanticError CResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ_get_err(LDKCResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native Bolt12SemanticError CResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ_get_err(long owner);
	// struct LDKOffer CResult_OfferDecodeErrorZ_get_ok(LDKCResult_OfferDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OfferDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_OfferDecodeErrorZ_get_err(LDKCResult_OfferDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OfferDecodeErrorZ_get_err(long owner);
	// struct LDKOffer CResult_OfferBolt12ParseErrorZ_get_ok(LDKCResult_OfferBolt12ParseErrorZ *NONNULL_PTR owner);
	public static native long CResult_OfferBolt12ParseErrorZ_get_ok(long owner);
	// struct LDKBolt12ParseError CResult_OfferBolt12ParseErrorZ_get_err(LDKCResult_OfferBolt12ParseErrorZ *NONNULL_PTR owner);
	public static native long CResult_OfferBolt12ParseErrorZ_get_err(long owner);
	// struct LDKNodeId CResult_NodeIdDecodeErrorZ_get_ok(LDKCResult_NodeIdDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NodeIdDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_NodeIdDecodeErrorZ_get_err(LDKCResult_NodeIdDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NodeIdDecodeErrorZ_get_err(long owner);
	// struct LDKPublicKey CResult_PublicKeySecp256k1ErrorZ_get_ok(LDKCResult_PublicKeySecp256k1ErrorZ *NONNULL_PTR owner);
	public static native byte[] CResult_PublicKeySecp256k1ErrorZ_get_ok(long owner);
	// enum LDKSecp256k1Error CResult_PublicKeySecp256k1ErrorZ_get_err(LDKCResult_PublicKeySecp256k1ErrorZ *NONNULL_PTR owner);
	public static native Secp256k1Error CResult_PublicKeySecp256k1ErrorZ_get_err(long owner);
	public static class LDKNetworkUpdate {
		private LDKNetworkUpdate() {}
		public final static class ChannelFailure extends LDKNetworkUpdate {
			public long short_channel_id;
			public boolean is_permanent;
			ChannelFailure(long short_channel_id, boolean is_permanent) { this.short_channel_id = short_channel_id; this.is_permanent = is_permanent; }
		}
		public final static class NodeFailure extends LDKNetworkUpdate {
			public byte[] node_id;
			public boolean is_permanent;
			NodeFailure(byte[] node_id, boolean is_permanent) { this.node_id = node_id; this.is_permanent = is_permanent; }
		}
		static native void init();
	}
	static { LDKNetworkUpdate.init(); }
	public static native LDKNetworkUpdate LDKNetworkUpdate_ref_from_ptr(long ptr);
	public static class LDKCOption_NetworkUpdateZ {
		private LDKCOption_NetworkUpdateZ() {}
		public final static class Some extends LDKCOption_NetworkUpdateZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_NetworkUpdateZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_NetworkUpdateZ.init(); }
	public static native LDKCOption_NetworkUpdateZ LDKCOption_NetworkUpdateZ_ref_from_ptr(long ptr);
	// struct LDKCOption_NetworkUpdateZ CResult_COption_NetworkUpdateZDecodeErrorZ_get_ok(LDKCResult_COption_NetworkUpdateZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_NetworkUpdateZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_COption_NetworkUpdateZDecodeErrorZ_get_err(LDKCResult_COption_NetworkUpdateZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_NetworkUpdateZDecodeErrorZ_get_err(long owner);
	// struct LDKTxOut CResult_TxOutUtxoLookupErrorZ_get_ok(LDKCResult_TxOutUtxoLookupErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxOutUtxoLookupErrorZ_get_ok(long owner);
	// enum LDKUtxoLookupError CResult_TxOutUtxoLookupErrorZ_get_err(LDKCResult_TxOutUtxoLookupErrorZ *NONNULL_PTR owner);
	public static native UtxoLookupError CResult_TxOutUtxoLookupErrorZ_get_err(long owner);
	public static class LDKUtxoResult {
		private LDKUtxoResult() {}
		public final static class Sync extends LDKUtxoResult {
			public long sync;
			Sync(long sync) { this.sync = sync; }
		}
		public final static class Async extends LDKUtxoResult {
			public long async;
			Async(long async) { this.async = async; }
		}
		static native void init();
	}
	static { LDKUtxoResult.init(); }
	public static native LDKUtxoResult LDKUtxoResult_ref_from_ptr(long ptr);
	public interface LDKUtxoLookup {
		 long get_utxo(byte[] chain_hash, long short_channel_id);
	}
	public static native long LDKUtxoLookup_new(LDKUtxoLookup impl);
	// LDKUtxoResult UtxoLookup_get_utxo LDKUtxoLookup *NONNULL_PTR this_arg, const uint8_t (*chain_hash)[32], uint64_t short_channel_id
	public static native long UtxoLookup_get_utxo(long this_arg, byte[] chain_hash, long short_channel_id);
	public static class LDKCOption_UtxoLookupZ {
		private LDKCOption_UtxoLookupZ() {}
		public final static class Some extends LDKCOption_UtxoLookupZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_UtxoLookupZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_UtxoLookupZ.init(); }
	public static native LDKCOption_UtxoLookupZ LDKCOption_UtxoLookupZ_ref_from_ptr(long ptr);
	// void CResult_NoneLightningErrorZ_get_ok(LDKCResult_NoneLightningErrorZ *NONNULL_PTR owner);
	public static native void CResult_NoneLightningErrorZ_get_ok(long owner);
	// struct LDKLightningError CResult_NoneLightningErrorZ_get_err(LDKCResult_NoneLightningErrorZ *NONNULL_PTR owner);
	public static native long CResult_NoneLightningErrorZ_get_err(long owner);
	// bool CResult_boolLightningErrorZ_get_ok(LDKCResult_boolLightningErrorZ *NONNULL_PTR owner);
	public static native boolean CResult_boolLightningErrorZ_get_ok(long owner);
	// struct LDKLightningError CResult_boolLightningErrorZ_get_err(LDKCResult_boolLightningErrorZ *NONNULL_PTR owner);
	public static native long CResult_boolLightningErrorZ_get_err(long owner);
	// struct LDKChannelAnnouncement C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ_get_a(LDKC3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ *NONNULL_PTR owner);
	public static native long C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ_get_a(long owner);
	// struct LDKChannelUpdate C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ_get_b(LDKC3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ *NONNULL_PTR owner);
	public static native long C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ_get_b(long owner);
	// struct LDKChannelUpdate C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ_get_c(LDKC3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ *NONNULL_PTR owner);
	public static native long C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ_get_c(long owner);
	public static class LDKCOption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ {
		private LDKCOption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ() {}
		public final static class Some extends LDKCOption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ.init(); }
	public static native LDKCOption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ LDKCOption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ_ref_from_ptr(long ptr);
	public static class LDKErrorAction {
		private LDKErrorAction() {}
		public final static class DisconnectPeer extends LDKErrorAction {
			public long msg;
			DisconnectPeer(long msg) { this.msg = msg; }
		}
		public final static class DisconnectPeerWithWarning extends LDKErrorAction {
			public long msg;
			DisconnectPeerWithWarning(long msg) { this.msg = msg; }
		}
		public final static class IgnoreError extends LDKErrorAction {
			IgnoreError() { }
		}
		public final static class IgnoreAndLog extends LDKErrorAction {
			public org.ldk.enums.Level ignore_and_log;
			IgnoreAndLog(org.ldk.enums.Level ignore_and_log) { this.ignore_and_log = ignore_and_log; }
		}
		public final static class IgnoreDuplicateGossip extends LDKErrorAction {
			IgnoreDuplicateGossip() { }
		}
		public final static class SendErrorMessage extends LDKErrorAction {
			public long msg;
			SendErrorMessage(long msg) { this.msg = msg; }
		}
		public final static class SendWarningMessage extends LDKErrorAction {
			public long msg;
			public org.ldk.enums.Level log_level;
			SendWarningMessage(long msg, org.ldk.enums.Level log_level) { this.msg = msg; this.log_level = log_level; }
		}
		static native void init();
	}
	static { LDKErrorAction.init(); }
	public static native LDKErrorAction LDKErrorAction_ref_from_ptr(long ptr);
	public static class LDKMessageSendEvent {
		private LDKMessageSendEvent() {}
		public final static class SendAcceptChannel extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendAcceptChannel(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendAcceptChannelV2 extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendAcceptChannelV2(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendOpenChannel extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendOpenChannel(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendOpenChannelV2 extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendOpenChannelV2(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendFundingCreated extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendFundingCreated(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendFundingSigned extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendFundingSigned(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendStfu extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendStfu(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendSpliceInit extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendSpliceInit(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendSpliceAck extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendSpliceAck(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendSpliceLocked extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendSpliceLocked(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendTxAddInput extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendTxAddInput(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendTxAddOutput extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendTxAddOutput(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendTxRemoveInput extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendTxRemoveInput(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendTxRemoveOutput extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendTxRemoveOutput(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendTxComplete extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendTxComplete(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendTxSignatures extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendTxSignatures(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendTxInitRbf extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendTxInitRbf(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendTxAckRbf extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendTxAckRbf(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendTxAbort extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendTxAbort(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendChannelReady extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendChannelReady(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendAnnouncementSignatures extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendAnnouncementSignatures(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class UpdateHTLCs extends LDKMessageSendEvent {
			public byte[] node_id;
			public long updates;
			UpdateHTLCs(byte[] node_id, long updates) { this.node_id = node_id; this.updates = updates; }
		}
		public final static class SendRevokeAndACK extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendRevokeAndACK(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendClosingSigned extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendClosingSigned(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendShutdown extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendShutdown(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendChannelReestablish extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendChannelReestablish(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendChannelAnnouncement extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			public long update_msg;
			SendChannelAnnouncement(byte[] node_id, long msg, long update_msg) { this.node_id = node_id; this.msg = msg; this.update_msg = update_msg; }
		}
		public final static class BroadcastChannelAnnouncement extends LDKMessageSendEvent {
			public long msg;
			public long update_msg;
			BroadcastChannelAnnouncement(long msg, long update_msg) { this.msg = msg; this.update_msg = update_msg; }
		}
		public final static class BroadcastChannelUpdate extends LDKMessageSendEvent {
			public long msg;
			BroadcastChannelUpdate(long msg) { this.msg = msg; }
		}
		public final static class BroadcastNodeAnnouncement extends LDKMessageSendEvent {
			public long msg;
			BroadcastNodeAnnouncement(long msg) { this.msg = msg; }
		}
		public final static class SendChannelUpdate extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendChannelUpdate(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class HandleError extends LDKMessageSendEvent {
			public byte[] node_id;
			public long action;
			HandleError(byte[] node_id, long action) { this.node_id = node_id; this.action = action; }
		}
		public final static class SendChannelRangeQuery extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendChannelRangeQuery(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendShortIdsQuery extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendShortIdsQuery(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendReplyChannelRange extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendReplyChannelRange(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		public final static class SendGossipTimestampFilter extends LDKMessageSendEvent {
			public byte[] node_id;
			public long msg;
			SendGossipTimestampFilter(byte[] node_id, long msg) { this.node_id = node_id; this.msg = msg; }
		}
		static native void init();
	}
	static { LDKMessageSendEvent.init(); }
	public static native LDKMessageSendEvent LDKMessageSendEvent_ref_from_ptr(long ptr);
	// struct LDKChannelUpdateInfo CResult_ChannelUpdateInfoDecodeErrorZ_get_ok(LDKCResult_ChannelUpdateInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelUpdateInfoDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelUpdateInfoDecodeErrorZ_get_err(LDKCResult_ChannelUpdateInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelUpdateInfoDecodeErrorZ_get_err(long owner);
	// struct LDKChannelInfo CResult_ChannelInfoDecodeErrorZ_get_ok(LDKCResult_ChannelInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelInfoDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelInfoDecodeErrorZ_get_err(LDKCResult_ChannelInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelInfoDecodeErrorZ_get_err(long owner);
	// struct LDKRoutingFees CResult_RoutingFeesDecodeErrorZ_get_ok(LDKCResult_RoutingFeesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RoutingFeesDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_RoutingFeesDecodeErrorZ_get_err(LDKCResult_RoutingFeesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RoutingFeesDecodeErrorZ_get_err(long owner);
	public static class LDKSocketAddress {
		private LDKSocketAddress() {}
		public final static class TcpIpV4 extends LDKSocketAddress {
			public byte[] addr;
			public short port;
			TcpIpV4(byte[] addr, short port) { this.addr = addr; this.port = port; }
		}
		public final static class TcpIpV6 extends LDKSocketAddress {
			public byte[] addr;
			public short port;
			TcpIpV6(byte[] addr, short port) { this.addr = addr; this.port = port; }
		}
		public final static class OnionV2 extends LDKSocketAddress {
			public byte[] onion_v2;
			OnionV2(byte[] onion_v2) { this.onion_v2 = onion_v2; }
		}
		public final static class OnionV3 extends LDKSocketAddress {
			public byte[] ed25519_pubkey;
			public short checksum;
			public byte version;
			public short port;
			OnionV3(byte[] ed25519_pubkey, short checksum, byte version, short port) { this.ed25519_pubkey = ed25519_pubkey; this.checksum = checksum; this.version = version; this.port = port; }
		}
		public final static class Hostname extends LDKSocketAddress {
			public long hostname;
			public short port;
			Hostname(long hostname, short port) { this.hostname = hostname; this.port = port; }
		}
		static native void init();
	}
	static { LDKSocketAddress.init(); }
	public static native LDKSocketAddress LDKSocketAddress_ref_from_ptr(long ptr);
	public static class LDKNodeAnnouncementInfo {
		private LDKNodeAnnouncementInfo() {}
		public final static class Relayed extends LDKNodeAnnouncementInfo {
			public long relayed;
			Relayed(long relayed) { this.relayed = relayed; }
		}
		public final static class Local extends LDKNodeAnnouncementInfo {
			public long local;
			Local(long local) { this.local = local; }
		}
		static native void init();
	}
	static { LDKNodeAnnouncementInfo.init(); }
	public static native LDKNodeAnnouncementInfo LDKNodeAnnouncementInfo_ref_from_ptr(long ptr);
	// struct LDKNodeAnnouncementInfo CResult_NodeAnnouncementInfoDecodeErrorZ_get_ok(LDKCResult_NodeAnnouncementInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NodeAnnouncementInfoDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_NodeAnnouncementInfoDecodeErrorZ_get_err(LDKCResult_NodeAnnouncementInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NodeAnnouncementInfoDecodeErrorZ_get_err(long owner);
	// struct LDKNodeAlias CResult_NodeAliasDecodeErrorZ_get_ok(LDKCResult_NodeAliasDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NodeAliasDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_NodeAliasDecodeErrorZ_get_err(LDKCResult_NodeAliasDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NodeAliasDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_NodeAnnouncementInfoZ {
		private LDKCOption_NodeAnnouncementInfoZ() {}
		public final static class Some extends LDKCOption_NodeAnnouncementInfoZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_NodeAnnouncementInfoZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_NodeAnnouncementInfoZ.init(); }
	public static native LDKCOption_NodeAnnouncementInfoZ LDKCOption_NodeAnnouncementInfoZ_ref_from_ptr(long ptr);
	// struct LDKNodeInfo CResult_NodeInfoDecodeErrorZ_get_ok(LDKCResult_NodeInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NodeInfoDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_NodeInfoDecodeErrorZ_get_err(LDKCResult_NodeInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NodeInfoDecodeErrorZ_get_err(long owner);
	// struct LDKNetworkGraph CResult_NetworkGraphDecodeErrorZ_get_ok(LDKCResult_NetworkGraphDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NetworkGraphDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_NetworkGraphDecodeErrorZ_get_err(LDKCResult_NetworkGraphDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NetworkGraphDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_CVec_SocketAddressZZ {
		private LDKCOption_CVec_SocketAddressZZ() {}
		public final static class Some extends LDKCOption_CVec_SocketAddressZZ {
			public long[] some;
			Some(long[] some) { this.some = some; }
		}
		public final static class None extends LDKCOption_CVec_SocketAddressZZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_CVec_SocketAddressZZ.init(); }
	public static native LDKCOption_CVec_SocketAddressZZ LDKCOption_CVec_SocketAddressZZ_ref_from_ptr(long ptr);
	// uint64_t CResult_u64ShortChannelIdErrorZ_get_ok(LDKCResult_u64ShortChannelIdErrorZ *NONNULL_PTR owner);
	public static native long CResult_u64ShortChannelIdErrorZ_get_ok(long owner);
	// enum LDKShortChannelIdError CResult_u64ShortChannelIdErrorZ_get_err(LDKCResult_u64ShortChannelIdErrorZ *NONNULL_PTR owner);
	public static native ShortChannelIdError CResult_u64ShortChannelIdErrorZ_get_err(long owner);
	// struct LDKPendingHTLCInfo CResult_PendingHTLCInfoInboundHTLCErrZ_get_ok(LDKCResult_PendingHTLCInfoInboundHTLCErrZ *NONNULL_PTR owner);
	public static native long CResult_PendingHTLCInfoInboundHTLCErrZ_get_ok(long owner);
	// struct LDKInboundHTLCErr CResult_PendingHTLCInfoInboundHTLCErrZ_get_err(LDKCResult_PendingHTLCInfoInboundHTLCErrZ *NONNULL_PTR owner);
	public static native long CResult_PendingHTLCInfoInboundHTLCErrZ_get_err(long owner);
	public static class LDKCOption_TxOutZ {
		private LDKCOption_TxOutZ() {}
		public final static class Some extends LDKCOption_TxOutZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_TxOutZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_TxOutZ.init(); }
	public static native LDKCOption_TxOutZ LDKCOption_TxOutZ_ref_from_ptr(long ptr);
	// struct LDKCoinSelection CResult_CoinSelectionNoneZ_get_ok(LDKCResult_CoinSelectionNoneZ *NONNULL_PTR owner);
	public static native long CResult_CoinSelectionNoneZ_get_ok(long owner);
	// void CResult_CoinSelectionNoneZ_get_err(LDKCResult_CoinSelectionNoneZ *NONNULL_PTR owner);
	public static native void CResult_CoinSelectionNoneZ_get_err(long owner);
	// struct LDKCVec_UtxoZ CResult_CVec_UtxoZNoneZ_get_ok(LDKCResult_CVec_UtxoZNoneZ *NONNULL_PTR owner);
	public static native long[] CResult_CVec_UtxoZNoneZ_get_ok(long owner);
	// void CResult_CVec_UtxoZNoneZ_get_err(LDKCResult_CVec_UtxoZNoneZ *NONNULL_PTR owner);
	public static native void CResult_CVec_UtxoZNoneZ_get_err(long owner);
	public static class LDKPaymentContext {
		private LDKPaymentContext() {}
		public final static class Bolt12Offer extends LDKPaymentContext {
			public long bolt12_offer;
			Bolt12Offer(long bolt12_offer) { this.bolt12_offer = bolt12_offer; }
		}
		public final static class Bolt12Refund extends LDKPaymentContext {
			public long bolt12_refund;
			Bolt12Refund(long bolt12_refund) { this.bolt12_refund = bolt12_refund; }
		}
		static native void init();
	}
	static { LDKPaymentContext.init(); }
	public static native LDKPaymentContext LDKPaymentContext_ref_from_ptr(long ptr);
	public static class LDKCOption_PaymentContextZ {
		private LDKCOption_PaymentContextZ() {}
		public final static class Some extends LDKCOption_PaymentContextZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_PaymentContextZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_PaymentContextZ.init(); }
	public static native LDKCOption_PaymentContextZ LDKCOption_PaymentContextZ_ref_from_ptr(long ptr);
	// uint64_t C2Tuple_u64u16Z_get_a(LDKC2Tuple_u64u16Z *NONNULL_PTR owner);
	public static native long C2Tuple_u64u16Z_get_a(long owner);
	// uint16_t C2Tuple_u64u16Z_get_b(LDKC2Tuple_u64u16Z *NONNULL_PTR owner);
	public static native short C2Tuple_u64u16Z_get_b(long owner);
	public static class LDKCOption_C2Tuple_u64u16ZZ {
		private LDKCOption_C2Tuple_u64u16ZZ() {}
		public final static class Some extends LDKCOption_C2Tuple_u64u16ZZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_C2Tuple_u64u16ZZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_C2Tuple_u64u16ZZ.init(); }
	public static native LDKCOption_C2Tuple_u64u16ZZ LDKCOption_C2Tuple_u64u16ZZ_ref_from_ptr(long ptr);
	// struct LDKChannelId CResult_ChannelIdAPIErrorZ_get_ok(LDKCResult_ChannelIdAPIErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelIdAPIErrorZ_get_ok(long owner);
	// struct LDKAPIError CResult_ChannelIdAPIErrorZ_get_err(LDKCResult_ChannelIdAPIErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelIdAPIErrorZ_get_err(long owner);
	public static class LDKRecentPaymentDetails {
		private LDKRecentPaymentDetails() {}
		public final static class AwaitingInvoice extends LDKRecentPaymentDetails {
			public byte[] payment_id;
			AwaitingInvoice(byte[] payment_id) { this.payment_id = payment_id; }
		}
		public final static class Pending extends LDKRecentPaymentDetails {
			public byte[] payment_id;
			public byte[] payment_hash;
			public long total_msat;
			Pending(byte[] payment_id, byte[] payment_hash, long total_msat) { this.payment_id = payment_id; this.payment_hash = payment_hash; this.total_msat = total_msat; }
		}
		public final static class Fulfilled extends LDKRecentPaymentDetails {
			public byte[] payment_id;
			public long payment_hash;
			Fulfilled(byte[] payment_id, long payment_hash) { this.payment_id = payment_id; this.payment_hash = payment_hash; }
		}
		public final static class Abandoned extends LDKRecentPaymentDetails {
			public byte[] payment_id;
			public byte[] payment_hash;
			Abandoned(byte[] payment_id, byte[] payment_hash) { this.payment_id = payment_id; this.payment_hash = payment_hash; }
		}
		static native void init();
	}
	static { LDKRecentPaymentDetails.init(); }
	public static native LDKRecentPaymentDetails LDKRecentPaymentDetails_ref_from_ptr(long ptr);
	// void CResult_NoneAPIErrorZ_get_ok(LDKCResult_NoneAPIErrorZ *NONNULL_PTR owner);
	public static native void CResult_NoneAPIErrorZ_get_ok(long owner);
	// struct LDKAPIError CResult_NoneAPIErrorZ_get_err(LDKCResult_NoneAPIErrorZ *NONNULL_PTR owner);
	public static native long CResult_NoneAPIErrorZ_get_err(long owner);
	// void CResult_NoneRetryableSendFailureZ_get_ok(LDKCResult_NoneRetryableSendFailureZ *NONNULL_PTR owner);
	public static native void CResult_NoneRetryableSendFailureZ_get_ok(long owner);
	// enum LDKRetryableSendFailure CResult_NoneRetryableSendFailureZ_get_err(LDKCResult_NoneRetryableSendFailureZ *NONNULL_PTR owner);
	public static native RetryableSendFailure CResult_NoneRetryableSendFailureZ_get_err(long owner);
	public static class LDKCOption_OffersContextZ {
		private LDKCOption_OffersContextZ() {}
		public final static class Some extends LDKCOption_OffersContextZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_OffersContextZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_OffersContextZ.init(); }
	public static native LDKCOption_OffersContextZ LDKCOption_OffersContextZ_ref_from_ptr(long ptr);
	public static class LDKBolt12PaymentError {
		private LDKBolt12PaymentError() {}
		public final static class UnexpectedInvoice extends LDKBolt12PaymentError {
			UnexpectedInvoice() { }
		}
		public final static class DuplicateInvoice extends LDKBolt12PaymentError {
			DuplicateInvoice() { }
		}
		public final static class UnknownRequiredFeatures extends LDKBolt12PaymentError {
			UnknownRequiredFeatures() { }
		}
		public final static class SendingFailed extends LDKBolt12PaymentError {
			public org.ldk.enums.RetryableSendFailure sending_failed;
			SendingFailed(org.ldk.enums.RetryableSendFailure sending_failed) { this.sending_failed = sending_failed; }
		}
		static native void init();
	}
	static { LDKBolt12PaymentError.init(); }
	public static native LDKBolt12PaymentError LDKBolt12PaymentError_ref_from_ptr(long ptr);
	// void CResult_NoneBolt12PaymentErrorZ_get_ok(LDKCResult_NoneBolt12PaymentErrorZ *NONNULL_PTR owner);
	public static native void CResult_NoneBolt12PaymentErrorZ_get_ok(long owner);
	// struct LDKBolt12PaymentError CResult_NoneBolt12PaymentErrorZ_get_err(LDKCResult_NoneBolt12PaymentErrorZ *NONNULL_PTR owner);
	public static native long CResult_NoneBolt12PaymentErrorZ_get_err(long owner);
	// struct LDKThirtyTwoBytes CResult_ThirtyTwoBytesRetryableSendFailureZ_get_ok(LDKCResult_ThirtyTwoBytesRetryableSendFailureZ *NONNULL_PTR owner);
	public static native byte[] CResult_ThirtyTwoBytesRetryableSendFailureZ_get_ok(long owner);
	// enum LDKRetryableSendFailure CResult_ThirtyTwoBytesRetryableSendFailureZ_get_err(LDKCResult_ThirtyTwoBytesRetryableSendFailureZ *NONNULL_PTR owner);
	public static native RetryableSendFailure CResult_ThirtyTwoBytesRetryableSendFailureZ_get_err(long owner);
	// struct LDKThirtyTwoBytes C2Tuple_ThirtyTwoBytesThirtyTwoBytesZ_get_a(LDKC2Tuple_ThirtyTwoBytesThirtyTwoBytesZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_ThirtyTwoBytesThirtyTwoBytesZ_get_a(long owner);
	// struct LDKThirtyTwoBytes C2Tuple_ThirtyTwoBytesThirtyTwoBytesZ_get_b(LDKC2Tuple_ThirtyTwoBytesThirtyTwoBytesZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_ThirtyTwoBytesThirtyTwoBytesZ_get_b(long owner);
	public static class LDKProbeSendFailure {
		private LDKProbeSendFailure() {}
		public final static class RouteNotFound extends LDKProbeSendFailure {
			RouteNotFound() { }
		}
		public final static class ParameterError extends LDKProbeSendFailure {
			public long parameter_error;
			ParameterError(long parameter_error) { this.parameter_error = parameter_error; }
		}
		public final static class DuplicateProbe extends LDKProbeSendFailure {
			DuplicateProbe() { }
		}
		static native void init();
	}
	static { LDKProbeSendFailure.init(); }
	public static native LDKProbeSendFailure LDKProbeSendFailure_ref_from_ptr(long ptr);
	// struct LDKC2Tuple_ThirtyTwoBytesThirtyTwoBytesZ CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_get_ok(LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ *NONNULL_PTR owner);
	public static native long CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_get_ok(long owner);
	// struct LDKProbeSendFailure CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_get_err(LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ *NONNULL_PTR owner);
	public static native long CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_get_err(long owner);
	// struct LDKCVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZ CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_get_ok(LDKCResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ *NONNULL_PTR owner);
	public static native long[] CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_get_ok(long owner);
	// struct LDKProbeSendFailure CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_get_err(LDKCResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ *NONNULL_PTR owner);
	public static native long CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_get_err(long owner);
	// struct LDKChannelId C2Tuple_ChannelIdPublicKeyZ_get_a(LDKC2Tuple_ChannelIdPublicKeyZ *NONNULL_PTR owner);
	public static native long C2Tuple_ChannelIdPublicKeyZ_get_a(long owner);
	// struct LDKPublicKey C2Tuple_ChannelIdPublicKeyZ_get_b(LDKC2Tuple_ChannelIdPublicKeyZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_ChannelIdPublicKeyZ_get_b(long owner);
	// struct LDKPublicKey C2Tuple_PublicKeyChannelIdZ_get_a(LDKC2Tuple_PublicKeyChannelIdZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_PublicKeyChannelIdZ_get_a(long owner);
	// struct LDKChannelId C2Tuple_PublicKeyChannelIdZ_get_b(LDKC2Tuple_PublicKeyChannelIdZ *NONNULL_PTR owner);
	public static native long C2Tuple_PublicKeyChannelIdZ_get_b(long owner);
	public static class LDKCOption_C2Tuple_PublicKeyChannelIdZZ {
		private LDKCOption_C2Tuple_PublicKeyChannelIdZZ() {}
		public final static class Some extends LDKCOption_C2Tuple_PublicKeyChannelIdZZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_C2Tuple_PublicKeyChannelIdZZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_C2Tuple_PublicKeyChannelIdZZ.init(); }
	public static native LDKCOption_C2Tuple_PublicKeyChannelIdZZ LDKCOption_C2Tuple_PublicKeyChannelIdZZ_ref_from_ptr(long ptr);
	public static class LDKSignOrCreationError {
		private LDKSignOrCreationError() {}
		public final static class SignError extends LDKSignOrCreationError {
			SignError() { }
		}
		public final static class CreationError extends LDKSignOrCreationError {
			public org.ldk.enums.CreationError creation_error;
			CreationError(org.ldk.enums.CreationError creation_error) { this.creation_error = creation_error; }
		}
		static native void init();
	}
	static { LDKSignOrCreationError.init(); }
	public static native LDKSignOrCreationError LDKSignOrCreationError_ref_from_ptr(long ptr);
	// struct LDKBolt11Invoice CResult_Bolt11InvoiceSignOrCreationErrorZ_get_ok(LDKCResult_Bolt11InvoiceSignOrCreationErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt11InvoiceSignOrCreationErrorZ_get_ok(long owner);
	// struct LDKSignOrCreationError CResult_Bolt11InvoiceSignOrCreationErrorZ_get_err(LDKCResult_Bolt11InvoiceSignOrCreationErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt11InvoiceSignOrCreationErrorZ_get_err(long owner);
	// struct LDKOfferWithDerivedMetadataBuilder CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_get_ok(LDKCResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native long CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_get_ok(long owner);
	// enum LDKBolt12SemanticError CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_get_err(LDKCResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native Bolt12SemanticError CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_get_err(long owner);
	// struct LDKC2Tuple_ThirtyTwoBytesThirtyTwoBytesZ CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_get_ok(LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ *NONNULL_PTR owner);
	public static native long CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_get_ok(long owner);
	// void CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_get_err(LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ *NONNULL_PTR owner);
	public static native void CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_get_err(long owner);
	// struct LDKThirtyTwoBytes CResult_ThirtyTwoBytesAPIErrorZ_get_ok(LDKCResult_ThirtyTwoBytesAPIErrorZ *NONNULL_PTR owner);
	public static native byte[] CResult_ThirtyTwoBytesAPIErrorZ_get_ok(long owner);
	// struct LDKAPIError CResult_ThirtyTwoBytesAPIErrorZ_get_err(LDKCResult_ThirtyTwoBytesAPIErrorZ *NONNULL_PTR owner);
	public static native long CResult_ThirtyTwoBytesAPIErrorZ_get_err(long owner);
	public static class LDKOffersMessage {
		private LDKOffersMessage() {}
		public final static class InvoiceRequest extends LDKOffersMessage {
			public long invoice_request;
			InvoiceRequest(long invoice_request) { this.invoice_request = invoice_request; }
		}
		public final static class Invoice extends LDKOffersMessage {
			public long invoice;
			Invoice(long invoice) { this.invoice = invoice; }
		}
		public final static class InvoiceError extends LDKOffersMessage {
			public long invoice_error;
			InvoiceError(long invoice_error) { this.invoice_error = invoice_error; }
		}
		static native void init();
	}
	static { LDKOffersMessage.init(); }
	public static native LDKOffersMessage LDKOffersMessage_ref_from_ptr(long ptr);
	// struct LDKOffersMessage C2Tuple_OffersMessageResponseInstructionZ_get_a(LDKC2Tuple_OffersMessageResponseInstructionZ *NONNULL_PTR owner);
	public static native long C2Tuple_OffersMessageResponseInstructionZ_get_a(long owner);
	// struct LDKResponseInstruction C2Tuple_OffersMessageResponseInstructionZ_get_b(LDKC2Tuple_OffersMessageResponseInstructionZ *NONNULL_PTR owner);
	public static native long C2Tuple_OffersMessageResponseInstructionZ_get_b(long owner);
	public static class LDKCOption_C2Tuple_OffersMessageResponseInstructionZZ {
		private LDKCOption_C2Tuple_OffersMessageResponseInstructionZZ() {}
		public final static class Some extends LDKCOption_C2Tuple_OffersMessageResponseInstructionZZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_C2Tuple_OffersMessageResponseInstructionZZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_C2Tuple_OffersMessageResponseInstructionZZ.init(); }
	public static native LDKCOption_C2Tuple_OffersMessageResponseInstructionZZ LDKCOption_C2Tuple_OffersMessageResponseInstructionZZ_ref_from_ptr(long ptr);
	// struct LDKOffersMessage C2Tuple_OffersMessageMessageSendInstructionsZ_get_a(LDKC2Tuple_OffersMessageMessageSendInstructionsZ *NONNULL_PTR owner);
	public static native long C2Tuple_OffersMessageMessageSendInstructionsZ_get_a(long owner);
	// struct LDKMessageSendInstructions C2Tuple_OffersMessageMessageSendInstructionsZ_get_b(LDKC2Tuple_OffersMessageMessageSendInstructionsZ *NONNULL_PTR owner);
	public static native long C2Tuple_OffersMessageMessageSendInstructionsZ_get_b(long owner);
	// struct LDKReleaseHeldHtlc C2Tuple_ReleaseHeldHtlcResponseInstructionZ_get_a(LDKC2Tuple_ReleaseHeldHtlcResponseInstructionZ *NONNULL_PTR owner);
	public static native long C2Tuple_ReleaseHeldHtlcResponseInstructionZ_get_a(long owner);
	// struct LDKResponseInstruction C2Tuple_ReleaseHeldHtlcResponseInstructionZ_get_b(LDKC2Tuple_ReleaseHeldHtlcResponseInstructionZ *NONNULL_PTR owner);
	public static native long C2Tuple_ReleaseHeldHtlcResponseInstructionZ_get_b(long owner);
	public static class LDKCOption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ {
		private LDKCOption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ() {}
		public final static class Some extends LDKCOption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ.init(); }
	public static native LDKCOption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ LDKCOption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ_ref_from_ptr(long ptr);
	public static class LDKAsyncPaymentsMessage {
		private LDKAsyncPaymentsMessage() {}
		public final static class HeldHtlcAvailable extends LDKAsyncPaymentsMessage {
			public long held_htlc_available;
			HeldHtlcAvailable(long held_htlc_available) { this.held_htlc_available = held_htlc_available; }
		}
		public final static class ReleaseHeldHtlc extends LDKAsyncPaymentsMessage {
			public long release_held_htlc;
			ReleaseHeldHtlc(long release_held_htlc) { this.release_held_htlc = release_held_htlc; }
		}
		static native void init();
	}
	static { LDKAsyncPaymentsMessage.init(); }
	public static native LDKAsyncPaymentsMessage LDKAsyncPaymentsMessage_ref_from_ptr(long ptr);
	// struct LDKAsyncPaymentsMessage C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ_get_a(LDKC2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ *NONNULL_PTR owner);
	public static native long C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ_get_a(long owner);
	// struct LDKMessageSendInstructions C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ_get_b(LDKC2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ *NONNULL_PTR owner);
	public static native long C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ_get_b(long owner);
	// struct LDKPhantomRouteHints CResult_PhantomRouteHintsDecodeErrorZ_get_ok(LDKCResult_PhantomRouteHintsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PhantomRouteHintsDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_PhantomRouteHintsDecodeErrorZ_get_err(LDKCResult_PhantomRouteHintsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PhantomRouteHintsDecodeErrorZ_get_err(long owner);
	// struct LDKBlindedForward CResult_BlindedForwardDecodeErrorZ_get_ok(LDKCResult_BlindedForwardDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BlindedForwardDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_BlindedForwardDecodeErrorZ_get_err(LDKCResult_BlindedForwardDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BlindedForwardDecodeErrorZ_get_err(long owner);
	public static class LDKPendingHTLCRouting {
		private LDKPendingHTLCRouting() {}
		public final static class Forward extends LDKPendingHTLCRouting {
			public long onion_packet;
			public long short_channel_id;
			public long blinded;
			public long incoming_cltv_expiry;
			Forward(long onion_packet, long short_channel_id, long blinded, long incoming_cltv_expiry) { this.onion_packet = onion_packet; this.short_channel_id = short_channel_id; this.blinded = blinded; this.incoming_cltv_expiry = incoming_cltv_expiry; }
		}
		public final static class Receive extends LDKPendingHTLCRouting {
			public long payment_data;
			public long payment_metadata;
			public long payment_context;
			public int incoming_cltv_expiry;
			public byte[] phantom_shared_secret;
			public long[] custom_tlvs;
			public boolean requires_blinded_error;
			Receive(long payment_data, long payment_metadata, long payment_context, int incoming_cltv_expiry, byte[] phantom_shared_secret, long[] custom_tlvs, boolean requires_blinded_error) { this.payment_data = payment_data; this.payment_metadata = payment_metadata; this.payment_context = payment_context; this.incoming_cltv_expiry = incoming_cltv_expiry; this.phantom_shared_secret = phantom_shared_secret; this.custom_tlvs = custom_tlvs; this.requires_blinded_error = requires_blinded_error; }
		}
		public final static class ReceiveKeysend extends LDKPendingHTLCRouting {
			public long payment_data;
			public byte[] payment_preimage;
			public long payment_metadata;
			public int incoming_cltv_expiry;
			public long[] custom_tlvs;
			public boolean requires_blinded_error;
			public boolean has_recipient_created_payment_secret;
			ReceiveKeysend(long payment_data, byte[] payment_preimage, long payment_metadata, int incoming_cltv_expiry, long[] custom_tlvs, boolean requires_blinded_error, boolean has_recipient_created_payment_secret) { this.payment_data = payment_data; this.payment_preimage = payment_preimage; this.payment_metadata = payment_metadata; this.incoming_cltv_expiry = incoming_cltv_expiry; this.custom_tlvs = custom_tlvs; this.requires_blinded_error = requires_blinded_error; this.has_recipient_created_payment_secret = has_recipient_created_payment_secret; }
		}
		static native void init();
	}
	static { LDKPendingHTLCRouting.init(); }
	public static native LDKPendingHTLCRouting LDKPendingHTLCRouting_ref_from_ptr(long ptr);
	// struct LDKPendingHTLCRouting CResult_PendingHTLCRoutingDecodeErrorZ_get_ok(LDKCResult_PendingHTLCRoutingDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PendingHTLCRoutingDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_PendingHTLCRoutingDecodeErrorZ_get_err(LDKCResult_PendingHTLCRoutingDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PendingHTLCRoutingDecodeErrorZ_get_err(long owner);
	// struct LDKPendingHTLCInfo CResult_PendingHTLCInfoDecodeErrorZ_get_ok(LDKCResult_PendingHTLCInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PendingHTLCInfoDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_PendingHTLCInfoDecodeErrorZ_get_err(LDKCResult_PendingHTLCInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PendingHTLCInfoDecodeErrorZ_get_err(long owner);
	// enum LDKBlindedFailure CResult_BlindedFailureDecodeErrorZ_get_ok(LDKCResult_BlindedFailureDecodeErrorZ *NONNULL_PTR owner);
	public static native BlindedFailure CResult_BlindedFailureDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_BlindedFailureDecodeErrorZ_get_err(LDKCResult_BlindedFailureDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BlindedFailureDecodeErrorZ_get_err(long owner);
	public interface LDKWatch {
		 long watch_channel(long funding_txo, long monitor);
		 ChannelMonitorUpdateStatus update_channel(long funding_txo, long update);
		 long[] release_pending_monitor_events();
	}
	public static native long LDKWatch_new(LDKWatch impl);
	// LDKCResult_ChannelMonitorUpdateStatusNoneZ Watch_watch_channel LDKWatch *NONNULL_PTR this_arg, struct LDKOutPoint funding_txo, struct LDKChannelMonitor monitor
	public static native long Watch_watch_channel(long this_arg, long funding_txo, long monitor);
	// LDKChannelMonitorUpdateStatus Watch_update_channel LDKWatch *NONNULL_PTR this_arg, struct LDKOutPoint funding_txo, const struct LDKChannelMonitorUpdate *NONNULL_PTR update
	public static native ChannelMonitorUpdateStatus Watch_update_channel(long this_arg, long funding_txo, long update);
	// LDKCVec_C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZZ Watch_release_pending_monitor_events LDKWatch *NONNULL_PTR this_arg
	public static native long[] Watch_release_pending_monitor_events(long this_arg);
	public interface LDKBroadcasterInterface {
		 void broadcast_transactions(byte[][] txs);
	}
	public static native long LDKBroadcasterInterface_new(LDKBroadcasterInterface impl);
	// void BroadcasterInterface_broadcast_transactions LDKBroadcasterInterface *NONNULL_PTR this_arg, struct LDKCVec_TransactionZ txs
	public static native void BroadcasterInterface_broadcast_transactions(long this_arg, byte[][] txs);
	public interface LDKEntropySource {
		 byte[] get_secure_random_bytes();
	}
	public static native long LDKEntropySource_new(LDKEntropySource impl);
	// LDKThirtyTwoBytes EntropySource_get_secure_random_bytes LDKEntropySource *NONNULL_PTR this_arg
	public static native byte[] EntropySource_get_secure_random_bytes(long this_arg);
	public static class LDKUnsignedGossipMessage {
		private LDKUnsignedGossipMessage() {}
		public final static class ChannelAnnouncement extends LDKUnsignedGossipMessage {
			public long channel_announcement;
			ChannelAnnouncement(long channel_announcement) { this.channel_announcement = channel_announcement; }
		}
		public final static class ChannelUpdate extends LDKUnsignedGossipMessage {
			public long channel_update;
			ChannelUpdate(long channel_update) { this.channel_update = channel_update; }
		}
		public final static class NodeAnnouncement extends LDKUnsignedGossipMessage {
			public long node_announcement;
			NodeAnnouncement(long node_announcement) { this.node_announcement = node_announcement; }
		}
		static native void init();
	}
	static { LDKUnsignedGossipMessage.init(); }
	public static native LDKUnsignedGossipMessage LDKUnsignedGossipMessage_ref_from_ptr(long ptr);
	public interface LDKNodeSigner {
		 long get_inbound_payment_key();
		 long get_node_id(Recipient recipient);
		 long ecdh(Recipient recipient, byte[] other_key, long tweak);
		 long sign_invoice(long invoice, Recipient recipient);
		 long sign_bolt12_invoice(long invoice);
		 long sign_gossip_message(long msg);
	}
	public static native long LDKNodeSigner_new(LDKNodeSigner impl);
	// LDKExpandedKey NodeSigner_get_inbound_payment_key LDKNodeSigner *NONNULL_PTR this_arg
	public static native long NodeSigner_get_inbound_payment_key(long this_arg);
	// LDKCResult_PublicKeyNoneZ NodeSigner_get_node_id LDKNodeSigner *NONNULL_PTR this_arg, enum LDKRecipient recipient
	public static native long NodeSigner_get_node_id(long this_arg, Recipient recipient);
	// LDKCResult_ThirtyTwoBytesNoneZ NodeSigner_ecdh LDKNodeSigner *NONNULL_PTR this_arg, enum LDKRecipient recipient, struct LDKPublicKey other_key, struct LDKCOption_BigEndianScalarZ tweak
	public static native long NodeSigner_ecdh(long this_arg, Recipient recipient, byte[] other_key, long tweak);
	// LDKCResult_RecoverableSignatureNoneZ NodeSigner_sign_invoice LDKNodeSigner *NONNULL_PTR this_arg, const struct LDKRawBolt11Invoice *NONNULL_PTR invoice, enum LDKRecipient recipient
	public static native long NodeSigner_sign_invoice(long this_arg, long invoice, Recipient recipient);
	// LDKCResult_SchnorrSignatureNoneZ NodeSigner_sign_bolt12_invoice LDKNodeSigner *NONNULL_PTR this_arg, const struct LDKUnsignedBolt12Invoice *NONNULL_PTR invoice
	public static native long NodeSigner_sign_bolt12_invoice(long this_arg, long invoice);
	// LDKCResult_ECDSASignatureNoneZ NodeSigner_sign_gossip_message LDKNodeSigner *NONNULL_PTR this_arg, struct LDKUnsignedGossipMessage msg
	public static native long NodeSigner_sign_gossip_message(long this_arg, long msg);
	public interface LDKSignerProvider {
		 byte[] generate_channel_keys_id(boolean inbound, long channel_value_satoshis, byte[] user_channel_id);
		 long derive_channel_signer(long channel_value_satoshis, byte[] channel_keys_id);
		 long read_chan_signer(byte[] reader);
		 long get_destination_script(byte[] channel_keys_id);
		 long get_shutdown_scriptpubkey();
	}
	public static native long LDKSignerProvider_new(LDKSignerProvider impl);
	// LDKThirtyTwoBytes SignerProvider_generate_channel_keys_id LDKSignerProvider *NONNULL_PTR this_arg, bool inbound, uint64_t channel_value_satoshis, struct LDKU128 user_channel_id
	public static native byte[] SignerProvider_generate_channel_keys_id(long this_arg, boolean inbound, long channel_value_satoshis, byte[] user_channel_id);
	// LDKEcdsaChannelSigner SignerProvider_derive_channel_signer LDKSignerProvider *NONNULL_PTR this_arg, uint64_t channel_value_satoshis, struct LDKThirtyTwoBytes channel_keys_id
	public static native long SignerProvider_derive_channel_signer(long this_arg, long channel_value_satoshis, byte[] channel_keys_id);
	// LDKCResult_EcdsaChannelSignerDecodeErrorZ SignerProvider_read_chan_signer LDKSignerProvider *NONNULL_PTR this_arg, struct LDKu8slice reader
	public static native long SignerProvider_read_chan_signer(long this_arg, byte[] reader);
	// LDKCResult_CVec_u8ZNoneZ SignerProvider_get_destination_script LDKSignerProvider *NONNULL_PTR this_arg, struct LDKThirtyTwoBytes channel_keys_id
	public static native long SignerProvider_get_destination_script(long this_arg, byte[] channel_keys_id);
	// LDKCResult_ShutdownScriptNoneZ SignerProvider_get_shutdown_scriptpubkey LDKSignerProvider *NONNULL_PTR this_arg
	public static native long SignerProvider_get_shutdown_scriptpubkey(long this_arg);
	public interface LDKFeeEstimator {
		 int get_est_sat_per_1000_weight(ConfirmationTarget confirmation_target);
	}
	public static native long LDKFeeEstimator_new(LDKFeeEstimator impl);
	// uint32_t FeeEstimator_get_est_sat_per_1000_weight LDKFeeEstimator *NONNULL_PTR this_arg, enum LDKConfirmationTarget confirmation_target
	public static native int FeeEstimator_get_est_sat_per_1000_weight(long this_arg, ConfirmationTarget confirmation_target);
	public interface LDKRouter {
		 long find_route(byte[] payer, long route_params, long[] first_hops, long inflight_htlcs);
		 long find_route_with_id(byte[] payer, long route_params, long[] first_hops, long inflight_htlcs, byte[] _payment_hash, byte[] _payment_id);
		 long create_blinded_payment_paths(byte[] recipient, long[] first_hops, long tlvs, long amount_msats);
	}
	public static native long LDKRouter_new(LDKRouter impl);
	// LDKCResult_RouteLightningErrorZ Router_find_route LDKRouter *NONNULL_PTR this_arg, struct LDKPublicKey payer, const struct LDKRouteParameters *NONNULL_PTR route_params, struct LDKCVec_ChannelDetailsZ *first_hops, struct LDKInFlightHtlcs inflight_htlcs
	public static native long Router_find_route(long this_arg, byte[] payer, long route_params, long[] first_hops, long inflight_htlcs);
	// LDKCResult_RouteLightningErrorZ Router_find_route_with_id LDKRouter *NONNULL_PTR this_arg, struct LDKPublicKey payer, const struct LDKRouteParameters *NONNULL_PTR route_params, struct LDKCVec_ChannelDetailsZ *first_hops, struct LDKInFlightHtlcs inflight_htlcs, struct LDKThirtyTwoBytes _payment_hash, struct LDKThirtyTwoBytes _payment_id
	public static native long Router_find_route_with_id(long this_arg, byte[] payer, long route_params, long[] first_hops, long inflight_htlcs, byte[] _payment_hash, byte[] _payment_id);
	// LDKCResult_CVec_BlindedPaymentPathZNoneZ Router_create_blinded_payment_paths LDKRouter *NONNULL_PTR this_arg, struct LDKPublicKey recipient, struct LDKCVec_ChannelDetailsZ first_hops, struct LDKReceiveTlvs tlvs, uint64_t amount_msats
	public static native long Router_create_blinded_payment_paths(long this_arg, byte[] recipient, long[] first_hops, long tlvs, long amount_msats);
	// struct LDKOnionMessagePath CResult_OnionMessagePathNoneZ_get_ok(LDKCResult_OnionMessagePathNoneZ *NONNULL_PTR owner);
	public static native long CResult_OnionMessagePathNoneZ_get_ok(long owner);
	// void CResult_OnionMessagePathNoneZ_get_err(LDKCResult_OnionMessagePathNoneZ *NONNULL_PTR owner);
	public static native void CResult_OnionMessagePathNoneZ_get_err(long owner);
	// struct LDKCVec_BlindedMessagePathZ CResult_CVec_BlindedMessagePathZNoneZ_get_ok(LDKCResult_CVec_BlindedMessagePathZNoneZ *NONNULL_PTR owner);
	public static native long[] CResult_CVec_BlindedMessagePathZNoneZ_get_ok(long owner);
	// void CResult_CVec_BlindedMessagePathZNoneZ_get_err(LDKCResult_CVec_BlindedMessagePathZNoneZ *NONNULL_PTR owner);
	public static native void CResult_CVec_BlindedMessagePathZNoneZ_get_err(long owner);
	public interface LDKMessageRouter {
		 long find_path(byte[] sender, byte[][] peers, long destination);
		 long create_blinded_paths(byte[] recipient, long context, byte[][] peers);
		 long create_compact_blinded_paths(byte[] recipient, long context, long[] peers);
	}
	public static native long LDKMessageRouter_new(LDKMessageRouter impl);
	// LDKCResult_OnionMessagePathNoneZ MessageRouter_find_path LDKMessageRouter *NONNULL_PTR this_arg, struct LDKPublicKey sender, struct LDKCVec_PublicKeyZ peers, struct LDKDestination destination
	public static native long MessageRouter_find_path(long this_arg, byte[] sender, byte[][] peers, long destination);
	// LDKCResult_CVec_BlindedMessagePathZNoneZ MessageRouter_create_blinded_paths LDKMessageRouter *NONNULL_PTR this_arg, struct LDKPublicKey recipient, struct LDKMessageContext context, struct LDKCVec_PublicKeyZ peers
	public static native long MessageRouter_create_blinded_paths(long this_arg, byte[] recipient, long context, byte[][] peers);
	// LDKCResult_CVec_BlindedMessagePathZNoneZ MessageRouter_create_compact_blinded_paths LDKMessageRouter *NONNULL_PTR this_arg, struct LDKPublicKey recipient, struct LDKMessageContext context, struct LDKCVec_MessageForwardNodeZ peers
	public static native long MessageRouter_create_compact_blinded_paths(long this_arg, byte[] recipient, long context, long[] peers);
	// struct LDKThirtyTwoBytes C2Tuple_ThirtyTwoBytesChannelManagerZ_get_a(LDKC2Tuple_ThirtyTwoBytesChannelManagerZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_ThirtyTwoBytesChannelManagerZ_get_a(long owner);
	// struct LDKChannelManager C2Tuple_ThirtyTwoBytesChannelManagerZ_get_b(LDKC2Tuple_ThirtyTwoBytesChannelManagerZ *NONNULL_PTR owner);
	public static native long C2Tuple_ThirtyTwoBytesChannelManagerZ_get_b(long owner);
	// struct LDKC2Tuple_ThirtyTwoBytesChannelManagerZ *CResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ_get_ok(LDKCResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ_get_err(LDKCResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ_get_err(long owner);
	public static class LDKMaxDustHTLCExposure {
		private LDKMaxDustHTLCExposure() {}
		public final static class FixedLimitMsat extends LDKMaxDustHTLCExposure {
			public long fixed_limit_msat;
			FixedLimitMsat(long fixed_limit_msat) { this.fixed_limit_msat = fixed_limit_msat; }
		}
		public final static class FeeRateMultiplier extends LDKMaxDustHTLCExposure {
			public long fee_rate_multiplier;
			FeeRateMultiplier(long fee_rate_multiplier) { this.fee_rate_multiplier = fee_rate_multiplier; }
		}
		static native void init();
	}
	static { LDKMaxDustHTLCExposure.init(); }
	public static native LDKMaxDustHTLCExposure LDKMaxDustHTLCExposure_ref_from_ptr(long ptr);
	// struct LDKMaxDustHTLCExposure CResult_MaxDustHTLCExposureDecodeErrorZ_get_ok(LDKCResult_MaxDustHTLCExposureDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_MaxDustHTLCExposureDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_MaxDustHTLCExposureDecodeErrorZ_get_err(LDKCResult_MaxDustHTLCExposureDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_MaxDustHTLCExposureDecodeErrorZ_get_err(long owner);
	// struct LDKChannelConfig CResult_ChannelConfigDecodeErrorZ_get_ok(LDKCResult_ChannelConfigDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelConfigDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelConfigDecodeErrorZ_get_err(LDKCResult_ChannelConfigDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelConfigDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_MaxDustHTLCExposureZ {
		private LDKCOption_MaxDustHTLCExposureZ() {}
		public final static class Some extends LDKCOption_MaxDustHTLCExposureZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_MaxDustHTLCExposureZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_MaxDustHTLCExposureZ.init(); }
	public static native LDKCOption_MaxDustHTLCExposureZ LDKCOption_MaxDustHTLCExposureZ_ref_from_ptr(long ptr);
	public static class LDKCOption_APIErrorZ {
		private LDKCOption_APIErrorZ() {}
		public final static class Some extends LDKCOption_APIErrorZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_APIErrorZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_APIErrorZ.init(); }
	public static native LDKCOption_APIErrorZ LDKCOption_APIErrorZ_ref_from_ptr(long ptr);
	// struct LDKCOption_APIErrorZ CResult_COption_APIErrorZDecodeErrorZ_get_ok(LDKCResult_COption_APIErrorZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_APIErrorZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_COption_APIErrorZDecodeErrorZ_get_err(LDKCResult_COption_APIErrorZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_APIErrorZDecodeErrorZ_get_err(long owner);
	// struct LDKChannelMonitorUpdate CResult_ChannelMonitorUpdateDecodeErrorZ_get_ok(LDKCResult_ChannelMonitorUpdateDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelMonitorUpdateDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelMonitorUpdateDecodeErrorZ_get_err(LDKCResult_ChannelMonitorUpdateDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelMonitorUpdateDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_MonitorEventZ {
		private LDKCOption_MonitorEventZ() {}
		public final static class Some extends LDKCOption_MonitorEventZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_MonitorEventZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_MonitorEventZ.init(); }
	public static native LDKCOption_MonitorEventZ LDKCOption_MonitorEventZ_ref_from_ptr(long ptr);
	// struct LDKCOption_MonitorEventZ CResult_COption_MonitorEventZDecodeErrorZ_get_ok(LDKCResult_COption_MonitorEventZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_MonitorEventZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_COption_MonitorEventZDecodeErrorZ_get_err(LDKCResult_COption_MonitorEventZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_MonitorEventZDecodeErrorZ_get_err(long owner);
	// struct LDKHTLCUpdate CResult_HTLCUpdateDecodeErrorZ_get_ok(LDKCResult_HTLCUpdateDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HTLCUpdateDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_HTLCUpdateDecodeErrorZ_get_err(LDKCResult_HTLCUpdateDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HTLCUpdateDecodeErrorZ_get_err(long owner);
	// struct LDKOutPoint C2Tuple_OutPointCVec_u8ZZ_get_a(LDKC2Tuple_OutPointCVec_u8ZZ *NONNULL_PTR owner);
	public static native long C2Tuple_OutPointCVec_u8ZZ_get_a(long owner);
	// struct LDKCVec_u8Z C2Tuple_OutPointCVec_u8ZZ_get_b(LDKC2Tuple_OutPointCVec_u8ZZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_OutPointCVec_u8ZZ_get_b(long owner);
	// uint32_t C2Tuple_u32CVec_u8ZZ_get_a(LDKC2Tuple_u32CVec_u8ZZ *NONNULL_PTR owner);
	public static native int C2Tuple_u32CVec_u8ZZ_get_a(long owner);
	// struct LDKCVec_u8Z C2Tuple_u32CVec_u8ZZ_get_b(LDKC2Tuple_u32CVec_u8ZZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_u32CVec_u8ZZ_get_b(long owner);
	// struct LDKThirtyTwoBytes C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ_get_a(LDKC2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ_get_a(long owner);
	// struct LDKCVec_C2Tuple_u32CVec_u8ZZZ C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ_get_b(LDKC2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ *NONNULL_PTR owner);
	public static native long[] C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ_get_b(long owner);
	// void CResult_NoneReplayEventZ_get_ok(LDKCResult_NoneReplayEventZ *NONNULL_PTR owner);
	public static native void CResult_NoneReplayEventZ_get_ok(long owner);
	// struct LDKReplayEvent CResult_NoneReplayEventZ_get_err(LDKCResult_NoneReplayEventZ *NONNULL_PTR owner);
	public static native long CResult_NoneReplayEventZ_get_err(long owner);
	// uint32_t C2Tuple_u32TxOutZ_get_a(LDKC2Tuple_u32TxOutZ *NONNULL_PTR owner);
	public static native int C2Tuple_u32TxOutZ_get_a(long owner);
	// struct LDKTxOut C2Tuple_u32TxOutZ_get_b(LDKC2Tuple_u32TxOutZ *NONNULL_PTR owner);
	public static native long C2Tuple_u32TxOutZ_get_b(long owner);
	// struct LDKThirtyTwoBytes C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ_get_a(LDKC2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ_get_a(long owner);
	// struct LDKCVec_C2Tuple_u32TxOutZZ C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ_get_b(LDKC2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ *NONNULL_PTR owner);
	public static native long[] C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ_get_b(long owner);
	// bool C2Tuple_boolboolZ_get_a(LDKC2Tuple_boolboolZ *NONNULL_PTR owner);
	public static native boolean C2Tuple_boolboolZ_get_a(long owner);
	// bool C2Tuple_boolboolZ_get_b(LDKC2Tuple_boolboolZ *NONNULL_PTR owner);
	public static native boolean C2Tuple_boolboolZ_get_b(long owner);
	public static class LDKBalance {
		private LDKBalance() {}
		public final static class ClaimableOnChannelClose extends LDKBalance {
			public long amount_satoshis;
			public long transaction_fee_satoshis;
			public long outbound_payment_htlc_rounded_msat;
			public long outbound_forwarded_htlc_rounded_msat;
			public long inbound_claiming_htlc_rounded_msat;
			public long inbound_htlc_rounded_msat;
			ClaimableOnChannelClose(long amount_satoshis, long transaction_fee_satoshis, long outbound_payment_htlc_rounded_msat, long outbound_forwarded_htlc_rounded_msat, long inbound_claiming_htlc_rounded_msat, long inbound_htlc_rounded_msat) { this.amount_satoshis = amount_satoshis; this.transaction_fee_satoshis = transaction_fee_satoshis; this.outbound_payment_htlc_rounded_msat = outbound_payment_htlc_rounded_msat; this.outbound_forwarded_htlc_rounded_msat = outbound_forwarded_htlc_rounded_msat; this.inbound_claiming_htlc_rounded_msat = inbound_claiming_htlc_rounded_msat; this.inbound_htlc_rounded_msat = inbound_htlc_rounded_msat; }
		}
		public final static class ClaimableAwaitingConfirmations extends LDKBalance {
			public long amount_satoshis;
			public int confirmation_height;
			public org.ldk.enums.BalanceSource source;
			ClaimableAwaitingConfirmations(long amount_satoshis, int confirmation_height, org.ldk.enums.BalanceSource source) { this.amount_satoshis = amount_satoshis; this.confirmation_height = confirmation_height; this.source = source; }
		}
		public final static class ContentiousClaimable extends LDKBalance {
			public long amount_satoshis;
			public int timeout_height;
			public byte[] payment_hash;
			public byte[] payment_preimage;
			ContentiousClaimable(long amount_satoshis, int timeout_height, byte[] payment_hash, byte[] payment_preimage) { this.amount_satoshis = amount_satoshis; this.timeout_height = timeout_height; this.payment_hash = payment_hash; this.payment_preimage = payment_preimage; }
		}
		public final static class MaybeTimeoutClaimableHTLC extends LDKBalance {
			public long amount_satoshis;
			public int claimable_height;
			public byte[] payment_hash;
			public boolean outbound_payment;
			MaybeTimeoutClaimableHTLC(long amount_satoshis, int claimable_height, byte[] payment_hash, boolean outbound_payment) { this.amount_satoshis = amount_satoshis; this.claimable_height = claimable_height; this.payment_hash = payment_hash; this.outbound_payment = outbound_payment; }
		}
		public final static class MaybePreimageClaimableHTLC extends LDKBalance {
			public long amount_satoshis;
			public int expiry_height;
			public byte[] payment_hash;
			MaybePreimageClaimableHTLC(long amount_satoshis, int expiry_height, byte[] payment_hash) { this.amount_satoshis = amount_satoshis; this.expiry_height = expiry_height; this.payment_hash = payment_hash; }
		}
		public final static class CounterpartyRevokedOutputClaimable extends LDKBalance {
			public long amount_satoshis;
			CounterpartyRevokedOutputClaimable(long amount_satoshis) { this.amount_satoshis = amount_satoshis; }
		}
		static native void init();
	}
	static { LDKBalance.init(); }
	public static native LDKBalance LDKBalance_ref_from_ptr(long ptr);
	// struct LDKThirtyTwoBytes C2Tuple_ThirtyTwoBytesChannelMonitorZ_get_a(LDKC2Tuple_ThirtyTwoBytesChannelMonitorZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_ThirtyTwoBytesChannelMonitorZ_get_a(long owner);
	// struct LDKChannelMonitor C2Tuple_ThirtyTwoBytesChannelMonitorZ_get_b(LDKC2Tuple_ThirtyTwoBytesChannelMonitorZ *NONNULL_PTR owner);
	public static native long C2Tuple_ThirtyTwoBytesChannelMonitorZ_get_b(long owner);
	// struct LDKC2Tuple_ThirtyTwoBytesChannelMonitorZ CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_get_ok(LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_get_err(LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_get_err(long owner);
	public interface LDKType {
		 short type_id();
		 String debug_str();
		 byte[] write();
	}
	public static native long LDKType_new(LDKType impl);
	// uint16_t Type_type_id LDKType *NONNULL_PTR this_arg
	public static native short Type_type_id(long this_arg);
	// LDKStr Type_debug_str LDKType *NONNULL_PTR this_arg
	public static native String Type_debug_str(long this_arg);
	// LDKCVec_u8Z Type_write LDKType *NONNULL_PTR this_arg
	public static native byte[] Type_write(long this_arg);
	// struct LDKPublicKey C2Tuple_PublicKeyTypeZ_get_a(LDKC2Tuple_PublicKeyTypeZ *NONNULL_PTR owner);
	public static native byte[] C2Tuple_PublicKeyTypeZ_get_a(long owner);
	// struct LDKType C2Tuple_PublicKeyTypeZ_get_b(LDKC2Tuple_PublicKeyTypeZ *NONNULL_PTR owner);
	public static native long C2Tuple_PublicKeyTypeZ_get_b(long owner);
	public interface LDKOnionMessageContents {
		 long tlv_type();
		 String msg_type();
		 byte[] write();
		 String debug_str();
	}
	public static native long LDKOnionMessageContents_new(LDKOnionMessageContents impl);
	// uint64_t OnionMessageContents_tlv_type LDKOnionMessageContents *NONNULL_PTR this_arg
	public static native long OnionMessageContents_tlv_type(long this_arg);
	// LDKStr OnionMessageContents_msg_type LDKOnionMessageContents *NONNULL_PTR this_arg
	public static native String OnionMessageContents_msg_type(long this_arg);
	// LDKCVec_u8Z OnionMessageContents_write LDKOnionMessageContents *NONNULL_PTR this_arg
	public static native byte[] OnionMessageContents_write(long this_arg);
	// LDKStr OnionMessageContents_debug_str LDKOnionMessageContents *NONNULL_PTR this_arg
	public static native String OnionMessageContents_debug_str(long this_arg);
	// struct LDKOnionMessageContents C2Tuple_OnionMessageContentsResponseInstructionZ_get_a(LDKC2Tuple_OnionMessageContentsResponseInstructionZ *NONNULL_PTR owner);
	public static native long C2Tuple_OnionMessageContentsResponseInstructionZ_get_a(long owner);
	// struct LDKResponseInstruction C2Tuple_OnionMessageContentsResponseInstructionZ_get_b(LDKC2Tuple_OnionMessageContentsResponseInstructionZ *NONNULL_PTR owner);
	public static native long C2Tuple_OnionMessageContentsResponseInstructionZ_get_b(long owner);
	public static class LDKCOption_C2Tuple_OnionMessageContentsResponseInstructionZZ {
		private LDKCOption_C2Tuple_OnionMessageContentsResponseInstructionZZ() {}
		public final static class Some extends LDKCOption_C2Tuple_OnionMessageContentsResponseInstructionZZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_C2Tuple_OnionMessageContentsResponseInstructionZZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_C2Tuple_OnionMessageContentsResponseInstructionZZ.init(); }
	public static native LDKCOption_C2Tuple_OnionMessageContentsResponseInstructionZZ LDKCOption_C2Tuple_OnionMessageContentsResponseInstructionZZ_ref_from_ptr(long ptr);
	public static class LDKCOption_OnionMessageContentsZ {
		private LDKCOption_OnionMessageContentsZ() {}
		public final static class Some extends LDKCOption_OnionMessageContentsZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_OnionMessageContentsZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_OnionMessageContentsZ.init(); }
	public static native LDKCOption_OnionMessageContentsZ LDKCOption_OnionMessageContentsZ_ref_from_ptr(long ptr);
	// struct LDKCOption_OnionMessageContentsZ CResult_COption_OnionMessageContentsZDecodeErrorZ_get_ok(LDKCResult_COption_OnionMessageContentsZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_OnionMessageContentsZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_COption_OnionMessageContentsZDecodeErrorZ_get_err(LDKCResult_COption_OnionMessageContentsZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_OnionMessageContentsZDecodeErrorZ_get_err(long owner);
	// struct LDKOnionMessageContents C2Tuple_OnionMessageContentsMessageSendInstructionsZ_get_a(LDKC2Tuple_OnionMessageContentsMessageSendInstructionsZ *NONNULL_PTR owner);
	public static native long C2Tuple_OnionMessageContentsMessageSendInstructionsZ_get_a(long owner);
	// struct LDKMessageSendInstructions C2Tuple_OnionMessageContentsMessageSendInstructionsZ_get_b(LDKC2Tuple_OnionMessageContentsMessageSendInstructionsZ *NONNULL_PTR owner);
	public static native long C2Tuple_OnionMessageContentsMessageSendInstructionsZ_get_b(long owner);
	public static class LDKCOption_TypeZ {
		private LDKCOption_TypeZ() {}
		public final static class Some extends LDKCOption_TypeZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_TypeZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_TypeZ.init(); }
	public static native LDKCOption_TypeZ LDKCOption_TypeZ_ref_from_ptr(long ptr);
	// struct LDKCOption_TypeZ CResult_COption_TypeZDecodeErrorZ_get_ok(LDKCResult_COption_TypeZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_TypeZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_COption_TypeZDecodeErrorZ_get_err(LDKCResult_COption_TypeZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_TypeZDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_SocketAddressZ {
		private LDKCOption_SocketAddressZ() {}
		public final static class Some extends LDKCOption_SocketAddressZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_SocketAddressZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_SocketAddressZ.init(); }
	public static native LDKCOption_SocketAddressZ LDKCOption_SocketAddressZ_ref_from_ptr(long ptr);
	// struct LDKCVec_u8Z CResult_CVec_u8ZPeerHandleErrorZ_get_ok(LDKCResult_CVec_u8ZPeerHandleErrorZ *NONNULL_PTR owner);
	public static native byte[] CResult_CVec_u8ZPeerHandleErrorZ_get_ok(long owner);
	// struct LDKPeerHandleError CResult_CVec_u8ZPeerHandleErrorZ_get_err(LDKCResult_CVec_u8ZPeerHandleErrorZ *NONNULL_PTR owner);
	public static native long CResult_CVec_u8ZPeerHandleErrorZ_get_err(long owner);
	// void CResult_NonePeerHandleErrorZ_get_ok(LDKCResult_NonePeerHandleErrorZ *NONNULL_PTR owner);
	public static native void CResult_NonePeerHandleErrorZ_get_ok(long owner);
	// struct LDKPeerHandleError CResult_NonePeerHandleErrorZ_get_err(LDKCResult_NonePeerHandleErrorZ *NONNULL_PTR owner);
	public static native long CResult_NonePeerHandleErrorZ_get_err(long owner);
	// bool CResult_boolPeerHandleErrorZ_get_ok(LDKCResult_boolPeerHandleErrorZ *NONNULL_PTR owner);
	public static native boolean CResult_boolPeerHandleErrorZ_get_ok(long owner);
	// struct LDKPeerHandleError CResult_boolPeerHandleErrorZ_get_err(LDKCResult_boolPeerHandleErrorZ *NONNULL_PTR owner);
	public static native long CResult_boolPeerHandleErrorZ_get_err(long owner);
	public static class LDKGraphSyncError {
		private LDKGraphSyncError() {}
		public final static class DecodeError extends LDKGraphSyncError {
			public long decode_error;
			DecodeError(long decode_error) { this.decode_error = decode_error; }
		}
		public final static class LightningError extends LDKGraphSyncError {
			public long lightning_error;
			LightningError(long lightning_error) { this.lightning_error = lightning_error; }
		}
		static native void init();
	}
	static { LDKGraphSyncError.init(); }
	public static native LDKGraphSyncError LDKGraphSyncError_ref_from_ptr(long ptr);
	// uint32_t CResult_u32GraphSyncErrorZ_get_ok(LDKCResult_u32GraphSyncErrorZ *NONNULL_PTR owner);
	public static native int CResult_u32GraphSyncErrorZ_get_ok(long owner);
	// struct LDKGraphSyncError CResult_u32GraphSyncErrorZ_get_err(LDKCResult_u32GraphSyncErrorZ *NONNULL_PTR owner);
	public static native long CResult_u32GraphSyncErrorZ_get_err(long owner);
	// struct LDKCVec_u8Z CResult_CVec_u8ZIOErrorZ_get_ok(LDKCResult_CVec_u8ZIOErrorZ *NONNULL_PTR owner);
	public static native byte[] CResult_CVec_u8ZIOErrorZ_get_ok(long owner);
	// enum LDKIOError CResult_CVec_u8ZIOErrorZ_get_err(LDKCResult_CVec_u8ZIOErrorZ *NONNULL_PTR owner);
	public static native IOError CResult_CVec_u8ZIOErrorZ_get_err(long owner);
	// struct LDKCVec_StrZ CResult_CVec_StrZIOErrorZ_get_ok(LDKCResult_CVec_StrZIOErrorZ *NONNULL_PTR owner);
	public static native String[] CResult_CVec_StrZIOErrorZ_get_ok(long owner);
	// enum LDKIOError CResult_CVec_StrZIOErrorZ_get_err(LDKCResult_CVec_StrZIOErrorZ *NONNULL_PTR owner);
	public static native IOError CResult_CVec_StrZIOErrorZ_get_err(long owner);
	// struct LDKStr C3Tuple_StrStrStrZ_get_a(LDKC3Tuple_StrStrStrZ *NONNULL_PTR owner);
	public static native String C3Tuple_StrStrStrZ_get_a(long owner);
	// struct LDKStr C3Tuple_StrStrStrZ_get_b(LDKC3Tuple_StrStrStrZ *NONNULL_PTR owner);
	public static native String C3Tuple_StrStrStrZ_get_b(long owner);
	// struct LDKStr C3Tuple_StrStrStrZ_get_c(LDKC3Tuple_StrStrStrZ *NONNULL_PTR owner);
	public static native String C3Tuple_StrStrStrZ_get_c(long owner);
	// struct LDKCVec_C3Tuple_StrStrStrZZ CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_get_ok(LDKCResult_CVec_C3Tuple_StrStrStrZZIOErrorZ *NONNULL_PTR owner);
	public static native long[] CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_get_ok(long owner);
	// enum LDKIOError CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_get_err(LDKCResult_CVec_C3Tuple_StrStrStrZZIOErrorZ *NONNULL_PTR owner);
	public static native IOError CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_get_err(long owner);
	// struct LDKCVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZ CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_get_ok(LDKCResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ *NONNULL_PTR owner);
	public static native long[] CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_get_ok(long owner);
	// enum LDKIOError CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_get_err(LDKCResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ *NONNULL_PTR owner);
	public static native IOError CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_get_err(long owner);
	// struct LDKC2Tuple_ThirtyTwoBytesChannelMonitorZ CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_get_ok(LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ *NONNULL_PTR owner);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_get_ok(long owner);
	// enum LDKIOError CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_get_err(LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ *NONNULL_PTR owner);
	public static native IOError CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_get_err(long owner);
	// struct LDKMonitorName CResult_MonitorNameIOErrorZ_get_ok(LDKCResult_MonitorNameIOErrorZ *NONNULL_PTR owner);
	public static native long CResult_MonitorNameIOErrorZ_get_ok(long owner);
	// enum LDKIOError CResult_MonitorNameIOErrorZ_get_err(LDKCResult_MonitorNameIOErrorZ *NONNULL_PTR owner);
	public static native IOError CResult_MonitorNameIOErrorZ_get_err(long owner);
	// struct LDKUpdateName CResult_UpdateNameIOErrorZ_get_ok(LDKCResult_UpdateNameIOErrorZ *NONNULL_PTR owner);
	public static native long CResult_UpdateNameIOErrorZ_get_ok(long owner);
	// enum LDKIOError CResult_UpdateNameIOErrorZ_get_err(LDKCResult_UpdateNameIOErrorZ *NONNULL_PTR owner);
	public static native IOError CResult_UpdateNameIOErrorZ_get_err(long owner);
	// struct LDKInvoiceRequest CResult_InvoiceRequestBolt12SemanticErrorZ_get_ok(LDKCResult_InvoiceRequestBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native long CResult_InvoiceRequestBolt12SemanticErrorZ_get_ok(long owner);
	// enum LDKBolt12SemanticError CResult_InvoiceRequestBolt12SemanticErrorZ_get_err(LDKCResult_InvoiceRequestBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native Bolt12SemanticError CResult_InvoiceRequestBolt12SemanticErrorZ_get_err(long owner);
	// struct LDKInvoiceWithExplicitSigningPubkeyBuilder CResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ_get_ok(LDKCResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native long CResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ_get_ok(long owner);
	// enum LDKBolt12SemanticError CResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ_get_err(LDKCResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native Bolt12SemanticError CResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ_get_err(long owner);
	// struct LDKVerifiedInvoiceRequest CResult_VerifiedInvoiceRequestNoneZ_get_ok(LDKCResult_VerifiedInvoiceRequestNoneZ *NONNULL_PTR owner);
	public static native long CResult_VerifiedInvoiceRequestNoneZ_get_ok(long owner);
	// void CResult_VerifiedInvoiceRequestNoneZ_get_err(LDKCResult_VerifiedInvoiceRequestNoneZ *NONNULL_PTR owner);
	public static native void CResult_VerifiedInvoiceRequestNoneZ_get_err(long owner);
	// struct LDKInvoiceWithDerivedSigningPubkeyBuilder CResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ_get_ok(LDKCResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native long CResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ_get_ok(long owner);
	// enum LDKBolt12SemanticError CResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ_get_err(LDKCResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ *NONNULL_PTR owner);
	public static native Bolt12SemanticError CResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ_get_err(long owner);
	// struct LDKInvoiceRequest CResult_InvoiceRequestDecodeErrorZ_get_ok(LDKCResult_InvoiceRequestDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InvoiceRequestDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_InvoiceRequestDecodeErrorZ_get_err(LDKCResult_InvoiceRequestDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InvoiceRequestDecodeErrorZ_get_err(long owner);
	// struct LDKInvoiceRequestFields CResult_InvoiceRequestFieldsDecodeErrorZ_get_ok(LDKCResult_InvoiceRequestFieldsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InvoiceRequestFieldsDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_InvoiceRequestFieldsDecodeErrorZ_get_err(LDKCResult_InvoiceRequestFieldsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InvoiceRequestFieldsDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_ECDSASignatureZ {
		private LDKCOption_ECDSASignatureZ() {}
		public final static class Some extends LDKCOption_ECDSASignatureZ {
			public byte[] some;
			Some(byte[] some) { this.some = some; }
		}
		public final static class None extends LDKCOption_ECDSASignatureZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_ECDSASignatureZ.init(); }
	public static native LDKCOption_ECDSASignatureZ LDKCOption_ECDSASignatureZ_ref_from_ptr(long ptr);
	public static class LDKCOption_i64Z {
		private LDKCOption_i64Z() {}
		public final static class Some extends LDKCOption_i64Z {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_i64Z {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_i64Z.init(); }
	public static native LDKCOption_i64Z LDKCOption_i64Z_ref_from_ptr(long ptr);
	// struct LDKSocketAddress CResult_SocketAddressDecodeErrorZ_get_ok(LDKCResult_SocketAddressDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_SocketAddressDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_SocketAddressDecodeErrorZ_get_err(LDKCResult_SocketAddressDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_SocketAddressDecodeErrorZ_get_err(long owner);
	// struct LDKSocketAddress CResult_SocketAddressSocketAddressParseErrorZ_get_ok(LDKCResult_SocketAddressSocketAddressParseErrorZ *NONNULL_PTR owner);
	public static native long CResult_SocketAddressSocketAddressParseErrorZ_get_ok(long owner);
	// enum LDKSocketAddressParseError CResult_SocketAddressSocketAddressParseErrorZ_get_err(LDKCResult_SocketAddressSocketAddressParseErrorZ *NONNULL_PTR owner);
	public static native SocketAddressParseError CResult_SocketAddressSocketAddressParseErrorZ_get_err(long owner);
	// struct LDKAcceptChannel CResult_AcceptChannelDecodeErrorZ_get_ok(LDKCResult_AcceptChannelDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_AcceptChannelDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_AcceptChannelDecodeErrorZ_get_err(LDKCResult_AcceptChannelDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_AcceptChannelDecodeErrorZ_get_err(long owner);
	// struct LDKAcceptChannelV2 CResult_AcceptChannelV2DecodeErrorZ_get_ok(LDKCResult_AcceptChannelV2DecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_AcceptChannelV2DecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_AcceptChannelV2DecodeErrorZ_get_err(LDKCResult_AcceptChannelV2DecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_AcceptChannelV2DecodeErrorZ_get_err(long owner);
	// struct LDKStfu CResult_StfuDecodeErrorZ_get_ok(LDKCResult_StfuDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_StfuDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_StfuDecodeErrorZ_get_err(LDKCResult_StfuDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_StfuDecodeErrorZ_get_err(long owner);
	// struct LDKSpliceInit CResult_SpliceInitDecodeErrorZ_get_ok(LDKCResult_SpliceInitDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_SpliceInitDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_SpliceInitDecodeErrorZ_get_err(LDKCResult_SpliceInitDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_SpliceInitDecodeErrorZ_get_err(long owner);
	// struct LDKSpliceAck CResult_SpliceAckDecodeErrorZ_get_ok(LDKCResult_SpliceAckDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_SpliceAckDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_SpliceAckDecodeErrorZ_get_err(LDKCResult_SpliceAckDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_SpliceAckDecodeErrorZ_get_err(long owner);
	// struct LDKSpliceLocked CResult_SpliceLockedDecodeErrorZ_get_ok(LDKCResult_SpliceLockedDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_SpliceLockedDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_SpliceLockedDecodeErrorZ_get_err(LDKCResult_SpliceLockedDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_SpliceLockedDecodeErrorZ_get_err(long owner);
	// struct LDKTxAddInput CResult_TxAddInputDecodeErrorZ_get_ok(LDKCResult_TxAddInputDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxAddInputDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_TxAddInputDecodeErrorZ_get_err(LDKCResult_TxAddInputDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxAddInputDecodeErrorZ_get_err(long owner);
	// struct LDKTxAddOutput CResult_TxAddOutputDecodeErrorZ_get_ok(LDKCResult_TxAddOutputDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxAddOutputDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_TxAddOutputDecodeErrorZ_get_err(LDKCResult_TxAddOutputDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxAddOutputDecodeErrorZ_get_err(long owner);
	// struct LDKTxRemoveInput CResult_TxRemoveInputDecodeErrorZ_get_ok(LDKCResult_TxRemoveInputDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxRemoveInputDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_TxRemoveInputDecodeErrorZ_get_err(LDKCResult_TxRemoveInputDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxRemoveInputDecodeErrorZ_get_err(long owner);
	// struct LDKTxRemoveOutput CResult_TxRemoveOutputDecodeErrorZ_get_ok(LDKCResult_TxRemoveOutputDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxRemoveOutputDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_TxRemoveOutputDecodeErrorZ_get_err(LDKCResult_TxRemoveOutputDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxRemoveOutputDecodeErrorZ_get_err(long owner);
	// struct LDKTxComplete CResult_TxCompleteDecodeErrorZ_get_ok(LDKCResult_TxCompleteDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxCompleteDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_TxCompleteDecodeErrorZ_get_err(LDKCResult_TxCompleteDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxCompleteDecodeErrorZ_get_err(long owner);
	// struct LDKTxSignatures CResult_TxSignaturesDecodeErrorZ_get_ok(LDKCResult_TxSignaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxSignaturesDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_TxSignaturesDecodeErrorZ_get_err(LDKCResult_TxSignaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxSignaturesDecodeErrorZ_get_err(long owner);
	// struct LDKTxInitRbf CResult_TxInitRbfDecodeErrorZ_get_ok(LDKCResult_TxInitRbfDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxInitRbfDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_TxInitRbfDecodeErrorZ_get_err(LDKCResult_TxInitRbfDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxInitRbfDecodeErrorZ_get_err(long owner);
	// struct LDKTxAckRbf CResult_TxAckRbfDecodeErrorZ_get_ok(LDKCResult_TxAckRbfDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxAckRbfDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_TxAckRbfDecodeErrorZ_get_err(LDKCResult_TxAckRbfDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxAckRbfDecodeErrorZ_get_err(long owner);
	// struct LDKTxAbort CResult_TxAbortDecodeErrorZ_get_ok(LDKCResult_TxAbortDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxAbortDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_TxAbortDecodeErrorZ_get_err(LDKCResult_TxAbortDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxAbortDecodeErrorZ_get_err(long owner);
	// struct LDKAnnouncementSignatures CResult_AnnouncementSignaturesDecodeErrorZ_get_ok(LDKCResult_AnnouncementSignaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_AnnouncementSignaturesDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_AnnouncementSignaturesDecodeErrorZ_get_err(LDKCResult_AnnouncementSignaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_AnnouncementSignaturesDecodeErrorZ_get_err(long owner);
	// struct LDKChannelReestablish CResult_ChannelReestablishDecodeErrorZ_get_ok(LDKCResult_ChannelReestablishDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelReestablishDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelReestablishDecodeErrorZ_get_err(LDKCResult_ChannelReestablishDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelReestablishDecodeErrorZ_get_err(long owner);
	// struct LDKClosingSigned CResult_ClosingSignedDecodeErrorZ_get_ok(LDKCResult_ClosingSignedDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ClosingSignedDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ClosingSignedDecodeErrorZ_get_err(LDKCResult_ClosingSignedDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ClosingSignedDecodeErrorZ_get_err(long owner);
	// struct LDKClosingSignedFeeRange CResult_ClosingSignedFeeRangeDecodeErrorZ_get_ok(LDKCResult_ClosingSignedFeeRangeDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ClosingSignedFeeRangeDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ClosingSignedFeeRangeDecodeErrorZ_get_err(LDKCResult_ClosingSignedFeeRangeDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ClosingSignedFeeRangeDecodeErrorZ_get_err(long owner);
	// struct LDKCommitmentSignedBatch CResult_CommitmentSignedBatchDecodeErrorZ_get_ok(LDKCResult_CommitmentSignedBatchDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_CommitmentSignedBatchDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_CommitmentSignedBatchDecodeErrorZ_get_err(LDKCResult_CommitmentSignedBatchDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_CommitmentSignedBatchDecodeErrorZ_get_err(long owner);
	// struct LDKCommitmentSigned CResult_CommitmentSignedDecodeErrorZ_get_ok(LDKCResult_CommitmentSignedDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_CommitmentSignedDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_CommitmentSignedDecodeErrorZ_get_err(LDKCResult_CommitmentSignedDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_CommitmentSignedDecodeErrorZ_get_err(long owner);
	// struct LDKFundingCreated CResult_FundingCreatedDecodeErrorZ_get_ok(LDKCResult_FundingCreatedDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_FundingCreatedDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_FundingCreatedDecodeErrorZ_get_err(LDKCResult_FundingCreatedDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_FundingCreatedDecodeErrorZ_get_err(long owner);
	// struct LDKFundingSigned CResult_FundingSignedDecodeErrorZ_get_ok(LDKCResult_FundingSignedDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_FundingSignedDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_FundingSignedDecodeErrorZ_get_err(LDKCResult_FundingSignedDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_FundingSignedDecodeErrorZ_get_err(long owner);
	// struct LDKChannelReady CResult_ChannelReadyDecodeErrorZ_get_ok(LDKCResult_ChannelReadyDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelReadyDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelReadyDecodeErrorZ_get_err(LDKCResult_ChannelReadyDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelReadyDecodeErrorZ_get_err(long owner);
	// struct LDKInit CResult_InitDecodeErrorZ_get_ok(LDKCResult_InitDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InitDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_InitDecodeErrorZ_get_err(LDKCResult_InitDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InitDecodeErrorZ_get_err(long owner);
	// struct LDKOpenChannel CResult_OpenChannelDecodeErrorZ_get_ok(LDKCResult_OpenChannelDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OpenChannelDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_OpenChannelDecodeErrorZ_get_err(LDKCResult_OpenChannelDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OpenChannelDecodeErrorZ_get_err(long owner);
	// struct LDKOpenChannelV2 CResult_OpenChannelV2DecodeErrorZ_get_ok(LDKCResult_OpenChannelV2DecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OpenChannelV2DecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_OpenChannelV2DecodeErrorZ_get_err(LDKCResult_OpenChannelV2DecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OpenChannelV2DecodeErrorZ_get_err(long owner);
	// struct LDKRevokeAndACK CResult_RevokeAndACKDecodeErrorZ_get_ok(LDKCResult_RevokeAndACKDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RevokeAndACKDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_RevokeAndACKDecodeErrorZ_get_err(LDKCResult_RevokeAndACKDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RevokeAndACKDecodeErrorZ_get_err(long owner);
	// struct LDKShutdown CResult_ShutdownDecodeErrorZ_get_ok(LDKCResult_ShutdownDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ShutdownDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ShutdownDecodeErrorZ_get_err(LDKCResult_ShutdownDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ShutdownDecodeErrorZ_get_err(long owner);
	// struct LDKUpdateFailHTLC CResult_UpdateFailHTLCDecodeErrorZ_get_ok(LDKCResult_UpdateFailHTLCDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UpdateFailHTLCDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_UpdateFailHTLCDecodeErrorZ_get_err(LDKCResult_UpdateFailHTLCDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UpdateFailHTLCDecodeErrorZ_get_err(long owner);
	// struct LDKUpdateFailMalformedHTLC CResult_UpdateFailMalformedHTLCDecodeErrorZ_get_ok(LDKCResult_UpdateFailMalformedHTLCDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UpdateFailMalformedHTLCDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_UpdateFailMalformedHTLCDecodeErrorZ_get_err(LDKCResult_UpdateFailMalformedHTLCDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UpdateFailMalformedHTLCDecodeErrorZ_get_err(long owner);
	// struct LDKUpdateFee CResult_UpdateFeeDecodeErrorZ_get_ok(LDKCResult_UpdateFeeDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UpdateFeeDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_UpdateFeeDecodeErrorZ_get_err(LDKCResult_UpdateFeeDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UpdateFeeDecodeErrorZ_get_err(long owner);
	// struct LDKUpdateFulfillHTLC CResult_UpdateFulfillHTLCDecodeErrorZ_get_ok(LDKCResult_UpdateFulfillHTLCDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UpdateFulfillHTLCDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_UpdateFulfillHTLCDecodeErrorZ_get_err(LDKCResult_UpdateFulfillHTLCDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UpdateFulfillHTLCDecodeErrorZ_get_err(long owner);
	// struct LDKOnionPacket CResult_OnionPacketDecodeErrorZ_get_ok(LDKCResult_OnionPacketDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OnionPacketDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_OnionPacketDecodeErrorZ_get_err(LDKCResult_OnionPacketDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OnionPacketDecodeErrorZ_get_err(long owner);
	// struct LDKUpdateAddHTLC CResult_UpdateAddHTLCDecodeErrorZ_get_ok(LDKCResult_UpdateAddHTLCDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UpdateAddHTLCDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_UpdateAddHTLCDecodeErrorZ_get_err(LDKCResult_UpdateAddHTLCDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UpdateAddHTLCDecodeErrorZ_get_err(long owner);
	// struct LDKOnionMessage CResult_OnionMessageDecodeErrorZ_get_ok(LDKCResult_OnionMessageDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OnionMessageDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_OnionMessageDecodeErrorZ_get_err(LDKCResult_OnionMessageDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OnionMessageDecodeErrorZ_get_err(long owner);
	// struct LDKFinalOnionHopData CResult_FinalOnionHopDataDecodeErrorZ_get_ok(LDKCResult_FinalOnionHopDataDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_FinalOnionHopDataDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_FinalOnionHopDataDecodeErrorZ_get_err(LDKCResult_FinalOnionHopDataDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_FinalOnionHopDataDecodeErrorZ_get_err(long owner);
	// struct LDKPing CResult_PingDecodeErrorZ_get_ok(LDKCResult_PingDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PingDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_PingDecodeErrorZ_get_err(LDKCResult_PingDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PingDecodeErrorZ_get_err(long owner);
	// struct LDKPong CResult_PongDecodeErrorZ_get_ok(LDKCResult_PongDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PongDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_PongDecodeErrorZ_get_err(LDKCResult_PongDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PongDecodeErrorZ_get_err(long owner);
	// struct LDKUnsignedChannelAnnouncement CResult_UnsignedChannelAnnouncementDecodeErrorZ_get_ok(LDKCResult_UnsignedChannelAnnouncementDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UnsignedChannelAnnouncementDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_UnsignedChannelAnnouncementDecodeErrorZ_get_err(LDKCResult_UnsignedChannelAnnouncementDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UnsignedChannelAnnouncementDecodeErrorZ_get_err(long owner);
	// struct LDKChannelAnnouncement CResult_ChannelAnnouncementDecodeErrorZ_get_ok(LDKCResult_ChannelAnnouncementDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelAnnouncementDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelAnnouncementDecodeErrorZ_get_err(LDKCResult_ChannelAnnouncementDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelAnnouncementDecodeErrorZ_get_err(long owner);
	// struct LDKUnsignedChannelUpdate CResult_UnsignedChannelUpdateDecodeErrorZ_get_ok(LDKCResult_UnsignedChannelUpdateDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UnsignedChannelUpdateDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_UnsignedChannelUpdateDecodeErrorZ_get_err(LDKCResult_UnsignedChannelUpdateDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UnsignedChannelUpdateDecodeErrorZ_get_err(long owner);
	// struct LDKChannelUpdate CResult_ChannelUpdateDecodeErrorZ_get_ok(LDKCResult_ChannelUpdateDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelUpdateDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelUpdateDecodeErrorZ_get_err(LDKCResult_ChannelUpdateDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelUpdateDecodeErrorZ_get_err(long owner);
	// struct LDKErrorMessage CResult_ErrorMessageDecodeErrorZ_get_ok(LDKCResult_ErrorMessageDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ErrorMessageDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ErrorMessageDecodeErrorZ_get_err(LDKCResult_ErrorMessageDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ErrorMessageDecodeErrorZ_get_err(long owner);
	// struct LDKWarningMessage CResult_WarningMessageDecodeErrorZ_get_ok(LDKCResult_WarningMessageDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_WarningMessageDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_WarningMessageDecodeErrorZ_get_err(LDKCResult_WarningMessageDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_WarningMessageDecodeErrorZ_get_err(long owner);
	// struct LDKUnsignedNodeAnnouncement CResult_UnsignedNodeAnnouncementDecodeErrorZ_get_ok(LDKCResult_UnsignedNodeAnnouncementDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UnsignedNodeAnnouncementDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_UnsignedNodeAnnouncementDecodeErrorZ_get_err(LDKCResult_UnsignedNodeAnnouncementDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UnsignedNodeAnnouncementDecodeErrorZ_get_err(long owner);
	// struct LDKNodeAnnouncement CResult_NodeAnnouncementDecodeErrorZ_get_ok(LDKCResult_NodeAnnouncementDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NodeAnnouncementDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_NodeAnnouncementDecodeErrorZ_get_err(LDKCResult_NodeAnnouncementDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NodeAnnouncementDecodeErrorZ_get_err(long owner);
	// struct LDKQueryShortChannelIds CResult_QueryShortChannelIdsDecodeErrorZ_get_ok(LDKCResult_QueryShortChannelIdsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_QueryShortChannelIdsDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_QueryShortChannelIdsDecodeErrorZ_get_err(LDKCResult_QueryShortChannelIdsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_QueryShortChannelIdsDecodeErrorZ_get_err(long owner);
	// struct LDKReplyShortChannelIdsEnd CResult_ReplyShortChannelIdsEndDecodeErrorZ_get_ok(LDKCResult_ReplyShortChannelIdsEndDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ReplyShortChannelIdsEndDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ReplyShortChannelIdsEndDecodeErrorZ_get_err(LDKCResult_ReplyShortChannelIdsEndDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ReplyShortChannelIdsEndDecodeErrorZ_get_err(long owner);
	// struct LDKQueryChannelRange CResult_QueryChannelRangeDecodeErrorZ_get_ok(LDKCResult_QueryChannelRangeDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_QueryChannelRangeDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_QueryChannelRangeDecodeErrorZ_get_err(LDKCResult_QueryChannelRangeDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_QueryChannelRangeDecodeErrorZ_get_err(long owner);
	// struct LDKReplyChannelRange CResult_ReplyChannelRangeDecodeErrorZ_get_ok(LDKCResult_ReplyChannelRangeDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ReplyChannelRangeDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ReplyChannelRangeDecodeErrorZ_get_err(LDKCResult_ReplyChannelRangeDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ReplyChannelRangeDecodeErrorZ_get_err(long owner);
	// struct LDKGossipTimestampFilter CResult_GossipTimestampFilterDecodeErrorZ_get_ok(LDKCResult_GossipTimestampFilterDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_GossipTimestampFilterDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_GossipTimestampFilterDecodeErrorZ_get_err(LDKCResult_GossipTimestampFilterDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_GossipTimestampFilterDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_InboundHTLCStateDetailsZ {
		private LDKCOption_InboundHTLCStateDetailsZ() {}
		public final static class Some extends LDKCOption_InboundHTLCStateDetailsZ {
			public org.ldk.enums.InboundHTLCStateDetails some;
			Some(org.ldk.enums.InboundHTLCStateDetails some) { this.some = some; }
		}
		public final static class None extends LDKCOption_InboundHTLCStateDetailsZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_InboundHTLCStateDetailsZ.init(); }
	public static native LDKCOption_InboundHTLCStateDetailsZ LDKCOption_InboundHTLCStateDetailsZ_ref_from_ptr(long ptr);
	// struct LDKCOption_InboundHTLCStateDetailsZ CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_get_ok(LDKCResult_COption_InboundHTLCStateDetailsZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_get_err(LDKCResult_COption_InboundHTLCStateDetailsZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_get_err(long owner);
	// struct LDKInboundHTLCDetails CResult_InboundHTLCDetailsDecodeErrorZ_get_ok(LDKCResult_InboundHTLCDetailsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InboundHTLCDetailsDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_InboundHTLCDetailsDecodeErrorZ_get_err(LDKCResult_InboundHTLCDetailsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InboundHTLCDetailsDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_OutboundHTLCStateDetailsZ {
		private LDKCOption_OutboundHTLCStateDetailsZ() {}
		public final static class Some extends LDKCOption_OutboundHTLCStateDetailsZ {
			public org.ldk.enums.OutboundHTLCStateDetails some;
			Some(org.ldk.enums.OutboundHTLCStateDetails some) { this.some = some; }
		}
		public final static class None extends LDKCOption_OutboundHTLCStateDetailsZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_OutboundHTLCStateDetailsZ.init(); }
	public static native LDKCOption_OutboundHTLCStateDetailsZ LDKCOption_OutboundHTLCStateDetailsZ_ref_from_ptr(long ptr);
	// struct LDKCOption_OutboundHTLCStateDetailsZ CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_get_ok(LDKCResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_get_err(LDKCResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_get_err(long owner);
	// struct LDKOutboundHTLCDetails CResult_OutboundHTLCDetailsDecodeErrorZ_get_ok(LDKCResult_OutboundHTLCDetailsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OutboundHTLCDetailsDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_OutboundHTLCDetailsDecodeErrorZ_get_err(LDKCResult_OutboundHTLCDetailsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OutboundHTLCDetailsDecodeErrorZ_get_err(long owner);
	// struct LDKCounterpartyForwardingInfo CResult_CounterpartyForwardingInfoDecodeErrorZ_get_ok(LDKCResult_CounterpartyForwardingInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_CounterpartyForwardingInfoDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_CounterpartyForwardingInfoDecodeErrorZ_get_err(LDKCResult_CounterpartyForwardingInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_CounterpartyForwardingInfoDecodeErrorZ_get_err(long owner);
	// struct LDKChannelCounterparty CResult_ChannelCounterpartyDecodeErrorZ_get_ok(LDKCResult_ChannelCounterpartyDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelCounterpartyDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelCounterpartyDecodeErrorZ_get_err(LDKCResult_ChannelCounterpartyDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelCounterpartyDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_ChannelShutdownStateZ {
		private LDKCOption_ChannelShutdownStateZ() {}
		public final static class Some extends LDKCOption_ChannelShutdownStateZ {
			public org.ldk.enums.ChannelShutdownState some;
			Some(org.ldk.enums.ChannelShutdownState some) { this.some = some; }
		}
		public final static class None extends LDKCOption_ChannelShutdownStateZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_ChannelShutdownStateZ.init(); }
	public static native LDKCOption_ChannelShutdownStateZ LDKCOption_ChannelShutdownStateZ_ref_from_ptr(long ptr);
	// struct LDKChannelDetails CResult_ChannelDetailsDecodeErrorZ_get_ok(LDKCResult_ChannelDetailsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelDetailsDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelDetailsDecodeErrorZ_get_err(LDKCResult_ChannelDetailsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelDetailsDecodeErrorZ_get_err(long owner);
	// enum LDKChannelShutdownState CResult_ChannelShutdownStateDecodeErrorZ_get_ok(LDKCResult_ChannelShutdownStateDecodeErrorZ *NONNULL_PTR owner);
	public static native ChannelShutdownState CResult_ChannelShutdownStateDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelShutdownStateDecodeErrorZ_get_err(LDKCResult_ChannelShutdownStateDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelShutdownStateDecodeErrorZ_get_err(long owner);
	// struct LDKRawLSPSMessage CResult_RawLSPSMessageDecodeErrorZ_get_ok(LDKCResult_RawLSPSMessageDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RawLSPSMessageDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_RawLSPSMessageDecodeErrorZ_get_err(LDKCResult_RawLSPSMessageDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RawLSPSMessageDecodeErrorZ_get_err(long owner);
	// struct LDKLSPSDateTime CResult_LSPSDateTimeNoneZ_get_ok(LDKCResult_LSPSDateTimeNoneZ *NONNULL_PTR owner);
	public static native long CResult_LSPSDateTimeNoneZ_get_ok(long owner);
	// void CResult_LSPSDateTimeNoneZ_get_err(LDKCResult_LSPSDateTimeNoneZ *NONNULL_PTR owner);
	public static native void CResult_LSPSDateTimeNoneZ_get_err(long owner);
	// struct LDKHeldHtlcAvailable CResult_HeldHtlcAvailableDecodeErrorZ_get_ok(LDKCResult_HeldHtlcAvailableDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HeldHtlcAvailableDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_HeldHtlcAvailableDecodeErrorZ_get_err(LDKCResult_HeldHtlcAvailableDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HeldHtlcAvailableDecodeErrorZ_get_err(long owner);
	// struct LDKReleaseHeldHtlc CResult_ReleaseHeldHtlcDecodeErrorZ_get_ok(LDKCResult_ReleaseHeldHtlcDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ReleaseHeldHtlcDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ReleaseHeldHtlcDecodeErrorZ_get_err(LDKCResult_ReleaseHeldHtlcDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ReleaseHeldHtlcDecodeErrorZ_get_err(long owner);
	// struct LDKAsyncPaymentsMessage CResult_AsyncPaymentsMessageDecodeErrorZ_get_ok(LDKCResult_AsyncPaymentsMessageDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_AsyncPaymentsMessageDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_AsyncPaymentsMessageDecodeErrorZ_get_err(LDKCResult_AsyncPaymentsMessageDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_AsyncPaymentsMessageDecodeErrorZ_get_err(long owner);
	// struct LDKOffersMessage CResult_OffersMessageDecodeErrorZ_get_ok(LDKCResult_OffersMessageDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OffersMessageDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_OffersMessageDecodeErrorZ_get_err(LDKCResult_OffersMessageDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OffersMessageDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_HTLCClaimZ {
		private LDKCOption_HTLCClaimZ() {}
		public final static class Some extends LDKCOption_HTLCClaimZ {
			public org.ldk.enums.HTLCClaim some;
			Some(org.ldk.enums.HTLCClaim some) { this.some = some; }
		}
		public final static class None extends LDKCOption_HTLCClaimZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_HTLCClaimZ.init(); }
	public static native LDKCOption_HTLCClaimZ LDKCOption_HTLCClaimZ_ref_from_ptr(long ptr);
	// struct LDKCounterpartyCommitmentSecrets CResult_CounterpartyCommitmentSecretsDecodeErrorZ_get_ok(LDKCResult_CounterpartyCommitmentSecretsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_CounterpartyCommitmentSecretsDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_CounterpartyCommitmentSecretsDecodeErrorZ_get_err(LDKCResult_CounterpartyCommitmentSecretsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_CounterpartyCommitmentSecretsDecodeErrorZ_get_err(long owner);
	// struct LDKTxCreationKeys CResult_TxCreationKeysDecodeErrorZ_get_ok(LDKCResult_TxCreationKeysDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxCreationKeysDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_TxCreationKeysDecodeErrorZ_get_err(LDKCResult_TxCreationKeysDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TxCreationKeysDecodeErrorZ_get_err(long owner);
	// struct LDKChannelPublicKeys CResult_ChannelPublicKeysDecodeErrorZ_get_ok(LDKCResult_ChannelPublicKeysDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelPublicKeysDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelPublicKeysDecodeErrorZ_get_err(LDKCResult_ChannelPublicKeysDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelPublicKeysDecodeErrorZ_get_err(long owner);
	// struct LDKHTLCOutputInCommitment CResult_HTLCOutputInCommitmentDecodeErrorZ_get_ok(LDKCResult_HTLCOutputInCommitmentDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HTLCOutputInCommitmentDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_HTLCOutputInCommitmentDecodeErrorZ_get_err(LDKCResult_HTLCOutputInCommitmentDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HTLCOutputInCommitmentDecodeErrorZ_get_err(long owner);
	// struct LDKCounterpartyChannelTransactionParameters CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_get_ok(LDKCResult_CounterpartyChannelTransactionParametersDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_get_err(LDKCResult_CounterpartyChannelTransactionParametersDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_get_err(long owner);
	// struct LDKChannelTransactionParameters CResult_ChannelTransactionParametersDecodeErrorZ_get_ok(LDKCResult_ChannelTransactionParametersDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelTransactionParametersDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelTransactionParametersDecodeErrorZ_get_err(LDKCResult_ChannelTransactionParametersDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelTransactionParametersDecodeErrorZ_get_err(long owner);
	// struct LDKHolderCommitmentTransaction CResult_HolderCommitmentTransactionDecodeErrorZ_get_ok(LDKCResult_HolderCommitmentTransactionDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HolderCommitmentTransactionDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_HolderCommitmentTransactionDecodeErrorZ_get_err(LDKCResult_HolderCommitmentTransactionDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HolderCommitmentTransactionDecodeErrorZ_get_err(long owner);
	// struct LDKBuiltCommitmentTransaction CResult_BuiltCommitmentTransactionDecodeErrorZ_get_ok(LDKCResult_BuiltCommitmentTransactionDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BuiltCommitmentTransactionDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_BuiltCommitmentTransactionDecodeErrorZ_get_err(LDKCResult_BuiltCommitmentTransactionDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BuiltCommitmentTransactionDecodeErrorZ_get_err(long owner);
	// struct LDKTrustedClosingTransaction CResult_TrustedClosingTransactionNoneZ_get_ok(LDKCResult_TrustedClosingTransactionNoneZ *NONNULL_PTR owner);
	public static native long CResult_TrustedClosingTransactionNoneZ_get_ok(long owner);
	// void CResult_TrustedClosingTransactionNoneZ_get_err(LDKCResult_TrustedClosingTransactionNoneZ *NONNULL_PTR owner);
	public static native void CResult_TrustedClosingTransactionNoneZ_get_err(long owner);
	// struct LDKCommitmentTransaction CResult_CommitmentTransactionDecodeErrorZ_get_ok(LDKCResult_CommitmentTransactionDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_CommitmentTransactionDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_CommitmentTransactionDecodeErrorZ_get_err(LDKCResult_CommitmentTransactionDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_CommitmentTransactionDecodeErrorZ_get_err(long owner);
	// struct LDKTrustedCommitmentTransaction CResult_TrustedCommitmentTransactionNoneZ_get_ok(LDKCResult_TrustedCommitmentTransactionNoneZ *NONNULL_PTR owner);
	public static native long CResult_TrustedCommitmentTransactionNoneZ_get_ok(long owner);
	// void CResult_TrustedCommitmentTransactionNoneZ_get_err(LDKCResult_TrustedCommitmentTransactionNoneZ *NONNULL_PTR owner);
	public static native void CResult_TrustedCommitmentTransactionNoneZ_get_err(long owner);
	// struct LDKCVec_ECDSASignatureZ CResult_CVec_ECDSASignatureZNoneZ_get_ok(LDKCResult_CVec_ECDSASignatureZNoneZ *NONNULL_PTR owner);
	public static native byte[][] CResult_CVec_ECDSASignatureZNoneZ_get_ok(long owner);
	// void CResult_CVec_ECDSASignatureZNoneZ_get_err(LDKCResult_CVec_ECDSASignatureZNoneZ *NONNULL_PTR owner);
	public static native void CResult_CVec_ECDSASignatureZNoneZ_get_err(long owner);
	public static class LDKCOption_usizeZ {
		private LDKCOption_usizeZ() {}
		public final static class Some extends LDKCOption_usizeZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_usizeZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_usizeZ.init(); }
	public static native LDKCOption_usizeZ LDKCOption_usizeZ_ref_from_ptr(long ptr);
	// struct LDKShutdownScript CResult_ShutdownScriptDecodeErrorZ_get_ok(LDKCResult_ShutdownScriptDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ShutdownScriptDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ShutdownScriptDecodeErrorZ_get_err(LDKCResult_ShutdownScriptDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ShutdownScriptDecodeErrorZ_get_err(long owner);
	// struct LDKShutdownScript CResult_ShutdownScriptInvalidShutdownScriptZ_get_ok(LDKCResult_ShutdownScriptInvalidShutdownScriptZ *NONNULL_PTR owner);
	public static native long CResult_ShutdownScriptInvalidShutdownScriptZ_get_ok(long owner);
	// struct LDKInvalidShutdownScript CResult_ShutdownScriptInvalidShutdownScriptZ_get_err(LDKCResult_ShutdownScriptInvalidShutdownScriptZ *NONNULL_PTR owner);
	public static native long CResult_ShutdownScriptInvalidShutdownScriptZ_get_err(long owner);
	// uint64_t CResult_u64NoneZ_get_ok(LDKCResult_u64NoneZ *NONNULL_PTR owner);
	public static native long CResult_u64NoneZ_get_ok(long owner);
	// void CResult_u64NoneZ_get_err(LDKCResult_u64NoneZ *NONNULL_PTR owner);
	public static native void CResult_u64NoneZ_get_err(long owner);
	public static class LDKFundingInfo {
		private LDKFundingInfo() {}
		public final static class Tx extends LDKFundingInfo {
			public byte[] transaction;
			Tx(byte[] transaction) { this.transaction = transaction; }
		}
		public final static class OutPoint extends LDKFundingInfo {
			public long outpoint;
			OutPoint(long outpoint) { this.outpoint = outpoint; }
		}
		static native void init();
	}
	static { LDKFundingInfo.init(); }
	public static native LDKFundingInfo LDKFundingInfo_ref_from_ptr(long ptr);
	// struct LDKFundingInfo CResult_FundingInfoDecodeErrorZ_get_ok(LDKCResult_FundingInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_FundingInfoDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_FundingInfoDecodeErrorZ_get_err(LDKCResult_FundingInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_FundingInfoDecodeErrorZ_get_err(long owner);
	public static class LDKPaymentPurpose {
		private LDKPaymentPurpose() {}
		public final static class Bolt11InvoicePayment extends LDKPaymentPurpose {
			public long payment_preimage;
			public byte[] payment_secret;
			Bolt11InvoicePayment(long payment_preimage, byte[] payment_secret) { this.payment_preimage = payment_preimage; this.payment_secret = payment_secret; }
		}
		public final static class Bolt12OfferPayment extends LDKPaymentPurpose {
			public long payment_preimage;
			public byte[] payment_secret;
			public long payment_context;
			Bolt12OfferPayment(long payment_preimage, byte[] payment_secret, long payment_context) { this.payment_preimage = payment_preimage; this.payment_secret = payment_secret; this.payment_context = payment_context; }
		}
		public final static class Bolt12RefundPayment extends LDKPaymentPurpose {
			public long payment_preimage;
			public byte[] payment_secret;
			public long payment_context;
			Bolt12RefundPayment(long payment_preimage, byte[] payment_secret, long payment_context) { this.payment_preimage = payment_preimage; this.payment_secret = payment_secret; this.payment_context = payment_context; }
		}
		public final static class SpontaneousPayment extends LDKPaymentPurpose {
			public byte[] spontaneous_payment;
			SpontaneousPayment(byte[] spontaneous_payment) { this.spontaneous_payment = spontaneous_payment; }
		}
		static native void init();
	}
	static { LDKPaymentPurpose.init(); }
	public static native LDKPaymentPurpose LDKPaymentPurpose_ref_from_ptr(long ptr);
	// struct LDKPaymentPurpose CResult_PaymentPurposeDecodeErrorZ_get_ok(LDKCResult_PaymentPurposeDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PaymentPurposeDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_PaymentPurposeDecodeErrorZ_get_err(LDKCResult_PaymentPurposeDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PaymentPurposeDecodeErrorZ_get_err(long owner);
	// struct LDKClaimedHTLC CResult_ClaimedHTLCDecodeErrorZ_get_ok(LDKCResult_ClaimedHTLCDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ClaimedHTLCDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ClaimedHTLCDecodeErrorZ_get_err(LDKCResult_ClaimedHTLCDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ClaimedHTLCDecodeErrorZ_get_err(long owner);
	public static class LDKPathFailure {
		private LDKPathFailure() {}
		public final static class InitialSend extends LDKPathFailure {
			public long err;
			InitialSend(long err) { this.err = err; }
		}
		public final static class OnPath extends LDKPathFailure {
			public long network_update;
			OnPath(long network_update) { this.network_update = network_update; }
		}
		static native void init();
	}
	static { LDKPathFailure.init(); }
	public static native LDKPathFailure LDKPathFailure_ref_from_ptr(long ptr);
	public static class LDKCOption_PathFailureZ {
		private LDKCOption_PathFailureZ() {}
		public final static class Some extends LDKCOption_PathFailureZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_PathFailureZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_PathFailureZ.init(); }
	public static native LDKCOption_PathFailureZ LDKCOption_PathFailureZ_ref_from_ptr(long ptr);
	// struct LDKCOption_PathFailureZ CResult_COption_PathFailureZDecodeErrorZ_get_ok(LDKCResult_COption_PathFailureZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_PathFailureZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_COption_PathFailureZDecodeErrorZ_get_err(LDKCResult_COption_PathFailureZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_PathFailureZDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_ClosureReasonZ {
		private LDKCOption_ClosureReasonZ() {}
		public final static class Some extends LDKCOption_ClosureReasonZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_ClosureReasonZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_ClosureReasonZ.init(); }
	public static native LDKCOption_ClosureReasonZ LDKCOption_ClosureReasonZ_ref_from_ptr(long ptr);
	// struct LDKCOption_ClosureReasonZ CResult_COption_ClosureReasonZDecodeErrorZ_get_ok(LDKCResult_COption_ClosureReasonZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_ClosureReasonZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_COption_ClosureReasonZDecodeErrorZ_get_err(LDKCResult_COption_ClosureReasonZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_ClosureReasonZDecodeErrorZ_get_err(long owner);
	public static class LDKHTLCDestination {
		private LDKHTLCDestination() {}
		public final static class NextHopChannel extends LDKHTLCDestination {
			public byte[] node_id;
			public long channel_id;
			NextHopChannel(byte[] node_id, long channel_id) { this.node_id = node_id; this.channel_id = channel_id; }
		}
		public final static class UnknownNextHop extends LDKHTLCDestination {
			public long requested_forward_scid;
			UnknownNextHop(long requested_forward_scid) { this.requested_forward_scid = requested_forward_scid; }
		}
		public final static class InvalidForward extends LDKHTLCDestination {
			public long requested_forward_scid;
			InvalidForward(long requested_forward_scid) { this.requested_forward_scid = requested_forward_scid; }
		}
		public final static class InvalidOnion extends LDKHTLCDestination {
			InvalidOnion() { }
		}
		public final static class FailedPayment extends LDKHTLCDestination {
			public byte[] payment_hash;
			FailedPayment(byte[] payment_hash) { this.payment_hash = payment_hash; }
		}
		static native void init();
	}
	static { LDKHTLCDestination.init(); }
	public static native LDKHTLCDestination LDKHTLCDestination_ref_from_ptr(long ptr);
	public static class LDKCOption_HTLCDestinationZ {
		private LDKCOption_HTLCDestinationZ() {}
		public final static class Some extends LDKCOption_HTLCDestinationZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_HTLCDestinationZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_HTLCDestinationZ.init(); }
	public static native LDKCOption_HTLCDestinationZ LDKCOption_HTLCDestinationZ_ref_from_ptr(long ptr);
	// struct LDKCOption_HTLCDestinationZ CResult_COption_HTLCDestinationZDecodeErrorZ_get_ok(LDKCResult_COption_HTLCDestinationZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_HTLCDestinationZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_COption_HTLCDestinationZDecodeErrorZ_get_err(LDKCResult_COption_HTLCDestinationZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_HTLCDestinationZDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_PaymentFailureReasonZ {
		private LDKCOption_PaymentFailureReasonZ() {}
		public final static class Some extends LDKCOption_PaymentFailureReasonZ {
			public org.ldk.enums.PaymentFailureReason some;
			Some(org.ldk.enums.PaymentFailureReason some) { this.some = some; }
		}
		public final static class None extends LDKCOption_PaymentFailureReasonZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_PaymentFailureReasonZ.init(); }
	public static native LDKCOption_PaymentFailureReasonZ LDKCOption_PaymentFailureReasonZ_ref_from_ptr(long ptr);
	// struct LDKCOption_PaymentFailureReasonZ CResult_COption_PaymentFailureReasonZDecodeErrorZ_get_ok(LDKCResult_COption_PaymentFailureReasonZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_PaymentFailureReasonZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_COption_PaymentFailureReasonZDecodeErrorZ_get_err(LDKCResult_COption_PaymentFailureReasonZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_PaymentFailureReasonZDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_U128Z {
		private LDKCOption_U128Z() {}
		public final static class Some extends LDKCOption_U128Z {
			public byte[] some;
			Some(byte[] some) { this.some = some; }
		}
		public final static class None extends LDKCOption_U128Z {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_U128Z.init(); }
	public static native LDKCOption_U128Z LDKCOption_U128Z_ref_from_ptr(long ptr);
	public static class LDKInboundChannelFunds {
		private LDKInboundChannelFunds() {}
		public final static class PushMsat extends LDKInboundChannelFunds {
			public long push_msat;
			PushMsat(long push_msat) { this.push_msat = push_msat; }
		}
		public final static class DualFunded extends LDKInboundChannelFunds {
			DualFunded() { }
		}
		static native void init();
	}
	static { LDKInboundChannelFunds.init(); }
	public static native LDKInboundChannelFunds LDKInboundChannelFunds_ref_from_ptr(long ptr);
	public static class LDKBumpTransactionEvent {
		private LDKBumpTransactionEvent() {}
		public final static class ChannelClose extends LDKBumpTransactionEvent {
			public long channel_id;
			public byte[] counterparty_node_id;
			public byte[] claim_id;
			public int package_target_feerate_sat_per_1000_weight;
			public byte[] commitment_tx;
			public long commitment_tx_fee_satoshis;
			public long anchor_descriptor;
			public long[] pending_htlcs;
			ChannelClose(long channel_id, byte[] counterparty_node_id, byte[] claim_id, int package_target_feerate_sat_per_1000_weight, byte[] commitment_tx, long commitment_tx_fee_satoshis, long anchor_descriptor, long[] pending_htlcs) { this.channel_id = channel_id; this.counterparty_node_id = counterparty_node_id; this.claim_id = claim_id; this.package_target_feerate_sat_per_1000_weight = package_target_feerate_sat_per_1000_weight; this.commitment_tx = commitment_tx; this.commitment_tx_fee_satoshis = commitment_tx_fee_satoshis; this.anchor_descriptor = anchor_descriptor; this.pending_htlcs = pending_htlcs; }
		}
		public final static class HTLCResolution extends LDKBumpTransactionEvent {
			public long channel_id;
			public byte[] counterparty_node_id;
			public byte[] claim_id;
			public int target_feerate_sat_per_1000_weight;
			public long[] htlc_descriptors;
			public int tx_lock_time;
			HTLCResolution(long channel_id, byte[] counterparty_node_id, byte[] claim_id, int target_feerate_sat_per_1000_weight, long[] htlc_descriptors, int tx_lock_time) { this.channel_id = channel_id; this.counterparty_node_id = counterparty_node_id; this.claim_id = claim_id; this.target_feerate_sat_per_1000_weight = target_feerate_sat_per_1000_weight; this.htlc_descriptors = htlc_descriptors; this.tx_lock_time = tx_lock_time; }
		}
		static native void init();
	}
	static { LDKBumpTransactionEvent.init(); }
	public static native LDKBumpTransactionEvent LDKBumpTransactionEvent_ref_from_ptr(long ptr);
	public static class LDKEvent {
		private LDKEvent() {}
		public final static class FundingGenerationReady extends LDKEvent {
			public long temporary_channel_id;
			public byte[] counterparty_node_id;
			public long channel_value_satoshis;
			public byte[] output_script;
			public byte[] user_channel_id;
			FundingGenerationReady(long temporary_channel_id, byte[] counterparty_node_id, long channel_value_satoshis, byte[] output_script, byte[] user_channel_id) { this.temporary_channel_id = temporary_channel_id; this.counterparty_node_id = counterparty_node_id; this.channel_value_satoshis = channel_value_satoshis; this.output_script = output_script; this.user_channel_id = user_channel_id; }
		}
		public final static class FundingTxBroadcastSafe extends LDKEvent {
			public long channel_id;
			public byte[] user_channel_id;
			public long funding_txo;
			public byte[] counterparty_node_id;
			public long former_temporary_channel_id;
			FundingTxBroadcastSafe(long channel_id, byte[] user_channel_id, long funding_txo, byte[] counterparty_node_id, long former_temporary_channel_id) { this.channel_id = channel_id; this.user_channel_id = user_channel_id; this.funding_txo = funding_txo; this.counterparty_node_id = counterparty_node_id; this.former_temporary_channel_id = former_temporary_channel_id; }
		}
		public final static class PaymentClaimable extends LDKEvent {
			public byte[] receiver_node_id;
			public byte[] payment_hash;
			public long onion_fields;
			public long amount_msat;
			public long counterparty_skimmed_fee_msat;
			public long purpose;
			public long via_channel_id;
			public long via_user_channel_id;
			public long claim_deadline;
			public long payment_id;
			PaymentClaimable(byte[] receiver_node_id, byte[] payment_hash, long onion_fields, long amount_msat, long counterparty_skimmed_fee_msat, long purpose, long via_channel_id, long via_user_channel_id, long claim_deadline, long payment_id) { this.receiver_node_id = receiver_node_id; this.payment_hash = payment_hash; this.onion_fields = onion_fields; this.amount_msat = amount_msat; this.counterparty_skimmed_fee_msat = counterparty_skimmed_fee_msat; this.purpose = purpose; this.via_channel_id = via_channel_id; this.via_user_channel_id = via_user_channel_id; this.claim_deadline = claim_deadline; this.payment_id = payment_id; }
		}
		public final static class PaymentClaimed extends LDKEvent {
			public byte[] receiver_node_id;
			public byte[] payment_hash;
			public long amount_msat;
			public long purpose;
			public long[] htlcs;
			public long sender_intended_total_msat;
			public long onion_fields;
			public long payment_id;
			PaymentClaimed(byte[] receiver_node_id, byte[] payment_hash, long amount_msat, long purpose, long[] htlcs, long sender_intended_total_msat, long onion_fields, long payment_id) { this.receiver_node_id = receiver_node_id; this.payment_hash = payment_hash; this.amount_msat = amount_msat; this.purpose = purpose; this.htlcs = htlcs; this.sender_intended_total_msat = sender_intended_total_msat; this.onion_fields = onion_fields; this.payment_id = payment_id; }
		}
		public final static class ConnectionNeeded extends LDKEvent {
			public byte[] node_id;
			public long[] addresses;
			ConnectionNeeded(byte[] node_id, long[] addresses) { this.node_id = node_id; this.addresses = addresses; }
		}
		public final static class InvoiceReceived extends LDKEvent {
			public byte[] payment_id;
			public long invoice;
			public long context;
			public long responder;
			InvoiceReceived(byte[] payment_id, long invoice, long context, long responder) { this.payment_id = payment_id; this.invoice = invoice; this.context = context; this.responder = responder; }
		}
		public final static class PaymentSent extends LDKEvent {
			public long payment_id;
			public byte[] payment_preimage;
			public byte[] payment_hash;
			public long fee_paid_msat;
			PaymentSent(long payment_id, byte[] payment_preimage, byte[] payment_hash, long fee_paid_msat) { this.payment_id = payment_id; this.payment_preimage = payment_preimage; this.payment_hash = payment_hash; this.fee_paid_msat = fee_paid_msat; }
		}
		public final static class PaymentFailed extends LDKEvent {
			public byte[] payment_id;
			public long payment_hash;
			public long reason;
			PaymentFailed(byte[] payment_id, long payment_hash, long reason) { this.payment_id = payment_id; this.payment_hash = payment_hash; this.reason = reason; }
		}
		public final static class PaymentPathSuccessful extends LDKEvent {
			public byte[] payment_id;
			public long payment_hash;
			public long path;
			PaymentPathSuccessful(byte[] payment_id, long payment_hash, long path) { this.payment_id = payment_id; this.payment_hash = payment_hash; this.path = path; }
		}
		public final static class PaymentPathFailed extends LDKEvent {
			public long payment_id;
			public byte[] payment_hash;
			public boolean payment_failed_permanently;
			public long failure;
			public long path;
			public long short_channel_id;
			PaymentPathFailed(long payment_id, byte[] payment_hash, boolean payment_failed_permanently, long failure, long path, long short_channel_id) { this.payment_id = payment_id; this.payment_hash = payment_hash; this.payment_failed_permanently = payment_failed_permanently; this.failure = failure; this.path = path; this.short_channel_id = short_channel_id; }
		}
		public final static class ProbeSuccessful extends LDKEvent {
			public byte[] payment_id;
			public byte[] payment_hash;
			public long path;
			ProbeSuccessful(byte[] payment_id, byte[] payment_hash, long path) { this.payment_id = payment_id; this.payment_hash = payment_hash; this.path = path; }
		}
		public final static class ProbeFailed extends LDKEvent {
			public byte[] payment_id;
			public byte[] payment_hash;
			public long path;
			public long short_channel_id;
			ProbeFailed(byte[] payment_id, byte[] payment_hash, long path, long short_channel_id) { this.payment_id = payment_id; this.payment_hash = payment_hash; this.path = path; this.short_channel_id = short_channel_id; }
		}
		public final static class PendingHTLCsForwardable extends LDKEvent {
			public long time_forwardable;
			PendingHTLCsForwardable(long time_forwardable) { this.time_forwardable = time_forwardable; }
		}
		public final static class HTLCIntercepted extends LDKEvent {
			public byte[] intercept_id;
			public long requested_next_hop_scid;
			public byte[] payment_hash;
			public long inbound_amount_msat;
			public long expected_outbound_amount_msat;
			HTLCIntercepted(byte[] intercept_id, long requested_next_hop_scid, byte[] payment_hash, long inbound_amount_msat, long expected_outbound_amount_msat) { this.intercept_id = intercept_id; this.requested_next_hop_scid = requested_next_hop_scid; this.payment_hash = payment_hash; this.inbound_amount_msat = inbound_amount_msat; this.expected_outbound_amount_msat = expected_outbound_amount_msat; }
		}
		public final static class SpendableOutputs extends LDKEvent {
			public long[] outputs;
			public long channel_id;
			SpendableOutputs(long[] outputs, long channel_id) { this.outputs = outputs; this.channel_id = channel_id; }
		}
		public final static class PaymentForwarded extends LDKEvent {
			public long prev_channel_id;
			public long next_channel_id;
			public long prev_user_channel_id;
			public long next_user_channel_id;
			public byte[] prev_node_id;
			public byte[] next_node_id;
			public long total_fee_earned_msat;
			public long skimmed_fee_msat;
			public boolean claim_from_onchain_tx;
			public long outbound_amount_forwarded_msat;
			PaymentForwarded(long prev_channel_id, long next_channel_id, long prev_user_channel_id, long next_user_channel_id, byte[] prev_node_id, byte[] next_node_id, long total_fee_earned_msat, long skimmed_fee_msat, boolean claim_from_onchain_tx, long outbound_amount_forwarded_msat) { this.prev_channel_id = prev_channel_id; this.next_channel_id = next_channel_id; this.prev_user_channel_id = prev_user_channel_id; this.next_user_channel_id = next_user_channel_id; this.prev_node_id = prev_node_id; this.next_node_id = next_node_id; this.total_fee_earned_msat = total_fee_earned_msat; this.skimmed_fee_msat = skimmed_fee_msat; this.claim_from_onchain_tx = claim_from_onchain_tx; this.outbound_amount_forwarded_msat = outbound_amount_forwarded_msat; }
		}
		public final static class ChannelPending extends LDKEvent {
			public long channel_id;
			public byte[] user_channel_id;
			public long former_temporary_channel_id;
			public byte[] counterparty_node_id;
			public long funding_txo;
			public long channel_type;
			ChannelPending(long channel_id, byte[] user_channel_id, long former_temporary_channel_id, byte[] counterparty_node_id, long funding_txo, long channel_type) { this.channel_id = channel_id; this.user_channel_id = user_channel_id; this.former_temporary_channel_id = former_temporary_channel_id; this.counterparty_node_id = counterparty_node_id; this.funding_txo = funding_txo; this.channel_type = channel_type; }
		}
		public final static class ChannelReady extends LDKEvent {
			public long channel_id;
			public byte[] user_channel_id;
			public byte[] counterparty_node_id;
			public long channel_type;
			ChannelReady(long channel_id, byte[] user_channel_id, byte[] counterparty_node_id, long channel_type) { this.channel_id = channel_id; this.user_channel_id = user_channel_id; this.counterparty_node_id = counterparty_node_id; this.channel_type = channel_type; }
		}
		public final static class ChannelClosed extends LDKEvent {
			public long channel_id;
			public byte[] user_channel_id;
			public long reason;
			public byte[] counterparty_node_id;
			public long channel_capacity_sats;
			public long channel_funding_txo;
			public long last_local_balance_msat;
			ChannelClosed(long channel_id, byte[] user_channel_id, long reason, byte[] counterparty_node_id, long channel_capacity_sats, long channel_funding_txo, long last_local_balance_msat) { this.channel_id = channel_id; this.user_channel_id = user_channel_id; this.reason = reason; this.counterparty_node_id = counterparty_node_id; this.channel_capacity_sats = channel_capacity_sats; this.channel_funding_txo = channel_funding_txo; this.last_local_balance_msat = last_local_balance_msat; }
		}
		public final static class DiscardFunding extends LDKEvent {
			public long channel_id;
			public long funding_info;
			DiscardFunding(long channel_id, long funding_info) { this.channel_id = channel_id; this.funding_info = funding_info; }
		}
		public final static class OpenChannelRequest extends LDKEvent {
			public long temporary_channel_id;
			public byte[] counterparty_node_id;
			public long funding_satoshis;
			public long channel_negotiation_type;
			public long channel_type;
			public boolean is_announced;
			public long params;
			OpenChannelRequest(long temporary_channel_id, byte[] counterparty_node_id, long funding_satoshis, long channel_negotiation_type, long channel_type, boolean is_announced, long params) { this.temporary_channel_id = temporary_channel_id; this.counterparty_node_id = counterparty_node_id; this.funding_satoshis = funding_satoshis; this.channel_negotiation_type = channel_negotiation_type; this.channel_type = channel_type; this.is_announced = is_announced; this.params = params; }
		}
		public final static class HTLCHandlingFailed extends LDKEvent {
			public long prev_channel_id;
			public long failed_next_destination;
			HTLCHandlingFailed(long prev_channel_id, long failed_next_destination) { this.prev_channel_id = prev_channel_id; this.failed_next_destination = failed_next_destination; }
		}
		public final static class BumpTransaction extends LDKEvent {
			public long bump_transaction;
			BumpTransaction(long bump_transaction) { this.bump_transaction = bump_transaction; }
		}
		public final static class OnionMessageIntercepted extends LDKEvent {
			public byte[] peer_node_id;
			public long message;
			OnionMessageIntercepted(byte[] peer_node_id, long message) { this.peer_node_id = peer_node_id; this.message = message; }
		}
		public final static class OnionMessagePeerConnected extends LDKEvent {
			public byte[] peer_node_id;
			OnionMessagePeerConnected(byte[] peer_node_id) { this.peer_node_id = peer_node_id; }
		}
		static native void init();
	}
	static { LDKEvent.init(); }
	public static native LDKEvent LDKEvent_ref_from_ptr(long ptr);
	public static class LDKCOption_EventZ {
		private LDKCOption_EventZ() {}
		public final static class Some extends LDKCOption_EventZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_EventZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_EventZ.init(); }
	public static native LDKCOption_EventZ LDKCOption_EventZ_ref_from_ptr(long ptr);
	// struct LDKCOption_EventZ CResult_COption_EventZDecodeErrorZ_get_ok(LDKCResult_COption_EventZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_EventZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_COption_EventZDecodeErrorZ_get_err(LDKCResult_COption_EventZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_COption_EventZDecodeErrorZ_get_err(long owner);
	// struct LDKNonce CResult_NonceDecodeErrorZ_get_ok(LDKCResult_NonceDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NonceDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_NonceDecodeErrorZ_get_err(LDKCResult_NonceDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NonceDecodeErrorZ_get_err(long owner);
	// enum LDKSiPrefix CResult_SiPrefixBolt11ParseErrorZ_get_ok(LDKCResult_SiPrefixBolt11ParseErrorZ *NONNULL_PTR owner);
	public static native SiPrefix CResult_SiPrefixBolt11ParseErrorZ_get_ok(long owner);
	// struct LDKBolt11ParseError CResult_SiPrefixBolt11ParseErrorZ_get_err(LDKCResult_SiPrefixBolt11ParseErrorZ *NONNULL_PTR owner);
	public static native long CResult_SiPrefixBolt11ParseErrorZ_get_err(long owner);
	public static class LDKParseOrSemanticError {
		private LDKParseOrSemanticError() {}
		public final static class ParseError extends LDKParseOrSemanticError {
			public long parse_error;
			ParseError(long parse_error) { this.parse_error = parse_error; }
		}
		public final static class SemanticError extends LDKParseOrSemanticError {
			public org.ldk.enums.Bolt11SemanticError semantic_error;
			SemanticError(org.ldk.enums.Bolt11SemanticError semantic_error) { this.semantic_error = semantic_error; }
		}
		static native void init();
	}
	static { LDKParseOrSemanticError.init(); }
	public static native LDKParseOrSemanticError LDKParseOrSemanticError_ref_from_ptr(long ptr);
	// struct LDKBolt11Invoice CResult_Bolt11InvoiceParseOrSemanticErrorZ_get_ok(LDKCResult_Bolt11InvoiceParseOrSemanticErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt11InvoiceParseOrSemanticErrorZ_get_ok(long owner);
	// struct LDKParseOrSemanticError CResult_Bolt11InvoiceParseOrSemanticErrorZ_get_err(LDKCResult_Bolt11InvoiceParseOrSemanticErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt11InvoiceParseOrSemanticErrorZ_get_err(long owner);
	// struct LDKSignedRawBolt11Invoice CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_get_ok(LDKCResult_SignedRawBolt11InvoiceBolt11ParseErrorZ *NONNULL_PTR owner);
	public static native long CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_get_ok(long owner);
	// struct LDKBolt11ParseError CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_get_err(LDKCResult_SignedRawBolt11InvoiceBolt11ParseErrorZ *NONNULL_PTR owner);
	public static native long CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_get_err(long owner);
	// struct LDKRawBolt11Invoice C3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ_get_a(LDKC3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ *NONNULL_PTR owner);
	public static native long C3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ_get_a(long owner);
	// struct LDKThirtyTwoBytes C3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ_get_b(LDKC3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ *NONNULL_PTR owner);
	public static native byte[] C3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ_get_b(long owner);
	// struct LDKBolt11InvoiceSignature C3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ_get_c(LDKC3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ *NONNULL_PTR owner);
	public static native long C3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ_get_c(long owner);
	// struct LDKPayeePubKey CResult_PayeePubKeySecp256k1ErrorZ_get_ok(LDKCResult_PayeePubKeySecp256k1ErrorZ *NONNULL_PTR owner);
	public static native long CResult_PayeePubKeySecp256k1ErrorZ_get_ok(long owner);
	// enum LDKSecp256k1Error CResult_PayeePubKeySecp256k1ErrorZ_get_err(LDKCResult_PayeePubKeySecp256k1ErrorZ *NONNULL_PTR owner);
	public static native Secp256k1Error CResult_PayeePubKeySecp256k1ErrorZ_get_err(long owner);
	// struct LDKPositiveTimestamp CResult_PositiveTimestampCreationErrorZ_get_ok(LDKCResult_PositiveTimestampCreationErrorZ *NONNULL_PTR owner);
	public static native long CResult_PositiveTimestampCreationErrorZ_get_ok(long owner);
	// enum LDKCreationError CResult_PositiveTimestampCreationErrorZ_get_err(LDKCResult_PositiveTimestampCreationErrorZ *NONNULL_PTR owner);
	public static native CreationError CResult_PositiveTimestampCreationErrorZ_get_err(long owner);
	// void CResult_NoneBolt11SemanticErrorZ_get_ok(LDKCResult_NoneBolt11SemanticErrorZ *NONNULL_PTR owner);
	public static native void CResult_NoneBolt11SemanticErrorZ_get_ok(long owner);
	// enum LDKBolt11SemanticError CResult_NoneBolt11SemanticErrorZ_get_err(LDKCResult_NoneBolt11SemanticErrorZ *NONNULL_PTR owner);
	public static native Bolt11SemanticError CResult_NoneBolt11SemanticErrorZ_get_err(long owner);
	// struct LDKBolt11Invoice CResult_Bolt11InvoiceBolt11SemanticErrorZ_get_ok(LDKCResult_Bolt11InvoiceBolt11SemanticErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt11InvoiceBolt11SemanticErrorZ_get_ok(long owner);
	// enum LDKBolt11SemanticError CResult_Bolt11InvoiceBolt11SemanticErrorZ_get_err(LDKCResult_Bolt11InvoiceBolt11SemanticErrorZ *NONNULL_PTR owner);
	public static native Bolt11SemanticError CResult_Bolt11InvoiceBolt11SemanticErrorZ_get_err(long owner);
	// struct LDKDescription CResult_DescriptionCreationErrorZ_get_ok(LDKCResult_DescriptionCreationErrorZ *NONNULL_PTR owner);
	public static native long CResult_DescriptionCreationErrorZ_get_ok(long owner);
	// enum LDKCreationError CResult_DescriptionCreationErrorZ_get_err(LDKCResult_DescriptionCreationErrorZ *NONNULL_PTR owner);
	public static native CreationError CResult_DescriptionCreationErrorZ_get_err(long owner);
	// struct LDKPrivateRoute CResult_PrivateRouteCreationErrorZ_get_ok(LDKCResult_PrivateRouteCreationErrorZ *NONNULL_PTR owner);
	public static native long CResult_PrivateRouteCreationErrorZ_get_ok(long owner);
	// enum LDKCreationError CResult_PrivateRouteCreationErrorZ_get_err(LDKCResult_PrivateRouteCreationErrorZ *NONNULL_PTR owner);
	public static native CreationError CResult_PrivateRouteCreationErrorZ_get_err(long owner);
	// struct LDKOutPoint CResult_OutPointDecodeErrorZ_get_ok(LDKCResult_OutPointDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OutPointDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_OutPointDecodeErrorZ_get_err(LDKCResult_OutPointDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OutPointDecodeErrorZ_get_err(long owner);
	// struct LDKBigSize CResult_BigSizeDecodeErrorZ_get_ok(LDKCResult_BigSizeDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BigSizeDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_BigSizeDecodeErrorZ_get_err(LDKCResult_BigSizeDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BigSizeDecodeErrorZ_get_err(long owner);
	// struct LDKUntrustedString CResult_UntrustedStringDecodeErrorZ_get_ok(LDKCResult_UntrustedStringDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UntrustedStringDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_UntrustedStringDecodeErrorZ_get_err(LDKCResult_UntrustedStringDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_UntrustedStringDecodeErrorZ_get_err(long owner);
	// struct LDKHostname CResult_HostnameDecodeErrorZ_get_ok(LDKCResult_HostnameDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HostnameDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_HostnameDecodeErrorZ_get_err(LDKCResult_HostnameDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HostnameDecodeErrorZ_get_err(long owner);
	// struct LDKTransactionU16LenLimited CResult_TransactionU16LenLimitedNoneZ_get_ok(LDKCResult_TransactionU16LenLimitedNoneZ *NONNULL_PTR owner);
	public static native long CResult_TransactionU16LenLimitedNoneZ_get_ok(long owner);
	// void CResult_TransactionU16LenLimitedNoneZ_get_err(LDKCResult_TransactionU16LenLimitedNoneZ *NONNULL_PTR owner);
	public static native void CResult_TransactionU16LenLimitedNoneZ_get_err(long owner);
	// struct LDKTransactionU16LenLimited CResult_TransactionU16LenLimitedDecodeErrorZ_get_ok(LDKCResult_TransactionU16LenLimitedDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TransactionU16LenLimitedDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_TransactionU16LenLimitedDecodeErrorZ_get_err(LDKCResult_TransactionU16LenLimitedDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TransactionU16LenLimitedDecodeErrorZ_get_err(long owner);
	// struct LDKChannelId CResult_ChannelIdDecodeErrorZ_get_ok(LDKCResult_ChannelIdDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelIdDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelIdDecodeErrorZ_get_err(LDKCResult_ChannelIdDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelIdDecodeErrorZ_get_err(long owner);
	// struct LDKInitFeatures CResult_InitFeaturesDecodeErrorZ_get_ok(LDKCResult_InitFeaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InitFeaturesDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_InitFeaturesDecodeErrorZ_get_err(LDKCResult_InitFeaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InitFeaturesDecodeErrorZ_get_err(long owner);
	// struct LDKChannelFeatures CResult_ChannelFeaturesDecodeErrorZ_get_ok(LDKCResult_ChannelFeaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelFeaturesDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelFeaturesDecodeErrorZ_get_err(LDKCResult_ChannelFeaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelFeaturesDecodeErrorZ_get_err(long owner);
	// struct LDKNodeFeatures CResult_NodeFeaturesDecodeErrorZ_get_ok(LDKCResult_NodeFeaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NodeFeaturesDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_NodeFeaturesDecodeErrorZ_get_err(LDKCResult_NodeFeaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_NodeFeaturesDecodeErrorZ_get_err(long owner);
	// struct LDKBolt11InvoiceFeatures CResult_Bolt11InvoiceFeaturesDecodeErrorZ_get_ok(LDKCResult_Bolt11InvoiceFeaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt11InvoiceFeaturesDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_Bolt11InvoiceFeaturesDecodeErrorZ_get_err(LDKCResult_Bolt11InvoiceFeaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt11InvoiceFeaturesDecodeErrorZ_get_err(long owner);
	// struct LDKBolt12InvoiceFeatures CResult_Bolt12InvoiceFeaturesDecodeErrorZ_get_ok(LDKCResult_Bolt12InvoiceFeaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt12InvoiceFeaturesDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_Bolt12InvoiceFeaturesDecodeErrorZ_get_err(LDKCResult_Bolt12InvoiceFeaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt12InvoiceFeaturesDecodeErrorZ_get_err(long owner);
	// struct LDKBlindedHopFeatures CResult_BlindedHopFeaturesDecodeErrorZ_get_ok(LDKCResult_BlindedHopFeaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BlindedHopFeaturesDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_BlindedHopFeaturesDecodeErrorZ_get_err(LDKCResult_BlindedHopFeaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BlindedHopFeaturesDecodeErrorZ_get_err(long owner);
	// struct LDKChannelTypeFeatures CResult_ChannelTypeFeaturesDecodeErrorZ_get_ok(LDKCResult_ChannelTypeFeaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelTypeFeaturesDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ChannelTypeFeaturesDecodeErrorZ_get_err(LDKCResult_ChannelTypeFeaturesDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ChannelTypeFeaturesDecodeErrorZ_get_err(long owner);
	// struct LDKThirtyTwoBytes C2Tuple__u832u16Z_get_a(LDKC2Tuple__u832u16Z *NONNULL_PTR owner);
	public static native byte[] C2Tuple__u832u16Z_get_a(long owner);
	// uint16_t C2Tuple__u832u16Z_get_b(LDKC2Tuple__u832u16Z *NONNULL_PTR owner);
	public static native short C2Tuple__u832u16Z_get_b(long owner);
	// struct LDKBlindedPayInfo CResult_BlindedPayInfoDecodeErrorZ_get_ok(LDKCResult_BlindedPayInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BlindedPayInfoDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_BlindedPayInfoDecodeErrorZ_get_err(LDKCResult_BlindedPayInfoDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BlindedPayInfoDecodeErrorZ_get_err(long owner);
	// struct LDKBlindedPaymentPath CResult_BlindedPaymentPathNoneZ_get_ok(LDKCResult_BlindedPaymentPathNoneZ *NONNULL_PTR owner);
	public static native long CResult_BlindedPaymentPathNoneZ_get_ok(long owner);
	// void CResult_BlindedPaymentPathNoneZ_get_err(LDKCResult_BlindedPaymentPathNoneZ *NONNULL_PTR owner);
	public static native void CResult_BlindedPaymentPathNoneZ_get_err(long owner);
	// struct LDKPaymentRelay CResult_PaymentRelayDecodeErrorZ_get_ok(LDKCResult_PaymentRelayDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PaymentRelayDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_PaymentRelayDecodeErrorZ_get_err(LDKCResult_PaymentRelayDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PaymentRelayDecodeErrorZ_get_err(long owner);
	// struct LDKPaymentConstraints CResult_PaymentConstraintsDecodeErrorZ_get_ok(LDKCResult_PaymentConstraintsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PaymentConstraintsDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_PaymentConstraintsDecodeErrorZ_get_err(LDKCResult_PaymentConstraintsDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PaymentConstraintsDecodeErrorZ_get_err(long owner);
	// struct LDKPaymentContext CResult_PaymentContextDecodeErrorZ_get_ok(LDKCResult_PaymentContextDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PaymentContextDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_PaymentContextDecodeErrorZ_get_err(LDKCResult_PaymentContextDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_PaymentContextDecodeErrorZ_get_err(long owner);
	// struct LDKBolt12OfferContext CResult_Bolt12OfferContextDecodeErrorZ_get_ok(LDKCResult_Bolt12OfferContextDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt12OfferContextDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_Bolt12OfferContextDecodeErrorZ_get_err(LDKCResult_Bolt12OfferContextDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt12OfferContextDecodeErrorZ_get_err(long owner);
	// struct LDKBolt12RefundContext CResult_Bolt12RefundContextDecodeErrorZ_get_ok(LDKCResult_Bolt12RefundContextDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt12RefundContextDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_Bolt12RefundContextDecodeErrorZ_get_err(LDKCResult_Bolt12RefundContextDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_Bolt12RefundContextDecodeErrorZ_get_err(long owner);
	// struct LDKResponder CResult_ResponderDecodeErrorZ_get_ok(LDKCResult_ResponderDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ResponderDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_ResponderDecodeErrorZ_get_err(LDKCResult_ResponderDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_ResponderDecodeErrorZ_get_err(long owner);
	public static class LDKCOption_MessageContextZ {
		private LDKCOption_MessageContextZ() {}
		public final static class Some extends LDKCOption_MessageContextZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_MessageContextZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_MessageContextZ.init(); }
	public static native LDKCOption_MessageContextZ LDKCOption_MessageContextZ_ref_from_ptr(long ptr);
	// struct LDKPublicKey C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ_get_a(LDKC3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ *NONNULL_PTR owner);
	public static native byte[] C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ_get_a(long owner);
	// struct LDKOnionMessage C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ_get_b(LDKC3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ *NONNULL_PTR owner);
	public static native long C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ_get_b(long owner);
	// struct LDKCOption_CVec_SocketAddressZZ C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ_get_c(LDKC3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ *NONNULL_PTR owner);
	public static native long C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ_get_c(long owner);
	public static class LDKSendError {
		private LDKSendError() {}
		public final static class Secp256k1 extends LDKSendError {
			public org.ldk.enums.Secp256k1Error secp256k1;
			Secp256k1(org.ldk.enums.Secp256k1Error secp256k1) { this.secp256k1 = secp256k1; }
		}
		public final static class TooBigPacket extends LDKSendError {
			TooBigPacket() { }
		}
		public final static class TooFewBlindedHops extends LDKSendError {
			TooFewBlindedHops() { }
		}
		public final static class InvalidFirstHop extends LDKSendError {
			public byte[] invalid_first_hop;
			InvalidFirstHop(byte[] invalid_first_hop) { this.invalid_first_hop = invalid_first_hop; }
		}
		public final static class PathNotFound extends LDKSendError {
			PathNotFound() { }
		}
		public final static class InvalidMessage extends LDKSendError {
			InvalidMessage() { }
		}
		public final static class BufferFull extends LDKSendError {
			BufferFull() { }
		}
		public final static class GetNodeIdFailed extends LDKSendError {
			GetNodeIdFailed() { }
		}
		public final static class UnresolvedIntroductionNode extends LDKSendError {
			UnresolvedIntroductionNode() { }
		}
		public final static class BlindedPathAdvanceFailed extends LDKSendError {
			BlindedPathAdvanceFailed() { }
		}
		static native void init();
	}
	static { LDKSendError.init(); }
	public static native LDKSendError LDKSendError_ref_from_ptr(long ptr);
	// struct LDKC3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_get_ok(LDKCResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ *NONNULL_PTR owner);
	public static native long CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_get_ok(long owner);
	// struct LDKSendError CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_get_err(LDKCResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ *NONNULL_PTR owner);
	public static native long CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_get_err(long owner);
	public static class LDKNextMessageHop {
		private LDKNextMessageHop() {}
		public final static class NodeId extends LDKNextMessageHop {
			public byte[] node_id;
			NodeId(byte[] node_id) { this.node_id = node_id; }
		}
		public final static class ShortChannelId extends LDKNextMessageHop {
			public long short_channel_id;
			ShortChannelId(long short_channel_id) { this.short_channel_id = short_channel_id; }
		}
		static native void init();
	}
	static { LDKNextMessageHop.init(); }
	public static native LDKNextMessageHop LDKNextMessageHop_ref_from_ptr(long ptr);
	public static class LDKParsedOnionMessageContents {
		private LDKParsedOnionMessageContents() {}
		public final static class Offers extends LDKParsedOnionMessageContents {
			public long offers;
			Offers(long offers) { this.offers = offers; }
		}
		public final static class DNSResolver extends LDKParsedOnionMessageContents {
			public long dns_resolver;
			DNSResolver(long dns_resolver) { this.dns_resolver = dns_resolver; }
		}
		public final static class Custom extends LDKParsedOnionMessageContents {
			public long custom;
			Custom(long custom) { this.custom = custom; }
		}
		static native void init();
	}
	static { LDKParsedOnionMessageContents.init(); }
	public static native LDKParsedOnionMessageContents LDKParsedOnionMessageContents_ref_from_ptr(long ptr);
	public static class LDKPeeledOnion {
		private LDKPeeledOnion() {}
		public final static class Forward extends LDKPeeledOnion {
			public long _0;
			public long _1;
			Forward(long _0, long _1) { this._0 = _0; this._1 = _1; }
		}
		public final static class Receive extends LDKPeeledOnion {
			public long _0;
			public long _1;
			public long _2;
			Receive(long _0, long _1, long _2) { this._0 = _0; this._1 = _1; this._2 = _2; }
		}
		static native void init();
	}
	static { LDKPeeledOnion.init(); }
	public static native LDKPeeledOnion LDKPeeledOnion_ref_from_ptr(long ptr);
	// struct LDKPeeledOnion CResult_PeeledOnionNoneZ_get_ok(LDKCResult_PeeledOnionNoneZ *NONNULL_PTR owner);
	public static native long CResult_PeeledOnionNoneZ_get_ok(long owner);
	// void CResult_PeeledOnionNoneZ_get_err(LDKCResult_PeeledOnionNoneZ *NONNULL_PTR owner);
	public static native void CResult_PeeledOnionNoneZ_get_err(long owner);
	public static class LDKSendSuccess {
		private LDKSendSuccess() {}
		public final static class Buffered extends LDKSendSuccess {
			Buffered() { }
		}
		public final static class BufferedAwaitingConnection extends LDKSendSuccess {
			public byte[] buffered_awaiting_connection;
			BufferedAwaitingConnection(byte[] buffered_awaiting_connection) { this.buffered_awaiting_connection = buffered_awaiting_connection; }
		}
		static native void init();
	}
	static { LDKSendSuccess.init(); }
	public static native LDKSendSuccess LDKSendSuccess_ref_from_ptr(long ptr);
	// struct LDKSendSuccess CResult_SendSuccessSendErrorZ_get_ok(LDKCResult_SendSuccessSendErrorZ *NONNULL_PTR owner);
	public static native long CResult_SendSuccessSendErrorZ_get_ok(long owner);
	// struct LDKSendError CResult_SendSuccessSendErrorZ_get_err(LDKCResult_SendSuccessSendErrorZ *NONNULL_PTR owner);
	public static native long CResult_SendSuccessSendErrorZ_get_err(long owner);
	// void CResult_NoneSendErrorZ_get_ok(LDKCResult_NoneSendErrorZ *NONNULL_PTR owner);
	public static native void CResult_NoneSendErrorZ_get_ok(long owner);
	// struct LDKSendError CResult_NoneSendErrorZ_get_err(LDKCResult_NoneSendErrorZ *NONNULL_PTR owner);
	public static native long CResult_NoneSendErrorZ_get_err(long owner);
	// struct LDKBlindedHop CResult_BlindedHopDecodeErrorZ_get_ok(LDKCResult_BlindedHopDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BlindedHopDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_BlindedHopDecodeErrorZ_get_err(LDKCResult_BlindedHopDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BlindedHopDecodeErrorZ_get_err(long owner);
	// struct LDKInvoiceError CResult_InvoiceErrorDecodeErrorZ_get_ok(LDKCResult_InvoiceErrorDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InvoiceErrorDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_InvoiceErrorDecodeErrorZ_get_err(LDKCResult_InvoiceErrorDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_InvoiceErrorDecodeErrorZ_get_err(long owner);
	// struct LDKTrackedSpendableOutput CResult_TrackedSpendableOutputDecodeErrorZ_get_ok(LDKCResult_TrackedSpendableOutputDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TrackedSpendableOutputDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_TrackedSpendableOutputDecodeErrorZ_get_err(LDKCResult_TrackedSpendableOutputDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_TrackedSpendableOutputDecodeErrorZ_get_err(long owner);
	public static class LDKOutputSpendStatus {
		private LDKOutputSpendStatus() {}
		public final static class PendingInitialBroadcast extends LDKOutputSpendStatus {
			public long delayed_until_height;
			PendingInitialBroadcast(long delayed_until_height) { this.delayed_until_height = delayed_until_height; }
		}
		public final static class PendingFirstConfirmation extends LDKOutputSpendStatus {
			public byte[] first_broadcast_hash;
			public int latest_broadcast_height;
			public byte[] latest_spending_tx;
			PendingFirstConfirmation(byte[] first_broadcast_hash, int latest_broadcast_height, byte[] latest_spending_tx) { this.first_broadcast_hash = first_broadcast_hash; this.latest_broadcast_height = latest_broadcast_height; this.latest_spending_tx = latest_spending_tx; }
		}
		public final static class PendingThresholdConfirmations extends LDKOutputSpendStatus {
			public byte[] first_broadcast_hash;
			public int latest_broadcast_height;
			public byte[] latest_spending_tx;
			public int confirmation_height;
			public byte[] confirmation_hash;
			PendingThresholdConfirmations(byte[] first_broadcast_hash, int latest_broadcast_height, byte[] latest_spending_tx, int confirmation_height, byte[] confirmation_hash) { this.first_broadcast_hash = first_broadcast_hash; this.latest_broadcast_height = latest_broadcast_height; this.latest_spending_tx = latest_spending_tx; this.confirmation_height = confirmation_height; this.confirmation_hash = confirmation_hash; }
		}
		static native void init();
	}
	static { LDKOutputSpendStatus.init(); }
	public static native LDKOutputSpendStatus LDKOutputSpendStatus_ref_from_ptr(long ptr);
	// struct LDKOutputSpendStatus CResult_OutputSpendStatusDecodeErrorZ_get_ok(LDKCResult_OutputSpendStatusDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OutputSpendStatusDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_OutputSpendStatusDecodeErrorZ_get_err(LDKCResult_OutputSpendStatusDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OutputSpendStatusDecodeErrorZ_get_err(long owner);
	public interface LDKFilter {
		 void register_tx(byte[] txid, byte[] script_pubkey);
		 void register_output(long output);
	}
	public static native long LDKFilter_new(LDKFilter impl);
	// void Filter_register_tx LDKFilter *NONNULL_PTR this_arg, const uint8_t (*txid)[32], struct LDKu8slice script_pubkey
	public static native void Filter_register_tx(long this_arg, byte[] txid, byte[] script_pubkey);
	// void Filter_register_output LDKFilter *NONNULL_PTR this_arg, struct LDKWatchedOutput output
	public static native void Filter_register_output(long this_arg, long output);
	public static class LDKCOption_FilterZ {
		private LDKCOption_FilterZ() {}
		public final static class Some extends LDKCOption_FilterZ {
			public long some;
			Some(long some) { this.some = some; }
		}
		public final static class None extends LDKCOption_FilterZ {
			None() { }
		}
		static native void init();
	}
	static { LDKCOption_FilterZ.init(); }
	public static native LDKCOption_FilterZ LDKCOption_FilterZ_ref_from_ptr(long ptr);
	public interface LDKChangeDestinationSource {
		 long get_change_destination_script();
	}
	public static native long LDKChangeDestinationSource_new(LDKChangeDestinationSource impl);
	// LDKCResult_CVec_u8ZNoneZ ChangeDestinationSource_get_change_destination_script LDKChangeDestinationSource *NONNULL_PTR this_arg
	public static native long ChangeDestinationSource_get_change_destination_script(long this_arg);
	public interface LDKKVStore {
		 long read(String primary_namespace, String secondary_namespace, String key);
		 long write(String primary_namespace, String secondary_namespace, String key, byte[] buf);
		 long remove(String primary_namespace, String secondary_namespace, String key, boolean lazy);
		 long list(String primary_namespace, String secondary_namespace);
	}
	public static native long LDKKVStore_new(LDKKVStore impl);
	// LDKCResult_CVec_u8ZIOErrorZ KVStore_read LDKKVStore *NONNULL_PTR this_arg, struct LDKStr primary_namespace, struct LDKStr secondary_namespace, struct LDKStr key
	public static native long KVStore_read(long this_arg, String primary_namespace, String secondary_namespace, String key);
	// LDKCResult_NoneIOErrorZ KVStore_write LDKKVStore *NONNULL_PTR this_arg, struct LDKStr primary_namespace, struct LDKStr secondary_namespace, struct LDKStr key, struct LDKu8slice buf
	public static native long KVStore_write(long this_arg, String primary_namespace, String secondary_namespace, String key, byte[] buf);
	// LDKCResult_NoneIOErrorZ KVStore_remove LDKKVStore *NONNULL_PTR this_arg, struct LDKStr primary_namespace, struct LDKStr secondary_namespace, struct LDKStr key, bool lazy
	public static native long KVStore_remove(long this_arg, String primary_namespace, String secondary_namespace, String key, boolean lazy);
	// LDKCResult_CVec_StrZIOErrorZ KVStore_list LDKKVStore *NONNULL_PTR this_arg, struct LDKStr primary_namespace, struct LDKStr secondary_namespace
	public static native long KVStore_list(long this_arg, String primary_namespace, String secondary_namespace);
	public interface LDKOutputSpender {
		 long spend_spendable_outputs(long[] descriptors, long[] outputs, byte[] change_destination_script, int feerate_sat_per_1000_weight, long locktime);
	}
	public static native long LDKOutputSpender_new(LDKOutputSpender impl);
	// LDKCResult_TransactionNoneZ OutputSpender_spend_spendable_outputs LDKOutputSpender *NONNULL_PTR this_arg, struct LDKCVec_SpendableOutputDescriptorZ descriptors, struct LDKCVec_TxOutZ outputs, struct LDKCVec_u8Z change_destination_script, uint32_t feerate_sat_per_1000_weight, struct LDKCOption_u32Z locktime
	public static native long OutputSpender_spend_spendable_outputs(long this_arg, long[] descriptors, long[] outputs, byte[] change_destination_script, int feerate_sat_per_1000_weight, long locktime);
	// struct LDKOutputSweeper CResult_OutputSweeperDecodeErrorZ_get_ok(LDKCResult_OutputSweeperDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OutputSweeperDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_OutputSweeperDecodeErrorZ_get_err(LDKCResult_OutputSweeperDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OutputSweeperDecodeErrorZ_get_err(long owner);
	// struct LDKBestBlock C2Tuple_BestBlockOutputSweeperZ_get_a(LDKC2Tuple_BestBlockOutputSweeperZ *NONNULL_PTR owner);
	public static native long C2Tuple_BestBlockOutputSweeperZ_get_a(long owner);
	// struct LDKOutputSweeper C2Tuple_BestBlockOutputSweeperZ_get_b(LDKC2Tuple_BestBlockOutputSweeperZ *NONNULL_PTR owner);
	public static native long C2Tuple_BestBlockOutputSweeperZ_get_b(long owner);
	// struct LDKC2Tuple_BestBlockOutputSweeperZ *CResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ_get_ok(LDKCResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ_get_err(LDKCResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ_get_err(long owner);
	// struct LDKDelayedPaymentBasepoint CResult_DelayedPaymentBasepointDecodeErrorZ_get_ok(LDKCResult_DelayedPaymentBasepointDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_DelayedPaymentBasepointDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_DelayedPaymentBasepointDecodeErrorZ_get_err(LDKCResult_DelayedPaymentBasepointDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_DelayedPaymentBasepointDecodeErrorZ_get_err(long owner);
	// struct LDKDelayedPaymentKey CResult_DelayedPaymentKeyDecodeErrorZ_get_ok(LDKCResult_DelayedPaymentKeyDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_DelayedPaymentKeyDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_DelayedPaymentKeyDecodeErrorZ_get_err(LDKCResult_DelayedPaymentKeyDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_DelayedPaymentKeyDecodeErrorZ_get_err(long owner);
	// struct LDKHtlcBasepoint CResult_HtlcBasepointDecodeErrorZ_get_ok(LDKCResult_HtlcBasepointDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HtlcBasepointDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_HtlcBasepointDecodeErrorZ_get_err(LDKCResult_HtlcBasepointDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HtlcBasepointDecodeErrorZ_get_err(long owner);
	// struct LDKHtlcKey CResult_HtlcKeyDecodeErrorZ_get_ok(LDKCResult_HtlcKeyDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HtlcKeyDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_HtlcKeyDecodeErrorZ_get_err(LDKCResult_HtlcKeyDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_HtlcKeyDecodeErrorZ_get_err(long owner);
	// struct LDKRevocationBasepoint CResult_RevocationBasepointDecodeErrorZ_get_ok(LDKCResult_RevocationBasepointDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RevocationBasepointDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_RevocationBasepointDecodeErrorZ_get_err(LDKCResult_RevocationBasepointDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RevocationBasepointDecodeErrorZ_get_err(long owner);
	// struct LDKRevocationKey CResult_RevocationKeyDecodeErrorZ_get_ok(LDKCResult_RevocationKeyDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RevocationKeyDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_RevocationKeyDecodeErrorZ_get_err(LDKCResult_RevocationKeyDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_RevocationKeyDecodeErrorZ_get_err(long owner);
	// struct LDKLockedChannelMonitor CResult_LockedChannelMonitorNoneZ_get_ok(LDKCResult_LockedChannelMonitorNoneZ *NONNULL_PTR owner);
	public static native long CResult_LockedChannelMonitorNoneZ_get_ok(long owner);
	// void CResult_LockedChannelMonitorNoneZ_get_err(LDKCResult_LockedChannelMonitorNoneZ *NONNULL_PTR owner);
	public static native void CResult_LockedChannelMonitorNoneZ_get_err(long owner);
	// struct LDKOutPoint C2Tuple_OutPointChannelIdZ_get_a(LDKC2Tuple_OutPointChannelIdZ *NONNULL_PTR owner);
	public static native long C2Tuple_OutPointChannelIdZ_get_a(long owner);
	// struct LDKChannelId C2Tuple_OutPointChannelIdZ_get_b(LDKC2Tuple_OutPointChannelIdZ *NONNULL_PTR owner);
	public static native long C2Tuple_OutPointChannelIdZ_get_b(long owner);
	// struct LDKOutPoint C2Tuple_OutPointCVec_u64ZZ_get_a(LDKC2Tuple_OutPointCVec_u64ZZ *NONNULL_PTR owner);
	public static native long C2Tuple_OutPointCVec_u64ZZ_get_a(long owner);
	// struct LDKCVec_u64Z C2Tuple_OutPointCVec_u64ZZ_get_b(LDKC2Tuple_OutPointCVec_u64ZZ *NONNULL_PTR owner);
	public static native long[] C2Tuple_OutPointCVec_u64ZZ_get_b(long owner);
	// struct LDKBlindedMessagePath CResult_BlindedMessagePathDecodeErrorZ_get_ok(LDKCResult_BlindedMessagePathDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BlindedMessagePathDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_BlindedMessagePathDecodeErrorZ_get_err(LDKCResult_BlindedMessagePathDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_BlindedMessagePathDecodeErrorZ_get_err(long owner);
	// struct LDKBlindedMessagePath CResult_BlindedMessagePathNoneZ_get_ok(LDKCResult_BlindedMessagePathNoneZ *NONNULL_PTR owner);
	public static native long CResult_BlindedMessagePathNoneZ_get_ok(long owner);
	// void CResult_BlindedMessagePathNoneZ_get_err(LDKCResult_BlindedMessagePathNoneZ *NONNULL_PTR owner);
	public static native void CResult_BlindedMessagePathNoneZ_get_err(long owner);
	// struct LDKMessageContext CResult_MessageContextDecodeErrorZ_get_ok(LDKCResult_MessageContextDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_MessageContextDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_MessageContextDecodeErrorZ_get_err(LDKCResult_MessageContextDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_MessageContextDecodeErrorZ_get_err(long owner);
	// struct LDKOffersContext CResult_OffersContextDecodeErrorZ_get_ok(LDKCResult_OffersContextDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OffersContextDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_OffersContextDecodeErrorZ_get_err(LDKCResult_OffersContextDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_OffersContextDecodeErrorZ_get_err(long owner);
	// struct LDKAsyncPaymentsContext CResult_AsyncPaymentsContextDecodeErrorZ_get_ok(LDKCResult_AsyncPaymentsContextDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_AsyncPaymentsContextDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_AsyncPaymentsContextDecodeErrorZ_get_err(LDKCResult_AsyncPaymentsContextDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_AsyncPaymentsContextDecodeErrorZ_get_err(long owner);
	// struct LDKDNSResolverContext CResult_DNSResolverContextDecodeErrorZ_get_ok(LDKCResult_DNSResolverContextDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_DNSResolverContextDecodeErrorZ_get_ok(long owner);
	// struct LDKDecodeError CResult_DNSResolverContextDecodeErrorZ_get_err(LDKCResult_DNSResolverContextDecodeErrorZ *NONNULL_PTR owner);
	public static native long CResult_DNSResolverContextDecodeErrorZ_get_err(long owner);
	public interface LDKMigratableKVStore {
		 long list_all_keys();
	}
	public static native long LDKMigratableKVStore_new(LDKMigratableKVStore impl, LDKKVStore KVStore);
	public static native long LDKMigratableKVStore_get_KVStore(long arg);
	// LDKCResult_CVec_C3Tuple_StrStrStrZZIOErrorZ MigratableKVStore_list_all_keys LDKMigratableKVStore *NONNULL_PTR this_arg
	public static native long MigratableKVStore_list_all_keys(long this_arg);
	public interface LDKPersister {
		 long persist_manager(long channel_manager);
		 long persist_graph(long network_graph);
		 long persist_scorer(long scorer);
	}
	public static native long LDKPersister_new(LDKPersister impl);
	// LDKCResult_NoneIOErrorZ Persister_persist_manager LDKPersister *NONNULL_PTR this_arg, const struct LDKChannelManager *NONNULL_PTR channel_manager
	public static native long Persister_persist_manager(long this_arg, long channel_manager);
	// LDKCResult_NoneIOErrorZ Persister_persist_graph LDKPersister *NONNULL_PTR this_arg, const struct LDKNetworkGraph *NONNULL_PTR network_graph
	public static native long Persister_persist_graph(long this_arg, long network_graph);
	// LDKCResult_NoneIOErrorZ Persister_persist_scorer LDKPersister *NONNULL_PTR this_arg, const struct LDKWriteableScore *NONNULL_PTR scorer
	public static native long Persister_persist_scorer(long this_arg, long scorer);
	public interface LDKPersist {
		 ChannelMonitorUpdateStatus persist_new_channel(long channel_funding_outpoint, long monitor);
		 ChannelMonitorUpdateStatus update_persisted_channel(long channel_funding_outpoint, long monitor_update, long monitor);
		 void archive_persisted_channel(long channel_funding_outpoint);
	}
	public static native long LDKPersist_new(LDKPersist impl);
	// LDKChannelMonitorUpdateStatus Persist_persist_new_channel LDKPersist *NONNULL_PTR this_arg, struct LDKOutPoint channel_funding_outpoint, const struct LDKChannelMonitor *NONNULL_PTR monitor
	public static native ChannelMonitorUpdateStatus Persist_persist_new_channel(long this_arg, long channel_funding_outpoint, long monitor);
	// LDKChannelMonitorUpdateStatus Persist_update_persisted_channel LDKPersist *NONNULL_PTR this_arg, struct LDKOutPoint channel_funding_outpoint, struct LDKChannelMonitorUpdate monitor_update, const struct LDKChannelMonitor *NONNULL_PTR monitor
	public static native ChannelMonitorUpdateStatus Persist_update_persisted_channel(long this_arg, long channel_funding_outpoint, long monitor_update, long monitor);
	// void Persist_archive_persisted_channel LDKPersist *NONNULL_PTR this_arg, struct LDKOutPoint channel_funding_outpoint
	public static native void Persist_archive_persisted_channel(long this_arg, long channel_funding_outpoint);
	public interface LDKListen {
		 void filtered_block_connected(byte[] header, long[] txdata, int height);
		 void block_connected(byte[] block, int height);
		 void block_disconnected(byte[] header, int height);
	}
	public static native long LDKListen_new(LDKListen impl);
	// void Listen_filtered_block_connected LDKListen *NONNULL_PTR this_arg, const uint8_t (*header)[80], struct LDKCVec_C2Tuple_usizeTransactionZZ txdata, uint32_t height
	public static native void Listen_filtered_block_connected(long this_arg, byte[] header, long[] txdata, int height);
	// void Listen_block_connected LDKListen *NONNULL_PTR this_arg, struct LDKu8slice block, uint32_t height
	public static native void Listen_block_connected(long this_arg, byte[] block, int height);
	// void Listen_block_disconnected LDKListen *NONNULL_PTR this_arg, const uint8_t (*header)[80], uint32_t height
	public static native void Listen_block_disconnected(long this_arg, byte[] header, int height);
	public interface LDKConfirm {
		 void transactions_confirmed(byte[] header, long[] txdata, int height);
		 void transaction_unconfirmed(byte[] txid);
		 void best_block_updated(byte[] header, int height);
		 long[] get_relevant_txids();
	}
	public static native long LDKConfirm_new(LDKConfirm impl);
	// void Confirm_transactions_confirmed LDKConfirm *NONNULL_PTR this_arg, const uint8_t (*header)[80], struct LDKCVec_C2Tuple_usizeTransactionZZ txdata, uint32_t height
	public static native void Confirm_transactions_confirmed(long this_arg, byte[] header, long[] txdata, int height);
	// void Confirm_transaction_unconfirmed LDKConfirm *NONNULL_PTR this_arg, const uint8_t (*txid)[32]
	public static native void Confirm_transaction_unconfirmed(long this_arg, byte[] txid);
	// void Confirm_best_block_updated LDKConfirm *NONNULL_PTR this_arg, const uint8_t (*header)[80], uint32_t height
	public static native void Confirm_best_block_updated(long this_arg, byte[] header, int height);
	// LDKCVec_C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZZ Confirm_get_relevant_txids LDKConfirm *NONNULL_PTR this_arg
	public static native long[] Confirm_get_relevant_txids(long this_arg);
	public static class LDKSpendingDelay {
		private LDKSpendingDelay() {}
		public final static class Relative extends LDKSpendingDelay {
			public int num_blocks;
			Relative(int num_blocks) { this.num_blocks = num_blocks; }
		}
		public final static class Absolute extends LDKSpendingDelay {
			public int height;
			Absolute(int height) { this.height = height; }
		}
		static native void init();
	}
	static { LDKSpendingDelay.init(); }
	public static native LDKSpendingDelay LDKSpendingDelay_ref_from_ptr(long ptr);
	public interface LDKFutureCallback {
		 void call();
	}
	public static native long LDKFutureCallback_new(LDKFutureCallback impl);
	// void FutureCallback_call LDKFutureCallback *NONNULL_PTR this_arg
	public static native void FutureCallback_call(long this_arg);
	public interface LDKEventHandler {
		 long handle_event(long event);
	}
	public static native long LDKEventHandler_new(LDKEventHandler impl);
	// LDKCResult_NoneReplayEventZ EventHandler_handle_event LDKEventHandler *NONNULL_PTR this_arg, struct LDKEvent event
	public static native long EventHandler_handle_event(long this_arg, long event);
	public interface LDKEventsProvider {
		 void process_pending_events(long handler);
	}
	public static native long LDKEventsProvider_new(LDKEventsProvider impl);
	// void EventsProvider_process_pending_events LDKEventsProvider *NONNULL_PTR this_arg, struct LDKEventHandler handler
	public static native void EventsProvider_process_pending_events(long this_arg, long handler);
	public interface LDKVerification {
		 byte[] hmac_for_offer_payment(long nonce, long expanded_key);
		 long verify_for_offer_payment(byte[] hmac, long nonce, long expanded_key);
	}
	public static native long LDKVerification_new(LDKVerification impl);
	// LDKThirtyTwoBytes Verification_hmac_for_offer_payment LDKVerification *NONNULL_PTR this_arg, struct LDKNonce nonce, const struct LDKExpandedKey *NONNULL_PTR expanded_key
	public static native byte[] Verification_hmac_for_offer_payment(long this_arg, long nonce, long expanded_key);
	// LDKCResult_NoneNoneZ Verification_verify_for_offer_payment LDKVerification *NONNULL_PTR this_arg, struct LDKThirtyTwoBytes hmac, struct LDKNonce nonce, const struct LDKExpandedKey *NONNULL_PTR expanded_key
	public static native long Verification_verify_for_offer_payment(long this_arg, byte[] hmac, long nonce, long expanded_key);
	public static class LDKFailureCode {
		private LDKFailureCode() {}
		public final static class TemporaryNodeFailure extends LDKFailureCode {
			TemporaryNodeFailure() { }
		}
		public final static class RequiredNodeFeatureMissing extends LDKFailureCode {
			RequiredNodeFeatureMissing() { }
		}
		public final static class IncorrectOrUnknownPaymentDetails extends LDKFailureCode {
			IncorrectOrUnknownPaymentDetails() { }
		}
		public final static class InvalidOnionPayload extends LDKFailureCode {
			public long invalid_onion_payload;
			InvalidOnionPayload(long invalid_onion_payload) { this.invalid_onion_payload = invalid_onion_payload; }
		}
		static native void init();
	}
	static { LDKFailureCode.init(); }
	public static native LDKFailureCode LDKFailureCode_ref_from_ptr(long ptr);
	public static class LDKBolt11InvoiceDescription {
		private LDKBolt11InvoiceDescription() {}
		public final static class Direct extends LDKBolt11InvoiceDescription {
			public long direct;
			Direct(long direct) { this.direct = direct; }
		}
		public final static class Hash extends LDKBolt11InvoiceDescription {
			public long hash;
			Hash(long hash) { this.hash = hash; }
		}
		static native void init();
	}
	static { LDKBolt11InvoiceDescription.init(); }
	public static native LDKBolt11InvoiceDescription LDKBolt11InvoiceDescription_ref_from_ptr(long ptr);
	public interface LDKMessageSendEventsProvider {
		 long[] get_and_clear_pending_msg_events();
	}
	public static native long LDKMessageSendEventsProvider_new(LDKMessageSendEventsProvider impl);
	// LDKCVec_MessageSendEventZ MessageSendEventsProvider_get_and_clear_pending_msg_events LDKMessageSendEventsProvider *NONNULL_PTR this_arg
	public static native long[] MessageSendEventsProvider_get_and_clear_pending_msg_events(long this_arg);
	public interface LDKChannelMessageHandler {
		 void handle_open_channel(byte[] their_node_id, long msg);
		 void handle_open_channel_v2(byte[] their_node_id, long msg);
		 void handle_accept_channel(byte[] their_node_id, long msg);
		 void handle_accept_channel_v2(byte[] their_node_id, long msg);
		 void handle_funding_created(byte[] their_node_id, long msg);
		 void handle_funding_signed(byte[] their_node_id, long msg);
		 void handle_channel_ready(byte[] their_node_id, long msg);
		 void handle_shutdown(byte[] their_node_id, long msg);
		 void handle_closing_signed(byte[] their_node_id, long msg);
		 void handle_stfu(byte[] their_node_id, long msg);
		 void handle_tx_add_input(byte[] their_node_id, long msg);
		 void handle_tx_add_output(byte[] their_node_id, long msg);
		 void handle_tx_remove_input(byte[] their_node_id, long msg);
		 void handle_tx_remove_output(byte[] their_node_id, long msg);
		 void handle_tx_complete(byte[] their_node_id, long msg);
		 void handle_tx_signatures(byte[] their_node_id, long msg);
		 void handle_tx_init_rbf(byte[] their_node_id, long msg);
		 void handle_tx_ack_rbf(byte[] their_node_id, long msg);
		 void handle_tx_abort(byte[] their_node_id, long msg);
		 void handle_update_add_htlc(byte[] their_node_id, long msg);
		 void handle_update_fulfill_htlc(byte[] their_node_id, long msg);
		 void handle_update_fail_htlc(byte[] their_node_id, long msg);
		 void handle_update_fail_malformed_htlc(byte[] their_node_id, long msg);
		 void handle_commitment_signed(byte[] their_node_id, long msg);
		 void handle_revoke_and_ack(byte[] their_node_id, long msg);
		 void handle_update_fee(byte[] their_node_id, long msg);
		 void handle_announcement_signatures(byte[] their_node_id, long msg);
		 void peer_disconnected(byte[] their_node_id);
		 long peer_connected(byte[] their_node_id, long msg, boolean inbound);
		 void handle_channel_reestablish(byte[] their_node_id, long msg);
		 void handle_channel_update(byte[] their_node_id, long msg);
		 void handle_error(byte[] their_node_id, long msg);
		 long provided_node_features();
		 long provided_init_features(byte[] their_node_id);
		 long get_chain_hashes();
		 void message_received();
	}
	public static native long LDKChannelMessageHandler_new(LDKChannelMessageHandler impl, LDKMessageSendEventsProvider MessageSendEventsProvider);
	public static native long LDKChannelMessageHandler_get_MessageSendEventsProvider(long arg);
	// void ChannelMessageHandler_handle_open_channel LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKOpenChannel *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_open_channel(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_open_channel_v2 LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKOpenChannelV2 *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_open_channel_v2(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_accept_channel LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKAcceptChannel *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_accept_channel(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_accept_channel_v2 LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKAcceptChannelV2 *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_accept_channel_v2(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_funding_created LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKFundingCreated *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_funding_created(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_funding_signed LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKFundingSigned *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_funding_signed(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_channel_ready LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKChannelReady *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_channel_ready(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_shutdown LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKShutdown *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_shutdown(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_closing_signed LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKClosingSigned *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_closing_signed(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_stfu LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKStfu *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_stfu(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_tx_add_input LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKTxAddInput *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_tx_add_input(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_tx_add_output LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKTxAddOutput *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_tx_add_output(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_tx_remove_input LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKTxRemoveInput *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_tx_remove_input(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_tx_remove_output LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKTxRemoveOutput *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_tx_remove_output(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_tx_complete LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKTxComplete *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_tx_complete(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_tx_signatures LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKTxSignatures *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_tx_signatures(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_tx_init_rbf LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKTxInitRbf *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_tx_init_rbf(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_tx_ack_rbf LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKTxAckRbf *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_tx_ack_rbf(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_tx_abort LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKTxAbort *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_tx_abort(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_update_add_htlc LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKUpdateAddHTLC *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_update_add_htlc(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_update_fulfill_htlc LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKUpdateFulfillHTLC *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_update_fulfill_htlc(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_update_fail_htlc LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKUpdateFailHTLC *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_update_fail_htlc(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_update_fail_malformed_htlc LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKUpdateFailMalformedHTLC *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_update_fail_malformed_htlc(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_commitment_signed LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKCommitmentSigned *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_commitment_signed(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_revoke_and_ack LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKRevokeAndACK *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_revoke_and_ack(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_update_fee LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKUpdateFee *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_update_fee(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_announcement_signatures LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKAnnouncementSignatures *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_announcement_signatures(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_peer_disconnected LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id
	public static native void ChannelMessageHandler_peer_disconnected(long this_arg, byte[] their_node_id);
	// LDKCResult_NoneNoneZ ChannelMessageHandler_peer_connected LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKInit *NONNULL_PTR msg, bool inbound
	public static native long ChannelMessageHandler_peer_connected(long this_arg, byte[] their_node_id, long msg, boolean inbound);
	// void ChannelMessageHandler_handle_channel_reestablish LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKChannelReestablish *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_channel_reestablish(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_channel_update LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKChannelUpdate *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_channel_update(long this_arg, byte[] their_node_id, long msg);
	// void ChannelMessageHandler_handle_error LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKErrorMessage *NONNULL_PTR msg
	public static native void ChannelMessageHandler_handle_error(long this_arg, byte[] their_node_id, long msg);
	// LDKNodeFeatures ChannelMessageHandler_provided_node_features LDKChannelMessageHandler *NONNULL_PTR this_arg
	public static native long ChannelMessageHandler_provided_node_features(long this_arg);
	// LDKInitFeatures ChannelMessageHandler_provided_init_features LDKChannelMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id
	public static native long ChannelMessageHandler_provided_init_features(long this_arg, byte[] their_node_id);
	// LDKCOption_CVec_ThirtyTwoBytesZZ ChannelMessageHandler_get_chain_hashes LDKChannelMessageHandler *NONNULL_PTR this_arg
	public static native long ChannelMessageHandler_get_chain_hashes(long this_arg);
	// void ChannelMessageHandler_message_received LDKChannelMessageHandler *NONNULL_PTR this_arg
	public static native void ChannelMessageHandler_message_received(long this_arg);
	public interface LDKOffersMessageHandler {
		 long handle_message(long message, long context, long responder);
		 long[] release_pending_messages();
	}
	public static native long LDKOffersMessageHandler_new(LDKOffersMessageHandler impl);
	// LDKCOption_C2Tuple_OffersMessageResponseInstructionZZ OffersMessageHandler_handle_message LDKOffersMessageHandler *NONNULL_PTR this_arg, struct LDKOffersMessage message, struct LDKCOption_OffersContextZ context, struct LDKResponder responder
	public static native long OffersMessageHandler_handle_message(long this_arg, long message, long context, long responder);
	// LDKCVec_C2Tuple_OffersMessageMessageSendInstructionsZZ OffersMessageHandler_release_pending_messages LDKOffersMessageHandler *NONNULL_PTR this_arg
	public static native long[] OffersMessageHandler_release_pending_messages(long this_arg);
	public interface LDKAsyncPaymentsMessageHandler {
		 long handle_held_htlc_available(long message, long responder);
		 void handle_release_held_htlc(long message, long context);
		 long[] release_pending_messages();
	}
	public static native long LDKAsyncPaymentsMessageHandler_new(LDKAsyncPaymentsMessageHandler impl);
	// LDKCOption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ AsyncPaymentsMessageHandler_handle_held_htlc_available LDKAsyncPaymentsMessageHandler *NONNULL_PTR this_arg, struct LDKHeldHtlcAvailable message, struct LDKResponder responder
	public static native long AsyncPaymentsMessageHandler_handle_held_htlc_available(long this_arg, long message, long responder);
	// void AsyncPaymentsMessageHandler_handle_release_held_htlc LDKAsyncPaymentsMessageHandler *NONNULL_PTR this_arg, struct LDKReleaseHeldHtlc message, struct LDKAsyncPaymentsContext context
	public static native void AsyncPaymentsMessageHandler_handle_release_held_htlc(long this_arg, long message, long context);
	// LDKCVec_C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZZ AsyncPaymentsMessageHandler_release_pending_messages LDKAsyncPaymentsMessageHandler *NONNULL_PTR this_arg
	public static native long[] AsyncPaymentsMessageHandler_release_pending_messages(long this_arg);
	public interface LDKDNSResolverMessageHandler {
		 long handle_dnssec_query(long message, long responder);
		 void handle_dnssec_proof(long message, long context);
		 long provided_node_features();
		 long[] release_pending_messages();
	}
	public static native long LDKDNSResolverMessageHandler_new(LDKDNSResolverMessageHandler impl);
	// LDKCOption_C2Tuple_DNSResolverMessageResponseInstructionZZ DNSResolverMessageHandler_handle_dnssec_query LDKDNSResolverMessageHandler *NONNULL_PTR this_arg, struct LDKDNSSECQuery message, struct LDKResponder responder
	public static native long DNSResolverMessageHandler_handle_dnssec_query(long this_arg, long message, long responder);
	// void DNSResolverMessageHandler_handle_dnssec_proof LDKDNSResolverMessageHandler *NONNULL_PTR this_arg, struct LDKDNSSECProof message, struct LDKDNSResolverContext context
	public static native void DNSResolverMessageHandler_handle_dnssec_proof(long this_arg, long message, long context);
	// LDKNodeFeatures DNSResolverMessageHandler_provided_node_features LDKDNSResolverMessageHandler *NONNULL_PTR this_arg
	public static native long DNSResolverMessageHandler_provided_node_features(long this_arg);
	// LDKCVec_C2Tuple_DNSResolverMessageMessageSendInstructionsZZ DNSResolverMessageHandler_release_pending_messages LDKDNSResolverMessageHandler *NONNULL_PTR this_arg
	public static native long[] DNSResolverMessageHandler_release_pending_messages(long this_arg);
	public interface LDKNodeIdLookUp {
		 byte[] next_node_id(long short_channel_id);
	}
	public static native long LDKNodeIdLookUp_new(LDKNodeIdLookUp impl);
	// LDKPublicKey NodeIdLookUp_next_node_id LDKNodeIdLookUp *NONNULL_PTR this_arg, uint64_t short_channel_id
	public static native byte[] NodeIdLookUp_next_node_id(long this_arg, long short_channel_id);
	public interface LDKRoutingMessageHandler {
		 long handle_node_announcement(byte[] their_node_id, long msg);
		 long handle_channel_announcement(byte[] their_node_id, long msg);
		 long handle_channel_update(byte[] their_node_id, long msg);
		 long get_next_channel_announcement(long starting_point);
		 long get_next_node_announcement(long starting_point);
		 long peer_connected(byte[] their_node_id, long init, boolean inbound);
		 long handle_reply_channel_range(byte[] their_node_id, long msg);
		 long handle_reply_short_channel_ids_end(byte[] their_node_id, long msg);
		 long handle_query_channel_range(byte[] their_node_id, long msg);
		 long handle_query_short_channel_ids(byte[] their_node_id, long msg);
		 boolean processing_queue_high();
		 long provided_node_features();
		 long provided_init_features(byte[] their_node_id);
	}
	public static native long LDKRoutingMessageHandler_new(LDKRoutingMessageHandler impl, LDKMessageSendEventsProvider MessageSendEventsProvider);
	public static native long LDKRoutingMessageHandler_get_MessageSendEventsProvider(long arg);
	// LDKCResult_boolLightningErrorZ RoutingMessageHandler_handle_node_announcement LDKRoutingMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKNodeAnnouncement *NONNULL_PTR msg
	public static native long RoutingMessageHandler_handle_node_announcement(long this_arg, byte[] their_node_id, long msg);
	// LDKCResult_boolLightningErrorZ RoutingMessageHandler_handle_channel_announcement LDKRoutingMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKChannelAnnouncement *NONNULL_PTR msg
	public static native long RoutingMessageHandler_handle_channel_announcement(long this_arg, byte[] their_node_id, long msg);
	// LDKCResult_boolLightningErrorZ RoutingMessageHandler_handle_channel_update LDKRoutingMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKChannelUpdate *NONNULL_PTR msg
	public static native long RoutingMessageHandler_handle_channel_update(long this_arg, byte[] their_node_id, long msg);
	// LDKCOption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ RoutingMessageHandler_get_next_channel_announcement LDKRoutingMessageHandler *NONNULL_PTR this_arg, uint64_t starting_point
	public static native long RoutingMessageHandler_get_next_channel_announcement(long this_arg, long starting_point);
	// LDKNodeAnnouncement RoutingMessageHandler_get_next_node_announcement LDKRoutingMessageHandler *NONNULL_PTR this_arg, struct LDKNodeId starting_point
	public static native long RoutingMessageHandler_get_next_node_announcement(long this_arg, long starting_point);
	// LDKCResult_NoneNoneZ RoutingMessageHandler_peer_connected LDKRoutingMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKInit *NONNULL_PTR init, bool inbound
	public static native long RoutingMessageHandler_peer_connected(long this_arg, byte[] their_node_id, long init, boolean inbound);
	// LDKCResult_NoneLightningErrorZ RoutingMessageHandler_handle_reply_channel_range LDKRoutingMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, struct LDKReplyChannelRange msg
	public static native long RoutingMessageHandler_handle_reply_channel_range(long this_arg, byte[] their_node_id, long msg);
	// LDKCResult_NoneLightningErrorZ RoutingMessageHandler_handle_reply_short_channel_ids_end LDKRoutingMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, struct LDKReplyShortChannelIdsEnd msg
	public static native long RoutingMessageHandler_handle_reply_short_channel_ids_end(long this_arg, byte[] their_node_id, long msg);
	// LDKCResult_NoneLightningErrorZ RoutingMessageHandler_handle_query_channel_range LDKRoutingMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, struct LDKQueryChannelRange msg
	public static native long RoutingMessageHandler_handle_query_channel_range(long this_arg, byte[] their_node_id, long msg);
	// LDKCResult_NoneLightningErrorZ RoutingMessageHandler_handle_query_short_channel_ids LDKRoutingMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, struct LDKQueryShortChannelIds msg
	public static native long RoutingMessageHandler_handle_query_short_channel_ids(long this_arg, byte[] their_node_id, long msg);
	// bool RoutingMessageHandler_processing_queue_high LDKRoutingMessageHandler *NONNULL_PTR this_arg
	public static native boolean RoutingMessageHandler_processing_queue_high(long this_arg);
	// LDKNodeFeatures RoutingMessageHandler_provided_node_features LDKRoutingMessageHandler *NONNULL_PTR this_arg
	public static native long RoutingMessageHandler_provided_node_features(long this_arg);
	// LDKInitFeatures RoutingMessageHandler_provided_init_features LDKRoutingMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id
	public static native long RoutingMessageHandler_provided_init_features(long this_arg, byte[] their_node_id);
	public interface LDKOnionMessageHandler {
		 void handle_onion_message(byte[] peer_node_id, long msg);
		 long next_onion_message_for_peer(byte[] peer_node_id);
		 long peer_connected(byte[] their_node_id, long init, boolean inbound);
		 void peer_disconnected(byte[] their_node_id);
		 void timer_tick_occurred();
		 long provided_node_features();
		 long provided_init_features(byte[] their_node_id);
	}
	public static native long LDKOnionMessageHandler_new(LDKOnionMessageHandler impl);
	// void OnionMessageHandler_handle_onion_message LDKOnionMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey peer_node_id, const struct LDKOnionMessage *NONNULL_PTR msg
	public static native void OnionMessageHandler_handle_onion_message(long this_arg, byte[] peer_node_id, long msg);
	// LDKOnionMessage OnionMessageHandler_next_onion_message_for_peer LDKOnionMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey peer_node_id
	public static native long OnionMessageHandler_next_onion_message_for_peer(long this_arg, byte[] peer_node_id);
	// LDKCResult_NoneNoneZ OnionMessageHandler_peer_connected LDKOnionMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKInit *NONNULL_PTR init, bool inbound
	public static native long OnionMessageHandler_peer_connected(long this_arg, byte[] their_node_id, long init, boolean inbound);
	// void OnionMessageHandler_peer_disconnected LDKOnionMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id
	public static native void OnionMessageHandler_peer_disconnected(long this_arg, byte[] their_node_id);
	// void OnionMessageHandler_timer_tick_occurred LDKOnionMessageHandler *NONNULL_PTR this_arg
	public static native void OnionMessageHandler_timer_tick_occurred(long this_arg);
	// LDKNodeFeatures OnionMessageHandler_provided_node_features LDKOnionMessageHandler *NONNULL_PTR this_arg
	public static native long OnionMessageHandler_provided_node_features(long this_arg);
	// LDKInitFeatures OnionMessageHandler_provided_init_features LDKOnionMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id
	public static native long OnionMessageHandler_provided_init_features(long this_arg, byte[] their_node_id);
	public interface LDKCustomMessageReader {
		 long read(short message_type, byte[] buffer);
	}
	public static native long LDKCustomMessageReader_new(LDKCustomMessageReader impl);
	// LDKCResult_COption_TypeZDecodeErrorZ CustomMessageReader_read LDKCustomMessageReader *NONNULL_PTR this_arg, uint16_t message_type, struct LDKu8slice buffer
	public static native long CustomMessageReader_read(long this_arg, short message_type, byte[] buffer);
	public interface LDKCustomMessageHandler {
		 long handle_custom_message(long msg, byte[] sender_node_id);
		 long[] get_and_clear_pending_msg();
		 void peer_disconnected(byte[] their_node_id);
		 long peer_connected(byte[] their_node_id, long msg, boolean inbound);
		 long provided_node_features();
		 long provided_init_features(byte[] their_node_id);
	}
	public static native long LDKCustomMessageHandler_new(LDKCustomMessageHandler impl, LDKCustomMessageReader CustomMessageReader);
	public static native long LDKCustomMessageHandler_get_CustomMessageReader(long arg);
	// LDKCResult_NoneLightningErrorZ CustomMessageHandler_handle_custom_message LDKCustomMessageHandler *NONNULL_PTR this_arg, struct LDKType msg, struct LDKPublicKey sender_node_id
	public static native long CustomMessageHandler_handle_custom_message(long this_arg, long msg, byte[] sender_node_id);
	// LDKCVec_C2Tuple_PublicKeyTypeZZ CustomMessageHandler_get_and_clear_pending_msg LDKCustomMessageHandler *NONNULL_PTR this_arg
	public static native long[] CustomMessageHandler_get_and_clear_pending_msg(long this_arg);
	// void CustomMessageHandler_peer_disconnected LDKCustomMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id
	public static native void CustomMessageHandler_peer_disconnected(long this_arg, byte[] their_node_id);
	// LDKCResult_NoneNoneZ CustomMessageHandler_peer_connected LDKCustomMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id, const struct LDKInit *NONNULL_PTR msg, bool inbound
	public static native long CustomMessageHandler_peer_connected(long this_arg, byte[] their_node_id, long msg, boolean inbound);
	// LDKNodeFeatures CustomMessageHandler_provided_node_features LDKCustomMessageHandler *NONNULL_PTR this_arg
	public static native long CustomMessageHandler_provided_node_features(long this_arg);
	// LDKInitFeatures CustomMessageHandler_provided_init_features LDKCustomMessageHandler *NONNULL_PTR this_arg, struct LDKPublicKey their_node_id
	public static native long CustomMessageHandler_provided_init_features(long this_arg, byte[] their_node_id);
	public interface LDKCustomOnionMessageHandler {
		 long handle_custom_message(long message, long context, long responder);
		 long read_custom_message(long message_type, byte[] buffer);
		 long[] release_pending_custom_messages();
	}
	public static native long LDKCustomOnionMessageHandler_new(LDKCustomOnionMessageHandler impl);
	// LDKCOption_C2Tuple_OnionMessageContentsResponseInstructionZZ CustomOnionMessageHandler_handle_custom_message LDKCustomOnionMessageHandler *NONNULL_PTR this_arg, struct LDKOnionMessageContents message, struct LDKCOption_CVec_u8ZZ context, struct LDKResponder responder
	public static native long CustomOnionMessageHandler_handle_custom_message(long this_arg, long message, long context, long responder);
	// LDKCResult_COption_OnionMessageContentsZDecodeErrorZ CustomOnionMessageHandler_read_custom_message LDKCustomOnionMessageHandler *NONNULL_PTR this_arg, uint64_t message_type, struct LDKu8slice buffer
	public static native long CustomOnionMessageHandler_read_custom_message(long this_arg, long message_type, byte[] buffer);
	// LDKCVec_C2Tuple_OnionMessageContentsMessageSendInstructionsZZ CustomOnionMessageHandler_release_pending_custom_messages LDKCustomOnionMessageHandler *NONNULL_PTR this_arg
	public static native long[] CustomOnionMessageHandler_release_pending_custom_messages(long this_arg);
	public interface LDKSocketDescriptor {
		 long send_data(byte[] data, boolean resume_read);
		 void disconnect_socket();
		 boolean eq(long other_arg);
		 long hash();
	}
	public static native long LDKSocketDescriptor_new(LDKSocketDescriptor impl);
	// uintptr_t SocketDescriptor_send_data LDKSocketDescriptor *NONNULL_PTR this_arg, struct LDKu8slice data, bool resume_read
	public static native long SocketDescriptor_send_data(long this_arg, byte[] data, boolean resume_read);
	// void SocketDescriptor_disconnect_socket LDKSocketDescriptor *NONNULL_PTR this_arg
	public static native void SocketDescriptor_disconnect_socket(long this_arg);
	// uint64_t SocketDescriptor_hash LDKSocketDescriptor *NONNULL_PTR this_arg
	public static native long SocketDescriptor_hash(long this_arg);
	public interface LDKSignBolt12InvoiceFn {
		 long sign_invoice(long message);
	}
	public static native long LDKSignBolt12InvoiceFn_new(LDKSignBolt12InvoiceFn impl);
	// LDKCResult_SchnorrSignatureNoneZ SignBolt12InvoiceFn_sign_invoice LDKSignBolt12InvoiceFn *NONNULL_PTR this_arg, const struct LDKUnsignedBolt12Invoice *NONNULL_PTR message
	public static native long SignBolt12InvoiceFn_sign_invoice(long this_arg, long message);
	public interface LDKSignInvoiceRequestFn {
		 long sign_invoice_request(long message);
	}
	public static native long LDKSignInvoiceRequestFn_new(LDKSignInvoiceRequestFn impl);
	// LDKCResult_SchnorrSignatureNoneZ SignInvoiceRequestFn_sign_invoice_request LDKSignInvoiceRequestFn *NONNULL_PTR this_arg, const struct LDKUnsignedInvoiceRequest *NONNULL_PTR message
	public static native long SignInvoiceRequestFn_sign_invoice_request(long this_arg, long message);
	public static class LDKSignError {
		private LDKSignError() {}
		public final static class Signing extends LDKSignError {
			Signing() { }
		}
		public final static class Verification extends LDKSignError {
			public org.ldk.enums.Secp256k1Error verification;
			Verification(org.ldk.enums.Secp256k1Error verification) { this.verification = verification; }
		}
		static native void init();
	}
	static { LDKSignError.init(); }
	public static native LDKSignError LDKSignError_ref_from_ptr(long ptr);
	public static class LDKEffectiveCapacity {
		private LDKEffectiveCapacity() {}
		public final static class ExactLiquidity extends LDKEffectiveCapacity {
			public long liquidity_msat;
			ExactLiquidity(long liquidity_msat) { this.liquidity_msat = liquidity_msat; }
		}
		public final static class AdvertisedMaxHTLC extends LDKEffectiveCapacity {
			public long amount_msat;
			AdvertisedMaxHTLC(long amount_msat) { this.amount_msat = amount_msat; }
		}
		public final static class Total extends LDKEffectiveCapacity {
			public long capacity_msat;
			public long htlc_maximum_msat;
			Total(long capacity_msat, long htlc_maximum_msat) { this.capacity_msat = capacity_msat; this.htlc_maximum_msat = htlc_maximum_msat; }
		}
		public final static class Infinite extends LDKEffectiveCapacity {
			Infinite() { }
		}
		public final static class HintMaxHTLC extends LDKEffectiveCapacity {
			public long amount_msat;
			HintMaxHTLC(long amount_msat) { this.amount_msat = amount_msat; }
		}
		public final static class Unknown extends LDKEffectiveCapacity {
			Unknown() { }
		}
		static native void init();
	}
	static { LDKEffectiveCapacity.init(); }
	public static native LDKEffectiveCapacity LDKEffectiveCapacity_ref_from_ptr(long ptr);
	public static class LDKPayee {
		private LDKPayee() {}
		public final static class Blinded extends LDKPayee {
			public long[] route_hints;
			public long features;
			Blinded(long[] route_hints, long features) { this.route_hints = route_hints; this.features = features; }
		}
		public final static class Clear extends LDKPayee {
			public byte[] node_id;
			public long[] route_hints;
			public long features;
			public int final_cltv_expiry_delta;
			Clear(byte[] node_id, long[] route_hints, long features, int final_cltv_expiry_delta) { this.node_id = node_id; this.route_hints = route_hints; this.features = features; this.final_cltv_expiry_delta = final_cltv_expiry_delta; }
		}
		static native void init();
	}
	static { LDKPayee.init(); }
	public static native LDKPayee LDKPayee_ref_from_ptr(long ptr);
	public interface LDKScore {
		 byte[] write();
	}
	public static native long LDKScore_new(LDKScore impl, LDKScoreLookUp ScoreLookUp, LDKScoreUpdate ScoreUpdate);
	public static native long LDKScore_get_ScoreLookUp(long arg);
	public static native long LDKScore_get_ScoreUpdate(long arg);
	// LDKCVec_u8Z Score_write LDKScore *NONNULL_PTR this_arg
	public static native byte[] Score_write(long this_arg);
	public static class LDKIntroductionNode {
		private LDKIntroductionNode() {}
		public final static class NodeId extends LDKIntroductionNode {
			public byte[] node_id;
			NodeId(byte[] node_id) { this.node_id = node_id; }
		}
		public final static class DirectedShortChannelId extends LDKIntroductionNode {
			public org.ldk.enums.Direction _0;
			public long _1;
			DirectedShortChannelId(org.ldk.enums.Direction _0, long _1) { this._0 = _0; this._1 = _1; }
		}
		static native void init();
	}
	static { LDKIntroductionNode.init(); }
	public static native LDKIntroductionNode LDKIntroductionNode_ref_from_ptr(long ptr);
	public interface LDKCoinSelectionSource {
		 long select_confirmed_utxos(byte[] claim_id, long[] must_spend, long[] must_pay_to, int target_feerate_sat_per_1000_weight);
		 long sign_psbt(byte[] psbt);
	}
	public static native long LDKCoinSelectionSource_new(LDKCoinSelectionSource impl);
	// LDKCResult_CoinSelectionNoneZ CoinSelectionSource_select_confirmed_utxos LDKCoinSelectionSource *NONNULL_PTR this_arg, struct LDKThirtyTwoBytes claim_id, struct LDKCVec_InputZ must_spend, struct LDKCVec_TxOutZ must_pay_to, uint32_t target_feerate_sat_per_1000_weight
	public static native long CoinSelectionSource_select_confirmed_utxos(long this_arg, byte[] claim_id, long[] must_spend, long[] must_pay_to, int target_feerate_sat_per_1000_weight);
	// LDKCResult_TransactionNoneZ CoinSelectionSource_sign_psbt LDKCoinSelectionSource *NONNULL_PTR this_arg, struct LDKCVec_u8Z psbt
	public static native long CoinSelectionSource_sign_psbt(long this_arg, byte[] psbt);
	public interface LDKWalletSource {
		 long list_confirmed_utxos();
		 long get_change_script();
		 long sign_psbt(byte[] psbt);
	}
	public static native long LDKWalletSource_new(LDKWalletSource impl);
	// LDKCResult_CVec_UtxoZNoneZ WalletSource_list_confirmed_utxos LDKWalletSource *NONNULL_PTR this_arg
	public static native long WalletSource_list_confirmed_utxos(long this_arg);
	// LDKCResult_CVec_u8ZNoneZ WalletSource_get_change_script LDKWalletSource *NONNULL_PTR this_arg
	public static native long WalletSource_get_change_script(long this_arg);
	// LDKCResult_TransactionNoneZ WalletSource_sign_psbt LDKWalletSource *NONNULL_PTR this_arg, struct LDKCVec_u8Z psbt
	public static native long WalletSource_sign_psbt(long this_arg, byte[] psbt);
	public static class LDKGossipSync {
		private LDKGossipSync() {}
		public final static class P2P extends LDKGossipSync {
			public long p2p;
			P2P(long p2p) { this.p2p = p2p; }
		}
		public final static class Rapid extends LDKGossipSync {
			public long rapid;
			Rapid(long rapid) { this.rapid = rapid; }
		}
		public final static class None extends LDKGossipSync {
			None() { }
		}
		static native void init();
	}
	static { LDKGossipSync.init(); }
	public static native LDKGossipSync LDKGossipSync_ref_from_ptr(long ptr);
	public static class LDKFallback {
		private LDKFallback() {}
		public final static class SegWitProgram extends LDKFallback {
			public byte version;
			public byte[] program;
			SegWitProgram(byte version, byte[] program) { this.version = version; this.program = program; }
		}
		public final static class PubKeyHash extends LDKFallback {
			public byte[] pub_key_hash;
			PubKeyHash(byte[] pub_key_hash) { this.pub_key_hash = pub_key_hash; }
		}
		public final static class ScriptHash extends LDKFallback {
			public byte[] script_hash;
			ScriptHash(byte[] script_hash) { this.script_hash = script_hash; }
		}
		static native void init();
	}
	static { LDKFallback.init(); }
	public static native LDKFallback LDKFallback_ref_from_ptr(long ptr);
	public static class LDKLSPS0ClientEvent {
		private LDKLSPS0ClientEvent() {}
		public final static class ListProtocolsResponse extends LDKLSPS0ClientEvent {
			public byte[] counterparty_node_id;
			public short[] protocols;
			ListProtocolsResponse(byte[] counterparty_node_id, short[] protocols) { this.counterparty_node_id = counterparty_node_id; this.protocols = protocols; }
		}
		static native void init();
	}
	static { LDKLSPS0ClientEvent.init(); }
	public static native LDKLSPS0ClientEvent LDKLSPS0ClientEvent_ref_from_ptr(long ptr);
	public static class LDKLSPS1ClientEvent {
		private LDKLSPS1ClientEvent() {}
		public final static class SupportedOptionsReady extends LDKLSPS1ClientEvent {
			public long request_id;
			public byte[] counterparty_node_id;
			public long supported_options;
			SupportedOptionsReady(long request_id, byte[] counterparty_node_id, long supported_options) { this.request_id = request_id; this.counterparty_node_id = counterparty_node_id; this.supported_options = supported_options; }
		}
		public final static class SupportedOptionsRequestFailed extends LDKLSPS1ClientEvent {
			public long request_id;
			public byte[] counterparty_node_id;
			public long error;
			SupportedOptionsRequestFailed(long request_id, byte[] counterparty_node_id, long error) { this.request_id = request_id; this.counterparty_node_id = counterparty_node_id; this.error = error; }
		}
		public final static class OrderCreated extends LDKLSPS1ClientEvent {
			public long request_id;
			public byte[] counterparty_node_id;
			public long order_id;
			public long order;
			public long payment;
			public long channel;
			OrderCreated(long request_id, byte[] counterparty_node_id, long order_id, long order, long payment, long channel) { this.request_id = request_id; this.counterparty_node_id = counterparty_node_id; this.order_id = order_id; this.order = order; this.payment = payment; this.channel = channel; }
		}
		public final static class OrderStatus extends LDKLSPS1ClientEvent {
			public long request_id;
			public byte[] counterparty_node_id;
			public long order_id;
			public long order;
			public long payment;
			public long channel;
			OrderStatus(long request_id, byte[] counterparty_node_id, long order_id, long order, long payment, long channel) { this.request_id = request_id; this.counterparty_node_id = counterparty_node_id; this.order_id = order_id; this.order = order; this.payment = payment; this.channel = channel; }
		}
		public final static class OrderRequestFailed extends LDKLSPS1ClientEvent {
			public long request_id;
			public byte[] counterparty_node_id;
			public long error;
			OrderRequestFailed(long request_id, byte[] counterparty_node_id, long error) { this.request_id = request_id; this.counterparty_node_id = counterparty_node_id; this.error = error; }
		}
		static native void init();
	}
	static { LDKLSPS1ClientEvent.init(); }
	public static native LDKLSPS1ClientEvent LDKLSPS1ClientEvent_ref_from_ptr(long ptr);
	public static class LDKLSPS2ClientEvent {
		private LDKLSPS2ClientEvent() {}
		public final static class OpeningParametersReady extends LDKLSPS2ClientEvent {
			public long request_id;
			public byte[] counterparty_node_id;
			public long[] opening_fee_params_menu;
			OpeningParametersReady(long request_id, byte[] counterparty_node_id, long[] opening_fee_params_menu) { this.request_id = request_id; this.counterparty_node_id = counterparty_node_id; this.opening_fee_params_menu = opening_fee_params_menu; }
		}
		public final static class InvoiceParametersReady extends LDKLSPS2ClientEvent {
			public long request_id;
			public byte[] counterparty_node_id;
			public long intercept_scid;
			public int cltv_expiry_delta;
			public long payment_size_msat;
			InvoiceParametersReady(long request_id, byte[] counterparty_node_id, long intercept_scid, int cltv_expiry_delta, long payment_size_msat) { this.request_id = request_id; this.counterparty_node_id = counterparty_node_id; this.intercept_scid = intercept_scid; this.cltv_expiry_delta = cltv_expiry_delta; this.payment_size_msat = payment_size_msat; }
		}
		static native void init();
	}
	static { LDKLSPS2ClientEvent.init(); }
	public static native LDKLSPS2ClientEvent LDKLSPS2ClientEvent_ref_from_ptr(long ptr);
	public static class LDKLSPS2ServiceEvent {
		private LDKLSPS2ServiceEvent() {}
		public final static class GetInfo extends LDKLSPS2ServiceEvent {
			public long request_id;
			public byte[] counterparty_node_id;
			public long token;
			GetInfo(long request_id, byte[] counterparty_node_id, long token) { this.request_id = request_id; this.counterparty_node_id = counterparty_node_id; this.token = token; }
		}
		public final static class BuyRequest extends LDKLSPS2ServiceEvent {
			public long request_id;
			public byte[] counterparty_node_id;
			public long opening_fee_params;
			public long payment_size_msat;
			BuyRequest(long request_id, byte[] counterparty_node_id, long opening_fee_params, long payment_size_msat) { this.request_id = request_id; this.counterparty_node_id = counterparty_node_id; this.opening_fee_params = opening_fee_params; this.payment_size_msat = payment_size_msat; }
		}
		public final static class OpenChannel extends LDKLSPS2ServiceEvent {
			public byte[] their_network_key;
			public long amt_to_forward_msat;
			public long opening_fee_msat;
			public byte[] user_channel_id;
			public long intercept_scid;
			OpenChannel(byte[] their_network_key, long amt_to_forward_msat, long opening_fee_msat, byte[] user_channel_id, long intercept_scid) { this.their_network_key = their_network_key; this.amt_to_forward_msat = amt_to_forward_msat; this.opening_fee_msat = opening_fee_msat; this.user_channel_id = user_channel_id; this.intercept_scid = intercept_scid; }
		}
		static native void init();
	}
	static { LDKLSPS2ServiceEvent.init(); }
	public static native LDKLSPS2ServiceEvent LDKLSPS2ServiceEvent_ref_from_ptr(long ptr);
	public static class LDKLiquidityEvent {
		private LDKLiquidityEvent() {}
		public final static class LSPS0Client extends LDKLiquidityEvent {
			LSPS0Client() { }
		}
		public final static class LSPS1Client extends LDKLiquidityEvent {
			LSPS1Client() { }
		}
		public final static class LSPS2Client extends LDKLiquidityEvent {
			LSPS2Client() { }
		}
		public final static class LSPS2Service extends LDKLiquidityEvent {
			LSPS2Service() { }
		}
		static native void init();
	}
	static { LDKLiquidityEvent.init(); }
	public static native LDKLiquidityEvent LDKLiquidityEvent_ref_from_ptr(long ptr);
	public static class LDKLSPS0Request {
		private LDKLSPS0Request() {}
		public final static class ListProtocols extends LDKLSPS0Request {
			public long list_protocols;
			ListProtocols(long list_protocols) { this.list_protocols = list_protocols; }
		}
		static native void init();
	}
	static { LDKLSPS0Request.init(); }
	public static native LDKLSPS0Request LDKLSPS0Request_ref_from_ptr(long ptr);
	public static class LDKLSPS0Response {
		private LDKLSPS0Response() {}
		public final static class ListProtocols extends LDKLSPS0Response {
			public long list_protocols;
			ListProtocols(long list_protocols) { this.list_protocols = list_protocols; }
		}
		public final static class ListProtocolsError extends LDKLSPS0Response {
			public long list_protocols_error;
			ListProtocolsError(long list_protocols_error) { this.list_protocols_error = list_protocols_error; }
		}
		static native void init();
	}
	static { LDKLSPS0Response.init(); }
	public static native LDKLSPS0Response LDKLSPS0Response_ref_from_ptr(long ptr);
	public static class LDKLSPS0Message {
		private LDKLSPS0Message() {}
		public final static class Request extends LDKLSPS0Message {
			public long _0;
			public long _1;
			Request(long _0, long _1) { this._0 = _0; this._1 = _1; }
		}
		public final static class Response extends LDKLSPS0Message {
			public long _0;
			public long _1;
			Response(long _0, long _1) { this._0 = _0; this._1 = _1; }
		}
		static native void init();
	}
	static { LDKLSPS0Message.init(); }
	public static native LDKLSPS0Message LDKLSPS0Message_ref_from_ptr(long ptr);
	public static class LDKLSPS1Request {
		private LDKLSPS1Request() {}
		public final static class GetInfo extends LDKLSPS1Request {
			public long get_info;
			GetInfo(long get_info) { this.get_info = get_info; }
		}
		public final static class CreateOrder extends LDKLSPS1Request {
			public long create_order;
			CreateOrder(long create_order) { this.create_order = create_order; }
		}
		public final static class GetOrder extends LDKLSPS1Request {
			public long get_order;
			GetOrder(long get_order) { this.get_order = get_order; }
		}
		static native void init();
	}
	static { LDKLSPS1Request.init(); }
	public static native LDKLSPS1Request LDKLSPS1Request_ref_from_ptr(long ptr);
	public static class LDKLSPS1Response {
		private LDKLSPS1Response() {}
		public final static class GetInfo extends LDKLSPS1Response {
			public long get_info;
			GetInfo(long get_info) { this.get_info = get_info; }
		}
		public final static class GetInfoError extends LDKLSPS1Response {
			public long get_info_error;
			GetInfoError(long get_info_error) { this.get_info_error = get_info_error; }
		}
		public final static class CreateOrder extends LDKLSPS1Response {
			public long create_order;
			CreateOrder(long create_order) { this.create_order = create_order; }
		}
		public final static class CreateOrderError extends LDKLSPS1Response {
			public long create_order_error;
			CreateOrderError(long create_order_error) { this.create_order_error = create_order_error; }
		}
		public final static class GetOrder extends LDKLSPS1Response {
			public long get_order;
			GetOrder(long get_order) { this.get_order = get_order; }
		}
		public final static class GetOrderError extends LDKLSPS1Response {
			public long get_order_error;
			GetOrderError(long get_order_error) { this.get_order_error = get_order_error; }
		}
		static native void init();
	}
	static { LDKLSPS1Response.init(); }
	public static native LDKLSPS1Response LDKLSPS1Response_ref_from_ptr(long ptr);
	public static class LDKLSPS1Message {
		private LDKLSPS1Message() {}
		public final static class Request extends LDKLSPS1Message {
			public long _0;
			public long _1;
			Request(long _0, long _1) { this._0 = _0; this._1 = _1; }
		}
		public final static class Response extends LDKLSPS1Message {
			public long _0;
			public long _1;
			Response(long _0, long _1) { this._0 = _0; this._1 = _1; }
		}
		static native void init();
	}
	static { LDKLSPS1Message.init(); }
	public static native LDKLSPS1Message LDKLSPS1Message_ref_from_ptr(long ptr);
	public static class LDKLSPS2Request {
		private LDKLSPS2Request() {}
		public final static class GetInfo extends LDKLSPS2Request {
			public long get_info;
			GetInfo(long get_info) { this.get_info = get_info; }
		}
		public final static class Buy extends LDKLSPS2Request {
			public long buy;
			Buy(long buy) { this.buy = buy; }
		}
		static native void init();
	}
	static { LDKLSPS2Request.init(); }
	public static native LDKLSPS2Request LDKLSPS2Request_ref_from_ptr(long ptr);
	public static class LDKLSPS2Response {
		private LDKLSPS2Response() {}
		public final static class GetInfo extends LDKLSPS2Response {
			public long get_info;
			GetInfo(long get_info) { this.get_info = get_info; }
		}
		public final static class GetInfoError extends LDKLSPS2Response {
			public long get_info_error;
			GetInfoError(long get_info_error) { this.get_info_error = get_info_error; }
		}
		public final static class Buy extends LDKLSPS2Response {
			public long buy;
			Buy(long buy) { this.buy = buy; }
		}
		public final static class BuyError extends LDKLSPS2Response {
			public long buy_error;
			BuyError(long buy_error) { this.buy_error = buy_error; }
		}
		static native void init();
	}
	static { LDKLSPS2Response.init(); }
	public static native LDKLSPS2Response LDKLSPS2Response_ref_from_ptr(long ptr);
	public static class LDKLSPS2Message {
		private LDKLSPS2Message() {}
		public final static class Request extends LDKLSPS2Message {
			public long _0;
			public long _1;
			Request(long _0, long _1) { this._0 = _0; this._1 = _1; }
		}
		public final static class Response extends LDKLSPS2Message {
			public long _0;
			public long _1;
			Response(long _0, long _1) { this._0 = _0; this._1 = _1; }
		}
		static native void init();
	}
	static { LDKLSPS2Message.init(); }
	public static native LDKLSPS2Message LDKLSPS2Message_ref_from_ptr(long ptr);
	public static class LDKLSPSMessage {
		private LDKLSPSMessage() {}
		public final static class Invalid extends LDKLSPSMessage {
			public long invalid;
			Invalid(long invalid) { this.invalid = invalid; }
		}
		public final static class LSPS0 extends LDKLSPSMessage {
			LSPS0() { }
		}
		public final static class LSPS1 extends LDKLSPSMessage {
			LSPS1() { }
		}
		public final static class LSPS2 extends LDKLSPSMessage {
			LSPS2() { }
		}
		static native void init();
	}
	static { LDKLSPSMessage.init(); }
	public static native LDKLSPSMessage LDKLSPSMessage_ref_from_ptr(long ptr);
	public interface LDKProcessMessagesCallback {
		 void call();
	}
	public static native long LDKProcessMessagesCallback_new(LDKProcessMessagesCallback impl);
	// void ProcessMessagesCallback_call LDKProcessMessagesCallback *NONNULL_PTR this_arg
	public static native void ProcessMessagesCallback_call(long this_arg);
	// struct LDKStr _ldk_get_compiled_version(void);
	public static native String _ldk_get_compiled_version();
	// struct LDKStr _ldk_c_bindings_get_compiled_version(void);
	public static native String _ldk_c_bindings_get_compiled_version();
	// struct LDKSixteenBytes U128_le_bytes(struct LDKU128 val);
	public static native byte[] U128_le_bytes(byte[] val);
	// struct LDKU128 U128_new(struct LDKSixteenBytes le_bytes);
	public static native byte[] U128_new(byte[] le_bytes);
	// struct LDKWitnessProgram WitnessProgram_new(struct LDKWitnessVersion version, struct LDKCVec_u8Z program);
	public static native long WitnessProgram_new(byte version, byte[] program);
	// struct LDKWitnessVersion WitnessProgram_get_version(const struct LDKWitnessProgram *NONNULL_PTR prog);
	public static native byte WitnessProgram_get_version(long prog);
	// struct LDKu8slice WitnessProgram_get_program(const struct LDKWitnessProgram *NONNULL_PTR prog);
	public static native byte[] WitnessProgram_get_program(long prog);
	// uint64_t WitnessProgram_clone_ptr(LDKWitnessProgram *NONNULL_PTR arg);
	public static native long WitnessProgram_clone_ptr(long arg);
	// struct LDKWitnessProgram WitnessProgram_clone(const struct LDKWitnessProgram *NONNULL_PTR orig);
	public static native long WitnessProgram_clone(long orig);
	// void WitnessProgram_free(struct LDKWitnessProgram o);
	public static native void WitnessProgram_free(long o);
	// struct LDKStr Address_to_string(const struct LDKAddress *NONNULL_PTR addr);
	public static native String Address_to_string(long addr);
	// struct LDKCOption_AddressZ Address_new(struct LDKStr s);
	public static native long Address_new(String s);
	// void Address_free(struct LDKAddress o);
	public static native void Address_free(long o);
	// uint64_t Address_clone_ptr(LDKAddress *NONNULL_PTR arg);
	public static native long Address_clone_ptr(long arg);
	// struct LDKAddress Address_clone(const struct LDKAddress *NONNULL_PTR orig);
	public static native long Address_clone(long orig);
	// struct LDKBigEndianScalar BigEndianScalar_new(struct LDKThirtyTwoBytes big_endian_bytes);
	public static native long BigEndianScalar_new(byte[] big_endian_bytes);
	// uint64_t BigEndianScalar_clone_ptr(LDKBigEndianScalar *NONNULL_PTR arg);
	public static native long BigEndianScalar_clone_ptr(long arg);
	// struct LDKBigEndianScalar BigEndianScalar_clone(const struct LDKBigEndianScalar *NONNULL_PTR orig);
	public static native long BigEndianScalar_clone(long orig);
	// uint64_t Bech32Error_clone_ptr(LDKBech32Error *NONNULL_PTR arg);
	public static native long Bech32Error_clone_ptr(long arg);
	// struct LDKBech32Error Bech32Error_clone(const struct LDKBech32Error *NONNULL_PTR orig);
	public static native long Bech32Error_clone(long orig);
	// void Bech32Error_free(struct LDKBech32Error o);
	public static native void Bech32Error_free(long o);
	// void Transaction_free(struct LDKTransaction _res);
	public static native void Transaction_free(byte[] _res);
	// void Witness_free(struct LDKWitness _res);
	public static native void Witness_free(byte[] _res);
	// struct LDKTxIn TxIn_new(struct LDKWitness witness, struct LDKCVec_u8Z script_sig, uint32_t sequence, struct LDKThirtyTwoBytes previous_txid, uint32_t previous_vout);
	public static native long TxIn_new(byte[] witness, byte[] script_sig, int sequence, byte[] previous_txid, int previous_vout);
	// struct LDKWitness TxIn_get_witness(const struct LDKTxIn *NONNULL_PTR txin);
	public static native byte[] TxIn_get_witness(long txin);
	// struct LDKu8slice TxIn_get_script_sig(const struct LDKTxIn *NONNULL_PTR txin);
	public static native byte[] TxIn_get_script_sig(long txin);
	// uint32_t TxIn_get_sequence(const struct LDKTxIn *NONNULL_PTR txin);
	public static native int TxIn_get_sequence(long txin);
	// struct LDKThirtyTwoBytes TxIn_get_previous_txid(const struct LDKTxIn *NONNULL_PTR txin);
	public static native byte[] TxIn_get_previous_txid(long txin);
	// uint32_t TxIn_get_previous_vout(const struct LDKTxIn *NONNULL_PTR txin);
	public static native int TxIn_get_previous_vout(long txin);
	// void TxIn_free(struct LDKTxIn _res);
	public static native void TxIn_free(long _res);
	// struct LDKTxOut TxOut_new(struct LDKCVec_u8Z script_pubkey, uint64_t value);
	public static native long TxOut_new(byte[] script_pubkey, long value);
	// struct LDKu8slice TxOut_get_script_pubkey(const struct LDKTxOut *NONNULL_PTR txout);
	public static native byte[] TxOut_get_script_pubkey(long txout);
	// uint64_t TxOut_get_value(const struct LDKTxOut *NONNULL_PTR txout);
	public static native long TxOut_get_value(long txout);
	// void TxOut_free(struct LDKTxOut _res);
	public static native void TxOut_free(long _res);
	// uint64_t TxOut_clone_ptr(LDKTxOut *NONNULL_PTR arg);
	public static native long TxOut_clone_ptr(long arg);
	// struct LDKTxOut TxOut_clone(const struct LDKTxOut *NONNULL_PTR orig);
	public static native long TxOut_clone(long orig);
	// void Str_free(struct LDKStr _res);
	public static native void Str_free(String _res);
	// void CVec_u8Z_free(struct LDKCVec_u8Z _res);
	public static native void CVec_u8Z_free(byte[] _res);
	// struct LDKCResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_ok(struct LDKRefundMaybeWithDerivedMetadataBuilder o);
	public static native long CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_ok(long o);
	// struct LDKCResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_err(enum LDKBolt12SemanticError e);
	public static native long CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_err(Bolt12SemanticError e);
	// bool CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_is_ok(const struct LDKCResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_is_ok(long o);
	// void CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_free(struct LDKCResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ _res);
	public static native void CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_free(long _res);
	// uint64_t CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_clone_ptr(LDKCResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ *NONNULL_PTR arg);
	public static native long CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_clone(const struct LDKCResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ *NONNULL_PTR orig);
	public static native long CResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ_clone(long orig);
	// struct LDKCResult_RefundBolt12SemanticErrorZ CResult_RefundBolt12SemanticErrorZ_ok(struct LDKRefund o);
	public static native long CResult_RefundBolt12SemanticErrorZ_ok(long o);
	// struct LDKCResult_RefundBolt12SemanticErrorZ CResult_RefundBolt12SemanticErrorZ_err(enum LDKBolt12SemanticError e);
	public static native long CResult_RefundBolt12SemanticErrorZ_err(Bolt12SemanticError e);
	// bool CResult_RefundBolt12SemanticErrorZ_is_ok(const struct LDKCResult_RefundBolt12SemanticErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RefundBolt12SemanticErrorZ_is_ok(long o);
	// void CResult_RefundBolt12SemanticErrorZ_free(struct LDKCResult_RefundBolt12SemanticErrorZ _res);
	public static native void CResult_RefundBolt12SemanticErrorZ_free(long _res);
	// uint64_t CResult_RefundBolt12SemanticErrorZ_clone_ptr(LDKCResult_RefundBolt12SemanticErrorZ *NONNULL_PTR arg);
	public static native long CResult_RefundBolt12SemanticErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RefundBolt12SemanticErrorZ CResult_RefundBolt12SemanticErrorZ_clone(const struct LDKCResult_RefundBolt12SemanticErrorZ *NONNULL_PTR orig);
	public static native long CResult_RefundBolt12SemanticErrorZ_clone(long orig);
	// struct LDKCOption_u64Z COption_u64Z_some(uint64_t o);
	public static native long COption_u64Z_some(long o);
	// struct LDKCOption_u64Z COption_u64Z_none(void);
	public static native long COption_u64Z_none();
	// void COption_u64Z_free(struct LDKCOption_u64Z _res);
	public static native void COption_u64Z_free(long _res);
	// uint64_t COption_u64Z_clone_ptr(LDKCOption_u64Z *NONNULL_PTR arg);
	public static native long COption_u64Z_clone_ptr(long arg);
	// struct LDKCOption_u64Z COption_u64Z_clone(const struct LDKCOption_u64Z *NONNULL_PTR orig);
	public static native long COption_u64Z_clone(long orig);
	// void CVec_BlindedMessagePathZ_free(struct LDKCVec_BlindedMessagePathZ _res);
	public static native void CVec_BlindedMessagePathZ_free(long[] _res);
	// struct LDKCResult_RefundDecodeErrorZ CResult_RefundDecodeErrorZ_ok(struct LDKRefund o);
	public static native long CResult_RefundDecodeErrorZ_ok(long o);
	// struct LDKCResult_RefundDecodeErrorZ CResult_RefundDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_RefundDecodeErrorZ_err(long e);
	// bool CResult_RefundDecodeErrorZ_is_ok(const struct LDKCResult_RefundDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RefundDecodeErrorZ_is_ok(long o);
	// void CResult_RefundDecodeErrorZ_free(struct LDKCResult_RefundDecodeErrorZ _res);
	public static native void CResult_RefundDecodeErrorZ_free(long _res);
	// uint64_t CResult_RefundDecodeErrorZ_clone_ptr(LDKCResult_RefundDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_RefundDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RefundDecodeErrorZ CResult_RefundDecodeErrorZ_clone(const struct LDKCResult_RefundDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_RefundDecodeErrorZ_clone(long orig);
	// struct LDKCResult_RefundBolt12ParseErrorZ CResult_RefundBolt12ParseErrorZ_ok(struct LDKRefund o);
	public static native long CResult_RefundBolt12ParseErrorZ_ok(long o);
	// struct LDKCResult_RefundBolt12ParseErrorZ CResult_RefundBolt12ParseErrorZ_err(struct LDKBolt12ParseError e);
	public static native long CResult_RefundBolt12ParseErrorZ_err(long e);
	// bool CResult_RefundBolt12ParseErrorZ_is_ok(const struct LDKCResult_RefundBolt12ParseErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RefundBolt12ParseErrorZ_is_ok(long o);
	// void CResult_RefundBolt12ParseErrorZ_free(struct LDKCResult_RefundBolt12ParseErrorZ _res);
	public static native void CResult_RefundBolt12ParseErrorZ_free(long _res);
	// uint64_t CResult_RefundBolt12ParseErrorZ_clone_ptr(LDKCResult_RefundBolt12ParseErrorZ *NONNULL_PTR arg);
	public static native long CResult_RefundBolt12ParseErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RefundBolt12ParseErrorZ CResult_RefundBolt12ParseErrorZ_clone(const struct LDKCResult_RefundBolt12ParseErrorZ *NONNULL_PTR orig);
	public static native long CResult_RefundBolt12ParseErrorZ_clone(long orig);
	// struct LDKCResult_RetryDecodeErrorZ CResult_RetryDecodeErrorZ_ok(struct LDKRetry o);
	public static native long CResult_RetryDecodeErrorZ_ok(long o);
	// struct LDKCResult_RetryDecodeErrorZ CResult_RetryDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_RetryDecodeErrorZ_err(long e);
	// bool CResult_RetryDecodeErrorZ_is_ok(const struct LDKCResult_RetryDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RetryDecodeErrorZ_is_ok(long o);
	// void CResult_RetryDecodeErrorZ_free(struct LDKCResult_RetryDecodeErrorZ _res);
	public static native void CResult_RetryDecodeErrorZ_free(long _res);
	// uint64_t CResult_RetryDecodeErrorZ_clone_ptr(LDKCResult_RetryDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_RetryDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RetryDecodeErrorZ CResult_RetryDecodeErrorZ_clone(const struct LDKCResult_RetryDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_RetryDecodeErrorZ_clone(long orig);
	// struct LDKCOption_ThirtyTwoBytesZ COption_ThirtyTwoBytesZ_some(struct LDKThirtyTwoBytes o);
	public static native long COption_ThirtyTwoBytesZ_some(byte[] o);
	// struct LDKCOption_ThirtyTwoBytesZ COption_ThirtyTwoBytesZ_none(void);
	public static native long COption_ThirtyTwoBytesZ_none();
	// void COption_ThirtyTwoBytesZ_free(struct LDKCOption_ThirtyTwoBytesZ _res);
	public static native void COption_ThirtyTwoBytesZ_free(long _res);
	// uint64_t COption_ThirtyTwoBytesZ_clone_ptr(LDKCOption_ThirtyTwoBytesZ *NONNULL_PTR arg);
	public static native long COption_ThirtyTwoBytesZ_clone_ptr(long arg);
	// struct LDKCOption_ThirtyTwoBytesZ COption_ThirtyTwoBytesZ_clone(const struct LDKCOption_ThirtyTwoBytesZ *NONNULL_PTR orig);
	public static native long COption_ThirtyTwoBytesZ_clone(long orig);
	// struct LDKCOption_CVec_u8ZZ COption_CVec_u8ZZ_some(struct LDKCVec_u8Z o);
	public static native long COption_CVec_u8ZZ_some(byte[] o);
	// struct LDKCOption_CVec_u8ZZ COption_CVec_u8ZZ_none(void);
	public static native long COption_CVec_u8ZZ_none();
	// void COption_CVec_u8ZZ_free(struct LDKCOption_CVec_u8ZZ _res);
	public static native void COption_CVec_u8ZZ_free(long _res);
	// uint64_t COption_CVec_u8ZZ_clone_ptr(LDKCOption_CVec_u8ZZ *NONNULL_PTR arg);
	public static native long COption_CVec_u8ZZ_clone_ptr(long arg);
	// struct LDKCOption_CVec_u8ZZ COption_CVec_u8ZZ_clone(const struct LDKCOption_CVec_u8ZZ *NONNULL_PTR orig);
	public static native long COption_CVec_u8ZZ_clone(long orig);
	// struct LDKCResult_RecipientOnionFieldsDecodeErrorZ CResult_RecipientOnionFieldsDecodeErrorZ_ok(struct LDKRecipientOnionFields o);
	public static native long CResult_RecipientOnionFieldsDecodeErrorZ_ok(long o);
	// struct LDKCResult_RecipientOnionFieldsDecodeErrorZ CResult_RecipientOnionFieldsDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_RecipientOnionFieldsDecodeErrorZ_err(long e);
	// bool CResult_RecipientOnionFieldsDecodeErrorZ_is_ok(const struct LDKCResult_RecipientOnionFieldsDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RecipientOnionFieldsDecodeErrorZ_is_ok(long o);
	// void CResult_RecipientOnionFieldsDecodeErrorZ_free(struct LDKCResult_RecipientOnionFieldsDecodeErrorZ _res);
	public static native void CResult_RecipientOnionFieldsDecodeErrorZ_free(long _res);
	// uint64_t CResult_RecipientOnionFieldsDecodeErrorZ_clone_ptr(LDKCResult_RecipientOnionFieldsDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_RecipientOnionFieldsDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RecipientOnionFieldsDecodeErrorZ CResult_RecipientOnionFieldsDecodeErrorZ_clone(const struct LDKCResult_RecipientOnionFieldsDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_RecipientOnionFieldsDecodeErrorZ_clone(long orig);
	// uint64_t C2Tuple_u64CVec_u8ZZ_clone_ptr(LDKC2Tuple_u64CVec_u8ZZ *NONNULL_PTR arg);
	public static native long C2Tuple_u64CVec_u8ZZ_clone_ptr(long arg);
	// struct LDKC2Tuple_u64CVec_u8ZZ C2Tuple_u64CVec_u8ZZ_clone(const struct LDKC2Tuple_u64CVec_u8ZZ *NONNULL_PTR orig);
	public static native long C2Tuple_u64CVec_u8ZZ_clone(long orig);
	// struct LDKC2Tuple_u64CVec_u8ZZ C2Tuple_u64CVec_u8ZZ_new(uint64_t a, struct LDKCVec_u8Z b);
	public static native long C2Tuple_u64CVec_u8ZZ_new(long a, byte[] b);
	// void C2Tuple_u64CVec_u8ZZ_free(struct LDKC2Tuple_u64CVec_u8ZZ _res);
	public static native void C2Tuple_u64CVec_u8ZZ_free(long _res);
	// void CVec_C2Tuple_u64CVec_u8ZZZ_free(struct LDKCVec_C2Tuple_u64CVec_u8ZZZ _res);
	public static native void CVec_C2Tuple_u64CVec_u8ZZZ_free(long[] _res);
	// struct LDKCResult_RecipientOnionFieldsNoneZ CResult_RecipientOnionFieldsNoneZ_ok(struct LDKRecipientOnionFields o);
	public static native long CResult_RecipientOnionFieldsNoneZ_ok(long o);
	// struct LDKCResult_RecipientOnionFieldsNoneZ CResult_RecipientOnionFieldsNoneZ_err(void);
	public static native long CResult_RecipientOnionFieldsNoneZ_err();
	// bool CResult_RecipientOnionFieldsNoneZ_is_ok(const struct LDKCResult_RecipientOnionFieldsNoneZ *NONNULL_PTR o);
	public static native boolean CResult_RecipientOnionFieldsNoneZ_is_ok(long o);
	// void CResult_RecipientOnionFieldsNoneZ_free(struct LDKCResult_RecipientOnionFieldsNoneZ _res);
	public static native void CResult_RecipientOnionFieldsNoneZ_free(long _res);
	// uint64_t CResult_RecipientOnionFieldsNoneZ_clone_ptr(LDKCResult_RecipientOnionFieldsNoneZ *NONNULL_PTR arg);
	public static native long CResult_RecipientOnionFieldsNoneZ_clone_ptr(long arg);
	// struct LDKCResult_RecipientOnionFieldsNoneZ CResult_RecipientOnionFieldsNoneZ_clone(const struct LDKCResult_RecipientOnionFieldsNoneZ *NONNULL_PTR orig);
	public static native long CResult_RecipientOnionFieldsNoneZ_clone(long orig);
	// uint64_t C2Tuple_DNSResolverMessageResponseInstructionZ_clone_ptr(LDKC2Tuple_DNSResolverMessageResponseInstructionZ *NONNULL_PTR arg);
	public static native long C2Tuple_DNSResolverMessageResponseInstructionZ_clone_ptr(long arg);
	// struct LDKC2Tuple_DNSResolverMessageResponseInstructionZ C2Tuple_DNSResolverMessageResponseInstructionZ_clone(const struct LDKC2Tuple_DNSResolverMessageResponseInstructionZ *NONNULL_PTR orig);
	public static native long C2Tuple_DNSResolverMessageResponseInstructionZ_clone(long orig);
	// struct LDKC2Tuple_DNSResolverMessageResponseInstructionZ C2Tuple_DNSResolverMessageResponseInstructionZ_new(struct LDKDNSResolverMessage a, struct LDKResponseInstruction b);
	public static native long C2Tuple_DNSResolverMessageResponseInstructionZ_new(long a, long b);
	// void C2Tuple_DNSResolverMessageResponseInstructionZ_free(struct LDKC2Tuple_DNSResolverMessageResponseInstructionZ _res);
	public static native void C2Tuple_DNSResolverMessageResponseInstructionZ_free(long _res);
	// struct LDKCOption_C2Tuple_DNSResolverMessageResponseInstructionZZ COption_C2Tuple_DNSResolverMessageResponseInstructionZZ_some(struct LDKC2Tuple_DNSResolverMessageResponseInstructionZ o);
	public static native long COption_C2Tuple_DNSResolverMessageResponseInstructionZZ_some(long o);
	// struct LDKCOption_C2Tuple_DNSResolverMessageResponseInstructionZZ COption_C2Tuple_DNSResolverMessageResponseInstructionZZ_none(void);
	public static native long COption_C2Tuple_DNSResolverMessageResponseInstructionZZ_none();
	// void COption_C2Tuple_DNSResolverMessageResponseInstructionZZ_free(struct LDKCOption_C2Tuple_DNSResolverMessageResponseInstructionZZ _res);
	public static native void COption_C2Tuple_DNSResolverMessageResponseInstructionZZ_free(long _res);
	// uint64_t COption_C2Tuple_DNSResolverMessageResponseInstructionZZ_clone_ptr(LDKCOption_C2Tuple_DNSResolverMessageResponseInstructionZZ *NONNULL_PTR arg);
	public static native long COption_C2Tuple_DNSResolverMessageResponseInstructionZZ_clone_ptr(long arg);
	// struct LDKCOption_C2Tuple_DNSResolverMessageResponseInstructionZZ COption_C2Tuple_DNSResolverMessageResponseInstructionZZ_clone(const struct LDKCOption_C2Tuple_DNSResolverMessageResponseInstructionZZ *NONNULL_PTR orig);
	public static native long COption_C2Tuple_DNSResolverMessageResponseInstructionZZ_clone(long orig);
	// uint64_t C2Tuple_DNSResolverMessageMessageSendInstructionsZ_clone_ptr(LDKC2Tuple_DNSResolverMessageMessageSendInstructionsZ *NONNULL_PTR arg);
	public static native long C2Tuple_DNSResolverMessageMessageSendInstructionsZ_clone_ptr(long arg);
	// struct LDKC2Tuple_DNSResolverMessageMessageSendInstructionsZ C2Tuple_DNSResolverMessageMessageSendInstructionsZ_clone(const struct LDKC2Tuple_DNSResolverMessageMessageSendInstructionsZ *NONNULL_PTR orig);
	public static native long C2Tuple_DNSResolverMessageMessageSendInstructionsZ_clone(long orig);
	// struct LDKC2Tuple_DNSResolverMessageMessageSendInstructionsZ C2Tuple_DNSResolverMessageMessageSendInstructionsZ_new(struct LDKDNSResolverMessage a, struct LDKMessageSendInstructions b);
	public static native long C2Tuple_DNSResolverMessageMessageSendInstructionsZ_new(long a, long b);
	// void C2Tuple_DNSResolverMessageMessageSendInstructionsZ_free(struct LDKC2Tuple_DNSResolverMessageMessageSendInstructionsZ _res);
	public static native void C2Tuple_DNSResolverMessageMessageSendInstructionsZ_free(long _res);
	// void CVec_C2Tuple_DNSResolverMessageMessageSendInstructionsZZ_free(struct LDKCVec_C2Tuple_DNSResolverMessageMessageSendInstructionsZZ _res);
	public static native void CVec_C2Tuple_DNSResolverMessageMessageSendInstructionsZZ_free(long[] _res);
	// struct LDKCResult_DNSResolverMessageDecodeErrorZ CResult_DNSResolverMessageDecodeErrorZ_ok(struct LDKDNSResolverMessage o);
	public static native long CResult_DNSResolverMessageDecodeErrorZ_ok(long o);
	// struct LDKCResult_DNSResolverMessageDecodeErrorZ CResult_DNSResolverMessageDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_DNSResolverMessageDecodeErrorZ_err(long e);
	// bool CResult_DNSResolverMessageDecodeErrorZ_is_ok(const struct LDKCResult_DNSResolverMessageDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_DNSResolverMessageDecodeErrorZ_is_ok(long o);
	// void CResult_DNSResolverMessageDecodeErrorZ_free(struct LDKCResult_DNSResolverMessageDecodeErrorZ _res);
	public static native void CResult_DNSResolverMessageDecodeErrorZ_free(long _res);
	// uint64_t CResult_DNSResolverMessageDecodeErrorZ_clone_ptr(LDKCResult_DNSResolverMessageDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_DNSResolverMessageDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_DNSResolverMessageDecodeErrorZ CResult_DNSResolverMessageDecodeErrorZ_clone(const struct LDKCResult_DNSResolverMessageDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_DNSResolverMessageDecodeErrorZ_clone(long orig);
	// struct LDKCResult_HumanReadableNameNoneZ CResult_HumanReadableNameNoneZ_ok(struct LDKHumanReadableName o);
	public static native long CResult_HumanReadableNameNoneZ_ok(long o);
	// struct LDKCResult_HumanReadableNameNoneZ CResult_HumanReadableNameNoneZ_err(void);
	public static native long CResult_HumanReadableNameNoneZ_err();
	// bool CResult_HumanReadableNameNoneZ_is_ok(const struct LDKCResult_HumanReadableNameNoneZ *NONNULL_PTR o);
	public static native boolean CResult_HumanReadableNameNoneZ_is_ok(long o);
	// void CResult_HumanReadableNameNoneZ_free(struct LDKCResult_HumanReadableNameNoneZ _res);
	public static native void CResult_HumanReadableNameNoneZ_free(long _res);
	// uint64_t CResult_HumanReadableNameNoneZ_clone_ptr(LDKCResult_HumanReadableNameNoneZ *NONNULL_PTR arg);
	public static native long CResult_HumanReadableNameNoneZ_clone_ptr(long arg);
	// struct LDKCResult_HumanReadableNameNoneZ CResult_HumanReadableNameNoneZ_clone(const struct LDKCResult_HumanReadableNameNoneZ *NONNULL_PTR orig);
	public static native long CResult_HumanReadableNameNoneZ_clone(long orig);
	// struct LDKCResult_HumanReadableNameDecodeErrorZ CResult_HumanReadableNameDecodeErrorZ_ok(struct LDKHumanReadableName o);
	public static native long CResult_HumanReadableNameDecodeErrorZ_ok(long o);
	// struct LDKCResult_HumanReadableNameDecodeErrorZ CResult_HumanReadableNameDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_HumanReadableNameDecodeErrorZ_err(long e);
	// bool CResult_HumanReadableNameDecodeErrorZ_is_ok(const struct LDKCResult_HumanReadableNameDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_HumanReadableNameDecodeErrorZ_is_ok(long o);
	// void CResult_HumanReadableNameDecodeErrorZ_free(struct LDKCResult_HumanReadableNameDecodeErrorZ _res);
	public static native void CResult_HumanReadableNameDecodeErrorZ_free(long _res);
	// uint64_t CResult_HumanReadableNameDecodeErrorZ_clone_ptr(LDKCResult_HumanReadableNameDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_HumanReadableNameDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_HumanReadableNameDecodeErrorZ CResult_HumanReadableNameDecodeErrorZ_clone(const struct LDKCResult_HumanReadableNameDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_HumanReadableNameDecodeErrorZ_clone(long orig);
	// uint64_t C2Tuple_DNSSECQueryDNSResolverContextZ_clone_ptr(LDKC2Tuple_DNSSECQueryDNSResolverContextZ *NONNULL_PTR arg);
	public static native long C2Tuple_DNSSECQueryDNSResolverContextZ_clone_ptr(long arg);
	// struct LDKC2Tuple_DNSSECQueryDNSResolverContextZ C2Tuple_DNSSECQueryDNSResolverContextZ_clone(const struct LDKC2Tuple_DNSSECQueryDNSResolverContextZ *NONNULL_PTR orig);
	public static native long C2Tuple_DNSSECQueryDNSResolverContextZ_clone(long orig);
	// struct LDKC2Tuple_DNSSECQueryDNSResolverContextZ C2Tuple_DNSSECQueryDNSResolverContextZ_new(struct LDKDNSSECQuery a, struct LDKDNSResolverContext b);
	public static native long C2Tuple_DNSSECQueryDNSResolverContextZ_new(long a, long b);
	// void C2Tuple_DNSSECQueryDNSResolverContextZ_free(struct LDKC2Tuple_DNSSECQueryDNSResolverContextZ _res);
	public static native void C2Tuple_DNSSECQueryDNSResolverContextZ_free(long _res);
	// struct LDKCResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_ok(struct LDKC2Tuple_DNSSECQueryDNSResolverContextZ o);
	public static native long CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_ok(long o);
	// struct LDKCResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_err(void);
	public static native long CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_err();
	// bool CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_is_ok(const struct LDKCResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ *NONNULL_PTR o);
	public static native boolean CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_is_ok(long o);
	// void CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_free(struct LDKCResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ _res);
	public static native void CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_free(long _res);
	// uint64_t CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_clone_ptr(LDKCResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ *NONNULL_PTR arg);
	public static native long CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_clone_ptr(long arg);
	// struct LDKCResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_clone(const struct LDKCResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ *NONNULL_PTR orig);
	public static native long CResult_C2Tuple_DNSSECQueryDNSResolverContextZNoneZ_clone(long orig);
	// uint64_t C2Tuple_HumanReadableNameThirtyTwoBytesZ_clone_ptr(LDKC2Tuple_HumanReadableNameThirtyTwoBytesZ *NONNULL_PTR arg);
	public static native long C2Tuple_HumanReadableNameThirtyTwoBytesZ_clone_ptr(long arg);
	// struct LDKC2Tuple_HumanReadableNameThirtyTwoBytesZ C2Tuple_HumanReadableNameThirtyTwoBytesZ_clone(const struct LDKC2Tuple_HumanReadableNameThirtyTwoBytesZ *NONNULL_PTR orig);
	public static native long C2Tuple_HumanReadableNameThirtyTwoBytesZ_clone(long orig);
	// struct LDKC2Tuple_HumanReadableNameThirtyTwoBytesZ C2Tuple_HumanReadableNameThirtyTwoBytesZ_new(struct LDKHumanReadableName a, struct LDKThirtyTwoBytes b);
	public static native long C2Tuple_HumanReadableNameThirtyTwoBytesZ_new(long a, byte[] b);
	// void C2Tuple_HumanReadableNameThirtyTwoBytesZ_free(struct LDKC2Tuple_HumanReadableNameThirtyTwoBytesZ _res);
	public static native void C2Tuple_HumanReadableNameThirtyTwoBytesZ_free(long _res);
	// void CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZ_free(struct LDKCVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZ _res);
	public static native void CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZ_free(long[] _res);
	// uint64_t C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ_clone_ptr(LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ *NONNULL_PTR arg);
	public static native long C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ_clone_ptr(long arg);
	// struct LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ_clone(const struct LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ *NONNULL_PTR orig);
	public static native long C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ_clone(long orig);
	// struct LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ_new(struct LDKCVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZ a, struct LDKOffer b);
	public static native long C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ_new(long[] a, long b);
	// void C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ_free(struct LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ _res);
	public static native void C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ_free(long _res);
	// struct LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ_some(struct LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZ o);
	public static native long COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ_some(long o);
	// struct LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ_none(void);
	public static native long COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ_none();
	// void COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ_free(struct LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ _res);
	public static native void COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ_free(long _res);
	// uint64_t COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ_clone_ptr(LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ *NONNULL_PTR arg);
	public static native long COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ_clone_ptr(long arg);
	// struct LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ_clone(const struct LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ *NONNULL_PTR orig);
	public static native long COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZOfferZZ_clone(long orig);
	// uint64_t C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ_clone_ptr(LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ *NONNULL_PTR arg);
	public static native long C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ_clone_ptr(long arg);
	// struct LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ_clone(const struct LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ *NONNULL_PTR orig);
	public static native long C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ_clone(long orig);
	// struct LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ_new(struct LDKCVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZ a, struct LDKStr b);
	public static native long C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ_new(long[] a, String b);
	// void C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ_free(struct LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ _res);
	public static native void C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ_free(long _res);
	// struct LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ_some(struct LDKC2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZ o);
	public static native long COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ_some(long o);
	// struct LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ_none(void);
	public static native long COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ_none();
	// void COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ_free(struct LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ _res);
	public static native void COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ_free(long _res);
	// uint64_t COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ_clone_ptr(LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ *NONNULL_PTR arg);
	public static native long COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ_clone_ptr(long arg);
	// struct LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ_clone(const struct LDKCOption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ *NONNULL_PTR orig);
	public static native long COption_C2Tuple_CVec_C2Tuple_HumanReadableNameThirtyTwoBytesZZStrZZ_clone(long orig);
	// struct LDKCResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_ok(struct LDKUnsignedBolt12Invoice o);
	public static native long CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_ok(long o);
	// struct LDKCResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_err(enum LDKBolt12SemanticError e);
	public static native long CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_err(Bolt12SemanticError e);
	// bool CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_is_ok(const struct LDKCResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ *NONNULL_PTR o);
	public static native boolean CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_is_ok(long o);
	// void CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_free(struct LDKCResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ _res);
	public static native void CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_free(long _res);
	// uint64_t CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_clone_ptr(LDKCResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ *NONNULL_PTR arg);
	public static native long CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_clone_ptr(long arg);
	// struct LDKCResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_clone(const struct LDKCResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ *NONNULL_PTR orig);
	public static native long CResult_UnsignedBolt12InvoiceBolt12SemanticErrorZ_clone(long orig);
	// struct LDKCResult_Bolt12InvoiceBolt12SemanticErrorZ CResult_Bolt12InvoiceBolt12SemanticErrorZ_ok(struct LDKBolt12Invoice o);
	public static native long CResult_Bolt12InvoiceBolt12SemanticErrorZ_ok(long o);
	// struct LDKCResult_Bolt12InvoiceBolt12SemanticErrorZ CResult_Bolt12InvoiceBolt12SemanticErrorZ_err(enum LDKBolt12SemanticError e);
	public static native long CResult_Bolt12InvoiceBolt12SemanticErrorZ_err(Bolt12SemanticError e);
	// bool CResult_Bolt12InvoiceBolt12SemanticErrorZ_is_ok(const struct LDKCResult_Bolt12InvoiceBolt12SemanticErrorZ *NONNULL_PTR o);
	public static native boolean CResult_Bolt12InvoiceBolt12SemanticErrorZ_is_ok(long o);
	// void CResult_Bolt12InvoiceBolt12SemanticErrorZ_free(struct LDKCResult_Bolt12InvoiceBolt12SemanticErrorZ _res);
	public static native void CResult_Bolt12InvoiceBolt12SemanticErrorZ_free(long _res);
	// uint64_t CResult_Bolt12InvoiceBolt12SemanticErrorZ_clone_ptr(LDKCResult_Bolt12InvoiceBolt12SemanticErrorZ *NONNULL_PTR arg);
	public static native long CResult_Bolt12InvoiceBolt12SemanticErrorZ_clone_ptr(long arg);
	// struct LDKCResult_Bolt12InvoiceBolt12SemanticErrorZ CResult_Bolt12InvoiceBolt12SemanticErrorZ_clone(const struct LDKCResult_Bolt12InvoiceBolt12SemanticErrorZ *NONNULL_PTR orig);
	public static native long CResult_Bolt12InvoiceBolt12SemanticErrorZ_clone(long orig);
	// struct LDKCResult_SchnorrSignatureNoneZ CResult_SchnorrSignatureNoneZ_ok(struct LDKSchnorrSignature o);
	public static native long CResult_SchnorrSignatureNoneZ_ok(byte[] o);
	// struct LDKCResult_SchnorrSignatureNoneZ CResult_SchnorrSignatureNoneZ_err(void);
	public static native long CResult_SchnorrSignatureNoneZ_err();
	// bool CResult_SchnorrSignatureNoneZ_is_ok(const struct LDKCResult_SchnorrSignatureNoneZ *NONNULL_PTR o);
	public static native boolean CResult_SchnorrSignatureNoneZ_is_ok(long o);
	// void CResult_SchnorrSignatureNoneZ_free(struct LDKCResult_SchnorrSignatureNoneZ _res);
	public static native void CResult_SchnorrSignatureNoneZ_free(long _res);
	// uint64_t CResult_SchnorrSignatureNoneZ_clone_ptr(LDKCResult_SchnorrSignatureNoneZ *NONNULL_PTR arg);
	public static native long CResult_SchnorrSignatureNoneZ_clone_ptr(long arg);
	// struct LDKCResult_SchnorrSignatureNoneZ CResult_SchnorrSignatureNoneZ_clone(const struct LDKCResult_SchnorrSignatureNoneZ *NONNULL_PTR orig);
	public static native long CResult_SchnorrSignatureNoneZ_clone(long orig);
	// void CVec_BlindedPaymentPathZ_free(struct LDKCVec_BlindedPaymentPathZ _res);
	public static native void CVec_BlindedPaymentPathZ_free(long[] _res);
	// void CVec_AddressZ_free(struct LDKCVec_AddressZ _res);
	public static native void CVec_AddressZ_free(long[] _res);
	// void CVec_ThirtyTwoBytesZ_free(struct LDKCVec_ThirtyTwoBytesZ _res);
	public static native void CVec_ThirtyTwoBytesZ_free(byte[][] _res);
	// struct LDKCOption_CVec_ThirtyTwoBytesZZ COption_CVec_ThirtyTwoBytesZZ_some(struct LDKCVec_ThirtyTwoBytesZ o);
	public static native long COption_CVec_ThirtyTwoBytesZZ_some(byte[][] o);
	// struct LDKCOption_CVec_ThirtyTwoBytesZZ COption_CVec_ThirtyTwoBytesZZ_none(void);
	public static native long COption_CVec_ThirtyTwoBytesZZ_none();
	// void COption_CVec_ThirtyTwoBytesZZ_free(struct LDKCOption_CVec_ThirtyTwoBytesZZ _res);
	public static native void COption_CVec_ThirtyTwoBytesZZ_free(long _res);
	// uint64_t COption_CVec_ThirtyTwoBytesZZ_clone_ptr(LDKCOption_CVec_ThirtyTwoBytesZZ *NONNULL_PTR arg);
	public static native long COption_CVec_ThirtyTwoBytesZZ_clone_ptr(long arg);
	// struct LDKCOption_CVec_ThirtyTwoBytesZZ COption_CVec_ThirtyTwoBytesZZ_clone(const struct LDKCOption_CVec_ThirtyTwoBytesZZ *NONNULL_PTR orig);
	public static native long COption_CVec_ThirtyTwoBytesZZ_clone(long orig);
	// struct LDKCOption_AmountZ COption_AmountZ_some(struct LDKAmount o);
	public static native long COption_AmountZ_some(long o);
	// struct LDKCOption_AmountZ COption_AmountZ_none(void);
	public static native long COption_AmountZ_none();
	// void COption_AmountZ_free(struct LDKCOption_AmountZ _res);
	public static native void COption_AmountZ_free(long _res);
	// uint64_t COption_AmountZ_clone_ptr(LDKCOption_AmountZ *NONNULL_PTR arg);
	public static native long COption_AmountZ_clone_ptr(long arg);
	// struct LDKCOption_AmountZ COption_AmountZ_clone(const struct LDKCOption_AmountZ *NONNULL_PTR orig);
	public static native long COption_AmountZ_clone(long orig);
	// struct LDKCOption_QuantityZ COption_QuantityZ_some(struct LDKQuantity o);
	public static native long COption_QuantityZ_some(long o);
	// struct LDKCOption_QuantityZ COption_QuantityZ_none(void);
	public static native long COption_QuantityZ_none();
	// void COption_QuantityZ_free(struct LDKCOption_QuantityZ _res);
	public static native void COption_QuantityZ_free(long _res);
	// uint64_t COption_QuantityZ_clone_ptr(LDKCOption_QuantityZ *NONNULL_PTR arg);
	public static native long COption_QuantityZ_clone_ptr(long arg);
	// struct LDKCOption_QuantityZ COption_QuantityZ_clone(const struct LDKCOption_QuantityZ *NONNULL_PTR orig);
	public static native long COption_QuantityZ_clone(long orig);
	// struct LDKCResult_ThirtyTwoBytesNoneZ CResult_ThirtyTwoBytesNoneZ_ok(struct LDKThirtyTwoBytes o);
	public static native long CResult_ThirtyTwoBytesNoneZ_ok(byte[] o);
	// struct LDKCResult_ThirtyTwoBytesNoneZ CResult_ThirtyTwoBytesNoneZ_err(void);
	public static native long CResult_ThirtyTwoBytesNoneZ_err();
	// bool CResult_ThirtyTwoBytesNoneZ_is_ok(const struct LDKCResult_ThirtyTwoBytesNoneZ *NONNULL_PTR o);
	public static native boolean CResult_ThirtyTwoBytesNoneZ_is_ok(long o);
	// void CResult_ThirtyTwoBytesNoneZ_free(struct LDKCResult_ThirtyTwoBytesNoneZ _res);
	public static native void CResult_ThirtyTwoBytesNoneZ_free(long _res);
	// uint64_t CResult_ThirtyTwoBytesNoneZ_clone_ptr(LDKCResult_ThirtyTwoBytesNoneZ *NONNULL_PTR arg);
	public static native long CResult_ThirtyTwoBytesNoneZ_clone_ptr(long arg);
	// struct LDKCResult_ThirtyTwoBytesNoneZ CResult_ThirtyTwoBytesNoneZ_clone(const struct LDKCResult_ThirtyTwoBytesNoneZ *NONNULL_PTR orig);
	public static native long CResult_ThirtyTwoBytesNoneZ_clone(long orig);
	// struct LDKCResult_Bolt12InvoiceDecodeErrorZ CResult_Bolt12InvoiceDecodeErrorZ_ok(struct LDKBolt12Invoice o);
	public static native long CResult_Bolt12InvoiceDecodeErrorZ_ok(long o);
	// struct LDKCResult_Bolt12InvoiceDecodeErrorZ CResult_Bolt12InvoiceDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_Bolt12InvoiceDecodeErrorZ_err(long e);
	// bool CResult_Bolt12InvoiceDecodeErrorZ_is_ok(const struct LDKCResult_Bolt12InvoiceDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_Bolt12InvoiceDecodeErrorZ_is_ok(long o);
	// void CResult_Bolt12InvoiceDecodeErrorZ_free(struct LDKCResult_Bolt12InvoiceDecodeErrorZ _res);
	public static native void CResult_Bolt12InvoiceDecodeErrorZ_free(long _res);
	// uint64_t CResult_Bolt12InvoiceDecodeErrorZ_clone_ptr(LDKCResult_Bolt12InvoiceDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_Bolt12InvoiceDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_Bolt12InvoiceDecodeErrorZ CResult_Bolt12InvoiceDecodeErrorZ_clone(const struct LDKCResult_Bolt12InvoiceDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_Bolt12InvoiceDecodeErrorZ_clone(long orig);
	// struct LDKCResult_DelayedPaymentOutputDescriptorDecodeErrorZ CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_ok(struct LDKDelayedPaymentOutputDescriptor o);
	public static native long CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_ok(long o);
	// struct LDKCResult_DelayedPaymentOutputDescriptorDecodeErrorZ CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_err(long e);
	// bool CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_is_ok(const struct LDKCResult_DelayedPaymentOutputDescriptorDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_is_ok(long o);
	// void CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_free(struct LDKCResult_DelayedPaymentOutputDescriptorDecodeErrorZ _res);
	public static native void CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_free(long _res);
	// uint64_t CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_clone_ptr(LDKCResult_DelayedPaymentOutputDescriptorDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_DelayedPaymentOutputDescriptorDecodeErrorZ CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_clone(const struct LDKCResult_DelayedPaymentOutputDescriptorDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_DelayedPaymentOutputDescriptorDecodeErrorZ_clone(long orig);
	// struct LDKCResult_StaticPaymentOutputDescriptorDecodeErrorZ CResult_StaticPaymentOutputDescriptorDecodeErrorZ_ok(struct LDKStaticPaymentOutputDescriptor o);
	public static native long CResult_StaticPaymentOutputDescriptorDecodeErrorZ_ok(long o);
	// struct LDKCResult_StaticPaymentOutputDescriptorDecodeErrorZ CResult_StaticPaymentOutputDescriptorDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_StaticPaymentOutputDescriptorDecodeErrorZ_err(long e);
	// bool CResult_StaticPaymentOutputDescriptorDecodeErrorZ_is_ok(const struct LDKCResult_StaticPaymentOutputDescriptorDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_StaticPaymentOutputDescriptorDecodeErrorZ_is_ok(long o);
	// void CResult_StaticPaymentOutputDescriptorDecodeErrorZ_free(struct LDKCResult_StaticPaymentOutputDescriptorDecodeErrorZ _res);
	public static native void CResult_StaticPaymentOutputDescriptorDecodeErrorZ_free(long _res);
	// uint64_t CResult_StaticPaymentOutputDescriptorDecodeErrorZ_clone_ptr(LDKCResult_StaticPaymentOutputDescriptorDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_StaticPaymentOutputDescriptorDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_StaticPaymentOutputDescriptorDecodeErrorZ CResult_StaticPaymentOutputDescriptorDecodeErrorZ_clone(const struct LDKCResult_StaticPaymentOutputDescriptorDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_StaticPaymentOutputDescriptorDecodeErrorZ_clone(long orig);
	// struct LDKCResult_SpendableOutputDescriptorDecodeErrorZ CResult_SpendableOutputDescriptorDecodeErrorZ_ok(struct LDKSpendableOutputDescriptor o);
	public static native long CResult_SpendableOutputDescriptorDecodeErrorZ_ok(long o);
	// struct LDKCResult_SpendableOutputDescriptorDecodeErrorZ CResult_SpendableOutputDescriptorDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_SpendableOutputDescriptorDecodeErrorZ_err(long e);
	// bool CResult_SpendableOutputDescriptorDecodeErrorZ_is_ok(const struct LDKCResult_SpendableOutputDescriptorDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_SpendableOutputDescriptorDecodeErrorZ_is_ok(long o);
	// void CResult_SpendableOutputDescriptorDecodeErrorZ_free(struct LDKCResult_SpendableOutputDescriptorDecodeErrorZ _res);
	public static native void CResult_SpendableOutputDescriptorDecodeErrorZ_free(long _res);
	// uint64_t CResult_SpendableOutputDescriptorDecodeErrorZ_clone_ptr(LDKCResult_SpendableOutputDescriptorDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_SpendableOutputDescriptorDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_SpendableOutputDescriptorDecodeErrorZ CResult_SpendableOutputDescriptorDecodeErrorZ_clone(const struct LDKCResult_SpendableOutputDescriptorDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_SpendableOutputDescriptorDecodeErrorZ_clone(long orig);
	// void CVec_SpendableOutputDescriptorZ_free(struct LDKCVec_SpendableOutputDescriptorZ _res);
	public static native void CVec_SpendableOutputDescriptorZ_free(long[] _res);
	// void CVec_TxOutZ_free(struct LDKCVec_TxOutZ _res);
	public static native void CVec_TxOutZ_free(long[] _res);
	// struct LDKCOption_u32Z COption_u32Z_some(uint32_t o);
	public static native long COption_u32Z_some(int o);
	// struct LDKCOption_u32Z COption_u32Z_none(void);
	public static native long COption_u32Z_none();
	// void COption_u32Z_free(struct LDKCOption_u32Z _res);
	public static native void COption_u32Z_free(long _res);
	// uint64_t COption_u32Z_clone_ptr(LDKCOption_u32Z *NONNULL_PTR arg);
	public static native long COption_u32Z_clone_ptr(long arg);
	// struct LDKCOption_u32Z COption_u32Z_clone(const struct LDKCOption_u32Z *NONNULL_PTR orig);
	public static native long COption_u32Z_clone(long orig);
	// uint64_t C2Tuple_CVec_u8Zu64Z_clone_ptr(LDKC2Tuple_CVec_u8Zu64Z *NONNULL_PTR arg);
	public static native long C2Tuple_CVec_u8Zu64Z_clone_ptr(long arg);
	// struct LDKC2Tuple_CVec_u8Zu64Z C2Tuple_CVec_u8Zu64Z_clone(const struct LDKC2Tuple_CVec_u8Zu64Z *NONNULL_PTR orig);
	public static native long C2Tuple_CVec_u8Zu64Z_clone(long orig);
	// struct LDKC2Tuple_CVec_u8Zu64Z C2Tuple_CVec_u8Zu64Z_new(struct LDKCVec_u8Z a, uint64_t b);
	public static native long C2Tuple_CVec_u8Zu64Z_new(byte[] a, long b);
	// void C2Tuple_CVec_u8Zu64Z_free(struct LDKC2Tuple_CVec_u8Zu64Z _res);
	public static native void C2Tuple_CVec_u8Zu64Z_free(long _res);
	// struct LDKCResult_C2Tuple_CVec_u8Zu64ZNoneZ CResult_C2Tuple_CVec_u8Zu64ZNoneZ_ok(struct LDKC2Tuple_CVec_u8Zu64Z o);
	public static native long CResult_C2Tuple_CVec_u8Zu64ZNoneZ_ok(long o);
	// struct LDKCResult_C2Tuple_CVec_u8Zu64ZNoneZ CResult_C2Tuple_CVec_u8Zu64ZNoneZ_err(void);
	public static native long CResult_C2Tuple_CVec_u8Zu64ZNoneZ_err();
	// bool CResult_C2Tuple_CVec_u8Zu64ZNoneZ_is_ok(const struct LDKCResult_C2Tuple_CVec_u8Zu64ZNoneZ *NONNULL_PTR o);
	public static native boolean CResult_C2Tuple_CVec_u8Zu64ZNoneZ_is_ok(long o);
	// void CResult_C2Tuple_CVec_u8Zu64ZNoneZ_free(struct LDKCResult_C2Tuple_CVec_u8Zu64ZNoneZ _res);
	public static native void CResult_C2Tuple_CVec_u8Zu64ZNoneZ_free(long _res);
	// uint64_t CResult_C2Tuple_CVec_u8Zu64ZNoneZ_clone_ptr(LDKCResult_C2Tuple_CVec_u8Zu64ZNoneZ *NONNULL_PTR arg);
	public static native long CResult_C2Tuple_CVec_u8Zu64ZNoneZ_clone_ptr(long arg);
	// struct LDKCResult_C2Tuple_CVec_u8Zu64ZNoneZ CResult_C2Tuple_CVec_u8Zu64ZNoneZ_clone(const struct LDKCResult_C2Tuple_CVec_u8Zu64ZNoneZ *NONNULL_PTR orig);
	public static native long CResult_C2Tuple_CVec_u8Zu64ZNoneZ_clone(long orig);
	// struct LDKCResult_ChannelDerivationParametersDecodeErrorZ CResult_ChannelDerivationParametersDecodeErrorZ_ok(struct LDKChannelDerivationParameters o);
	public static native long CResult_ChannelDerivationParametersDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelDerivationParametersDecodeErrorZ CResult_ChannelDerivationParametersDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelDerivationParametersDecodeErrorZ_err(long e);
	// bool CResult_ChannelDerivationParametersDecodeErrorZ_is_ok(const struct LDKCResult_ChannelDerivationParametersDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelDerivationParametersDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelDerivationParametersDecodeErrorZ_free(struct LDKCResult_ChannelDerivationParametersDecodeErrorZ _res);
	public static native void CResult_ChannelDerivationParametersDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelDerivationParametersDecodeErrorZ_clone_ptr(LDKCResult_ChannelDerivationParametersDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelDerivationParametersDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelDerivationParametersDecodeErrorZ CResult_ChannelDerivationParametersDecodeErrorZ_clone(const struct LDKCResult_ChannelDerivationParametersDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelDerivationParametersDecodeErrorZ_clone(long orig);
	// struct LDKCResult_HTLCDescriptorDecodeErrorZ CResult_HTLCDescriptorDecodeErrorZ_ok(struct LDKHTLCDescriptor o);
	public static native long CResult_HTLCDescriptorDecodeErrorZ_ok(long o);
	// struct LDKCResult_HTLCDescriptorDecodeErrorZ CResult_HTLCDescriptorDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_HTLCDescriptorDecodeErrorZ_err(long e);
	// bool CResult_HTLCDescriptorDecodeErrorZ_is_ok(const struct LDKCResult_HTLCDescriptorDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_HTLCDescriptorDecodeErrorZ_is_ok(long o);
	// void CResult_HTLCDescriptorDecodeErrorZ_free(struct LDKCResult_HTLCDescriptorDecodeErrorZ _res);
	public static native void CResult_HTLCDescriptorDecodeErrorZ_free(long _res);
	// uint64_t CResult_HTLCDescriptorDecodeErrorZ_clone_ptr(LDKCResult_HTLCDescriptorDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_HTLCDescriptorDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_HTLCDescriptorDecodeErrorZ CResult_HTLCDescriptorDecodeErrorZ_clone(const struct LDKCResult_HTLCDescriptorDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_HTLCDescriptorDecodeErrorZ_clone(long orig);
	// struct LDKCResult_PublicKeyNoneZ CResult_PublicKeyNoneZ_ok(struct LDKPublicKey o);
	public static native long CResult_PublicKeyNoneZ_ok(byte[] o);
	// struct LDKCResult_PublicKeyNoneZ CResult_PublicKeyNoneZ_err(void);
	public static native long CResult_PublicKeyNoneZ_err();
	// bool CResult_PublicKeyNoneZ_is_ok(const struct LDKCResult_PublicKeyNoneZ *NONNULL_PTR o);
	public static native boolean CResult_PublicKeyNoneZ_is_ok(long o);
	// void CResult_PublicKeyNoneZ_free(struct LDKCResult_PublicKeyNoneZ _res);
	public static native void CResult_PublicKeyNoneZ_free(long _res);
	// uint64_t CResult_PublicKeyNoneZ_clone_ptr(LDKCResult_PublicKeyNoneZ *NONNULL_PTR arg);
	public static native long CResult_PublicKeyNoneZ_clone_ptr(long arg);
	// struct LDKCResult_PublicKeyNoneZ CResult_PublicKeyNoneZ_clone(const struct LDKCResult_PublicKeyNoneZ *NONNULL_PTR orig);
	public static native long CResult_PublicKeyNoneZ_clone(long orig);
	// struct LDKCResult__u832NoneZ CResult__u832NoneZ_ok(struct LDKThirtyTwoBytes o);
	public static native long CResult__u832NoneZ_ok(byte[] o);
	// struct LDKCResult__u832NoneZ CResult__u832NoneZ_err(void);
	public static native long CResult__u832NoneZ_err();
	// bool CResult__u832NoneZ_is_ok(const struct LDKCResult__u832NoneZ *NONNULL_PTR o);
	public static native boolean CResult__u832NoneZ_is_ok(long o);
	// void CResult__u832NoneZ_free(struct LDKCResult__u832NoneZ _res);
	public static native void CResult__u832NoneZ_free(long _res);
	// uint64_t CResult__u832NoneZ_clone_ptr(LDKCResult__u832NoneZ *NONNULL_PTR arg);
	public static native long CResult__u832NoneZ_clone_ptr(long arg);
	// struct LDKCResult__u832NoneZ CResult__u832NoneZ_clone(const struct LDKCResult__u832NoneZ *NONNULL_PTR orig);
	public static native long CResult__u832NoneZ_clone(long orig);
	// struct LDKCResult_NoneNoneZ CResult_NoneNoneZ_ok(void);
	public static native long CResult_NoneNoneZ_ok();
	// struct LDKCResult_NoneNoneZ CResult_NoneNoneZ_err(void);
	public static native long CResult_NoneNoneZ_err();
	// bool CResult_NoneNoneZ_is_ok(const struct LDKCResult_NoneNoneZ *NONNULL_PTR o);
	public static native boolean CResult_NoneNoneZ_is_ok(long o);
	// void CResult_NoneNoneZ_free(struct LDKCResult_NoneNoneZ _res);
	public static native void CResult_NoneNoneZ_free(long _res);
	// uint64_t CResult_NoneNoneZ_clone_ptr(LDKCResult_NoneNoneZ *NONNULL_PTR arg);
	public static native long CResult_NoneNoneZ_clone_ptr(long arg);
	// struct LDKCResult_NoneNoneZ CResult_NoneNoneZ_clone(const struct LDKCResult_NoneNoneZ *NONNULL_PTR orig);
	public static native long CResult_NoneNoneZ_clone(long orig);
	// struct LDKCOption_BigEndianScalarZ COption_BigEndianScalarZ_some(struct LDKBigEndianScalar o);
	public static native long COption_BigEndianScalarZ_some(long o);
	// struct LDKCOption_BigEndianScalarZ COption_BigEndianScalarZ_none(void);
	public static native long COption_BigEndianScalarZ_none();
	// void COption_BigEndianScalarZ_free(struct LDKCOption_BigEndianScalarZ _res);
	public static native void COption_BigEndianScalarZ_free(long _res);
	// uint64_t COption_BigEndianScalarZ_clone_ptr(LDKCOption_BigEndianScalarZ *NONNULL_PTR arg);
	public static native long COption_BigEndianScalarZ_clone_ptr(long arg);
	// struct LDKCOption_BigEndianScalarZ COption_BigEndianScalarZ_clone(const struct LDKCOption_BigEndianScalarZ *NONNULL_PTR orig);
	public static native long COption_BigEndianScalarZ_clone(long orig);
	// struct LDKCResult_RecoverableSignatureNoneZ CResult_RecoverableSignatureNoneZ_ok(struct LDKRecoverableSignature o);
	public static native long CResult_RecoverableSignatureNoneZ_ok(byte[] o);
	// struct LDKCResult_RecoverableSignatureNoneZ CResult_RecoverableSignatureNoneZ_err(void);
	public static native long CResult_RecoverableSignatureNoneZ_err();
	// bool CResult_RecoverableSignatureNoneZ_is_ok(const struct LDKCResult_RecoverableSignatureNoneZ *NONNULL_PTR o);
	public static native boolean CResult_RecoverableSignatureNoneZ_is_ok(long o);
	// void CResult_RecoverableSignatureNoneZ_free(struct LDKCResult_RecoverableSignatureNoneZ _res);
	public static native void CResult_RecoverableSignatureNoneZ_free(long _res);
	// uint64_t CResult_RecoverableSignatureNoneZ_clone_ptr(LDKCResult_RecoverableSignatureNoneZ *NONNULL_PTR arg);
	public static native long CResult_RecoverableSignatureNoneZ_clone_ptr(long arg);
	// struct LDKCResult_RecoverableSignatureNoneZ CResult_RecoverableSignatureNoneZ_clone(const struct LDKCResult_RecoverableSignatureNoneZ *NONNULL_PTR orig);
	public static native long CResult_RecoverableSignatureNoneZ_clone(long orig);
	// struct LDKCResult_ECDSASignatureNoneZ CResult_ECDSASignatureNoneZ_ok(struct LDKECDSASignature o);
	public static native long CResult_ECDSASignatureNoneZ_ok(byte[] o);
	// struct LDKCResult_ECDSASignatureNoneZ CResult_ECDSASignatureNoneZ_err(void);
	public static native long CResult_ECDSASignatureNoneZ_err();
	// bool CResult_ECDSASignatureNoneZ_is_ok(const struct LDKCResult_ECDSASignatureNoneZ *NONNULL_PTR o);
	public static native boolean CResult_ECDSASignatureNoneZ_is_ok(long o);
	// void CResult_ECDSASignatureNoneZ_free(struct LDKCResult_ECDSASignatureNoneZ _res);
	public static native void CResult_ECDSASignatureNoneZ_free(long _res);
	// uint64_t CResult_ECDSASignatureNoneZ_clone_ptr(LDKCResult_ECDSASignatureNoneZ *NONNULL_PTR arg);
	public static native long CResult_ECDSASignatureNoneZ_clone_ptr(long arg);
	// struct LDKCResult_ECDSASignatureNoneZ CResult_ECDSASignatureNoneZ_clone(const struct LDKCResult_ECDSASignatureNoneZ *NONNULL_PTR orig);
	public static native long CResult_ECDSASignatureNoneZ_clone(long orig);
	// struct LDKCResult_TransactionNoneZ CResult_TransactionNoneZ_ok(struct LDKTransaction o);
	public static native long CResult_TransactionNoneZ_ok(byte[] o);
	// struct LDKCResult_TransactionNoneZ CResult_TransactionNoneZ_err(void);
	public static native long CResult_TransactionNoneZ_err();
	// bool CResult_TransactionNoneZ_is_ok(const struct LDKCResult_TransactionNoneZ *NONNULL_PTR o);
	public static native boolean CResult_TransactionNoneZ_is_ok(long o);
	// void CResult_TransactionNoneZ_free(struct LDKCResult_TransactionNoneZ _res);
	public static native void CResult_TransactionNoneZ_free(long _res);
	// uint64_t CResult_TransactionNoneZ_clone_ptr(LDKCResult_TransactionNoneZ *NONNULL_PTR arg);
	public static native long CResult_TransactionNoneZ_clone_ptr(long arg);
	// struct LDKCResult_TransactionNoneZ CResult_TransactionNoneZ_clone(const struct LDKCResult_TransactionNoneZ *NONNULL_PTR orig);
	public static native long CResult_TransactionNoneZ_clone(long orig);
	// struct LDKCResult_EcdsaChannelSignerDecodeErrorZ CResult_EcdsaChannelSignerDecodeErrorZ_ok(struct LDKEcdsaChannelSigner o);
	public static native long CResult_EcdsaChannelSignerDecodeErrorZ_ok(long o);
	// struct LDKCResult_EcdsaChannelSignerDecodeErrorZ CResult_EcdsaChannelSignerDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_EcdsaChannelSignerDecodeErrorZ_err(long e);
	// bool CResult_EcdsaChannelSignerDecodeErrorZ_is_ok(const struct LDKCResult_EcdsaChannelSignerDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_EcdsaChannelSignerDecodeErrorZ_is_ok(long o);
	// void CResult_EcdsaChannelSignerDecodeErrorZ_free(struct LDKCResult_EcdsaChannelSignerDecodeErrorZ _res);
	public static native void CResult_EcdsaChannelSignerDecodeErrorZ_free(long _res);
	// uint64_t CResult_EcdsaChannelSignerDecodeErrorZ_clone_ptr(LDKCResult_EcdsaChannelSignerDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_EcdsaChannelSignerDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_EcdsaChannelSignerDecodeErrorZ CResult_EcdsaChannelSignerDecodeErrorZ_clone(const struct LDKCResult_EcdsaChannelSignerDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_EcdsaChannelSignerDecodeErrorZ_clone(long orig);
	// struct LDKCResult_CVec_u8ZNoneZ CResult_CVec_u8ZNoneZ_ok(struct LDKCVec_u8Z o);
	public static native long CResult_CVec_u8ZNoneZ_ok(byte[] o);
	// struct LDKCResult_CVec_u8ZNoneZ CResult_CVec_u8ZNoneZ_err(void);
	public static native long CResult_CVec_u8ZNoneZ_err();
	// bool CResult_CVec_u8ZNoneZ_is_ok(const struct LDKCResult_CVec_u8ZNoneZ *NONNULL_PTR o);
	public static native boolean CResult_CVec_u8ZNoneZ_is_ok(long o);
	// void CResult_CVec_u8ZNoneZ_free(struct LDKCResult_CVec_u8ZNoneZ _res);
	public static native void CResult_CVec_u8ZNoneZ_free(long _res);
	// uint64_t CResult_CVec_u8ZNoneZ_clone_ptr(LDKCResult_CVec_u8ZNoneZ *NONNULL_PTR arg);
	public static native long CResult_CVec_u8ZNoneZ_clone_ptr(long arg);
	// struct LDKCResult_CVec_u8ZNoneZ CResult_CVec_u8ZNoneZ_clone(const struct LDKCResult_CVec_u8ZNoneZ *NONNULL_PTR orig);
	public static native long CResult_CVec_u8ZNoneZ_clone(long orig);
	// struct LDKCResult_ShutdownScriptNoneZ CResult_ShutdownScriptNoneZ_ok(struct LDKShutdownScript o);
	public static native long CResult_ShutdownScriptNoneZ_ok(long o);
	// struct LDKCResult_ShutdownScriptNoneZ CResult_ShutdownScriptNoneZ_err(void);
	public static native long CResult_ShutdownScriptNoneZ_err();
	// bool CResult_ShutdownScriptNoneZ_is_ok(const struct LDKCResult_ShutdownScriptNoneZ *NONNULL_PTR o);
	public static native boolean CResult_ShutdownScriptNoneZ_is_ok(long o);
	// void CResult_ShutdownScriptNoneZ_free(struct LDKCResult_ShutdownScriptNoneZ _res);
	public static native void CResult_ShutdownScriptNoneZ_free(long _res);
	// uint64_t CResult_ShutdownScriptNoneZ_clone_ptr(LDKCResult_ShutdownScriptNoneZ *NONNULL_PTR arg);
	public static native long CResult_ShutdownScriptNoneZ_clone_ptr(long arg);
	// struct LDKCResult_ShutdownScriptNoneZ CResult_ShutdownScriptNoneZ_clone(const struct LDKCResult_ShutdownScriptNoneZ *NONNULL_PTR orig);
	public static native long CResult_ShutdownScriptNoneZ_clone(long orig);
	// struct LDKCOption_u16Z COption_u16Z_some(uint16_t o);
	public static native long COption_u16Z_some(short o);
	// struct LDKCOption_u16Z COption_u16Z_none(void);
	public static native long COption_u16Z_none();
	// void COption_u16Z_free(struct LDKCOption_u16Z _res);
	public static native void COption_u16Z_free(long _res);
	// uint64_t COption_u16Z_clone_ptr(LDKCOption_u16Z *NONNULL_PTR arg);
	public static native long COption_u16Z_clone_ptr(long arg);
	// struct LDKCOption_u16Z COption_u16Z_clone(const struct LDKCOption_u16Z *NONNULL_PTR orig);
	public static native long COption_u16Z_clone(long orig);
	// struct LDKCOption_boolZ COption_boolZ_some(bool o);
	public static native long COption_boolZ_some(boolean o);
	// struct LDKCOption_boolZ COption_boolZ_none(void);
	public static native long COption_boolZ_none();
	// void COption_boolZ_free(struct LDKCOption_boolZ _res);
	public static native void COption_boolZ_free(long _res);
	// uint64_t COption_boolZ_clone_ptr(LDKCOption_boolZ *NONNULL_PTR arg);
	public static native long COption_boolZ_clone_ptr(long arg);
	// struct LDKCOption_boolZ COption_boolZ_clone(const struct LDKCOption_boolZ *NONNULL_PTR orig);
	public static native long COption_boolZ_clone(long orig);
	// struct LDKCResult_WitnessNoneZ CResult_WitnessNoneZ_ok(struct LDKWitness o);
	public static native long CResult_WitnessNoneZ_ok(byte[] o);
	// struct LDKCResult_WitnessNoneZ CResult_WitnessNoneZ_err(void);
	public static native long CResult_WitnessNoneZ_err();
	// bool CResult_WitnessNoneZ_is_ok(const struct LDKCResult_WitnessNoneZ *NONNULL_PTR o);
	public static native boolean CResult_WitnessNoneZ_is_ok(long o);
	// void CResult_WitnessNoneZ_free(struct LDKCResult_WitnessNoneZ _res);
	public static native void CResult_WitnessNoneZ_free(long _res);
	// uint64_t CResult_WitnessNoneZ_clone_ptr(LDKCResult_WitnessNoneZ *NONNULL_PTR arg);
	public static native long CResult_WitnessNoneZ_clone_ptr(long arg);
	// struct LDKCResult_WitnessNoneZ CResult_WitnessNoneZ_clone(const struct LDKCResult_WitnessNoneZ *NONNULL_PTR orig);
	public static native long CResult_WitnessNoneZ_clone(long orig);
	// void CVec_ECDSASignatureZ_free(struct LDKCVec_ECDSASignatureZ _res);
	public static native void CVec_ECDSASignatureZ_free(byte[][] _res);
	// uint64_t C2Tuple_ECDSASignatureCVec_ECDSASignatureZZ_clone_ptr(LDKC2Tuple_ECDSASignatureCVec_ECDSASignatureZZ *NONNULL_PTR arg);
	public static native long C2Tuple_ECDSASignatureCVec_ECDSASignatureZZ_clone_ptr(long arg);
	// struct LDKC2Tuple_ECDSASignatureCVec_ECDSASignatureZZ C2Tuple_ECDSASignatureCVec_ECDSASignatureZZ_clone(const struct LDKC2Tuple_ECDSASignatureCVec_ECDSASignatureZZ *NONNULL_PTR orig);
	public static native long C2Tuple_ECDSASignatureCVec_ECDSASignatureZZ_clone(long orig);
	// struct LDKC2Tuple_ECDSASignatureCVec_ECDSASignatureZZ C2Tuple_ECDSASignatureCVec_ECDSASignatureZZ_new(struct LDKECDSASignature a, struct LDKCVec_ECDSASignatureZ b);
	public static native long C2Tuple_ECDSASignatureCVec_ECDSASignatureZZ_new(byte[] a, byte[][] b);
	// void C2Tuple_ECDSASignatureCVec_ECDSASignatureZZ_free(struct LDKC2Tuple_ECDSASignatureCVec_ECDSASignatureZZ _res);
	public static native void C2Tuple_ECDSASignatureCVec_ECDSASignatureZZ_free(long _res);
	// struct LDKCResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_ok(struct LDKC2Tuple_ECDSASignatureCVec_ECDSASignatureZZ o);
	public static native long CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_ok(long o);
	// struct LDKCResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_err(void);
	public static native long CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_err();
	// bool CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_is_ok(const struct LDKCResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ *NONNULL_PTR o);
	public static native boolean CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_is_ok(long o);
	// void CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_free(struct LDKCResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ _res);
	public static native void CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_free(long _res);
	// uint64_t CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_clone_ptr(LDKCResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ *NONNULL_PTR arg);
	public static native long CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_clone_ptr(long arg);
	// struct LDKCResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_clone(const struct LDKCResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ *NONNULL_PTR orig);
	public static native long CResult_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ_clone(long orig);
	// struct LDKCResult_InMemorySignerDecodeErrorZ CResult_InMemorySignerDecodeErrorZ_ok(struct LDKInMemorySigner o);
	public static native long CResult_InMemorySignerDecodeErrorZ_ok(long o);
	// struct LDKCResult_InMemorySignerDecodeErrorZ CResult_InMemorySignerDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_InMemorySignerDecodeErrorZ_err(long e);
	// bool CResult_InMemorySignerDecodeErrorZ_is_ok(const struct LDKCResult_InMemorySignerDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_InMemorySignerDecodeErrorZ_is_ok(long o);
	// void CResult_InMemorySignerDecodeErrorZ_free(struct LDKCResult_InMemorySignerDecodeErrorZ _res);
	public static native void CResult_InMemorySignerDecodeErrorZ_free(long _res);
	// uint64_t CResult_InMemorySignerDecodeErrorZ_clone_ptr(LDKCResult_InMemorySignerDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_InMemorySignerDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_InMemorySignerDecodeErrorZ CResult_InMemorySignerDecodeErrorZ_clone(const struct LDKCResult_InMemorySignerDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_InMemorySignerDecodeErrorZ_clone(long orig);
	// struct LDKCOption_WriteableScoreZ COption_WriteableScoreZ_some(struct LDKWriteableScore o);
	public static native long COption_WriteableScoreZ_some(long o);
	// struct LDKCOption_WriteableScoreZ COption_WriteableScoreZ_none(void);
	public static native long COption_WriteableScoreZ_none();
	// void COption_WriteableScoreZ_free(struct LDKCOption_WriteableScoreZ _res);
	public static native void COption_WriteableScoreZ_free(long _res);
	// struct LDKCResult_NoneIOErrorZ CResult_NoneIOErrorZ_ok(void);
	public static native long CResult_NoneIOErrorZ_ok();
	// struct LDKCResult_NoneIOErrorZ CResult_NoneIOErrorZ_err(enum LDKIOError e);
	public static native long CResult_NoneIOErrorZ_err(IOError e);
	// bool CResult_NoneIOErrorZ_is_ok(const struct LDKCResult_NoneIOErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NoneIOErrorZ_is_ok(long o);
	// void CResult_NoneIOErrorZ_free(struct LDKCResult_NoneIOErrorZ _res);
	public static native void CResult_NoneIOErrorZ_free(long _res);
	// uint64_t CResult_NoneIOErrorZ_clone_ptr(LDKCResult_NoneIOErrorZ *NONNULL_PTR arg);
	public static native long CResult_NoneIOErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NoneIOErrorZ CResult_NoneIOErrorZ_clone(const struct LDKCResult_NoneIOErrorZ *NONNULL_PTR orig);
	public static native long CResult_NoneIOErrorZ_clone(long orig);
	// uint64_t C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ_clone_ptr(LDKC3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ *NONNULL_PTR arg);
	public static native long C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ_clone_ptr(long arg);
	// struct LDKC3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ_clone(const struct LDKC3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ *NONNULL_PTR orig);
	public static native long C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ_clone(long orig);
	// struct LDKC3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ_new(struct LDKThirtyTwoBytes a, struct LDKRecipientOnionFields b, struct LDKRouteParameters c);
	public static native long C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ_new(byte[] a, long b, long c);
	// void C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ_free(struct LDKC3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ _res);
	public static native void C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ_free(long _res);
	// struct LDKCResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_ok(struct LDKC3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZ o);
	public static native long CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_ok(long o);
	// struct LDKCResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_err(void);
	public static native long CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_err();
	// bool CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_is_ok(const struct LDKCResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ *NONNULL_PTR o);
	public static native boolean CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_is_ok(long o);
	// void CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_free(struct LDKCResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ _res);
	public static native void CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_free(long _res);
	// uint64_t CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_clone_ptr(LDKCResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ *NONNULL_PTR arg);
	public static native long CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_clone_ptr(long arg);
	// struct LDKCResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_clone(const struct LDKCResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ *NONNULL_PTR orig);
	public static native long CResult_C3Tuple_ThirtyTwoBytesRecipientOnionFieldsRouteParametersZNoneZ_clone(long orig);
	// void CVec_ChannelDetailsZ_free(struct LDKCVec_ChannelDetailsZ _res);
	public static native void CVec_ChannelDetailsZ_free(long[] _res);
	// struct LDKCResult_RouteLightningErrorZ CResult_RouteLightningErrorZ_ok(struct LDKRoute o);
	public static native long CResult_RouteLightningErrorZ_ok(long o);
	// struct LDKCResult_RouteLightningErrorZ CResult_RouteLightningErrorZ_err(struct LDKLightningError e);
	public static native long CResult_RouteLightningErrorZ_err(long e);
	// bool CResult_RouteLightningErrorZ_is_ok(const struct LDKCResult_RouteLightningErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RouteLightningErrorZ_is_ok(long o);
	// void CResult_RouteLightningErrorZ_free(struct LDKCResult_RouteLightningErrorZ _res);
	public static native void CResult_RouteLightningErrorZ_free(long _res);
	// uint64_t CResult_RouteLightningErrorZ_clone_ptr(LDKCResult_RouteLightningErrorZ *NONNULL_PTR arg);
	public static native long CResult_RouteLightningErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RouteLightningErrorZ CResult_RouteLightningErrorZ_clone(const struct LDKCResult_RouteLightningErrorZ *NONNULL_PTR orig);
	public static native long CResult_RouteLightningErrorZ_clone(long orig);
	// struct LDKCResult_CVec_BlindedPaymentPathZNoneZ CResult_CVec_BlindedPaymentPathZNoneZ_ok(struct LDKCVec_BlindedPaymentPathZ o);
	public static native long CResult_CVec_BlindedPaymentPathZNoneZ_ok(long[] o);
	// struct LDKCResult_CVec_BlindedPaymentPathZNoneZ CResult_CVec_BlindedPaymentPathZNoneZ_err(void);
	public static native long CResult_CVec_BlindedPaymentPathZNoneZ_err();
	// bool CResult_CVec_BlindedPaymentPathZNoneZ_is_ok(const struct LDKCResult_CVec_BlindedPaymentPathZNoneZ *NONNULL_PTR o);
	public static native boolean CResult_CVec_BlindedPaymentPathZNoneZ_is_ok(long o);
	// void CResult_CVec_BlindedPaymentPathZNoneZ_free(struct LDKCResult_CVec_BlindedPaymentPathZNoneZ _res);
	public static native void CResult_CVec_BlindedPaymentPathZNoneZ_free(long _res);
	// uint64_t CResult_CVec_BlindedPaymentPathZNoneZ_clone_ptr(LDKCResult_CVec_BlindedPaymentPathZNoneZ *NONNULL_PTR arg);
	public static native long CResult_CVec_BlindedPaymentPathZNoneZ_clone_ptr(long arg);
	// struct LDKCResult_CVec_BlindedPaymentPathZNoneZ CResult_CVec_BlindedPaymentPathZNoneZ_clone(const struct LDKCResult_CVec_BlindedPaymentPathZNoneZ *NONNULL_PTR orig);
	public static native long CResult_CVec_BlindedPaymentPathZNoneZ_clone(long orig);
	// struct LDKCResult_InFlightHtlcsDecodeErrorZ CResult_InFlightHtlcsDecodeErrorZ_ok(struct LDKInFlightHtlcs o);
	public static native long CResult_InFlightHtlcsDecodeErrorZ_ok(long o);
	// struct LDKCResult_InFlightHtlcsDecodeErrorZ CResult_InFlightHtlcsDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_InFlightHtlcsDecodeErrorZ_err(long e);
	// bool CResult_InFlightHtlcsDecodeErrorZ_is_ok(const struct LDKCResult_InFlightHtlcsDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_InFlightHtlcsDecodeErrorZ_is_ok(long o);
	// void CResult_InFlightHtlcsDecodeErrorZ_free(struct LDKCResult_InFlightHtlcsDecodeErrorZ _res);
	public static native void CResult_InFlightHtlcsDecodeErrorZ_free(long _res);
	// uint64_t CResult_InFlightHtlcsDecodeErrorZ_clone_ptr(LDKCResult_InFlightHtlcsDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_InFlightHtlcsDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_InFlightHtlcsDecodeErrorZ CResult_InFlightHtlcsDecodeErrorZ_clone(const struct LDKCResult_InFlightHtlcsDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_InFlightHtlcsDecodeErrorZ_clone(long orig);
	// struct LDKCResult_RouteHopDecodeErrorZ CResult_RouteHopDecodeErrorZ_ok(struct LDKRouteHop o);
	public static native long CResult_RouteHopDecodeErrorZ_ok(long o);
	// struct LDKCResult_RouteHopDecodeErrorZ CResult_RouteHopDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_RouteHopDecodeErrorZ_err(long e);
	// bool CResult_RouteHopDecodeErrorZ_is_ok(const struct LDKCResult_RouteHopDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RouteHopDecodeErrorZ_is_ok(long o);
	// void CResult_RouteHopDecodeErrorZ_free(struct LDKCResult_RouteHopDecodeErrorZ _res);
	public static native void CResult_RouteHopDecodeErrorZ_free(long _res);
	// uint64_t CResult_RouteHopDecodeErrorZ_clone_ptr(LDKCResult_RouteHopDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_RouteHopDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RouteHopDecodeErrorZ CResult_RouteHopDecodeErrorZ_clone(const struct LDKCResult_RouteHopDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_RouteHopDecodeErrorZ_clone(long orig);
	// void CVec_BlindedHopZ_free(struct LDKCVec_BlindedHopZ _res);
	public static native void CVec_BlindedHopZ_free(long[] _res);
	// struct LDKCResult_BlindedTailDecodeErrorZ CResult_BlindedTailDecodeErrorZ_ok(struct LDKBlindedTail o);
	public static native long CResult_BlindedTailDecodeErrorZ_ok(long o);
	// struct LDKCResult_BlindedTailDecodeErrorZ CResult_BlindedTailDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_BlindedTailDecodeErrorZ_err(long e);
	// bool CResult_BlindedTailDecodeErrorZ_is_ok(const struct LDKCResult_BlindedTailDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_BlindedTailDecodeErrorZ_is_ok(long o);
	// void CResult_BlindedTailDecodeErrorZ_free(struct LDKCResult_BlindedTailDecodeErrorZ _res);
	public static native void CResult_BlindedTailDecodeErrorZ_free(long _res);
	// uint64_t CResult_BlindedTailDecodeErrorZ_clone_ptr(LDKCResult_BlindedTailDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_BlindedTailDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_BlindedTailDecodeErrorZ CResult_BlindedTailDecodeErrorZ_clone(const struct LDKCResult_BlindedTailDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_BlindedTailDecodeErrorZ_clone(long orig);
	// void CVec_RouteHopZ_free(struct LDKCVec_RouteHopZ _res);
	public static native void CVec_RouteHopZ_free(long[] _res);
	// void CVec_PathZ_free(struct LDKCVec_PathZ _res);
	public static native void CVec_PathZ_free(long[] _res);
	// struct LDKCResult_RouteDecodeErrorZ CResult_RouteDecodeErrorZ_ok(struct LDKRoute o);
	public static native long CResult_RouteDecodeErrorZ_ok(long o);
	// struct LDKCResult_RouteDecodeErrorZ CResult_RouteDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_RouteDecodeErrorZ_err(long e);
	// bool CResult_RouteDecodeErrorZ_is_ok(const struct LDKCResult_RouteDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RouteDecodeErrorZ_is_ok(long o);
	// void CResult_RouteDecodeErrorZ_free(struct LDKCResult_RouteDecodeErrorZ _res);
	public static native void CResult_RouteDecodeErrorZ_free(long _res);
	// uint64_t CResult_RouteDecodeErrorZ_clone_ptr(LDKCResult_RouteDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_RouteDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RouteDecodeErrorZ CResult_RouteDecodeErrorZ_clone(const struct LDKCResult_RouteDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_RouteDecodeErrorZ_clone(long orig);
	// struct LDKCResult_RouteParametersDecodeErrorZ CResult_RouteParametersDecodeErrorZ_ok(struct LDKRouteParameters o);
	public static native long CResult_RouteParametersDecodeErrorZ_ok(long o);
	// struct LDKCResult_RouteParametersDecodeErrorZ CResult_RouteParametersDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_RouteParametersDecodeErrorZ_err(long e);
	// bool CResult_RouteParametersDecodeErrorZ_is_ok(const struct LDKCResult_RouteParametersDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RouteParametersDecodeErrorZ_is_ok(long o);
	// void CResult_RouteParametersDecodeErrorZ_free(struct LDKCResult_RouteParametersDecodeErrorZ _res);
	public static native void CResult_RouteParametersDecodeErrorZ_free(long _res);
	// uint64_t CResult_RouteParametersDecodeErrorZ_clone_ptr(LDKCResult_RouteParametersDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_RouteParametersDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RouteParametersDecodeErrorZ CResult_RouteParametersDecodeErrorZ_clone(const struct LDKCResult_RouteParametersDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_RouteParametersDecodeErrorZ_clone(long orig);
	// void CVec_u64Z_free(struct LDKCVec_u64Z _res);
	public static native void CVec_u64Z_free(long[] _res);
	// struct LDKCResult_PaymentParametersDecodeErrorZ CResult_PaymentParametersDecodeErrorZ_ok(struct LDKPaymentParameters o);
	public static native long CResult_PaymentParametersDecodeErrorZ_ok(long o);
	// struct LDKCResult_PaymentParametersDecodeErrorZ CResult_PaymentParametersDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_PaymentParametersDecodeErrorZ_err(long e);
	// bool CResult_PaymentParametersDecodeErrorZ_is_ok(const struct LDKCResult_PaymentParametersDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_PaymentParametersDecodeErrorZ_is_ok(long o);
	// void CResult_PaymentParametersDecodeErrorZ_free(struct LDKCResult_PaymentParametersDecodeErrorZ _res);
	public static native void CResult_PaymentParametersDecodeErrorZ_free(long _res);
	// uint64_t CResult_PaymentParametersDecodeErrorZ_clone_ptr(LDKCResult_PaymentParametersDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_PaymentParametersDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_PaymentParametersDecodeErrorZ CResult_PaymentParametersDecodeErrorZ_clone(const struct LDKCResult_PaymentParametersDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_PaymentParametersDecodeErrorZ_clone(long orig);
	// void CVec_RouteHintZ_free(struct LDKCVec_RouteHintZ _res);
	public static native void CVec_RouteHintZ_free(long[] _res);
	// struct LDKCResult_RouteHintDecodeErrorZ CResult_RouteHintDecodeErrorZ_ok(struct LDKRouteHint o);
	public static native long CResult_RouteHintDecodeErrorZ_ok(long o);
	// struct LDKCResult_RouteHintDecodeErrorZ CResult_RouteHintDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_RouteHintDecodeErrorZ_err(long e);
	// bool CResult_RouteHintDecodeErrorZ_is_ok(const struct LDKCResult_RouteHintDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RouteHintDecodeErrorZ_is_ok(long o);
	// void CResult_RouteHintDecodeErrorZ_free(struct LDKCResult_RouteHintDecodeErrorZ _res);
	public static native void CResult_RouteHintDecodeErrorZ_free(long _res);
	// uint64_t CResult_RouteHintDecodeErrorZ_clone_ptr(LDKCResult_RouteHintDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_RouteHintDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RouteHintDecodeErrorZ CResult_RouteHintDecodeErrorZ_clone(const struct LDKCResult_RouteHintDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_RouteHintDecodeErrorZ_clone(long orig);
	// struct LDKCResult_RouteHintHopDecodeErrorZ CResult_RouteHintHopDecodeErrorZ_ok(struct LDKRouteHintHop o);
	public static native long CResult_RouteHintHopDecodeErrorZ_ok(long o);
	// struct LDKCResult_RouteHintHopDecodeErrorZ CResult_RouteHintHopDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_RouteHintHopDecodeErrorZ_err(long e);
	// bool CResult_RouteHintHopDecodeErrorZ_is_ok(const struct LDKCResult_RouteHintHopDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RouteHintHopDecodeErrorZ_is_ok(long o);
	// void CResult_RouteHintHopDecodeErrorZ_free(struct LDKCResult_RouteHintHopDecodeErrorZ _res);
	public static native void CResult_RouteHintHopDecodeErrorZ_free(long _res);
	// uint64_t CResult_RouteHintHopDecodeErrorZ_clone_ptr(LDKCResult_RouteHintHopDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_RouteHintHopDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RouteHintHopDecodeErrorZ CResult_RouteHintHopDecodeErrorZ_clone(const struct LDKCResult_RouteHintHopDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_RouteHintHopDecodeErrorZ_clone(long orig);
	// void CVec_PublicKeyZ_free(struct LDKCVec_PublicKeyZ _res);
	public static native void CVec_PublicKeyZ_free(byte[][] _res);
	// void CVec_u16Z_free(struct LDKCVec_u16Z _res);
	public static native void CVec_u16Z_free(short[] _res);
	// struct LDKCResult_FixedPenaltyScorerDecodeErrorZ CResult_FixedPenaltyScorerDecodeErrorZ_ok(struct LDKFixedPenaltyScorer o);
	public static native long CResult_FixedPenaltyScorerDecodeErrorZ_ok(long o);
	// struct LDKCResult_FixedPenaltyScorerDecodeErrorZ CResult_FixedPenaltyScorerDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_FixedPenaltyScorerDecodeErrorZ_err(long e);
	// bool CResult_FixedPenaltyScorerDecodeErrorZ_is_ok(const struct LDKCResult_FixedPenaltyScorerDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_FixedPenaltyScorerDecodeErrorZ_is_ok(long o);
	// void CResult_FixedPenaltyScorerDecodeErrorZ_free(struct LDKCResult_FixedPenaltyScorerDecodeErrorZ _res);
	public static native void CResult_FixedPenaltyScorerDecodeErrorZ_free(long _res);
	// uint64_t CResult_FixedPenaltyScorerDecodeErrorZ_clone_ptr(LDKCResult_FixedPenaltyScorerDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_FixedPenaltyScorerDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_FixedPenaltyScorerDecodeErrorZ CResult_FixedPenaltyScorerDecodeErrorZ_clone(const struct LDKCResult_FixedPenaltyScorerDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_FixedPenaltyScorerDecodeErrorZ_clone(long orig);
	// void CVec_NodeIdZ_free(struct LDKCVec_NodeIdZ _res);
	public static native void CVec_NodeIdZ_free(long[] _res);
	// uint64_t C2Tuple_u64u64Z_clone_ptr(LDKC2Tuple_u64u64Z *NONNULL_PTR arg);
	public static native long C2Tuple_u64u64Z_clone_ptr(long arg);
	// struct LDKC2Tuple_u64u64Z C2Tuple_u64u64Z_clone(const struct LDKC2Tuple_u64u64Z *NONNULL_PTR orig);
	public static native long C2Tuple_u64u64Z_clone(long orig);
	// struct LDKC2Tuple_u64u64Z C2Tuple_u64u64Z_new(uint64_t a, uint64_t b);
	public static native long C2Tuple_u64u64Z_new(long a, long b);
	// void C2Tuple_u64u64Z_free(struct LDKC2Tuple_u64u64Z _res);
	public static native void C2Tuple_u64u64Z_free(long _res);
	// struct LDKCOption_C2Tuple_u64u64ZZ COption_C2Tuple_u64u64ZZ_some(struct LDKC2Tuple_u64u64Z o);
	public static native long COption_C2Tuple_u64u64ZZ_some(long o);
	// struct LDKCOption_C2Tuple_u64u64ZZ COption_C2Tuple_u64u64ZZ_none(void);
	public static native long COption_C2Tuple_u64u64ZZ_none();
	// void COption_C2Tuple_u64u64ZZ_free(struct LDKCOption_C2Tuple_u64u64ZZ _res);
	public static native void COption_C2Tuple_u64u64ZZ_free(long _res);
	// uint64_t COption_C2Tuple_u64u64ZZ_clone_ptr(LDKCOption_C2Tuple_u64u64ZZ *NONNULL_PTR arg);
	public static native long COption_C2Tuple_u64u64ZZ_clone_ptr(long arg);
	// struct LDKCOption_C2Tuple_u64u64ZZ COption_C2Tuple_u64u64ZZ_clone(const struct LDKCOption_C2Tuple_u64u64ZZ *NONNULL_PTR orig);
	public static native long COption_C2Tuple_u64u64ZZ_clone(long orig);
	// struct LDKC2Tuple_Z C2Tuple_Z_new(struct LDKThirtyTwoU16s a, struct LDKThirtyTwoU16s b);
	public static native long C2Tuple_Z_new(short[] a, short[] b);
	// void C2Tuple_Z_free(struct LDKC2Tuple_Z _res);
	public static native void C2Tuple_Z_free(long _res);
	// struct LDKC2Tuple__u1632_u1632Z C2Tuple__u1632_u1632Z_new(struct LDKThirtyTwoU16s a, struct LDKThirtyTwoU16s b);
	public static native long C2Tuple__u1632_u1632Z_new(short[] a, short[] b);
	// void C2Tuple__u1632_u1632Z_free(struct LDKC2Tuple__u1632_u1632Z _res);
	public static native void C2Tuple__u1632_u1632Z_free(long _res);
	// struct LDKCOption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ COption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ_some(struct LDKC2Tuple__u1632_u1632Z o);
	public static native long COption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ_some(long o);
	// struct LDKCOption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ COption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ_none(void);
	public static native long COption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ_none();
	// void COption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ_free(struct LDKCOption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ _res);
	public static native void COption_C2Tuple_ThirtyTwoU16sThirtyTwoU16sZZ_free(long _res);
	// struct LDKCOption_f64Z COption_f64Z_some(double o);
	public static native long COption_f64Z_some(double o);
	// struct LDKCOption_f64Z COption_f64Z_none(void);
	public static native long COption_f64Z_none();
	// void COption_f64Z_free(struct LDKCOption_f64Z _res);
	public static native void COption_f64Z_free(long _res);
	// uint64_t COption_f64Z_clone_ptr(LDKCOption_f64Z *NONNULL_PTR arg);
	public static native long COption_f64Z_clone_ptr(long arg);
	// struct LDKCOption_f64Z COption_f64Z_clone(const struct LDKCOption_f64Z *NONNULL_PTR orig);
	public static native long COption_f64Z_clone(long orig);
	// struct LDKCResult_ProbabilisticScorerDecodeErrorZ CResult_ProbabilisticScorerDecodeErrorZ_ok(struct LDKProbabilisticScorer o);
	public static native long CResult_ProbabilisticScorerDecodeErrorZ_ok(long o);
	// struct LDKCResult_ProbabilisticScorerDecodeErrorZ CResult_ProbabilisticScorerDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ProbabilisticScorerDecodeErrorZ_err(long e);
	// bool CResult_ProbabilisticScorerDecodeErrorZ_is_ok(const struct LDKCResult_ProbabilisticScorerDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ProbabilisticScorerDecodeErrorZ_is_ok(long o);
	// void CResult_ProbabilisticScorerDecodeErrorZ_free(struct LDKCResult_ProbabilisticScorerDecodeErrorZ _res);
	public static native void CResult_ProbabilisticScorerDecodeErrorZ_free(long _res);
	// struct LDKCResult_BestBlockDecodeErrorZ CResult_BestBlockDecodeErrorZ_ok(struct LDKBestBlock o);
	public static native long CResult_BestBlockDecodeErrorZ_ok(long o);
	// struct LDKCResult_BestBlockDecodeErrorZ CResult_BestBlockDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_BestBlockDecodeErrorZ_err(long e);
	// bool CResult_BestBlockDecodeErrorZ_is_ok(const struct LDKCResult_BestBlockDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_BestBlockDecodeErrorZ_is_ok(long o);
	// void CResult_BestBlockDecodeErrorZ_free(struct LDKCResult_BestBlockDecodeErrorZ _res);
	public static native void CResult_BestBlockDecodeErrorZ_free(long _res);
	// uint64_t CResult_BestBlockDecodeErrorZ_clone_ptr(LDKCResult_BestBlockDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_BestBlockDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_BestBlockDecodeErrorZ CResult_BestBlockDecodeErrorZ_clone(const struct LDKCResult_BestBlockDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_BestBlockDecodeErrorZ_clone(long orig);
	// uint64_t C2Tuple_usizeTransactionZ_clone_ptr(LDKC2Tuple_usizeTransactionZ *NONNULL_PTR arg);
	public static native long C2Tuple_usizeTransactionZ_clone_ptr(long arg);
	// struct LDKC2Tuple_usizeTransactionZ C2Tuple_usizeTransactionZ_clone(const struct LDKC2Tuple_usizeTransactionZ *NONNULL_PTR orig);
	public static native long C2Tuple_usizeTransactionZ_clone(long orig);
	// struct LDKC2Tuple_usizeTransactionZ C2Tuple_usizeTransactionZ_new(uintptr_t a, struct LDKTransaction b);
	public static native long C2Tuple_usizeTransactionZ_new(long a, byte[] b);
	// void C2Tuple_usizeTransactionZ_free(struct LDKC2Tuple_usizeTransactionZ _res);
	public static native void C2Tuple_usizeTransactionZ_free(long _res);
	// void CVec_C2Tuple_usizeTransactionZZ_free(struct LDKCVec_C2Tuple_usizeTransactionZZ _res);
	public static native void CVec_C2Tuple_usizeTransactionZZ_free(long[] _res);
	// uint64_t C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ_clone_ptr(LDKC3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ *NONNULL_PTR arg);
	public static native long C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ_clone_ptr(long arg);
	// struct LDKC3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ_clone(const struct LDKC3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ *NONNULL_PTR orig);
	public static native long C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ_clone(long orig);
	// struct LDKC3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ_new(struct LDKThirtyTwoBytes a, uint32_t b, struct LDKCOption_ThirtyTwoBytesZ c);
	public static native long C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ_new(byte[] a, int b, long c);
	// void C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ_free(struct LDKC3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ _res);
	public static native void C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ_free(long _res);
	// void CVec_C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZZ_free(struct LDKCVec_C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZZ _res);
	public static native void CVec_C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZZ_free(long[] _res);
	// struct LDKCResult_ChannelMonitorUpdateStatusNoneZ CResult_ChannelMonitorUpdateStatusNoneZ_ok(enum LDKChannelMonitorUpdateStatus o);
	public static native long CResult_ChannelMonitorUpdateStatusNoneZ_ok(ChannelMonitorUpdateStatus o);
	// struct LDKCResult_ChannelMonitorUpdateStatusNoneZ CResult_ChannelMonitorUpdateStatusNoneZ_err(void);
	public static native long CResult_ChannelMonitorUpdateStatusNoneZ_err();
	// bool CResult_ChannelMonitorUpdateStatusNoneZ_is_ok(const struct LDKCResult_ChannelMonitorUpdateStatusNoneZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelMonitorUpdateStatusNoneZ_is_ok(long o);
	// void CResult_ChannelMonitorUpdateStatusNoneZ_free(struct LDKCResult_ChannelMonitorUpdateStatusNoneZ _res);
	public static native void CResult_ChannelMonitorUpdateStatusNoneZ_free(long _res);
	// uint64_t CResult_ChannelMonitorUpdateStatusNoneZ_clone_ptr(LDKCResult_ChannelMonitorUpdateStatusNoneZ *NONNULL_PTR arg);
	public static native long CResult_ChannelMonitorUpdateStatusNoneZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelMonitorUpdateStatusNoneZ CResult_ChannelMonitorUpdateStatusNoneZ_clone(const struct LDKCResult_ChannelMonitorUpdateStatusNoneZ *NONNULL_PTR orig);
	public static native long CResult_ChannelMonitorUpdateStatusNoneZ_clone(long orig);
	// void CVec_MonitorEventZ_free(struct LDKCVec_MonitorEventZ _res);
	public static native void CVec_MonitorEventZ_free(long[] _res);
	// uint64_t C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_clone_ptr(LDKC4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ *NONNULL_PTR arg);
	public static native long C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_clone_ptr(long arg);
	// struct LDKC4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_clone(const struct LDKC4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ *NONNULL_PTR orig);
	public static native long C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_clone(long orig);
	// struct LDKC4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_new(struct LDKOutPoint a, struct LDKChannelId b, struct LDKCVec_MonitorEventZ c, struct LDKPublicKey d);
	public static native long C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_new(long a, long b, long[] c, byte[] d);
	// void C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_free(struct LDKC4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ _res);
	public static native void C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZ_free(long _res);
	// void CVec_C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZZ_free(struct LDKCVec_C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZZ _res);
	public static native void CVec_C4Tuple_OutPointChannelIdCVec_MonitorEventZPublicKeyZZ_free(long[] _res);
	// struct LDKCOption_AddressZ COption_AddressZ_some(struct LDKAddress o);
	public static native long COption_AddressZ_some(long o);
	// struct LDKCOption_AddressZ COption_AddressZ_none(void);
	public static native long COption_AddressZ_none();
	// void COption_AddressZ_free(struct LDKCOption_AddressZ _res);
	public static native void COption_AddressZ_free(long _res);
	// struct LDKCOption_StrZ COption_StrZ_some(struct LDKStr o);
	public static native long COption_StrZ_some(String o);
	// struct LDKCOption_StrZ COption_StrZ_none(void);
	public static native long COption_StrZ_none();
	// void COption_StrZ_free(struct LDKCOption_StrZ _res);
	public static native void COption_StrZ_free(long _res);
	// uint64_t COption_StrZ_clone_ptr(LDKCOption_StrZ *NONNULL_PTR arg);
	public static native long COption_StrZ_clone_ptr(long arg);
	// struct LDKCOption_StrZ COption_StrZ_clone(const struct LDKCOption_StrZ *NONNULL_PTR orig);
	public static native long COption_StrZ_clone(long orig);
	// struct LDKCResult_LSPSRequestIdAPIErrorZ CResult_LSPSRequestIdAPIErrorZ_ok(struct LDKLSPSRequestId o);
	public static native long CResult_LSPSRequestIdAPIErrorZ_ok(long o);
	// struct LDKCResult_LSPSRequestIdAPIErrorZ CResult_LSPSRequestIdAPIErrorZ_err(struct LDKAPIError e);
	public static native long CResult_LSPSRequestIdAPIErrorZ_err(long e);
	// bool CResult_LSPSRequestIdAPIErrorZ_is_ok(const struct LDKCResult_LSPSRequestIdAPIErrorZ *NONNULL_PTR o);
	public static native boolean CResult_LSPSRequestIdAPIErrorZ_is_ok(long o);
	// void CResult_LSPSRequestIdAPIErrorZ_free(struct LDKCResult_LSPSRequestIdAPIErrorZ _res);
	public static native void CResult_LSPSRequestIdAPIErrorZ_free(long _res);
	// uint64_t CResult_LSPSRequestIdAPIErrorZ_clone_ptr(LDKCResult_LSPSRequestIdAPIErrorZ *NONNULL_PTR arg);
	public static native long CResult_LSPSRequestIdAPIErrorZ_clone_ptr(long arg);
	// struct LDKCResult_LSPSRequestIdAPIErrorZ CResult_LSPSRequestIdAPIErrorZ_clone(const struct LDKCResult_LSPSRequestIdAPIErrorZ *NONNULL_PTR orig);
	public static native long CResult_LSPSRequestIdAPIErrorZ_clone(long orig);
	// void CVec_LSPS2OpeningFeeParamsZ_free(struct LDKCVec_LSPS2OpeningFeeParamsZ _res);
	public static native void CVec_LSPS2OpeningFeeParamsZ_free(long[] _res);
	// struct LDKCResult_OfferIdDecodeErrorZ CResult_OfferIdDecodeErrorZ_ok(struct LDKOfferId o);
	public static native long CResult_OfferIdDecodeErrorZ_ok(long o);
	// struct LDKCResult_OfferIdDecodeErrorZ CResult_OfferIdDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_OfferIdDecodeErrorZ_err(long e);
	// bool CResult_OfferIdDecodeErrorZ_is_ok(const struct LDKCResult_OfferIdDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OfferIdDecodeErrorZ_is_ok(long o);
	// void CResult_OfferIdDecodeErrorZ_free(struct LDKCResult_OfferIdDecodeErrorZ _res);
	public static native void CResult_OfferIdDecodeErrorZ_free(long _res);
	// uint64_t CResult_OfferIdDecodeErrorZ_clone_ptr(LDKCResult_OfferIdDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_OfferIdDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_OfferIdDecodeErrorZ CResult_OfferIdDecodeErrorZ_clone(const struct LDKCResult_OfferIdDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_OfferIdDecodeErrorZ_clone(long orig);
	// struct LDKCResult_NoneBolt12SemanticErrorZ CResult_NoneBolt12SemanticErrorZ_ok(void);
	public static native long CResult_NoneBolt12SemanticErrorZ_ok();
	// struct LDKCResult_NoneBolt12SemanticErrorZ CResult_NoneBolt12SemanticErrorZ_err(enum LDKBolt12SemanticError e);
	public static native long CResult_NoneBolt12SemanticErrorZ_err(Bolt12SemanticError e);
	// bool CResult_NoneBolt12SemanticErrorZ_is_ok(const struct LDKCResult_NoneBolt12SemanticErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NoneBolt12SemanticErrorZ_is_ok(long o);
	// void CResult_NoneBolt12SemanticErrorZ_free(struct LDKCResult_NoneBolt12SemanticErrorZ _res);
	public static native void CResult_NoneBolt12SemanticErrorZ_free(long _res);
	// uint64_t CResult_NoneBolt12SemanticErrorZ_clone_ptr(LDKCResult_NoneBolt12SemanticErrorZ *NONNULL_PTR arg);
	public static native long CResult_NoneBolt12SemanticErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NoneBolt12SemanticErrorZ CResult_NoneBolt12SemanticErrorZ_clone(const struct LDKCResult_NoneBolt12SemanticErrorZ *NONNULL_PTR orig);
	public static native long CResult_NoneBolt12SemanticErrorZ_clone(long orig);
	// struct LDKCResult_OfferBolt12SemanticErrorZ CResult_OfferBolt12SemanticErrorZ_ok(struct LDKOffer o);
	public static native long CResult_OfferBolt12SemanticErrorZ_ok(long o);
	// struct LDKCResult_OfferBolt12SemanticErrorZ CResult_OfferBolt12SemanticErrorZ_err(enum LDKBolt12SemanticError e);
	public static native long CResult_OfferBolt12SemanticErrorZ_err(Bolt12SemanticError e);
	// bool CResult_OfferBolt12SemanticErrorZ_is_ok(const struct LDKCResult_OfferBolt12SemanticErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OfferBolt12SemanticErrorZ_is_ok(long o);
	// void CResult_OfferBolt12SemanticErrorZ_free(struct LDKCResult_OfferBolt12SemanticErrorZ _res);
	public static native void CResult_OfferBolt12SemanticErrorZ_free(long _res);
	// uint64_t CResult_OfferBolt12SemanticErrorZ_clone_ptr(LDKCResult_OfferBolt12SemanticErrorZ *NONNULL_PTR arg);
	public static native long CResult_OfferBolt12SemanticErrorZ_clone_ptr(long arg);
	// struct LDKCResult_OfferBolt12SemanticErrorZ CResult_OfferBolt12SemanticErrorZ_clone(const struct LDKCResult_OfferBolt12SemanticErrorZ *NONNULL_PTR orig);
	public static native long CResult_OfferBolt12SemanticErrorZ_clone(long orig);
	// struct LDKCResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ CResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ_ok(struct LDKInvoiceRequestWithDerivedPayerSigningPubkeyBuilder o);
	public static native long CResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ_ok(long o);
	// struct LDKCResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ CResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ_err(enum LDKBolt12SemanticError e);
	public static native long CResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ_err(Bolt12SemanticError e);
	// bool CResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ_is_ok(const struct LDKCResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ *NONNULL_PTR o);
	public static native boolean CResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ_is_ok(long o);
	// void CResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ_free(struct LDKCResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ _res);
	public static native void CResult_InvoiceRequestWithDerivedPayerSigningPubkeyBuilderBolt12SemanticErrorZ_free(long _res);
	// struct LDKCResult_OfferDecodeErrorZ CResult_OfferDecodeErrorZ_ok(struct LDKOffer o);
	public static native long CResult_OfferDecodeErrorZ_ok(long o);
	// struct LDKCResult_OfferDecodeErrorZ CResult_OfferDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_OfferDecodeErrorZ_err(long e);
	// bool CResult_OfferDecodeErrorZ_is_ok(const struct LDKCResult_OfferDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OfferDecodeErrorZ_is_ok(long o);
	// void CResult_OfferDecodeErrorZ_free(struct LDKCResult_OfferDecodeErrorZ _res);
	public static native void CResult_OfferDecodeErrorZ_free(long _res);
	// uint64_t CResult_OfferDecodeErrorZ_clone_ptr(LDKCResult_OfferDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_OfferDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_OfferDecodeErrorZ CResult_OfferDecodeErrorZ_clone(const struct LDKCResult_OfferDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_OfferDecodeErrorZ_clone(long orig);
	// struct LDKCResult_OfferBolt12ParseErrorZ CResult_OfferBolt12ParseErrorZ_ok(struct LDKOffer o);
	public static native long CResult_OfferBolt12ParseErrorZ_ok(long o);
	// struct LDKCResult_OfferBolt12ParseErrorZ CResult_OfferBolt12ParseErrorZ_err(struct LDKBolt12ParseError e);
	public static native long CResult_OfferBolt12ParseErrorZ_err(long e);
	// bool CResult_OfferBolt12ParseErrorZ_is_ok(const struct LDKCResult_OfferBolt12ParseErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OfferBolt12ParseErrorZ_is_ok(long o);
	// void CResult_OfferBolt12ParseErrorZ_free(struct LDKCResult_OfferBolt12ParseErrorZ _res);
	public static native void CResult_OfferBolt12ParseErrorZ_free(long _res);
	// uint64_t CResult_OfferBolt12ParseErrorZ_clone_ptr(LDKCResult_OfferBolt12ParseErrorZ *NONNULL_PTR arg);
	public static native long CResult_OfferBolt12ParseErrorZ_clone_ptr(long arg);
	// struct LDKCResult_OfferBolt12ParseErrorZ CResult_OfferBolt12ParseErrorZ_clone(const struct LDKCResult_OfferBolt12ParseErrorZ *NONNULL_PTR orig);
	public static native long CResult_OfferBolt12ParseErrorZ_clone(long orig);
	// struct LDKCResult_NodeIdDecodeErrorZ CResult_NodeIdDecodeErrorZ_ok(struct LDKNodeId o);
	public static native long CResult_NodeIdDecodeErrorZ_ok(long o);
	// struct LDKCResult_NodeIdDecodeErrorZ CResult_NodeIdDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_NodeIdDecodeErrorZ_err(long e);
	// bool CResult_NodeIdDecodeErrorZ_is_ok(const struct LDKCResult_NodeIdDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NodeIdDecodeErrorZ_is_ok(long o);
	// void CResult_NodeIdDecodeErrorZ_free(struct LDKCResult_NodeIdDecodeErrorZ _res);
	public static native void CResult_NodeIdDecodeErrorZ_free(long _res);
	// uint64_t CResult_NodeIdDecodeErrorZ_clone_ptr(LDKCResult_NodeIdDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_NodeIdDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NodeIdDecodeErrorZ CResult_NodeIdDecodeErrorZ_clone(const struct LDKCResult_NodeIdDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_NodeIdDecodeErrorZ_clone(long orig);
	// struct LDKCResult_PublicKeySecp256k1ErrorZ CResult_PublicKeySecp256k1ErrorZ_ok(struct LDKPublicKey o);
	public static native long CResult_PublicKeySecp256k1ErrorZ_ok(byte[] o);
	// struct LDKCResult_PublicKeySecp256k1ErrorZ CResult_PublicKeySecp256k1ErrorZ_err(enum LDKSecp256k1Error e);
	public static native long CResult_PublicKeySecp256k1ErrorZ_err(Secp256k1Error e);
	// bool CResult_PublicKeySecp256k1ErrorZ_is_ok(const struct LDKCResult_PublicKeySecp256k1ErrorZ *NONNULL_PTR o);
	public static native boolean CResult_PublicKeySecp256k1ErrorZ_is_ok(long o);
	// void CResult_PublicKeySecp256k1ErrorZ_free(struct LDKCResult_PublicKeySecp256k1ErrorZ _res);
	public static native void CResult_PublicKeySecp256k1ErrorZ_free(long _res);
	// uint64_t CResult_PublicKeySecp256k1ErrorZ_clone_ptr(LDKCResult_PublicKeySecp256k1ErrorZ *NONNULL_PTR arg);
	public static native long CResult_PublicKeySecp256k1ErrorZ_clone_ptr(long arg);
	// struct LDKCResult_PublicKeySecp256k1ErrorZ CResult_PublicKeySecp256k1ErrorZ_clone(const struct LDKCResult_PublicKeySecp256k1ErrorZ *NONNULL_PTR orig);
	public static native long CResult_PublicKeySecp256k1ErrorZ_clone(long orig);
	// struct LDKCOption_NetworkUpdateZ COption_NetworkUpdateZ_some(struct LDKNetworkUpdate o);
	public static native long COption_NetworkUpdateZ_some(long o);
	// struct LDKCOption_NetworkUpdateZ COption_NetworkUpdateZ_none(void);
	public static native long COption_NetworkUpdateZ_none();
	// void COption_NetworkUpdateZ_free(struct LDKCOption_NetworkUpdateZ _res);
	public static native void COption_NetworkUpdateZ_free(long _res);
	// uint64_t COption_NetworkUpdateZ_clone_ptr(LDKCOption_NetworkUpdateZ *NONNULL_PTR arg);
	public static native long COption_NetworkUpdateZ_clone_ptr(long arg);
	// struct LDKCOption_NetworkUpdateZ COption_NetworkUpdateZ_clone(const struct LDKCOption_NetworkUpdateZ *NONNULL_PTR orig);
	public static native long COption_NetworkUpdateZ_clone(long orig);
	// struct LDKCResult_COption_NetworkUpdateZDecodeErrorZ CResult_COption_NetworkUpdateZDecodeErrorZ_ok(struct LDKCOption_NetworkUpdateZ o);
	public static native long CResult_COption_NetworkUpdateZDecodeErrorZ_ok(long o);
	// struct LDKCResult_COption_NetworkUpdateZDecodeErrorZ CResult_COption_NetworkUpdateZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_COption_NetworkUpdateZDecodeErrorZ_err(long e);
	// bool CResult_COption_NetworkUpdateZDecodeErrorZ_is_ok(const struct LDKCResult_COption_NetworkUpdateZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_COption_NetworkUpdateZDecodeErrorZ_is_ok(long o);
	// void CResult_COption_NetworkUpdateZDecodeErrorZ_free(struct LDKCResult_COption_NetworkUpdateZDecodeErrorZ _res);
	public static native void CResult_COption_NetworkUpdateZDecodeErrorZ_free(long _res);
	// uint64_t CResult_COption_NetworkUpdateZDecodeErrorZ_clone_ptr(LDKCResult_COption_NetworkUpdateZDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_COption_NetworkUpdateZDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_COption_NetworkUpdateZDecodeErrorZ CResult_COption_NetworkUpdateZDecodeErrorZ_clone(const struct LDKCResult_COption_NetworkUpdateZDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_COption_NetworkUpdateZDecodeErrorZ_clone(long orig);
	// struct LDKCOption_UtxoLookupZ COption_UtxoLookupZ_some(struct LDKUtxoLookup o);
	public static native long COption_UtxoLookupZ_some(long o);
	// struct LDKCOption_UtxoLookupZ COption_UtxoLookupZ_none(void);
	public static native long COption_UtxoLookupZ_none();
	// void COption_UtxoLookupZ_free(struct LDKCOption_UtxoLookupZ _res);
	public static native void COption_UtxoLookupZ_free(long _res);
	// struct LDKCResult_NoneLightningErrorZ CResult_NoneLightningErrorZ_ok(void);
	public static native long CResult_NoneLightningErrorZ_ok();
	// struct LDKCResult_NoneLightningErrorZ CResult_NoneLightningErrorZ_err(struct LDKLightningError e);
	public static native long CResult_NoneLightningErrorZ_err(long e);
	// bool CResult_NoneLightningErrorZ_is_ok(const struct LDKCResult_NoneLightningErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NoneLightningErrorZ_is_ok(long o);
	// void CResult_NoneLightningErrorZ_free(struct LDKCResult_NoneLightningErrorZ _res);
	public static native void CResult_NoneLightningErrorZ_free(long _res);
	// uint64_t CResult_NoneLightningErrorZ_clone_ptr(LDKCResult_NoneLightningErrorZ *NONNULL_PTR arg);
	public static native long CResult_NoneLightningErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NoneLightningErrorZ CResult_NoneLightningErrorZ_clone(const struct LDKCResult_NoneLightningErrorZ *NONNULL_PTR orig);
	public static native long CResult_NoneLightningErrorZ_clone(long orig);
	// struct LDKCResult_boolLightningErrorZ CResult_boolLightningErrorZ_ok(bool o);
	public static native long CResult_boolLightningErrorZ_ok(boolean o);
	// struct LDKCResult_boolLightningErrorZ CResult_boolLightningErrorZ_err(struct LDKLightningError e);
	public static native long CResult_boolLightningErrorZ_err(long e);
	// bool CResult_boolLightningErrorZ_is_ok(const struct LDKCResult_boolLightningErrorZ *NONNULL_PTR o);
	public static native boolean CResult_boolLightningErrorZ_is_ok(long o);
	// void CResult_boolLightningErrorZ_free(struct LDKCResult_boolLightningErrorZ _res);
	public static native void CResult_boolLightningErrorZ_free(long _res);
	// uint64_t CResult_boolLightningErrorZ_clone_ptr(LDKCResult_boolLightningErrorZ *NONNULL_PTR arg);
	public static native long CResult_boolLightningErrorZ_clone_ptr(long arg);
	// struct LDKCResult_boolLightningErrorZ CResult_boolLightningErrorZ_clone(const struct LDKCResult_boolLightningErrorZ *NONNULL_PTR orig);
	public static native long CResult_boolLightningErrorZ_clone(long orig);
	// uint64_t C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ_clone_ptr(LDKC3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ *NONNULL_PTR arg);
	public static native long C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ_clone_ptr(long arg);
	// struct LDKC3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ_clone(const struct LDKC3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ *NONNULL_PTR orig);
	public static native long C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ_clone(long orig);
	// struct LDKC3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ_new(struct LDKChannelAnnouncement a, struct LDKChannelUpdate b, struct LDKChannelUpdate c);
	public static native long C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ_new(long a, long b, long c);
	// void C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ_free(struct LDKC3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ _res);
	public static native void C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ_free(long _res);
	// struct LDKCOption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ COption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ_some(struct LDKC3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZ o);
	public static native long COption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ_some(long o);
	// struct LDKCOption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ COption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ_none(void);
	public static native long COption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ_none();
	// void COption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ_free(struct LDKCOption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ _res);
	public static native void COption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ_free(long _res);
	// uint64_t COption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ_clone_ptr(LDKCOption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ *NONNULL_PTR arg);
	public static native long COption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ_clone_ptr(long arg);
	// struct LDKCOption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ COption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ_clone(const struct LDKCOption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ *NONNULL_PTR orig);
	public static native long COption_C3Tuple_ChannelAnnouncementChannelUpdateChannelUpdateZZ_clone(long orig);
	// void CVec_MessageSendEventZ_free(struct LDKCVec_MessageSendEventZ _res);
	public static native void CVec_MessageSendEventZ_free(long[] _res);
	// struct LDKCResult_ChannelUpdateInfoDecodeErrorZ CResult_ChannelUpdateInfoDecodeErrorZ_ok(struct LDKChannelUpdateInfo o);
	public static native long CResult_ChannelUpdateInfoDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelUpdateInfoDecodeErrorZ CResult_ChannelUpdateInfoDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelUpdateInfoDecodeErrorZ_err(long e);
	// bool CResult_ChannelUpdateInfoDecodeErrorZ_is_ok(const struct LDKCResult_ChannelUpdateInfoDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelUpdateInfoDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelUpdateInfoDecodeErrorZ_free(struct LDKCResult_ChannelUpdateInfoDecodeErrorZ _res);
	public static native void CResult_ChannelUpdateInfoDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelUpdateInfoDecodeErrorZ_clone_ptr(LDKCResult_ChannelUpdateInfoDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelUpdateInfoDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelUpdateInfoDecodeErrorZ CResult_ChannelUpdateInfoDecodeErrorZ_clone(const struct LDKCResult_ChannelUpdateInfoDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelUpdateInfoDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ChannelInfoDecodeErrorZ CResult_ChannelInfoDecodeErrorZ_ok(struct LDKChannelInfo o);
	public static native long CResult_ChannelInfoDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelInfoDecodeErrorZ CResult_ChannelInfoDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelInfoDecodeErrorZ_err(long e);
	// bool CResult_ChannelInfoDecodeErrorZ_is_ok(const struct LDKCResult_ChannelInfoDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelInfoDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelInfoDecodeErrorZ_free(struct LDKCResult_ChannelInfoDecodeErrorZ _res);
	public static native void CResult_ChannelInfoDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelInfoDecodeErrorZ_clone_ptr(LDKCResult_ChannelInfoDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelInfoDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelInfoDecodeErrorZ CResult_ChannelInfoDecodeErrorZ_clone(const struct LDKCResult_ChannelInfoDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelInfoDecodeErrorZ_clone(long orig);
	// struct LDKCResult_RoutingFeesDecodeErrorZ CResult_RoutingFeesDecodeErrorZ_ok(struct LDKRoutingFees o);
	public static native long CResult_RoutingFeesDecodeErrorZ_ok(long o);
	// struct LDKCResult_RoutingFeesDecodeErrorZ CResult_RoutingFeesDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_RoutingFeesDecodeErrorZ_err(long e);
	// bool CResult_RoutingFeesDecodeErrorZ_is_ok(const struct LDKCResult_RoutingFeesDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RoutingFeesDecodeErrorZ_is_ok(long o);
	// void CResult_RoutingFeesDecodeErrorZ_free(struct LDKCResult_RoutingFeesDecodeErrorZ _res);
	public static native void CResult_RoutingFeesDecodeErrorZ_free(long _res);
	// uint64_t CResult_RoutingFeesDecodeErrorZ_clone_ptr(LDKCResult_RoutingFeesDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_RoutingFeesDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RoutingFeesDecodeErrorZ CResult_RoutingFeesDecodeErrorZ_clone(const struct LDKCResult_RoutingFeesDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_RoutingFeesDecodeErrorZ_clone(long orig);
	// void CVec_SocketAddressZ_free(struct LDKCVec_SocketAddressZ _res);
	public static native void CVec_SocketAddressZ_free(long[] _res);
	// struct LDKCResult_NodeAnnouncementInfoDecodeErrorZ CResult_NodeAnnouncementInfoDecodeErrorZ_ok(struct LDKNodeAnnouncementInfo o);
	public static native long CResult_NodeAnnouncementInfoDecodeErrorZ_ok(long o);
	// struct LDKCResult_NodeAnnouncementInfoDecodeErrorZ CResult_NodeAnnouncementInfoDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_NodeAnnouncementInfoDecodeErrorZ_err(long e);
	// bool CResult_NodeAnnouncementInfoDecodeErrorZ_is_ok(const struct LDKCResult_NodeAnnouncementInfoDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NodeAnnouncementInfoDecodeErrorZ_is_ok(long o);
	// void CResult_NodeAnnouncementInfoDecodeErrorZ_free(struct LDKCResult_NodeAnnouncementInfoDecodeErrorZ _res);
	public static native void CResult_NodeAnnouncementInfoDecodeErrorZ_free(long _res);
	// uint64_t CResult_NodeAnnouncementInfoDecodeErrorZ_clone_ptr(LDKCResult_NodeAnnouncementInfoDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_NodeAnnouncementInfoDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NodeAnnouncementInfoDecodeErrorZ CResult_NodeAnnouncementInfoDecodeErrorZ_clone(const struct LDKCResult_NodeAnnouncementInfoDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_NodeAnnouncementInfoDecodeErrorZ_clone(long orig);
	// struct LDKCResult_NodeAliasDecodeErrorZ CResult_NodeAliasDecodeErrorZ_ok(struct LDKNodeAlias o);
	public static native long CResult_NodeAliasDecodeErrorZ_ok(long o);
	// struct LDKCResult_NodeAliasDecodeErrorZ CResult_NodeAliasDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_NodeAliasDecodeErrorZ_err(long e);
	// bool CResult_NodeAliasDecodeErrorZ_is_ok(const struct LDKCResult_NodeAliasDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NodeAliasDecodeErrorZ_is_ok(long o);
	// void CResult_NodeAliasDecodeErrorZ_free(struct LDKCResult_NodeAliasDecodeErrorZ _res);
	public static native void CResult_NodeAliasDecodeErrorZ_free(long _res);
	// uint64_t CResult_NodeAliasDecodeErrorZ_clone_ptr(LDKCResult_NodeAliasDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_NodeAliasDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NodeAliasDecodeErrorZ CResult_NodeAliasDecodeErrorZ_clone(const struct LDKCResult_NodeAliasDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_NodeAliasDecodeErrorZ_clone(long orig);
	// struct LDKCOption_NodeAnnouncementInfoZ COption_NodeAnnouncementInfoZ_some(struct LDKNodeAnnouncementInfo o);
	public static native long COption_NodeAnnouncementInfoZ_some(long o);
	// struct LDKCOption_NodeAnnouncementInfoZ COption_NodeAnnouncementInfoZ_none(void);
	public static native long COption_NodeAnnouncementInfoZ_none();
	// void COption_NodeAnnouncementInfoZ_free(struct LDKCOption_NodeAnnouncementInfoZ _res);
	public static native void COption_NodeAnnouncementInfoZ_free(long _res);
	// uint64_t COption_NodeAnnouncementInfoZ_clone_ptr(LDKCOption_NodeAnnouncementInfoZ *NONNULL_PTR arg);
	public static native long COption_NodeAnnouncementInfoZ_clone_ptr(long arg);
	// struct LDKCOption_NodeAnnouncementInfoZ COption_NodeAnnouncementInfoZ_clone(const struct LDKCOption_NodeAnnouncementInfoZ *NONNULL_PTR orig);
	public static native long COption_NodeAnnouncementInfoZ_clone(long orig);
	// struct LDKCResult_NodeInfoDecodeErrorZ CResult_NodeInfoDecodeErrorZ_ok(struct LDKNodeInfo o);
	public static native long CResult_NodeInfoDecodeErrorZ_ok(long o);
	// struct LDKCResult_NodeInfoDecodeErrorZ CResult_NodeInfoDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_NodeInfoDecodeErrorZ_err(long e);
	// bool CResult_NodeInfoDecodeErrorZ_is_ok(const struct LDKCResult_NodeInfoDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NodeInfoDecodeErrorZ_is_ok(long o);
	// void CResult_NodeInfoDecodeErrorZ_free(struct LDKCResult_NodeInfoDecodeErrorZ _res);
	public static native void CResult_NodeInfoDecodeErrorZ_free(long _res);
	// uint64_t CResult_NodeInfoDecodeErrorZ_clone_ptr(LDKCResult_NodeInfoDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_NodeInfoDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NodeInfoDecodeErrorZ CResult_NodeInfoDecodeErrorZ_clone(const struct LDKCResult_NodeInfoDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_NodeInfoDecodeErrorZ_clone(long orig);
	// struct LDKCResult_NetworkGraphDecodeErrorZ CResult_NetworkGraphDecodeErrorZ_ok(struct LDKNetworkGraph o);
	public static native long CResult_NetworkGraphDecodeErrorZ_ok(long o);
	// struct LDKCResult_NetworkGraphDecodeErrorZ CResult_NetworkGraphDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_NetworkGraphDecodeErrorZ_err(long e);
	// bool CResult_NetworkGraphDecodeErrorZ_is_ok(const struct LDKCResult_NetworkGraphDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NetworkGraphDecodeErrorZ_is_ok(long o);
	// void CResult_NetworkGraphDecodeErrorZ_free(struct LDKCResult_NetworkGraphDecodeErrorZ _res);
	public static native void CResult_NetworkGraphDecodeErrorZ_free(long _res);
	// struct LDKCOption_CVec_SocketAddressZZ COption_CVec_SocketAddressZZ_some(struct LDKCVec_SocketAddressZ o);
	public static native long COption_CVec_SocketAddressZZ_some(long[] o);
	// struct LDKCOption_CVec_SocketAddressZZ COption_CVec_SocketAddressZZ_none(void);
	public static native long COption_CVec_SocketAddressZZ_none();
	// void COption_CVec_SocketAddressZZ_free(struct LDKCOption_CVec_SocketAddressZZ _res);
	public static native void COption_CVec_SocketAddressZZ_free(long _res);
	// uint64_t COption_CVec_SocketAddressZZ_clone_ptr(LDKCOption_CVec_SocketAddressZZ *NONNULL_PTR arg);
	public static native long COption_CVec_SocketAddressZZ_clone_ptr(long arg);
	// struct LDKCOption_CVec_SocketAddressZZ COption_CVec_SocketAddressZZ_clone(const struct LDKCOption_CVec_SocketAddressZZ *NONNULL_PTR orig);
	public static native long COption_CVec_SocketAddressZZ_clone(long orig);
	// struct LDKCResult_u64ShortChannelIdErrorZ CResult_u64ShortChannelIdErrorZ_ok(uint64_t o);
	public static native long CResult_u64ShortChannelIdErrorZ_ok(long o);
	// struct LDKCResult_u64ShortChannelIdErrorZ CResult_u64ShortChannelIdErrorZ_err(enum LDKShortChannelIdError e);
	public static native long CResult_u64ShortChannelIdErrorZ_err(ShortChannelIdError e);
	// bool CResult_u64ShortChannelIdErrorZ_is_ok(const struct LDKCResult_u64ShortChannelIdErrorZ *NONNULL_PTR o);
	public static native boolean CResult_u64ShortChannelIdErrorZ_is_ok(long o);
	// void CResult_u64ShortChannelIdErrorZ_free(struct LDKCResult_u64ShortChannelIdErrorZ _res);
	public static native void CResult_u64ShortChannelIdErrorZ_free(long _res);
	// struct LDKCResult_PendingHTLCInfoInboundHTLCErrZ CResult_PendingHTLCInfoInboundHTLCErrZ_ok(struct LDKPendingHTLCInfo o);
	public static native long CResult_PendingHTLCInfoInboundHTLCErrZ_ok(long o);
	// struct LDKCResult_PendingHTLCInfoInboundHTLCErrZ CResult_PendingHTLCInfoInboundHTLCErrZ_err(struct LDKInboundHTLCErr e);
	public static native long CResult_PendingHTLCInfoInboundHTLCErrZ_err(long e);
	// bool CResult_PendingHTLCInfoInboundHTLCErrZ_is_ok(const struct LDKCResult_PendingHTLCInfoInboundHTLCErrZ *NONNULL_PTR o);
	public static native boolean CResult_PendingHTLCInfoInboundHTLCErrZ_is_ok(long o);
	// void CResult_PendingHTLCInfoInboundHTLCErrZ_free(struct LDKCResult_PendingHTLCInfoInboundHTLCErrZ _res);
	public static native void CResult_PendingHTLCInfoInboundHTLCErrZ_free(long _res);
	// uint64_t CResult_PendingHTLCInfoInboundHTLCErrZ_clone_ptr(LDKCResult_PendingHTLCInfoInboundHTLCErrZ *NONNULL_PTR arg);
	public static native long CResult_PendingHTLCInfoInboundHTLCErrZ_clone_ptr(long arg);
	// struct LDKCResult_PendingHTLCInfoInboundHTLCErrZ CResult_PendingHTLCInfoInboundHTLCErrZ_clone(const struct LDKCResult_PendingHTLCInfoInboundHTLCErrZ *NONNULL_PTR orig);
	public static native long CResult_PendingHTLCInfoInboundHTLCErrZ_clone(long orig);
	// void CVec_HTLCOutputInCommitmentZ_free(struct LDKCVec_HTLCOutputInCommitmentZ _res);
	public static native void CVec_HTLCOutputInCommitmentZ_free(long[] _res);
	// void CVec_HTLCDescriptorZ_free(struct LDKCVec_HTLCDescriptorZ _res);
	public static native void CVec_HTLCDescriptorZ_free(long[] _res);
	// void CVec_UtxoZ_free(struct LDKCVec_UtxoZ _res);
	public static native void CVec_UtxoZ_free(long[] _res);
	// struct LDKCOption_TxOutZ COption_TxOutZ_some(struct LDKTxOut o);
	public static native long COption_TxOutZ_some(long o);
	// struct LDKCOption_TxOutZ COption_TxOutZ_none(void);
	public static native long COption_TxOutZ_none();
	// void COption_TxOutZ_free(struct LDKCOption_TxOutZ _res);
	public static native void COption_TxOutZ_free(long _res);
	// uint64_t COption_TxOutZ_clone_ptr(LDKCOption_TxOutZ *NONNULL_PTR arg);
	public static native long COption_TxOutZ_clone_ptr(long arg);
	// struct LDKCOption_TxOutZ COption_TxOutZ_clone(const struct LDKCOption_TxOutZ *NONNULL_PTR orig);
	public static native long COption_TxOutZ_clone(long orig);
	// void CVec_InputZ_free(struct LDKCVec_InputZ _res);
	public static native void CVec_InputZ_free(long[] _res);
	// struct LDKCResult_CoinSelectionNoneZ CResult_CoinSelectionNoneZ_ok(struct LDKCoinSelection o);
	public static native long CResult_CoinSelectionNoneZ_ok(long o);
	// struct LDKCResult_CoinSelectionNoneZ CResult_CoinSelectionNoneZ_err(void);
	public static native long CResult_CoinSelectionNoneZ_err();
	// bool CResult_CoinSelectionNoneZ_is_ok(const struct LDKCResult_CoinSelectionNoneZ *NONNULL_PTR o);
	public static native boolean CResult_CoinSelectionNoneZ_is_ok(long o);
	// void CResult_CoinSelectionNoneZ_free(struct LDKCResult_CoinSelectionNoneZ _res);
	public static native void CResult_CoinSelectionNoneZ_free(long _res);
	// uint64_t CResult_CoinSelectionNoneZ_clone_ptr(LDKCResult_CoinSelectionNoneZ *NONNULL_PTR arg);
	public static native long CResult_CoinSelectionNoneZ_clone_ptr(long arg);
	// struct LDKCResult_CoinSelectionNoneZ CResult_CoinSelectionNoneZ_clone(const struct LDKCResult_CoinSelectionNoneZ *NONNULL_PTR orig);
	public static native long CResult_CoinSelectionNoneZ_clone(long orig);
	// struct LDKCResult_CVec_UtxoZNoneZ CResult_CVec_UtxoZNoneZ_ok(struct LDKCVec_UtxoZ o);
	public static native long CResult_CVec_UtxoZNoneZ_ok(long[] o);
	// struct LDKCResult_CVec_UtxoZNoneZ CResult_CVec_UtxoZNoneZ_err(void);
	public static native long CResult_CVec_UtxoZNoneZ_err();
	// bool CResult_CVec_UtxoZNoneZ_is_ok(const struct LDKCResult_CVec_UtxoZNoneZ *NONNULL_PTR o);
	public static native boolean CResult_CVec_UtxoZNoneZ_is_ok(long o);
	// void CResult_CVec_UtxoZNoneZ_free(struct LDKCResult_CVec_UtxoZNoneZ _res);
	public static native void CResult_CVec_UtxoZNoneZ_free(long _res);
	// uint64_t CResult_CVec_UtxoZNoneZ_clone_ptr(LDKCResult_CVec_UtxoZNoneZ *NONNULL_PTR arg);
	public static native long CResult_CVec_UtxoZNoneZ_clone_ptr(long arg);
	// struct LDKCResult_CVec_UtxoZNoneZ CResult_CVec_UtxoZNoneZ_clone(const struct LDKCResult_CVec_UtxoZNoneZ *NONNULL_PTR orig);
	public static native long CResult_CVec_UtxoZNoneZ_clone(long orig);
	// struct LDKCOption_PaymentContextZ COption_PaymentContextZ_some(struct LDKPaymentContext o);
	public static native long COption_PaymentContextZ_some(long o);
	// struct LDKCOption_PaymentContextZ COption_PaymentContextZ_none(void);
	public static native long COption_PaymentContextZ_none();
	// void COption_PaymentContextZ_free(struct LDKCOption_PaymentContextZ _res);
	public static native void COption_PaymentContextZ_free(long _res);
	// uint64_t COption_PaymentContextZ_clone_ptr(LDKCOption_PaymentContextZ *NONNULL_PTR arg);
	public static native long COption_PaymentContextZ_clone_ptr(long arg);
	// struct LDKCOption_PaymentContextZ COption_PaymentContextZ_clone(const struct LDKCOption_PaymentContextZ *NONNULL_PTR orig);
	public static native long COption_PaymentContextZ_clone(long orig);
	// uint64_t C2Tuple_u64u16Z_clone_ptr(LDKC2Tuple_u64u16Z *NONNULL_PTR arg);
	public static native long C2Tuple_u64u16Z_clone_ptr(long arg);
	// struct LDKC2Tuple_u64u16Z C2Tuple_u64u16Z_clone(const struct LDKC2Tuple_u64u16Z *NONNULL_PTR orig);
	public static native long C2Tuple_u64u16Z_clone(long orig);
	// struct LDKC2Tuple_u64u16Z C2Tuple_u64u16Z_new(uint64_t a, uint16_t b);
	public static native long C2Tuple_u64u16Z_new(long a, short b);
	// void C2Tuple_u64u16Z_free(struct LDKC2Tuple_u64u16Z _res);
	public static native void C2Tuple_u64u16Z_free(long _res);
	// struct LDKCOption_C2Tuple_u64u16ZZ COption_C2Tuple_u64u16ZZ_some(struct LDKC2Tuple_u64u16Z o);
	public static native long COption_C2Tuple_u64u16ZZ_some(long o);
	// struct LDKCOption_C2Tuple_u64u16ZZ COption_C2Tuple_u64u16ZZ_none(void);
	public static native long COption_C2Tuple_u64u16ZZ_none();
	// void COption_C2Tuple_u64u16ZZ_free(struct LDKCOption_C2Tuple_u64u16ZZ _res);
	public static native void COption_C2Tuple_u64u16ZZ_free(long _res);
	// uint64_t COption_C2Tuple_u64u16ZZ_clone_ptr(LDKCOption_C2Tuple_u64u16ZZ *NONNULL_PTR arg);
	public static native long COption_C2Tuple_u64u16ZZ_clone_ptr(long arg);
	// struct LDKCOption_C2Tuple_u64u16ZZ COption_C2Tuple_u64u16ZZ_clone(const struct LDKCOption_C2Tuple_u64u16ZZ *NONNULL_PTR orig);
	public static native long COption_C2Tuple_u64u16ZZ_clone(long orig);
	// struct LDKCResult_ChannelIdAPIErrorZ CResult_ChannelIdAPIErrorZ_ok(struct LDKChannelId o);
	public static native long CResult_ChannelIdAPIErrorZ_ok(long o);
	// struct LDKCResult_ChannelIdAPIErrorZ CResult_ChannelIdAPIErrorZ_err(struct LDKAPIError e);
	public static native long CResult_ChannelIdAPIErrorZ_err(long e);
	// bool CResult_ChannelIdAPIErrorZ_is_ok(const struct LDKCResult_ChannelIdAPIErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelIdAPIErrorZ_is_ok(long o);
	// void CResult_ChannelIdAPIErrorZ_free(struct LDKCResult_ChannelIdAPIErrorZ _res);
	public static native void CResult_ChannelIdAPIErrorZ_free(long _res);
	// uint64_t CResult_ChannelIdAPIErrorZ_clone_ptr(LDKCResult_ChannelIdAPIErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelIdAPIErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelIdAPIErrorZ CResult_ChannelIdAPIErrorZ_clone(const struct LDKCResult_ChannelIdAPIErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelIdAPIErrorZ_clone(long orig);
	// void CVec_RecentPaymentDetailsZ_free(struct LDKCVec_RecentPaymentDetailsZ _res);
	public static native void CVec_RecentPaymentDetailsZ_free(long[] _res);
	// struct LDKCResult_NoneAPIErrorZ CResult_NoneAPIErrorZ_ok(void);
	public static native long CResult_NoneAPIErrorZ_ok();
	// struct LDKCResult_NoneAPIErrorZ CResult_NoneAPIErrorZ_err(struct LDKAPIError e);
	public static native long CResult_NoneAPIErrorZ_err(long e);
	// bool CResult_NoneAPIErrorZ_is_ok(const struct LDKCResult_NoneAPIErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NoneAPIErrorZ_is_ok(long o);
	// void CResult_NoneAPIErrorZ_free(struct LDKCResult_NoneAPIErrorZ _res);
	public static native void CResult_NoneAPIErrorZ_free(long _res);
	// uint64_t CResult_NoneAPIErrorZ_clone_ptr(LDKCResult_NoneAPIErrorZ *NONNULL_PTR arg);
	public static native long CResult_NoneAPIErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NoneAPIErrorZ CResult_NoneAPIErrorZ_clone(const struct LDKCResult_NoneAPIErrorZ *NONNULL_PTR orig);
	public static native long CResult_NoneAPIErrorZ_clone(long orig);
	// struct LDKCResult_NoneRetryableSendFailureZ CResult_NoneRetryableSendFailureZ_ok(void);
	public static native long CResult_NoneRetryableSendFailureZ_ok();
	// struct LDKCResult_NoneRetryableSendFailureZ CResult_NoneRetryableSendFailureZ_err(enum LDKRetryableSendFailure e);
	public static native long CResult_NoneRetryableSendFailureZ_err(RetryableSendFailure e);
	// bool CResult_NoneRetryableSendFailureZ_is_ok(const struct LDKCResult_NoneRetryableSendFailureZ *NONNULL_PTR o);
	public static native boolean CResult_NoneRetryableSendFailureZ_is_ok(long o);
	// void CResult_NoneRetryableSendFailureZ_free(struct LDKCResult_NoneRetryableSendFailureZ _res);
	public static native void CResult_NoneRetryableSendFailureZ_free(long _res);
	// uint64_t CResult_NoneRetryableSendFailureZ_clone_ptr(LDKCResult_NoneRetryableSendFailureZ *NONNULL_PTR arg);
	public static native long CResult_NoneRetryableSendFailureZ_clone_ptr(long arg);
	// struct LDKCResult_NoneRetryableSendFailureZ CResult_NoneRetryableSendFailureZ_clone(const struct LDKCResult_NoneRetryableSendFailureZ *NONNULL_PTR orig);
	public static native long CResult_NoneRetryableSendFailureZ_clone(long orig);
	// struct LDKCOption_OffersContextZ COption_OffersContextZ_some(struct LDKOffersContext o);
	public static native long COption_OffersContextZ_some(long o);
	// struct LDKCOption_OffersContextZ COption_OffersContextZ_none(void);
	public static native long COption_OffersContextZ_none();
	// void COption_OffersContextZ_free(struct LDKCOption_OffersContextZ _res);
	public static native void COption_OffersContextZ_free(long _res);
	// uint64_t COption_OffersContextZ_clone_ptr(LDKCOption_OffersContextZ *NONNULL_PTR arg);
	public static native long COption_OffersContextZ_clone_ptr(long arg);
	// struct LDKCOption_OffersContextZ COption_OffersContextZ_clone(const struct LDKCOption_OffersContextZ *NONNULL_PTR orig);
	public static native long COption_OffersContextZ_clone(long orig);
	// struct LDKCResult_NoneBolt12PaymentErrorZ CResult_NoneBolt12PaymentErrorZ_ok(void);
	public static native long CResult_NoneBolt12PaymentErrorZ_ok();
	// struct LDKCResult_NoneBolt12PaymentErrorZ CResult_NoneBolt12PaymentErrorZ_err(struct LDKBolt12PaymentError e);
	public static native long CResult_NoneBolt12PaymentErrorZ_err(long e);
	// bool CResult_NoneBolt12PaymentErrorZ_is_ok(const struct LDKCResult_NoneBolt12PaymentErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NoneBolt12PaymentErrorZ_is_ok(long o);
	// void CResult_NoneBolt12PaymentErrorZ_free(struct LDKCResult_NoneBolt12PaymentErrorZ _res);
	public static native void CResult_NoneBolt12PaymentErrorZ_free(long _res);
	// uint64_t CResult_NoneBolt12PaymentErrorZ_clone_ptr(LDKCResult_NoneBolt12PaymentErrorZ *NONNULL_PTR arg);
	public static native long CResult_NoneBolt12PaymentErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NoneBolt12PaymentErrorZ CResult_NoneBolt12PaymentErrorZ_clone(const struct LDKCResult_NoneBolt12PaymentErrorZ *NONNULL_PTR orig);
	public static native long CResult_NoneBolt12PaymentErrorZ_clone(long orig);
	// struct LDKCResult_ThirtyTwoBytesRetryableSendFailureZ CResult_ThirtyTwoBytesRetryableSendFailureZ_ok(struct LDKThirtyTwoBytes o);
	public static native long CResult_ThirtyTwoBytesRetryableSendFailureZ_ok(byte[] o);
	// struct LDKCResult_ThirtyTwoBytesRetryableSendFailureZ CResult_ThirtyTwoBytesRetryableSendFailureZ_err(enum LDKRetryableSendFailure e);
	public static native long CResult_ThirtyTwoBytesRetryableSendFailureZ_err(RetryableSendFailure e);
	// bool CResult_ThirtyTwoBytesRetryableSendFailureZ_is_ok(const struct LDKCResult_ThirtyTwoBytesRetryableSendFailureZ *NONNULL_PTR o);
	public static native boolean CResult_ThirtyTwoBytesRetryableSendFailureZ_is_ok(long o);
	// void CResult_ThirtyTwoBytesRetryableSendFailureZ_free(struct LDKCResult_ThirtyTwoBytesRetryableSendFailureZ _res);
	public static native void CResult_ThirtyTwoBytesRetryableSendFailureZ_free(long _res);
	// uint64_t CResult_ThirtyTwoBytesRetryableSendFailureZ_clone_ptr(LDKCResult_ThirtyTwoBytesRetryableSendFailureZ *NONNULL_PTR arg);
	public static native long CResult_ThirtyTwoBytesRetryableSendFailureZ_clone_ptr(long arg);
	// struct LDKCResult_ThirtyTwoBytesRetryableSendFailureZ CResult_ThirtyTwoBytesRetryableSendFailureZ_clone(const struct LDKCResult_ThirtyTwoBytesRetryableSendFailureZ *NONNULL_PTR orig);
	public static native long CResult_ThirtyTwoBytesRetryableSendFailureZ_clone(long orig);
	// uint64_t C2Tuple_ThirtyTwoBytesThirtyTwoBytesZ_clone_ptr(LDKC2Tuple_ThirtyTwoBytesThirtyTwoBytesZ *NONNULL_PTR arg);
	public static native long C2Tuple_ThirtyTwoBytesThirtyTwoBytesZ_clone_ptr(long arg);
	// struct LDKC2Tuple_ThirtyTwoBytesThirtyTwoBytesZ C2Tuple_ThirtyTwoBytesThirtyTwoBytesZ_clone(const struct LDKC2Tuple_ThirtyTwoBytesThirtyTwoBytesZ *NONNULL_PTR orig);
	public static native long C2Tuple_ThirtyTwoBytesThirtyTwoBytesZ_clone(long orig);
	// struct LDKC2Tuple_ThirtyTwoBytesThirtyTwoBytesZ C2Tuple_ThirtyTwoBytesThirtyTwoBytesZ_new(struct LDKThirtyTwoBytes a, struct LDKThirtyTwoBytes b);
	public static native long C2Tuple_ThirtyTwoBytesThirtyTwoBytesZ_new(byte[] a, byte[] b);
	// void C2Tuple_ThirtyTwoBytesThirtyTwoBytesZ_free(struct LDKC2Tuple_ThirtyTwoBytesThirtyTwoBytesZ _res);
	public static native void C2Tuple_ThirtyTwoBytesThirtyTwoBytesZ_free(long _res);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_ok(struct LDKC2Tuple_ThirtyTwoBytesThirtyTwoBytesZ o);
	public static native long CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_ok(long o);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_err(struct LDKProbeSendFailure e);
	public static native long CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_err(long e);
	// bool CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_is_ok(const struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ *NONNULL_PTR o);
	public static native boolean CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_is_ok(long o);
	// void CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_free(struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ _res);
	public static native void CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_free(long _res);
	// uint64_t CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_clone_ptr(LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ *NONNULL_PTR arg);
	public static native long CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_clone_ptr(long arg);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_clone(const struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ *NONNULL_PTR orig);
	public static native long CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ_clone(long orig);
	// void CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZ_free(struct LDKCVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZ _res);
	public static native void CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZ_free(long[] _res);
	// struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_ok(struct LDKCVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZ o);
	public static native long CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_ok(long[] o);
	// struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_err(struct LDKProbeSendFailure e);
	public static native long CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_err(long e);
	// bool CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_is_ok(const struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ *NONNULL_PTR o);
	public static native boolean CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_is_ok(long o);
	// void CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_free(struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ _res);
	public static native void CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_free(long _res);
	// uint64_t CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_clone_ptr(LDKCResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ *NONNULL_PTR arg);
	public static native long CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_clone_ptr(long arg);
	// struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_clone(const struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ *NONNULL_PTR orig);
	public static native long CResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ_clone(long orig);
	// uint64_t C2Tuple_ChannelIdPublicKeyZ_clone_ptr(LDKC2Tuple_ChannelIdPublicKeyZ *NONNULL_PTR arg);
	public static native long C2Tuple_ChannelIdPublicKeyZ_clone_ptr(long arg);
	// struct LDKC2Tuple_ChannelIdPublicKeyZ C2Tuple_ChannelIdPublicKeyZ_clone(const struct LDKC2Tuple_ChannelIdPublicKeyZ *NONNULL_PTR orig);
	public static native long C2Tuple_ChannelIdPublicKeyZ_clone(long orig);
	// struct LDKC2Tuple_ChannelIdPublicKeyZ C2Tuple_ChannelIdPublicKeyZ_new(struct LDKChannelId a, struct LDKPublicKey b);
	public static native long C2Tuple_ChannelIdPublicKeyZ_new(long a, byte[] b);
	// void C2Tuple_ChannelIdPublicKeyZ_free(struct LDKC2Tuple_ChannelIdPublicKeyZ _res);
	public static native void C2Tuple_ChannelIdPublicKeyZ_free(long _res);
	// void CVec_C2Tuple_ChannelIdPublicKeyZZ_free(struct LDKCVec_C2Tuple_ChannelIdPublicKeyZZ _res);
	public static native void CVec_C2Tuple_ChannelIdPublicKeyZZ_free(long[] _res);
	// void CVec_ChannelIdZ_free(struct LDKCVec_ChannelIdZ _res);
	public static native void CVec_ChannelIdZ_free(long[] _res);
	// uint64_t C2Tuple_PublicKeyChannelIdZ_clone_ptr(LDKC2Tuple_PublicKeyChannelIdZ *NONNULL_PTR arg);
	public static native long C2Tuple_PublicKeyChannelIdZ_clone_ptr(long arg);
	// struct LDKC2Tuple_PublicKeyChannelIdZ C2Tuple_PublicKeyChannelIdZ_clone(const struct LDKC2Tuple_PublicKeyChannelIdZ *NONNULL_PTR orig);
	public static native long C2Tuple_PublicKeyChannelIdZ_clone(long orig);
	// struct LDKC2Tuple_PublicKeyChannelIdZ C2Tuple_PublicKeyChannelIdZ_new(struct LDKPublicKey a, struct LDKChannelId b);
	public static native long C2Tuple_PublicKeyChannelIdZ_new(byte[] a, long b);
	// void C2Tuple_PublicKeyChannelIdZ_free(struct LDKC2Tuple_PublicKeyChannelIdZ _res);
	public static native void C2Tuple_PublicKeyChannelIdZ_free(long _res);
	// struct LDKCOption_C2Tuple_PublicKeyChannelIdZZ COption_C2Tuple_PublicKeyChannelIdZZ_some(struct LDKC2Tuple_PublicKeyChannelIdZ o);
	public static native long COption_C2Tuple_PublicKeyChannelIdZZ_some(long o);
	// struct LDKCOption_C2Tuple_PublicKeyChannelIdZZ COption_C2Tuple_PublicKeyChannelIdZZ_none(void);
	public static native long COption_C2Tuple_PublicKeyChannelIdZZ_none();
	// void COption_C2Tuple_PublicKeyChannelIdZZ_free(struct LDKCOption_C2Tuple_PublicKeyChannelIdZZ _res);
	public static native void COption_C2Tuple_PublicKeyChannelIdZZ_free(long _res);
	// uint64_t COption_C2Tuple_PublicKeyChannelIdZZ_clone_ptr(LDKCOption_C2Tuple_PublicKeyChannelIdZZ *NONNULL_PTR arg);
	public static native long COption_C2Tuple_PublicKeyChannelIdZZ_clone_ptr(long arg);
	// struct LDKCOption_C2Tuple_PublicKeyChannelIdZZ COption_C2Tuple_PublicKeyChannelIdZZ_clone(const struct LDKCOption_C2Tuple_PublicKeyChannelIdZZ *NONNULL_PTR orig);
	public static native long COption_C2Tuple_PublicKeyChannelIdZZ_clone(long orig);
	// struct LDKCResult_Bolt11InvoiceSignOrCreationErrorZ CResult_Bolt11InvoiceSignOrCreationErrorZ_ok(struct LDKBolt11Invoice o);
	public static native long CResult_Bolt11InvoiceSignOrCreationErrorZ_ok(long o);
	// struct LDKCResult_Bolt11InvoiceSignOrCreationErrorZ CResult_Bolt11InvoiceSignOrCreationErrorZ_err(struct LDKSignOrCreationError e);
	public static native long CResult_Bolt11InvoiceSignOrCreationErrorZ_err(long e);
	// bool CResult_Bolt11InvoiceSignOrCreationErrorZ_is_ok(const struct LDKCResult_Bolt11InvoiceSignOrCreationErrorZ *NONNULL_PTR o);
	public static native boolean CResult_Bolt11InvoiceSignOrCreationErrorZ_is_ok(long o);
	// void CResult_Bolt11InvoiceSignOrCreationErrorZ_free(struct LDKCResult_Bolt11InvoiceSignOrCreationErrorZ _res);
	public static native void CResult_Bolt11InvoiceSignOrCreationErrorZ_free(long _res);
	// uint64_t CResult_Bolt11InvoiceSignOrCreationErrorZ_clone_ptr(LDKCResult_Bolt11InvoiceSignOrCreationErrorZ *NONNULL_PTR arg);
	public static native long CResult_Bolt11InvoiceSignOrCreationErrorZ_clone_ptr(long arg);
	// struct LDKCResult_Bolt11InvoiceSignOrCreationErrorZ CResult_Bolt11InvoiceSignOrCreationErrorZ_clone(const struct LDKCResult_Bolt11InvoiceSignOrCreationErrorZ *NONNULL_PTR orig);
	public static native long CResult_Bolt11InvoiceSignOrCreationErrorZ_clone(long orig);
	// struct LDKCResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_ok(struct LDKOfferWithDerivedMetadataBuilder o);
	public static native long CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_ok(long o);
	// struct LDKCResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_err(enum LDKBolt12SemanticError e);
	public static native long CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_err(Bolt12SemanticError e);
	// bool CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_is_ok(const struct LDKCResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_is_ok(long o);
	// void CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_free(struct LDKCResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ _res);
	public static native void CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_free(long _res);
	// uint64_t CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_clone_ptr(LDKCResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ *NONNULL_PTR arg);
	public static native long CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_clone_ptr(long arg);
	// struct LDKCResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_clone(const struct LDKCResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ *NONNULL_PTR orig);
	public static native long CResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ_clone(long orig);
	// void CVec_DestinationZ_free(struct LDKCVec_DestinationZ _res);
	public static native void CVec_DestinationZ_free(long[] _res);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_ok(struct LDKC2Tuple_ThirtyTwoBytesThirtyTwoBytesZ o);
	public static native long CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_ok(long o);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_err(void);
	public static native long CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_err();
	// bool CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_is_ok(const struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ *NONNULL_PTR o);
	public static native boolean CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_is_ok(long o);
	// void CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_free(struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ _res);
	public static native void CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_free(long _res);
	// uint64_t CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_clone_ptr(LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ *NONNULL_PTR arg);
	public static native long CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_clone_ptr(long arg);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_clone(const struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ *NONNULL_PTR orig);
	public static native long CResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ_clone(long orig);
	// struct LDKCResult_ThirtyTwoBytesAPIErrorZ CResult_ThirtyTwoBytesAPIErrorZ_ok(struct LDKThirtyTwoBytes o);
	public static native long CResult_ThirtyTwoBytesAPIErrorZ_ok(byte[] o);
	// struct LDKCResult_ThirtyTwoBytesAPIErrorZ CResult_ThirtyTwoBytesAPIErrorZ_err(struct LDKAPIError e);
	public static native long CResult_ThirtyTwoBytesAPIErrorZ_err(long e);
	// bool CResult_ThirtyTwoBytesAPIErrorZ_is_ok(const struct LDKCResult_ThirtyTwoBytesAPIErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ThirtyTwoBytesAPIErrorZ_is_ok(long o);
	// void CResult_ThirtyTwoBytesAPIErrorZ_free(struct LDKCResult_ThirtyTwoBytesAPIErrorZ _res);
	public static native void CResult_ThirtyTwoBytesAPIErrorZ_free(long _res);
	// uint64_t CResult_ThirtyTwoBytesAPIErrorZ_clone_ptr(LDKCResult_ThirtyTwoBytesAPIErrorZ *NONNULL_PTR arg);
	public static native long CResult_ThirtyTwoBytesAPIErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ThirtyTwoBytesAPIErrorZ CResult_ThirtyTwoBytesAPIErrorZ_clone(const struct LDKCResult_ThirtyTwoBytesAPIErrorZ *NONNULL_PTR orig);
	public static native long CResult_ThirtyTwoBytesAPIErrorZ_clone(long orig);
	// uint64_t C2Tuple_OffersMessageResponseInstructionZ_clone_ptr(LDKC2Tuple_OffersMessageResponseInstructionZ *NONNULL_PTR arg);
	public static native long C2Tuple_OffersMessageResponseInstructionZ_clone_ptr(long arg);
	// struct LDKC2Tuple_OffersMessageResponseInstructionZ C2Tuple_OffersMessageResponseInstructionZ_clone(const struct LDKC2Tuple_OffersMessageResponseInstructionZ *NONNULL_PTR orig);
	public static native long C2Tuple_OffersMessageResponseInstructionZ_clone(long orig);
	// struct LDKC2Tuple_OffersMessageResponseInstructionZ C2Tuple_OffersMessageResponseInstructionZ_new(struct LDKOffersMessage a, struct LDKResponseInstruction b);
	public static native long C2Tuple_OffersMessageResponseInstructionZ_new(long a, long b);
	// void C2Tuple_OffersMessageResponseInstructionZ_free(struct LDKC2Tuple_OffersMessageResponseInstructionZ _res);
	public static native void C2Tuple_OffersMessageResponseInstructionZ_free(long _res);
	// struct LDKCOption_C2Tuple_OffersMessageResponseInstructionZZ COption_C2Tuple_OffersMessageResponseInstructionZZ_some(struct LDKC2Tuple_OffersMessageResponseInstructionZ o);
	public static native long COption_C2Tuple_OffersMessageResponseInstructionZZ_some(long o);
	// struct LDKCOption_C2Tuple_OffersMessageResponseInstructionZZ COption_C2Tuple_OffersMessageResponseInstructionZZ_none(void);
	public static native long COption_C2Tuple_OffersMessageResponseInstructionZZ_none();
	// void COption_C2Tuple_OffersMessageResponseInstructionZZ_free(struct LDKCOption_C2Tuple_OffersMessageResponseInstructionZZ _res);
	public static native void COption_C2Tuple_OffersMessageResponseInstructionZZ_free(long _res);
	// uint64_t COption_C2Tuple_OffersMessageResponseInstructionZZ_clone_ptr(LDKCOption_C2Tuple_OffersMessageResponseInstructionZZ *NONNULL_PTR arg);
	public static native long COption_C2Tuple_OffersMessageResponseInstructionZZ_clone_ptr(long arg);
	// struct LDKCOption_C2Tuple_OffersMessageResponseInstructionZZ COption_C2Tuple_OffersMessageResponseInstructionZZ_clone(const struct LDKCOption_C2Tuple_OffersMessageResponseInstructionZZ *NONNULL_PTR orig);
	public static native long COption_C2Tuple_OffersMessageResponseInstructionZZ_clone(long orig);
	// uint64_t C2Tuple_OffersMessageMessageSendInstructionsZ_clone_ptr(LDKC2Tuple_OffersMessageMessageSendInstructionsZ *NONNULL_PTR arg);
	public static native long C2Tuple_OffersMessageMessageSendInstructionsZ_clone_ptr(long arg);
	// struct LDKC2Tuple_OffersMessageMessageSendInstructionsZ C2Tuple_OffersMessageMessageSendInstructionsZ_clone(const struct LDKC2Tuple_OffersMessageMessageSendInstructionsZ *NONNULL_PTR orig);
	public static native long C2Tuple_OffersMessageMessageSendInstructionsZ_clone(long orig);
	// struct LDKC2Tuple_OffersMessageMessageSendInstructionsZ C2Tuple_OffersMessageMessageSendInstructionsZ_new(struct LDKOffersMessage a, struct LDKMessageSendInstructions b);
	public static native long C2Tuple_OffersMessageMessageSendInstructionsZ_new(long a, long b);
	// void C2Tuple_OffersMessageMessageSendInstructionsZ_free(struct LDKC2Tuple_OffersMessageMessageSendInstructionsZ _res);
	public static native void C2Tuple_OffersMessageMessageSendInstructionsZ_free(long _res);
	// void CVec_C2Tuple_OffersMessageMessageSendInstructionsZZ_free(struct LDKCVec_C2Tuple_OffersMessageMessageSendInstructionsZZ _res);
	public static native void CVec_C2Tuple_OffersMessageMessageSendInstructionsZZ_free(long[] _res);
	// uint64_t C2Tuple_ReleaseHeldHtlcResponseInstructionZ_clone_ptr(LDKC2Tuple_ReleaseHeldHtlcResponseInstructionZ *NONNULL_PTR arg);
	public static native long C2Tuple_ReleaseHeldHtlcResponseInstructionZ_clone_ptr(long arg);
	// struct LDKC2Tuple_ReleaseHeldHtlcResponseInstructionZ C2Tuple_ReleaseHeldHtlcResponseInstructionZ_clone(const struct LDKC2Tuple_ReleaseHeldHtlcResponseInstructionZ *NONNULL_PTR orig);
	public static native long C2Tuple_ReleaseHeldHtlcResponseInstructionZ_clone(long orig);
	// struct LDKC2Tuple_ReleaseHeldHtlcResponseInstructionZ C2Tuple_ReleaseHeldHtlcResponseInstructionZ_new(struct LDKReleaseHeldHtlc a, struct LDKResponseInstruction b);
	public static native long C2Tuple_ReleaseHeldHtlcResponseInstructionZ_new(long a, long b);
	// void C2Tuple_ReleaseHeldHtlcResponseInstructionZ_free(struct LDKC2Tuple_ReleaseHeldHtlcResponseInstructionZ _res);
	public static native void C2Tuple_ReleaseHeldHtlcResponseInstructionZ_free(long _res);
	// struct LDKCOption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ COption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ_some(struct LDKC2Tuple_ReleaseHeldHtlcResponseInstructionZ o);
	public static native long COption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ_some(long o);
	// struct LDKCOption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ COption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ_none(void);
	public static native long COption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ_none();
	// void COption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ_free(struct LDKCOption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ _res);
	public static native void COption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ_free(long _res);
	// uint64_t COption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ_clone_ptr(LDKCOption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ *NONNULL_PTR arg);
	public static native long COption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ_clone_ptr(long arg);
	// struct LDKCOption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ COption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ_clone(const struct LDKCOption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ *NONNULL_PTR orig);
	public static native long COption_C2Tuple_ReleaseHeldHtlcResponseInstructionZZ_clone(long orig);
	// uint64_t C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ_clone_ptr(LDKC2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ *NONNULL_PTR arg);
	public static native long C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ_clone_ptr(long arg);
	// struct LDKC2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ_clone(const struct LDKC2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ *NONNULL_PTR orig);
	public static native long C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ_clone(long orig);
	// struct LDKC2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ_new(struct LDKAsyncPaymentsMessage a, struct LDKMessageSendInstructions b);
	public static native long C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ_new(long a, long b);
	// void C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ_free(struct LDKC2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ _res);
	public static native void C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZ_free(long _res);
	// void CVec_C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZZ_free(struct LDKCVec_C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZZ _res);
	public static native void CVec_C2Tuple_AsyncPaymentsMessageMessageSendInstructionsZZ_free(long[] _res);
	// struct LDKCResult_PhantomRouteHintsDecodeErrorZ CResult_PhantomRouteHintsDecodeErrorZ_ok(struct LDKPhantomRouteHints o);
	public static native long CResult_PhantomRouteHintsDecodeErrorZ_ok(long o);
	// struct LDKCResult_PhantomRouteHintsDecodeErrorZ CResult_PhantomRouteHintsDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_PhantomRouteHintsDecodeErrorZ_err(long e);
	// bool CResult_PhantomRouteHintsDecodeErrorZ_is_ok(const struct LDKCResult_PhantomRouteHintsDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_PhantomRouteHintsDecodeErrorZ_is_ok(long o);
	// void CResult_PhantomRouteHintsDecodeErrorZ_free(struct LDKCResult_PhantomRouteHintsDecodeErrorZ _res);
	public static native void CResult_PhantomRouteHintsDecodeErrorZ_free(long _res);
	// uint64_t CResult_PhantomRouteHintsDecodeErrorZ_clone_ptr(LDKCResult_PhantomRouteHintsDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_PhantomRouteHintsDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_PhantomRouteHintsDecodeErrorZ CResult_PhantomRouteHintsDecodeErrorZ_clone(const struct LDKCResult_PhantomRouteHintsDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_PhantomRouteHintsDecodeErrorZ_clone(long orig);
	// struct LDKCResult_BlindedForwardDecodeErrorZ CResult_BlindedForwardDecodeErrorZ_ok(struct LDKBlindedForward o);
	public static native long CResult_BlindedForwardDecodeErrorZ_ok(long o);
	// struct LDKCResult_BlindedForwardDecodeErrorZ CResult_BlindedForwardDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_BlindedForwardDecodeErrorZ_err(long e);
	// bool CResult_BlindedForwardDecodeErrorZ_is_ok(const struct LDKCResult_BlindedForwardDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_BlindedForwardDecodeErrorZ_is_ok(long o);
	// void CResult_BlindedForwardDecodeErrorZ_free(struct LDKCResult_BlindedForwardDecodeErrorZ _res);
	public static native void CResult_BlindedForwardDecodeErrorZ_free(long _res);
	// uint64_t CResult_BlindedForwardDecodeErrorZ_clone_ptr(LDKCResult_BlindedForwardDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_BlindedForwardDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_BlindedForwardDecodeErrorZ CResult_BlindedForwardDecodeErrorZ_clone(const struct LDKCResult_BlindedForwardDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_BlindedForwardDecodeErrorZ_clone(long orig);
	// struct LDKCResult_PendingHTLCRoutingDecodeErrorZ CResult_PendingHTLCRoutingDecodeErrorZ_ok(struct LDKPendingHTLCRouting o);
	public static native long CResult_PendingHTLCRoutingDecodeErrorZ_ok(long o);
	// struct LDKCResult_PendingHTLCRoutingDecodeErrorZ CResult_PendingHTLCRoutingDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_PendingHTLCRoutingDecodeErrorZ_err(long e);
	// bool CResult_PendingHTLCRoutingDecodeErrorZ_is_ok(const struct LDKCResult_PendingHTLCRoutingDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_PendingHTLCRoutingDecodeErrorZ_is_ok(long o);
	// void CResult_PendingHTLCRoutingDecodeErrorZ_free(struct LDKCResult_PendingHTLCRoutingDecodeErrorZ _res);
	public static native void CResult_PendingHTLCRoutingDecodeErrorZ_free(long _res);
	// uint64_t CResult_PendingHTLCRoutingDecodeErrorZ_clone_ptr(LDKCResult_PendingHTLCRoutingDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_PendingHTLCRoutingDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_PendingHTLCRoutingDecodeErrorZ CResult_PendingHTLCRoutingDecodeErrorZ_clone(const struct LDKCResult_PendingHTLCRoutingDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_PendingHTLCRoutingDecodeErrorZ_clone(long orig);
	// struct LDKCResult_PendingHTLCInfoDecodeErrorZ CResult_PendingHTLCInfoDecodeErrorZ_ok(struct LDKPendingHTLCInfo o);
	public static native long CResult_PendingHTLCInfoDecodeErrorZ_ok(long o);
	// struct LDKCResult_PendingHTLCInfoDecodeErrorZ CResult_PendingHTLCInfoDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_PendingHTLCInfoDecodeErrorZ_err(long e);
	// bool CResult_PendingHTLCInfoDecodeErrorZ_is_ok(const struct LDKCResult_PendingHTLCInfoDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_PendingHTLCInfoDecodeErrorZ_is_ok(long o);
	// void CResult_PendingHTLCInfoDecodeErrorZ_free(struct LDKCResult_PendingHTLCInfoDecodeErrorZ _res);
	public static native void CResult_PendingHTLCInfoDecodeErrorZ_free(long _res);
	// uint64_t CResult_PendingHTLCInfoDecodeErrorZ_clone_ptr(LDKCResult_PendingHTLCInfoDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_PendingHTLCInfoDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_PendingHTLCInfoDecodeErrorZ CResult_PendingHTLCInfoDecodeErrorZ_clone(const struct LDKCResult_PendingHTLCInfoDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_PendingHTLCInfoDecodeErrorZ_clone(long orig);
	// struct LDKCResult_BlindedFailureDecodeErrorZ CResult_BlindedFailureDecodeErrorZ_ok(enum LDKBlindedFailure o);
	public static native long CResult_BlindedFailureDecodeErrorZ_ok(BlindedFailure o);
	// struct LDKCResult_BlindedFailureDecodeErrorZ CResult_BlindedFailureDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_BlindedFailureDecodeErrorZ_err(long e);
	// bool CResult_BlindedFailureDecodeErrorZ_is_ok(const struct LDKCResult_BlindedFailureDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_BlindedFailureDecodeErrorZ_is_ok(long o);
	// void CResult_BlindedFailureDecodeErrorZ_free(struct LDKCResult_BlindedFailureDecodeErrorZ _res);
	public static native void CResult_BlindedFailureDecodeErrorZ_free(long _res);
	// uint64_t CResult_BlindedFailureDecodeErrorZ_clone_ptr(LDKCResult_BlindedFailureDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_BlindedFailureDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_BlindedFailureDecodeErrorZ CResult_BlindedFailureDecodeErrorZ_clone(const struct LDKCResult_BlindedFailureDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_BlindedFailureDecodeErrorZ_clone(long orig);
	// void CVec_ChannelMonitorZ_free(struct LDKCVec_ChannelMonitorZ _res);
	public static native void CVec_ChannelMonitorZ_free(long[] _res);
	// struct LDKC2Tuple_ThirtyTwoBytesChannelManagerZ C2Tuple_ThirtyTwoBytesChannelManagerZ_new(struct LDKThirtyTwoBytes a, struct LDKChannelManager b);
	public static native long C2Tuple_ThirtyTwoBytesChannelManagerZ_new(byte[] a, long b);
	// void C2Tuple_ThirtyTwoBytesChannelManagerZ_free(struct LDKC2Tuple_ThirtyTwoBytesChannelManagerZ _res);
	public static native void C2Tuple_ThirtyTwoBytesChannelManagerZ_free(long _res);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ CResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ_ok(struct LDKC2Tuple_ThirtyTwoBytesChannelManagerZ o);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ_ok(long o);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ CResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ_err(long e);
	// bool CResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ_is_ok(const struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ_is_ok(long o);
	// void CResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ_free(struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ _res);
	public static native void CResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ_free(long _res);
	// struct LDKCResult_MaxDustHTLCExposureDecodeErrorZ CResult_MaxDustHTLCExposureDecodeErrorZ_ok(struct LDKMaxDustHTLCExposure o);
	public static native long CResult_MaxDustHTLCExposureDecodeErrorZ_ok(long o);
	// struct LDKCResult_MaxDustHTLCExposureDecodeErrorZ CResult_MaxDustHTLCExposureDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_MaxDustHTLCExposureDecodeErrorZ_err(long e);
	// bool CResult_MaxDustHTLCExposureDecodeErrorZ_is_ok(const struct LDKCResult_MaxDustHTLCExposureDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_MaxDustHTLCExposureDecodeErrorZ_is_ok(long o);
	// void CResult_MaxDustHTLCExposureDecodeErrorZ_free(struct LDKCResult_MaxDustHTLCExposureDecodeErrorZ _res);
	public static native void CResult_MaxDustHTLCExposureDecodeErrorZ_free(long _res);
	// uint64_t CResult_MaxDustHTLCExposureDecodeErrorZ_clone_ptr(LDKCResult_MaxDustHTLCExposureDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_MaxDustHTLCExposureDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_MaxDustHTLCExposureDecodeErrorZ CResult_MaxDustHTLCExposureDecodeErrorZ_clone(const struct LDKCResult_MaxDustHTLCExposureDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_MaxDustHTLCExposureDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ChannelConfigDecodeErrorZ CResult_ChannelConfigDecodeErrorZ_ok(struct LDKChannelConfig o);
	public static native long CResult_ChannelConfigDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelConfigDecodeErrorZ CResult_ChannelConfigDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelConfigDecodeErrorZ_err(long e);
	// bool CResult_ChannelConfigDecodeErrorZ_is_ok(const struct LDKCResult_ChannelConfigDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelConfigDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelConfigDecodeErrorZ_free(struct LDKCResult_ChannelConfigDecodeErrorZ _res);
	public static native void CResult_ChannelConfigDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelConfigDecodeErrorZ_clone_ptr(LDKCResult_ChannelConfigDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelConfigDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelConfigDecodeErrorZ CResult_ChannelConfigDecodeErrorZ_clone(const struct LDKCResult_ChannelConfigDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelConfigDecodeErrorZ_clone(long orig);
	// struct LDKCOption_MaxDustHTLCExposureZ COption_MaxDustHTLCExposureZ_some(struct LDKMaxDustHTLCExposure o);
	public static native long COption_MaxDustHTLCExposureZ_some(long o);
	// struct LDKCOption_MaxDustHTLCExposureZ COption_MaxDustHTLCExposureZ_none(void);
	public static native long COption_MaxDustHTLCExposureZ_none();
	// void COption_MaxDustHTLCExposureZ_free(struct LDKCOption_MaxDustHTLCExposureZ _res);
	public static native void COption_MaxDustHTLCExposureZ_free(long _res);
	// uint64_t COption_MaxDustHTLCExposureZ_clone_ptr(LDKCOption_MaxDustHTLCExposureZ *NONNULL_PTR arg);
	public static native long COption_MaxDustHTLCExposureZ_clone_ptr(long arg);
	// struct LDKCOption_MaxDustHTLCExposureZ COption_MaxDustHTLCExposureZ_clone(const struct LDKCOption_MaxDustHTLCExposureZ *NONNULL_PTR orig);
	public static native long COption_MaxDustHTLCExposureZ_clone(long orig);
	// struct LDKCOption_APIErrorZ COption_APIErrorZ_some(struct LDKAPIError o);
	public static native long COption_APIErrorZ_some(long o);
	// struct LDKCOption_APIErrorZ COption_APIErrorZ_none(void);
	public static native long COption_APIErrorZ_none();
	// void COption_APIErrorZ_free(struct LDKCOption_APIErrorZ _res);
	public static native void COption_APIErrorZ_free(long _res);
	// uint64_t COption_APIErrorZ_clone_ptr(LDKCOption_APIErrorZ *NONNULL_PTR arg);
	public static native long COption_APIErrorZ_clone_ptr(long arg);
	// struct LDKCOption_APIErrorZ COption_APIErrorZ_clone(const struct LDKCOption_APIErrorZ *NONNULL_PTR orig);
	public static native long COption_APIErrorZ_clone(long orig);
	// struct LDKCResult_COption_APIErrorZDecodeErrorZ CResult_COption_APIErrorZDecodeErrorZ_ok(struct LDKCOption_APIErrorZ o);
	public static native long CResult_COption_APIErrorZDecodeErrorZ_ok(long o);
	// struct LDKCResult_COption_APIErrorZDecodeErrorZ CResult_COption_APIErrorZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_COption_APIErrorZDecodeErrorZ_err(long e);
	// bool CResult_COption_APIErrorZDecodeErrorZ_is_ok(const struct LDKCResult_COption_APIErrorZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_COption_APIErrorZDecodeErrorZ_is_ok(long o);
	// void CResult_COption_APIErrorZDecodeErrorZ_free(struct LDKCResult_COption_APIErrorZDecodeErrorZ _res);
	public static native void CResult_COption_APIErrorZDecodeErrorZ_free(long _res);
	// uint64_t CResult_COption_APIErrorZDecodeErrorZ_clone_ptr(LDKCResult_COption_APIErrorZDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_COption_APIErrorZDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_COption_APIErrorZDecodeErrorZ CResult_COption_APIErrorZDecodeErrorZ_clone(const struct LDKCResult_COption_APIErrorZDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_COption_APIErrorZDecodeErrorZ_clone(long orig);
	// void CVec_LSPS2RawOpeningFeeParamsZ_free(struct LDKCVec_LSPS2RawOpeningFeeParamsZ _res);
	public static native void CVec_LSPS2RawOpeningFeeParamsZ_free(long[] _res);
	// struct LDKCResult_ChannelMonitorUpdateDecodeErrorZ CResult_ChannelMonitorUpdateDecodeErrorZ_ok(struct LDKChannelMonitorUpdate o);
	public static native long CResult_ChannelMonitorUpdateDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelMonitorUpdateDecodeErrorZ CResult_ChannelMonitorUpdateDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelMonitorUpdateDecodeErrorZ_err(long e);
	// bool CResult_ChannelMonitorUpdateDecodeErrorZ_is_ok(const struct LDKCResult_ChannelMonitorUpdateDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelMonitorUpdateDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelMonitorUpdateDecodeErrorZ_free(struct LDKCResult_ChannelMonitorUpdateDecodeErrorZ _res);
	public static native void CResult_ChannelMonitorUpdateDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelMonitorUpdateDecodeErrorZ_clone_ptr(LDKCResult_ChannelMonitorUpdateDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelMonitorUpdateDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelMonitorUpdateDecodeErrorZ CResult_ChannelMonitorUpdateDecodeErrorZ_clone(const struct LDKCResult_ChannelMonitorUpdateDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelMonitorUpdateDecodeErrorZ_clone(long orig);
	// struct LDKCOption_MonitorEventZ COption_MonitorEventZ_some(struct LDKMonitorEvent o);
	public static native long COption_MonitorEventZ_some(long o);
	// struct LDKCOption_MonitorEventZ COption_MonitorEventZ_none(void);
	public static native long COption_MonitorEventZ_none();
	// void COption_MonitorEventZ_free(struct LDKCOption_MonitorEventZ _res);
	public static native void COption_MonitorEventZ_free(long _res);
	// uint64_t COption_MonitorEventZ_clone_ptr(LDKCOption_MonitorEventZ *NONNULL_PTR arg);
	public static native long COption_MonitorEventZ_clone_ptr(long arg);
	// struct LDKCOption_MonitorEventZ COption_MonitorEventZ_clone(const struct LDKCOption_MonitorEventZ *NONNULL_PTR orig);
	public static native long COption_MonitorEventZ_clone(long orig);
	// struct LDKCResult_COption_MonitorEventZDecodeErrorZ CResult_COption_MonitorEventZDecodeErrorZ_ok(struct LDKCOption_MonitorEventZ o);
	public static native long CResult_COption_MonitorEventZDecodeErrorZ_ok(long o);
	// struct LDKCResult_COption_MonitorEventZDecodeErrorZ CResult_COption_MonitorEventZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_COption_MonitorEventZDecodeErrorZ_err(long e);
	// bool CResult_COption_MonitorEventZDecodeErrorZ_is_ok(const struct LDKCResult_COption_MonitorEventZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_COption_MonitorEventZDecodeErrorZ_is_ok(long o);
	// void CResult_COption_MonitorEventZDecodeErrorZ_free(struct LDKCResult_COption_MonitorEventZDecodeErrorZ _res);
	public static native void CResult_COption_MonitorEventZDecodeErrorZ_free(long _res);
	// uint64_t CResult_COption_MonitorEventZDecodeErrorZ_clone_ptr(LDKCResult_COption_MonitorEventZDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_COption_MonitorEventZDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_COption_MonitorEventZDecodeErrorZ CResult_COption_MonitorEventZDecodeErrorZ_clone(const struct LDKCResult_COption_MonitorEventZDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_COption_MonitorEventZDecodeErrorZ_clone(long orig);
	// struct LDKCResult_HTLCUpdateDecodeErrorZ CResult_HTLCUpdateDecodeErrorZ_ok(struct LDKHTLCUpdate o);
	public static native long CResult_HTLCUpdateDecodeErrorZ_ok(long o);
	// struct LDKCResult_HTLCUpdateDecodeErrorZ CResult_HTLCUpdateDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_HTLCUpdateDecodeErrorZ_err(long e);
	// bool CResult_HTLCUpdateDecodeErrorZ_is_ok(const struct LDKCResult_HTLCUpdateDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_HTLCUpdateDecodeErrorZ_is_ok(long o);
	// void CResult_HTLCUpdateDecodeErrorZ_free(struct LDKCResult_HTLCUpdateDecodeErrorZ _res);
	public static native void CResult_HTLCUpdateDecodeErrorZ_free(long _res);
	// uint64_t CResult_HTLCUpdateDecodeErrorZ_clone_ptr(LDKCResult_HTLCUpdateDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_HTLCUpdateDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_HTLCUpdateDecodeErrorZ CResult_HTLCUpdateDecodeErrorZ_clone(const struct LDKCResult_HTLCUpdateDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_HTLCUpdateDecodeErrorZ_clone(long orig);
	// uint64_t C2Tuple_OutPointCVec_u8ZZ_clone_ptr(LDKC2Tuple_OutPointCVec_u8ZZ *NONNULL_PTR arg);
	public static native long C2Tuple_OutPointCVec_u8ZZ_clone_ptr(long arg);
	// struct LDKC2Tuple_OutPointCVec_u8ZZ C2Tuple_OutPointCVec_u8ZZ_clone(const struct LDKC2Tuple_OutPointCVec_u8ZZ *NONNULL_PTR orig);
	public static native long C2Tuple_OutPointCVec_u8ZZ_clone(long orig);
	// struct LDKC2Tuple_OutPointCVec_u8ZZ C2Tuple_OutPointCVec_u8ZZ_new(struct LDKOutPoint a, struct LDKCVec_u8Z b);
	public static native long C2Tuple_OutPointCVec_u8ZZ_new(long a, byte[] b);
	// void C2Tuple_OutPointCVec_u8ZZ_free(struct LDKC2Tuple_OutPointCVec_u8ZZ _res);
	public static native void C2Tuple_OutPointCVec_u8ZZ_free(long _res);
	// uint64_t C2Tuple_u32CVec_u8ZZ_clone_ptr(LDKC2Tuple_u32CVec_u8ZZ *NONNULL_PTR arg);
	public static native long C2Tuple_u32CVec_u8ZZ_clone_ptr(long arg);
	// struct LDKC2Tuple_u32CVec_u8ZZ C2Tuple_u32CVec_u8ZZ_clone(const struct LDKC2Tuple_u32CVec_u8ZZ *NONNULL_PTR orig);
	public static native long C2Tuple_u32CVec_u8ZZ_clone(long orig);
	// struct LDKC2Tuple_u32CVec_u8ZZ C2Tuple_u32CVec_u8ZZ_new(uint32_t a, struct LDKCVec_u8Z b);
	public static native long C2Tuple_u32CVec_u8ZZ_new(int a, byte[] b);
	// void C2Tuple_u32CVec_u8ZZ_free(struct LDKC2Tuple_u32CVec_u8ZZ _res);
	public static native void C2Tuple_u32CVec_u8ZZ_free(long _res);
	// void CVec_C2Tuple_u32CVec_u8ZZZ_free(struct LDKCVec_C2Tuple_u32CVec_u8ZZZ _res);
	public static native void CVec_C2Tuple_u32CVec_u8ZZZ_free(long[] _res);
	// uint64_t C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ_clone_ptr(LDKC2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ *NONNULL_PTR arg);
	public static native long C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ_clone_ptr(long arg);
	// struct LDKC2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ_clone(const struct LDKC2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ *NONNULL_PTR orig);
	public static native long C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ_clone(long orig);
	// struct LDKC2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ_new(struct LDKThirtyTwoBytes a, struct LDKCVec_C2Tuple_u32CVec_u8ZZZ b);
	public static native long C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ_new(byte[] a, long[] b);
	// void C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ_free(struct LDKC2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ _res);
	public static native void C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ_free(long _res);
	// void CVec_C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZZ_free(struct LDKCVec_C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZZ _res);
	public static native void CVec_C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZZ_free(long[] _res);
	// struct LDKCResult_NoneReplayEventZ CResult_NoneReplayEventZ_ok(void);
	public static native long CResult_NoneReplayEventZ_ok();
	// struct LDKCResult_NoneReplayEventZ CResult_NoneReplayEventZ_err(struct LDKReplayEvent e);
	public static native long CResult_NoneReplayEventZ_err(long e);
	// bool CResult_NoneReplayEventZ_is_ok(const struct LDKCResult_NoneReplayEventZ *NONNULL_PTR o);
	public static native boolean CResult_NoneReplayEventZ_is_ok(long o);
	// void CResult_NoneReplayEventZ_free(struct LDKCResult_NoneReplayEventZ _res);
	public static native void CResult_NoneReplayEventZ_free(long _res);
	// uint64_t CResult_NoneReplayEventZ_clone_ptr(LDKCResult_NoneReplayEventZ *NONNULL_PTR arg);
	public static native long CResult_NoneReplayEventZ_clone_ptr(long arg);
	// struct LDKCResult_NoneReplayEventZ CResult_NoneReplayEventZ_clone(const struct LDKCResult_NoneReplayEventZ *NONNULL_PTR orig);
	public static native long CResult_NoneReplayEventZ_clone(long orig);
	// void CVec_CommitmentTransactionZ_free(struct LDKCVec_CommitmentTransactionZ _res);
	public static native void CVec_CommitmentTransactionZ_free(long[] _res);
	// uint64_t C2Tuple_u32TxOutZ_clone_ptr(LDKC2Tuple_u32TxOutZ *NONNULL_PTR arg);
	public static native long C2Tuple_u32TxOutZ_clone_ptr(long arg);
	// struct LDKC2Tuple_u32TxOutZ C2Tuple_u32TxOutZ_clone(const struct LDKC2Tuple_u32TxOutZ *NONNULL_PTR orig);
	public static native long C2Tuple_u32TxOutZ_clone(long orig);
	// struct LDKC2Tuple_u32TxOutZ C2Tuple_u32TxOutZ_new(uint32_t a, struct LDKTxOut b);
	public static native long C2Tuple_u32TxOutZ_new(int a, long b);
	// void C2Tuple_u32TxOutZ_free(struct LDKC2Tuple_u32TxOutZ _res);
	public static native void C2Tuple_u32TxOutZ_free(long _res);
	// void CVec_C2Tuple_u32TxOutZZ_free(struct LDKCVec_C2Tuple_u32TxOutZZ _res);
	public static native void CVec_C2Tuple_u32TxOutZZ_free(long[] _res);
	// uint64_t C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ_clone_ptr(LDKC2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ *NONNULL_PTR arg);
	public static native long C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ_clone_ptr(long arg);
	// struct LDKC2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ_clone(const struct LDKC2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ *NONNULL_PTR orig);
	public static native long C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ_clone(long orig);
	// struct LDKC2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ_new(struct LDKThirtyTwoBytes a, struct LDKCVec_C2Tuple_u32TxOutZZ b);
	public static native long C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ_new(byte[] a, long[] b);
	// void C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ_free(struct LDKC2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ _res);
	public static native void C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ_free(long _res);
	// void CVec_C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZZ_free(struct LDKCVec_C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZZ _res);
	public static native void CVec_C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZZ_free(long[] _res);
	// uint64_t C2Tuple_boolboolZ_clone_ptr(LDKC2Tuple_boolboolZ *NONNULL_PTR arg);
	public static native long C2Tuple_boolboolZ_clone_ptr(long arg);
	// struct LDKC2Tuple_boolboolZ C2Tuple_boolboolZ_clone(const struct LDKC2Tuple_boolboolZ *NONNULL_PTR orig);
	public static native long C2Tuple_boolboolZ_clone(long orig);
	// struct LDKC2Tuple_boolboolZ C2Tuple_boolboolZ_new(bool a, bool b);
	public static native long C2Tuple_boolboolZ_new(boolean a, boolean b);
	// void C2Tuple_boolboolZ_free(struct LDKC2Tuple_boolboolZ _res);
	public static native void C2Tuple_boolboolZ_free(long _res);
	// void CVec_BalanceZ_free(struct LDKCVec_BalanceZ _res);
	public static native void CVec_BalanceZ_free(long[] _res);
	// uint64_t C2Tuple_ThirtyTwoBytesChannelMonitorZ_clone_ptr(LDKC2Tuple_ThirtyTwoBytesChannelMonitorZ *NONNULL_PTR arg);
	public static native long C2Tuple_ThirtyTwoBytesChannelMonitorZ_clone_ptr(long arg);
	// struct LDKC2Tuple_ThirtyTwoBytesChannelMonitorZ C2Tuple_ThirtyTwoBytesChannelMonitorZ_clone(const struct LDKC2Tuple_ThirtyTwoBytesChannelMonitorZ *NONNULL_PTR orig);
	public static native long C2Tuple_ThirtyTwoBytesChannelMonitorZ_clone(long orig);
	// struct LDKC2Tuple_ThirtyTwoBytesChannelMonitorZ C2Tuple_ThirtyTwoBytesChannelMonitorZ_new(struct LDKThirtyTwoBytes a, struct LDKChannelMonitor b);
	public static native long C2Tuple_ThirtyTwoBytesChannelMonitorZ_new(byte[] a, long b);
	// void C2Tuple_ThirtyTwoBytesChannelMonitorZ_free(struct LDKC2Tuple_ThirtyTwoBytesChannelMonitorZ _res);
	public static native void C2Tuple_ThirtyTwoBytesChannelMonitorZ_free(long _res);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_ok(struct LDKC2Tuple_ThirtyTwoBytesChannelMonitorZ o);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_ok(long o);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_err(long e);
	// bool CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_is_ok(const struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_is_ok(long o);
	// void CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_free(struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ _res);
	public static native void CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_free(long _res);
	// uint64_t CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_clone_ptr(LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_clone(const struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_clone(long orig);
	// uint64_t C2Tuple_PublicKeyTypeZ_clone_ptr(LDKC2Tuple_PublicKeyTypeZ *NONNULL_PTR arg);
	public static native long C2Tuple_PublicKeyTypeZ_clone_ptr(long arg);
	// struct LDKC2Tuple_PublicKeyTypeZ C2Tuple_PublicKeyTypeZ_clone(const struct LDKC2Tuple_PublicKeyTypeZ *NONNULL_PTR orig);
	public static native long C2Tuple_PublicKeyTypeZ_clone(long orig);
	// struct LDKC2Tuple_PublicKeyTypeZ C2Tuple_PublicKeyTypeZ_new(struct LDKPublicKey a, struct LDKType b);
	public static native long C2Tuple_PublicKeyTypeZ_new(byte[] a, long b);
	// void C2Tuple_PublicKeyTypeZ_free(struct LDKC2Tuple_PublicKeyTypeZ _res);
	public static native void C2Tuple_PublicKeyTypeZ_free(long _res);
	// void CVec_C2Tuple_PublicKeyTypeZZ_free(struct LDKCVec_C2Tuple_PublicKeyTypeZZ _res);
	public static native void CVec_C2Tuple_PublicKeyTypeZZ_free(long[] _res);
	// uint64_t C2Tuple_OnionMessageContentsResponseInstructionZ_clone_ptr(LDKC2Tuple_OnionMessageContentsResponseInstructionZ *NONNULL_PTR arg);
	public static native long C2Tuple_OnionMessageContentsResponseInstructionZ_clone_ptr(long arg);
	// struct LDKC2Tuple_OnionMessageContentsResponseInstructionZ C2Tuple_OnionMessageContentsResponseInstructionZ_clone(const struct LDKC2Tuple_OnionMessageContentsResponseInstructionZ *NONNULL_PTR orig);
	public static native long C2Tuple_OnionMessageContentsResponseInstructionZ_clone(long orig);
	// struct LDKC2Tuple_OnionMessageContentsResponseInstructionZ C2Tuple_OnionMessageContentsResponseInstructionZ_new(struct LDKOnionMessageContents a, struct LDKResponseInstruction b);
	public static native long C2Tuple_OnionMessageContentsResponseInstructionZ_new(long a, long b);
	// void C2Tuple_OnionMessageContentsResponseInstructionZ_free(struct LDKC2Tuple_OnionMessageContentsResponseInstructionZ _res);
	public static native void C2Tuple_OnionMessageContentsResponseInstructionZ_free(long _res);
	// struct LDKCOption_C2Tuple_OnionMessageContentsResponseInstructionZZ COption_C2Tuple_OnionMessageContentsResponseInstructionZZ_some(struct LDKC2Tuple_OnionMessageContentsResponseInstructionZ o);
	public static native long COption_C2Tuple_OnionMessageContentsResponseInstructionZZ_some(long o);
	// struct LDKCOption_C2Tuple_OnionMessageContentsResponseInstructionZZ COption_C2Tuple_OnionMessageContentsResponseInstructionZZ_none(void);
	public static native long COption_C2Tuple_OnionMessageContentsResponseInstructionZZ_none();
	// void COption_C2Tuple_OnionMessageContentsResponseInstructionZZ_free(struct LDKCOption_C2Tuple_OnionMessageContentsResponseInstructionZZ _res);
	public static native void COption_C2Tuple_OnionMessageContentsResponseInstructionZZ_free(long _res);
	// uint64_t COption_C2Tuple_OnionMessageContentsResponseInstructionZZ_clone_ptr(LDKCOption_C2Tuple_OnionMessageContentsResponseInstructionZZ *NONNULL_PTR arg);
	public static native long COption_C2Tuple_OnionMessageContentsResponseInstructionZZ_clone_ptr(long arg);
	// struct LDKCOption_C2Tuple_OnionMessageContentsResponseInstructionZZ COption_C2Tuple_OnionMessageContentsResponseInstructionZZ_clone(const struct LDKCOption_C2Tuple_OnionMessageContentsResponseInstructionZZ *NONNULL_PTR orig);
	public static native long COption_C2Tuple_OnionMessageContentsResponseInstructionZZ_clone(long orig);
	// struct LDKCOption_OnionMessageContentsZ COption_OnionMessageContentsZ_some(struct LDKOnionMessageContents o);
	public static native long COption_OnionMessageContentsZ_some(long o);
	// struct LDKCOption_OnionMessageContentsZ COption_OnionMessageContentsZ_none(void);
	public static native long COption_OnionMessageContentsZ_none();
	// void COption_OnionMessageContentsZ_free(struct LDKCOption_OnionMessageContentsZ _res);
	public static native void COption_OnionMessageContentsZ_free(long _res);
	// uint64_t COption_OnionMessageContentsZ_clone_ptr(LDKCOption_OnionMessageContentsZ *NONNULL_PTR arg);
	public static native long COption_OnionMessageContentsZ_clone_ptr(long arg);
	// struct LDKCOption_OnionMessageContentsZ COption_OnionMessageContentsZ_clone(const struct LDKCOption_OnionMessageContentsZ *NONNULL_PTR orig);
	public static native long COption_OnionMessageContentsZ_clone(long orig);
	// struct LDKCResult_COption_OnionMessageContentsZDecodeErrorZ CResult_COption_OnionMessageContentsZDecodeErrorZ_ok(struct LDKCOption_OnionMessageContentsZ o);
	public static native long CResult_COption_OnionMessageContentsZDecodeErrorZ_ok(long o);
	// struct LDKCResult_COption_OnionMessageContentsZDecodeErrorZ CResult_COption_OnionMessageContentsZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_COption_OnionMessageContentsZDecodeErrorZ_err(long e);
	// bool CResult_COption_OnionMessageContentsZDecodeErrorZ_is_ok(const struct LDKCResult_COption_OnionMessageContentsZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_COption_OnionMessageContentsZDecodeErrorZ_is_ok(long o);
	// void CResult_COption_OnionMessageContentsZDecodeErrorZ_free(struct LDKCResult_COption_OnionMessageContentsZDecodeErrorZ _res);
	public static native void CResult_COption_OnionMessageContentsZDecodeErrorZ_free(long _res);
	// uint64_t CResult_COption_OnionMessageContentsZDecodeErrorZ_clone_ptr(LDKCResult_COption_OnionMessageContentsZDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_COption_OnionMessageContentsZDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_COption_OnionMessageContentsZDecodeErrorZ CResult_COption_OnionMessageContentsZDecodeErrorZ_clone(const struct LDKCResult_COption_OnionMessageContentsZDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_COption_OnionMessageContentsZDecodeErrorZ_clone(long orig);
	// uint64_t C2Tuple_OnionMessageContentsMessageSendInstructionsZ_clone_ptr(LDKC2Tuple_OnionMessageContentsMessageSendInstructionsZ *NONNULL_PTR arg);
	public static native long C2Tuple_OnionMessageContentsMessageSendInstructionsZ_clone_ptr(long arg);
	// struct LDKC2Tuple_OnionMessageContentsMessageSendInstructionsZ C2Tuple_OnionMessageContentsMessageSendInstructionsZ_clone(const struct LDKC2Tuple_OnionMessageContentsMessageSendInstructionsZ *NONNULL_PTR orig);
	public static native long C2Tuple_OnionMessageContentsMessageSendInstructionsZ_clone(long orig);
	// struct LDKC2Tuple_OnionMessageContentsMessageSendInstructionsZ C2Tuple_OnionMessageContentsMessageSendInstructionsZ_new(struct LDKOnionMessageContents a, struct LDKMessageSendInstructions b);
	public static native long C2Tuple_OnionMessageContentsMessageSendInstructionsZ_new(long a, long b);
	// void C2Tuple_OnionMessageContentsMessageSendInstructionsZ_free(struct LDKC2Tuple_OnionMessageContentsMessageSendInstructionsZ _res);
	public static native void C2Tuple_OnionMessageContentsMessageSendInstructionsZ_free(long _res);
	// void CVec_C2Tuple_OnionMessageContentsMessageSendInstructionsZZ_free(struct LDKCVec_C2Tuple_OnionMessageContentsMessageSendInstructionsZZ _res);
	public static native void CVec_C2Tuple_OnionMessageContentsMessageSendInstructionsZZ_free(long[] _res);
	// struct LDKCOption_TypeZ COption_TypeZ_some(struct LDKType o);
	public static native long COption_TypeZ_some(long o);
	// struct LDKCOption_TypeZ COption_TypeZ_none(void);
	public static native long COption_TypeZ_none();
	// void COption_TypeZ_free(struct LDKCOption_TypeZ _res);
	public static native void COption_TypeZ_free(long _res);
	// uint64_t COption_TypeZ_clone_ptr(LDKCOption_TypeZ *NONNULL_PTR arg);
	public static native long COption_TypeZ_clone_ptr(long arg);
	// struct LDKCOption_TypeZ COption_TypeZ_clone(const struct LDKCOption_TypeZ *NONNULL_PTR orig);
	public static native long COption_TypeZ_clone(long orig);
	// struct LDKCResult_COption_TypeZDecodeErrorZ CResult_COption_TypeZDecodeErrorZ_ok(struct LDKCOption_TypeZ o);
	public static native long CResult_COption_TypeZDecodeErrorZ_ok(long o);
	// struct LDKCResult_COption_TypeZDecodeErrorZ CResult_COption_TypeZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_COption_TypeZDecodeErrorZ_err(long e);
	// bool CResult_COption_TypeZDecodeErrorZ_is_ok(const struct LDKCResult_COption_TypeZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_COption_TypeZDecodeErrorZ_is_ok(long o);
	// void CResult_COption_TypeZDecodeErrorZ_free(struct LDKCResult_COption_TypeZDecodeErrorZ _res);
	public static native void CResult_COption_TypeZDecodeErrorZ_free(long _res);
	// uint64_t CResult_COption_TypeZDecodeErrorZ_clone_ptr(LDKCResult_COption_TypeZDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_COption_TypeZDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_COption_TypeZDecodeErrorZ CResult_COption_TypeZDecodeErrorZ_clone(const struct LDKCResult_COption_TypeZDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_COption_TypeZDecodeErrorZ_clone(long orig);
	// struct LDKCOption_SocketAddressZ COption_SocketAddressZ_some(struct LDKSocketAddress o);
	public static native long COption_SocketAddressZ_some(long o);
	// struct LDKCOption_SocketAddressZ COption_SocketAddressZ_none(void);
	public static native long COption_SocketAddressZ_none();
	// void COption_SocketAddressZ_free(struct LDKCOption_SocketAddressZ _res);
	public static native void COption_SocketAddressZ_free(long _res);
	// uint64_t COption_SocketAddressZ_clone_ptr(LDKCOption_SocketAddressZ *NONNULL_PTR arg);
	public static native long COption_SocketAddressZ_clone_ptr(long arg);
	// struct LDKCOption_SocketAddressZ COption_SocketAddressZ_clone(const struct LDKCOption_SocketAddressZ *NONNULL_PTR orig);
	public static native long COption_SocketAddressZ_clone(long orig);
	// void CVec_PeerDetailsZ_free(struct LDKCVec_PeerDetailsZ _res);
	public static native void CVec_PeerDetailsZ_free(long[] _res);
	// struct LDKCResult_CVec_u8ZPeerHandleErrorZ CResult_CVec_u8ZPeerHandleErrorZ_ok(struct LDKCVec_u8Z o);
	public static native long CResult_CVec_u8ZPeerHandleErrorZ_ok(byte[] o);
	// struct LDKCResult_CVec_u8ZPeerHandleErrorZ CResult_CVec_u8ZPeerHandleErrorZ_err(struct LDKPeerHandleError e);
	public static native long CResult_CVec_u8ZPeerHandleErrorZ_err(long e);
	// bool CResult_CVec_u8ZPeerHandleErrorZ_is_ok(const struct LDKCResult_CVec_u8ZPeerHandleErrorZ *NONNULL_PTR o);
	public static native boolean CResult_CVec_u8ZPeerHandleErrorZ_is_ok(long o);
	// void CResult_CVec_u8ZPeerHandleErrorZ_free(struct LDKCResult_CVec_u8ZPeerHandleErrorZ _res);
	public static native void CResult_CVec_u8ZPeerHandleErrorZ_free(long _res);
	// uint64_t CResult_CVec_u8ZPeerHandleErrorZ_clone_ptr(LDKCResult_CVec_u8ZPeerHandleErrorZ *NONNULL_PTR arg);
	public static native long CResult_CVec_u8ZPeerHandleErrorZ_clone_ptr(long arg);
	// struct LDKCResult_CVec_u8ZPeerHandleErrorZ CResult_CVec_u8ZPeerHandleErrorZ_clone(const struct LDKCResult_CVec_u8ZPeerHandleErrorZ *NONNULL_PTR orig);
	public static native long CResult_CVec_u8ZPeerHandleErrorZ_clone(long orig);
	// struct LDKCResult_NonePeerHandleErrorZ CResult_NonePeerHandleErrorZ_ok(void);
	public static native long CResult_NonePeerHandleErrorZ_ok();
	// struct LDKCResult_NonePeerHandleErrorZ CResult_NonePeerHandleErrorZ_err(struct LDKPeerHandleError e);
	public static native long CResult_NonePeerHandleErrorZ_err(long e);
	// bool CResult_NonePeerHandleErrorZ_is_ok(const struct LDKCResult_NonePeerHandleErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NonePeerHandleErrorZ_is_ok(long o);
	// void CResult_NonePeerHandleErrorZ_free(struct LDKCResult_NonePeerHandleErrorZ _res);
	public static native void CResult_NonePeerHandleErrorZ_free(long _res);
	// uint64_t CResult_NonePeerHandleErrorZ_clone_ptr(LDKCResult_NonePeerHandleErrorZ *NONNULL_PTR arg);
	public static native long CResult_NonePeerHandleErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NonePeerHandleErrorZ CResult_NonePeerHandleErrorZ_clone(const struct LDKCResult_NonePeerHandleErrorZ *NONNULL_PTR orig);
	public static native long CResult_NonePeerHandleErrorZ_clone(long orig);
	// struct LDKCResult_boolPeerHandleErrorZ CResult_boolPeerHandleErrorZ_ok(bool o);
	public static native long CResult_boolPeerHandleErrorZ_ok(boolean o);
	// struct LDKCResult_boolPeerHandleErrorZ CResult_boolPeerHandleErrorZ_err(struct LDKPeerHandleError e);
	public static native long CResult_boolPeerHandleErrorZ_err(long e);
	// bool CResult_boolPeerHandleErrorZ_is_ok(const struct LDKCResult_boolPeerHandleErrorZ *NONNULL_PTR o);
	public static native boolean CResult_boolPeerHandleErrorZ_is_ok(long o);
	// void CResult_boolPeerHandleErrorZ_free(struct LDKCResult_boolPeerHandleErrorZ _res);
	public static native void CResult_boolPeerHandleErrorZ_free(long _res);
	// uint64_t CResult_boolPeerHandleErrorZ_clone_ptr(LDKCResult_boolPeerHandleErrorZ *NONNULL_PTR arg);
	public static native long CResult_boolPeerHandleErrorZ_clone_ptr(long arg);
	// struct LDKCResult_boolPeerHandleErrorZ CResult_boolPeerHandleErrorZ_clone(const struct LDKCResult_boolPeerHandleErrorZ *NONNULL_PTR orig);
	public static native long CResult_boolPeerHandleErrorZ_clone(long orig);
	// struct LDKCResult_u32GraphSyncErrorZ CResult_u32GraphSyncErrorZ_ok(uint32_t o);
	public static native long CResult_u32GraphSyncErrorZ_ok(int o);
	// struct LDKCResult_u32GraphSyncErrorZ CResult_u32GraphSyncErrorZ_err(struct LDKGraphSyncError e);
	public static native long CResult_u32GraphSyncErrorZ_err(long e);
	// bool CResult_u32GraphSyncErrorZ_is_ok(const struct LDKCResult_u32GraphSyncErrorZ *NONNULL_PTR o);
	public static native boolean CResult_u32GraphSyncErrorZ_is_ok(long o);
	// void CResult_u32GraphSyncErrorZ_free(struct LDKCResult_u32GraphSyncErrorZ _res);
	public static native void CResult_u32GraphSyncErrorZ_free(long _res);
	// struct LDKCResult_CVec_u8ZIOErrorZ CResult_CVec_u8ZIOErrorZ_ok(struct LDKCVec_u8Z o);
	public static native long CResult_CVec_u8ZIOErrorZ_ok(byte[] o);
	// struct LDKCResult_CVec_u8ZIOErrorZ CResult_CVec_u8ZIOErrorZ_err(enum LDKIOError e);
	public static native long CResult_CVec_u8ZIOErrorZ_err(IOError e);
	// bool CResult_CVec_u8ZIOErrorZ_is_ok(const struct LDKCResult_CVec_u8ZIOErrorZ *NONNULL_PTR o);
	public static native boolean CResult_CVec_u8ZIOErrorZ_is_ok(long o);
	// void CResult_CVec_u8ZIOErrorZ_free(struct LDKCResult_CVec_u8ZIOErrorZ _res);
	public static native void CResult_CVec_u8ZIOErrorZ_free(long _res);
	// uint64_t CResult_CVec_u8ZIOErrorZ_clone_ptr(LDKCResult_CVec_u8ZIOErrorZ *NONNULL_PTR arg);
	public static native long CResult_CVec_u8ZIOErrorZ_clone_ptr(long arg);
	// struct LDKCResult_CVec_u8ZIOErrorZ CResult_CVec_u8ZIOErrorZ_clone(const struct LDKCResult_CVec_u8ZIOErrorZ *NONNULL_PTR orig);
	public static native long CResult_CVec_u8ZIOErrorZ_clone(long orig);
	// void CVec_StrZ_free(struct LDKCVec_StrZ _res);
	public static native void CVec_StrZ_free(String[] _res);
	// struct LDKCResult_CVec_StrZIOErrorZ CResult_CVec_StrZIOErrorZ_ok(struct LDKCVec_StrZ o);
	public static native long CResult_CVec_StrZIOErrorZ_ok(String[] o);
	// struct LDKCResult_CVec_StrZIOErrorZ CResult_CVec_StrZIOErrorZ_err(enum LDKIOError e);
	public static native long CResult_CVec_StrZIOErrorZ_err(IOError e);
	// bool CResult_CVec_StrZIOErrorZ_is_ok(const struct LDKCResult_CVec_StrZIOErrorZ *NONNULL_PTR o);
	public static native boolean CResult_CVec_StrZIOErrorZ_is_ok(long o);
	// void CResult_CVec_StrZIOErrorZ_free(struct LDKCResult_CVec_StrZIOErrorZ _res);
	public static native void CResult_CVec_StrZIOErrorZ_free(long _res);
	// uint64_t CResult_CVec_StrZIOErrorZ_clone_ptr(LDKCResult_CVec_StrZIOErrorZ *NONNULL_PTR arg);
	public static native long CResult_CVec_StrZIOErrorZ_clone_ptr(long arg);
	// struct LDKCResult_CVec_StrZIOErrorZ CResult_CVec_StrZIOErrorZ_clone(const struct LDKCResult_CVec_StrZIOErrorZ *NONNULL_PTR orig);
	public static native long CResult_CVec_StrZIOErrorZ_clone(long orig);
	// uint64_t C3Tuple_StrStrStrZ_clone_ptr(LDKC3Tuple_StrStrStrZ *NONNULL_PTR arg);
	public static native long C3Tuple_StrStrStrZ_clone_ptr(long arg);
	// struct LDKC3Tuple_StrStrStrZ C3Tuple_StrStrStrZ_clone(const struct LDKC3Tuple_StrStrStrZ *NONNULL_PTR orig);
	public static native long C3Tuple_StrStrStrZ_clone(long orig);
	// struct LDKC3Tuple_StrStrStrZ C3Tuple_StrStrStrZ_new(struct LDKStr a, struct LDKStr b, struct LDKStr c);
	public static native long C3Tuple_StrStrStrZ_new(String a, String b, String c);
	// void C3Tuple_StrStrStrZ_free(struct LDKC3Tuple_StrStrStrZ _res);
	public static native void C3Tuple_StrStrStrZ_free(long _res);
	// void CVec_C3Tuple_StrStrStrZZ_free(struct LDKCVec_C3Tuple_StrStrStrZZ _res);
	public static native void CVec_C3Tuple_StrStrStrZZ_free(long[] _res);
	// struct LDKCResult_CVec_C3Tuple_StrStrStrZZIOErrorZ CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_ok(struct LDKCVec_C3Tuple_StrStrStrZZ o);
	public static native long CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_ok(long[] o);
	// struct LDKCResult_CVec_C3Tuple_StrStrStrZZIOErrorZ CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_err(enum LDKIOError e);
	public static native long CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_err(IOError e);
	// bool CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_is_ok(const struct LDKCResult_CVec_C3Tuple_StrStrStrZZIOErrorZ *NONNULL_PTR o);
	public static native boolean CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_is_ok(long o);
	// void CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_free(struct LDKCResult_CVec_C3Tuple_StrStrStrZZIOErrorZ _res);
	public static native void CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_free(long _res);
	// uint64_t CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_clone_ptr(LDKCResult_CVec_C3Tuple_StrStrStrZZIOErrorZ *NONNULL_PTR arg);
	public static native long CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_clone_ptr(long arg);
	// struct LDKCResult_CVec_C3Tuple_StrStrStrZZIOErrorZ CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_clone(const struct LDKCResult_CVec_C3Tuple_StrStrStrZZIOErrorZ *NONNULL_PTR orig);
	public static native long CResult_CVec_C3Tuple_StrStrStrZZIOErrorZ_clone(long orig);
	// void CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZ_free(struct LDKCVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZ _res);
	public static native void CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZ_free(long[] _res);
	// struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_ok(struct LDKCVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZ o);
	public static native long CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_ok(long[] o);
	// struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_err(enum LDKIOError e);
	public static native long CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_err(IOError e);
	// bool CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_is_ok(const struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ *NONNULL_PTR o);
	public static native boolean CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_is_ok(long o);
	// void CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_free(struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ _res);
	public static native void CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_free(long _res);
	// uint64_t CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_clone_ptr(LDKCResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ *NONNULL_PTR arg);
	public static native long CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_clone_ptr(long arg);
	// struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_clone(const struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ *NONNULL_PTR orig);
	public static native long CResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ_clone(long orig);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_ok(struct LDKC2Tuple_ThirtyTwoBytesChannelMonitorZ o);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_ok(long o);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_err(enum LDKIOError e);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_err(IOError e);
	// bool CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_is_ok(const struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ *NONNULL_PTR o);
	public static native boolean CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_is_ok(long o);
	// void CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_free(struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ _res);
	public static native void CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_free(long _res);
	// uint64_t CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_clone_ptr(LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ *NONNULL_PTR arg);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_clone_ptr(long arg);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_clone(const struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ *NONNULL_PTR orig);
	public static native long CResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ_clone(long orig);
	// struct LDKCResult_MonitorNameIOErrorZ CResult_MonitorNameIOErrorZ_ok(struct LDKMonitorName o);
	public static native long CResult_MonitorNameIOErrorZ_ok(long o);
	// struct LDKCResult_MonitorNameIOErrorZ CResult_MonitorNameIOErrorZ_err(enum LDKIOError e);
	public static native long CResult_MonitorNameIOErrorZ_err(IOError e);
	// bool CResult_MonitorNameIOErrorZ_is_ok(const struct LDKCResult_MonitorNameIOErrorZ *NONNULL_PTR o);
	public static native boolean CResult_MonitorNameIOErrorZ_is_ok(long o);
	// void CResult_MonitorNameIOErrorZ_free(struct LDKCResult_MonitorNameIOErrorZ _res);
	public static native void CResult_MonitorNameIOErrorZ_free(long _res);
	// struct LDKCResult_UpdateNameIOErrorZ CResult_UpdateNameIOErrorZ_ok(struct LDKUpdateName o);
	public static native long CResult_UpdateNameIOErrorZ_ok(long o);
	// struct LDKCResult_UpdateNameIOErrorZ CResult_UpdateNameIOErrorZ_err(enum LDKIOError e);
	public static native long CResult_UpdateNameIOErrorZ_err(IOError e);
	// bool CResult_UpdateNameIOErrorZ_is_ok(const struct LDKCResult_UpdateNameIOErrorZ *NONNULL_PTR o);
	public static native boolean CResult_UpdateNameIOErrorZ_is_ok(long o);
	// void CResult_UpdateNameIOErrorZ_free(struct LDKCResult_UpdateNameIOErrorZ _res);
	public static native void CResult_UpdateNameIOErrorZ_free(long _res);
	// struct LDKCResult_InvoiceRequestBolt12SemanticErrorZ CResult_InvoiceRequestBolt12SemanticErrorZ_ok(struct LDKInvoiceRequest o);
	public static native long CResult_InvoiceRequestBolt12SemanticErrorZ_ok(long o);
	// struct LDKCResult_InvoiceRequestBolt12SemanticErrorZ CResult_InvoiceRequestBolt12SemanticErrorZ_err(enum LDKBolt12SemanticError e);
	public static native long CResult_InvoiceRequestBolt12SemanticErrorZ_err(Bolt12SemanticError e);
	// bool CResult_InvoiceRequestBolt12SemanticErrorZ_is_ok(const struct LDKCResult_InvoiceRequestBolt12SemanticErrorZ *NONNULL_PTR o);
	public static native boolean CResult_InvoiceRequestBolt12SemanticErrorZ_is_ok(long o);
	// void CResult_InvoiceRequestBolt12SemanticErrorZ_free(struct LDKCResult_InvoiceRequestBolt12SemanticErrorZ _res);
	public static native void CResult_InvoiceRequestBolt12SemanticErrorZ_free(long _res);
	// uint64_t CResult_InvoiceRequestBolt12SemanticErrorZ_clone_ptr(LDKCResult_InvoiceRequestBolt12SemanticErrorZ *NONNULL_PTR arg);
	public static native long CResult_InvoiceRequestBolt12SemanticErrorZ_clone_ptr(long arg);
	// struct LDKCResult_InvoiceRequestBolt12SemanticErrorZ CResult_InvoiceRequestBolt12SemanticErrorZ_clone(const struct LDKCResult_InvoiceRequestBolt12SemanticErrorZ *NONNULL_PTR orig);
	public static native long CResult_InvoiceRequestBolt12SemanticErrorZ_clone(long orig);
	// struct LDKCResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ CResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ_ok(struct LDKInvoiceWithExplicitSigningPubkeyBuilder o);
	public static native long CResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ_ok(long o);
	// struct LDKCResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ CResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ_err(enum LDKBolt12SemanticError e);
	public static native long CResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ_err(Bolt12SemanticError e);
	// bool CResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ_is_ok(const struct LDKCResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ *NONNULL_PTR o);
	public static native boolean CResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ_is_ok(long o);
	// void CResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ_free(struct LDKCResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ _res);
	public static native void CResult_InvoiceWithExplicitSigningPubkeyBuilderBolt12SemanticErrorZ_free(long _res);
	// struct LDKCResult_VerifiedInvoiceRequestNoneZ CResult_VerifiedInvoiceRequestNoneZ_ok(struct LDKVerifiedInvoiceRequest o);
	public static native long CResult_VerifiedInvoiceRequestNoneZ_ok(long o);
	// struct LDKCResult_VerifiedInvoiceRequestNoneZ CResult_VerifiedInvoiceRequestNoneZ_err(void);
	public static native long CResult_VerifiedInvoiceRequestNoneZ_err();
	// bool CResult_VerifiedInvoiceRequestNoneZ_is_ok(const struct LDKCResult_VerifiedInvoiceRequestNoneZ *NONNULL_PTR o);
	public static native boolean CResult_VerifiedInvoiceRequestNoneZ_is_ok(long o);
	// void CResult_VerifiedInvoiceRequestNoneZ_free(struct LDKCResult_VerifiedInvoiceRequestNoneZ _res);
	public static native void CResult_VerifiedInvoiceRequestNoneZ_free(long _res);
	// uint64_t CResult_VerifiedInvoiceRequestNoneZ_clone_ptr(LDKCResult_VerifiedInvoiceRequestNoneZ *NONNULL_PTR arg);
	public static native long CResult_VerifiedInvoiceRequestNoneZ_clone_ptr(long arg);
	// struct LDKCResult_VerifiedInvoiceRequestNoneZ CResult_VerifiedInvoiceRequestNoneZ_clone(const struct LDKCResult_VerifiedInvoiceRequestNoneZ *NONNULL_PTR orig);
	public static native long CResult_VerifiedInvoiceRequestNoneZ_clone(long orig);
	// struct LDKCResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ CResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ_ok(struct LDKInvoiceWithDerivedSigningPubkeyBuilder o);
	public static native long CResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ_ok(long o);
	// struct LDKCResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ CResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ_err(enum LDKBolt12SemanticError e);
	public static native long CResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ_err(Bolt12SemanticError e);
	// bool CResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ_is_ok(const struct LDKCResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ *NONNULL_PTR o);
	public static native boolean CResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ_is_ok(long o);
	// void CResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ_free(struct LDKCResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ _res);
	public static native void CResult_InvoiceWithDerivedSigningPubkeyBuilderBolt12SemanticErrorZ_free(long _res);
	// struct LDKCResult_InvoiceRequestDecodeErrorZ CResult_InvoiceRequestDecodeErrorZ_ok(struct LDKInvoiceRequest o);
	public static native long CResult_InvoiceRequestDecodeErrorZ_ok(long o);
	// struct LDKCResult_InvoiceRequestDecodeErrorZ CResult_InvoiceRequestDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_InvoiceRequestDecodeErrorZ_err(long e);
	// bool CResult_InvoiceRequestDecodeErrorZ_is_ok(const struct LDKCResult_InvoiceRequestDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_InvoiceRequestDecodeErrorZ_is_ok(long o);
	// void CResult_InvoiceRequestDecodeErrorZ_free(struct LDKCResult_InvoiceRequestDecodeErrorZ _res);
	public static native void CResult_InvoiceRequestDecodeErrorZ_free(long _res);
	// uint64_t CResult_InvoiceRequestDecodeErrorZ_clone_ptr(LDKCResult_InvoiceRequestDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_InvoiceRequestDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_InvoiceRequestDecodeErrorZ CResult_InvoiceRequestDecodeErrorZ_clone(const struct LDKCResult_InvoiceRequestDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_InvoiceRequestDecodeErrorZ_clone(long orig);
	// struct LDKCResult_InvoiceRequestFieldsDecodeErrorZ CResult_InvoiceRequestFieldsDecodeErrorZ_ok(struct LDKInvoiceRequestFields o);
	public static native long CResult_InvoiceRequestFieldsDecodeErrorZ_ok(long o);
	// struct LDKCResult_InvoiceRequestFieldsDecodeErrorZ CResult_InvoiceRequestFieldsDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_InvoiceRequestFieldsDecodeErrorZ_err(long e);
	// bool CResult_InvoiceRequestFieldsDecodeErrorZ_is_ok(const struct LDKCResult_InvoiceRequestFieldsDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_InvoiceRequestFieldsDecodeErrorZ_is_ok(long o);
	// void CResult_InvoiceRequestFieldsDecodeErrorZ_free(struct LDKCResult_InvoiceRequestFieldsDecodeErrorZ _res);
	public static native void CResult_InvoiceRequestFieldsDecodeErrorZ_free(long _res);
	// uint64_t CResult_InvoiceRequestFieldsDecodeErrorZ_clone_ptr(LDKCResult_InvoiceRequestFieldsDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_InvoiceRequestFieldsDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_InvoiceRequestFieldsDecodeErrorZ CResult_InvoiceRequestFieldsDecodeErrorZ_clone(const struct LDKCResult_InvoiceRequestFieldsDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_InvoiceRequestFieldsDecodeErrorZ_clone(long orig);
	// enum LDKCOption_NoneZ COption_NoneZ_some(void);
	public static native COption_NoneZ COption_NoneZ_some();
	// enum LDKCOption_NoneZ COption_NoneZ_none(void);
	public static native COption_NoneZ COption_NoneZ_none();
	// void COption_NoneZ_free(enum LDKCOption_NoneZ _res);
	public static native void COption_NoneZ_free(COption_NoneZ _res);
	// void CVec_WitnessZ_free(struct LDKCVec_WitnessZ _res);
	public static native void CVec_WitnessZ_free(byte[][] _res);
	// struct LDKCOption_ECDSASignatureZ COption_ECDSASignatureZ_some(struct LDKECDSASignature o);
	public static native long COption_ECDSASignatureZ_some(byte[] o);
	// struct LDKCOption_ECDSASignatureZ COption_ECDSASignatureZ_none(void);
	public static native long COption_ECDSASignatureZ_none();
	// void COption_ECDSASignatureZ_free(struct LDKCOption_ECDSASignatureZ _res);
	public static native void COption_ECDSASignatureZ_free(long _res);
	// uint64_t COption_ECDSASignatureZ_clone_ptr(LDKCOption_ECDSASignatureZ *NONNULL_PTR arg);
	public static native long COption_ECDSASignatureZ_clone_ptr(long arg);
	// struct LDKCOption_ECDSASignatureZ COption_ECDSASignatureZ_clone(const struct LDKCOption_ECDSASignatureZ *NONNULL_PTR orig);
	public static native long COption_ECDSASignatureZ_clone(long orig);
	// struct LDKCOption_i64Z COption_i64Z_some(int64_t o);
	public static native long COption_i64Z_some(long o);
	// struct LDKCOption_i64Z COption_i64Z_none(void);
	public static native long COption_i64Z_none();
	// void COption_i64Z_free(struct LDKCOption_i64Z _res);
	public static native void COption_i64Z_free(long _res);
	// uint64_t COption_i64Z_clone_ptr(LDKCOption_i64Z *NONNULL_PTR arg);
	public static native long COption_i64Z_clone_ptr(long arg);
	// struct LDKCOption_i64Z COption_i64Z_clone(const struct LDKCOption_i64Z *NONNULL_PTR orig);
	public static native long COption_i64Z_clone(long orig);
	// struct LDKCResult_SocketAddressDecodeErrorZ CResult_SocketAddressDecodeErrorZ_ok(struct LDKSocketAddress o);
	public static native long CResult_SocketAddressDecodeErrorZ_ok(long o);
	// struct LDKCResult_SocketAddressDecodeErrorZ CResult_SocketAddressDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_SocketAddressDecodeErrorZ_err(long e);
	// bool CResult_SocketAddressDecodeErrorZ_is_ok(const struct LDKCResult_SocketAddressDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_SocketAddressDecodeErrorZ_is_ok(long o);
	// void CResult_SocketAddressDecodeErrorZ_free(struct LDKCResult_SocketAddressDecodeErrorZ _res);
	public static native void CResult_SocketAddressDecodeErrorZ_free(long _res);
	// uint64_t CResult_SocketAddressDecodeErrorZ_clone_ptr(LDKCResult_SocketAddressDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_SocketAddressDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_SocketAddressDecodeErrorZ CResult_SocketAddressDecodeErrorZ_clone(const struct LDKCResult_SocketAddressDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_SocketAddressDecodeErrorZ_clone(long orig);
	// struct LDKCResult_SocketAddressSocketAddressParseErrorZ CResult_SocketAddressSocketAddressParseErrorZ_ok(struct LDKSocketAddress o);
	public static native long CResult_SocketAddressSocketAddressParseErrorZ_ok(long o);
	// struct LDKCResult_SocketAddressSocketAddressParseErrorZ CResult_SocketAddressSocketAddressParseErrorZ_err(enum LDKSocketAddressParseError e);
	public static native long CResult_SocketAddressSocketAddressParseErrorZ_err(SocketAddressParseError e);
	// bool CResult_SocketAddressSocketAddressParseErrorZ_is_ok(const struct LDKCResult_SocketAddressSocketAddressParseErrorZ *NONNULL_PTR o);
	public static native boolean CResult_SocketAddressSocketAddressParseErrorZ_is_ok(long o);
	// void CResult_SocketAddressSocketAddressParseErrorZ_free(struct LDKCResult_SocketAddressSocketAddressParseErrorZ _res);
	public static native void CResult_SocketAddressSocketAddressParseErrorZ_free(long _res);
	// uint64_t CResult_SocketAddressSocketAddressParseErrorZ_clone_ptr(LDKCResult_SocketAddressSocketAddressParseErrorZ *NONNULL_PTR arg);
	public static native long CResult_SocketAddressSocketAddressParseErrorZ_clone_ptr(long arg);
	// struct LDKCResult_SocketAddressSocketAddressParseErrorZ CResult_SocketAddressSocketAddressParseErrorZ_clone(const struct LDKCResult_SocketAddressSocketAddressParseErrorZ *NONNULL_PTR orig);
	public static native long CResult_SocketAddressSocketAddressParseErrorZ_clone(long orig);
	// void CVec_UpdateAddHTLCZ_free(struct LDKCVec_UpdateAddHTLCZ _res);
	public static native void CVec_UpdateAddHTLCZ_free(long[] _res);
	// void CVec_UpdateFulfillHTLCZ_free(struct LDKCVec_UpdateFulfillHTLCZ _res);
	public static native void CVec_UpdateFulfillHTLCZ_free(long[] _res);
	// void CVec_UpdateFailHTLCZ_free(struct LDKCVec_UpdateFailHTLCZ _res);
	public static native void CVec_UpdateFailHTLCZ_free(long[] _res);
	// void CVec_UpdateFailMalformedHTLCZ_free(struct LDKCVec_UpdateFailMalformedHTLCZ _res);
	public static native void CVec_UpdateFailMalformedHTLCZ_free(long[] _res);
	// struct LDKCResult_AcceptChannelDecodeErrorZ CResult_AcceptChannelDecodeErrorZ_ok(struct LDKAcceptChannel o);
	public static native long CResult_AcceptChannelDecodeErrorZ_ok(long o);
	// struct LDKCResult_AcceptChannelDecodeErrorZ CResult_AcceptChannelDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_AcceptChannelDecodeErrorZ_err(long e);
	// bool CResult_AcceptChannelDecodeErrorZ_is_ok(const struct LDKCResult_AcceptChannelDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_AcceptChannelDecodeErrorZ_is_ok(long o);
	// void CResult_AcceptChannelDecodeErrorZ_free(struct LDKCResult_AcceptChannelDecodeErrorZ _res);
	public static native void CResult_AcceptChannelDecodeErrorZ_free(long _res);
	// uint64_t CResult_AcceptChannelDecodeErrorZ_clone_ptr(LDKCResult_AcceptChannelDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_AcceptChannelDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_AcceptChannelDecodeErrorZ CResult_AcceptChannelDecodeErrorZ_clone(const struct LDKCResult_AcceptChannelDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_AcceptChannelDecodeErrorZ_clone(long orig);
	// struct LDKCResult_AcceptChannelV2DecodeErrorZ CResult_AcceptChannelV2DecodeErrorZ_ok(struct LDKAcceptChannelV2 o);
	public static native long CResult_AcceptChannelV2DecodeErrorZ_ok(long o);
	// struct LDKCResult_AcceptChannelV2DecodeErrorZ CResult_AcceptChannelV2DecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_AcceptChannelV2DecodeErrorZ_err(long e);
	// bool CResult_AcceptChannelV2DecodeErrorZ_is_ok(const struct LDKCResult_AcceptChannelV2DecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_AcceptChannelV2DecodeErrorZ_is_ok(long o);
	// void CResult_AcceptChannelV2DecodeErrorZ_free(struct LDKCResult_AcceptChannelV2DecodeErrorZ _res);
	public static native void CResult_AcceptChannelV2DecodeErrorZ_free(long _res);
	// uint64_t CResult_AcceptChannelV2DecodeErrorZ_clone_ptr(LDKCResult_AcceptChannelV2DecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_AcceptChannelV2DecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_AcceptChannelV2DecodeErrorZ CResult_AcceptChannelV2DecodeErrorZ_clone(const struct LDKCResult_AcceptChannelV2DecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_AcceptChannelV2DecodeErrorZ_clone(long orig);
	// struct LDKCResult_StfuDecodeErrorZ CResult_StfuDecodeErrorZ_ok(struct LDKStfu o);
	public static native long CResult_StfuDecodeErrorZ_ok(long o);
	// struct LDKCResult_StfuDecodeErrorZ CResult_StfuDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_StfuDecodeErrorZ_err(long e);
	// bool CResult_StfuDecodeErrorZ_is_ok(const struct LDKCResult_StfuDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_StfuDecodeErrorZ_is_ok(long o);
	// void CResult_StfuDecodeErrorZ_free(struct LDKCResult_StfuDecodeErrorZ _res);
	public static native void CResult_StfuDecodeErrorZ_free(long _res);
	// uint64_t CResult_StfuDecodeErrorZ_clone_ptr(LDKCResult_StfuDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_StfuDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_StfuDecodeErrorZ CResult_StfuDecodeErrorZ_clone(const struct LDKCResult_StfuDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_StfuDecodeErrorZ_clone(long orig);
	// struct LDKCResult_SpliceInitDecodeErrorZ CResult_SpliceInitDecodeErrorZ_ok(struct LDKSpliceInit o);
	public static native long CResult_SpliceInitDecodeErrorZ_ok(long o);
	// struct LDKCResult_SpliceInitDecodeErrorZ CResult_SpliceInitDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_SpliceInitDecodeErrorZ_err(long e);
	// bool CResult_SpliceInitDecodeErrorZ_is_ok(const struct LDKCResult_SpliceInitDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_SpliceInitDecodeErrorZ_is_ok(long o);
	// void CResult_SpliceInitDecodeErrorZ_free(struct LDKCResult_SpliceInitDecodeErrorZ _res);
	public static native void CResult_SpliceInitDecodeErrorZ_free(long _res);
	// uint64_t CResult_SpliceInitDecodeErrorZ_clone_ptr(LDKCResult_SpliceInitDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_SpliceInitDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_SpliceInitDecodeErrorZ CResult_SpliceInitDecodeErrorZ_clone(const struct LDKCResult_SpliceInitDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_SpliceInitDecodeErrorZ_clone(long orig);
	// struct LDKCResult_SpliceAckDecodeErrorZ CResult_SpliceAckDecodeErrorZ_ok(struct LDKSpliceAck o);
	public static native long CResult_SpliceAckDecodeErrorZ_ok(long o);
	// struct LDKCResult_SpliceAckDecodeErrorZ CResult_SpliceAckDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_SpliceAckDecodeErrorZ_err(long e);
	// bool CResult_SpliceAckDecodeErrorZ_is_ok(const struct LDKCResult_SpliceAckDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_SpliceAckDecodeErrorZ_is_ok(long o);
	// void CResult_SpliceAckDecodeErrorZ_free(struct LDKCResult_SpliceAckDecodeErrorZ _res);
	public static native void CResult_SpliceAckDecodeErrorZ_free(long _res);
	// uint64_t CResult_SpliceAckDecodeErrorZ_clone_ptr(LDKCResult_SpliceAckDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_SpliceAckDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_SpliceAckDecodeErrorZ CResult_SpliceAckDecodeErrorZ_clone(const struct LDKCResult_SpliceAckDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_SpliceAckDecodeErrorZ_clone(long orig);
	// struct LDKCResult_SpliceLockedDecodeErrorZ CResult_SpliceLockedDecodeErrorZ_ok(struct LDKSpliceLocked o);
	public static native long CResult_SpliceLockedDecodeErrorZ_ok(long o);
	// struct LDKCResult_SpliceLockedDecodeErrorZ CResult_SpliceLockedDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_SpliceLockedDecodeErrorZ_err(long e);
	// bool CResult_SpliceLockedDecodeErrorZ_is_ok(const struct LDKCResult_SpliceLockedDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_SpliceLockedDecodeErrorZ_is_ok(long o);
	// void CResult_SpliceLockedDecodeErrorZ_free(struct LDKCResult_SpliceLockedDecodeErrorZ _res);
	public static native void CResult_SpliceLockedDecodeErrorZ_free(long _res);
	// uint64_t CResult_SpliceLockedDecodeErrorZ_clone_ptr(LDKCResult_SpliceLockedDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_SpliceLockedDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_SpliceLockedDecodeErrorZ CResult_SpliceLockedDecodeErrorZ_clone(const struct LDKCResult_SpliceLockedDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_SpliceLockedDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TxAddInputDecodeErrorZ CResult_TxAddInputDecodeErrorZ_ok(struct LDKTxAddInput o);
	public static native long CResult_TxAddInputDecodeErrorZ_ok(long o);
	// struct LDKCResult_TxAddInputDecodeErrorZ CResult_TxAddInputDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_TxAddInputDecodeErrorZ_err(long e);
	// bool CResult_TxAddInputDecodeErrorZ_is_ok(const struct LDKCResult_TxAddInputDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_TxAddInputDecodeErrorZ_is_ok(long o);
	// void CResult_TxAddInputDecodeErrorZ_free(struct LDKCResult_TxAddInputDecodeErrorZ _res);
	public static native void CResult_TxAddInputDecodeErrorZ_free(long _res);
	// uint64_t CResult_TxAddInputDecodeErrorZ_clone_ptr(LDKCResult_TxAddInputDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_TxAddInputDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_TxAddInputDecodeErrorZ CResult_TxAddInputDecodeErrorZ_clone(const struct LDKCResult_TxAddInputDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_TxAddInputDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TxAddOutputDecodeErrorZ CResult_TxAddOutputDecodeErrorZ_ok(struct LDKTxAddOutput o);
	public static native long CResult_TxAddOutputDecodeErrorZ_ok(long o);
	// struct LDKCResult_TxAddOutputDecodeErrorZ CResult_TxAddOutputDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_TxAddOutputDecodeErrorZ_err(long e);
	// bool CResult_TxAddOutputDecodeErrorZ_is_ok(const struct LDKCResult_TxAddOutputDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_TxAddOutputDecodeErrorZ_is_ok(long o);
	// void CResult_TxAddOutputDecodeErrorZ_free(struct LDKCResult_TxAddOutputDecodeErrorZ _res);
	public static native void CResult_TxAddOutputDecodeErrorZ_free(long _res);
	// uint64_t CResult_TxAddOutputDecodeErrorZ_clone_ptr(LDKCResult_TxAddOutputDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_TxAddOutputDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_TxAddOutputDecodeErrorZ CResult_TxAddOutputDecodeErrorZ_clone(const struct LDKCResult_TxAddOutputDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_TxAddOutputDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TxRemoveInputDecodeErrorZ CResult_TxRemoveInputDecodeErrorZ_ok(struct LDKTxRemoveInput o);
	public static native long CResult_TxRemoveInputDecodeErrorZ_ok(long o);
	// struct LDKCResult_TxRemoveInputDecodeErrorZ CResult_TxRemoveInputDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_TxRemoveInputDecodeErrorZ_err(long e);
	// bool CResult_TxRemoveInputDecodeErrorZ_is_ok(const struct LDKCResult_TxRemoveInputDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_TxRemoveInputDecodeErrorZ_is_ok(long o);
	// void CResult_TxRemoveInputDecodeErrorZ_free(struct LDKCResult_TxRemoveInputDecodeErrorZ _res);
	public static native void CResult_TxRemoveInputDecodeErrorZ_free(long _res);
	// uint64_t CResult_TxRemoveInputDecodeErrorZ_clone_ptr(LDKCResult_TxRemoveInputDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_TxRemoveInputDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_TxRemoveInputDecodeErrorZ CResult_TxRemoveInputDecodeErrorZ_clone(const struct LDKCResult_TxRemoveInputDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_TxRemoveInputDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TxRemoveOutputDecodeErrorZ CResult_TxRemoveOutputDecodeErrorZ_ok(struct LDKTxRemoveOutput o);
	public static native long CResult_TxRemoveOutputDecodeErrorZ_ok(long o);
	// struct LDKCResult_TxRemoveOutputDecodeErrorZ CResult_TxRemoveOutputDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_TxRemoveOutputDecodeErrorZ_err(long e);
	// bool CResult_TxRemoveOutputDecodeErrorZ_is_ok(const struct LDKCResult_TxRemoveOutputDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_TxRemoveOutputDecodeErrorZ_is_ok(long o);
	// void CResult_TxRemoveOutputDecodeErrorZ_free(struct LDKCResult_TxRemoveOutputDecodeErrorZ _res);
	public static native void CResult_TxRemoveOutputDecodeErrorZ_free(long _res);
	// uint64_t CResult_TxRemoveOutputDecodeErrorZ_clone_ptr(LDKCResult_TxRemoveOutputDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_TxRemoveOutputDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_TxRemoveOutputDecodeErrorZ CResult_TxRemoveOutputDecodeErrorZ_clone(const struct LDKCResult_TxRemoveOutputDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_TxRemoveOutputDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TxCompleteDecodeErrorZ CResult_TxCompleteDecodeErrorZ_ok(struct LDKTxComplete o);
	public static native long CResult_TxCompleteDecodeErrorZ_ok(long o);
	// struct LDKCResult_TxCompleteDecodeErrorZ CResult_TxCompleteDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_TxCompleteDecodeErrorZ_err(long e);
	// bool CResult_TxCompleteDecodeErrorZ_is_ok(const struct LDKCResult_TxCompleteDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_TxCompleteDecodeErrorZ_is_ok(long o);
	// void CResult_TxCompleteDecodeErrorZ_free(struct LDKCResult_TxCompleteDecodeErrorZ _res);
	public static native void CResult_TxCompleteDecodeErrorZ_free(long _res);
	// uint64_t CResult_TxCompleteDecodeErrorZ_clone_ptr(LDKCResult_TxCompleteDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_TxCompleteDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_TxCompleteDecodeErrorZ CResult_TxCompleteDecodeErrorZ_clone(const struct LDKCResult_TxCompleteDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_TxCompleteDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TxSignaturesDecodeErrorZ CResult_TxSignaturesDecodeErrorZ_ok(struct LDKTxSignatures o);
	public static native long CResult_TxSignaturesDecodeErrorZ_ok(long o);
	// struct LDKCResult_TxSignaturesDecodeErrorZ CResult_TxSignaturesDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_TxSignaturesDecodeErrorZ_err(long e);
	// bool CResult_TxSignaturesDecodeErrorZ_is_ok(const struct LDKCResult_TxSignaturesDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_TxSignaturesDecodeErrorZ_is_ok(long o);
	// void CResult_TxSignaturesDecodeErrorZ_free(struct LDKCResult_TxSignaturesDecodeErrorZ _res);
	public static native void CResult_TxSignaturesDecodeErrorZ_free(long _res);
	// uint64_t CResult_TxSignaturesDecodeErrorZ_clone_ptr(LDKCResult_TxSignaturesDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_TxSignaturesDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_TxSignaturesDecodeErrorZ CResult_TxSignaturesDecodeErrorZ_clone(const struct LDKCResult_TxSignaturesDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_TxSignaturesDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TxInitRbfDecodeErrorZ CResult_TxInitRbfDecodeErrorZ_ok(struct LDKTxInitRbf o);
	public static native long CResult_TxInitRbfDecodeErrorZ_ok(long o);
	// struct LDKCResult_TxInitRbfDecodeErrorZ CResult_TxInitRbfDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_TxInitRbfDecodeErrorZ_err(long e);
	// bool CResult_TxInitRbfDecodeErrorZ_is_ok(const struct LDKCResult_TxInitRbfDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_TxInitRbfDecodeErrorZ_is_ok(long o);
	// void CResult_TxInitRbfDecodeErrorZ_free(struct LDKCResult_TxInitRbfDecodeErrorZ _res);
	public static native void CResult_TxInitRbfDecodeErrorZ_free(long _res);
	// uint64_t CResult_TxInitRbfDecodeErrorZ_clone_ptr(LDKCResult_TxInitRbfDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_TxInitRbfDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_TxInitRbfDecodeErrorZ CResult_TxInitRbfDecodeErrorZ_clone(const struct LDKCResult_TxInitRbfDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_TxInitRbfDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TxAckRbfDecodeErrorZ CResult_TxAckRbfDecodeErrorZ_ok(struct LDKTxAckRbf o);
	public static native long CResult_TxAckRbfDecodeErrorZ_ok(long o);
	// struct LDKCResult_TxAckRbfDecodeErrorZ CResult_TxAckRbfDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_TxAckRbfDecodeErrorZ_err(long e);
	// bool CResult_TxAckRbfDecodeErrorZ_is_ok(const struct LDKCResult_TxAckRbfDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_TxAckRbfDecodeErrorZ_is_ok(long o);
	// void CResult_TxAckRbfDecodeErrorZ_free(struct LDKCResult_TxAckRbfDecodeErrorZ _res);
	public static native void CResult_TxAckRbfDecodeErrorZ_free(long _res);
	// uint64_t CResult_TxAckRbfDecodeErrorZ_clone_ptr(LDKCResult_TxAckRbfDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_TxAckRbfDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_TxAckRbfDecodeErrorZ CResult_TxAckRbfDecodeErrorZ_clone(const struct LDKCResult_TxAckRbfDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_TxAckRbfDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TxAbortDecodeErrorZ CResult_TxAbortDecodeErrorZ_ok(struct LDKTxAbort o);
	public static native long CResult_TxAbortDecodeErrorZ_ok(long o);
	// struct LDKCResult_TxAbortDecodeErrorZ CResult_TxAbortDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_TxAbortDecodeErrorZ_err(long e);
	// bool CResult_TxAbortDecodeErrorZ_is_ok(const struct LDKCResult_TxAbortDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_TxAbortDecodeErrorZ_is_ok(long o);
	// void CResult_TxAbortDecodeErrorZ_free(struct LDKCResult_TxAbortDecodeErrorZ _res);
	public static native void CResult_TxAbortDecodeErrorZ_free(long _res);
	// uint64_t CResult_TxAbortDecodeErrorZ_clone_ptr(LDKCResult_TxAbortDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_TxAbortDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_TxAbortDecodeErrorZ CResult_TxAbortDecodeErrorZ_clone(const struct LDKCResult_TxAbortDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_TxAbortDecodeErrorZ_clone(long orig);
	// struct LDKCResult_AnnouncementSignaturesDecodeErrorZ CResult_AnnouncementSignaturesDecodeErrorZ_ok(struct LDKAnnouncementSignatures o);
	public static native long CResult_AnnouncementSignaturesDecodeErrorZ_ok(long o);
	// struct LDKCResult_AnnouncementSignaturesDecodeErrorZ CResult_AnnouncementSignaturesDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_AnnouncementSignaturesDecodeErrorZ_err(long e);
	// bool CResult_AnnouncementSignaturesDecodeErrorZ_is_ok(const struct LDKCResult_AnnouncementSignaturesDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_AnnouncementSignaturesDecodeErrorZ_is_ok(long o);
	// void CResult_AnnouncementSignaturesDecodeErrorZ_free(struct LDKCResult_AnnouncementSignaturesDecodeErrorZ _res);
	public static native void CResult_AnnouncementSignaturesDecodeErrorZ_free(long _res);
	// uint64_t CResult_AnnouncementSignaturesDecodeErrorZ_clone_ptr(LDKCResult_AnnouncementSignaturesDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_AnnouncementSignaturesDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_AnnouncementSignaturesDecodeErrorZ CResult_AnnouncementSignaturesDecodeErrorZ_clone(const struct LDKCResult_AnnouncementSignaturesDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_AnnouncementSignaturesDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ChannelReestablishDecodeErrorZ CResult_ChannelReestablishDecodeErrorZ_ok(struct LDKChannelReestablish o);
	public static native long CResult_ChannelReestablishDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelReestablishDecodeErrorZ CResult_ChannelReestablishDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelReestablishDecodeErrorZ_err(long e);
	// bool CResult_ChannelReestablishDecodeErrorZ_is_ok(const struct LDKCResult_ChannelReestablishDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelReestablishDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelReestablishDecodeErrorZ_free(struct LDKCResult_ChannelReestablishDecodeErrorZ _res);
	public static native void CResult_ChannelReestablishDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelReestablishDecodeErrorZ_clone_ptr(LDKCResult_ChannelReestablishDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelReestablishDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelReestablishDecodeErrorZ CResult_ChannelReestablishDecodeErrorZ_clone(const struct LDKCResult_ChannelReestablishDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelReestablishDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ClosingSignedDecodeErrorZ CResult_ClosingSignedDecodeErrorZ_ok(struct LDKClosingSigned o);
	public static native long CResult_ClosingSignedDecodeErrorZ_ok(long o);
	// struct LDKCResult_ClosingSignedDecodeErrorZ CResult_ClosingSignedDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ClosingSignedDecodeErrorZ_err(long e);
	// bool CResult_ClosingSignedDecodeErrorZ_is_ok(const struct LDKCResult_ClosingSignedDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ClosingSignedDecodeErrorZ_is_ok(long o);
	// void CResult_ClosingSignedDecodeErrorZ_free(struct LDKCResult_ClosingSignedDecodeErrorZ _res);
	public static native void CResult_ClosingSignedDecodeErrorZ_free(long _res);
	// uint64_t CResult_ClosingSignedDecodeErrorZ_clone_ptr(LDKCResult_ClosingSignedDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ClosingSignedDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ClosingSignedDecodeErrorZ CResult_ClosingSignedDecodeErrorZ_clone(const struct LDKCResult_ClosingSignedDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ClosingSignedDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ClosingSignedFeeRangeDecodeErrorZ CResult_ClosingSignedFeeRangeDecodeErrorZ_ok(struct LDKClosingSignedFeeRange o);
	public static native long CResult_ClosingSignedFeeRangeDecodeErrorZ_ok(long o);
	// struct LDKCResult_ClosingSignedFeeRangeDecodeErrorZ CResult_ClosingSignedFeeRangeDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ClosingSignedFeeRangeDecodeErrorZ_err(long e);
	// bool CResult_ClosingSignedFeeRangeDecodeErrorZ_is_ok(const struct LDKCResult_ClosingSignedFeeRangeDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ClosingSignedFeeRangeDecodeErrorZ_is_ok(long o);
	// void CResult_ClosingSignedFeeRangeDecodeErrorZ_free(struct LDKCResult_ClosingSignedFeeRangeDecodeErrorZ _res);
	public static native void CResult_ClosingSignedFeeRangeDecodeErrorZ_free(long _res);
	// uint64_t CResult_ClosingSignedFeeRangeDecodeErrorZ_clone_ptr(LDKCResult_ClosingSignedFeeRangeDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ClosingSignedFeeRangeDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ClosingSignedFeeRangeDecodeErrorZ CResult_ClosingSignedFeeRangeDecodeErrorZ_clone(const struct LDKCResult_ClosingSignedFeeRangeDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ClosingSignedFeeRangeDecodeErrorZ_clone(long orig);
	// struct LDKCResult_CommitmentSignedBatchDecodeErrorZ CResult_CommitmentSignedBatchDecodeErrorZ_ok(struct LDKCommitmentSignedBatch o);
	public static native long CResult_CommitmentSignedBatchDecodeErrorZ_ok(long o);
	// struct LDKCResult_CommitmentSignedBatchDecodeErrorZ CResult_CommitmentSignedBatchDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_CommitmentSignedBatchDecodeErrorZ_err(long e);
	// bool CResult_CommitmentSignedBatchDecodeErrorZ_is_ok(const struct LDKCResult_CommitmentSignedBatchDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_CommitmentSignedBatchDecodeErrorZ_is_ok(long o);
	// void CResult_CommitmentSignedBatchDecodeErrorZ_free(struct LDKCResult_CommitmentSignedBatchDecodeErrorZ _res);
	public static native void CResult_CommitmentSignedBatchDecodeErrorZ_free(long _res);
	// uint64_t CResult_CommitmentSignedBatchDecodeErrorZ_clone_ptr(LDKCResult_CommitmentSignedBatchDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_CommitmentSignedBatchDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_CommitmentSignedBatchDecodeErrorZ CResult_CommitmentSignedBatchDecodeErrorZ_clone(const struct LDKCResult_CommitmentSignedBatchDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_CommitmentSignedBatchDecodeErrorZ_clone(long orig);
	// struct LDKCResult_CommitmentSignedDecodeErrorZ CResult_CommitmentSignedDecodeErrorZ_ok(struct LDKCommitmentSigned o);
	public static native long CResult_CommitmentSignedDecodeErrorZ_ok(long o);
	// struct LDKCResult_CommitmentSignedDecodeErrorZ CResult_CommitmentSignedDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_CommitmentSignedDecodeErrorZ_err(long e);
	// bool CResult_CommitmentSignedDecodeErrorZ_is_ok(const struct LDKCResult_CommitmentSignedDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_CommitmentSignedDecodeErrorZ_is_ok(long o);
	// void CResult_CommitmentSignedDecodeErrorZ_free(struct LDKCResult_CommitmentSignedDecodeErrorZ _res);
	public static native void CResult_CommitmentSignedDecodeErrorZ_free(long _res);
	// uint64_t CResult_CommitmentSignedDecodeErrorZ_clone_ptr(LDKCResult_CommitmentSignedDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_CommitmentSignedDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_CommitmentSignedDecodeErrorZ CResult_CommitmentSignedDecodeErrorZ_clone(const struct LDKCResult_CommitmentSignedDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_CommitmentSignedDecodeErrorZ_clone(long orig);
	// struct LDKCResult_FundingCreatedDecodeErrorZ CResult_FundingCreatedDecodeErrorZ_ok(struct LDKFundingCreated o);
	public static native long CResult_FundingCreatedDecodeErrorZ_ok(long o);
	// struct LDKCResult_FundingCreatedDecodeErrorZ CResult_FundingCreatedDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_FundingCreatedDecodeErrorZ_err(long e);
	// bool CResult_FundingCreatedDecodeErrorZ_is_ok(const struct LDKCResult_FundingCreatedDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_FundingCreatedDecodeErrorZ_is_ok(long o);
	// void CResult_FundingCreatedDecodeErrorZ_free(struct LDKCResult_FundingCreatedDecodeErrorZ _res);
	public static native void CResult_FundingCreatedDecodeErrorZ_free(long _res);
	// uint64_t CResult_FundingCreatedDecodeErrorZ_clone_ptr(LDKCResult_FundingCreatedDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_FundingCreatedDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_FundingCreatedDecodeErrorZ CResult_FundingCreatedDecodeErrorZ_clone(const struct LDKCResult_FundingCreatedDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_FundingCreatedDecodeErrorZ_clone(long orig);
	// struct LDKCResult_FundingSignedDecodeErrorZ CResult_FundingSignedDecodeErrorZ_ok(struct LDKFundingSigned o);
	public static native long CResult_FundingSignedDecodeErrorZ_ok(long o);
	// struct LDKCResult_FundingSignedDecodeErrorZ CResult_FundingSignedDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_FundingSignedDecodeErrorZ_err(long e);
	// bool CResult_FundingSignedDecodeErrorZ_is_ok(const struct LDKCResult_FundingSignedDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_FundingSignedDecodeErrorZ_is_ok(long o);
	// void CResult_FundingSignedDecodeErrorZ_free(struct LDKCResult_FundingSignedDecodeErrorZ _res);
	public static native void CResult_FundingSignedDecodeErrorZ_free(long _res);
	// uint64_t CResult_FundingSignedDecodeErrorZ_clone_ptr(LDKCResult_FundingSignedDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_FundingSignedDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_FundingSignedDecodeErrorZ CResult_FundingSignedDecodeErrorZ_clone(const struct LDKCResult_FundingSignedDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_FundingSignedDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ChannelReadyDecodeErrorZ CResult_ChannelReadyDecodeErrorZ_ok(struct LDKChannelReady o);
	public static native long CResult_ChannelReadyDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelReadyDecodeErrorZ CResult_ChannelReadyDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelReadyDecodeErrorZ_err(long e);
	// bool CResult_ChannelReadyDecodeErrorZ_is_ok(const struct LDKCResult_ChannelReadyDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelReadyDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelReadyDecodeErrorZ_free(struct LDKCResult_ChannelReadyDecodeErrorZ _res);
	public static native void CResult_ChannelReadyDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelReadyDecodeErrorZ_clone_ptr(LDKCResult_ChannelReadyDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelReadyDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelReadyDecodeErrorZ CResult_ChannelReadyDecodeErrorZ_clone(const struct LDKCResult_ChannelReadyDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelReadyDecodeErrorZ_clone(long orig);
	// struct LDKCResult_InitDecodeErrorZ CResult_InitDecodeErrorZ_ok(struct LDKInit o);
	public static native long CResult_InitDecodeErrorZ_ok(long o);
	// struct LDKCResult_InitDecodeErrorZ CResult_InitDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_InitDecodeErrorZ_err(long e);
	// bool CResult_InitDecodeErrorZ_is_ok(const struct LDKCResult_InitDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_InitDecodeErrorZ_is_ok(long o);
	// void CResult_InitDecodeErrorZ_free(struct LDKCResult_InitDecodeErrorZ _res);
	public static native void CResult_InitDecodeErrorZ_free(long _res);
	// uint64_t CResult_InitDecodeErrorZ_clone_ptr(LDKCResult_InitDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_InitDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_InitDecodeErrorZ CResult_InitDecodeErrorZ_clone(const struct LDKCResult_InitDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_InitDecodeErrorZ_clone(long orig);
	// struct LDKCResult_OpenChannelDecodeErrorZ CResult_OpenChannelDecodeErrorZ_ok(struct LDKOpenChannel o);
	public static native long CResult_OpenChannelDecodeErrorZ_ok(long o);
	// struct LDKCResult_OpenChannelDecodeErrorZ CResult_OpenChannelDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_OpenChannelDecodeErrorZ_err(long e);
	// bool CResult_OpenChannelDecodeErrorZ_is_ok(const struct LDKCResult_OpenChannelDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OpenChannelDecodeErrorZ_is_ok(long o);
	// void CResult_OpenChannelDecodeErrorZ_free(struct LDKCResult_OpenChannelDecodeErrorZ _res);
	public static native void CResult_OpenChannelDecodeErrorZ_free(long _res);
	// uint64_t CResult_OpenChannelDecodeErrorZ_clone_ptr(LDKCResult_OpenChannelDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_OpenChannelDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_OpenChannelDecodeErrorZ CResult_OpenChannelDecodeErrorZ_clone(const struct LDKCResult_OpenChannelDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_OpenChannelDecodeErrorZ_clone(long orig);
	// struct LDKCResult_OpenChannelV2DecodeErrorZ CResult_OpenChannelV2DecodeErrorZ_ok(struct LDKOpenChannelV2 o);
	public static native long CResult_OpenChannelV2DecodeErrorZ_ok(long o);
	// struct LDKCResult_OpenChannelV2DecodeErrorZ CResult_OpenChannelV2DecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_OpenChannelV2DecodeErrorZ_err(long e);
	// bool CResult_OpenChannelV2DecodeErrorZ_is_ok(const struct LDKCResult_OpenChannelV2DecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OpenChannelV2DecodeErrorZ_is_ok(long o);
	// void CResult_OpenChannelV2DecodeErrorZ_free(struct LDKCResult_OpenChannelV2DecodeErrorZ _res);
	public static native void CResult_OpenChannelV2DecodeErrorZ_free(long _res);
	// uint64_t CResult_OpenChannelV2DecodeErrorZ_clone_ptr(LDKCResult_OpenChannelV2DecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_OpenChannelV2DecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_OpenChannelV2DecodeErrorZ CResult_OpenChannelV2DecodeErrorZ_clone(const struct LDKCResult_OpenChannelV2DecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_OpenChannelV2DecodeErrorZ_clone(long orig);
	// struct LDKCResult_RevokeAndACKDecodeErrorZ CResult_RevokeAndACKDecodeErrorZ_ok(struct LDKRevokeAndACK o);
	public static native long CResult_RevokeAndACKDecodeErrorZ_ok(long o);
	// struct LDKCResult_RevokeAndACKDecodeErrorZ CResult_RevokeAndACKDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_RevokeAndACKDecodeErrorZ_err(long e);
	// bool CResult_RevokeAndACKDecodeErrorZ_is_ok(const struct LDKCResult_RevokeAndACKDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RevokeAndACKDecodeErrorZ_is_ok(long o);
	// void CResult_RevokeAndACKDecodeErrorZ_free(struct LDKCResult_RevokeAndACKDecodeErrorZ _res);
	public static native void CResult_RevokeAndACKDecodeErrorZ_free(long _res);
	// uint64_t CResult_RevokeAndACKDecodeErrorZ_clone_ptr(LDKCResult_RevokeAndACKDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_RevokeAndACKDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RevokeAndACKDecodeErrorZ CResult_RevokeAndACKDecodeErrorZ_clone(const struct LDKCResult_RevokeAndACKDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_RevokeAndACKDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ShutdownDecodeErrorZ CResult_ShutdownDecodeErrorZ_ok(struct LDKShutdown o);
	public static native long CResult_ShutdownDecodeErrorZ_ok(long o);
	// struct LDKCResult_ShutdownDecodeErrorZ CResult_ShutdownDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ShutdownDecodeErrorZ_err(long e);
	// bool CResult_ShutdownDecodeErrorZ_is_ok(const struct LDKCResult_ShutdownDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ShutdownDecodeErrorZ_is_ok(long o);
	// void CResult_ShutdownDecodeErrorZ_free(struct LDKCResult_ShutdownDecodeErrorZ _res);
	public static native void CResult_ShutdownDecodeErrorZ_free(long _res);
	// uint64_t CResult_ShutdownDecodeErrorZ_clone_ptr(LDKCResult_ShutdownDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ShutdownDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ShutdownDecodeErrorZ CResult_ShutdownDecodeErrorZ_clone(const struct LDKCResult_ShutdownDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ShutdownDecodeErrorZ_clone(long orig);
	// struct LDKCResult_UpdateFailHTLCDecodeErrorZ CResult_UpdateFailHTLCDecodeErrorZ_ok(struct LDKUpdateFailHTLC o);
	public static native long CResult_UpdateFailHTLCDecodeErrorZ_ok(long o);
	// struct LDKCResult_UpdateFailHTLCDecodeErrorZ CResult_UpdateFailHTLCDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_UpdateFailHTLCDecodeErrorZ_err(long e);
	// bool CResult_UpdateFailHTLCDecodeErrorZ_is_ok(const struct LDKCResult_UpdateFailHTLCDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_UpdateFailHTLCDecodeErrorZ_is_ok(long o);
	// void CResult_UpdateFailHTLCDecodeErrorZ_free(struct LDKCResult_UpdateFailHTLCDecodeErrorZ _res);
	public static native void CResult_UpdateFailHTLCDecodeErrorZ_free(long _res);
	// uint64_t CResult_UpdateFailHTLCDecodeErrorZ_clone_ptr(LDKCResult_UpdateFailHTLCDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_UpdateFailHTLCDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_UpdateFailHTLCDecodeErrorZ CResult_UpdateFailHTLCDecodeErrorZ_clone(const struct LDKCResult_UpdateFailHTLCDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_UpdateFailHTLCDecodeErrorZ_clone(long orig);
	// struct LDKCResult_UpdateFailMalformedHTLCDecodeErrorZ CResult_UpdateFailMalformedHTLCDecodeErrorZ_ok(struct LDKUpdateFailMalformedHTLC o);
	public static native long CResult_UpdateFailMalformedHTLCDecodeErrorZ_ok(long o);
	// struct LDKCResult_UpdateFailMalformedHTLCDecodeErrorZ CResult_UpdateFailMalformedHTLCDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_UpdateFailMalformedHTLCDecodeErrorZ_err(long e);
	// bool CResult_UpdateFailMalformedHTLCDecodeErrorZ_is_ok(const struct LDKCResult_UpdateFailMalformedHTLCDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_UpdateFailMalformedHTLCDecodeErrorZ_is_ok(long o);
	// void CResult_UpdateFailMalformedHTLCDecodeErrorZ_free(struct LDKCResult_UpdateFailMalformedHTLCDecodeErrorZ _res);
	public static native void CResult_UpdateFailMalformedHTLCDecodeErrorZ_free(long _res);
	// uint64_t CResult_UpdateFailMalformedHTLCDecodeErrorZ_clone_ptr(LDKCResult_UpdateFailMalformedHTLCDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_UpdateFailMalformedHTLCDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_UpdateFailMalformedHTLCDecodeErrorZ CResult_UpdateFailMalformedHTLCDecodeErrorZ_clone(const struct LDKCResult_UpdateFailMalformedHTLCDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_UpdateFailMalformedHTLCDecodeErrorZ_clone(long orig);
	// struct LDKCResult_UpdateFeeDecodeErrorZ CResult_UpdateFeeDecodeErrorZ_ok(struct LDKUpdateFee o);
	public static native long CResult_UpdateFeeDecodeErrorZ_ok(long o);
	// struct LDKCResult_UpdateFeeDecodeErrorZ CResult_UpdateFeeDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_UpdateFeeDecodeErrorZ_err(long e);
	// bool CResult_UpdateFeeDecodeErrorZ_is_ok(const struct LDKCResult_UpdateFeeDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_UpdateFeeDecodeErrorZ_is_ok(long o);
	// void CResult_UpdateFeeDecodeErrorZ_free(struct LDKCResult_UpdateFeeDecodeErrorZ _res);
	public static native void CResult_UpdateFeeDecodeErrorZ_free(long _res);
	// uint64_t CResult_UpdateFeeDecodeErrorZ_clone_ptr(LDKCResult_UpdateFeeDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_UpdateFeeDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_UpdateFeeDecodeErrorZ CResult_UpdateFeeDecodeErrorZ_clone(const struct LDKCResult_UpdateFeeDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_UpdateFeeDecodeErrorZ_clone(long orig);
	// struct LDKCResult_UpdateFulfillHTLCDecodeErrorZ CResult_UpdateFulfillHTLCDecodeErrorZ_ok(struct LDKUpdateFulfillHTLC o);
	public static native long CResult_UpdateFulfillHTLCDecodeErrorZ_ok(long o);
	// struct LDKCResult_UpdateFulfillHTLCDecodeErrorZ CResult_UpdateFulfillHTLCDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_UpdateFulfillHTLCDecodeErrorZ_err(long e);
	// bool CResult_UpdateFulfillHTLCDecodeErrorZ_is_ok(const struct LDKCResult_UpdateFulfillHTLCDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_UpdateFulfillHTLCDecodeErrorZ_is_ok(long o);
	// void CResult_UpdateFulfillHTLCDecodeErrorZ_free(struct LDKCResult_UpdateFulfillHTLCDecodeErrorZ _res);
	public static native void CResult_UpdateFulfillHTLCDecodeErrorZ_free(long _res);
	// uint64_t CResult_UpdateFulfillHTLCDecodeErrorZ_clone_ptr(LDKCResult_UpdateFulfillHTLCDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_UpdateFulfillHTLCDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_UpdateFulfillHTLCDecodeErrorZ CResult_UpdateFulfillHTLCDecodeErrorZ_clone(const struct LDKCResult_UpdateFulfillHTLCDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_UpdateFulfillHTLCDecodeErrorZ_clone(long orig);
	// struct LDKCResult_OnionPacketDecodeErrorZ CResult_OnionPacketDecodeErrorZ_ok(struct LDKOnionPacket o);
	public static native long CResult_OnionPacketDecodeErrorZ_ok(long o);
	// struct LDKCResult_OnionPacketDecodeErrorZ CResult_OnionPacketDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_OnionPacketDecodeErrorZ_err(long e);
	// bool CResult_OnionPacketDecodeErrorZ_is_ok(const struct LDKCResult_OnionPacketDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OnionPacketDecodeErrorZ_is_ok(long o);
	// void CResult_OnionPacketDecodeErrorZ_free(struct LDKCResult_OnionPacketDecodeErrorZ _res);
	public static native void CResult_OnionPacketDecodeErrorZ_free(long _res);
	// uint64_t CResult_OnionPacketDecodeErrorZ_clone_ptr(LDKCResult_OnionPacketDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_OnionPacketDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_OnionPacketDecodeErrorZ CResult_OnionPacketDecodeErrorZ_clone(const struct LDKCResult_OnionPacketDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_OnionPacketDecodeErrorZ_clone(long orig);
	// struct LDKCResult_UpdateAddHTLCDecodeErrorZ CResult_UpdateAddHTLCDecodeErrorZ_ok(struct LDKUpdateAddHTLC o);
	public static native long CResult_UpdateAddHTLCDecodeErrorZ_ok(long o);
	// struct LDKCResult_UpdateAddHTLCDecodeErrorZ CResult_UpdateAddHTLCDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_UpdateAddHTLCDecodeErrorZ_err(long e);
	// bool CResult_UpdateAddHTLCDecodeErrorZ_is_ok(const struct LDKCResult_UpdateAddHTLCDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_UpdateAddHTLCDecodeErrorZ_is_ok(long o);
	// void CResult_UpdateAddHTLCDecodeErrorZ_free(struct LDKCResult_UpdateAddHTLCDecodeErrorZ _res);
	public static native void CResult_UpdateAddHTLCDecodeErrorZ_free(long _res);
	// uint64_t CResult_UpdateAddHTLCDecodeErrorZ_clone_ptr(LDKCResult_UpdateAddHTLCDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_UpdateAddHTLCDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_UpdateAddHTLCDecodeErrorZ CResult_UpdateAddHTLCDecodeErrorZ_clone(const struct LDKCResult_UpdateAddHTLCDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_UpdateAddHTLCDecodeErrorZ_clone(long orig);
	// struct LDKCResult_OnionMessageDecodeErrorZ CResult_OnionMessageDecodeErrorZ_ok(struct LDKOnionMessage o);
	public static native long CResult_OnionMessageDecodeErrorZ_ok(long o);
	// struct LDKCResult_OnionMessageDecodeErrorZ CResult_OnionMessageDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_OnionMessageDecodeErrorZ_err(long e);
	// bool CResult_OnionMessageDecodeErrorZ_is_ok(const struct LDKCResult_OnionMessageDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OnionMessageDecodeErrorZ_is_ok(long o);
	// void CResult_OnionMessageDecodeErrorZ_free(struct LDKCResult_OnionMessageDecodeErrorZ _res);
	public static native void CResult_OnionMessageDecodeErrorZ_free(long _res);
	// uint64_t CResult_OnionMessageDecodeErrorZ_clone_ptr(LDKCResult_OnionMessageDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_OnionMessageDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_OnionMessageDecodeErrorZ CResult_OnionMessageDecodeErrorZ_clone(const struct LDKCResult_OnionMessageDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_OnionMessageDecodeErrorZ_clone(long orig);
	// struct LDKCResult_FinalOnionHopDataDecodeErrorZ CResult_FinalOnionHopDataDecodeErrorZ_ok(struct LDKFinalOnionHopData o);
	public static native long CResult_FinalOnionHopDataDecodeErrorZ_ok(long o);
	// struct LDKCResult_FinalOnionHopDataDecodeErrorZ CResult_FinalOnionHopDataDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_FinalOnionHopDataDecodeErrorZ_err(long e);
	// bool CResult_FinalOnionHopDataDecodeErrorZ_is_ok(const struct LDKCResult_FinalOnionHopDataDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_FinalOnionHopDataDecodeErrorZ_is_ok(long o);
	// void CResult_FinalOnionHopDataDecodeErrorZ_free(struct LDKCResult_FinalOnionHopDataDecodeErrorZ _res);
	public static native void CResult_FinalOnionHopDataDecodeErrorZ_free(long _res);
	// uint64_t CResult_FinalOnionHopDataDecodeErrorZ_clone_ptr(LDKCResult_FinalOnionHopDataDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_FinalOnionHopDataDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_FinalOnionHopDataDecodeErrorZ CResult_FinalOnionHopDataDecodeErrorZ_clone(const struct LDKCResult_FinalOnionHopDataDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_FinalOnionHopDataDecodeErrorZ_clone(long orig);
	// struct LDKCResult_PingDecodeErrorZ CResult_PingDecodeErrorZ_ok(struct LDKPing o);
	public static native long CResult_PingDecodeErrorZ_ok(long o);
	// struct LDKCResult_PingDecodeErrorZ CResult_PingDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_PingDecodeErrorZ_err(long e);
	// bool CResult_PingDecodeErrorZ_is_ok(const struct LDKCResult_PingDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_PingDecodeErrorZ_is_ok(long o);
	// void CResult_PingDecodeErrorZ_free(struct LDKCResult_PingDecodeErrorZ _res);
	public static native void CResult_PingDecodeErrorZ_free(long _res);
	// uint64_t CResult_PingDecodeErrorZ_clone_ptr(LDKCResult_PingDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_PingDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_PingDecodeErrorZ CResult_PingDecodeErrorZ_clone(const struct LDKCResult_PingDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_PingDecodeErrorZ_clone(long orig);
	// struct LDKCResult_PongDecodeErrorZ CResult_PongDecodeErrorZ_ok(struct LDKPong o);
	public static native long CResult_PongDecodeErrorZ_ok(long o);
	// struct LDKCResult_PongDecodeErrorZ CResult_PongDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_PongDecodeErrorZ_err(long e);
	// bool CResult_PongDecodeErrorZ_is_ok(const struct LDKCResult_PongDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_PongDecodeErrorZ_is_ok(long o);
	// void CResult_PongDecodeErrorZ_free(struct LDKCResult_PongDecodeErrorZ _res);
	public static native void CResult_PongDecodeErrorZ_free(long _res);
	// uint64_t CResult_PongDecodeErrorZ_clone_ptr(LDKCResult_PongDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_PongDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_PongDecodeErrorZ CResult_PongDecodeErrorZ_clone(const struct LDKCResult_PongDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_PongDecodeErrorZ_clone(long orig);
	// struct LDKCResult_UnsignedChannelAnnouncementDecodeErrorZ CResult_UnsignedChannelAnnouncementDecodeErrorZ_ok(struct LDKUnsignedChannelAnnouncement o);
	public static native long CResult_UnsignedChannelAnnouncementDecodeErrorZ_ok(long o);
	// struct LDKCResult_UnsignedChannelAnnouncementDecodeErrorZ CResult_UnsignedChannelAnnouncementDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_UnsignedChannelAnnouncementDecodeErrorZ_err(long e);
	// bool CResult_UnsignedChannelAnnouncementDecodeErrorZ_is_ok(const struct LDKCResult_UnsignedChannelAnnouncementDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_UnsignedChannelAnnouncementDecodeErrorZ_is_ok(long o);
	// void CResult_UnsignedChannelAnnouncementDecodeErrorZ_free(struct LDKCResult_UnsignedChannelAnnouncementDecodeErrorZ _res);
	public static native void CResult_UnsignedChannelAnnouncementDecodeErrorZ_free(long _res);
	// uint64_t CResult_UnsignedChannelAnnouncementDecodeErrorZ_clone_ptr(LDKCResult_UnsignedChannelAnnouncementDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_UnsignedChannelAnnouncementDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_UnsignedChannelAnnouncementDecodeErrorZ CResult_UnsignedChannelAnnouncementDecodeErrorZ_clone(const struct LDKCResult_UnsignedChannelAnnouncementDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_UnsignedChannelAnnouncementDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ChannelAnnouncementDecodeErrorZ CResult_ChannelAnnouncementDecodeErrorZ_ok(struct LDKChannelAnnouncement o);
	public static native long CResult_ChannelAnnouncementDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelAnnouncementDecodeErrorZ CResult_ChannelAnnouncementDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelAnnouncementDecodeErrorZ_err(long e);
	// bool CResult_ChannelAnnouncementDecodeErrorZ_is_ok(const struct LDKCResult_ChannelAnnouncementDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelAnnouncementDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelAnnouncementDecodeErrorZ_free(struct LDKCResult_ChannelAnnouncementDecodeErrorZ _res);
	public static native void CResult_ChannelAnnouncementDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelAnnouncementDecodeErrorZ_clone_ptr(LDKCResult_ChannelAnnouncementDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelAnnouncementDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelAnnouncementDecodeErrorZ CResult_ChannelAnnouncementDecodeErrorZ_clone(const struct LDKCResult_ChannelAnnouncementDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelAnnouncementDecodeErrorZ_clone(long orig);
	// struct LDKCResult_UnsignedChannelUpdateDecodeErrorZ CResult_UnsignedChannelUpdateDecodeErrorZ_ok(struct LDKUnsignedChannelUpdate o);
	public static native long CResult_UnsignedChannelUpdateDecodeErrorZ_ok(long o);
	// struct LDKCResult_UnsignedChannelUpdateDecodeErrorZ CResult_UnsignedChannelUpdateDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_UnsignedChannelUpdateDecodeErrorZ_err(long e);
	// bool CResult_UnsignedChannelUpdateDecodeErrorZ_is_ok(const struct LDKCResult_UnsignedChannelUpdateDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_UnsignedChannelUpdateDecodeErrorZ_is_ok(long o);
	// void CResult_UnsignedChannelUpdateDecodeErrorZ_free(struct LDKCResult_UnsignedChannelUpdateDecodeErrorZ _res);
	public static native void CResult_UnsignedChannelUpdateDecodeErrorZ_free(long _res);
	// uint64_t CResult_UnsignedChannelUpdateDecodeErrorZ_clone_ptr(LDKCResult_UnsignedChannelUpdateDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_UnsignedChannelUpdateDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_UnsignedChannelUpdateDecodeErrorZ CResult_UnsignedChannelUpdateDecodeErrorZ_clone(const struct LDKCResult_UnsignedChannelUpdateDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_UnsignedChannelUpdateDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ChannelUpdateDecodeErrorZ CResult_ChannelUpdateDecodeErrorZ_ok(struct LDKChannelUpdate o);
	public static native long CResult_ChannelUpdateDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelUpdateDecodeErrorZ CResult_ChannelUpdateDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelUpdateDecodeErrorZ_err(long e);
	// bool CResult_ChannelUpdateDecodeErrorZ_is_ok(const struct LDKCResult_ChannelUpdateDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelUpdateDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelUpdateDecodeErrorZ_free(struct LDKCResult_ChannelUpdateDecodeErrorZ _res);
	public static native void CResult_ChannelUpdateDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelUpdateDecodeErrorZ_clone_ptr(LDKCResult_ChannelUpdateDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelUpdateDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelUpdateDecodeErrorZ CResult_ChannelUpdateDecodeErrorZ_clone(const struct LDKCResult_ChannelUpdateDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelUpdateDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ErrorMessageDecodeErrorZ CResult_ErrorMessageDecodeErrorZ_ok(struct LDKErrorMessage o);
	public static native long CResult_ErrorMessageDecodeErrorZ_ok(long o);
	// struct LDKCResult_ErrorMessageDecodeErrorZ CResult_ErrorMessageDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ErrorMessageDecodeErrorZ_err(long e);
	// bool CResult_ErrorMessageDecodeErrorZ_is_ok(const struct LDKCResult_ErrorMessageDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ErrorMessageDecodeErrorZ_is_ok(long o);
	// void CResult_ErrorMessageDecodeErrorZ_free(struct LDKCResult_ErrorMessageDecodeErrorZ _res);
	public static native void CResult_ErrorMessageDecodeErrorZ_free(long _res);
	// uint64_t CResult_ErrorMessageDecodeErrorZ_clone_ptr(LDKCResult_ErrorMessageDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ErrorMessageDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ErrorMessageDecodeErrorZ CResult_ErrorMessageDecodeErrorZ_clone(const struct LDKCResult_ErrorMessageDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ErrorMessageDecodeErrorZ_clone(long orig);
	// struct LDKCResult_WarningMessageDecodeErrorZ CResult_WarningMessageDecodeErrorZ_ok(struct LDKWarningMessage o);
	public static native long CResult_WarningMessageDecodeErrorZ_ok(long o);
	// struct LDKCResult_WarningMessageDecodeErrorZ CResult_WarningMessageDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_WarningMessageDecodeErrorZ_err(long e);
	// bool CResult_WarningMessageDecodeErrorZ_is_ok(const struct LDKCResult_WarningMessageDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_WarningMessageDecodeErrorZ_is_ok(long o);
	// void CResult_WarningMessageDecodeErrorZ_free(struct LDKCResult_WarningMessageDecodeErrorZ _res);
	public static native void CResult_WarningMessageDecodeErrorZ_free(long _res);
	// uint64_t CResult_WarningMessageDecodeErrorZ_clone_ptr(LDKCResult_WarningMessageDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_WarningMessageDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_WarningMessageDecodeErrorZ CResult_WarningMessageDecodeErrorZ_clone(const struct LDKCResult_WarningMessageDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_WarningMessageDecodeErrorZ_clone(long orig);
	// struct LDKCResult_UnsignedNodeAnnouncementDecodeErrorZ CResult_UnsignedNodeAnnouncementDecodeErrorZ_ok(struct LDKUnsignedNodeAnnouncement o);
	public static native long CResult_UnsignedNodeAnnouncementDecodeErrorZ_ok(long o);
	// struct LDKCResult_UnsignedNodeAnnouncementDecodeErrorZ CResult_UnsignedNodeAnnouncementDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_UnsignedNodeAnnouncementDecodeErrorZ_err(long e);
	// bool CResult_UnsignedNodeAnnouncementDecodeErrorZ_is_ok(const struct LDKCResult_UnsignedNodeAnnouncementDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_UnsignedNodeAnnouncementDecodeErrorZ_is_ok(long o);
	// void CResult_UnsignedNodeAnnouncementDecodeErrorZ_free(struct LDKCResult_UnsignedNodeAnnouncementDecodeErrorZ _res);
	public static native void CResult_UnsignedNodeAnnouncementDecodeErrorZ_free(long _res);
	// uint64_t CResult_UnsignedNodeAnnouncementDecodeErrorZ_clone_ptr(LDKCResult_UnsignedNodeAnnouncementDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_UnsignedNodeAnnouncementDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_UnsignedNodeAnnouncementDecodeErrorZ CResult_UnsignedNodeAnnouncementDecodeErrorZ_clone(const struct LDKCResult_UnsignedNodeAnnouncementDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_UnsignedNodeAnnouncementDecodeErrorZ_clone(long orig);
	// struct LDKCResult_NodeAnnouncementDecodeErrorZ CResult_NodeAnnouncementDecodeErrorZ_ok(struct LDKNodeAnnouncement o);
	public static native long CResult_NodeAnnouncementDecodeErrorZ_ok(long o);
	// struct LDKCResult_NodeAnnouncementDecodeErrorZ CResult_NodeAnnouncementDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_NodeAnnouncementDecodeErrorZ_err(long e);
	// bool CResult_NodeAnnouncementDecodeErrorZ_is_ok(const struct LDKCResult_NodeAnnouncementDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NodeAnnouncementDecodeErrorZ_is_ok(long o);
	// void CResult_NodeAnnouncementDecodeErrorZ_free(struct LDKCResult_NodeAnnouncementDecodeErrorZ _res);
	public static native void CResult_NodeAnnouncementDecodeErrorZ_free(long _res);
	// uint64_t CResult_NodeAnnouncementDecodeErrorZ_clone_ptr(LDKCResult_NodeAnnouncementDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_NodeAnnouncementDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NodeAnnouncementDecodeErrorZ CResult_NodeAnnouncementDecodeErrorZ_clone(const struct LDKCResult_NodeAnnouncementDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_NodeAnnouncementDecodeErrorZ_clone(long orig);
	// struct LDKCResult_QueryShortChannelIdsDecodeErrorZ CResult_QueryShortChannelIdsDecodeErrorZ_ok(struct LDKQueryShortChannelIds o);
	public static native long CResult_QueryShortChannelIdsDecodeErrorZ_ok(long o);
	// struct LDKCResult_QueryShortChannelIdsDecodeErrorZ CResult_QueryShortChannelIdsDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_QueryShortChannelIdsDecodeErrorZ_err(long e);
	// bool CResult_QueryShortChannelIdsDecodeErrorZ_is_ok(const struct LDKCResult_QueryShortChannelIdsDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_QueryShortChannelIdsDecodeErrorZ_is_ok(long o);
	// void CResult_QueryShortChannelIdsDecodeErrorZ_free(struct LDKCResult_QueryShortChannelIdsDecodeErrorZ _res);
	public static native void CResult_QueryShortChannelIdsDecodeErrorZ_free(long _res);
	// uint64_t CResult_QueryShortChannelIdsDecodeErrorZ_clone_ptr(LDKCResult_QueryShortChannelIdsDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_QueryShortChannelIdsDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_QueryShortChannelIdsDecodeErrorZ CResult_QueryShortChannelIdsDecodeErrorZ_clone(const struct LDKCResult_QueryShortChannelIdsDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_QueryShortChannelIdsDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ReplyShortChannelIdsEndDecodeErrorZ CResult_ReplyShortChannelIdsEndDecodeErrorZ_ok(struct LDKReplyShortChannelIdsEnd o);
	public static native long CResult_ReplyShortChannelIdsEndDecodeErrorZ_ok(long o);
	// struct LDKCResult_ReplyShortChannelIdsEndDecodeErrorZ CResult_ReplyShortChannelIdsEndDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ReplyShortChannelIdsEndDecodeErrorZ_err(long e);
	// bool CResult_ReplyShortChannelIdsEndDecodeErrorZ_is_ok(const struct LDKCResult_ReplyShortChannelIdsEndDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ReplyShortChannelIdsEndDecodeErrorZ_is_ok(long o);
	// void CResult_ReplyShortChannelIdsEndDecodeErrorZ_free(struct LDKCResult_ReplyShortChannelIdsEndDecodeErrorZ _res);
	public static native void CResult_ReplyShortChannelIdsEndDecodeErrorZ_free(long _res);
	// uint64_t CResult_ReplyShortChannelIdsEndDecodeErrorZ_clone_ptr(LDKCResult_ReplyShortChannelIdsEndDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ReplyShortChannelIdsEndDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ReplyShortChannelIdsEndDecodeErrorZ CResult_ReplyShortChannelIdsEndDecodeErrorZ_clone(const struct LDKCResult_ReplyShortChannelIdsEndDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ReplyShortChannelIdsEndDecodeErrorZ_clone(long orig);
	// struct LDKCResult_QueryChannelRangeDecodeErrorZ CResult_QueryChannelRangeDecodeErrorZ_ok(struct LDKQueryChannelRange o);
	public static native long CResult_QueryChannelRangeDecodeErrorZ_ok(long o);
	// struct LDKCResult_QueryChannelRangeDecodeErrorZ CResult_QueryChannelRangeDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_QueryChannelRangeDecodeErrorZ_err(long e);
	// bool CResult_QueryChannelRangeDecodeErrorZ_is_ok(const struct LDKCResult_QueryChannelRangeDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_QueryChannelRangeDecodeErrorZ_is_ok(long o);
	// void CResult_QueryChannelRangeDecodeErrorZ_free(struct LDKCResult_QueryChannelRangeDecodeErrorZ _res);
	public static native void CResult_QueryChannelRangeDecodeErrorZ_free(long _res);
	// uint64_t CResult_QueryChannelRangeDecodeErrorZ_clone_ptr(LDKCResult_QueryChannelRangeDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_QueryChannelRangeDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_QueryChannelRangeDecodeErrorZ CResult_QueryChannelRangeDecodeErrorZ_clone(const struct LDKCResult_QueryChannelRangeDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_QueryChannelRangeDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ReplyChannelRangeDecodeErrorZ CResult_ReplyChannelRangeDecodeErrorZ_ok(struct LDKReplyChannelRange o);
	public static native long CResult_ReplyChannelRangeDecodeErrorZ_ok(long o);
	// struct LDKCResult_ReplyChannelRangeDecodeErrorZ CResult_ReplyChannelRangeDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ReplyChannelRangeDecodeErrorZ_err(long e);
	// bool CResult_ReplyChannelRangeDecodeErrorZ_is_ok(const struct LDKCResult_ReplyChannelRangeDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ReplyChannelRangeDecodeErrorZ_is_ok(long o);
	// void CResult_ReplyChannelRangeDecodeErrorZ_free(struct LDKCResult_ReplyChannelRangeDecodeErrorZ _res);
	public static native void CResult_ReplyChannelRangeDecodeErrorZ_free(long _res);
	// uint64_t CResult_ReplyChannelRangeDecodeErrorZ_clone_ptr(LDKCResult_ReplyChannelRangeDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ReplyChannelRangeDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ReplyChannelRangeDecodeErrorZ CResult_ReplyChannelRangeDecodeErrorZ_clone(const struct LDKCResult_ReplyChannelRangeDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ReplyChannelRangeDecodeErrorZ_clone(long orig);
	// struct LDKCResult_GossipTimestampFilterDecodeErrorZ CResult_GossipTimestampFilterDecodeErrorZ_ok(struct LDKGossipTimestampFilter o);
	public static native long CResult_GossipTimestampFilterDecodeErrorZ_ok(long o);
	// struct LDKCResult_GossipTimestampFilterDecodeErrorZ CResult_GossipTimestampFilterDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_GossipTimestampFilterDecodeErrorZ_err(long e);
	// bool CResult_GossipTimestampFilterDecodeErrorZ_is_ok(const struct LDKCResult_GossipTimestampFilterDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_GossipTimestampFilterDecodeErrorZ_is_ok(long o);
	// void CResult_GossipTimestampFilterDecodeErrorZ_free(struct LDKCResult_GossipTimestampFilterDecodeErrorZ _res);
	public static native void CResult_GossipTimestampFilterDecodeErrorZ_free(long _res);
	// uint64_t CResult_GossipTimestampFilterDecodeErrorZ_clone_ptr(LDKCResult_GossipTimestampFilterDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_GossipTimestampFilterDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_GossipTimestampFilterDecodeErrorZ CResult_GossipTimestampFilterDecodeErrorZ_clone(const struct LDKCResult_GossipTimestampFilterDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_GossipTimestampFilterDecodeErrorZ_clone(long orig);
	// struct LDKCOption_InboundHTLCStateDetailsZ COption_InboundHTLCStateDetailsZ_some(enum LDKInboundHTLCStateDetails o);
	public static native long COption_InboundHTLCStateDetailsZ_some(InboundHTLCStateDetails o);
	// struct LDKCOption_InboundHTLCStateDetailsZ COption_InboundHTLCStateDetailsZ_none(void);
	public static native long COption_InboundHTLCStateDetailsZ_none();
	// void COption_InboundHTLCStateDetailsZ_free(struct LDKCOption_InboundHTLCStateDetailsZ _res);
	public static native void COption_InboundHTLCStateDetailsZ_free(long _res);
	// uint64_t COption_InboundHTLCStateDetailsZ_clone_ptr(LDKCOption_InboundHTLCStateDetailsZ *NONNULL_PTR arg);
	public static native long COption_InboundHTLCStateDetailsZ_clone_ptr(long arg);
	// struct LDKCOption_InboundHTLCStateDetailsZ COption_InboundHTLCStateDetailsZ_clone(const struct LDKCOption_InboundHTLCStateDetailsZ *NONNULL_PTR orig);
	public static native long COption_InboundHTLCStateDetailsZ_clone(long orig);
	// struct LDKCResult_COption_InboundHTLCStateDetailsZDecodeErrorZ CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_ok(struct LDKCOption_InboundHTLCStateDetailsZ o);
	public static native long CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_ok(long o);
	// struct LDKCResult_COption_InboundHTLCStateDetailsZDecodeErrorZ CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_err(long e);
	// bool CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_is_ok(const struct LDKCResult_COption_InboundHTLCStateDetailsZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_is_ok(long o);
	// void CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_free(struct LDKCResult_COption_InboundHTLCStateDetailsZDecodeErrorZ _res);
	public static native void CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_free(long _res);
	// uint64_t CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_clone_ptr(LDKCResult_COption_InboundHTLCStateDetailsZDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_COption_InboundHTLCStateDetailsZDecodeErrorZ CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_clone(const struct LDKCResult_COption_InboundHTLCStateDetailsZDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_COption_InboundHTLCStateDetailsZDecodeErrorZ_clone(long orig);
	// struct LDKCResult_InboundHTLCDetailsDecodeErrorZ CResult_InboundHTLCDetailsDecodeErrorZ_ok(struct LDKInboundHTLCDetails o);
	public static native long CResult_InboundHTLCDetailsDecodeErrorZ_ok(long o);
	// struct LDKCResult_InboundHTLCDetailsDecodeErrorZ CResult_InboundHTLCDetailsDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_InboundHTLCDetailsDecodeErrorZ_err(long e);
	// bool CResult_InboundHTLCDetailsDecodeErrorZ_is_ok(const struct LDKCResult_InboundHTLCDetailsDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_InboundHTLCDetailsDecodeErrorZ_is_ok(long o);
	// void CResult_InboundHTLCDetailsDecodeErrorZ_free(struct LDKCResult_InboundHTLCDetailsDecodeErrorZ _res);
	public static native void CResult_InboundHTLCDetailsDecodeErrorZ_free(long _res);
	// uint64_t CResult_InboundHTLCDetailsDecodeErrorZ_clone_ptr(LDKCResult_InboundHTLCDetailsDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_InboundHTLCDetailsDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_InboundHTLCDetailsDecodeErrorZ CResult_InboundHTLCDetailsDecodeErrorZ_clone(const struct LDKCResult_InboundHTLCDetailsDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_InboundHTLCDetailsDecodeErrorZ_clone(long orig);
	// struct LDKCOption_OutboundHTLCStateDetailsZ COption_OutboundHTLCStateDetailsZ_some(enum LDKOutboundHTLCStateDetails o);
	public static native long COption_OutboundHTLCStateDetailsZ_some(OutboundHTLCStateDetails o);
	// struct LDKCOption_OutboundHTLCStateDetailsZ COption_OutboundHTLCStateDetailsZ_none(void);
	public static native long COption_OutboundHTLCStateDetailsZ_none();
	// void COption_OutboundHTLCStateDetailsZ_free(struct LDKCOption_OutboundHTLCStateDetailsZ _res);
	public static native void COption_OutboundHTLCStateDetailsZ_free(long _res);
	// uint64_t COption_OutboundHTLCStateDetailsZ_clone_ptr(LDKCOption_OutboundHTLCStateDetailsZ *NONNULL_PTR arg);
	public static native long COption_OutboundHTLCStateDetailsZ_clone_ptr(long arg);
	// struct LDKCOption_OutboundHTLCStateDetailsZ COption_OutboundHTLCStateDetailsZ_clone(const struct LDKCOption_OutboundHTLCStateDetailsZ *NONNULL_PTR orig);
	public static native long COption_OutboundHTLCStateDetailsZ_clone(long orig);
	// struct LDKCResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_ok(struct LDKCOption_OutboundHTLCStateDetailsZ o);
	public static native long CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_ok(long o);
	// struct LDKCResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_err(long e);
	// bool CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_is_ok(const struct LDKCResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_is_ok(long o);
	// void CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_free(struct LDKCResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ _res);
	public static native void CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_free(long _res);
	// uint64_t CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_clone_ptr(LDKCResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_clone(const struct LDKCResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ_clone(long orig);
	// struct LDKCResult_OutboundHTLCDetailsDecodeErrorZ CResult_OutboundHTLCDetailsDecodeErrorZ_ok(struct LDKOutboundHTLCDetails o);
	public static native long CResult_OutboundHTLCDetailsDecodeErrorZ_ok(long o);
	// struct LDKCResult_OutboundHTLCDetailsDecodeErrorZ CResult_OutboundHTLCDetailsDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_OutboundHTLCDetailsDecodeErrorZ_err(long e);
	// bool CResult_OutboundHTLCDetailsDecodeErrorZ_is_ok(const struct LDKCResult_OutboundHTLCDetailsDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OutboundHTLCDetailsDecodeErrorZ_is_ok(long o);
	// void CResult_OutboundHTLCDetailsDecodeErrorZ_free(struct LDKCResult_OutboundHTLCDetailsDecodeErrorZ _res);
	public static native void CResult_OutboundHTLCDetailsDecodeErrorZ_free(long _res);
	// uint64_t CResult_OutboundHTLCDetailsDecodeErrorZ_clone_ptr(LDKCResult_OutboundHTLCDetailsDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_OutboundHTLCDetailsDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_OutboundHTLCDetailsDecodeErrorZ CResult_OutboundHTLCDetailsDecodeErrorZ_clone(const struct LDKCResult_OutboundHTLCDetailsDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_OutboundHTLCDetailsDecodeErrorZ_clone(long orig);
	// struct LDKCResult_CounterpartyForwardingInfoDecodeErrorZ CResult_CounterpartyForwardingInfoDecodeErrorZ_ok(struct LDKCounterpartyForwardingInfo o);
	public static native long CResult_CounterpartyForwardingInfoDecodeErrorZ_ok(long o);
	// struct LDKCResult_CounterpartyForwardingInfoDecodeErrorZ CResult_CounterpartyForwardingInfoDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_CounterpartyForwardingInfoDecodeErrorZ_err(long e);
	// bool CResult_CounterpartyForwardingInfoDecodeErrorZ_is_ok(const struct LDKCResult_CounterpartyForwardingInfoDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_CounterpartyForwardingInfoDecodeErrorZ_is_ok(long o);
	// void CResult_CounterpartyForwardingInfoDecodeErrorZ_free(struct LDKCResult_CounterpartyForwardingInfoDecodeErrorZ _res);
	public static native void CResult_CounterpartyForwardingInfoDecodeErrorZ_free(long _res);
	// uint64_t CResult_CounterpartyForwardingInfoDecodeErrorZ_clone_ptr(LDKCResult_CounterpartyForwardingInfoDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_CounterpartyForwardingInfoDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_CounterpartyForwardingInfoDecodeErrorZ CResult_CounterpartyForwardingInfoDecodeErrorZ_clone(const struct LDKCResult_CounterpartyForwardingInfoDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_CounterpartyForwardingInfoDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ChannelCounterpartyDecodeErrorZ CResult_ChannelCounterpartyDecodeErrorZ_ok(struct LDKChannelCounterparty o);
	public static native long CResult_ChannelCounterpartyDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelCounterpartyDecodeErrorZ CResult_ChannelCounterpartyDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelCounterpartyDecodeErrorZ_err(long e);
	// bool CResult_ChannelCounterpartyDecodeErrorZ_is_ok(const struct LDKCResult_ChannelCounterpartyDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelCounterpartyDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelCounterpartyDecodeErrorZ_free(struct LDKCResult_ChannelCounterpartyDecodeErrorZ _res);
	public static native void CResult_ChannelCounterpartyDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelCounterpartyDecodeErrorZ_clone_ptr(LDKCResult_ChannelCounterpartyDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelCounterpartyDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelCounterpartyDecodeErrorZ CResult_ChannelCounterpartyDecodeErrorZ_clone(const struct LDKCResult_ChannelCounterpartyDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelCounterpartyDecodeErrorZ_clone(long orig);
	// struct LDKCOption_ChannelShutdownStateZ COption_ChannelShutdownStateZ_some(enum LDKChannelShutdownState o);
	public static native long COption_ChannelShutdownStateZ_some(ChannelShutdownState o);
	// struct LDKCOption_ChannelShutdownStateZ COption_ChannelShutdownStateZ_none(void);
	public static native long COption_ChannelShutdownStateZ_none();
	// void COption_ChannelShutdownStateZ_free(struct LDKCOption_ChannelShutdownStateZ _res);
	public static native void COption_ChannelShutdownStateZ_free(long _res);
	// uint64_t COption_ChannelShutdownStateZ_clone_ptr(LDKCOption_ChannelShutdownStateZ *NONNULL_PTR arg);
	public static native long COption_ChannelShutdownStateZ_clone_ptr(long arg);
	// struct LDKCOption_ChannelShutdownStateZ COption_ChannelShutdownStateZ_clone(const struct LDKCOption_ChannelShutdownStateZ *NONNULL_PTR orig);
	public static native long COption_ChannelShutdownStateZ_clone(long orig);
	// void CVec_InboundHTLCDetailsZ_free(struct LDKCVec_InboundHTLCDetailsZ _res);
	public static native void CVec_InboundHTLCDetailsZ_free(long[] _res);
	// void CVec_OutboundHTLCDetailsZ_free(struct LDKCVec_OutboundHTLCDetailsZ _res);
	public static native void CVec_OutboundHTLCDetailsZ_free(long[] _res);
	// struct LDKCResult_ChannelDetailsDecodeErrorZ CResult_ChannelDetailsDecodeErrorZ_ok(struct LDKChannelDetails o);
	public static native long CResult_ChannelDetailsDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelDetailsDecodeErrorZ CResult_ChannelDetailsDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelDetailsDecodeErrorZ_err(long e);
	// bool CResult_ChannelDetailsDecodeErrorZ_is_ok(const struct LDKCResult_ChannelDetailsDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelDetailsDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelDetailsDecodeErrorZ_free(struct LDKCResult_ChannelDetailsDecodeErrorZ _res);
	public static native void CResult_ChannelDetailsDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelDetailsDecodeErrorZ_clone_ptr(LDKCResult_ChannelDetailsDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelDetailsDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelDetailsDecodeErrorZ CResult_ChannelDetailsDecodeErrorZ_clone(const struct LDKCResult_ChannelDetailsDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelDetailsDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ChannelShutdownStateDecodeErrorZ CResult_ChannelShutdownStateDecodeErrorZ_ok(enum LDKChannelShutdownState o);
	public static native long CResult_ChannelShutdownStateDecodeErrorZ_ok(ChannelShutdownState o);
	// struct LDKCResult_ChannelShutdownStateDecodeErrorZ CResult_ChannelShutdownStateDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelShutdownStateDecodeErrorZ_err(long e);
	// bool CResult_ChannelShutdownStateDecodeErrorZ_is_ok(const struct LDKCResult_ChannelShutdownStateDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelShutdownStateDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelShutdownStateDecodeErrorZ_free(struct LDKCResult_ChannelShutdownStateDecodeErrorZ _res);
	public static native void CResult_ChannelShutdownStateDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelShutdownStateDecodeErrorZ_clone_ptr(LDKCResult_ChannelShutdownStateDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelShutdownStateDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelShutdownStateDecodeErrorZ CResult_ChannelShutdownStateDecodeErrorZ_clone(const struct LDKCResult_ChannelShutdownStateDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelShutdownStateDecodeErrorZ_clone(long orig);
	// void CVec_FutureZ_free(struct LDKCVec_FutureZ _res);
	public static native void CVec_FutureZ_free(long[] _res);
	// struct LDKCResult_RawLSPSMessageDecodeErrorZ CResult_RawLSPSMessageDecodeErrorZ_ok(struct LDKRawLSPSMessage o);
	public static native long CResult_RawLSPSMessageDecodeErrorZ_ok(long o);
	// struct LDKCResult_RawLSPSMessageDecodeErrorZ CResult_RawLSPSMessageDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_RawLSPSMessageDecodeErrorZ_err(long e);
	// bool CResult_RawLSPSMessageDecodeErrorZ_is_ok(const struct LDKCResult_RawLSPSMessageDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RawLSPSMessageDecodeErrorZ_is_ok(long o);
	// void CResult_RawLSPSMessageDecodeErrorZ_free(struct LDKCResult_RawLSPSMessageDecodeErrorZ _res);
	public static native void CResult_RawLSPSMessageDecodeErrorZ_free(long _res);
	// uint64_t CResult_RawLSPSMessageDecodeErrorZ_clone_ptr(LDKCResult_RawLSPSMessageDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_RawLSPSMessageDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RawLSPSMessageDecodeErrorZ CResult_RawLSPSMessageDecodeErrorZ_clone(const struct LDKCResult_RawLSPSMessageDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_RawLSPSMessageDecodeErrorZ_clone(long orig);
	// struct LDKCResult_LSPSDateTimeNoneZ CResult_LSPSDateTimeNoneZ_ok(struct LDKLSPSDateTime o);
	public static native long CResult_LSPSDateTimeNoneZ_ok(long o);
	// struct LDKCResult_LSPSDateTimeNoneZ CResult_LSPSDateTimeNoneZ_err(void);
	public static native long CResult_LSPSDateTimeNoneZ_err();
	// bool CResult_LSPSDateTimeNoneZ_is_ok(const struct LDKCResult_LSPSDateTimeNoneZ *NONNULL_PTR o);
	public static native boolean CResult_LSPSDateTimeNoneZ_is_ok(long o);
	// void CResult_LSPSDateTimeNoneZ_free(struct LDKCResult_LSPSDateTimeNoneZ _res);
	public static native void CResult_LSPSDateTimeNoneZ_free(long _res);
	// uint64_t CResult_LSPSDateTimeNoneZ_clone_ptr(LDKCResult_LSPSDateTimeNoneZ *NONNULL_PTR arg);
	public static native long CResult_LSPSDateTimeNoneZ_clone_ptr(long arg);
	// struct LDKCResult_LSPSDateTimeNoneZ CResult_LSPSDateTimeNoneZ_clone(const struct LDKCResult_LSPSDateTimeNoneZ *NONNULL_PTR orig);
	public static native long CResult_LSPSDateTimeNoneZ_clone(long orig);
	// struct LDKCResult_HeldHtlcAvailableDecodeErrorZ CResult_HeldHtlcAvailableDecodeErrorZ_ok(struct LDKHeldHtlcAvailable o);
	public static native long CResult_HeldHtlcAvailableDecodeErrorZ_ok(long o);
	// struct LDKCResult_HeldHtlcAvailableDecodeErrorZ CResult_HeldHtlcAvailableDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_HeldHtlcAvailableDecodeErrorZ_err(long e);
	// bool CResult_HeldHtlcAvailableDecodeErrorZ_is_ok(const struct LDKCResult_HeldHtlcAvailableDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_HeldHtlcAvailableDecodeErrorZ_is_ok(long o);
	// void CResult_HeldHtlcAvailableDecodeErrorZ_free(struct LDKCResult_HeldHtlcAvailableDecodeErrorZ _res);
	public static native void CResult_HeldHtlcAvailableDecodeErrorZ_free(long _res);
	// uint64_t CResult_HeldHtlcAvailableDecodeErrorZ_clone_ptr(LDKCResult_HeldHtlcAvailableDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_HeldHtlcAvailableDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_HeldHtlcAvailableDecodeErrorZ CResult_HeldHtlcAvailableDecodeErrorZ_clone(const struct LDKCResult_HeldHtlcAvailableDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_HeldHtlcAvailableDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ReleaseHeldHtlcDecodeErrorZ CResult_ReleaseHeldHtlcDecodeErrorZ_ok(struct LDKReleaseHeldHtlc o);
	public static native long CResult_ReleaseHeldHtlcDecodeErrorZ_ok(long o);
	// struct LDKCResult_ReleaseHeldHtlcDecodeErrorZ CResult_ReleaseHeldHtlcDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ReleaseHeldHtlcDecodeErrorZ_err(long e);
	// bool CResult_ReleaseHeldHtlcDecodeErrorZ_is_ok(const struct LDKCResult_ReleaseHeldHtlcDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ReleaseHeldHtlcDecodeErrorZ_is_ok(long o);
	// void CResult_ReleaseHeldHtlcDecodeErrorZ_free(struct LDKCResult_ReleaseHeldHtlcDecodeErrorZ _res);
	public static native void CResult_ReleaseHeldHtlcDecodeErrorZ_free(long _res);
	// uint64_t CResult_ReleaseHeldHtlcDecodeErrorZ_clone_ptr(LDKCResult_ReleaseHeldHtlcDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ReleaseHeldHtlcDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ReleaseHeldHtlcDecodeErrorZ CResult_ReleaseHeldHtlcDecodeErrorZ_clone(const struct LDKCResult_ReleaseHeldHtlcDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ReleaseHeldHtlcDecodeErrorZ_clone(long orig);
	// struct LDKCResult_AsyncPaymentsMessageDecodeErrorZ CResult_AsyncPaymentsMessageDecodeErrorZ_ok(struct LDKAsyncPaymentsMessage o);
	public static native long CResult_AsyncPaymentsMessageDecodeErrorZ_ok(long o);
	// struct LDKCResult_AsyncPaymentsMessageDecodeErrorZ CResult_AsyncPaymentsMessageDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_AsyncPaymentsMessageDecodeErrorZ_err(long e);
	// bool CResult_AsyncPaymentsMessageDecodeErrorZ_is_ok(const struct LDKCResult_AsyncPaymentsMessageDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_AsyncPaymentsMessageDecodeErrorZ_is_ok(long o);
	// void CResult_AsyncPaymentsMessageDecodeErrorZ_free(struct LDKCResult_AsyncPaymentsMessageDecodeErrorZ _res);
	public static native void CResult_AsyncPaymentsMessageDecodeErrorZ_free(long _res);
	// uint64_t CResult_AsyncPaymentsMessageDecodeErrorZ_clone_ptr(LDKCResult_AsyncPaymentsMessageDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_AsyncPaymentsMessageDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_AsyncPaymentsMessageDecodeErrorZ CResult_AsyncPaymentsMessageDecodeErrorZ_clone(const struct LDKCResult_AsyncPaymentsMessageDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_AsyncPaymentsMessageDecodeErrorZ_clone(long orig);
	// struct LDKCResult_OffersMessageDecodeErrorZ CResult_OffersMessageDecodeErrorZ_ok(struct LDKOffersMessage o);
	public static native long CResult_OffersMessageDecodeErrorZ_ok(long o);
	// struct LDKCResult_OffersMessageDecodeErrorZ CResult_OffersMessageDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_OffersMessageDecodeErrorZ_err(long e);
	// bool CResult_OffersMessageDecodeErrorZ_is_ok(const struct LDKCResult_OffersMessageDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OffersMessageDecodeErrorZ_is_ok(long o);
	// void CResult_OffersMessageDecodeErrorZ_free(struct LDKCResult_OffersMessageDecodeErrorZ _res);
	public static native void CResult_OffersMessageDecodeErrorZ_free(long _res);
	// uint64_t CResult_OffersMessageDecodeErrorZ_clone_ptr(LDKCResult_OffersMessageDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_OffersMessageDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_OffersMessageDecodeErrorZ CResult_OffersMessageDecodeErrorZ_clone(const struct LDKCResult_OffersMessageDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_OffersMessageDecodeErrorZ_clone(long orig);
	// struct LDKCOption_HTLCClaimZ COption_HTLCClaimZ_some(enum LDKHTLCClaim o);
	public static native long COption_HTLCClaimZ_some(HTLCClaim o);
	// struct LDKCOption_HTLCClaimZ COption_HTLCClaimZ_none(void);
	public static native long COption_HTLCClaimZ_none();
	// void COption_HTLCClaimZ_free(struct LDKCOption_HTLCClaimZ _res);
	public static native void COption_HTLCClaimZ_free(long _res);
	// struct LDKCResult_CounterpartyCommitmentSecretsDecodeErrorZ CResult_CounterpartyCommitmentSecretsDecodeErrorZ_ok(struct LDKCounterpartyCommitmentSecrets o);
	public static native long CResult_CounterpartyCommitmentSecretsDecodeErrorZ_ok(long o);
	// struct LDKCResult_CounterpartyCommitmentSecretsDecodeErrorZ CResult_CounterpartyCommitmentSecretsDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_CounterpartyCommitmentSecretsDecodeErrorZ_err(long e);
	// bool CResult_CounterpartyCommitmentSecretsDecodeErrorZ_is_ok(const struct LDKCResult_CounterpartyCommitmentSecretsDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_CounterpartyCommitmentSecretsDecodeErrorZ_is_ok(long o);
	// void CResult_CounterpartyCommitmentSecretsDecodeErrorZ_free(struct LDKCResult_CounterpartyCommitmentSecretsDecodeErrorZ _res);
	public static native void CResult_CounterpartyCommitmentSecretsDecodeErrorZ_free(long _res);
	// uint64_t CResult_CounterpartyCommitmentSecretsDecodeErrorZ_clone_ptr(LDKCResult_CounterpartyCommitmentSecretsDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_CounterpartyCommitmentSecretsDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_CounterpartyCommitmentSecretsDecodeErrorZ CResult_CounterpartyCommitmentSecretsDecodeErrorZ_clone(const struct LDKCResult_CounterpartyCommitmentSecretsDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_CounterpartyCommitmentSecretsDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TxCreationKeysDecodeErrorZ CResult_TxCreationKeysDecodeErrorZ_ok(struct LDKTxCreationKeys o);
	public static native long CResult_TxCreationKeysDecodeErrorZ_ok(long o);
	// struct LDKCResult_TxCreationKeysDecodeErrorZ CResult_TxCreationKeysDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_TxCreationKeysDecodeErrorZ_err(long e);
	// bool CResult_TxCreationKeysDecodeErrorZ_is_ok(const struct LDKCResult_TxCreationKeysDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_TxCreationKeysDecodeErrorZ_is_ok(long o);
	// void CResult_TxCreationKeysDecodeErrorZ_free(struct LDKCResult_TxCreationKeysDecodeErrorZ _res);
	public static native void CResult_TxCreationKeysDecodeErrorZ_free(long _res);
	// uint64_t CResult_TxCreationKeysDecodeErrorZ_clone_ptr(LDKCResult_TxCreationKeysDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_TxCreationKeysDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_TxCreationKeysDecodeErrorZ CResult_TxCreationKeysDecodeErrorZ_clone(const struct LDKCResult_TxCreationKeysDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_TxCreationKeysDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ChannelPublicKeysDecodeErrorZ CResult_ChannelPublicKeysDecodeErrorZ_ok(struct LDKChannelPublicKeys o);
	public static native long CResult_ChannelPublicKeysDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelPublicKeysDecodeErrorZ CResult_ChannelPublicKeysDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelPublicKeysDecodeErrorZ_err(long e);
	// bool CResult_ChannelPublicKeysDecodeErrorZ_is_ok(const struct LDKCResult_ChannelPublicKeysDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelPublicKeysDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelPublicKeysDecodeErrorZ_free(struct LDKCResult_ChannelPublicKeysDecodeErrorZ _res);
	public static native void CResult_ChannelPublicKeysDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelPublicKeysDecodeErrorZ_clone_ptr(LDKCResult_ChannelPublicKeysDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelPublicKeysDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelPublicKeysDecodeErrorZ CResult_ChannelPublicKeysDecodeErrorZ_clone(const struct LDKCResult_ChannelPublicKeysDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelPublicKeysDecodeErrorZ_clone(long orig);
	// struct LDKCResult_HTLCOutputInCommitmentDecodeErrorZ CResult_HTLCOutputInCommitmentDecodeErrorZ_ok(struct LDKHTLCOutputInCommitment o);
	public static native long CResult_HTLCOutputInCommitmentDecodeErrorZ_ok(long o);
	// struct LDKCResult_HTLCOutputInCommitmentDecodeErrorZ CResult_HTLCOutputInCommitmentDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_HTLCOutputInCommitmentDecodeErrorZ_err(long e);
	// bool CResult_HTLCOutputInCommitmentDecodeErrorZ_is_ok(const struct LDKCResult_HTLCOutputInCommitmentDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_HTLCOutputInCommitmentDecodeErrorZ_is_ok(long o);
	// void CResult_HTLCOutputInCommitmentDecodeErrorZ_free(struct LDKCResult_HTLCOutputInCommitmentDecodeErrorZ _res);
	public static native void CResult_HTLCOutputInCommitmentDecodeErrorZ_free(long _res);
	// uint64_t CResult_HTLCOutputInCommitmentDecodeErrorZ_clone_ptr(LDKCResult_HTLCOutputInCommitmentDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_HTLCOutputInCommitmentDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_HTLCOutputInCommitmentDecodeErrorZ CResult_HTLCOutputInCommitmentDecodeErrorZ_clone(const struct LDKCResult_HTLCOutputInCommitmentDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_HTLCOutputInCommitmentDecodeErrorZ_clone(long orig);
	// struct LDKCResult_CounterpartyChannelTransactionParametersDecodeErrorZ CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_ok(struct LDKCounterpartyChannelTransactionParameters o);
	public static native long CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_ok(long o);
	// struct LDKCResult_CounterpartyChannelTransactionParametersDecodeErrorZ CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_err(long e);
	// bool CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_is_ok(const struct LDKCResult_CounterpartyChannelTransactionParametersDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_is_ok(long o);
	// void CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_free(struct LDKCResult_CounterpartyChannelTransactionParametersDecodeErrorZ _res);
	public static native void CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_free(long _res);
	// uint64_t CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_clone_ptr(LDKCResult_CounterpartyChannelTransactionParametersDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_CounterpartyChannelTransactionParametersDecodeErrorZ CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_clone(const struct LDKCResult_CounterpartyChannelTransactionParametersDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_CounterpartyChannelTransactionParametersDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ChannelTransactionParametersDecodeErrorZ CResult_ChannelTransactionParametersDecodeErrorZ_ok(struct LDKChannelTransactionParameters o);
	public static native long CResult_ChannelTransactionParametersDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelTransactionParametersDecodeErrorZ CResult_ChannelTransactionParametersDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelTransactionParametersDecodeErrorZ_err(long e);
	// bool CResult_ChannelTransactionParametersDecodeErrorZ_is_ok(const struct LDKCResult_ChannelTransactionParametersDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelTransactionParametersDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelTransactionParametersDecodeErrorZ_free(struct LDKCResult_ChannelTransactionParametersDecodeErrorZ _res);
	public static native void CResult_ChannelTransactionParametersDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelTransactionParametersDecodeErrorZ_clone_ptr(LDKCResult_ChannelTransactionParametersDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelTransactionParametersDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelTransactionParametersDecodeErrorZ CResult_ChannelTransactionParametersDecodeErrorZ_clone(const struct LDKCResult_ChannelTransactionParametersDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelTransactionParametersDecodeErrorZ_clone(long orig);
	// struct LDKCResult_HolderCommitmentTransactionDecodeErrorZ CResult_HolderCommitmentTransactionDecodeErrorZ_ok(struct LDKHolderCommitmentTransaction o);
	public static native long CResult_HolderCommitmentTransactionDecodeErrorZ_ok(long o);
	// struct LDKCResult_HolderCommitmentTransactionDecodeErrorZ CResult_HolderCommitmentTransactionDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_HolderCommitmentTransactionDecodeErrorZ_err(long e);
	// bool CResult_HolderCommitmentTransactionDecodeErrorZ_is_ok(const struct LDKCResult_HolderCommitmentTransactionDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_HolderCommitmentTransactionDecodeErrorZ_is_ok(long o);
	// void CResult_HolderCommitmentTransactionDecodeErrorZ_free(struct LDKCResult_HolderCommitmentTransactionDecodeErrorZ _res);
	public static native void CResult_HolderCommitmentTransactionDecodeErrorZ_free(long _res);
	// uint64_t CResult_HolderCommitmentTransactionDecodeErrorZ_clone_ptr(LDKCResult_HolderCommitmentTransactionDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_HolderCommitmentTransactionDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_HolderCommitmentTransactionDecodeErrorZ CResult_HolderCommitmentTransactionDecodeErrorZ_clone(const struct LDKCResult_HolderCommitmentTransactionDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_HolderCommitmentTransactionDecodeErrorZ_clone(long orig);
	// struct LDKCResult_BuiltCommitmentTransactionDecodeErrorZ CResult_BuiltCommitmentTransactionDecodeErrorZ_ok(struct LDKBuiltCommitmentTransaction o);
	public static native long CResult_BuiltCommitmentTransactionDecodeErrorZ_ok(long o);
	// struct LDKCResult_BuiltCommitmentTransactionDecodeErrorZ CResult_BuiltCommitmentTransactionDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_BuiltCommitmentTransactionDecodeErrorZ_err(long e);
	// bool CResult_BuiltCommitmentTransactionDecodeErrorZ_is_ok(const struct LDKCResult_BuiltCommitmentTransactionDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_BuiltCommitmentTransactionDecodeErrorZ_is_ok(long o);
	// void CResult_BuiltCommitmentTransactionDecodeErrorZ_free(struct LDKCResult_BuiltCommitmentTransactionDecodeErrorZ _res);
	public static native void CResult_BuiltCommitmentTransactionDecodeErrorZ_free(long _res);
	// uint64_t CResult_BuiltCommitmentTransactionDecodeErrorZ_clone_ptr(LDKCResult_BuiltCommitmentTransactionDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_BuiltCommitmentTransactionDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_BuiltCommitmentTransactionDecodeErrorZ CResult_BuiltCommitmentTransactionDecodeErrorZ_clone(const struct LDKCResult_BuiltCommitmentTransactionDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_BuiltCommitmentTransactionDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TrustedClosingTransactionNoneZ CResult_TrustedClosingTransactionNoneZ_ok(struct LDKTrustedClosingTransaction o);
	public static native long CResult_TrustedClosingTransactionNoneZ_ok(long o);
	// struct LDKCResult_TrustedClosingTransactionNoneZ CResult_TrustedClosingTransactionNoneZ_err(void);
	public static native long CResult_TrustedClosingTransactionNoneZ_err();
	// bool CResult_TrustedClosingTransactionNoneZ_is_ok(const struct LDKCResult_TrustedClosingTransactionNoneZ *NONNULL_PTR o);
	public static native boolean CResult_TrustedClosingTransactionNoneZ_is_ok(long o);
	// void CResult_TrustedClosingTransactionNoneZ_free(struct LDKCResult_TrustedClosingTransactionNoneZ _res);
	public static native void CResult_TrustedClosingTransactionNoneZ_free(long _res);
	// struct LDKCResult_CommitmentTransactionDecodeErrorZ CResult_CommitmentTransactionDecodeErrorZ_ok(struct LDKCommitmentTransaction o);
	public static native long CResult_CommitmentTransactionDecodeErrorZ_ok(long o);
	// struct LDKCResult_CommitmentTransactionDecodeErrorZ CResult_CommitmentTransactionDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_CommitmentTransactionDecodeErrorZ_err(long e);
	// bool CResult_CommitmentTransactionDecodeErrorZ_is_ok(const struct LDKCResult_CommitmentTransactionDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_CommitmentTransactionDecodeErrorZ_is_ok(long o);
	// void CResult_CommitmentTransactionDecodeErrorZ_free(struct LDKCResult_CommitmentTransactionDecodeErrorZ _res);
	public static native void CResult_CommitmentTransactionDecodeErrorZ_free(long _res);
	// uint64_t CResult_CommitmentTransactionDecodeErrorZ_clone_ptr(LDKCResult_CommitmentTransactionDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_CommitmentTransactionDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_CommitmentTransactionDecodeErrorZ CResult_CommitmentTransactionDecodeErrorZ_clone(const struct LDKCResult_CommitmentTransactionDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_CommitmentTransactionDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TrustedCommitmentTransactionNoneZ CResult_TrustedCommitmentTransactionNoneZ_ok(struct LDKTrustedCommitmentTransaction o);
	public static native long CResult_TrustedCommitmentTransactionNoneZ_ok(long o);
	// struct LDKCResult_TrustedCommitmentTransactionNoneZ CResult_TrustedCommitmentTransactionNoneZ_err(void);
	public static native long CResult_TrustedCommitmentTransactionNoneZ_err();
	// bool CResult_TrustedCommitmentTransactionNoneZ_is_ok(const struct LDKCResult_TrustedCommitmentTransactionNoneZ *NONNULL_PTR o);
	public static native boolean CResult_TrustedCommitmentTransactionNoneZ_is_ok(long o);
	// void CResult_TrustedCommitmentTransactionNoneZ_free(struct LDKCResult_TrustedCommitmentTransactionNoneZ _res);
	public static native void CResult_TrustedCommitmentTransactionNoneZ_free(long _res);
	// struct LDKCResult_CVec_ECDSASignatureZNoneZ CResult_CVec_ECDSASignatureZNoneZ_ok(struct LDKCVec_ECDSASignatureZ o);
	public static native long CResult_CVec_ECDSASignatureZNoneZ_ok(byte[][] o);
	// struct LDKCResult_CVec_ECDSASignatureZNoneZ CResult_CVec_ECDSASignatureZNoneZ_err(void);
	public static native long CResult_CVec_ECDSASignatureZNoneZ_err();
	// bool CResult_CVec_ECDSASignatureZNoneZ_is_ok(const struct LDKCResult_CVec_ECDSASignatureZNoneZ *NONNULL_PTR o);
	public static native boolean CResult_CVec_ECDSASignatureZNoneZ_is_ok(long o);
	// void CResult_CVec_ECDSASignatureZNoneZ_free(struct LDKCResult_CVec_ECDSASignatureZNoneZ _res);
	public static native void CResult_CVec_ECDSASignatureZNoneZ_free(long _res);
	// uint64_t CResult_CVec_ECDSASignatureZNoneZ_clone_ptr(LDKCResult_CVec_ECDSASignatureZNoneZ *NONNULL_PTR arg);
	public static native long CResult_CVec_ECDSASignatureZNoneZ_clone_ptr(long arg);
	// struct LDKCResult_CVec_ECDSASignatureZNoneZ CResult_CVec_ECDSASignatureZNoneZ_clone(const struct LDKCResult_CVec_ECDSASignatureZNoneZ *NONNULL_PTR orig);
	public static native long CResult_CVec_ECDSASignatureZNoneZ_clone(long orig);
	// struct LDKCOption_usizeZ COption_usizeZ_some(uintptr_t o);
	public static native long COption_usizeZ_some(long o);
	// struct LDKCOption_usizeZ COption_usizeZ_none(void);
	public static native long COption_usizeZ_none();
	// void COption_usizeZ_free(struct LDKCOption_usizeZ _res);
	public static native void COption_usizeZ_free(long _res);
	// uint64_t COption_usizeZ_clone_ptr(LDKCOption_usizeZ *NONNULL_PTR arg);
	public static native long COption_usizeZ_clone_ptr(long arg);
	// struct LDKCOption_usizeZ COption_usizeZ_clone(const struct LDKCOption_usizeZ *NONNULL_PTR orig);
	public static native long COption_usizeZ_clone(long orig);
	// struct LDKCResult_ShutdownScriptDecodeErrorZ CResult_ShutdownScriptDecodeErrorZ_ok(struct LDKShutdownScript o);
	public static native long CResult_ShutdownScriptDecodeErrorZ_ok(long o);
	// struct LDKCResult_ShutdownScriptDecodeErrorZ CResult_ShutdownScriptDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ShutdownScriptDecodeErrorZ_err(long e);
	// bool CResult_ShutdownScriptDecodeErrorZ_is_ok(const struct LDKCResult_ShutdownScriptDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ShutdownScriptDecodeErrorZ_is_ok(long o);
	// void CResult_ShutdownScriptDecodeErrorZ_free(struct LDKCResult_ShutdownScriptDecodeErrorZ _res);
	public static native void CResult_ShutdownScriptDecodeErrorZ_free(long _res);
	// uint64_t CResult_ShutdownScriptDecodeErrorZ_clone_ptr(LDKCResult_ShutdownScriptDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ShutdownScriptDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ShutdownScriptDecodeErrorZ CResult_ShutdownScriptDecodeErrorZ_clone(const struct LDKCResult_ShutdownScriptDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ShutdownScriptDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ShutdownScriptInvalidShutdownScriptZ CResult_ShutdownScriptInvalidShutdownScriptZ_ok(struct LDKShutdownScript o);
	public static native long CResult_ShutdownScriptInvalidShutdownScriptZ_ok(long o);
	// struct LDKCResult_ShutdownScriptInvalidShutdownScriptZ CResult_ShutdownScriptInvalidShutdownScriptZ_err(struct LDKInvalidShutdownScript e);
	public static native long CResult_ShutdownScriptInvalidShutdownScriptZ_err(long e);
	// bool CResult_ShutdownScriptInvalidShutdownScriptZ_is_ok(const struct LDKCResult_ShutdownScriptInvalidShutdownScriptZ *NONNULL_PTR o);
	public static native boolean CResult_ShutdownScriptInvalidShutdownScriptZ_is_ok(long o);
	// void CResult_ShutdownScriptInvalidShutdownScriptZ_free(struct LDKCResult_ShutdownScriptInvalidShutdownScriptZ _res);
	public static native void CResult_ShutdownScriptInvalidShutdownScriptZ_free(long _res);
	// uint64_t CResult_ShutdownScriptInvalidShutdownScriptZ_clone_ptr(LDKCResult_ShutdownScriptInvalidShutdownScriptZ *NONNULL_PTR arg);
	public static native long CResult_ShutdownScriptInvalidShutdownScriptZ_clone_ptr(long arg);
	// struct LDKCResult_ShutdownScriptInvalidShutdownScriptZ CResult_ShutdownScriptInvalidShutdownScriptZ_clone(const struct LDKCResult_ShutdownScriptInvalidShutdownScriptZ *NONNULL_PTR orig);
	public static native long CResult_ShutdownScriptInvalidShutdownScriptZ_clone(long orig);
	// void CVec_TransactionZ_free(struct LDKCVec_TransactionZ _res);
	public static native void CVec_TransactionZ_free(byte[][] _res);
	// struct LDKCResult_u64NoneZ CResult_u64NoneZ_ok(uint64_t o);
	public static native long CResult_u64NoneZ_ok(long o);
	// struct LDKCResult_u64NoneZ CResult_u64NoneZ_err(void);
	public static native long CResult_u64NoneZ_err();
	// bool CResult_u64NoneZ_is_ok(const struct LDKCResult_u64NoneZ *NONNULL_PTR o);
	public static native boolean CResult_u64NoneZ_is_ok(long o);
	// void CResult_u64NoneZ_free(struct LDKCResult_u64NoneZ _res);
	public static native void CResult_u64NoneZ_free(long _res);
	// uint64_t CResult_u64NoneZ_clone_ptr(LDKCResult_u64NoneZ *NONNULL_PTR arg);
	public static native long CResult_u64NoneZ_clone_ptr(long arg);
	// struct LDKCResult_u64NoneZ CResult_u64NoneZ_clone(const struct LDKCResult_u64NoneZ *NONNULL_PTR orig);
	public static native long CResult_u64NoneZ_clone(long orig);
	// struct LDKCResult_FundingInfoDecodeErrorZ CResult_FundingInfoDecodeErrorZ_ok(struct LDKFundingInfo o);
	public static native long CResult_FundingInfoDecodeErrorZ_ok(long o);
	// struct LDKCResult_FundingInfoDecodeErrorZ CResult_FundingInfoDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_FundingInfoDecodeErrorZ_err(long e);
	// bool CResult_FundingInfoDecodeErrorZ_is_ok(const struct LDKCResult_FundingInfoDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_FundingInfoDecodeErrorZ_is_ok(long o);
	// void CResult_FundingInfoDecodeErrorZ_free(struct LDKCResult_FundingInfoDecodeErrorZ _res);
	public static native void CResult_FundingInfoDecodeErrorZ_free(long _res);
	// uint64_t CResult_FundingInfoDecodeErrorZ_clone_ptr(LDKCResult_FundingInfoDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_FundingInfoDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_FundingInfoDecodeErrorZ CResult_FundingInfoDecodeErrorZ_clone(const struct LDKCResult_FundingInfoDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_FundingInfoDecodeErrorZ_clone(long orig);
	// struct LDKCResult_PaymentPurposeDecodeErrorZ CResult_PaymentPurposeDecodeErrorZ_ok(struct LDKPaymentPurpose o);
	public static native long CResult_PaymentPurposeDecodeErrorZ_ok(long o);
	// struct LDKCResult_PaymentPurposeDecodeErrorZ CResult_PaymentPurposeDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_PaymentPurposeDecodeErrorZ_err(long e);
	// bool CResult_PaymentPurposeDecodeErrorZ_is_ok(const struct LDKCResult_PaymentPurposeDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_PaymentPurposeDecodeErrorZ_is_ok(long o);
	// void CResult_PaymentPurposeDecodeErrorZ_free(struct LDKCResult_PaymentPurposeDecodeErrorZ _res);
	public static native void CResult_PaymentPurposeDecodeErrorZ_free(long _res);
	// uint64_t CResult_PaymentPurposeDecodeErrorZ_clone_ptr(LDKCResult_PaymentPurposeDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_PaymentPurposeDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_PaymentPurposeDecodeErrorZ CResult_PaymentPurposeDecodeErrorZ_clone(const struct LDKCResult_PaymentPurposeDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_PaymentPurposeDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ClaimedHTLCDecodeErrorZ CResult_ClaimedHTLCDecodeErrorZ_ok(struct LDKClaimedHTLC o);
	public static native long CResult_ClaimedHTLCDecodeErrorZ_ok(long o);
	// struct LDKCResult_ClaimedHTLCDecodeErrorZ CResult_ClaimedHTLCDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ClaimedHTLCDecodeErrorZ_err(long e);
	// bool CResult_ClaimedHTLCDecodeErrorZ_is_ok(const struct LDKCResult_ClaimedHTLCDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ClaimedHTLCDecodeErrorZ_is_ok(long o);
	// void CResult_ClaimedHTLCDecodeErrorZ_free(struct LDKCResult_ClaimedHTLCDecodeErrorZ _res);
	public static native void CResult_ClaimedHTLCDecodeErrorZ_free(long _res);
	// uint64_t CResult_ClaimedHTLCDecodeErrorZ_clone_ptr(LDKCResult_ClaimedHTLCDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ClaimedHTLCDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ClaimedHTLCDecodeErrorZ CResult_ClaimedHTLCDecodeErrorZ_clone(const struct LDKCResult_ClaimedHTLCDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ClaimedHTLCDecodeErrorZ_clone(long orig);
	// struct LDKCOption_PathFailureZ COption_PathFailureZ_some(struct LDKPathFailure o);
	public static native long COption_PathFailureZ_some(long o);
	// struct LDKCOption_PathFailureZ COption_PathFailureZ_none(void);
	public static native long COption_PathFailureZ_none();
	// void COption_PathFailureZ_free(struct LDKCOption_PathFailureZ _res);
	public static native void COption_PathFailureZ_free(long _res);
	// uint64_t COption_PathFailureZ_clone_ptr(LDKCOption_PathFailureZ *NONNULL_PTR arg);
	public static native long COption_PathFailureZ_clone_ptr(long arg);
	// struct LDKCOption_PathFailureZ COption_PathFailureZ_clone(const struct LDKCOption_PathFailureZ *NONNULL_PTR orig);
	public static native long COption_PathFailureZ_clone(long orig);
	// struct LDKCResult_COption_PathFailureZDecodeErrorZ CResult_COption_PathFailureZDecodeErrorZ_ok(struct LDKCOption_PathFailureZ o);
	public static native long CResult_COption_PathFailureZDecodeErrorZ_ok(long o);
	// struct LDKCResult_COption_PathFailureZDecodeErrorZ CResult_COption_PathFailureZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_COption_PathFailureZDecodeErrorZ_err(long e);
	// bool CResult_COption_PathFailureZDecodeErrorZ_is_ok(const struct LDKCResult_COption_PathFailureZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_COption_PathFailureZDecodeErrorZ_is_ok(long o);
	// void CResult_COption_PathFailureZDecodeErrorZ_free(struct LDKCResult_COption_PathFailureZDecodeErrorZ _res);
	public static native void CResult_COption_PathFailureZDecodeErrorZ_free(long _res);
	// uint64_t CResult_COption_PathFailureZDecodeErrorZ_clone_ptr(LDKCResult_COption_PathFailureZDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_COption_PathFailureZDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_COption_PathFailureZDecodeErrorZ CResult_COption_PathFailureZDecodeErrorZ_clone(const struct LDKCResult_COption_PathFailureZDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_COption_PathFailureZDecodeErrorZ_clone(long orig);
	// struct LDKCOption_ClosureReasonZ COption_ClosureReasonZ_some(struct LDKClosureReason o);
	public static native long COption_ClosureReasonZ_some(long o);
	// struct LDKCOption_ClosureReasonZ COption_ClosureReasonZ_none(void);
	public static native long COption_ClosureReasonZ_none();
	// void COption_ClosureReasonZ_free(struct LDKCOption_ClosureReasonZ _res);
	public static native void COption_ClosureReasonZ_free(long _res);
	// uint64_t COption_ClosureReasonZ_clone_ptr(LDKCOption_ClosureReasonZ *NONNULL_PTR arg);
	public static native long COption_ClosureReasonZ_clone_ptr(long arg);
	// struct LDKCOption_ClosureReasonZ COption_ClosureReasonZ_clone(const struct LDKCOption_ClosureReasonZ *NONNULL_PTR orig);
	public static native long COption_ClosureReasonZ_clone(long orig);
	// struct LDKCResult_COption_ClosureReasonZDecodeErrorZ CResult_COption_ClosureReasonZDecodeErrorZ_ok(struct LDKCOption_ClosureReasonZ o);
	public static native long CResult_COption_ClosureReasonZDecodeErrorZ_ok(long o);
	// struct LDKCResult_COption_ClosureReasonZDecodeErrorZ CResult_COption_ClosureReasonZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_COption_ClosureReasonZDecodeErrorZ_err(long e);
	// bool CResult_COption_ClosureReasonZDecodeErrorZ_is_ok(const struct LDKCResult_COption_ClosureReasonZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_COption_ClosureReasonZDecodeErrorZ_is_ok(long o);
	// void CResult_COption_ClosureReasonZDecodeErrorZ_free(struct LDKCResult_COption_ClosureReasonZDecodeErrorZ _res);
	public static native void CResult_COption_ClosureReasonZDecodeErrorZ_free(long _res);
	// uint64_t CResult_COption_ClosureReasonZDecodeErrorZ_clone_ptr(LDKCResult_COption_ClosureReasonZDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_COption_ClosureReasonZDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_COption_ClosureReasonZDecodeErrorZ CResult_COption_ClosureReasonZDecodeErrorZ_clone(const struct LDKCResult_COption_ClosureReasonZDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_COption_ClosureReasonZDecodeErrorZ_clone(long orig);
	// struct LDKCOption_HTLCDestinationZ COption_HTLCDestinationZ_some(struct LDKHTLCDestination o);
	public static native long COption_HTLCDestinationZ_some(long o);
	// struct LDKCOption_HTLCDestinationZ COption_HTLCDestinationZ_none(void);
	public static native long COption_HTLCDestinationZ_none();
	// void COption_HTLCDestinationZ_free(struct LDKCOption_HTLCDestinationZ _res);
	public static native void COption_HTLCDestinationZ_free(long _res);
	// uint64_t COption_HTLCDestinationZ_clone_ptr(LDKCOption_HTLCDestinationZ *NONNULL_PTR arg);
	public static native long COption_HTLCDestinationZ_clone_ptr(long arg);
	// struct LDKCOption_HTLCDestinationZ COption_HTLCDestinationZ_clone(const struct LDKCOption_HTLCDestinationZ *NONNULL_PTR orig);
	public static native long COption_HTLCDestinationZ_clone(long orig);
	// struct LDKCResult_COption_HTLCDestinationZDecodeErrorZ CResult_COption_HTLCDestinationZDecodeErrorZ_ok(struct LDKCOption_HTLCDestinationZ o);
	public static native long CResult_COption_HTLCDestinationZDecodeErrorZ_ok(long o);
	// struct LDKCResult_COption_HTLCDestinationZDecodeErrorZ CResult_COption_HTLCDestinationZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_COption_HTLCDestinationZDecodeErrorZ_err(long e);
	// bool CResult_COption_HTLCDestinationZDecodeErrorZ_is_ok(const struct LDKCResult_COption_HTLCDestinationZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_COption_HTLCDestinationZDecodeErrorZ_is_ok(long o);
	// void CResult_COption_HTLCDestinationZDecodeErrorZ_free(struct LDKCResult_COption_HTLCDestinationZDecodeErrorZ _res);
	public static native void CResult_COption_HTLCDestinationZDecodeErrorZ_free(long _res);
	// uint64_t CResult_COption_HTLCDestinationZDecodeErrorZ_clone_ptr(LDKCResult_COption_HTLCDestinationZDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_COption_HTLCDestinationZDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_COption_HTLCDestinationZDecodeErrorZ CResult_COption_HTLCDestinationZDecodeErrorZ_clone(const struct LDKCResult_COption_HTLCDestinationZDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_COption_HTLCDestinationZDecodeErrorZ_clone(long orig);
	// struct LDKCOption_PaymentFailureReasonZ COption_PaymentFailureReasonZ_some(enum LDKPaymentFailureReason o);
	public static native long COption_PaymentFailureReasonZ_some(PaymentFailureReason o);
	// struct LDKCOption_PaymentFailureReasonZ COption_PaymentFailureReasonZ_none(void);
	public static native long COption_PaymentFailureReasonZ_none();
	// void COption_PaymentFailureReasonZ_free(struct LDKCOption_PaymentFailureReasonZ _res);
	public static native void COption_PaymentFailureReasonZ_free(long _res);
	// uint64_t COption_PaymentFailureReasonZ_clone_ptr(LDKCOption_PaymentFailureReasonZ *NONNULL_PTR arg);
	public static native long COption_PaymentFailureReasonZ_clone_ptr(long arg);
	// struct LDKCOption_PaymentFailureReasonZ COption_PaymentFailureReasonZ_clone(const struct LDKCOption_PaymentFailureReasonZ *NONNULL_PTR orig);
	public static native long COption_PaymentFailureReasonZ_clone(long orig);
	// struct LDKCResult_COption_PaymentFailureReasonZDecodeErrorZ CResult_COption_PaymentFailureReasonZDecodeErrorZ_ok(struct LDKCOption_PaymentFailureReasonZ o);
	public static native long CResult_COption_PaymentFailureReasonZDecodeErrorZ_ok(long o);
	// struct LDKCResult_COption_PaymentFailureReasonZDecodeErrorZ CResult_COption_PaymentFailureReasonZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_COption_PaymentFailureReasonZDecodeErrorZ_err(long e);
	// bool CResult_COption_PaymentFailureReasonZDecodeErrorZ_is_ok(const struct LDKCResult_COption_PaymentFailureReasonZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_COption_PaymentFailureReasonZDecodeErrorZ_is_ok(long o);
	// void CResult_COption_PaymentFailureReasonZDecodeErrorZ_free(struct LDKCResult_COption_PaymentFailureReasonZDecodeErrorZ _res);
	public static native void CResult_COption_PaymentFailureReasonZDecodeErrorZ_free(long _res);
	// uint64_t CResult_COption_PaymentFailureReasonZDecodeErrorZ_clone_ptr(LDKCResult_COption_PaymentFailureReasonZDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_COption_PaymentFailureReasonZDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_COption_PaymentFailureReasonZDecodeErrorZ CResult_COption_PaymentFailureReasonZDecodeErrorZ_clone(const struct LDKCResult_COption_PaymentFailureReasonZDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_COption_PaymentFailureReasonZDecodeErrorZ_clone(long orig);
	// struct LDKCOption_U128Z COption_U128Z_some(struct LDKU128 o);
	public static native long COption_U128Z_some(byte[] o);
	// struct LDKCOption_U128Z COption_U128Z_none(void);
	public static native long COption_U128Z_none();
	// void COption_U128Z_free(struct LDKCOption_U128Z _res);
	public static native void COption_U128Z_free(long _res);
	// uint64_t COption_U128Z_clone_ptr(LDKCOption_U128Z *NONNULL_PTR arg);
	public static native long COption_U128Z_clone_ptr(long arg);
	// struct LDKCOption_U128Z COption_U128Z_clone(const struct LDKCOption_U128Z *NONNULL_PTR orig);
	public static native long COption_U128Z_clone(long orig);
	// void CVec_ClaimedHTLCZ_free(struct LDKCVec_ClaimedHTLCZ _res);
	public static native void CVec_ClaimedHTLCZ_free(long[] _res);
	// struct LDKCOption_EventZ COption_EventZ_some(struct LDKEvent o);
	public static native long COption_EventZ_some(long o);
	// struct LDKCOption_EventZ COption_EventZ_none(void);
	public static native long COption_EventZ_none();
	// void COption_EventZ_free(struct LDKCOption_EventZ _res);
	public static native void COption_EventZ_free(long _res);
	// uint64_t COption_EventZ_clone_ptr(LDKCOption_EventZ *NONNULL_PTR arg);
	public static native long COption_EventZ_clone_ptr(long arg);
	// struct LDKCOption_EventZ COption_EventZ_clone(const struct LDKCOption_EventZ *NONNULL_PTR orig);
	public static native long COption_EventZ_clone(long orig);
	// struct LDKCResult_COption_EventZDecodeErrorZ CResult_COption_EventZDecodeErrorZ_ok(struct LDKCOption_EventZ o);
	public static native long CResult_COption_EventZDecodeErrorZ_ok(long o);
	// struct LDKCResult_COption_EventZDecodeErrorZ CResult_COption_EventZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_COption_EventZDecodeErrorZ_err(long e);
	// bool CResult_COption_EventZDecodeErrorZ_is_ok(const struct LDKCResult_COption_EventZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_COption_EventZDecodeErrorZ_is_ok(long o);
	// void CResult_COption_EventZDecodeErrorZ_free(struct LDKCResult_COption_EventZDecodeErrorZ _res);
	public static native void CResult_COption_EventZDecodeErrorZ_free(long _res);
	// uint64_t CResult_COption_EventZDecodeErrorZ_clone_ptr(LDKCResult_COption_EventZDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_COption_EventZDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_COption_EventZDecodeErrorZ CResult_COption_EventZDecodeErrorZ_clone(const struct LDKCResult_COption_EventZDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_COption_EventZDecodeErrorZ_clone(long orig);
	// struct LDKCResult_NonceDecodeErrorZ CResult_NonceDecodeErrorZ_ok(struct LDKNonce o);
	public static native long CResult_NonceDecodeErrorZ_ok(long o);
	// struct LDKCResult_NonceDecodeErrorZ CResult_NonceDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_NonceDecodeErrorZ_err(long e);
	// bool CResult_NonceDecodeErrorZ_is_ok(const struct LDKCResult_NonceDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NonceDecodeErrorZ_is_ok(long o);
	// void CResult_NonceDecodeErrorZ_free(struct LDKCResult_NonceDecodeErrorZ _res);
	public static native void CResult_NonceDecodeErrorZ_free(long _res);
	// uint64_t CResult_NonceDecodeErrorZ_clone_ptr(LDKCResult_NonceDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_NonceDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NonceDecodeErrorZ CResult_NonceDecodeErrorZ_clone(const struct LDKCResult_NonceDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_NonceDecodeErrorZ_clone(long orig);
	// void CVec_RouteHintHopZ_free(struct LDKCVec_RouteHintHopZ _res);
	public static native void CVec_RouteHintHopZ_free(long[] _res);
	// struct LDKCResult_SiPrefixBolt11ParseErrorZ CResult_SiPrefixBolt11ParseErrorZ_ok(enum LDKSiPrefix o);
	public static native long CResult_SiPrefixBolt11ParseErrorZ_ok(SiPrefix o);
	// struct LDKCResult_SiPrefixBolt11ParseErrorZ CResult_SiPrefixBolt11ParseErrorZ_err(struct LDKBolt11ParseError e);
	public static native long CResult_SiPrefixBolt11ParseErrorZ_err(long e);
	// bool CResult_SiPrefixBolt11ParseErrorZ_is_ok(const struct LDKCResult_SiPrefixBolt11ParseErrorZ *NONNULL_PTR o);
	public static native boolean CResult_SiPrefixBolt11ParseErrorZ_is_ok(long o);
	// void CResult_SiPrefixBolt11ParseErrorZ_free(struct LDKCResult_SiPrefixBolt11ParseErrorZ _res);
	public static native void CResult_SiPrefixBolt11ParseErrorZ_free(long _res);
	// uint64_t CResult_SiPrefixBolt11ParseErrorZ_clone_ptr(LDKCResult_SiPrefixBolt11ParseErrorZ *NONNULL_PTR arg);
	public static native long CResult_SiPrefixBolt11ParseErrorZ_clone_ptr(long arg);
	// struct LDKCResult_SiPrefixBolt11ParseErrorZ CResult_SiPrefixBolt11ParseErrorZ_clone(const struct LDKCResult_SiPrefixBolt11ParseErrorZ *NONNULL_PTR orig);
	public static native long CResult_SiPrefixBolt11ParseErrorZ_clone(long orig);
	// struct LDKCResult_Bolt11InvoiceParseOrSemanticErrorZ CResult_Bolt11InvoiceParseOrSemanticErrorZ_ok(struct LDKBolt11Invoice o);
	public static native long CResult_Bolt11InvoiceParseOrSemanticErrorZ_ok(long o);
	// struct LDKCResult_Bolt11InvoiceParseOrSemanticErrorZ CResult_Bolt11InvoiceParseOrSemanticErrorZ_err(struct LDKParseOrSemanticError e);
	public static native long CResult_Bolt11InvoiceParseOrSemanticErrorZ_err(long e);
	// bool CResult_Bolt11InvoiceParseOrSemanticErrorZ_is_ok(const struct LDKCResult_Bolt11InvoiceParseOrSemanticErrorZ *NONNULL_PTR o);
	public static native boolean CResult_Bolt11InvoiceParseOrSemanticErrorZ_is_ok(long o);
	// void CResult_Bolt11InvoiceParseOrSemanticErrorZ_free(struct LDKCResult_Bolt11InvoiceParseOrSemanticErrorZ _res);
	public static native void CResult_Bolt11InvoiceParseOrSemanticErrorZ_free(long _res);
	// uint64_t CResult_Bolt11InvoiceParseOrSemanticErrorZ_clone_ptr(LDKCResult_Bolt11InvoiceParseOrSemanticErrorZ *NONNULL_PTR arg);
	public static native long CResult_Bolt11InvoiceParseOrSemanticErrorZ_clone_ptr(long arg);
	// struct LDKCResult_Bolt11InvoiceParseOrSemanticErrorZ CResult_Bolt11InvoiceParseOrSemanticErrorZ_clone(const struct LDKCResult_Bolt11InvoiceParseOrSemanticErrorZ *NONNULL_PTR orig);
	public static native long CResult_Bolt11InvoiceParseOrSemanticErrorZ_clone(long orig);
	// struct LDKCResult_SignedRawBolt11InvoiceBolt11ParseErrorZ CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_ok(struct LDKSignedRawBolt11Invoice o);
	public static native long CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_ok(long o);
	// struct LDKCResult_SignedRawBolt11InvoiceBolt11ParseErrorZ CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_err(struct LDKBolt11ParseError e);
	public static native long CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_err(long e);
	// bool CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_is_ok(const struct LDKCResult_SignedRawBolt11InvoiceBolt11ParseErrorZ *NONNULL_PTR o);
	public static native boolean CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_is_ok(long o);
	// void CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_free(struct LDKCResult_SignedRawBolt11InvoiceBolt11ParseErrorZ _res);
	public static native void CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_free(long _res);
	// uint64_t CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_clone_ptr(LDKCResult_SignedRawBolt11InvoiceBolt11ParseErrorZ *NONNULL_PTR arg);
	public static native long CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_clone_ptr(long arg);
	// struct LDKCResult_SignedRawBolt11InvoiceBolt11ParseErrorZ CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_clone(const struct LDKCResult_SignedRawBolt11InvoiceBolt11ParseErrorZ *NONNULL_PTR orig);
	public static native long CResult_SignedRawBolt11InvoiceBolt11ParseErrorZ_clone(long orig);
	// uint64_t C3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ_clone_ptr(LDKC3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ *NONNULL_PTR arg);
	public static native long C3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ_clone_ptr(long arg);
	// struct LDKC3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ C3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ_clone(const struct LDKC3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ *NONNULL_PTR orig);
	public static native long C3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ_clone(long orig);
	// struct LDKC3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ C3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ_new(struct LDKRawBolt11Invoice a, struct LDKThirtyTwoBytes b, struct LDKBolt11InvoiceSignature c);
	public static native long C3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ_new(long a, byte[] b, long c);
	// void C3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ_free(struct LDKC3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ _res);
	public static native void C3Tuple_RawBolt11Invoice_u832Bolt11InvoiceSignatureZ_free(long _res);
	// struct LDKCResult_PayeePubKeySecp256k1ErrorZ CResult_PayeePubKeySecp256k1ErrorZ_ok(struct LDKPayeePubKey o);
	public static native long CResult_PayeePubKeySecp256k1ErrorZ_ok(long o);
	// struct LDKCResult_PayeePubKeySecp256k1ErrorZ CResult_PayeePubKeySecp256k1ErrorZ_err(enum LDKSecp256k1Error e);
	public static native long CResult_PayeePubKeySecp256k1ErrorZ_err(Secp256k1Error e);
	// bool CResult_PayeePubKeySecp256k1ErrorZ_is_ok(const struct LDKCResult_PayeePubKeySecp256k1ErrorZ *NONNULL_PTR o);
	public static native boolean CResult_PayeePubKeySecp256k1ErrorZ_is_ok(long o);
	// void CResult_PayeePubKeySecp256k1ErrorZ_free(struct LDKCResult_PayeePubKeySecp256k1ErrorZ _res);
	public static native void CResult_PayeePubKeySecp256k1ErrorZ_free(long _res);
	// uint64_t CResult_PayeePubKeySecp256k1ErrorZ_clone_ptr(LDKCResult_PayeePubKeySecp256k1ErrorZ *NONNULL_PTR arg);
	public static native long CResult_PayeePubKeySecp256k1ErrorZ_clone_ptr(long arg);
	// struct LDKCResult_PayeePubKeySecp256k1ErrorZ CResult_PayeePubKeySecp256k1ErrorZ_clone(const struct LDKCResult_PayeePubKeySecp256k1ErrorZ *NONNULL_PTR orig);
	public static native long CResult_PayeePubKeySecp256k1ErrorZ_clone(long orig);
	// void CVec_PrivateRouteZ_free(struct LDKCVec_PrivateRouteZ _res);
	public static native void CVec_PrivateRouteZ_free(long[] _res);
	// struct LDKCResult_PositiveTimestampCreationErrorZ CResult_PositiveTimestampCreationErrorZ_ok(struct LDKPositiveTimestamp o);
	public static native long CResult_PositiveTimestampCreationErrorZ_ok(long o);
	// struct LDKCResult_PositiveTimestampCreationErrorZ CResult_PositiveTimestampCreationErrorZ_err(enum LDKCreationError e);
	public static native long CResult_PositiveTimestampCreationErrorZ_err(CreationError e);
	// bool CResult_PositiveTimestampCreationErrorZ_is_ok(const struct LDKCResult_PositiveTimestampCreationErrorZ *NONNULL_PTR o);
	public static native boolean CResult_PositiveTimestampCreationErrorZ_is_ok(long o);
	// void CResult_PositiveTimestampCreationErrorZ_free(struct LDKCResult_PositiveTimestampCreationErrorZ _res);
	public static native void CResult_PositiveTimestampCreationErrorZ_free(long _res);
	// uint64_t CResult_PositiveTimestampCreationErrorZ_clone_ptr(LDKCResult_PositiveTimestampCreationErrorZ *NONNULL_PTR arg);
	public static native long CResult_PositiveTimestampCreationErrorZ_clone_ptr(long arg);
	// struct LDKCResult_PositiveTimestampCreationErrorZ CResult_PositiveTimestampCreationErrorZ_clone(const struct LDKCResult_PositiveTimestampCreationErrorZ *NONNULL_PTR orig);
	public static native long CResult_PositiveTimestampCreationErrorZ_clone(long orig);
	// struct LDKCResult_NoneBolt11SemanticErrorZ CResult_NoneBolt11SemanticErrorZ_ok(void);
	public static native long CResult_NoneBolt11SemanticErrorZ_ok();
	// struct LDKCResult_NoneBolt11SemanticErrorZ CResult_NoneBolt11SemanticErrorZ_err(enum LDKBolt11SemanticError e);
	public static native long CResult_NoneBolt11SemanticErrorZ_err(Bolt11SemanticError e);
	// bool CResult_NoneBolt11SemanticErrorZ_is_ok(const struct LDKCResult_NoneBolt11SemanticErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NoneBolt11SemanticErrorZ_is_ok(long o);
	// void CResult_NoneBolt11SemanticErrorZ_free(struct LDKCResult_NoneBolt11SemanticErrorZ _res);
	public static native void CResult_NoneBolt11SemanticErrorZ_free(long _res);
	// uint64_t CResult_NoneBolt11SemanticErrorZ_clone_ptr(LDKCResult_NoneBolt11SemanticErrorZ *NONNULL_PTR arg);
	public static native long CResult_NoneBolt11SemanticErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NoneBolt11SemanticErrorZ CResult_NoneBolt11SemanticErrorZ_clone(const struct LDKCResult_NoneBolt11SemanticErrorZ *NONNULL_PTR orig);
	public static native long CResult_NoneBolt11SemanticErrorZ_clone(long orig);
	// struct LDKCResult_Bolt11InvoiceBolt11SemanticErrorZ CResult_Bolt11InvoiceBolt11SemanticErrorZ_ok(struct LDKBolt11Invoice o);
	public static native long CResult_Bolt11InvoiceBolt11SemanticErrorZ_ok(long o);
	// struct LDKCResult_Bolt11InvoiceBolt11SemanticErrorZ CResult_Bolt11InvoiceBolt11SemanticErrorZ_err(enum LDKBolt11SemanticError e);
	public static native long CResult_Bolt11InvoiceBolt11SemanticErrorZ_err(Bolt11SemanticError e);
	// bool CResult_Bolt11InvoiceBolt11SemanticErrorZ_is_ok(const struct LDKCResult_Bolt11InvoiceBolt11SemanticErrorZ *NONNULL_PTR o);
	public static native boolean CResult_Bolt11InvoiceBolt11SemanticErrorZ_is_ok(long o);
	// void CResult_Bolt11InvoiceBolt11SemanticErrorZ_free(struct LDKCResult_Bolt11InvoiceBolt11SemanticErrorZ _res);
	public static native void CResult_Bolt11InvoiceBolt11SemanticErrorZ_free(long _res);
	// uint64_t CResult_Bolt11InvoiceBolt11SemanticErrorZ_clone_ptr(LDKCResult_Bolt11InvoiceBolt11SemanticErrorZ *NONNULL_PTR arg);
	public static native long CResult_Bolt11InvoiceBolt11SemanticErrorZ_clone_ptr(long arg);
	// struct LDKCResult_Bolt11InvoiceBolt11SemanticErrorZ CResult_Bolt11InvoiceBolt11SemanticErrorZ_clone(const struct LDKCResult_Bolt11InvoiceBolt11SemanticErrorZ *NONNULL_PTR orig);
	public static native long CResult_Bolt11InvoiceBolt11SemanticErrorZ_clone(long orig);
	// struct LDKCResult_DescriptionCreationErrorZ CResult_DescriptionCreationErrorZ_ok(struct LDKDescription o);
	public static native long CResult_DescriptionCreationErrorZ_ok(long o);
	// struct LDKCResult_DescriptionCreationErrorZ CResult_DescriptionCreationErrorZ_err(enum LDKCreationError e);
	public static native long CResult_DescriptionCreationErrorZ_err(CreationError e);
	// bool CResult_DescriptionCreationErrorZ_is_ok(const struct LDKCResult_DescriptionCreationErrorZ *NONNULL_PTR o);
	public static native boolean CResult_DescriptionCreationErrorZ_is_ok(long o);
	// void CResult_DescriptionCreationErrorZ_free(struct LDKCResult_DescriptionCreationErrorZ _res);
	public static native void CResult_DescriptionCreationErrorZ_free(long _res);
	// uint64_t CResult_DescriptionCreationErrorZ_clone_ptr(LDKCResult_DescriptionCreationErrorZ *NONNULL_PTR arg);
	public static native long CResult_DescriptionCreationErrorZ_clone_ptr(long arg);
	// struct LDKCResult_DescriptionCreationErrorZ CResult_DescriptionCreationErrorZ_clone(const struct LDKCResult_DescriptionCreationErrorZ *NONNULL_PTR orig);
	public static native long CResult_DescriptionCreationErrorZ_clone(long orig);
	// struct LDKCResult_PrivateRouteCreationErrorZ CResult_PrivateRouteCreationErrorZ_ok(struct LDKPrivateRoute o);
	public static native long CResult_PrivateRouteCreationErrorZ_ok(long o);
	// struct LDKCResult_PrivateRouteCreationErrorZ CResult_PrivateRouteCreationErrorZ_err(enum LDKCreationError e);
	public static native long CResult_PrivateRouteCreationErrorZ_err(CreationError e);
	// bool CResult_PrivateRouteCreationErrorZ_is_ok(const struct LDKCResult_PrivateRouteCreationErrorZ *NONNULL_PTR o);
	public static native boolean CResult_PrivateRouteCreationErrorZ_is_ok(long o);
	// void CResult_PrivateRouteCreationErrorZ_free(struct LDKCResult_PrivateRouteCreationErrorZ _res);
	public static native void CResult_PrivateRouteCreationErrorZ_free(long _res);
	// uint64_t CResult_PrivateRouteCreationErrorZ_clone_ptr(LDKCResult_PrivateRouteCreationErrorZ *NONNULL_PTR arg);
	public static native long CResult_PrivateRouteCreationErrorZ_clone_ptr(long arg);
	// struct LDKCResult_PrivateRouteCreationErrorZ CResult_PrivateRouteCreationErrorZ_clone(const struct LDKCResult_PrivateRouteCreationErrorZ *NONNULL_PTR orig);
	public static native long CResult_PrivateRouteCreationErrorZ_clone(long orig);
	// struct LDKCResult_OutPointDecodeErrorZ CResult_OutPointDecodeErrorZ_ok(struct LDKOutPoint o);
	public static native long CResult_OutPointDecodeErrorZ_ok(long o);
	// struct LDKCResult_OutPointDecodeErrorZ CResult_OutPointDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_OutPointDecodeErrorZ_err(long e);
	// bool CResult_OutPointDecodeErrorZ_is_ok(const struct LDKCResult_OutPointDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OutPointDecodeErrorZ_is_ok(long o);
	// void CResult_OutPointDecodeErrorZ_free(struct LDKCResult_OutPointDecodeErrorZ _res);
	public static native void CResult_OutPointDecodeErrorZ_free(long _res);
	// uint64_t CResult_OutPointDecodeErrorZ_clone_ptr(LDKCResult_OutPointDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_OutPointDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_OutPointDecodeErrorZ CResult_OutPointDecodeErrorZ_clone(const struct LDKCResult_OutPointDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_OutPointDecodeErrorZ_clone(long orig);
	// struct LDKCResult_BigSizeDecodeErrorZ CResult_BigSizeDecodeErrorZ_ok(struct LDKBigSize o);
	public static native long CResult_BigSizeDecodeErrorZ_ok(long o);
	// struct LDKCResult_BigSizeDecodeErrorZ CResult_BigSizeDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_BigSizeDecodeErrorZ_err(long e);
	// bool CResult_BigSizeDecodeErrorZ_is_ok(const struct LDKCResult_BigSizeDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_BigSizeDecodeErrorZ_is_ok(long o);
	// void CResult_BigSizeDecodeErrorZ_free(struct LDKCResult_BigSizeDecodeErrorZ _res);
	public static native void CResult_BigSizeDecodeErrorZ_free(long _res);
	// uint64_t CResult_BigSizeDecodeErrorZ_clone_ptr(LDKCResult_BigSizeDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_BigSizeDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_BigSizeDecodeErrorZ CResult_BigSizeDecodeErrorZ_clone(const struct LDKCResult_BigSizeDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_BigSizeDecodeErrorZ_clone(long orig);
	// struct LDKCResult_UntrustedStringDecodeErrorZ CResult_UntrustedStringDecodeErrorZ_ok(struct LDKUntrustedString o);
	public static native long CResult_UntrustedStringDecodeErrorZ_ok(long o);
	// struct LDKCResult_UntrustedStringDecodeErrorZ CResult_UntrustedStringDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_UntrustedStringDecodeErrorZ_err(long e);
	// bool CResult_UntrustedStringDecodeErrorZ_is_ok(const struct LDKCResult_UntrustedStringDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_UntrustedStringDecodeErrorZ_is_ok(long o);
	// void CResult_UntrustedStringDecodeErrorZ_free(struct LDKCResult_UntrustedStringDecodeErrorZ _res);
	public static native void CResult_UntrustedStringDecodeErrorZ_free(long _res);
	// uint64_t CResult_UntrustedStringDecodeErrorZ_clone_ptr(LDKCResult_UntrustedStringDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_UntrustedStringDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_UntrustedStringDecodeErrorZ CResult_UntrustedStringDecodeErrorZ_clone(const struct LDKCResult_UntrustedStringDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_UntrustedStringDecodeErrorZ_clone(long orig);
	// struct LDKCResult_HostnameDecodeErrorZ CResult_HostnameDecodeErrorZ_ok(struct LDKHostname o);
	public static native long CResult_HostnameDecodeErrorZ_ok(long o);
	// struct LDKCResult_HostnameDecodeErrorZ CResult_HostnameDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_HostnameDecodeErrorZ_err(long e);
	// bool CResult_HostnameDecodeErrorZ_is_ok(const struct LDKCResult_HostnameDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_HostnameDecodeErrorZ_is_ok(long o);
	// void CResult_HostnameDecodeErrorZ_free(struct LDKCResult_HostnameDecodeErrorZ _res);
	public static native void CResult_HostnameDecodeErrorZ_free(long _res);
	// uint64_t CResult_HostnameDecodeErrorZ_clone_ptr(LDKCResult_HostnameDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_HostnameDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_HostnameDecodeErrorZ CResult_HostnameDecodeErrorZ_clone(const struct LDKCResult_HostnameDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_HostnameDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TransactionU16LenLimitedNoneZ CResult_TransactionU16LenLimitedNoneZ_ok(struct LDKTransactionU16LenLimited o);
	public static native long CResult_TransactionU16LenLimitedNoneZ_ok(long o);
	// struct LDKCResult_TransactionU16LenLimitedNoneZ CResult_TransactionU16LenLimitedNoneZ_err(void);
	public static native long CResult_TransactionU16LenLimitedNoneZ_err();
	// bool CResult_TransactionU16LenLimitedNoneZ_is_ok(const struct LDKCResult_TransactionU16LenLimitedNoneZ *NONNULL_PTR o);
	public static native boolean CResult_TransactionU16LenLimitedNoneZ_is_ok(long o);
	// void CResult_TransactionU16LenLimitedNoneZ_free(struct LDKCResult_TransactionU16LenLimitedNoneZ _res);
	public static native void CResult_TransactionU16LenLimitedNoneZ_free(long _res);
	// uint64_t CResult_TransactionU16LenLimitedNoneZ_clone_ptr(LDKCResult_TransactionU16LenLimitedNoneZ *NONNULL_PTR arg);
	public static native long CResult_TransactionU16LenLimitedNoneZ_clone_ptr(long arg);
	// struct LDKCResult_TransactionU16LenLimitedNoneZ CResult_TransactionU16LenLimitedNoneZ_clone(const struct LDKCResult_TransactionU16LenLimitedNoneZ *NONNULL_PTR orig);
	public static native long CResult_TransactionU16LenLimitedNoneZ_clone(long orig);
	// struct LDKCResult_TransactionU16LenLimitedDecodeErrorZ CResult_TransactionU16LenLimitedDecodeErrorZ_ok(struct LDKTransactionU16LenLimited o);
	public static native long CResult_TransactionU16LenLimitedDecodeErrorZ_ok(long o);
	// struct LDKCResult_TransactionU16LenLimitedDecodeErrorZ CResult_TransactionU16LenLimitedDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_TransactionU16LenLimitedDecodeErrorZ_err(long e);
	// bool CResult_TransactionU16LenLimitedDecodeErrorZ_is_ok(const struct LDKCResult_TransactionU16LenLimitedDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_TransactionU16LenLimitedDecodeErrorZ_is_ok(long o);
	// void CResult_TransactionU16LenLimitedDecodeErrorZ_free(struct LDKCResult_TransactionU16LenLimitedDecodeErrorZ _res);
	public static native void CResult_TransactionU16LenLimitedDecodeErrorZ_free(long _res);
	// uint64_t CResult_TransactionU16LenLimitedDecodeErrorZ_clone_ptr(LDKCResult_TransactionU16LenLimitedDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_TransactionU16LenLimitedDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_TransactionU16LenLimitedDecodeErrorZ CResult_TransactionU16LenLimitedDecodeErrorZ_clone(const struct LDKCResult_TransactionU16LenLimitedDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_TransactionU16LenLimitedDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ChannelIdDecodeErrorZ CResult_ChannelIdDecodeErrorZ_ok(struct LDKChannelId o);
	public static native long CResult_ChannelIdDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelIdDecodeErrorZ CResult_ChannelIdDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelIdDecodeErrorZ_err(long e);
	// bool CResult_ChannelIdDecodeErrorZ_is_ok(const struct LDKCResult_ChannelIdDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelIdDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelIdDecodeErrorZ_free(struct LDKCResult_ChannelIdDecodeErrorZ _res);
	public static native void CResult_ChannelIdDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelIdDecodeErrorZ_clone_ptr(LDKCResult_ChannelIdDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelIdDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelIdDecodeErrorZ CResult_ChannelIdDecodeErrorZ_clone(const struct LDKCResult_ChannelIdDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelIdDecodeErrorZ_clone(long orig);
	// struct LDKCResult_InitFeaturesDecodeErrorZ CResult_InitFeaturesDecodeErrorZ_ok(struct LDKInitFeatures o);
	public static native long CResult_InitFeaturesDecodeErrorZ_ok(long o);
	// struct LDKCResult_InitFeaturesDecodeErrorZ CResult_InitFeaturesDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_InitFeaturesDecodeErrorZ_err(long e);
	// bool CResult_InitFeaturesDecodeErrorZ_is_ok(const struct LDKCResult_InitFeaturesDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_InitFeaturesDecodeErrorZ_is_ok(long o);
	// void CResult_InitFeaturesDecodeErrorZ_free(struct LDKCResult_InitFeaturesDecodeErrorZ _res);
	public static native void CResult_InitFeaturesDecodeErrorZ_free(long _res);
	// uint64_t CResult_InitFeaturesDecodeErrorZ_clone_ptr(LDKCResult_InitFeaturesDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_InitFeaturesDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_InitFeaturesDecodeErrorZ CResult_InitFeaturesDecodeErrorZ_clone(const struct LDKCResult_InitFeaturesDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_InitFeaturesDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ChannelFeaturesDecodeErrorZ CResult_ChannelFeaturesDecodeErrorZ_ok(struct LDKChannelFeatures o);
	public static native long CResult_ChannelFeaturesDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelFeaturesDecodeErrorZ CResult_ChannelFeaturesDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelFeaturesDecodeErrorZ_err(long e);
	// bool CResult_ChannelFeaturesDecodeErrorZ_is_ok(const struct LDKCResult_ChannelFeaturesDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelFeaturesDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelFeaturesDecodeErrorZ_free(struct LDKCResult_ChannelFeaturesDecodeErrorZ _res);
	public static native void CResult_ChannelFeaturesDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelFeaturesDecodeErrorZ_clone_ptr(LDKCResult_ChannelFeaturesDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelFeaturesDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelFeaturesDecodeErrorZ CResult_ChannelFeaturesDecodeErrorZ_clone(const struct LDKCResult_ChannelFeaturesDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelFeaturesDecodeErrorZ_clone(long orig);
	// struct LDKCResult_NodeFeaturesDecodeErrorZ CResult_NodeFeaturesDecodeErrorZ_ok(struct LDKNodeFeatures o);
	public static native long CResult_NodeFeaturesDecodeErrorZ_ok(long o);
	// struct LDKCResult_NodeFeaturesDecodeErrorZ CResult_NodeFeaturesDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_NodeFeaturesDecodeErrorZ_err(long e);
	// bool CResult_NodeFeaturesDecodeErrorZ_is_ok(const struct LDKCResult_NodeFeaturesDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NodeFeaturesDecodeErrorZ_is_ok(long o);
	// void CResult_NodeFeaturesDecodeErrorZ_free(struct LDKCResult_NodeFeaturesDecodeErrorZ _res);
	public static native void CResult_NodeFeaturesDecodeErrorZ_free(long _res);
	// uint64_t CResult_NodeFeaturesDecodeErrorZ_clone_ptr(LDKCResult_NodeFeaturesDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_NodeFeaturesDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NodeFeaturesDecodeErrorZ CResult_NodeFeaturesDecodeErrorZ_clone(const struct LDKCResult_NodeFeaturesDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_NodeFeaturesDecodeErrorZ_clone(long orig);
	// struct LDKCResult_Bolt11InvoiceFeaturesDecodeErrorZ CResult_Bolt11InvoiceFeaturesDecodeErrorZ_ok(struct LDKBolt11InvoiceFeatures o);
	public static native long CResult_Bolt11InvoiceFeaturesDecodeErrorZ_ok(long o);
	// struct LDKCResult_Bolt11InvoiceFeaturesDecodeErrorZ CResult_Bolt11InvoiceFeaturesDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_Bolt11InvoiceFeaturesDecodeErrorZ_err(long e);
	// bool CResult_Bolt11InvoiceFeaturesDecodeErrorZ_is_ok(const struct LDKCResult_Bolt11InvoiceFeaturesDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_Bolt11InvoiceFeaturesDecodeErrorZ_is_ok(long o);
	// void CResult_Bolt11InvoiceFeaturesDecodeErrorZ_free(struct LDKCResult_Bolt11InvoiceFeaturesDecodeErrorZ _res);
	public static native void CResult_Bolt11InvoiceFeaturesDecodeErrorZ_free(long _res);
	// uint64_t CResult_Bolt11InvoiceFeaturesDecodeErrorZ_clone_ptr(LDKCResult_Bolt11InvoiceFeaturesDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_Bolt11InvoiceFeaturesDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_Bolt11InvoiceFeaturesDecodeErrorZ CResult_Bolt11InvoiceFeaturesDecodeErrorZ_clone(const struct LDKCResult_Bolt11InvoiceFeaturesDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_Bolt11InvoiceFeaturesDecodeErrorZ_clone(long orig);
	// struct LDKCResult_Bolt12InvoiceFeaturesDecodeErrorZ CResult_Bolt12InvoiceFeaturesDecodeErrorZ_ok(struct LDKBolt12InvoiceFeatures o);
	public static native long CResult_Bolt12InvoiceFeaturesDecodeErrorZ_ok(long o);
	// struct LDKCResult_Bolt12InvoiceFeaturesDecodeErrorZ CResult_Bolt12InvoiceFeaturesDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_Bolt12InvoiceFeaturesDecodeErrorZ_err(long e);
	// bool CResult_Bolt12InvoiceFeaturesDecodeErrorZ_is_ok(const struct LDKCResult_Bolt12InvoiceFeaturesDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_Bolt12InvoiceFeaturesDecodeErrorZ_is_ok(long o);
	// void CResult_Bolt12InvoiceFeaturesDecodeErrorZ_free(struct LDKCResult_Bolt12InvoiceFeaturesDecodeErrorZ _res);
	public static native void CResult_Bolt12InvoiceFeaturesDecodeErrorZ_free(long _res);
	// uint64_t CResult_Bolt12InvoiceFeaturesDecodeErrorZ_clone_ptr(LDKCResult_Bolt12InvoiceFeaturesDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_Bolt12InvoiceFeaturesDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_Bolt12InvoiceFeaturesDecodeErrorZ CResult_Bolt12InvoiceFeaturesDecodeErrorZ_clone(const struct LDKCResult_Bolt12InvoiceFeaturesDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_Bolt12InvoiceFeaturesDecodeErrorZ_clone(long orig);
	// struct LDKCResult_BlindedHopFeaturesDecodeErrorZ CResult_BlindedHopFeaturesDecodeErrorZ_ok(struct LDKBlindedHopFeatures o);
	public static native long CResult_BlindedHopFeaturesDecodeErrorZ_ok(long o);
	// struct LDKCResult_BlindedHopFeaturesDecodeErrorZ CResult_BlindedHopFeaturesDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_BlindedHopFeaturesDecodeErrorZ_err(long e);
	// bool CResult_BlindedHopFeaturesDecodeErrorZ_is_ok(const struct LDKCResult_BlindedHopFeaturesDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_BlindedHopFeaturesDecodeErrorZ_is_ok(long o);
	// void CResult_BlindedHopFeaturesDecodeErrorZ_free(struct LDKCResult_BlindedHopFeaturesDecodeErrorZ _res);
	public static native void CResult_BlindedHopFeaturesDecodeErrorZ_free(long _res);
	// uint64_t CResult_BlindedHopFeaturesDecodeErrorZ_clone_ptr(LDKCResult_BlindedHopFeaturesDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_BlindedHopFeaturesDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_BlindedHopFeaturesDecodeErrorZ CResult_BlindedHopFeaturesDecodeErrorZ_clone(const struct LDKCResult_BlindedHopFeaturesDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_BlindedHopFeaturesDecodeErrorZ_clone(long orig);
	// struct LDKCResult_ChannelTypeFeaturesDecodeErrorZ CResult_ChannelTypeFeaturesDecodeErrorZ_ok(struct LDKChannelTypeFeatures o);
	public static native long CResult_ChannelTypeFeaturesDecodeErrorZ_ok(long o);
	// struct LDKCResult_ChannelTypeFeaturesDecodeErrorZ CResult_ChannelTypeFeaturesDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ChannelTypeFeaturesDecodeErrorZ_err(long e);
	// bool CResult_ChannelTypeFeaturesDecodeErrorZ_is_ok(const struct LDKCResult_ChannelTypeFeaturesDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ChannelTypeFeaturesDecodeErrorZ_is_ok(long o);
	// void CResult_ChannelTypeFeaturesDecodeErrorZ_free(struct LDKCResult_ChannelTypeFeaturesDecodeErrorZ _res);
	public static native void CResult_ChannelTypeFeaturesDecodeErrorZ_free(long _res);
	// uint64_t CResult_ChannelTypeFeaturesDecodeErrorZ_clone_ptr(LDKCResult_ChannelTypeFeaturesDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ChannelTypeFeaturesDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ChannelTypeFeaturesDecodeErrorZ CResult_ChannelTypeFeaturesDecodeErrorZ_clone(const struct LDKCResult_ChannelTypeFeaturesDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ChannelTypeFeaturesDecodeErrorZ_clone(long orig);
	// uint64_t C2Tuple__u832u16Z_clone_ptr(LDKC2Tuple__u832u16Z *NONNULL_PTR arg);
	public static native long C2Tuple__u832u16Z_clone_ptr(long arg);
	// struct LDKC2Tuple__u832u16Z C2Tuple__u832u16Z_clone(const struct LDKC2Tuple__u832u16Z *NONNULL_PTR orig);
	public static native long C2Tuple__u832u16Z_clone(long orig);
	// struct LDKC2Tuple__u832u16Z C2Tuple__u832u16Z_new(struct LDKThirtyTwoBytes a, uint16_t b);
	public static native long C2Tuple__u832u16Z_new(byte[] a, short b);
	// void C2Tuple__u832u16Z_free(struct LDKC2Tuple__u832u16Z _res);
	public static native void C2Tuple__u832u16Z_free(long _res);
	// struct LDKCResult_BlindedPayInfoDecodeErrorZ CResult_BlindedPayInfoDecodeErrorZ_ok(struct LDKBlindedPayInfo o);
	public static native long CResult_BlindedPayInfoDecodeErrorZ_ok(long o);
	// struct LDKCResult_BlindedPayInfoDecodeErrorZ CResult_BlindedPayInfoDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_BlindedPayInfoDecodeErrorZ_err(long e);
	// bool CResult_BlindedPayInfoDecodeErrorZ_is_ok(const struct LDKCResult_BlindedPayInfoDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_BlindedPayInfoDecodeErrorZ_is_ok(long o);
	// void CResult_BlindedPayInfoDecodeErrorZ_free(struct LDKCResult_BlindedPayInfoDecodeErrorZ _res);
	public static native void CResult_BlindedPayInfoDecodeErrorZ_free(long _res);
	// uint64_t CResult_BlindedPayInfoDecodeErrorZ_clone_ptr(LDKCResult_BlindedPayInfoDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_BlindedPayInfoDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_BlindedPayInfoDecodeErrorZ CResult_BlindedPayInfoDecodeErrorZ_clone(const struct LDKCResult_BlindedPayInfoDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_BlindedPayInfoDecodeErrorZ_clone(long orig);
	// struct LDKCResult_BlindedPaymentPathNoneZ CResult_BlindedPaymentPathNoneZ_ok(struct LDKBlindedPaymentPath o);
	public static native long CResult_BlindedPaymentPathNoneZ_ok(long o);
	// struct LDKCResult_BlindedPaymentPathNoneZ CResult_BlindedPaymentPathNoneZ_err(void);
	public static native long CResult_BlindedPaymentPathNoneZ_err();
	// bool CResult_BlindedPaymentPathNoneZ_is_ok(const struct LDKCResult_BlindedPaymentPathNoneZ *NONNULL_PTR o);
	public static native boolean CResult_BlindedPaymentPathNoneZ_is_ok(long o);
	// void CResult_BlindedPaymentPathNoneZ_free(struct LDKCResult_BlindedPaymentPathNoneZ _res);
	public static native void CResult_BlindedPaymentPathNoneZ_free(long _res);
	// uint64_t CResult_BlindedPaymentPathNoneZ_clone_ptr(LDKCResult_BlindedPaymentPathNoneZ *NONNULL_PTR arg);
	public static native long CResult_BlindedPaymentPathNoneZ_clone_ptr(long arg);
	// struct LDKCResult_BlindedPaymentPathNoneZ CResult_BlindedPaymentPathNoneZ_clone(const struct LDKCResult_BlindedPaymentPathNoneZ *NONNULL_PTR orig);
	public static native long CResult_BlindedPaymentPathNoneZ_clone(long orig);
	// void CVec_PaymentForwardNodeZ_free(struct LDKCVec_PaymentForwardNodeZ _res);
	public static native void CVec_PaymentForwardNodeZ_free(long[] _res);
	// struct LDKCResult_PaymentRelayDecodeErrorZ CResult_PaymentRelayDecodeErrorZ_ok(struct LDKPaymentRelay o);
	public static native long CResult_PaymentRelayDecodeErrorZ_ok(long o);
	// struct LDKCResult_PaymentRelayDecodeErrorZ CResult_PaymentRelayDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_PaymentRelayDecodeErrorZ_err(long e);
	// bool CResult_PaymentRelayDecodeErrorZ_is_ok(const struct LDKCResult_PaymentRelayDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_PaymentRelayDecodeErrorZ_is_ok(long o);
	// void CResult_PaymentRelayDecodeErrorZ_free(struct LDKCResult_PaymentRelayDecodeErrorZ _res);
	public static native void CResult_PaymentRelayDecodeErrorZ_free(long _res);
	// uint64_t CResult_PaymentRelayDecodeErrorZ_clone_ptr(LDKCResult_PaymentRelayDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_PaymentRelayDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_PaymentRelayDecodeErrorZ CResult_PaymentRelayDecodeErrorZ_clone(const struct LDKCResult_PaymentRelayDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_PaymentRelayDecodeErrorZ_clone(long orig);
	// struct LDKCResult_PaymentConstraintsDecodeErrorZ CResult_PaymentConstraintsDecodeErrorZ_ok(struct LDKPaymentConstraints o);
	public static native long CResult_PaymentConstraintsDecodeErrorZ_ok(long o);
	// struct LDKCResult_PaymentConstraintsDecodeErrorZ CResult_PaymentConstraintsDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_PaymentConstraintsDecodeErrorZ_err(long e);
	// bool CResult_PaymentConstraintsDecodeErrorZ_is_ok(const struct LDKCResult_PaymentConstraintsDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_PaymentConstraintsDecodeErrorZ_is_ok(long o);
	// void CResult_PaymentConstraintsDecodeErrorZ_free(struct LDKCResult_PaymentConstraintsDecodeErrorZ _res);
	public static native void CResult_PaymentConstraintsDecodeErrorZ_free(long _res);
	// uint64_t CResult_PaymentConstraintsDecodeErrorZ_clone_ptr(LDKCResult_PaymentConstraintsDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_PaymentConstraintsDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_PaymentConstraintsDecodeErrorZ CResult_PaymentConstraintsDecodeErrorZ_clone(const struct LDKCResult_PaymentConstraintsDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_PaymentConstraintsDecodeErrorZ_clone(long orig);
	// struct LDKCResult_PaymentContextDecodeErrorZ CResult_PaymentContextDecodeErrorZ_ok(struct LDKPaymentContext o);
	public static native long CResult_PaymentContextDecodeErrorZ_ok(long o);
	// struct LDKCResult_PaymentContextDecodeErrorZ CResult_PaymentContextDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_PaymentContextDecodeErrorZ_err(long e);
	// bool CResult_PaymentContextDecodeErrorZ_is_ok(const struct LDKCResult_PaymentContextDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_PaymentContextDecodeErrorZ_is_ok(long o);
	// void CResult_PaymentContextDecodeErrorZ_free(struct LDKCResult_PaymentContextDecodeErrorZ _res);
	public static native void CResult_PaymentContextDecodeErrorZ_free(long _res);
	// uint64_t CResult_PaymentContextDecodeErrorZ_clone_ptr(LDKCResult_PaymentContextDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_PaymentContextDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_PaymentContextDecodeErrorZ CResult_PaymentContextDecodeErrorZ_clone(const struct LDKCResult_PaymentContextDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_PaymentContextDecodeErrorZ_clone(long orig);
	// struct LDKCResult_Bolt12OfferContextDecodeErrorZ CResult_Bolt12OfferContextDecodeErrorZ_ok(struct LDKBolt12OfferContext o);
	public static native long CResult_Bolt12OfferContextDecodeErrorZ_ok(long o);
	// struct LDKCResult_Bolt12OfferContextDecodeErrorZ CResult_Bolt12OfferContextDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_Bolt12OfferContextDecodeErrorZ_err(long e);
	// bool CResult_Bolt12OfferContextDecodeErrorZ_is_ok(const struct LDKCResult_Bolt12OfferContextDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_Bolt12OfferContextDecodeErrorZ_is_ok(long o);
	// void CResult_Bolt12OfferContextDecodeErrorZ_free(struct LDKCResult_Bolt12OfferContextDecodeErrorZ _res);
	public static native void CResult_Bolt12OfferContextDecodeErrorZ_free(long _res);
	// uint64_t CResult_Bolt12OfferContextDecodeErrorZ_clone_ptr(LDKCResult_Bolt12OfferContextDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_Bolt12OfferContextDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_Bolt12OfferContextDecodeErrorZ CResult_Bolt12OfferContextDecodeErrorZ_clone(const struct LDKCResult_Bolt12OfferContextDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_Bolt12OfferContextDecodeErrorZ_clone(long orig);
	// struct LDKCResult_Bolt12RefundContextDecodeErrorZ CResult_Bolt12RefundContextDecodeErrorZ_ok(struct LDKBolt12RefundContext o);
	public static native long CResult_Bolt12RefundContextDecodeErrorZ_ok(long o);
	// struct LDKCResult_Bolt12RefundContextDecodeErrorZ CResult_Bolt12RefundContextDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_Bolt12RefundContextDecodeErrorZ_err(long e);
	// bool CResult_Bolt12RefundContextDecodeErrorZ_is_ok(const struct LDKCResult_Bolt12RefundContextDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_Bolt12RefundContextDecodeErrorZ_is_ok(long o);
	// void CResult_Bolt12RefundContextDecodeErrorZ_free(struct LDKCResult_Bolt12RefundContextDecodeErrorZ _res);
	public static native void CResult_Bolt12RefundContextDecodeErrorZ_free(long _res);
	// uint64_t CResult_Bolt12RefundContextDecodeErrorZ_clone_ptr(LDKCResult_Bolt12RefundContextDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_Bolt12RefundContextDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_Bolt12RefundContextDecodeErrorZ CResult_Bolt12RefundContextDecodeErrorZ_clone(const struct LDKCResult_Bolt12RefundContextDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_Bolt12RefundContextDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TxOutUtxoLookupErrorZ CResult_TxOutUtxoLookupErrorZ_ok(struct LDKTxOut o);
	public static native long CResult_TxOutUtxoLookupErrorZ_ok(long o);
	// struct LDKCResult_TxOutUtxoLookupErrorZ CResult_TxOutUtxoLookupErrorZ_err(enum LDKUtxoLookupError e);
	public static native long CResult_TxOutUtxoLookupErrorZ_err(UtxoLookupError e);
	// bool CResult_TxOutUtxoLookupErrorZ_is_ok(const struct LDKCResult_TxOutUtxoLookupErrorZ *NONNULL_PTR o);
	public static native boolean CResult_TxOutUtxoLookupErrorZ_is_ok(long o);
	// void CResult_TxOutUtxoLookupErrorZ_free(struct LDKCResult_TxOutUtxoLookupErrorZ _res);
	public static native void CResult_TxOutUtxoLookupErrorZ_free(long _res);
	// uint64_t CResult_TxOutUtxoLookupErrorZ_clone_ptr(LDKCResult_TxOutUtxoLookupErrorZ *NONNULL_PTR arg);
	public static native long CResult_TxOutUtxoLookupErrorZ_clone_ptr(long arg);
	// struct LDKCResult_TxOutUtxoLookupErrorZ CResult_TxOutUtxoLookupErrorZ_clone(const struct LDKCResult_TxOutUtxoLookupErrorZ *NONNULL_PTR orig);
	public static native long CResult_TxOutUtxoLookupErrorZ_clone(long orig);
	// struct LDKCResult_ResponderDecodeErrorZ CResult_ResponderDecodeErrorZ_ok(struct LDKResponder o);
	public static native long CResult_ResponderDecodeErrorZ_ok(long o);
	// struct LDKCResult_ResponderDecodeErrorZ CResult_ResponderDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_ResponderDecodeErrorZ_err(long e);
	// bool CResult_ResponderDecodeErrorZ_is_ok(const struct LDKCResult_ResponderDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_ResponderDecodeErrorZ_is_ok(long o);
	// void CResult_ResponderDecodeErrorZ_free(struct LDKCResult_ResponderDecodeErrorZ _res);
	public static native void CResult_ResponderDecodeErrorZ_free(long _res);
	// uint64_t CResult_ResponderDecodeErrorZ_clone_ptr(LDKCResult_ResponderDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_ResponderDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_ResponderDecodeErrorZ CResult_ResponderDecodeErrorZ_clone(const struct LDKCResult_ResponderDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_ResponderDecodeErrorZ_clone(long orig);
	// struct LDKCResult_OnionMessagePathNoneZ CResult_OnionMessagePathNoneZ_ok(struct LDKOnionMessagePath o);
	public static native long CResult_OnionMessagePathNoneZ_ok(long o);
	// struct LDKCResult_OnionMessagePathNoneZ CResult_OnionMessagePathNoneZ_err(void);
	public static native long CResult_OnionMessagePathNoneZ_err();
	// bool CResult_OnionMessagePathNoneZ_is_ok(const struct LDKCResult_OnionMessagePathNoneZ *NONNULL_PTR o);
	public static native boolean CResult_OnionMessagePathNoneZ_is_ok(long o);
	// void CResult_OnionMessagePathNoneZ_free(struct LDKCResult_OnionMessagePathNoneZ _res);
	public static native void CResult_OnionMessagePathNoneZ_free(long _res);
	// uint64_t CResult_OnionMessagePathNoneZ_clone_ptr(LDKCResult_OnionMessagePathNoneZ *NONNULL_PTR arg);
	public static native long CResult_OnionMessagePathNoneZ_clone_ptr(long arg);
	// struct LDKCResult_OnionMessagePathNoneZ CResult_OnionMessagePathNoneZ_clone(const struct LDKCResult_OnionMessagePathNoneZ *NONNULL_PTR orig);
	public static native long CResult_OnionMessagePathNoneZ_clone(long orig);
	// struct LDKCResult_CVec_BlindedMessagePathZNoneZ CResult_CVec_BlindedMessagePathZNoneZ_ok(struct LDKCVec_BlindedMessagePathZ o);
	public static native long CResult_CVec_BlindedMessagePathZNoneZ_ok(long[] o);
	// struct LDKCResult_CVec_BlindedMessagePathZNoneZ CResult_CVec_BlindedMessagePathZNoneZ_err(void);
	public static native long CResult_CVec_BlindedMessagePathZNoneZ_err();
	// bool CResult_CVec_BlindedMessagePathZNoneZ_is_ok(const struct LDKCResult_CVec_BlindedMessagePathZNoneZ *NONNULL_PTR o);
	public static native boolean CResult_CVec_BlindedMessagePathZNoneZ_is_ok(long o);
	// void CResult_CVec_BlindedMessagePathZNoneZ_free(struct LDKCResult_CVec_BlindedMessagePathZNoneZ _res);
	public static native void CResult_CVec_BlindedMessagePathZNoneZ_free(long _res);
	// uint64_t CResult_CVec_BlindedMessagePathZNoneZ_clone_ptr(LDKCResult_CVec_BlindedMessagePathZNoneZ *NONNULL_PTR arg);
	public static native long CResult_CVec_BlindedMessagePathZNoneZ_clone_ptr(long arg);
	// struct LDKCResult_CVec_BlindedMessagePathZNoneZ CResult_CVec_BlindedMessagePathZNoneZ_clone(const struct LDKCResult_CVec_BlindedMessagePathZNoneZ *NONNULL_PTR orig);
	public static native long CResult_CVec_BlindedMessagePathZNoneZ_clone(long orig);
	// void CVec_MessageForwardNodeZ_free(struct LDKCVec_MessageForwardNodeZ _res);
	public static native void CVec_MessageForwardNodeZ_free(long[] _res);
	// struct LDKCOption_MessageContextZ COption_MessageContextZ_some(struct LDKMessageContext o);
	public static native long COption_MessageContextZ_some(long o);
	// struct LDKCOption_MessageContextZ COption_MessageContextZ_none(void);
	public static native long COption_MessageContextZ_none();
	// void COption_MessageContextZ_free(struct LDKCOption_MessageContextZ _res);
	public static native void COption_MessageContextZ_free(long _res);
	// uint64_t COption_MessageContextZ_clone_ptr(LDKCOption_MessageContextZ *NONNULL_PTR arg);
	public static native long COption_MessageContextZ_clone_ptr(long arg);
	// struct LDKCOption_MessageContextZ COption_MessageContextZ_clone(const struct LDKCOption_MessageContextZ *NONNULL_PTR orig);
	public static native long COption_MessageContextZ_clone(long orig);
	// uint64_t C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ_clone_ptr(LDKC3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ *NONNULL_PTR arg);
	public static native long C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ_clone_ptr(long arg);
	// struct LDKC3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ_clone(const struct LDKC3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ *NONNULL_PTR orig);
	public static native long C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ_clone(long orig);
	// struct LDKC3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ_new(struct LDKPublicKey a, struct LDKOnionMessage b, struct LDKCOption_CVec_SocketAddressZZ c);
	public static native long C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ_new(byte[] a, long b, long c);
	// void C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ_free(struct LDKC3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ _res);
	public static native void C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ_free(long _res);
	// struct LDKCResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_ok(struct LDKC3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZ o);
	public static native long CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_ok(long o);
	// struct LDKCResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_err(struct LDKSendError e);
	public static native long CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_err(long e);
	// bool CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_is_ok(const struct LDKCResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ *NONNULL_PTR o);
	public static native boolean CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_is_ok(long o);
	// void CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_free(struct LDKCResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ _res);
	public static native void CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_free(long _res);
	// uint64_t CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_clone_ptr(LDKCResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ *NONNULL_PTR arg);
	public static native long CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_clone_ptr(long arg);
	// struct LDKCResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_clone(const struct LDKCResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ *NONNULL_PTR orig);
	public static native long CResult_C3Tuple_PublicKeyOnionMessageCOption_CVec_SocketAddressZZZSendErrorZ_clone(long orig);
	// struct LDKCResult_PeeledOnionNoneZ CResult_PeeledOnionNoneZ_ok(struct LDKPeeledOnion o);
	public static native long CResult_PeeledOnionNoneZ_ok(long o);
	// struct LDKCResult_PeeledOnionNoneZ CResult_PeeledOnionNoneZ_err(void);
	public static native long CResult_PeeledOnionNoneZ_err();
	// bool CResult_PeeledOnionNoneZ_is_ok(const struct LDKCResult_PeeledOnionNoneZ *NONNULL_PTR o);
	public static native boolean CResult_PeeledOnionNoneZ_is_ok(long o);
	// void CResult_PeeledOnionNoneZ_free(struct LDKCResult_PeeledOnionNoneZ _res);
	public static native void CResult_PeeledOnionNoneZ_free(long _res);
	// uint64_t CResult_PeeledOnionNoneZ_clone_ptr(LDKCResult_PeeledOnionNoneZ *NONNULL_PTR arg);
	public static native long CResult_PeeledOnionNoneZ_clone_ptr(long arg);
	// struct LDKCResult_PeeledOnionNoneZ CResult_PeeledOnionNoneZ_clone(const struct LDKCResult_PeeledOnionNoneZ *NONNULL_PTR orig);
	public static native long CResult_PeeledOnionNoneZ_clone(long orig);
	// struct LDKCResult_SendSuccessSendErrorZ CResult_SendSuccessSendErrorZ_ok(struct LDKSendSuccess o);
	public static native long CResult_SendSuccessSendErrorZ_ok(long o);
	// struct LDKCResult_SendSuccessSendErrorZ CResult_SendSuccessSendErrorZ_err(struct LDKSendError e);
	public static native long CResult_SendSuccessSendErrorZ_err(long e);
	// bool CResult_SendSuccessSendErrorZ_is_ok(const struct LDKCResult_SendSuccessSendErrorZ *NONNULL_PTR o);
	public static native boolean CResult_SendSuccessSendErrorZ_is_ok(long o);
	// void CResult_SendSuccessSendErrorZ_free(struct LDKCResult_SendSuccessSendErrorZ _res);
	public static native void CResult_SendSuccessSendErrorZ_free(long _res);
	// uint64_t CResult_SendSuccessSendErrorZ_clone_ptr(LDKCResult_SendSuccessSendErrorZ *NONNULL_PTR arg);
	public static native long CResult_SendSuccessSendErrorZ_clone_ptr(long arg);
	// struct LDKCResult_SendSuccessSendErrorZ CResult_SendSuccessSendErrorZ_clone(const struct LDKCResult_SendSuccessSendErrorZ *NONNULL_PTR orig);
	public static native long CResult_SendSuccessSendErrorZ_clone(long orig);
	// struct LDKCResult_NoneSendErrorZ CResult_NoneSendErrorZ_ok(void);
	public static native long CResult_NoneSendErrorZ_ok();
	// struct LDKCResult_NoneSendErrorZ CResult_NoneSendErrorZ_err(struct LDKSendError e);
	public static native long CResult_NoneSendErrorZ_err(long e);
	// bool CResult_NoneSendErrorZ_is_ok(const struct LDKCResult_NoneSendErrorZ *NONNULL_PTR o);
	public static native boolean CResult_NoneSendErrorZ_is_ok(long o);
	// void CResult_NoneSendErrorZ_free(struct LDKCResult_NoneSendErrorZ _res);
	public static native void CResult_NoneSendErrorZ_free(long _res);
	// uint64_t CResult_NoneSendErrorZ_clone_ptr(LDKCResult_NoneSendErrorZ *NONNULL_PTR arg);
	public static native long CResult_NoneSendErrorZ_clone_ptr(long arg);
	// struct LDKCResult_NoneSendErrorZ CResult_NoneSendErrorZ_clone(const struct LDKCResult_NoneSendErrorZ *NONNULL_PTR orig);
	public static native long CResult_NoneSendErrorZ_clone(long orig);
	// struct LDKCResult_BlindedHopDecodeErrorZ CResult_BlindedHopDecodeErrorZ_ok(struct LDKBlindedHop o);
	public static native long CResult_BlindedHopDecodeErrorZ_ok(long o);
	// struct LDKCResult_BlindedHopDecodeErrorZ CResult_BlindedHopDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_BlindedHopDecodeErrorZ_err(long e);
	// bool CResult_BlindedHopDecodeErrorZ_is_ok(const struct LDKCResult_BlindedHopDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_BlindedHopDecodeErrorZ_is_ok(long o);
	// void CResult_BlindedHopDecodeErrorZ_free(struct LDKCResult_BlindedHopDecodeErrorZ _res);
	public static native void CResult_BlindedHopDecodeErrorZ_free(long _res);
	// uint64_t CResult_BlindedHopDecodeErrorZ_clone_ptr(LDKCResult_BlindedHopDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_BlindedHopDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_BlindedHopDecodeErrorZ CResult_BlindedHopDecodeErrorZ_clone(const struct LDKCResult_BlindedHopDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_BlindedHopDecodeErrorZ_clone(long orig);
	// void CVec_PhantomRouteHintsZ_free(struct LDKCVec_PhantomRouteHintsZ _res);
	public static native void CVec_PhantomRouteHintsZ_free(long[] _res);
	// struct LDKCResult_InvoiceErrorDecodeErrorZ CResult_InvoiceErrorDecodeErrorZ_ok(struct LDKInvoiceError o);
	public static native long CResult_InvoiceErrorDecodeErrorZ_ok(long o);
	// struct LDKCResult_InvoiceErrorDecodeErrorZ CResult_InvoiceErrorDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_InvoiceErrorDecodeErrorZ_err(long e);
	// bool CResult_InvoiceErrorDecodeErrorZ_is_ok(const struct LDKCResult_InvoiceErrorDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_InvoiceErrorDecodeErrorZ_is_ok(long o);
	// void CResult_InvoiceErrorDecodeErrorZ_free(struct LDKCResult_InvoiceErrorDecodeErrorZ _res);
	public static native void CResult_InvoiceErrorDecodeErrorZ_free(long _res);
	// uint64_t CResult_InvoiceErrorDecodeErrorZ_clone_ptr(LDKCResult_InvoiceErrorDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_InvoiceErrorDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_InvoiceErrorDecodeErrorZ CResult_InvoiceErrorDecodeErrorZ_clone(const struct LDKCResult_InvoiceErrorDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_InvoiceErrorDecodeErrorZ_clone(long orig);
	// struct LDKCResult_TrackedSpendableOutputDecodeErrorZ CResult_TrackedSpendableOutputDecodeErrorZ_ok(struct LDKTrackedSpendableOutput o);
	public static native long CResult_TrackedSpendableOutputDecodeErrorZ_ok(long o);
	// struct LDKCResult_TrackedSpendableOutputDecodeErrorZ CResult_TrackedSpendableOutputDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_TrackedSpendableOutputDecodeErrorZ_err(long e);
	// bool CResult_TrackedSpendableOutputDecodeErrorZ_is_ok(const struct LDKCResult_TrackedSpendableOutputDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_TrackedSpendableOutputDecodeErrorZ_is_ok(long o);
	// void CResult_TrackedSpendableOutputDecodeErrorZ_free(struct LDKCResult_TrackedSpendableOutputDecodeErrorZ _res);
	public static native void CResult_TrackedSpendableOutputDecodeErrorZ_free(long _res);
	// uint64_t CResult_TrackedSpendableOutputDecodeErrorZ_clone_ptr(LDKCResult_TrackedSpendableOutputDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_TrackedSpendableOutputDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_TrackedSpendableOutputDecodeErrorZ CResult_TrackedSpendableOutputDecodeErrorZ_clone(const struct LDKCResult_TrackedSpendableOutputDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_TrackedSpendableOutputDecodeErrorZ_clone(long orig);
	// struct LDKCResult_OutputSpendStatusDecodeErrorZ CResult_OutputSpendStatusDecodeErrorZ_ok(struct LDKOutputSpendStatus o);
	public static native long CResult_OutputSpendStatusDecodeErrorZ_ok(long o);
	// struct LDKCResult_OutputSpendStatusDecodeErrorZ CResult_OutputSpendStatusDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_OutputSpendStatusDecodeErrorZ_err(long e);
	// bool CResult_OutputSpendStatusDecodeErrorZ_is_ok(const struct LDKCResult_OutputSpendStatusDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OutputSpendStatusDecodeErrorZ_is_ok(long o);
	// void CResult_OutputSpendStatusDecodeErrorZ_free(struct LDKCResult_OutputSpendStatusDecodeErrorZ _res);
	public static native void CResult_OutputSpendStatusDecodeErrorZ_free(long _res);
	// uint64_t CResult_OutputSpendStatusDecodeErrorZ_clone_ptr(LDKCResult_OutputSpendStatusDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_OutputSpendStatusDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_OutputSpendStatusDecodeErrorZ CResult_OutputSpendStatusDecodeErrorZ_clone(const struct LDKCResult_OutputSpendStatusDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_OutputSpendStatusDecodeErrorZ_clone(long orig);
	// struct LDKCOption_FilterZ COption_FilterZ_some(struct LDKFilter o);
	public static native long COption_FilterZ_some(long o);
	// struct LDKCOption_FilterZ COption_FilterZ_none(void);
	public static native long COption_FilterZ_none();
	// void COption_FilterZ_free(struct LDKCOption_FilterZ _res);
	public static native void COption_FilterZ_free(long _res);
	// void CVec_TrackedSpendableOutputZ_free(struct LDKCVec_TrackedSpendableOutputZ _res);
	public static native void CVec_TrackedSpendableOutputZ_free(long[] _res);
	// struct LDKCResult_OutputSweeperDecodeErrorZ CResult_OutputSweeperDecodeErrorZ_ok(struct LDKOutputSweeper o);
	public static native long CResult_OutputSweeperDecodeErrorZ_ok(long o);
	// struct LDKCResult_OutputSweeperDecodeErrorZ CResult_OutputSweeperDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_OutputSweeperDecodeErrorZ_err(long e);
	// bool CResult_OutputSweeperDecodeErrorZ_is_ok(const struct LDKCResult_OutputSweeperDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OutputSweeperDecodeErrorZ_is_ok(long o);
	// void CResult_OutputSweeperDecodeErrorZ_free(struct LDKCResult_OutputSweeperDecodeErrorZ _res);
	public static native void CResult_OutputSweeperDecodeErrorZ_free(long _res);
	// struct LDKC2Tuple_BestBlockOutputSweeperZ C2Tuple_BestBlockOutputSweeperZ_new(struct LDKBestBlock a, struct LDKOutputSweeper b);
	public static native long C2Tuple_BestBlockOutputSweeperZ_new(long a, long b);
	// void C2Tuple_BestBlockOutputSweeperZ_free(struct LDKC2Tuple_BestBlockOutputSweeperZ _res);
	public static native void C2Tuple_BestBlockOutputSweeperZ_free(long _res);
	// struct LDKCResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ CResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ_ok(struct LDKC2Tuple_BestBlockOutputSweeperZ o);
	public static native long CResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ_ok(long o);
	// struct LDKCResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ CResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ_err(long e);
	// bool CResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ_is_ok(const struct LDKCResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ_is_ok(long o);
	// void CResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ_free(struct LDKCResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ _res);
	public static native void CResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ_free(long _res);
	// struct LDKCResult_DelayedPaymentBasepointDecodeErrorZ CResult_DelayedPaymentBasepointDecodeErrorZ_ok(struct LDKDelayedPaymentBasepoint o);
	public static native long CResult_DelayedPaymentBasepointDecodeErrorZ_ok(long o);
	// struct LDKCResult_DelayedPaymentBasepointDecodeErrorZ CResult_DelayedPaymentBasepointDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_DelayedPaymentBasepointDecodeErrorZ_err(long e);
	// bool CResult_DelayedPaymentBasepointDecodeErrorZ_is_ok(const struct LDKCResult_DelayedPaymentBasepointDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_DelayedPaymentBasepointDecodeErrorZ_is_ok(long o);
	// void CResult_DelayedPaymentBasepointDecodeErrorZ_free(struct LDKCResult_DelayedPaymentBasepointDecodeErrorZ _res);
	public static native void CResult_DelayedPaymentBasepointDecodeErrorZ_free(long _res);
	// uint64_t CResult_DelayedPaymentBasepointDecodeErrorZ_clone_ptr(LDKCResult_DelayedPaymentBasepointDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_DelayedPaymentBasepointDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_DelayedPaymentBasepointDecodeErrorZ CResult_DelayedPaymentBasepointDecodeErrorZ_clone(const struct LDKCResult_DelayedPaymentBasepointDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_DelayedPaymentBasepointDecodeErrorZ_clone(long orig);
	// struct LDKCResult_DelayedPaymentKeyDecodeErrorZ CResult_DelayedPaymentKeyDecodeErrorZ_ok(struct LDKDelayedPaymentKey o);
	public static native long CResult_DelayedPaymentKeyDecodeErrorZ_ok(long o);
	// struct LDKCResult_DelayedPaymentKeyDecodeErrorZ CResult_DelayedPaymentKeyDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_DelayedPaymentKeyDecodeErrorZ_err(long e);
	// bool CResult_DelayedPaymentKeyDecodeErrorZ_is_ok(const struct LDKCResult_DelayedPaymentKeyDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_DelayedPaymentKeyDecodeErrorZ_is_ok(long o);
	// void CResult_DelayedPaymentKeyDecodeErrorZ_free(struct LDKCResult_DelayedPaymentKeyDecodeErrorZ _res);
	public static native void CResult_DelayedPaymentKeyDecodeErrorZ_free(long _res);
	// uint64_t CResult_DelayedPaymentKeyDecodeErrorZ_clone_ptr(LDKCResult_DelayedPaymentKeyDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_DelayedPaymentKeyDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_DelayedPaymentKeyDecodeErrorZ CResult_DelayedPaymentKeyDecodeErrorZ_clone(const struct LDKCResult_DelayedPaymentKeyDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_DelayedPaymentKeyDecodeErrorZ_clone(long orig);
	// struct LDKCResult_HtlcBasepointDecodeErrorZ CResult_HtlcBasepointDecodeErrorZ_ok(struct LDKHtlcBasepoint o);
	public static native long CResult_HtlcBasepointDecodeErrorZ_ok(long o);
	// struct LDKCResult_HtlcBasepointDecodeErrorZ CResult_HtlcBasepointDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_HtlcBasepointDecodeErrorZ_err(long e);
	// bool CResult_HtlcBasepointDecodeErrorZ_is_ok(const struct LDKCResult_HtlcBasepointDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_HtlcBasepointDecodeErrorZ_is_ok(long o);
	// void CResult_HtlcBasepointDecodeErrorZ_free(struct LDKCResult_HtlcBasepointDecodeErrorZ _res);
	public static native void CResult_HtlcBasepointDecodeErrorZ_free(long _res);
	// uint64_t CResult_HtlcBasepointDecodeErrorZ_clone_ptr(LDKCResult_HtlcBasepointDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_HtlcBasepointDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_HtlcBasepointDecodeErrorZ CResult_HtlcBasepointDecodeErrorZ_clone(const struct LDKCResult_HtlcBasepointDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_HtlcBasepointDecodeErrorZ_clone(long orig);
	// struct LDKCResult_HtlcKeyDecodeErrorZ CResult_HtlcKeyDecodeErrorZ_ok(struct LDKHtlcKey o);
	public static native long CResult_HtlcKeyDecodeErrorZ_ok(long o);
	// struct LDKCResult_HtlcKeyDecodeErrorZ CResult_HtlcKeyDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_HtlcKeyDecodeErrorZ_err(long e);
	// bool CResult_HtlcKeyDecodeErrorZ_is_ok(const struct LDKCResult_HtlcKeyDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_HtlcKeyDecodeErrorZ_is_ok(long o);
	// void CResult_HtlcKeyDecodeErrorZ_free(struct LDKCResult_HtlcKeyDecodeErrorZ _res);
	public static native void CResult_HtlcKeyDecodeErrorZ_free(long _res);
	// uint64_t CResult_HtlcKeyDecodeErrorZ_clone_ptr(LDKCResult_HtlcKeyDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_HtlcKeyDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_HtlcKeyDecodeErrorZ CResult_HtlcKeyDecodeErrorZ_clone(const struct LDKCResult_HtlcKeyDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_HtlcKeyDecodeErrorZ_clone(long orig);
	// struct LDKCResult_RevocationBasepointDecodeErrorZ CResult_RevocationBasepointDecodeErrorZ_ok(struct LDKRevocationBasepoint o);
	public static native long CResult_RevocationBasepointDecodeErrorZ_ok(long o);
	// struct LDKCResult_RevocationBasepointDecodeErrorZ CResult_RevocationBasepointDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_RevocationBasepointDecodeErrorZ_err(long e);
	// bool CResult_RevocationBasepointDecodeErrorZ_is_ok(const struct LDKCResult_RevocationBasepointDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RevocationBasepointDecodeErrorZ_is_ok(long o);
	// void CResult_RevocationBasepointDecodeErrorZ_free(struct LDKCResult_RevocationBasepointDecodeErrorZ _res);
	public static native void CResult_RevocationBasepointDecodeErrorZ_free(long _res);
	// uint64_t CResult_RevocationBasepointDecodeErrorZ_clone_ptr(LDKCResult_RevocationBasepointDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_RevocationBasepointDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RevocationBasepointDecodeErrorZ CResult_RevocationBasepointDecodeErrorZ_clone(const struct LDKCResult_RevocationBasepointDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_RevocationBasepointDecodeErrorZ_clone(long orig);
	// struct LDKCResult_RevocationKeyDecodeErrorZ CResult_RevocationKeyDecodeErrorZ_ok(struct LDKRevocationKey o);
	public static native long CResult_RevocationKeyDecodeErrorZ_ok(long o);
	// struct LDKCResult_RevocationKeyDecodeErrorZ CResult_RevocationKeyDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_RevocationKeyDecodeErrorZ_err(long e);
	// bool CResult_RevocationKeyDecodeErrorZ_is_ok(const struct LDKCResult_RevocationKeyDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_RevocationKeyDecodeErrorZ_is_ok(long o);
	// void CResult_RevocationKeyDecodeErrorZ_free(struct LDKCResult_RevocationKeyDecodeErrorZ _res);
	public static native void CResult_RevocationKeyDecodeErrorZ_free(long _res);
	// uint64_t CResult_RevocationKeyDecodeErrorZ_clone_ptr(LDKCResult_RevocationKeyDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_RevocationKeyDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_RevocationKeyDecodeErrorZ CResult_RevocationKeyDecodeErrorZ_clone(const struct LDKCResult_RevocationKeyDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_RevocationKeyDecodeErrorZ_clone(long orig);
	// struct LDKCResult_LockedChannelMonitorNoneZ CResult_LockedChannelMonitorNoneZ_ok(struct LDKLockedChannelMonitor o);
	public static native long CResult_LockedChannelMonitorNoneZ_ok(long o);
	// struct LDKCResult_LockedChannelMonitorNoneZ CResult_LockedChannelMonitorNoneZ_err(void);
	public static native long CResult_LockedChannelMonitorNoneZ_err();
	// bool CResult_LockedChannelMonitorNoneZ_is_ok(const struct LDKCResult_LockedChannelMonitorNoneZ *NONNULL_PTR o);
	public static native boolean CResult_LockedChannelMonitorNoneZ_is_ok(long o);
	// void CResult_LockedChannelMonitorNoneZ_free(struct LDKCResult_LockedChannelMonitorNoneZ _res);
	public static native void CResult_LockedChannelMonitorNoneZ_free(long _res);
	// uint64_t C2Tuple_OutPointChannelIdZ_clone_ptr(LDKC2Tuple_OutPointChannelIdZ *NONNULL_PTR arg);
	public static native long C2Tuple_OutPointChannelIdZ_clone_ptr(long arg);
	// struct LDKC2Tuple_OutPointChannelIdZ C2Tuple_OutPointChannelIdZ_clone(const struct LDKC2Tuple_OutPointChannelIdZ *NONNULL_PTR orig);
	public static native long C2Tuple_OutPointChannelIdZ_clone(long orig);
	// struct LDKC2Tuple_OutPointChannelIdZ C2Tuple_OutPointChannelIdZ_new(struct LDKOutPoint a, struct LDKChannelId b);
	public static native long C2Tuple_OutPointChannelIdZ_new(long a, long b);
	// void C2Tuple_OutPointChannelIdZ_free(struct LDKC2Tuple_OutPointChannelIdZ _res);
	public static native void C2Tuple_OutPointChannelIdZ_free(long _res);
	// void CVec_C2Tuple_OutPointChannelIdZZ_free(struct LDKCVec_C2Tuple_OutPointChannelIdZZ _res);
	public static native void CVec_C2Tuple_OutPointChannelIdZZ_free(long[] _res);
	// uint64_t C2Tuple_OutPointCVec_u64ZZ_clone_ptr(LDKC2Tuple_OutPointCVec_u64ZZ *NONNULL_PTR arg);
	public static native long C2Tuple_OutPointCVec_u64ZZ_clone_ptr(long arg);
	// struct LDKC2Tuple_OutPointCVec_u64ZZ C2Tuple_OutPointCVec_u64ZZ_clone(const struct LDKC2Tuple_OutPointCVec_u64ZZ *NONNULL_PTR orig);
	public static native long C2Tuple_OutPointCVec_u64ZZ_clone(long orig);
	// struct LDKC2Tuple_OutPointCVec_u64ZZ C2Tuple_OutPointCVec_u64ZZ_new(struct LDKOutPoint a, struct LDKCVec_u64Z b);
	public static native long C2Tuple_OutPointCVec_u64ZZ_new(long a, long[] b);
	// void C2Tuple_OutPointCVec_u64ZZ_free(struct LDKC2Tuple_OutPointCVec_u64ZZ _res);
	public static native void C2Tuple_OutPointCVec_u64ZZ_free(long _res);
	// void CVec_C2Tuple_OutPointCVec_u64ZZZ_free(struct LDKCVec_C2Tuple_OutPointCVec_u64ZZZ _res);
	public static native void CVec_C2Tuple_OutPointCVec_u64ZZZ_free(long[] _res);
	// struct LDKCResult_BlindedMessagePathDecodeErrorZ CResult_BlindedMessagePathDecodeErrorZ_ok(struct LDKBlindedMessagePath o);
	public static native long CResult_BlindedMessagePathDecodeErrorZ_ok(long o);
	// struct LDKCResult_BlindedMessagePathDecodeErrorZ CResult_BlindedMessagePathDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_BlindedMessagePathDecodeErrorZ_err(long e);
	// bool CResult_BlindedMessagePathDecodeErrorZ_is_ok(const struct LDKCResult_BlindedMessagePathDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_BlindedMessagePathDecodeErrorZ_is_ok(long o);
	// void CResult_BlindedMessagePathDecodeErrorZ_free(struct LDKCResult_BlindedMessagePathDecodeErrorZ _res);
	public static native void CResult_BlindedMessagePathDecodeErrorZ_free(long _res);
	// uint64_t CResult_BlindedMessagePathDecodeErrorZ_clone_ptr(LDKCResult_BlindedMessagePathDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_BlindedMessagePathDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_BlindedMessagePathDecodeErrorZ CResult_BlindedMessagePathDecodeErrorZ_clone(const struct LDKCResult_BlindedMessagePathDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_BlindedMessagePathDecodeErrorZ_clone(long orig);
	// struct LDKCResult_BlindedMessagePathNoneZ CResult_BlindedMessagePathNoneZ_ok(struct LDKBlindedMessagePath o);
	public static native long CResult_BlindedMessagePathNoneZ_ok(long o);
	// struct LDKCResult_BlindedMessagePathNoneZ CResult_BlindedMessagePathNoneZ_err(void);
	public static native long CResult_BlindedMessagePathNoneZ_err();
	// bool CResult_BlindedMessagePathNoneZ_is_ok(const struct LDKCResult_BlindedMessagePathNoneZ *NONNULL_PTR o);
	public static native boolean CResult_BlindedMessagePathNoneZ_is_ok(long o);
	// void CResult_BlindedMessagePathNoneZ_free(struct LDKCResult_BlindedMessagePathNoneZ _res);
	public static native void CResult_BlindedMessagePathNoneZ_free(long _res);
	// uint64_t CResult_BlindedMessagePathNoneZ_clone_ptr(LDKCResult_BlindedMessagePathNoneZ *NONNULL_PTR arg);
	public static native long CResult_BlindedMessagePathNoneZ_clone_ptr(long arg);
	// struct LDKCResult_BlindedMessagePathNoneZ CResult_BlindedMessagePathNoneZ_clone(const struct LDKCResult_BlindedMessagePathNoneZ *NONNULL_PTR orig);
	public static native long CResult_BlindedMessagePathNoneZ_clone(long orig);
	// struct LDKCResult_MessageContextDecodeErrorZ CResult_MessageContextDecodeErrorZ_ok(struct LDKMessageContext o);
	public static native long CResult_MessageContextDecodeErrorZ_ok(long o);
	// struct LDKCResult_MessageContextDecodeErrorZ CResult_MessageContextDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_MessageContextDecodeErrorZ_err(long e);
	// bool CResult_MessageContextDecodeErrorZ_is_ok(const struct LDKCResult_MessageContextDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_MessageContextDecodeErrorZ_is_ok(long o);
	// void CResult_MessageContextDecodeErrorZ_free(struct LDKCResult_MessageContextDecodeErrorZ _res);
	public static native void CResult_MessageContextDecodeErrorZ_free(long _res);
	// uint64_t CResult_MessageContextDecodeErrorZ_clone_ptr(LDKCResult_MessageContextDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_MessageContextDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_MessageContextDecodeErrorZ CResult_MessageContextDecodeErrorZ_clone(const struct LDKCResult_MessageContextDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_MessageContextDecodeErrorZ_clone(long orig);
	// struct LDKCResult_OffersContextDecodeErrorZ CResult_OffersContextDecodeErrorZ_ok(struct LDKOffersContext o);
	public static native long CResult_OffersContextDecodeErrorZ_ok(long o);
	// struct LDKCResult_OffersContextDecodeErrorZ CResult_OffersContextDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_OffersContextDecodeErrorZ_err(long e);
	// bool CResult_OffersContextDecodeErrorZ_is_ok(const struct LDKCResult_OffersContextDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_OffersContextDecodeErrorZ_is_ok(long o);
	// void CResult_OffersContextDecodeErrorZ_free(struct LDKCResult_OffersContextDecodeErrorZ _res);
	public static native void CResult_OffersContextDecodeErrorZ_free(long _res);
	// uint64_t CResult_OffersContextDecodeErrorZ_clone_ptr(LDKCResult_OffersContextDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_OffersContextDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_OffersContextDecodeErrorZ CResult_OffersContextDecodeErrorZ_clone(const struct LDKCResult_OffersContextDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_OffersContextDecodeErrorZ_clone(long orig);
	// struct LDKCResult_AsyncPaymentsContextDecodeErrorZ CResult_AsyncPaymentsContextDecodeErrorZ_ok(struct LDKAsyncPaymentsContext o);
	public static native long CResult_AsyncPaymentsContextDecodeErrorZ_ok(long o);
	// struct LDKCResult_AsyncPaymentsContextDecodeErrorZ CResult_AsyncPaymentsContextDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_AsyncPaymentsContextDecodeErrorZ_err(long e);
	// bool CResult_AsyncPaymentsContextDecodeErrorZ_is_ok(const struct LDKCResult_AsyncPaymentsContextDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_AsyncPaymentsContextDecodeErrorZ_is_ok(long o);
	// void CResult_AsyncPaymentsContextDecodeErrorZ_free(struct LDKCResult_AsyncPaymentsContextDecodeErrorZ _res);
	public static native void CResult_AsyncPaymentsContextDecodeErrorZ_free(long _res);
	// uint64_t CResult_AsyncPaymentsContextDecodeErrorZ_clone_ptr(LDKCResult_AsyncPaymentsContextDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_AsyncPaymentsContextDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_AsyncPaymentsContextDecodeErrorZ CResult_AsyncPaymentsContextDecodeErrorZ_clone(const struct LDKCResult_AsyncPaymentsContextDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_AsyncPaymentsContextDecodeErrorZ_clone(long orig);
	// struct LDKCResult_DNSResolverContextDecodeErrorZ CResult_DNSResolverContextDecodeErrorZ_ok(struct LDKDNSResolverContext o);
	public static native long CResult_DNSResolverContextDecodeErrorZ_ok(long o);
	// struct LDKCResult_DNSResolverContextDecodeErrorZ CResult_DNSResolverContextDecodeErrorZ_err(struct LDKDecodeError e);
	public static native long CResult_DNSResolverContextDecodeErrorZ_err(long e);
	// bool CResult_DNSResolverContextDecodeErrorZ_is_ok(const struct LDKCResult_DNSResolverContextDecodeErrorZ *NONNULL_PTR o);
	public static native boolean CResult_DNSResolverContextDecodeErrorZ_is_ok(long o);
	// void CResult_DNSResolverContextDecodeErrorZ_free(struct LDKCResult_DNSResolverContextDecodeErrorZ _res);
	public static native void CResult_DNSResolverContextDecodeErrorZ_free(long _res);
	// uint64_t CResult_DNSResolverContextDecodeErrorZ_clone_ptr(LDKCResult_DNSResolverContextDecodeErrorZ *NONNULL_PTR arg);
	public static native long CResult_DNSResolverContextDecodeErrorZ_clone_ptr(long arg);
	// struct LDKCResult_DNSResolverContextDecodeErrorZ CResult_DNSResolverContextDecodeErrorZ_clone(const struct LDKCResult_DNSResolverContextDecodeErrorZ *NONNULL_PTR orig);
	public static native long CResult_DNSResolverContextDecodeErrorZ_clone(long orig);
	// void APIError_free(struct LDKAPIError this_ptr);
	public static native void APIError_free(long this_ptr);
	// uint64_t APIError_clone_ptr(LDKAPIError *NONNULL_PTR arg);
	public static native long APIError_clone_ptr(long arg);
	// struct LDKAPIError APIError_clone(const struct LDKAPIError *NONNULL_PTR orig);
	public static native long APIError_clone(long orig);
	// struct LDKAPIError APIError_apimisuse_error(struct LDKStr err);
	public static native long APIError_apimisuse_error(String err);
	// struct LDKAPIError APIError_fee_rate_too_high(struct LDKStr err, uint32_t feerate);
	public static native long APIError_fee_rate_too_high(String err, int feerate);
	// struct LDKAPIError APIError_invalid_route(struct LDKStr err);
	public static native long APIError_invalid_route(String err);
	// struct LDKAPIError APIError_channel_unavailable(struct LDKStr err);
	public static native long APIError_channel_unavailable(String err);
	// struct LDKAPIError APIError_monitor_update_in_progress(void);
	public static native long APIError_monitor_update_in_progress();
	// struct LDKAPIError APIError_incompatible_shutdown_script(struct LDKShutdownScript script);
	public static native long APIError_incompatible_shutdown_script(long script);
	// bool APIError_eq(const struct LDKAPIError *NONNULL_PTR a, const struct LDKAPIError *NONNULL_PTR b);
	public static native boolean APIError_eq(long a, long b);
	// struct LDKCVec_u8Z APIError_write(const struct LDKAPIError *NONNULL_PTR obj);
	public static native byte[] APIError_write(long obj);
	// struct LDKCResult_COption_APIErrorZDecodeErrorZ APIError_read(struct LDKu8slice ser);
	public static native long APIError_read(byte[] ser);
	// void BigSize_free(struct LDKBigSize this_obj);
	public static native void BigSize_free(long this_obj);
	// uint64_t BigSize_get_a(const struct LDKBigSize *NONNULL_PTR this_ptr);
	public static native long BigSize_get_a(long this_ptr);
	// void BigSize_set_a(struct LDKBigSize *NONNULL_PTR this_ptr, uint64_t val);
	public static native void BigSize_set_a(long this_ptr, long val);
	// MUST_USE_RES struct LDKBigSize BigSize_new(uint64_t a_arg);
	public static native long BigSize_new(long a_arg);
	// uint64_t BigSize_clone_ptr(LDKBigSize *NONNULL_PTR arg);
	public static native long BigSize_clone_ptr(long arg);
	// struct LDKBigSize BigSize_clone(const struct LDKBigSize *NONNULL_PTR orig);
	public static native long BigSize_clone(long orig);
	// uint64_t BigSize_hash(const struct LDKBigSize *NONNULL_PTR o);
	public static native long BigSize_hash(long o);
	// bool BigSize_eq(const struct LDKBigSize *NONNULL_PTR a, const struct LDKBigSize *NONNULL_PTR b);
	public static native boolean BigSize_eq(long a, long b);
	// struct LDKCVec_u8Z BigSize_write(const struct LDKBigSize *NONNULL_PTR obj);
	public static native byte[] BigSize_write(long obj);
	// struct LDKCResult_BigSizeDecodeErrorZ BigSize_read(struct LDKu8slice ser);
	public static native long BigSize_read(byte[] ser);
	// struct LDKCVec_u8Z UntrustedString_write(const struct LDKUntrustedString *NONNULL_PTR obj);
	public static native byte[] UntrustedString_write(long obj);
	// struct LDKCResult_UntrustedStringDecodeErrorZ UntrustedString_read(struct LDKu8slice ser);
	public static native long UntrustedString_read(byte[] ser);
	// void Hostname_free(struct LDKHostname this_obj);
	public static native void Hostname_free(long this_obj);
	// uint64_t Hostname_clone_ptr(LDKHostname *NONNULL_PTR arg);
	public static native long Hostname_clone_ptr(long arg);
	// struct LDKHostname Hostname_clone(const struct LDKHostname *NONNULL_PTR orig);
	public static native long Hostname_clone(long orig);
	// uint64_t Hostname_hash(const struct LDKHostname *NONNULL_PTR o);
	public static native long Hostname_hash(long o);
	// bool Hostname_eq(const struct LDKHostname *NONNULL_PTR a, const struct LDKHostname *NONNULL_PTR b);
	public static native boolean Hostname_eq(long a, long b);
	// MUST_USE_RES uint8_t Hostname_len(const struct LDKHostname *NONNULL_PTR this_arg);
	public static native byte Hostname_len(long this_arg);
	// struct LDKStr Hostname_to_str(const struct LDKHostname *NONNULL_PTR o);
	public static native String Hostname_to_str(long o);
	// struct LDKCVec_u8Z Hostname_write(const struct LDKHostname *NONNULL_PTR obj);
	public static native byte[] Hostname_write(long obj);
	// struct LDKCResult_HostnameDecodeErrorZ Hostname_read(struct LDKu8slice ser);
	public static native long Hostname_read(byte[] ser);
	// void TransactionU16LenLimited_free(struct LDKTransactionU16LenLimited this_obj);
	public static native void TransactionU16LenLimited_free(long this_obj);
	// uint64_t TransactionU16LenLimited_clone_ptr(LDKTransactionU16LenLimited *NONNULL_PTR arg);
	public static native long TransactionU16LenLimited_clone_ptr(long arg);
	// struct LDKTransactionU16LenLimited TransactionU16LenLimited_clone(const struct LDKTransactionU16LenLimited *NONNULL_PTR orig);
	public static native long TransactionU16LenLimited_clone(long orig);
	// uint64_t TransactionU16LenLimited_hash(const struct LDKTransactionU16LenLimited *NONNULL_PTR o);
	public static native long TransactionU16LenLimited_hash(long o);
	// bool TransactionU16LenLimited_eq(const struct LDKTransactionU16LenLimited *NONNULL_PTR a, const struct LDKTransactionU16LenLimited *NONNULL_PTR b);
	public static native boolean TransactionU16LenLimited_eq(long a, long b);
	// MUST_USE_RES struct LDKCResult_TransactionU16LenLimitedNoneZ TransactionU16LenLimited_new(struct LDKTransaction transaction);
	public static native long TransactionU16LenLimited_new(byte[] transaction);
	// MUST_USE_RES struct LDKTransaction TransactionU16LenLimited_into_transaction(struct LDKTransactionU16LenLimited this_arg);
	public static native byte[] TransactionU16LenLimited_into_transaction(long this_arg);
	// MUST_USE_RES struct LDKTransaction TransactionU16LenLimited_as_transaction(const struct LDKTransactionU16LenLimited *NONNULL_PTR this_arg);
	public static native byte[] TransactionU16LenLimited_as_transaction(long this_arg);
	// struct LDKCVec_u8Z TransactionU16LenLimited_write(const struct LDKTransactionU16LenLimited *NONNULL_PTR obj);
	public static native byte[] TransactionU16LenLimited_write(long obj);
	// struct LDKCResult_TransactionU16LenLimitedDecodeErrorZ TransactionU16LenLimited_read(struct LDKu8slice ser);
	public static native long TransactionU16LenLimited_read(byte[] ser);
	// struct LDKStr sign(struct LDKu8slice msg, const uint8_t (*sk)[32]);
	public static native String sign(byte[] msg, byte[] sk);
	// struct LDKCResult_PublicKeySecp256k1ErrorZ recover_pk(struct LDKu8slice msg, struct LDKStr sig);
	public static native long recover_pk(byte[] msg, String sig);
	// bool verify(struct LDKu8slice msg, struct LDKStr sig, struct LDKPublicKey pk);
	public static native boolean verify(byte[] msg, String sig, byte[] pk);
	// void KVStore_free(struct LDKKVStore this_ptr);
	public static native void KVStore_free(long this_ptr);
	// void MigratableKVStore_free(struct LDKMigratableKVStore this_ptr);
	public static native void MigratableKVStore_free(long this_ptr);
	// struct LDKCResult_NoneIOErrorZ migrate_kv_store_data(struct LDKMigratableKVStore *NONNULL_PTR source_store, struct LDKMigratableKVStore *NONNULL_PTR target_store);
	public static native long migrate_kv_store_data(long source_store, long target_store);
	// void Persister_free(struct LDKPersister this_ptr);
	public static native void Persister_free(long this_ptr);
	// struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ read_channel_monitors(struct LDKKVStore kv_store, struct LDKEntropySource entropy_source, struct LDKSignerProvider signer_provider);
	public static native long read_channel_monitors(long kv_store, long entropy_source, long signer_provider);
	// void MonitorUpdatingPersister_free(struct LDKMonitorUpdatingPersister this_obj);
	public static native void MonitorUpdatingPersister_free(long this_obj);
	// MUST_USE_RES struct LDKMonitorUpdatingPersister MonitorUpdatingPersister_new(struct LDKKVStore kv_store, struct LDKLogger logger, uint64_t maximum_pending_updates, struct LDKEntropySource entropy_source, struct LDKSignerProvider signer_provider, struct LDKBroadcasterInterface broadcaster, struct LDKFeeEstimator fee_estimator);
	public static native long MonitorUpdatingPersister_new(long kv_store, long logger, long maximum_pending_updates, long entropy_source, long signer_provider, long broadcaster, long fee_estimator);
	// MUST_USE_RES struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesChannelMonitorZZIOErrorZ MonitorUpdatingPersister_read_all_channel_monitors_with_updates(const struct LDKMonitorUpdatingPersister *NONNULL_PTR this_arg);
	public static native long MonitorUpdatingPersister_read_all_channel_monitors_with_updates(long this_arg);
	// MUST_USE_RES struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZIOErrorZ MonitorUpdatingPersister_read_channel_monitor_with_updates(const struct LDKMonitorUpdatingPersister *NONNULL_PTR this_arg, struct LDKStr monitor_key);
	public static native long MonitorUpdatingPersister_read_channel_monitor_with_updates(long this_arg, String monitor_key);
	// MUST_USE_RES struct LDKCResult_NoneIOErrorZ MonitorUpdatingPersister_cleanup_stale_updates(const struct LDKMonitorUpdatingPersister *NONNULL_PTR this_arg, bool lazy);
	public static native long MonitorUpdatingPersister_cleanup_stale_updates(long this_arg, boolean lazy);
	// struct LDKPersist MonitorUpdatingPersister_as_Persist(const struct LDKMonitorUpdatingPersister *NONNULL_PTR this_arg);
	public static native long MonitorUpdatingPersister_as_Persist(long this_arg);
	// void MonitorName_free(struct LDKMonitorName this_obj);
	public static native void MonitorName_free(long this_obj);
	// MUST_USE_RES struct LDKCResult_MonitorNameIOErrorZ MonitorName_new(struct LDKStr name);
	public static native long MonitorName_new(String name);
	// MUST_USE_RES struct LDKStr MonitorName_as_str(const struct LDKMonitorName *NONNULL_PTR this_arg);
	public static native String MonitorName_as_str(long this_arg);
	// void UpdateName_free(struct LDKUpdateName this_obj);
	public static native void UpdateName_free(long this_obj);
	// uint64_t UpdateName_get_a(const struct LDKUpdateName *NONNULL_PTR this_ptr);
	public static native long UpdateName_get_a(long this_ptr);
	// void UpdateName_set_a(struct LDKUpdateName *NONNULL_PTR this_ptr, uint64_t val);
	public static native void UpdateName_set_a(long this_ptr, long val);
	// MUST_USE_RES struct LDKCResult_UpdateNameIOErrorZ UpdateName_new(struct LDKStr name);
	public static native long UpdateName_new(String name);
	// MUST_USE_RES struct LDKStr UpdateName_as_str(const struct LDKUpdateName *NONNULL_PTR this_arg);
	public static native String UpdateName_as_str(long this_arg);
	// enum LDKShortChannelIdError ShortChannelIdError_clone(const enum LDKShortChannelIdError *NONNULL_PTR orig);
	public static native ShortChannelIdError ShortChannelIdError_clone(long orig);
	// enum LDKShortChannelIdError ShortChannelIdError_block_overflow(void);
	public static native ShortChannelIdError ShortChannelIdError_block_overflow();
	// enum LDKShortChannelIdError ShortChannelIdError_tx_index_overflow(void);
	public static native ShortChannelIdError ShortChannelIdError_tx_index_overflow();
	// enum LDKShortChannelIdError ShortChannelIdError_vout_index_overflow(void);
	public static native ShortChannelIdError ShortChannelIdError_vout_index_overflow();
	// bool ShortChannelIdError_eq(const enum LDKShortChannelIdError *NONNULL_PTR a, const enum LDKShortChannelIdError *NONNULL_PTR b);
	public static native boolean ShortChannelIdError_eq(long a, long b);
	// uint32_t block_from_scid(uint64_t short_channel_id);
	public static native int block_from_scid(long short_channel_id);
	// uint32_t tx_index_from_scid(uint64_t short_channel_id);
	public static native int tx_index_from_scid(long short_channel_id);
	// uint16_t vout_from_scid(uint64_t short_channel_id);
	public static native short vout_from_scid(long short_channel_id);
	// struct LDKCResult_u64ShortChannelIdErrorZ scid_from_parts(uint64_t block, uint64_t tx_index, uint64_t vout_index);
	public static native long scid_from_parts(long block, long tx_index, long vout_index);
	// void TrackedSpendableOutput_free(struct LDKTrackedSpendableOutput this_obj);
	public static native void TrackedSpendableOutput_free(long this_obj);
	// struct LDKSpendableOutputDescriptor TrackedSpendableOutput_get_descriptor(const struct LDKTrackedSpendableOutput *NONNULL_PTR this_ptr);
	public static native long TrackedSpendableOutput_get_descriptor(long this_ptr);
	// void TrackedSpendableOutput_set_descriptor(struct LDKTrackedSpendableOutput *NONNULL_PTR this_ptr, struct LDKSpendableOutputDescriptor val);
	public static native void TrackedSpendableOutput_set_descriptor(long this_ptr, long val);
	// struct LDKChannelId TrackedSpendableOutput_get_channel_id(const struct LDKTrackedSpendableOutput *NONNULL_PTR this_ptr);
	public static native long TrackedSpendableOutput_get_channel_id(long this_ptr);
	// void TrackedSpendableOutput_set_channel_id(struct LDKTrackedSpendableOutput *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void TrackedSpendableOutput_set_channel_id(long this_ptr, long val);
	// struct LDKOutputSpendStatus TrackedSpendableOutput_get_status(const struct LDKTrackedSpendableOutput *NONNULL_PTR this_ptr);
	public static native long TrackedSpendableOutput_get_status(long this_ptr);
	// void TrackedSpendableOutput_set_status(struct LDKTrackedSpendableOutput *NONNULL_PTR this_ptr, struct LDKOutputSpendStatus val);
	public static native void TrackedSpendableOutput_set_status(long this_ptr, long val);
	// MUST_USE_RES struct LDKTrackedSpendableOutput TrackedSpendableOutput_new(struct LDKSpendableOutputDescriptor descriptor_arg, struct LDKChannelId channel_id_arg, struct LDKOutputSpendStatus status_arg);
	public static native long TrackedSpendableOutput_new(long descriptor_arg, long channel_id_arg, long status_arg);
	// uint64_t TrackedSpendableOutput_clone_ptr(LDKTrackedSpendableOutput *NONNULL_PTR arg);
	public static native long TrackedSpendableOutput_clone_ptr(long arg);
	// struct LDKTrackedSpendableOutput TrackedSpendableOutput_clone(const struct LDKTrackedSpendableOutput *NONNULL_PTR orig);
	public static native long TrackedSpendableOutput_clone(long orig);
	// bool TrackedSpendableOutput_eq(const struct LDKTrackedSpendableOutput *NONNULL_PTR a, const struct LDKTrackedSpendableOutput *NONNULL_PTR b);
	public static native boolean TrackedSpendableOutput_eq(long a, long b);
	// MUST_USE_RES bool TrackedSpendableOutput_is_spent_in(const struct LDKTrackedSpendableOutput *NONNULL_PTR this_arg, struct LDKTransaction tx);
	public static native boolean TrackedSpendableOutput_is_spent_in(long this_arg, byte[] tx);
	// struct LDKCVec_u8Z TrackedSpendableOutput_write(const struct LDKTrackedSpendableOutput *NONNULL_PTR obj);
	public static native byte[] TrackedSpendableOutput_write(long obj);
	// struct LDKCResult_TrackedSpendableOutputDecodeErrorZ TrackedSpendableOutput_read(struct LDKu8slice ser);
	public static native long TrackedSpendableOutput_read(byte[] ser);
	// void OutputSpendStatus_free(struct LDKOutputSpendStatus this_ptr);
	public static native void OutputSpendStatus_free(long this_ptr);
	// uint64_t OutputSpendStatus_clone_ptr(LDKOutputSpendStatus *NONNULL_PTR arg);
	public static native long OutputSpendStatus_clone_ptr(long arg);
	// struct LDKOutputSpendStatus OutputSpendStatus_clone(const struct LDKOutputSpendStatus *NONNULL_PTR orig);
	public static native long OutputSpendStatus_clone(long orig);
	// struct LDKOutputSpendStatus OutputSpendStatus_pending_initial_broadcast(struct LDKCOption_u32Z delayed_until_height);
	public static native long OutputSpendStatus_pending_initial_broadcast(long delayed_until_height);
	// struct LDKOutputSpendStatus OutputSpendStatus_pending_first_confirmation(struct LDKThirtyTwoBytes first_broadcast_hash, uint32_t latest_broadcast_height, struct LDKTransaction latest_spending_tx);
	public static native long OutputSpendStatus_pending_first_confirmation(byte[] first_broadcast_hash, int latest_broadcast_height, byte[] latest_spending_tx);
	// struct LDKOutputSpendStatus OutputSpendStatus_pending_threshold_confirmations(struct LDKThirtyTwoBytes first_broadcast_hash, uint32_t latest_broadcast_height, struct LDKTransaction latest_spending_tx, uint32_t confirmation_height, struct LDKThirtyTwoBytes confirmation_hash);
	public static native long OutputSpendStatus_pending_threshold_confirmations(byte[] first_broadcast_hash, int latest_broadcast_height, byte[] latest_spending_tx, int confirmation_height, byte[] confirmation_hash);
	// bool OutputSpendStatus_eq(const struct LDKOutputSpendStatus *NONNULL_PTR a, const struct LDKOutputSpendStatus *NONNULL_PTR b);
	public static native boolean OutputSpendStatus_eq(long a, long b);
	// struct LDKCVec_u8Z OutputSpendStatus_write(const struct LDKOutputSpendStatus *NONNULL_PTR obj);
	public static native byte[] OutputSpendStatus_write(long obj);
	// struct LDKCResult_OutputSpendStatusDecodeErrorZ OutputSpendStatus_read(struct LDKu8slice ser);
	public static native long OutputSpendStatus_read(byte[] ser);
	// void OutputSweeper_free(struct LDKOutputSweeper this_obj);
	public static native void OutputSweeper_free(long this_obj);
	// MUST_USE_RES struct LDKOutputSweeper OutputSweeper_new(struct LDKBestBlock best_block, struct LDKBroadcasterInterface broadcaster, struct LDKFeeEstimator fee_estimator, struct LDKCOption_FilterZ chain_data_source, struct LDKOutputSpender output_spender, struct LDKChangeDestinationSource change_destination_source, struct LDKKVStore kv_store, struct LDKLogger logger);
	public static native long OutputSweeper_new(long best_block, long broadcaster, long fee_estimator, long chain_data_source, long output_spender, long change_destination_source, long kv_store, long logger);
	// MUST_USE_RES struct LDKCResult_NoneNoneZ OutputSweeper_track_spendable_outputs(const struct LDKOutputSweeper *NONNULL_PTR this_arg, struct LDKCVec_SpendableOutputDescriptorZ output_descriptors, struct LDKChannelId channel_id, bool exclude_static_outputs, struct LDKCOption_u32Z delay_until_height);
	public static native long OutputSweeper_track_spendable_outputs(long this_arg, long[] output_descriptors, long channel_id, boolean exclude_static_outputs, long delay_until_height);
	// MUST_USE_RES struct LDKCVec_TrackedSpendableOutputZ OutputSweeper_tracked_spendable_outputs(const struct LDKOutputSweeper *NONNULL_PTR this_arg);
	public static native long[] OutputSweeper_tracked_spendable_outputs(long this_arg);
	// MUST_USE_RES struct LDKBestBlock OutputSweeper_current_best_block(const struct LDKOutputSweeper *NONNULL_PTR this_arg);
	public static native long OutputSweeper_current_best_block(long this_arg);
	// struct LDKListen OutputSweeper_as_Listen(const struct LDKOutputSweeper *NONNULL_PTR this_arg);
	public static native long OutputSweeper_as_Listen(long this_arg);
	// struct LDKConfirm OutputSweeper_as_Confirm(const struct LDKOutputSweeper *NONNULL_PTR this_arg);
	public static native long OutputSweeper_as_Confirm(long this_arg);
	// void SpendingDelay_free(struct LDKSpendingDelay this_ptr);
	public static native void SpendingDelay_free(long this_ptr);
	// uint64_t SpendingDelay_clone_ptr(LDKSpendingDelay *NONNULL_PTR arg);
	public static native long SpendingDelay_clone_ptr(long arg);
	// struct LDKSpendingDelay SpendingDelay_clone(const struct LDKSpendingDelay *NONNULL_PTR orig);
	public static native long SpendingDelay_clone(long orig);
	// struct LDKSpendingDelay SpendingDelay_relative(uint32_t num_blocks);
	public static native long SpendingDelay_relative(int num_blocks);
	// struct LDKSpendingDelay SpendingDelay_absolute(uint32_t height);
	public static native long SpendingDelay_absolute(int height);
	// struct LDKCResult_OutputSweeperDecodeErrorZ OutputSweeper_read(struct LDKu8slice ser, struct LDKBroadcasterInterface arg_a, struct LDKFeeEstimator arg_b, struct LDKCOption_FilterZ arg_c, struct LDKOutputSpender arg_d, struct LDKChangeDestinationSource arg_e, struct LDKKVStore arg_f, struct LDKLogger arg_g);
	public static native long OutputSweeper_read(byte[] ser, long arg_a, long arg_b, long arg_c, long arg_d, long arg_e, long arg_f, long arg_g);
	// struct LDKCResult_C2Tuple_BestBlockOutputSweeperZDecodeErrorZ C2Tuple_BestBlockOutputSweeperZ_read(struct LDKu8slice ser, struct LDKBroadcasterInterface arg_a, struct LDKFeeEstimator arg_b, struct LDKCOption_FilterZ arg_c, struct LDKOutputSpender arg_d, struct LDKChangeDestinationSource arg_e, struct LDKKVStore arg_f, struct LDKLogger arg_g);
	public static native long C2Tuple_BestBlockOutputSweeperZ_read(byte[] ser, long arg_a, long arg_b, long arg_c, long arg_d, long arg_e, long arg_f, long arg_g);
	// void FutureCallback_free(struct LDKFutureCallback this_ptr);
	public static native void FutureCallback_free(long this_ptr);
	// void Future_free(struct LDKFuture this_obj);
	public static native void Future_free(long this_obj);
	// void Future_register_callback_fn(const struct LDKFuture *NONNULL_PTR this_arg, struct LDKFutureCallback callback);
	public static native void Future_register_callback_fn(long this_arg, long callback);
	// void Future_wait(const struct LDKFuture *NONNULL_PTR this_arg);
	public static native void Future_wait(long this_arg);
	// MUST_USE_RES bool Future_wait_timeout(const struct LDKFuture *NONNULL_PTR this_arg, uint64_t max_wait);
	public static native boolean Future_wait_timeout(long this_arg, long max_wait);
	// void Sleeper_free(struct LDKSleeper this_obj);
	public static native void Sleeper_free(long this_obj);
	// MUST_USE_RES struct LDKSleeper Sleeper_from_single_future(const struct LDKFuture *NONNULL_PTR future);
	public static native long Sleeper_from_single_future(long future);
	// MUST_USE_RES struct LDKSleeper Sleeper_from_two_futures(const struct LDKFuture *NONNULL_PTR fut_a, const struct LDKFuture *NONNULL_PTR fut_b);
	public static native long Sleeper_from_two_futures(long fut_a, long fut_b);
	// MUST_USE_RES struct LDKSleeper Sleeper_from_three_futures(const struct LDKFuture *NONNULL_PTR fut_a, const struct LDKFuture *NONNULL_PTR fut_b, const struct LDKFuture *NONNULL_PTR fut_c);
	public static native long Sleeper_from_three_futures(long fut_a, long fut_b, long fut_c);
	// MUST_USE_RES struct LDKSleeper Sleeper_new(struct LDKCVec_FutureZ futures);
	public static native long Sleeper_new(long[] futures);
	// void Sleeper_wait(const struct LDKSleeper *NONNULL_PTR this_arg);
	public static native void Sleeper_wait(long this_arg);
	// MUST_USE_RES bool Sleeper_wait_timeout(const struct LDKSleeper *NONNULL_PTR this_arg, uint64_t max_wait);
	public static native boolean Sleeper_wait_timeout(long this_arg, long max_wait);
	// enum LDKLevel Level_clone(const enum LDKLevel *NONNULL_PTR orig);
	public static native Level Level_clone(long orig);
	// enum LDKLevel Level_gossip(void);
	public static native Level Level_gossip();
	// enum LDKLevel Level_trace(void);
	public static native Level Level_trace();
	// enum LDKLevel Level_debug(void);
	public static native Level Level_debug();
	// enum LDKLevel Level_info(void);
	public static native Level Level_info();
	// enum LDKLevel Level_warn(void);
	public static native Level Level_warn();
	// enum LDKLevel Level_error(void);
	public static native Level Level_error();
	// bool Level_eq(const enum LDKLevel *NONNULL_PTR a, const enum LDKLevel *NONNULL_PTR b);
	public static native boolean Level_eq(long a, long b);
	// uint64_t Level_hash(const enum LDKLevel *NONNULL_PTR o);
	public static native long Level_hash(long o);
	// struct LDKStr Level_to_str(const enum LDKLevel *NONNULL_PTR o);
	public static native String Level_to_str(long o);
	// MUST_USE_RES enum LDKLevel Level_max(void);
	public static native Level Level_max();
	// void Record_free(struct LDKRecord this_obj);
	public static native void Record_free(long this_obj);
	// enum LDKLevel Record_get_level(const struct LDKRecord *NONNULL_PTR this_ptr);
	public static native Level Record_get_level(long this_ptr);
	// void Record_set_level(struct LDKRecord *NONNULL_PTR this_ptr, enum LDKLevel val);
	public static native void Record_set_level(long this_ptr, Level val);
	// struct LDKPublicKey Record_get_peer_id(const struct LDKRecord *NONNULL_PTR this_ptr);
	public static native byte[] Record_get_peer_id(long this_ptr);
	// void Record_set_peer_id(struct LDKRecord *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void Record_set_peer_id(long this_ptr, byte[] val);
	// struct LDKChannelId Record_get_channel_id(const struct LDKRecord *NONNULL_PTR this_ptr);
	public static native long Record_get_channel_id(long this_ptr);
	// void Record_set_channel_id(struct LDKRecord *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void Record_set_channel_id(long this_ptr, long val);
	// struct LDKStr Record_get_args(const struct LDKRecord *NONNULL_PTR this_ptr);
	public static native String Record_get_args(long this_ptr);
	// void Record_set_args(struct LDKRecord *NONNULL_PTR this_ptr, struct LDKStr val);
	public static native void Record_set_args(long this_ptr, String val);
	// struct LDKStr Record_get_module_path(const struct LDKRecord *NONNULL_PTR this_ptr);
	public static native String Record_get_module_path(long this_ptr);
	// void Record_set_module_path(struct LDKRecord *NONNULL_PTR this_ptr, struct LDKStr val);
	public static native void Record_set_module_path(long this_ptr, String val);
	// struct LDKStr Record_get_file(const struct LDKRecord *NONNULL_PTR this_ptr);
	public static native String Record_get_file(long this_ptr);
	// void Record_set_file(struct LDKRecord *NONNULL_PTR this_ptr, struct LDKStr val);
	public static native void Record_set_file(long this_ptr, String val);
	// uint32_t Record_get_line(const struct LDKRecord *NONNULL_PTR this_ptr);
	public static native int Record_get_line(long this_ptr);
	// void Record_set_line(struct LDKRecord *NONNULL_PTR this_ptr, uint32_t val);
	public static native void Record_set_line(long this_ptr, int val);
	// struct LDKCOption_ThirtyTwoBytesZ Record_get_payment_hash(const struct LDKRecord *NONNULL_PTR this_ptr);
	public static native long Record_get_payment_hash(long this_ptr);
	// void Record_set_payment_hash(struct LDKRecord *NONNULL_PTR this_ptr, struct LDKCOption_ThirtyTwoBytesZ val);
	public static native void Record_set_payment_hash(long this_ptr, long val);
	// MUST_USE_RES struct LDKRecord Record_new(enum LDKLevel level_arg, struct LDKPublicKey peer_id_arg, struct LDKChannelId channel_id_arg, struct LDKStr args_arg, struct LDKStr module_path_arg, struct LDKStr file_arg, uint32_t line_arg, struct LDKCOption_ThirtyTwoBytesZ payment_hash_arg);
	public static native long Record_new(Level level_arg, byte[] peer_id_arg, long channel_id_arg, String args_arg, String module_path_arg, String file_arg, int line_arg, long payment_hash_arg);
	// uint64_t Record_clone_ptr(LDKRecord *NONNULL_PTR arg);
	public static native long Record_clone_ptr(long arg);
	// struct LDKRecord Record_clone(const struct LDKRecord *NONNULL_PTR orig);
	public static native long Record_clone(long orig);
	// void Logger_free(struct LDKLogger this_ptr);
	public static native void Logger_free(long this_ptr);
	// void ChannelHandshakeConfig_free(struct LDKChannelHandshakeConfig this_obj);
	public static native void ChannelHandshakeConfig_free(long this_obj);
	// uint32_t ChannelHandshakeConfig_get_minimum_depth(const struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr);
	public static native int ChannelHandshakeConfig_get_minimum_depth(long this_ptr);
	// void ChannelHandshakeConfig_set_minimum_depth(struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr, uint32_t val);
	public static native void ChannelHandshakeConfig_set_minimum_depth(long this_ptr, int val);
	// uint16_t ChannelHandshakeConfig_get_our_to_self_delay(const struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr);
	public static native short ChannelHandshakeConfig_get_our_to_self_delay(long this_ptr);
	// void ChannelHandshakeConfig_set_our_to_self_delay(struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr, uint16_t val);
	public static native void ChannelHandshakeConfig_set_our_to_self_delay(long this_ptr, short val);
	// uint64_t ChannelHandshakeConfig_get_our_htlc_minimum_msat(const struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr);
	public static native long ChannelHandshakeConfig_get_our_htlc_minimum_msat(long this_ptr);
	// void ChannelHandshakeConfig_set_our_htlc_minimum_msat(struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelHandshakeConfig_set_our_htlc_minimum_msat(long this_ptr, long val);
	// uint8_t ChannelHandshakeConfig_get_max_inbound_htlc_value_in_flight_percent_of_channel(const struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr);
	public static native byte ChannelHandshakeConfig_get_max_inbound_htlc_value_in_flight_percent_of_channel(long this_ptr);
	// void ChannelHandshakeConfig_set_max_inbound_htlc_value_in_flight_percent_of_channel(struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr, uint8_t val);
	public static native void ChannelHandshakeConfig_set_max_inbound_htlc_value_in_flight_percent_of_channel(long this_ptr, byte val);
	// bool ChannelHandshakeConfig_get_negotiate_scid_privacy(const struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr);
	public static native boolean ChannelHandshakeConfig_get_negotiate_scid_privacy(long this_ptr);
	// void ChannelHandshakeConfig_set_negotiate_scid_privacy(struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr, bool val);
	public static native void ChannelHandshakeConfig_set_negotiate_scid_privacy(long this_ptr, boolean val);
	// bool ChannelHandshakeConfig_get_announce_for_forwarding(const struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr);
	public static native boolean ChannelHandshakeConfig_get_announce_for_forwarding(long this_ptr);
	// void ChannelHandshakeConfig_set_announce_for_forwarding(struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr, bool val);
	public static native void ChannelHandshakeConfig_set_announce_for_forwarding(long this_ptr, boolean val);
	// bool ChannelHandshakeConfig_get_commit_upfront_shutdown_pubkey(const struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr);
	public static native boolean ChannelHandshakeConfig_get_commit_upfront_shutdown_pubkey(long this_ptr);
	// void ChannelHandshakeConfig_set_commit_upfront_shutdown_pubkey(struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr, bool val);
	public static native void ChannelHandshakeConfig_set_commit_upfront_shutdown_pubkey(long this_ptr, boolean val);
	// uint32_t ChannelHandshakeConfig_get_their_channel_reserve_proportional_millionths(const struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr);
	public static native int ChannelHandshakeConfig_get_their_channel_reserve_proportional_millionths(long this_ptr);
	// void ChannelHandshakeConfig_set_their_channel_reserve_proportional_millionths(struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr, uint32_t val);
	public static native void ChannelHandshakeConfig_set_their_channel_reserve_proportional_millionths(long this_ptr, int val);
	// bool ChannelHandshakeConfig_get_negotiate_anchors_zero_fee_htlc_tx(const struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr);
	public static native boolean ChannelHandshakeConfig_get_negotiate_anchors_zero_fee_htlc_tx(long this_ptr);
	// void ChannelHandshakeConfig_set_negotiate_anchors_zero_fee_htlc_tx(struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr, bool val);
	public static native void ChannelHandshakeConfig_set_negotiate_anchors_zero_fee_htlc_tx(long this_ptr, boolean val);
	// uint16_t ChannelHandshakeConfig_get_our_max_accepted_htlcs(const struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr);
	public static native short ChannelHandshakeConfig_get_our_max_accepted_htlcs(long this_ptr);
	// void ChannelHandshakeConfig_set_our_max_accepted_htlcs(struct LDKChannelHandshakeConfig *NONNULL_PTR this_ptr, uint16_t val);
	public static native void ChannelHandshakeConfig_set_our_max_accepted_htlcs(long this_ptr, short val);
	// MUST_USE_RES struct LDKChannelHandshakeConfig ChannelHandshakeConfig_new(uint32_t minimum_depth_arg, uint16_t our_to_self_delay_arg, uint64_t our_htlc_minimum_msat_arg, uint8_t max_inbound_htlc_value_in_flight_percent_of_channel_arg, bool negotiate_scid_privacy_arg, bool announce_for_forwarding_arg, bool commit_upfront_shutdown_pubkey_arg, uint32_t their_channel_reserve_proportional_millionths_arg, bool negotiate_anchors_zero_fee_htlc_tx_arg, uint16_t our_max_accepted_htlcs_arg);
	public static native long ChannelHandshakeConfig_new(int minimum_depth_arg, short our_to_self_delay_arg, long our_htlc_minimum_msat_arg, byte max_inbound_htlc_value_in_flight_percent_of_channel_arg, boolean negotiate_scid_privacy_arg, boolean announce_for_forwarding_arg, boolean commit_upfront_shutdown_pubkey_arg, int their_channel_reserve_proportional_millionths_arg, boolean negotiate_anchors_zero_fee_htlc_tx_arg, short our_max_accepted_htlcs_arg);
	// uint64_t ChannelHandshakeConfig_clone_ptr(LDKChannelHandshakeConfig *NONNULL_PTR arg);
	public static native long ChannelHandshakeConfig_clone_ptr(long arg);
	// struct LDKChannelHandshakeConfig ChannelHandshakeConfig_clone(const struct LDKChannelHandshakeConfig *NONNULL_PTR orig);
	public static native long ChannelHandshakeConfig_clone(long orig);
	// MUST_USE_RES struct LDKChannelHandshakeConfig ChannelHandshakeConfig_default(void);
	public static native long ChannelHandshakeConfig_default();
	// void ChannelHandshakeLimits_free(struct LDKChannelHandshakeLimits this_obj);
	public static native void ChannelHandshakeLimits_free(long this_obj);
	// uint64_t ChannelHandshakeLimits_get_min_funding_satoshis(const struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr);
	public static native long ChannelHandshakeLimits_get_min_funding_satoshis(long this_ptr);
	// void ChannelHandshakeLimits_set_min_funding_satoshis(struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelHandshakeLimits_set_min_funding_satoshis(long this_ptr, long val);
	// uint64_t ChannelHandshakeLimits_get_max_funding_satoshis(const struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr);
	public static native long ChannelHandshakeLimits_get_max_funding_satoshis(long this_ptr);
	// void ChannelHandshakeLimits_set_max_funding_satoshis(struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelHandshakeLimits_set_max_funding_satoshis(long this_ptr, long val);
	// uint64_t ChannelHandshakeLimits_get_max_htlc_minimum_msat(const struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr);
	public static native long ChannelHandshakeLimits_get_max_htlc_minimum_msat(long this_ptr);
	// void ChannelHandshakeLimits_set_max_htlc_minimum_msat(struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelHandshakeLimits_set_max_htlc_minimum_msat(long this_ptr, long val);
	// uint64_t ChannelHandshakeLimits_get_min_max_htlc_value_in_flight_msat(const struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr);
	public static native long ChannelHandshakeLimits_get_min_max_htlc_value_in_flight_msat(long this_ptr);
	// void ChannelHandshakeLimits_set_min_max_htlc_value_in_flight_msat(struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelHandshakeLimits_set_min_max_htlc_value_in_flight_msat(long this_ptr, long val);
	// uint64_t ChannelHandshakeLimits_get_max_channel_reserve_satoshis(const struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr);
	public static native long ChannelHandshakeLimits_get_max_channel_reserve_satoshis(long this_ptr);
	// void ChannelHandshakeLimits_set_max_channel_reserve_satoshis(struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelHandshakeLimits_set_max_channel_reserve_satoshis(long this_ptr, long val);
	// uint16_t ChannelHandshakeLimits_get_min_max_accepted_htlcs(const struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr);
	public static native short ChannelHandshakeLimits_get_min_max_accepted_htlcs(long this_ptr);
	// void ChannelHandshakeLimits_set_min_max_accepted_htlcs(struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr, uint16_t val);
	public static native void ChannelHandshakeLimits_set_min_max_accepted_htlcs(long this_ptr, short val);
	// uint32_t ChannelHandshakeLimits_get_max_minimum_depth(const struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr);
	public static native int ChannelHandshakeLimits_get_max_minimum_depth(long this_ptr);
	// void ChannelHandshakeLimits_set_max_minimum_depth(struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr, uint32_t val);
	public static native void ChannelHandshakeLimits_set_max_minimum_depth(long this_ptr, int val);
	// bool ChannelHandshakeLimits_get_trust_own_funding_0conf(const struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr);
	public static native boolean ChannelHandshakeLimits_get_trust_own_funding_0conf(long this_ptr);
	// void ChannelHandshakeLimits_set_trust_own_funding_0conf(struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr, bool val);
	public static native void ChannelHandshakeLimits_set_trust_own_funding_0conf(long this_ptr, boolean val);
	// bool ChannelHandshakeLimits_get_force_announced_channel_preference(const struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr);
	public static native boolean ChannelHandshakeLimits_get_force_announced_channel_preference(long this_ptr);
	// void ChannelHandshakeLimits_set_force_announced_channel_preference(struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr, bool val);
	public static native void ChannelHandshakeLimits_set_force_announced_channel_preference(long this_ptr, boolean val);
	// uint16_t ChannelHandshakeLimits_get_their_to_self_delay(const struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr);
	public static native short ChannelHandshakeLimits_get_their_to_self_delay(long this_ptr);
	// void ChannelHandshakeLimits_set_their_to_self_delay(struct LDKChannelHandshakeLimits *NONNULL_PTR this_ptr, uint16_t val);
	public static native void ChannelHandshakeLimits_set_their_to_self_delay(long this_ptr, short val);
	// MUST_USE_RES struct LDKChannelHandshakeLimits ChannelHandshakeLimits_new(uint64_t min_funding_satoshis_arg, uint64_t max_funding_satoshis_arg, uint64_t max_htlc_minimum_msat_arg, uint64_t min_max_htlc_value_in_flight_msat_arg, uint64_t max_channel_reserve_satoshis_arg, uint16_t min_max_accepted_htlcs_arg, uint32_t max_minimum_depth_arg, bool trust_own_funding_0conf_arg, bool force_announced_channel_preference_arg, uint16_t their_to_self_delay_arg);
	public static native long ChannelHandshakeLimits_new(long min_funding_satoshis_arg, long max_funding_satoshis_arg, long max_htlc_minimum_msat_arg, long min_max_htlc_value_in_flight_msat_arg, long max_channel_reserve_satoshis_arg, short min_max_accepted_htlcs_arg, int max_minimum_depth_arg, boolean trust_own_funding_0conf_arg, boolean force_announced_channel_preference_arg, short their_to_self_delay_arg);
	// uint64_t ChannelHandshakeLimits_clone_ptr(LDKChannelHandshakeLimits *NONNULL_PTR arg);
	public static native long ChannelHandshakeLimits_clone_ptr(long arg);
	// struct LDKChannelHandshakeLimits ChannelHandshakeLimits_clone(const struct LDKChannelHandshakeLimits *NONNULL_PTR orig);
	public static native long ChannelHandshakeLimits_clone(long orig);
	// MUST_USE_RES struct LDKChannelHandshakeLimits ChannelHandshakeLimits_default(void);
	public static native long ChannelHandshakeLimits_default();
	// void MaxDustHTLCExposure_free(struct LDKMaxDustHTLCExposure this_ptr);
	public static native void MaxDustHTLCExposure_free(long this_ptr);
	// uint64_t MaxDustHTLCExposure_clone_ptr(LDKMaxDustHTLCExposure *NONNULL_PTR arg);
	public static native long MaxDustHTLCExposure_clone_ptr(long arg);
	// struct LDKMaxDustHTLCExposure MaxDustHTLCExposure_clone(const struct LDKMaxDustHTLCExposure *NONNULL_PTR orig);
	public static native long MaxDustHTLCExposure_clone(long orig);
	// struct LDKMaxDustHTLCExposure MaxDustHTLCExposure_fixed_limit_msat(uint64_t a);
	public static native long MaxDustHTLCExposure_fixed_limit_msat(long a);
	// struct LDKMaxDustHTLCExposure MaxDustHTLCExposure_fee_rate_multiplier(uint64_t a);
	public static native long MaxDustHTLCExposure_fee_rate_multiplier(long a);
	// bool MaxDustHTLCExposure_eq(const struct LDKMaxDustHTLCExposure *NONNULL_PTR a, const struct LDKMaxDustHTLCExposure *NONNULL_PTR b);
	public static native boolean MaxDustHTLCExposure_eq(long a, long b);
	// struct LDKCVec_u8Z MaxDustHTLCExposure_write(const struct LDKMaxDustHTLCExposure *NONNULL_PTR obj);
	public static native byte[] MaxDustHTLCExposure_write(long obj);
	// struct LDKCResult_MaxDustHTLCExposureDecodeErrorZ MaxDustHTLCExposure_read(struct LDKu8slice ser);
	public static native long MaxDustHTLCExposure_read(byte[] ser);
	// void ChannelConfig_free(struct LDKChannelConfig this_obj);
	public static native void ChannelConfig_free(long this_obj);
	// uint32_t ChannelConfig_get_forwarding_fee_proportional_millionths(const struct LDKChannelConfig *NONNULL_PTR this_ptr);
	public static native int ChannelConfig_get_forwarding_fee_proportional_millionths(long this_ptr);
	// void ChannelConfig_set_forwarding_fee_proportional_millionths(struct LDKChannelConfig *NONNULL_PTR this_ptr, uint32_t val);
	public static native void ChannelConfig_set_forwarding_fee_proportional_millionths(long this_ptr, int val);
	// uint32_t ChannelConfig_get_forwarding_fee_base_msat(const struct LDKChannelConfig *NONNULL_PTR this_ptr);
	public static native int ChannelConfig_get_forwarding_fee_base_msat(long this_ptr);
	// void ChannelConfig_set_forwarding_fee_base_msat(struct LDKChannelConfig *NONNULL_PTR this_ptr, uint32_t val);
	public static native void ChannelConfig_set_forwarding_fee_base_msat(long this_ptr, int val);
	// uint16_t ChannelConfig_get_cltv_expiry_delta(const struct LDKChannelConfig *NONNULL_PTR this_ptr);
	public static native short ChannelConfig_get_cltv_expiry_delta(long this_ptr);
	// void ChannelConfig_set_cltv_expiry_delta(struct LDKChannelConfig *NONNULL_PTR this_ptr, uint16_t val);
	public static native void ChannelConfig_set_cltv_expiry_delta(long this_ptr, short val);
	// struct LDKMaxDustHTLCExposure ChannelConfig_get_max_dust_htlc_exposure(const struct LDKChannelConfig *NONNULL_PTR this_ptr);
	public static native long ChannelConfig_get_max_dust_htlc_exposure(long this_ptr);
	// void ChannelConfig_set_max_dust_htlc_exposure(struct LDKChannelConfig *NONNULL_PTR this_ptr, struct LDKMaxDustHTLCExposure val);
	public static native void ChannelConfig_set_max_dust_htlc_exposure(long this_ptr, long val);
	// uint64_t ChannelConfig_get_force_close_avoidance_max_fee_satoshis(const struct LDKChannelConfig *NONNULL_PTR this_ptr);
	public static native long ChannelConfig_get_force_close_avoidance_max_fee_satoshis(long this_ptr);
	// void ChannelConfig_set_force_close_avoidance_max_fee_satoshis(struct LDKChannelConfig *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelConfig_set_force_close_avoidance_max_fee_satoshis(long this_ptr, long val);
	// bool ChannelConfig_get_accept_underpaying_htlcs(const struct LDKChannelConfig *NONNULL_PTR this_ptr);
	public static native boolean ChannelConfig_get_accept_underpaying_htlcs(long this_ptr);
	// void ChannelConfig_set_accept_underpaying_htlcs(struct LDKChannelConfig *NONNULL_PTR this_ptr, bool val);
	public static native void ChannelConfig_set_accept_underpaying_htlcs(long this_ptr, boolean val);
	// MUST_USE_RES struct LDKChannelConfig ChannelConfig_new(uint32_t forwarding_fee_proportional_millionths_arg, uint32_t forwarding_fee_base_msat_arg, uint16_t cltv_expiry_delta_arg, struct LDKMaxDustHTLCExposure max_dust_htlc_exposure_arg, uint64_t force_close_avoidance_max_fee_satoshis_arg, bool accept_underpaying_htlcs_arg);
	public static native long ChannelConfig_new(int forwarding_fee_proportional_millionths_arg, int forwarding_fee_base_msat_arg, short cltv_expiry_delta_arg, long max_dust_htlc_exposure_arg, long force_close_avoidance_max_fee_satoshis_arg, boolean accept_underpaying_htlcs_arg);
	// uint64_t ChannelConfig_clone_ptr(LDKChannelConfig *NONNULL_PTR arg);
	public static native long ChannelConfig_clone_ptr(long arg);
	// struct LDKChannelConfig ChannelConfig_clone(const struct LDKChannelConfig *NONNULL_PTR orig);
	public static native long ChannelConfig_clone(long orig);
	// bool ChannelConfig_eq(const struct LDKChannelConfig *NONNULL_PTR a, const struct LDKChannelConfig *NONNULL_PTR b);
	public static native boolean ChannelConfig_eq(long a, long b);
	// void ChannelConfig_apply(struct LDKChannelConfig *NONNULL_PTR this_arg, const struct LDKChannelConfigUpdate *NONNULL_PTR update);
	public static native void ChannelConfig_apply(long this_arg, long update);
	// MUST_USE_RES struct LDKChannelConfig ChannelConfig_default(void);
	public static native long ChannelConfig_default();
	// struct LDKCVec_u8Z ChannelConfig_write(const struct LDKChannelConfig *NONNULL_PTR obj);
	public static native byte[] ChannelConfig_write(long obj);
	// struct LDKCResult_ChannelConfigDecodeErrorZ ChannelConfig_read(struct LDKu8slice ser);
	public static native long ChannelConfig_read(byte[] ser);
	// void ChannelConfigUpdate_free(struct LDKChannelConfigUpdate this_obj);
	public static native void ChannelConfigUpdate_free(long this_obj);
	// struct LDKCOption_u32Z ChannelConfigUpdate_get_forwarding_fee_proportional_millionths(const struct LDKChannelConfigUpdate *NONNULL_PTR this_ptr);
	public static native long ChannelConfigUpdate_get_forwarding_fee_proportional_millionths(long this_ptr);
	// void ChannelConfigUpdate_set_forwarding_fee_proportional_millionths(struct LDKChannelConfigUpdate *NONNULL_PTR this_ptr, struct LDKCOption_u32Z val);
	public static native void ChannelConfigUpdate_set_forwarding_fee_proportional_millionths(long this_ptr, long val);
	// struct LDKCOption_u32Z ChannelConfigUpdate_get_forwarding_fee_base_msat(const struct LDKChannelConfigUpdate *NONNULL_PTR this_ptr);
	public static native long ChannelConfigUpdate_get_forwarding_fee_base_msat(long this_ptr);
	// void ChannelConfigUpdate_set_forwarding_fee_base_msat(struct LDKChannelConfigUpdate *NONNULL_PTR this_ptr, struct LDKCOption_u32Z val);
	public static native void ChannelConfigUpdate_set_forwarding_fee_base_msat(long this_ptr, long val);
	// struct LDKCOption_u16Z ChannelConfigUpdate_get_cltv_expiry_delta(const struct LDKChannelConfigUpdate *NONNULL_PTR this_ptr);
	public static native long ChannelConfigUpdate_get_cltv_expiry_delta(long this_ptr);
	// void ChannelConfigUpdate_set_cltv_expiry_delta(struct LDKChannelConfigUpdate *NONNULL_PTR this_ptr, struct LDKCOption_u16Z val);
	public static native void ChannelConfigUpdate_set_cltv_expiry_delta(long this_ptr, long val);
	// struct LDKCOption_MaxDustHTLCExposureZ ChannelConfigUpdate_get_max_dust_htlc_exposure_msat(const struct LDKChannelConfigUpdate *NONNULL_PTR this_ptr);
	public static native long ChannelConfigUpdate_get_max_dust_htlc_exposure_msat(long this_ptr);
	// void ChannelConfigUpdate_set_max_dust_htlc_exposure_msat(struct LDKChannelConfigUpdate *NONNULL_PTR this_ptr, struct LDKCOption_MaxDustHTLCExposureZ val);
	public static native void ChannelConfigUpdate_set_max_dust_htlc_exposure_msat(long this_ptr, long val);
	// struct LDKCOption_u64Z ChannelConfigUpdate_get_force_close_avoidance_max_fee_satoshis(const struct LDKChannelConfigUpdate *NONNULL_PTR this_ptr);
	public static native long ChannelConfigUpdate_get_force_close_avoidance_max_fee_satoshis(long this_ptr);
	// void ChannelConfigUpdate_set_force_close_avoidance_max_fee_satoshis(struct LDKChannelConfigUpdate *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void ChannelConfigUpdate_set_force_close_avoidance_max_fee_satoshis(long this_ptr, long val);
	// MUST_USE_RES struct LDKChannelConfigUpdate ChannelConfigUpdate_new(struct LDKCOption_u32Z forwarding_fee_proportional_millionths_arg, struct LDKCOption_u32Z forwarding_fee_base_msat_arg, struct LDKCOption_u16Z cltv_expiry_delta_arg, struct LDKCOption_MaxDustHTLCExposureZ max_dust_htlc_exposure_msat_arg, struct LDKCOption_u64Z force_close_avoidance_max_fee_satoshis_arg);
	public static native long ChannelConfigUpdate_new(long forwarding_fee_proportional_millionths_arg, long forwarding_fee_base_msat_arg, long cltv_expiry_delta_arg, long max_dust_htlc_exposure_msat_arg, long force_close_avoidance_max_fee_satoshis_arg);
	// void UserConfig_free(struct LDKUserConfig this_obj);
	public static native void UserConfig_free(long this_obj);
	// struct LDKChannelHandshakeConfig UserConfig_get_channel_handshake_config(const struct LDKUserConfig *NONNULL_PTR this_ptr);
	public static native long UserConfig_get_channel_handshake_config(long this_ptr);
	// void UserConfig_set_channel_handshake_config(struct LDKUserConfig *NONNULL_PTR this_ptr, struct LDKChannelHandshakeConfig val);
	public static native void UserConfig_set_channel_handshake_config(long this_ptr, long val);
	// struct LDKChannelHandshakeLimits UserConfig_get_channel_handshake_limits(const struct LDKUserConfig *NONNULL_PTR this_ptr);
	public static native long UserConfig_get_channel_handshake_limits(long this_ptr);
	// void UserConfig_set_channel_handshake_limits(struct LDKUserConfig *NONNULL_PTR this_ptr, struct LDKChannelHandshakeLimits val);
	public static native void UserConfig_set_channel_handshake_limits(long this_ptr, long val);
	// struct LDKChannelConfig UserConfig_get_channel_config(const struct LDKUserConfig *NONNULL_PTR this_ptr);
	public static native long UserConfig_get_channel_config(long this_ptr);
	// void UserConfig_set_channel_config(struct LDKUserConfig *NONNULL_PTR this_ptr, struct LDKChannelConfig val);
	public static native void UserConfig_set_channel_config(long this_ptr, long val);
	// bool UserConfig_get_accept_forwards_to_priv_channels(const struct LDKUserConfig *NONNULL_PTR this_ptr);
	public static native boolean UserConfig_get_accept_forwards_to_priv_channels(long this_ptr);
	// void UserConfig_set_accept_forwards_to_priv_channels(struct LDKUserConfig *NONNULL_PTR this_ptr, bool val);
	public static native void UserConfig_set_accept_forwards_to_priv_channels(long this_ptr, boolean val);
	// bool UserConfig_get_accept_inbound_channels(const struct LDKUserConfig *NONNULL_PTR this_ptr);
	public static native boolean UserConfig_get_accept_inbound_channels(long this_ptr);
	// void UserConfig_set_accept_inbound_channels(struct LDKUserConfig *NONNULL_PTR this_ptr, bool val);
	public static native void UserConfig_set_accept_inbound_channels(long this_ptr, boolean val);
	// bool UserConfig_get_manually_accept_inbound_channels(const struct LDKUserConfig *NONNULL_PTR this_ptr);
	public static native boolean UserConfig_get_manually_accept_inbound_channels(long this_ptr);
	// void UserConfig_set_manually_accept_inbound_channels(struct LDKUserConfig *NONNULL_PTR this_ptr, bool val);
	public static native void UserConfig_set_manually_accept_inbound_channels(long this_ptr, boolean val);
	// bool UserConfig_get_accept_intercept_htlcs(const struct LDKUserConfig *NONNULL_PTR this_ptr);
	public static native boolean UserConfig_get_accept_intercept_htlcs(long this_ptr);
	// void UserConfig_set_accept_intercept_htlcs(struct LDKUserConfig *NONNULL_PTR this_ptr, bool val);
	public static native void UserConfig_set_accept_intercept_htlcs(long this_ptr, boolean val);
	// bool UserConfig_get_manually_handle_bolt12_invoices(const struct LDKUserConfig *NONNULL_PTR this_ptr);
	public static native boolean UserConfig_get_manually_handle_bolt12_invoices(long this_ptr);
	// void UserConfig_set_manually_handle_bolt12_invoices(struct LDKUserConfig *NONNULL_PTR this_ptr, bool val);
	public static native void UserConfig_set_manually_handle_bolt12_invoices(long this_ptr, boolean val);
	// MUST_USE_RES struct LDKUserConfig UserConfig_new(struct LDKChannelHandshakeConfig channel_handshake_config_arg, struct LDKChannelHandshakeLimits channel_handshake_limits_arg, struct LDKChannelConfig channel_config_arg, bool accept_forwards_to_priv_channels_arg, bool accept_inbound_channels_arg, bool manually_accept_inbound_channels_arg, bool accept_intercept_htlcs_arg, bool manually_handle_bolt12_invoices_arg);
	public static native long UserConfig_new(long channel_handshake_config_arg, long channel_handshake_limits_arg, long channel_config_arg, boolean accept_forwards_to_priv_channels_arg, boolean accept_inbound_channels_arg, boolean manually_accept_inbound_channels_arg, boolean accept_intercept_htlcs_arg, boolean manually_handle_bolt12_invoices_arg);
	// uint64_t UserConfig_clone_ptr(LDKUserConfig *NONNULL_PTR arg);
	public static native long UserConfig_clone_ptr(long arg);
	// struct LDKUserConfig UserConfig_clone(const struct LDKUserConfig *NONNULL_PTR orig);
	public static native long UserConfig_clone(long orig);
	// MUST_USE_RES struct LDKUserConfig UserConfig_default(void);
	public static native long UserConfig_default();
	// void BestBlock_free(struct LDKBestBlock this_obj);
	public static native void BestBlock_free(long this_obj);
	// const uint8_t (*BestBlock_get_block_hash(const struct LDKBestBlock *NONNULL_PTR this_ptr))[32];
	public static native byte[] BestBlock_get_block_hash(long this_ptr);
	// void BestBlock_set_block_hash(struct LDKBestBlock *NONNULL_PTR this_ptr, struct LDKThirtyTwoBytes val);
	public static native void BestBlock_set_block_hash(long this_ptr, byte[] val);
	// uint32_t BestBlock_get_height(const struct LDKBestBlock *NONNULL_PTR this_ptr);
	public static native int BestBlock_get_height(long this_ptr);
	// void BestBlock_set_height(struct LDKBestBlock *NONNULL_PTR this_ptr, uint32_t val);
	public static native void BestBlock_set_height(long this_ptr, int val);
	// MUST_USE_RES struct LDKBestBlock BestBlock_new(struct LDKThirtyTwoBytes block_hash_arg, uint32_t height_arg);
	public static native long BestBlock_new(byte[] block_hash_arg, int height_arg);
	// uint64_t BestBlock_clone_ptr(LDKBestBlock *NONNULL_PTR arg);
	public static native long BestBlock_clone_ptr(long arg);
	// struct LDKBestBlock BestBlock_clone(const struct LDKBestBlock *NONNULL_PTR orig);
	public static native long BestBlock_clone(long orig);
	// uint64_t BestBlock_hash(const struct LDKBestBlock *NONNULL_PTR o);
	public static native long BestBlock_hash(long o);
	// bool BestBlock_eq(const struct LDKBestBlock *NONNULL_PTR a, const struct LDKBestBlock *NONNULL_PTR b);
	public static native boolean BestBlock_eq(long a, long b);
	// MUST_USE_RES struct LDKBestBlock BestBlock_from_network(enum LDKNetwork network);
	public static native long BestBlock_from_network(Network network);
	// struct LDKCVec_u8Z BestBlock_write(const struct LDKBestBlock *NONNULL_PTR obj);
	public static native byte[] BestBlock_write(long obj);
	// struct LDKCResult_BestBlockDecodeErrorZ BestBlock_read(struct LDKu8slice ser);
	public static native long BestBlock_read(byte[] ser);
	// void Listen_free(struct LDKListen this_ptr);
	public static native void Listen_free(long this_ptr);
	// void Confirm_free(struct LDKConfirm this_ptr);
	public static native void Confirm_free(long this_ptr);
	// enum LDKChannelMonitorUpdateStatus ChannelMonitorUpdateStatus_clone(const enum LDKChannelMonitorUpdateStatus *NONNULL_PTR orig);
	public static native ChannelMonitorUpdateStatus ChannelMonitorUpdateStatus_clone(long orig);
	// enum LDKChannelMonitorUpdateStatus ChannelMonitorUpdateStatus_completed(void);
	public static native ChannelMonitorUpdateStatus ChannelMonitorUpdateStatus_completed();
	// enum LDKChannelMonitorUpdateStatus ChannelMonitorUpdateStatus_in_progress(void);
	public static native ChannelMonitorUpdateStatus ChannelMonitorUpdateStatus_in_progress();
	// enum LDKChannelMonitorUpdateStatus ChannelMonitorUpdateStatus_unrecoverable_error(void);
	public static native ChannelMonitorUpdateStatus ChannelMonitorUpdateStatus_unrecoverable_error();
	// bool ChannelMonitorUpdateStatus_eq(const enum LDKChannelMonitorUpdateStatus *NONNULL_PTR a, const enum LDKChannelMonitorUpdateStatus *NONNULL_PTR b);
	public static native boolean ChannelMonitorUpdateStatus_eq(long a, long b);
	// void Watch_free(struct LDKWatch this_ptr);
	public static native void Watch_free(long this_ptr);
	// void Filter_free(struct LDKFilter this_ptr);
	public static native void Filter_free(long this_ptr);
	// void WatchedOutput_free(struct LDKWatchedOutput this_obj);
	public static native void WatchedOutput_free(long this_obj);
	// struct LDKCOption_ThirtyTwoBytesZ WatchedOutput_get_block_hash(const struct LDKWatchedOutput *NONNULL_PTR this_ptr);
	public static native long WatchedOutput_get_block_hash(long this_ptr);
	// void WatchedOutput_set_block_hash(struct LDKWatchedOutput *NONNULL_PTR this_ptr, struct LDKCOption_ThirtyTwoBytesZ val);
	public static native void WatchedOutput_set_block_hash(long this_ptr, long val);
	// struct LDKOutPoint WatchedOutput_get_outpoint(const struct LDKWatchedOutput *NONNULL_PTR this_ptr);
	public static native long WatchedOutput_get_outpoint(long this_ptr);
	// void WatchedOutput_set_outpoint(struct LDKWatchedOutput *NONNULL_PTR this_ptr, struct LDKOutPoint val);
	public static native void WatchedOutput_set_outpoint(long this_ptr, long val);
	// struct LDKCVec_u8Z WatchedOutput_get_script_pubkey(const struct LDKWatchedOutput *NONNULL_PTR this_ptr);
	public static native byte[] WatchedOutput_get_script_pubkey(long this_ptr);
	// void WatchedOutput_set_script_pubkey(struct LDKWatchedOutput *NONNULL_PTR this_ptr, struct LDKCVec_u8Z val);
	public static native void WatchedOutput_set_script_pubkey(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKWatchedOutput WatchedOutput_new(struct LDKCOption_ThirtyTwoBytesZ block_hash_arg, struct LDKOutPoint outpoint_arg, struct LDKCVec_u8Z script_pubkey_arg);
	public static native long WatchedOutput_new(long block_hash_arg, long outpoint_arg, byte[] script_pubkey_arg);
	// uint64_t WatchedOutput_clone_ptr(LDKWatchedOutput *NONNULL_PTR arg);
	public static native long WatchedOutput_clone_ptr(long arg);
	// struct LDKWatchedOutput WatchedOutput_clone(const struct LDKWatchedOutput *NONNULL_PTR orig);
	public static native long WatchedOutput_clone(long orig);
	// bool WatchedOutput_eq(const struct LDKWatchedOutput *NONNULL_PTR a, const struct LDKWatchedOutput *NONNULL_PTR b);
	public static native boolean WatchedOutput_eq(long a, long b);
	// uint64_t WatchedOutput_hash(const struct LDKWatchedOutput *NONNULL_PTR o);
	public static native long WatchedOutput_hash(long o);
	// void BroadcasterInterface_free(struct LDKBroadcasterInterface this_ptr);
	public static native void BroadcasterInterface_free(long this_ptr);
	// enum LDKConfirmationTarget ConfirmationTarget_clone(const enum LDKConfirmationTarget *NONNULL_PTR orig);
	public static native ConfirmationTarget ConfirmationTarget_clone(long orig);
	// enum LDKConfirmationTarget ConfirmationTarget_maximum_fee_estimate(void);
	public static native ConfirmationTarget ConfirmationTarget_maximum_fee_estimate();
	// enum LDKConfirmationTarget ConfirmationTarget_urgent_on_chain_sweep(void);
	public static native ConfirmationTarget ConfirmationTarget_urgent_on_chain_sweep();
	// enum LDKConfirmationTarget ConfirmationTarget_min_allowed_anchor_channel_remote_fee(void);
	public static native ConfirmationTarget ConfirmationTarget_min_allowed_anchor_channel_remote_fee();
	// enum LDKConfirmationTarget ConfirmationTarget_min_allowed_non_anchor_channel_remote_fee(void);
	public static native ConfirmationTarget ConfirmationTarget_min_allowed_non_anchor_channel_remote_fee();
	// enum LDKConfirmationTarget ConfirmationTarget_anchor_channel_fee(void);
	public static native ConfirmationTarget ConfirmationTarget_anchor_channel_fee();
	// enum LDKConfirmationTarget ConfirmationTarget_non_anchor_channel_fee(void);
	public static native ConfirmationTarget ConfirmationTarget_non_anchor_channel_fee();
	// enum LDKConfirmationTarget ConfirmationTarget_channel_close_minimum(void);
	public static native ConfirmationTarget ConfirmationTarget_channel_close_minimum();
	// enum LDKConfirmationTarget ConfirmationTarget_output_spending_fee(void);
	public static native ConfirmationTarget ConfirmationTarget_output_spending_fee();
	// uint64_t ConfirmationTarget_hash(const enum LDKConfirmationTarget *NONNULL_PTR o);
	public static native long ConfirmationTarget_hash(long o);
	// bool ConfirmationTarget_eq(const enum LDKConfirmationTarget *NONNULL_PTR a, const enum LDKConfirmationTarget *NONNULL_PTR b);
	public static native boolean ConfirmationTarget_eq(long a, long b);
	// void FeeEstimator_free(struct LDKFeeEstimator this_ptr);
	public static native void FeeEstimator_free(long this_ptr);
	// void Persist_free(struct LDKPersist this_ptr);
	public static native void Persist_free(long this_ptr);
	// void LockedChannelMonitor_free(struct LDKLockedChannelMonitor this_obj);
	public static native void LockedChannelMonitor_free(long this_obj);
	// void ChainMonitor_free(struct LDKChainMonitor this_obj);
	public static native void ChainMonitor_free(long this_obj);
	// MUST_USE_RES struct LDKChainMonitor ChainMonitor_new(struct LDKCOption_FilterZ chain_source, struct LDKBroadcasterInterface broadcaster, struct LDKLogger logger, struct LDKFeeEstimator feeest, struct LDKPersist persister);
	public static native long ChainMonitor_new(long chain_source, long broadcaster, long logger, long feeest, long persister);
	// MUST_USE_RES struct LDKCVec_BalanceZ ChainMonitor_get_claimable_balances(const struct LDKChainMonitor *NONNULL_PTR this_arg, struct LDKCVec_ChannelDetailsZ ignored_channels);
	public static native long[] ChainMonitor_get_claimable_balances(long this_arg, long[] ignored_channels);
	// MUST_USE_RES struct LDKCResult_LockedChannelMonitorNoneZ ChainMonitor_get_monitor(const struct LDKChainMonitor *NONNULL_PTR this_arg, struct LDKOutPoint funding_txo);
	public static native long ChainMonitor_get_monitor(long this_arg, long funding_txo);
	// MUST_USE_RES struct LDKCVec_C2Tuple_OutPointChannelIdZZ ChainMonitor_list_monitors(const struct LDKChainMonitor *NONNULL_PTR this_arg);
	public static native long[] ChainMonitor_list_monitors(long this_arg);
	// MUST_USE_RES struct LDKCVec_C2Tuple_OutPointCVec_u64ZZZ ChainMonitor_list_pending_monitor_updates(const struct LDKChainMonitor *NONNULL_PTR this_arg);
	public static native long[] ChainMonitor_list_pending_monitor_updates(long this_arg);
	// MUST_USE_RES struct LDKCResult_NoneAPIErrorZ ChainMonitor_channel_monitor_updated(const struct LDKChainMonitor *NONNULL_PTR this_arg, struct LDKOutPoint funding_txo, uint64_t completed_update_id);
	public static native long ChainMonitor_channel_monitor_updated(long this_arg, long funding_txo, long completed_update_id);
	// MUST_USE_RES struct LDKFuture ChainMonitor_get_update_future(const struct LDKChainMonitor *NONNULL_PTR this_arg);
	public static native long ChainMonitor_get_update_future(long this_arg);
	// void ChainMonitor_rebroadcast_pending_claims(const struct LDKChainMonitor *NONNULL_PTR this_arg);
	public static native void ChainMonitor_rebroadcast_pending_claims(long this_arg);
	// void ChainMonitor_signer_unblocked(const struct LDKChainMonitor *NONNULL_PTR this_arg, struct LDKOutPoint monitor_opt);
	public static native void ChainMonitor_signer_unblocked(long this_arg, long monitor_opt);
	// void ChainMonitor_archive_fully_resolved_channel_monitors(const struct LDKChainMonitor *NONNULL_PTR this_arg);
	public static native void ChainMonitor_archive_fully_resolved_channel_monitors(long this_arg);
	// struct LDKListen ChainMonitor_as_Listen(const struct LDKChainMonitor *NONNULL_PTR this_arg);
	public static native long ChainMonitor_as_Listen(long this_arg);
	// struct LDKConfirm ChainMonitor_as_Confirm(const struct LDKChainMonitor *NONNULL_PTR this_arg);
	public static native long ChainMonitor_as_Confirm(long this_arg);
	// struct LDKWatch ChainMonitor_as_Watch(const struct LDKChainMonitor *NONNULL_PTR this_arg);
	public static native long ChainMonitor_as_Watch(long this_arg);
	// struct LDKEventsProvider ChainMonitor_as_EventsProvider(const struct LDKChainMonitor *NONNULL_PTR this_arg);
	public static native long ChainMonitor_as_EventsProvider(long this_arg);
	// void ChannelMonitorUpdate_free(struct LDKChannelMonitorUpdate this_obj);
	public static native void ChannelMonitorUpdate_free(long this_obj);
	// uint64_t ChannelMonitorUpdate_get_update_id(const struct LDKChannelMonitorUpdate *NONNULL_PTR this_ptr);
	public static native long ChannelMonitorUpdate_get_update_id(long this_ptr);
	// void ChannelMonitorUpdate_set_update_id(struct LDKChannelMonitorUpdate *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelMonitorUpdate_set_update_id(long this_ptr, long val);
	// struct LDKChannelId ChannelMonitorUpdate_get_channel_id(const struct LDKChannelMonitorUpdate *NONNULL_PTR this_ptr);
	public static native long ChannelMonitorUpdate_get_channel_id(long this_ptr);
	// void ChannelMonitorUpdate_set_channel_id(struct LDKChannelMonitorUpdate *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void ChannelMonitorUpdate_set_channel_id(long this_ptr, long val);
	// uint64_t ChannelMonitorUpdate_clone_ptr(LDKChannelMonitorUpdate *NONNULL_PTR arg);
	public static native long ChannelMonitorUpdate_clone_ptr(long arg);
	// struct LDKChannelMonitorUpdate ChannelMonitorUpdate_clone(const struct LDKChannelMonitorUpdate *NONNULL_PTR orig);
	public static native long ChannelMonitorUpdate_clone(long orig);
	// bool ChannelMonitorUpdate_eq(const struct LDKChannelMonitorUpdate *NONNULL_PTR a, const struct LDKChannelMonitorUpdate *NONNULL_PTR b);
	public static native boolean ChannelMonitorUpdate_eq(long a, long b);
	// struct LDKCVec_u8Z ChannelMonitorUpdate_write(const struct LDKChannelMonitorUpdate *NONNULL_PTR obj);
	public static native byte[] ChannelMonitorUpdate_write(long obj);
	// struct LDKCResult_ChannelMonitorUpdateDecodeErrorZ ChannelMonitorUpdate_read(struct LDKu8slice ser);
	public static native long ChannelMonitorUpdate_read(byte[] ser);
	// void MonitorEvent_free(struct LDKMonitorEvent this_ptr);
	public static native void MonitorEvent_free(long this_ptr);
	// uint64_t MonitorEvent_clone_ptr(LDKMonitorEvent *NONNULL_PTR arg);
	public static native long MonitorEvent_clone_ptr(long arg);
	// struct LDKMonitorEvent MonitorEvent_clone(const struct LDKMonitorEvent *NONNULL_PTR orig);
	public static native long MonitorEvent_clone(long orig);
	// struct LDKMonitorEvent MonitorEvent_htlcevent(struct LDKHTLCUpdate a);
	public static native long MonitorEvent_htlcevent(long a);
	// struct LDKMonitorEvent MonitorEvent_holder_force_closed_with_info(struct LDKClosureReason reason, struct LDKOutPoint outpoint, struct LDKChannelId channel_id);
	public static native long MonitorEvent_holder_force_closed_with_info(long reason, long outpoint, long channel_id);
	// struct LDKMonitorEvent MonitorEvent_holder_force_closed(struct LDKOutPoint a);
	public static native long MonitorEvent_holder_force_closed(long a);
	// struct LDKMonitorEvent MonitorEvent_completed(struct LDKOutPoint funding_txo, struct LDKChannelId channel_id, uint64_t monitor_update_id);
	public static native long MonitorEvent_completed(long funding_txo, long channel_id, long monitor_update_id);
	// bool MonitorEvent_eq(const struct LDKMonitorEvent *NONNULL_PTR a, const struct LDKMonitorEvent *NONNULL_PTR b);
	public static native boolean MonitorEvent_eq(long a, long b);
	// struct LDKCVec_u8Z MonitorEvent_write(const struct LDKMonitorEvent *NONNULL_PTR obj);
	public static native byte[] MonitorEvent_write(long obj);
	// struct LDKCResult_COption_MonitorEventZDecodeErrorZ MonitorEvent_read(struct LDKu8slice ser);
	public static native long MonitorEvent_read(byte[] ser);
	// void HTLCUpdate_free(struct LDKHTLCUpdate this_obj);
	public static native void HTLCUpdate_free(long this_obj);
	// uint64_t HTLCUpdate_clone_ptr(LDKHTLCUpdate *NONNULL_PTR arg);
	public static native long HTLCUpdate_clone_ptr(long arg);
	// struct LDKHTLCUpdate HTLCUpdate_clone(const struct LDKHTLCUpdate *NONNULL_PTR orig);
	public static native long HTLCUpdate_clone(long orig);
	// bool HTLCUpdate_eq(const struct LDKHTLCUpdate *NONNULL_PTR a, const struct LDKHTLCUpdate *NONNULL_PTR b);
	public static native boolean HTLCUpdate_eq(long a, long b);
	// struct LDKCVec_u8Z HTLCUpdate_write(const struct LDKHTLCUpdate *NONNULL_PTR obj);
	public static native byte[] HTLCUpdate_write(long obj);
	// struct LDKCResult_HTLCUpdateDecodeErrorZ HTLCUpdate_read(struct LDKu8slice ser);
	public static native long HTLCUpdate_read(byte[] ser);
	// enum LDKBalanceSource BalanceSource_clone(const enum LDKBalanceSource *NONNULL_PTR orig);
	public static native BalanceSource BalanceSource_clone(long orig);
	// enum LDKBalanceSource BalanceSource_holder_force_closed(void);
	public static native BalanceSource BalanceSource_holder_force_closed();
	// enum LDKBalanceSource BalanceSource_counterparty_force_closed(void);
	public static native BalanceSource BalanceSource_counterparty_force_closed();
	// enum LDKBalanceSource BalanceSource_coop_close(void);
	public static native BalanceSource BalanceSource_coop_close();
	// enum LDKBalanceSource BalanceSource_htlc(void);
	public static native BalanceSource BalanceSource_htlc();
	// bool BalanceSource_eq(const enum LDKBalanceSource *NONNULL_PTR a, const enum LDKBalanceSource *NONNULL_PTR b);
	public static native boolean BalanceSource_eq(long a, long b);
	// void Balance_free(struct LDKBalance this_ptr);
	public static native void Balance_free(long this_ptr);
	// uint64_t Balance_clone_ptr(LDKBalance *NONNULL_PTR arg);
	public static native long Balance_clone_ptr(long arg);
	// struct LDKBalance Balance_clone(const struct LDKBalance *NONNULL_PTR orig);
	public static native long Balance_clone(long orig);
	// struct LDKBalance Balance_claimable_on_channel_close(uint64_t amount_satoshis, uint64_t transaction_fee_satoshis, uint64_t outbound_payment_htlc_rounded_msat, uint64_t outbound_forwarded_htlc_rounded_msat, uint64_t inbound_claiming_htlc_rounded_msat, uint64_t inbound_htlc_rounded_msat);
	public static native long Balance_claimable_on_channel_close(long amount_satoshis, long transaction_fee_satoshis, long outbound_payment_htlc_rounded_msat, long outbound_forwarded_htlc_rounded_msat, long inbound_claiming_htlc_rounded_msat, long inbound_htlc_rounded_msat);
	// struct LDKBalance Balance_claimable_awaiting_confirmations(uint64_t amount_satoshis, uint32_t confirmation_height, enum LDKBalanceSource source);
	public static native long Balance_claimable_awaiting_confirmations(long amount_satoshis, int confirmation_height, BalanceSource source);
	// struct LDKBalance Balance_contentious_claimable(uint64_t amount_satoshis, uint32_t timeout_height, struct LDKThirtyTwoBytes payment_hash, struct LDKThirtyTwoBytes payment_preimage);
	public static native long Balance_contentious_claimable(long amount_satoshis, int timeout_height, byte[] payment_hash, byte[] payment_preimage);
	// struct LDKBalance Balance_maybe_timeout_claimable_htlc(uint64_t amount_satoshis, uint32_t claimable_height, struct LDKThirtyTwoBytes payment_hash, bool outbound_payment);
	public static native long Balance_maybe_timeout_claimable_htlc(long amount_satoshis, int claimable_height, byte[] payment_hash, boolean outbound_payment);
	// struct LDKBalance Balance_maybe_preimage_claimable_htlc(uint64_t amount_satoshis, uint32_t expiry_height, struct LDKThirtyTwoBytes payment_hash);
	public static native long Balance_maybe_preimage_claimable_htlc(long amount_satoshis, int expiry_height, byte[] payment_hash);
	// struct LDKBalance Balance_counterparty_revoked_output_claimable(uint64_t amount_satoshis);
	public static native long Balance_counterparty_revoked_output_claimable(long amount_satoshis);
	// bool Balance_eq(const struct LDKBalance *NONNULL_PTR a, const struct LDKBalance *NONNULL_PTR b);
	public static native boolean Balance_eq(long a, long b);
	// MUST_USE_RES uint64_t Balance_claimable_amount_satoshis(const struct LDKBalance *NONNULL_PTR this_arg);
	public static native long Balance_claimable_amount_satoshis(long this_arg);
	// void ChannelMonitor_free(struct LDKChannelMonitor this_obj);
	public static native void ChannelMonitor_free(long this_obj);
	// uint64_t ChannelMonitor_clone_ptr(LDKChannelMonitor *NONNULL_PTR arg);
	public static native long ChannelMonitor_clone_ptr(long arg);
	// struct LDKChannelMonitor ChannelMonitor_clone(const struct LDKChannelMonitor *NONNULL_PTR orig);
	public static native long ChannelMonitor_clone(long orig);
	// struct LDKCVec_u8Z ChannelMonitor_write(const struct LDKChannelMonitor *NONNULL_PTR obj);
	public static native byte[] ChannelMonitor_write(long obj);
	// MUST_USE_RES struct LDKCResult_NoneNoneZ ChannelMonitor_update_monitor(const struct LDKChannelMonitor *NONNULL_PTR this_arg, const struct LDKChannelMonitorUpdate *NONNULL_PTR updates, const struct LDKBroadcasterInterface *NONNULL_PTR broadcaster, const struct LDKFeeEstimator *NONNULL_PTR fee_estimator, const struct LDKLogger *NONNULL_PTR logger);
	public static native long ChannelMonitor_update_monitor(long this_arg, long updates, long broadcaster, long fee_estimator, long logger);
	// MUST_USE_RES uint64_t ChannelMonitor_get_latest_update_id(const struct LDKChannelMonitor *NONNULL_PTR this_arg);
	public static native long ChannelMonitor_get_latest_update_id(long this_arg);
	// MUST_USE_RES struct LDKC2Tuple_OutPointCVec_u8ZZ ChannelMonitor_get_funding_txo(const struct LDKChannelMonitor *NONNULL_PTR this_arg);
	public static native long ChannelMonitor_get_funding_txo(long this_arg);
	// MUST_USE_RES struct LDKChannelId ChannelMonitor_channel_id(const struct LDKChannelMonitor *NONNULL_PTR this_arg);
	public static native long ChannelMonitor_channel_id(long this_arg);
	// MUST_USE_RES struct LDKCVec_C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZZ ChannelMonitor_get_outputs_to_watch(const struct LDKChannelMonitor *NONNULL_PTR this_arg);
	public static native long[] ChannelMonitor_get_outputs_to_watch(long this_arg);
	// void ChannelMonitor_load_outputs_to_watch(const struct LDKChannelMonitor *NONNULL_PTR this_arg, const struct LDKFilter *NONNULL_PTR filter, const struct LDKLogger *NONNULL_PTR logger);
	public static native void ChannelMonitor_load_outputs_to_watch(long this_arg, long filter, long logger);
	// MUST_USE_RES struct LDKCVec_MonitorEventZ ChannelMonitor_get_and_clear_pending_monitor_events(const struct LDKChannelMonitor *NONNULL_PTR this_arg);
	public static native long[] ChannelMonitor_get_and_clear_pending_monitor_events(long this_arg);
	// MUST_USE_RES struct LDKCResult_NoneReplayEventZ ChannelMonitor_process_pending_events(const struct LDKChannelMonitor *NONNULL_PTR this_arg, const struct LDKEventHandler *NONNULL_PTR handler, const struct LDKLogger *NONNULL_PTR logger);
	public static native long ChannelMonitor_process_pending_events(long this_arg, long handler, long logger);
	// MUST_USE_RES struct LDKCommitmentTransaction ChannelMonitor_initial_counterparty_commitment_tx(const struct LDKChannelMonitor *NONNULL_PTR this_arg);
	public static native long ChannelMonitor_initial_counterparty_commitment_tx(long this_arg);
	// MUST_USE_RES struct LDKCVec_CommitmentTransactionZ ChannelMonitor_counterparty_commitment_txs_from_update(const struct LDKChannelMonitor *NONNULL_PTR this_arg, const struct LDKChannelMonitorUpdate *NONNULL_PTR update);
	public static native long[] ChannelMonitor_counterparty_commitment_txs_from_update(long this_arg, long update);
	// MUST_USE_RES struct LDKCResult_TransactionNoneZ ChannelMonitor_sign_to_local_justice_tx(const struct LDKChannelMonitor *NONNULL_PTR this_arg, struct LDKTransaction justice_tx, uintptr_t input_idx, uint64_t value, uint64_t commitment_number);
	public static native long ChannelMonitor_sign_to_local_justice_tx(long this_arg, byte[] justice_tx, long input_idx, long value, long commitment_number);
	// MUST_USE_RES struct LDKPublicKey ChannelMonitor_get_counterparty_node_id(const struct LDKChannelMonitor *NONNULL_PTR this_arg);
	public static native byte[] ChannelMonitor_get_counterparty_node_id(long this_arg);
	// void ChannelMonitor_broadcast_latest_holder_commitment_txn(const struct LDKChannelMonitor *NONNULL_PTR this_arg, const struct LDKBroadcasterInterface *NONNULL_PTR broadcaster, const struct LDKFeeEstimator *NONNULL_PTR fee_estimator, const struct LDKLogger *NONNULL_PTR logger);
	public static native void ChannelMonitor_broadcast_latest_holder_commitment_txn(long this_arg, long broadcaster, long fee_estimator, long logger);
	// MUST_USE_RES struct LDKCVec_C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZZ ChannelMonitor_block_connected(const struct LDKChannelMonitor *NONNULL_PTR this_arg, const uint8_t (*header)[80], struct LDKCVec_C2Tuple_usizeTransactionZZ txdata, uint32_t height, struct LDKBroadcasterInterface broadcaster, struct LDKFeeEstimator fee_estimator, const struct LDKLogger *NONNULL_PTR logger);
	public static native long[] ChannelMonitor_block_connected(long this_arg, byte[] header, long[] txdata, int height, long broadcaster, long fee_estimator, long logger);
	// void ChannelMonitor_block_disconnected(const struct LDKChannelMonitor *NONNULL_PTR this_arg, const uint8_t (*header)[80], uint32_t height, struct LDKBroadcasterInterface broadcaster, struct LDKFeeEstimator fee_estimator, const struct LDKLogger *NONNULL_PTR logger);
	public static native void ChannelMonitor_block_disconnected(long this_arg, byte[] header, int height, long broadcaster, long fee_estimator, long logger);
	// MUST_USE_RES struct LDKCVec_C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZZ ChannelMonitor_transactions_confirmed(const struct LDKChannelMonitor *NONNULL_PTR this_arg, const uint8_t (*header)[80], struct LDKCVec_C2Tuple_usizeTransactionZZ txdata, uint32_t height, struct LDKBroadcasterInterface broadcaster, struct LDKFeeEstimator fee_estimator, const struct LDKLogger *NONNULL_PTR logger);
	public static native long[] ChannelMonitor_transactions_confirmed(long this_arg, byte[] header, long[] txdata, int height, long broadcaster, long fee_estimator, long logger);
	// void ChannelMonitor_transaction_unconfirmed(const struct LDKChannelMonitor *NONNULL_PTR this_arg, const uint8_t (*txid)[32], struct LDKBroadcasterInterface broadcaster, struct LDKFeeEstimator fee_estimator, const struct LDKLogger *NONNULL_PTR logger);
	public static native void ChannelMonitor_transaction_unconfirmed(long this_arg, byte[] txid, long broadcaster, long fee_estimator, long logger);
	// MUST_USE_RES struct LDKCVec_C2Tuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZZ ChannelMonitor_best_block_updated(const struct LDKChannelMonitor *NONNULL_PTR this_arg, const uint8_t (*header)[80], uint32_t height, struct LDKBroadcasterInterface broadcaster, struct LDKFeeEstimator fee_estimator, const struct LDKLogger *NONNULL_PTR logger);
	public static native long[] ChannelMonitor_best_block_updated(long this_arg, byte[] header, int height, long broadcaster, long fee_estimator, long logger);
	// MUST_USE_RES struct LDKCVec_C3Tuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZZ ChannelMonitor_get_relevant_txids(const struct LDKChannelMonitor *NONNULL_PTR this_arg);
	public static native long[] ChannelMonitor_get_relevant_txids(long this_arg);
	// MUST_USE_RES struct LDKBestBlock ChannelMonitor_current_best_block(const struct LDKChannelMonitor *NONNULL_PTR this_arg);
	public static native long ChannelMonitor_current_best_block(long this_arg);
	// void ChannelMonitor_rebroadcast_pending_claims(const struct LDKChannelMonitor *NONNULL_PTR this_arg, struct LDKBroadcasterInterface broadcaster, struct LDKFeeEstimator fee_estimator, const struct LDKLogger *NONNULL_PTR logger);
	public static native void ChannelMonitor_rebroadcast_pending_claims(long this_arg, long broadcaster, long fee_estimator, long logger);
	// MUST_USE_RES bool ChannelMonitor_has_pending_claims(const struct LDKChannelMonitor *NONNULL_PTR this_arg);
	public static native boolean ChannelMonitor_has_pending_claims(long this_arg);
	// void ChannelMonitor_signer_unblocked(const struct LDKChannelMonitor *NONNULL_PTR this_arg, struct LDKBroadcasterInterface broadcaster, struct LDKFeeEstimator fee_estimator, const struct LDKLogger *NONNULL_PTR logger);
	public static native void ChannelMonitor_signer_unblocked(long this_arg, long broadcaster, long fee_estimator, long logger);
	// MUST_USE_RES struct LDKCVec_SpendableOutputDescriptorZ ChannelMonitor_get_spendable_outputs(const struct LDKChannelMonitor *NONNULL_PTR this_arg, struct LDKTransaction tx, uint32_t confirmation_height);
	public static native long[] ChannelMonitor_get_spendable_outputs(long this_arg, byte[] tx, int confirmation_height);
	// MUST_USE_RES struct LDKC2Tuple_boolboolZ ChannelMonitor_check_and_update_full_resolution_status(const struct LDKChannelMonitor *NONNULL_PTR this_arg, const struct LDKLogger *NONNULL_PTR logger);
	public static native long ChannelMonitor_check_and_update_full_resolution_status(long this_arg, long logger);
	// MUST_USE_RES struct LDKCVec_BalanceZ ChannelMonitor_get_claimable_balances(const struct LDKChannelMonitor *NONNULL_PTR this_arg);
	public static native long[] ChannelMonitor_get_claimable_balances(long this_arg);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ C2Tuple_ThirtyTwoBytesChannelMonitorZ_read(struct LDKu8slice ser, const struct LDKEntropySource *NONNULL_PTR arg_a, const struct LDKSignerProvider *NONNULL_PTR arg_b);
	public static native long C2Tuple_ThirtyTwoBytesChannelMonitorZ_read(byte[] ser, long arg_a, long arg_b);
	// void OutPoint_free(struct LDKOutPoint this_obj);
	public static native void OutPoint_free(long this_obj);
	// const uint8_t (*OutPoint_get_txid(const struct LDKOutPoint *NONNULL_PTR this_ptr))[32];
	public static native byte[] OutPoint_get_txid(long this_ptr);
	// void OutPoint_set_txid(struct LDKOutPoint *NONNULL_PTR this_ptr, struct LDKThirtyTwoBytes val);
	public static native void OutPoint_set_txid(long this_ptr, byte[] val);
	// uint16_t OutPoint_get_index(const struct LDKOutPoint *NONNULL_PTR this_ptr);
	public static native short OutPoint_get_index(long this_ptr);
	// void OutPoint_set_index(struct LDKOutPoint *NONNULL_PTR this_ptr, uint16_t val);
	public static native void OutPoint_set_index(long this_ptr, short val);
	// MUST_USE_RES struct LDKOutPoint OutPoint_new(struct LDKThirtyTwoBytes txid_arg, uint16_t index_arg);
	public static native long OutPoint_new(byte[] txid_arg, short index_arg);
	// uint64_t OutPoint_clone_ptr(LDKOutPoint *NONNULL_PTR arg);
	public static native long OutPoint_clone_ptr(long arg);
	// struct LDKOutPoint OutPoint_clone(const struct LDKOutPoint *NONNULL_PTR orig);
	public static native long OutPoint_clone(long orig);
	// bool OutPoint_eq(const struct LDKOutPoint *NONNULL_PTR a, const struct LDKOutPoint *NONNULL_PTR b);
	public static native boolean OutPoint_eq(long a, long b);
	// uint64_t OutPoint_hash(const struct LDKOutPoint *NONNULL_PTR o);
	public static native long OutPoint_hash(long o);
	// struct LDKStr OutPoint_to_str(const struct LDKOutPoint *NONNULL_PTR o);
	public static native String OutPoint_to_str(long o);
	// struct LDKCVec_u8Z OutPoint_write(const struct LDKOutPoint *NONNULL_PTR obj);
	public static native byte[] OutPoint_write(long obj);
	// struct LDKCResult_OutPointDecodeErrorZ OutPoint_read(struct LDKu8slice ser);
	public static native long OutPoint_read(byte[] ser);
	// void InboundHTLCErr_free(struct LDKInboundHTLCErr this_obj);
	public static native void InboundHTLCErr_free(long this_obj);
	// uint16_t InboundHTLCErr_get_err_code(const struct LDKInboundHTLCErr *NONNULL_PTR this_ptr);
	public static native short InboundHTLCErr_get_err_code(long this_ptr);
	// void InboundHTLCErr_set_err_code(struct LDKInboundHTLCErr *NONNULL_PTR this_ptr, uint16_t val);
	public static native void InboundHTLCErr_set_err_code(long this_ptr, short val);
	// struct LDKCVec_u8Z InboundHTLCErr_get_err_data(const struct LDKInboundHTLCErr *NONNULL_PTR this_ptr);
	public static native byte[] InboundHTLCErr_get_err_data(long this_ptr);
	// void InboundHTLCErr_set_err_data(struct LDKInboundHTLCErr *NONNULL_PTR this_ptr, struct LDKCVec_u8Z val);
	public static native void InboundHTLCErr_set_err_data(long this_ptr, byte[] val);
	// struct LDKStr InboundHTLCErr_get_msg(const struct LDKInboundHTLCErr *NONNULL_PTR this_ptr);
	public static native String InboundHTLCErr_get_msg(long this_ptr);
	// void InboundHTLCErr_set_msg(struct LDKInboundHTLCErr *NONNULL_PTR this_ptr, struct LDKStr val);
	public static native void InboundHTLCErr_set_msg(long this_ptr, String val);
	// MUST_USE_RES struct LDKInboundHTLCErr InboundHTLCErr_new(uint16_t err_code_arg, struct LDKCVec_u8Z err_data_arg, struct LDKStr msg_arg);
	public static native long InboundHTLCErr_new(short err_code_arg, byte[] err_data_arg, String msg_arg);
	// uint64_t InboundHTLCErr_clone_ptr(LDKInboundHTLCErr *NONNULL_PTR arg);
	public static native long InboundHTLCErr_clone_ptr(long arg);
	// struct LDKInboundHTLCErr InboundHTLCErr_clone(const struct LDKInboundHTLCErr *NONNULL_PTR orig);
	public static native long InboundHTLCErr_clone(long orig);
	// uint64_t InboundHTLCErr_hash(const struct LDKInboundHTLCErr *NONNULL_PTR o);
	public static native long InboundHTLCErr_hash(long o);
	// bool InboundHTLCErr_eq(const struct LDKInboundHTLCErr *NONNULL_PTR a, const struct LDKInboundHTLCErr *NONNULL_PTR b);
	public static native boolean InboundHTLCErr_eq(long a, long b);
	// struct LDKCResult_PendingHTLCInfoInboundHTLCErrZ peel_payment_onion(const struct LDKUpdateAddHTLC *NONNULL_PTR msg, struct LDKNodeSigner node_signer, struct LDKLogger logger, uint32_t cur_height, bool allow_skimmed_fees);
	public static native long peel_payment_onion(long msg, long node_signer, long logger, int cur_height, boolean allow_skimmed_fees);
	// void PendingHTLCRouting_free(struct LDKPendingHTLCRouting this_ptr);
	public static native void PendingHTLCRouting_free(long this_ptr);
	// uint64_t PendingHTLCRouting_clone_ptr(LDKPendingHTLCRouting *NONNULL_PTR arg);
	public static native long PendingHTLCRouting_clone_ptr(long arg);
	// struct LDKPendingHTLCRouting PendingHTLCRouting_clone(const struct LDKPendingHTLCRouting *NONNULL_PTR orig);
	public static native long PendingHTLCRouting_clone(long orig);
	// struct LDKPendingHTLCRouting PendingHTLCRouting_forward(struct LDKOnionPacket onion_packet, uint64_t short_channel_id, struct LDKBlindedForward blinded, struct LDKCOption_u32Z incoming_cltv_expiry);
	public static native long PendingHTLCRouting_forward(long onion_packet, long short_channel_id, long blinded, long incoming_cltv_expiry);
	// struct LDKPendingHTLCRouting PendingHTLCRouting_receive(struct LDKFinalOnionHopData payment_data, struct LDKCOption_CVec_u8ZZ payment_metadata, struct LDKCOption_PaymentContextZ payment_context, uint32_t incoming_cltv_expiry, struct LDKThirtyTwoBytes phantom_shared_secret, struct LDKCVec_C2Tuple_u64CVec_u8ZZZ custom_tlvs, bool requires_blinded_error);
	public static native long PendingHTLCRouting_receive(long payment_data, long payment_metadata, long payment_context, int incoming_cltv_expiry, byte[] phantom_shared_secret, long[] custom_tlvs, boolean requires_blinded_error);
	// struct LDKPendingHTLCRouting PendingHTLCRouting_receive_keysend(struct LDKFinalOnionHopData payment_data, struct LDKThirtyTwoBytes payment_preimage, struct LDKCOption_CVec_u8ZZ payment_metadata, uint32_t incoming_cltv_expiry, struct LDKCVec_C2Tuple_u64CVec_u8ZZZ custom_tlvs, bool requires_blinded_error, bool has_recipient_created_payment_secret);
	public static native long PendingHTLCRouting_receive_keysend(long payment_data, byte[] payment_preimage, long payment_metadata, int incoming_cltv_expiry, long[] custom_tlvs, boolean requires_blinded_error, boolean has_recipient_created_payment_secret);
	// void BlindedForward_free(struct LDKBlindedForward this_obj);
	public static native void BlindedForward_free(long this_obj);
	// struct LDKPublicKey BlindedForward_get_inbound_blinding_point(const struct LDKBlindedForward *NONNULL_PTR this_ptr);
	public static native byte[] BlindedForward_get_inbound_blinding_point(long this_ptr);
	// void BlindedForward_set_inbound_blinding_point(struct LDKBlindedForward *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void BlindedForward_set_inbound_blinding_point(long this_ptr, byte[] val);
	// enum LDKBlindedFailure BlindedForward_get_failure(const struct LDKBlindedForward *NONNULL_PTR this_ptr);
	public static native BlindedFailure BlindedForward_get_failure(long this_ptr);
	// void BlindedForward_set_failure(struct LDKBlindedForward *NONNULL_PTR this_ptr, enum LDKBlindedFailure val);
	public static native void BlindedForward_set_failure(long this_ptr, BlindedFailure val);
	// struct LDKPublicKey BlindedForward_get_next_blinding_override(const struct LDKBlindedForward *NONNULL_PTR this_ptr);
	public static native byte[] BlindedForward_get_next_blinding_override(long this_ptr);
	// void BlindedForward_set_next_blinding_override(struct LDKBlindedForward *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void BlindedForward_set_next_blinding_override(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKBlindedForward BlindedForward_new(struct LDKPublicKey inbound_blinding_point_arg, enum LDKBlindedFailure failure_arg, struct LDKPublicKey next_blinding_override_arg);
	public static native long BlindedForward_new(byte[] inbound_blinding_point_arg, BlindedFailure failure_arg, byte[] next_blinding_override_arg);
	// uint64_t BlindedForward_clone_ptr(LDKBlindedForward *NONNULL_PTR arg);
	public static native long BlindedForward_clone_ptr(long arg);
	// struct LDKBlindedForward BlindedForward_clone(const struct LDKBlindedForward *NONNULL_PTR orig);
	public static native long BlindedForward_clone(long orig);
	// uint64_t BlindedForward_hash(const struct LDKBlindedForward *NONNULL_PTR o);
	public static native long BlindedForward_hash(long o);
	// bool BlindedForward_eq(const struct LDKBlindedForward *NONNULL_PTR a, const struct LDKBlindedForward *NONNULL_PTR b);
	public static native boolean BlindedForward_eq(long a, long b);
	// void PendingHTLCInfo_free(struct LDKPendingHTLCInfo this_obj);
	public static native void PendingHTLCInfo_free(long this_obj);
	// struct LDKPendingHTLCRouting PendingHTLCInfo_get_routing(const struct LDKPendingHTLCInfo *NONNULL_PTR this_ptr);
	public static native long PendingHTLCInfo_get_routing(long this_ptr);
	// void PendingHTLCInfo_set_routing(struct LDKPendingHTLCInfo *NONNULL_PTR this_ptr, struct LDKPendingHTLCRouting val);
	public static native void PendingHTLCInfo_set_routing(long this_ptr, long val);
	// const uint8_t (*PendingHTLCInfo_get_incoming_shared_secret(const struct LDKPendingHTLCInfo *NONNULL_PTR this_ptr))[32];
	public static native byte[] PendingHTLCInfo_get_incoming_shared_secret(long this_ptr);
	// void PendingHTLCInfo_set_incoming_shared_secret(struct LDKPendingHTLCInfo *NONNULL_PTR this_ptr, struct LDKThirtyTwoBytes val);
	public static native void PendingHTLCInfo_set_incoming_shared_secret(long this_ptr, byte[] val);
	// const uint8_t (*PendingHTLCInfo_get_payment_hash(const struct LDKPendingHTLCInfo *NONNULL_PTR this_ptr))[32];
	public static native byte[] PendingHTLCInfo_get_payment_hash(long this_ptr);
	// void PendingHTLCInfo_set_payment_hash(struct LDKPendingHTLCInfo *NONNULL_PTR this_ptr, struct LDKThirtyTwoBytes val);
	public static native void PendingHTLCInfo_set_payment_hash(long this_ptr, byte[] val);
	// struct LDKCOption_u64Z PendingHTLCInfo_get_incoming_amt_msat(const struct LDKPendingHTLCInfo *NONNULL_PTR this_ptr);
	public static native long PendingHTLCInfo_get_incoming_amt_msat(long this_ptr);
	// void PendingHTLCInfo_set_incoming_amt_msat(struct LDKPendingHTLCInfo *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void PendingHTLCInfo_set_incoming_amt_msat(long this_ptr, long val);
	// uint64_t PendingHTLCInfo_get_outgoing_amt_msat(const struct LDKPendingHTLCInfo *NONNULL_PTR this_ptr);
	public static native long PendingHTLCInfo_get_outgoing_amt_msat(long this_ptr);
	// void PendingHTLCInfo_set_outgoing_amt_msat(struct LDKPendingHTLCInfo *NONNULL_PTR this_ptr, uint64_t val);
	public static native void PendingHTLCInfo_set_outgoing_amt_msat(long this_ptr, long val);
	// uint32_t PendingHTLCInfo_get_outgoing_cltv_value(const struct LDKPendingHTLCInfo *NONNULL_PTR this_ptr);
	public static native int PendingHTLCInfo_get_outgoing_cltv_value(long this_ptr);
	// void PendingHTLCInfo_set_outgoing_cltv_value(struct LDKPendingHTLCInfo *NONNULL_PTR this_ptr, uint32_t val);
	public static native void PendingHTLCInfo_set_outgoing_cltv_value(long this_ptr, int val);
	// struct LDKCOption_u64Z PendingHTLCInfo_get_skimmed_fee_msat(const struct LDKPendingHTLCInfo *NONNULL_PTR this_ptr);
	public static native long PendingHTLCInfo_get_skimmed_fee_msat(long this_ptr);
	// void PendingHTLCInfo_set_skimmed_fee_msat(struct LDKPendingHTLCInfo *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void PendingHTLCInfo_set_skimmed_fee_msat(long this_ptr, long val);
	// MUST_USE_RES struct LDKPendingHTLCInfo PendingHTLCInfo_new(struct LDKPendingHTLCRouting routing_arg, struct LDKThirtyTwoBytes incoming_shared_secret_arg, struct LDKThirtyTwoBytes payment_hash_arg, struct LDKCOption_u64Z incoming_amt_msat_arg, uint64_t outgoing_amt_msat_arg, uint32_t outgoing_cltv_value_arg, struct LDKCOption_u64Z skimmed_fee_msat_arg);
	public static native long PendingHTLCInfo_new(long routing_arg, byte[] incoming_shared_secret_arg, byte[] payment_hash_arg, long incoming_amt_msat_arg, long outgoing_amt_msat_arg, int outgoing_cltv_value_arg, long skimmed_fee_msat_arg);
	// uint64_t PendingHTLCInfo_clone_ptr(LDKPendingHTLCInfo *NONNULL_PTR arg);
	public static native long PendingHTLCInfo_clone_ptr(long arg);
	// struct LDKPendingHTLCInfo PendingHTLCInfo_clone(const struct LDKPendingHTLCInfo *NONNULL_PTR orig);
	public static native long PendingHTLCInfo_clone(long orig);
	// enum LDKBlindedFailure BlindedFailure_clone(const enum LDKBlindedFailure *NONNULL_PTR orig);
	public static native BlindedFailure BlindedFailure_clone(long orig);
	// enum LDKBlindedFailure BlindedFailure_from_introduction_node(void);
	public static native BlindedFailure BlindedFailure_from_introduction_node();
	// enum LDKBlindedFailure BlindedFailure_from_blinded_node(void);
	public static native BlindedFailure BlindedFailure_from_blinded_node();
	// uint64_t BlindedFailure_hash(const enum LDKBlindedFailure *NONNULL_PTR o);
	public static native long BlindedFailure_hash(long o);
	// bool BlindedFailure_eq(const enum LDKBlindedFailure *NONNULL_PTR a, const enum LDKBlindedFailure *NONNULL_PTR b);
	public static native boolean BlindedFailure_eq(long a, long b);
	// void Verification_free(struct LDKVerification this_ptr);
	public static native void Verification_free(long this_ptr);
	// struct LDKVerification UnauthenticatedReceiveTlvs_as_Verification(const struct LDKUnauthenticatedReceiveTlvs *NONNULL_PTR this_arg);
	public static native long UnauthenticatedReceiveTlvs_as_Verification(long this_arg);
	// void FailureCode_free(struct LDKFailureCode this_ptr);
	public static native void FailureCode_free(long this_ptr);
	// uint64_t FailureCode_clone_ptr(LDKFailureCode *NONNULL_PTR arg);
	public static native long FailureCode_clone_ptr(long arg);
	// struct LDKFailureCode FailureCode_clone(const struct LDKFailureCode *NONNULL_PTR orig);
	public static native long FailureCode_clone(long orig);
	// struct LDKFailureCode FailureCode_temporary_node_failure(void);
	public static native long FailureCode_temporary_node_failure();
	// struct LDKFailureCode FailureCode_required_node_feature_missing(void);
	public static native long FailureCode_required_node_feature_missing();
	// struct LDKFailureCode FailureCode_incorrect_or_unknown_payment_details(void);
	public static native long FailureCode_incorrect_or_unknown_payment_details();
	// struct LDKFailureCode FailureCode_invalid_onion_payload(struct LDKCOption_C2Tuple_u64u16ZZ a);
	public static native long FailureCode_invalid_onion_payload(long a);
	// void ChannelManager_free(struct LDKChannelManager this_obj);
	public static native void ChannelManager_free(long this_obj);
	// void ChainParameters_free(struct LDKChainParameters this_obj);
	public static native void ChainParameters_free(long this_obj);
	// enum LDKNetwork ChainParameters_get_network(const struct LDKChainParameters *NONNULL_PTR this_ptr);
	public static native Network ChainParameters_get_network(long this_ptr);
	// void ChainParameters_set_network(struct LDKChainParameters *NONNULL_PTR this_ptr, enum LDKNetwork val);
	public static native void ChainParameters_set_network(long this_ptr, Network val);
	// struct LDKBestBlock ChainParameters_get_best_block(const struct LDKChainParameters *NONNULL_PTR this_ptr);
	public static native long ChainParameters_get_best_block(long this_ptr);
	// void ChainParameters_set_best_block(struct LDKChainParameters *NONNULL_PTR this_ptr, struct LDKBestBlock val);
	public static native void ChainParameters_set_best_block(long this_ptr, long val);
	// MUST_USE_RES struct LDKChainParameters ChainParameters_new(enum LDKNetwork network_arg, struct LDKBestBlock best_block_arg);
	public static native long ChainParameters_new(Network network_arg, long best_block_arg);
	// uint64_t ChainParameters_clone_ptr(LDKChainParameters *NONNULL_PTR arg);
	public static native long ChainParameters_clone_ptr(long arg);
	// struct LDKChainParameters ChainParameters_clone(const struct LDKChainParameters *NONNULL_PTR orig);
	public static native long ChainParameters_clone(long orig);
	// void RecentPaymentDetails_free(struct LDKRecentPaymentDetails this_ptr);
	public static native void RecentPaymentDetails_free(long this_ptr);
	// uint64_t RecentPaymentDetails_clone_ptr(LDKRecentPaymentDetails *NONNULL_PTR arg);
	public static native long RecentPaymentDetails_clone_ptr(long arg);
	// struct LDKRecentPaymentDetails RecentPaymentDetails_clone(const struct LDKRecentPaymentDetails *NONNULL_PTR orig);
	public static native long RecentPaymentDetails_clone(long orig);
	// struct LDKRecentPaymentDetails RecentPaymentDetails_awaiting_invoice(struct LDKThirtyTwoBytes payment_id);
	public static native long RecentPaymentDetails_awaiting_invoice(byte[] payment_id);
	// struct LDKRecentPaymentDetails RecentPaymentDetails_pending(struct LDKThirtyTwoBytes payment_id, struct LDKThirtyTwoBytes payment_hash, uint64_t total_msat);
	public static native long RecentPaymentDetails_pending(byte[] payment_id, byte[] payment_hash, long total_msat);
	// struct LDKRecentPaymentDetails RecentPaymentDetails_fulfilled(struct LDKThirtyTwoBytes payment_id, struct LDKCOption_ThirtyTwoBytesZ payment_hash);
	public static native long RecentPaymentDetails_fulfilled(byte[] payment_id, long payment_hash);
	// struct LDKRecentPaymentDetails RecentPaymentDetails_abandoned(struct LDKThirtyTwoBytes payment_id, struct LDKThirtyTwoBytes payment_hash);
	public static native long RecentPaymentDetails_abandoned(byte[] payment_id, byte[] payment_hash);
	// void PhantomRouteHints_free(struct LDKPhantomRouteHints this_obj);
	public static native void PhantomRouteHints_free(long this_obj);
	// struct LDKCVec_ChannelDetailsZ PhantomRouteHints_get_channels(const struct LDKPhantomRouteHints *NONNULL_PTR this_ptr);
	public static native long[] PhantomRouteHints_get_channels(long this_ptr);
	// void PhantomRouteHints_set_channels(struct LDKPhantomRouteHints *NONNULL_PTR this_ptr, struct LDKCVec_ChannelDetailsZ val);
	public static native void PhantomRouteHints_set_channels(long this_ptr, long[] val);
	// uint64_t PhantomRouteHints_get_phantom_scid(const struct LDKPhantomRouteHints *NONNULL_PTR this_ptr);
	public static native long PhantomRouteHints_get_phantom_scid(long this_ptr);
	// void PhantomRouteHints_set_phantom_scid(struct LDKPhantomRouteHints *NONNULL_PTR this_ptr, uint64_t val);
	public static native void PhantomRouteHints_set_phantom_scid(long this_ptr, long val);
	// struct LDKPublicKey PhantomRouteHints_get_real_node_pubkey(const struct LDKPhantomRouteHints *NONNULL_PTR this_ptr);
	public static native byte[] PhantomRouteHints_get_real_node_pubkey(long this_ptr);
	// void PhantomRouteHints_set_real_node_pubkey(struct LDKPhantomRouteHints *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void PhantomRouteHints_set_real_node_pubkey(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKPhantomRouteHints PhantomRouteHints_new(struct LDKCVec_ChannelDetailsZ channels_arg, uint64_t phantom_scid_arg, struct LDKPublicKey real_node_pubkey_arg);
	public static native long PhantomRouteHints_new(long[] channels_arg, long phantom_scid_arg, byte[] real_node_pubkey_arg);
	// uint64_t PhantomRouteHints_clone_ptr(LDKPhantomRouteHints *NONNULL_PTR arg);
	public static native long PhantomRouteHints_clone_ptr(long arg);
	// struct LDKPhantomRouteHints PhantomRouteHints_clone(const struct LDKPhantomRouteHints *NONNULL_PTR orig);
	public static native long PhantomRouteHints_clone(long orig);
	// MUST_USE_RES struct LDKChannelManager ChannelManager_new(struct LDKFeeEstimator fee_est, struct LDKWatch chain_monitor, struct LDKBroadcasterInterface tx_broadcaster, struct LDKRouter router, struct LDKMessageRouter message_router, struct LDKLogger logger, struct LDKEntropySource entropy_source, struct LDKNodeSigner node_signer, struct LDKSignerProvider signer_provider, struct LDKUserConfig config, struct LDKChainParameters params, uint32_t current_timestamp);
	public static native long ChannelManager_new(long fee_est, long chain_monitor, long tx_broadcaster, long router, long message_router, long logger, long entropy_source, long node_signer, long signer_provider, long config, long params, int current_timestamp);
	// MUST_USE_RES struct LDKUserConfig ChannelManager_get_current_default_configuration(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_get_current_default_configuration(long this_arg);
	// MUST_USE_RES struct LDKCResult_ChannelIdAPIErrorZ ChannelManager_create_channel(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKPublicKey their_network_key, uint64_t channel_value_satoshis, uint64_t push_msat, struct LDKU128 user_channel_id, struct LDKChannelId temporary_channel_id, struct LDKUserConfig override_config);
	public static native long ChannelManager_create_channel(long this_arg, byte[] their_network_key, long channel_value_satoshis, long push_msat, byte[] user_channel_id, long temporary_channel_id, long override_config);
	// MUST_USE_RES struct LDKCVec_ChannelDetailsZ ChannelManager_list_channels(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long[] ChannelManager_list_channels(long this_arg);
	// MUST_USE_RES struct LDKCVec_ChannelDetailsZ ChannelManager_list_usable_channels(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long[] ChannelManager_list_usable_channels(long this_arg);
	// MUST_USE_RES struct LDKCVec_ChannelDetailsZ ChannelManager_list_channels_with_counterparty(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKPublicKey counterparty_node_id);
	public static native long[] ChannelManager_list_channels_with_counterparty(long this_arg, byte[] counterparty_node_id);
	// MUST_USE_RES struct LDKCVec_RecentPaymentDetailsZ ChannelManager_list_recent_payments(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long[] ChannelManager_list_recent_payments(long this_arg);
	// MUST_USE_RES struct LDKCResult_NoneAPIErrorZ ChannelManager_close_channel(const struct LDKChannelManager *NONNULL_PTR this_arg, const struct LDKChannelId *NONNULL_PTR channel_id, struct LDKPublicKey counterparty_node_id);
	public static native long ChannelManager_close_channel(long this_arg, long channel_id, byte[] counterparty_node_id);
	// MUST_USE_RES struct LDKCResult_NoneAPIErrorZ ChannelManager_close_channel_with_feerate_and_script(const struct LDKChannelManager *NONNULL_PTR this_arg, const struct LDKChannelId *NONNULL_PTR channel_id, struct LDKPublicKey counterparty_node_id, struct LDKCOption_u32Z target_feerate_sats_per_1000_weight, struct LDKShutdownScript shutdown_script);
	public static native long ChannelManager_close_channel_with_feerate_and_script(long this_arg, long channel_id, byte[] counterparty_node_id, long target_feerate_sats_per_1000_weight, long shutdown_script);
	// MUST_USE_RES struct LDKCResult_NoneAPIErrorZ ChannelManager_force_close_broadcasting_latest_txn(const struct LDKChannelManager *NONNULL_PTR this_arg, const struct LDKChannelId *NONNULL_PTR channel_id, struct LDKPublicKey counterparty_node_id, struct LDKStr error_message);
	public static native long ChannelManager_force_close_broadcasting_latest_txn(long this_arg, long channel_id, byte[] counterparty_node_id, String error_message);
	// MUST_USE_RES struct LDKCResult_NoneAPIErrorZ ChannelManager_force_close_without_broadcasting_txn(const struct LDKChannelManager *NONNULL_PTR this_arg, const struct LDKChannelId *NONNULL_PTR channel_id, struct LDKPublicKey counterparty_node_id, struct LDKStr error_message);
	public static native long ChannelManager_force_close_without_broadcasting_txn(long this_arg, long channel_id, byte[] counterparty_node_id, String error_message);
	// void ChannelManager_force_close_all_channels_broadcasting_latest_txn(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKStr error_message);
	public static native void ChannelManager_force_close_all_channels_broadcasting_latest_txn(long this_arg, String error_message);
	// void ChannelManager_force_close_all_channels_without_broadcasting_txn(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKStr error_message);
	public static native void ChannelManager_force_close_all_channels_without_broadcasting_txn(long this_arg, String error_message);
	// MUST_USE_RES struct LDKCResult_NoneRetryableSendFailureZ ChannelManager_send_payment_with_route(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKRoute route, struct LDKThirtyTwoBytes payment_hash, struct LDKRecipientOnionFields recipient_onion, struct LDKThirtyTwoBytes payment_id);
	public static native long ChannelManager_send_payment_with_route(long this_arg, long route, byte[] payment_hash, long recipient_onion, byte[] payment_id);
	// MUST_USE_RES struct LDKCResult_NoneRetryableSendFailureZ ChannelManager_send_payment(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKThirtyTwoBytes payment_hash, struct LDKRecipientOnionFields recipient_onion, struct LDKThirtyTwoBytes payment_id, struct LDKRouteParameters route_params, struct LDKRetry retry_strategy);
	public static native long ChannelManager_send_payment(long this_arg, byte[] payment_hash, long recipient_onion, byte[] payment_id, long route_params, long retry_strategy);
	// MUST_USE_RES struct LDKCResult_NoneBolt12PaymentErrorZ ChannelManager_send_payment_for_bolt12_invoice(const struct LDKChannelManager *NONNULL_PTR this_arg, const struct LDKBolt12Invoice *NONNULL_PTR invoice, struct LDKCOption_OffersContextZ context);
	public static native long ChannelManager_send_payment_for_bolt12_invoice(long this_arg, long invoice, long context);
	// void ChannelManager_abandon_payment(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKThirtyTwoBytes payment_id);
	public static native void ChannelManager_abandon_payment(long this_arg, byte[] payment_id);
	// MUST_USE_RES struct LDKCResult_ThirtyTwoBytesRetryableSendFailureZ ChannelManager_send_spontaneous_payment(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKCOption_ThirtyTwoBytesZ payment_preimage, struct LDKRecipientOnionFields recipient_onion, struct LDKThirtyTwoBytes payment_id, struct LDKRouteParameters route_params, struct LDKRetry retry_strategy);
	public static native long ChannelManager_send_spontaneous_payment(long this_arg, long payment_preimage, long recipient_onion, byte[] payment_id, long route_params, long retry_strategy);
	// MUST_USE_RES struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ ChannelManager_send_probe(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKPath path);
	public static native long ChannelManager_send_probe(long this_arg, long path);
	// MUST_USE_RES struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ ChannelManager_send_spontaneous_preflight_probes(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKPublicKey node_id, uint64_t amount_msat, uint32_t final_cltv_expiry_delta, struct LDKCOption_u64Z liquidity_limit_multiplier);
	public static native long ChannelManager_send_spontaneous_preflight_probes(long this_arg, byte[] node_id, long amount_msat, int final_cltv_expiry_delta, long liquidity_limit_multiplier);
	// MUST_USE_RES struct LDKCResult_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ ChannelManager_send_preflight_probes(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKRouteParameters route_params, struct LDKCOption_u64Z liquidity_limit_multiplier);
	public static native long ChannelManager_send_preflight_probes(long this_arg, long route_params, long liquidity_limit_multiplier);
	// MUST_USE_RES struct LDKCResult_NoneAPIErrorZ ChannelManager_funding_transaction_generated(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKChannelId temporary_channel_id, struct LDKPublicKey counterparty_node_id, struct LDKTransaction funding_transaction);
	public static native long ChannelManager_funding_transaction_generated(long this_arg, long temporary_channel_id, byte[] counterparty_node_id, byte[] funding_transaction);
	// MUST_USE_RES struct LDKCResult_NoneAPIErrorZ ChannelManager_unsafe_manual_funding_transaction_generated(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKChannelId temporary_channel_id, struct LDKPublicKey counterparty_node_id, struct LDKOutPoint funding);
	public static native long ChannelManager_unsafe_manual_funding_transaction_generated(long this_arg, long temporary_channel_id, byte[] counterparty_node_id, long funding);
	// MUST_USE_RES struct LDKCResult_NoneAPIErrorZ ChannelManager_batch_funding_transaction_generated(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKCVec_C2Tuple_ChannelIdPublicKeyZZ temporary_channels, struct LDKTransaction funding_transaction);
	public static native long ChannelManager_batch_funding_transaction_generated(long this_arg, long[] temporary_channels, byte[] funding_transaction);
	// MUST_USE_RES struct LDKCResult_NoneAPIErrorZ ChannelManager_update_partial_channel_config(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKPublicKey counterparty_node_id, struct LDKCVec_ChannelIdZ channel_ids, const struct LDKChannelConfigUpdate *NONNULL_PTR config_update);
	public static native long ChannelManager_update_partial_channel_config(long this_arg, byte[] counterparty_node_id, long[] channel_ids, long config_update);
	// MUST_USE_RES struct LDKCResult_NoneAPIErrorZ ChannelManager_update_channel_config(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKPublicKey counterparty_node_id, struct LDKCVec_ChannelIdZ channel_ids, const struct LDKChannelConfig *NONNULL_PTR config);
	public static native long ChannelManager_update_channel_config(long this_arg, byte[] counterparty_node_id, long[] channel_ids, long config);
	// MUST_USE_RES struct LDKCResult_NoneAPIErrorZ ChannelManager_forward_intercepted_htlc(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKThirtyTwoBytes intercept_id, const struct LDKChannelId *NONNULL_PTR next_hop_channel_id, struct LDKPublicKey next_node_id, uint64_t amt_to_forward_msat);
	public static native long ChannelManager_forward_intercepted_htlc(long this_arg, byte[] intercept_id, long next_hop_channel_id, byte[] next_node_id, long amt_to_forward_msat);
	// MUST_USE_RES struct LDKCResult_NoneAPIErrorZ ChannelManager_fail_intercepted_htlc(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKThirtyTwoBytes intercept_id);
	public static native long ChannelManager_fail_intercepted_htlc(long this_arg, byte[] intercept_id);
	// void ChannelManager_process_pending_htlc_forwards(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native void ChannelManager_process_pending_htlc_forwards(long this_arg);
	// void ChannelManager_timer_tick_occurred(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native void ChannelManager_timer_tick_occurred(long this_arg);
	// void ChannelManager_fail_htlc_backwards(const struct LDKChannelManager *NONNULL_PTR this_arg, const uint8_t (*payment_hash)[32]);
	public static native void ChannelManager_fail_htlc_backwards(long this_arg, byte[] payment_hash);
	// void ChannelManager_fail_htlc_backwards_with_reason(const struct LDKChannelManager *NONNULL_PTR this_arg, const uint8_t (*payment_hash)[32], struct LDKFailureCode failure_code);
	public static native void ChannelManager_fail_htlc_backwards_with_reason(long this_arg, byte[] payment_hash, long failure_code);
	// void ChannelManager_claim_funds(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKThirtyTwoBytes payment_preimage);
	public static native void ChannelManager_claim_funds(long this_arg, byte[] payment_preimage);
	// void ChannelManager_claim_funds_with_known_custom_tlvs(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKThirtyTwoBytes payment_preimage);
	public static native void ChannelManager_claim_funds_with_known_custom_tlvs(long this_arg, byte[] payment_preimage);
	// MUST_USE_RES struct LDKPublicKey ChannelManager_get_our_node_id(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native byte[] ChannelManager_get_our_node_id(long this_arg);
	// MUST_USE_RES struct LDKCResult_NoneAPIErrorZ ChannelManager_accept_inbound_channel(const struct LDKChannelManager *NONNULL_PTR this_arg, const struct LDKChannelId *NONNULL_PTR temporary_channel_id, struct LDKPublicKey counterparty_node_id, struct LDKU128 user_channel_id);
	public static native long ChannelManager_accept_inbound_channel(long this_arg, long temporary_channel_id, byte[] counterparty_node_id, byte[] user_channel_id);
	// MUST_USE_RES struct LDKCResult_NoneAPIErrorZ ChannelManager_accept_inbound_channel_from_trusted_peer_0conf(const struct LDKChannelManager *NONNULL_PTR this_arg, const struct LDKChannelId *NONNULL_PTR temporary_channel_id, struct LDKPublicKey counterparty_node_id, struct LDKU128 user_channel_id);
	public static native long ChannelManager_accept_inbound_channel_from_trusted_peer_0conf(long this_arg, long temporary_channel_id, byte[] counterparty_node_id, byte[] user_channel_id);
	// void ChannelManager_signer_unblocked(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKCOption_C2Tuple_PublicKeyChannelIdZZ channel_opt);
	public static native void ChannelManager_signer_unblocked(long this_arg, long channel_opt);
	// MUST_USE_RES struct LDKCResult_Bolt11InvoiceSignOrCreationErrorZ ChannelManager_create_bolt11_invoice(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKBolt11InvoiceParameters params);
	public static native long ChannelManager_create_bolt11_invoice(long this_arg, long params);
	// void Bolt11InvoiceParameters_free(struct LDKBolt11InvoiceParameters this_obj);
	public static native void Bolt11InvoiceParameters_free(long this_obj);
	// struct LDKCOption_u64Z Bolt11InvoiceParameters_get_amount_msats(const struct LDKBolt11InvoiceParameters *NONNULL_PTR this_ptr);
	public static native long Bolt11InvoiceParameters_get_amount_msats(long this_ptr);
	// void Bolt11InvoiceParameters_set_amount_msats(struct LDKBolt11InvoiceParameters *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void Bolt11InvoiceParameters_set_amount_msats(long this_ptr, long val);
	// struct LDKBolt11InvoiceDescription Bolt11InvoiceParameters_get_description(const struct LDKBolt11InvoiceParameters *NONNULL_PTR this_ptr);
	public static native long Bolt11InvoiceParameters_get_description(long this_ptr);
	// void Bolt11InvoiceParameters_set_description(struct LDKBolt11InvoiceParameters *NONNULL_PTR this_ptr, struct LDKBolt11InvoiceDescription val);
	public static native void Bolt11InvoiceParameters_set_description(long this_ptr, long val);
	// struct LDKCOption_u32Z Bolt11InvoiceParameters_get_invoice_expiry_delta_secs(const struct LDKBolt11InvoiceParameters *NONNULL_PTR this_ptr);
	public static native long Bolt11InvoiceParameters_get_invoice_expiry_delta_secs(long this_ptr);
	// void Bolt11InvoiceParameters_set_invoice_expiry_delta_secs(struct LDKBolt11InvoiceParameters *NONNULL_PTR this_ptr, struct LDKCOption_u32Z val);
	public static native void Bolt11InvoiceParameters_set_invoice_expiry_delta_secs(long this_ptr, long val);
	// struct LDKCOption_u16Z Bolt11InvoiceParameters_get_min_final_cltv_expiry_delta(const struct LDKBolt11InvoiceParameters *NONNULL_PTR this_ptr);
	public static native long Bolt11InvoiceParameters_get_min_final_cltv_expiry_delta(long this_ptr);
	// void Bolt11InvoiceParameters_set_min_final_cltv_expiry_delta(struct LDKBolt11InvoiceParameters *NONNULL_PTR this_ptr, struct LDKCOption_u16Z val);
	public static native void Bolt11InvoiceParameters_set_min_final_cltv_expiry_delta(long this_ptr, long val);
	// struct LDKCOption_ThirtyTwoBytesZ Bolt11InvoiceParameters_get_payment_hash(const struct LDKBolt11InvoiceParameters *NONNULL_PTR this_ptr);
	public static native long Bolt11InvoiceParameters_get_payment_hash(long this_ptr);
	// void Bolt11InvoiceParameters_set_payment_hash(struct LDKBolt11InvoiceParameters *NONNULL_PTR this_ptr, struct LDKCOption_ThirtyTwoBytesZ val);
	public static native void Bolt11InvoiceParameters_set_payment_hash(long this_ptr, long val);
	// MUST_USE_RES struct LDKBolt11InvoiceParameters Bolt11InvoiceParameters_new(struct LDKCOption_u64Z amount_msats_arg, struct LDKBolt11InvoiceDescription description_arg, struct LDKCOption_u32Z invoice_expiry_delta_secs_arg, struct LDKCOption_u16Z min_final_cltv_expiry_delta_arg, struct LDKCOption_ThirtyTwoBytesZ payment_hash_arg);
	public static native long Bolt11InvoiceParameters_new(long amount_msats_arg, long description_arg, long invoice_expiry_delta_secs_arg, long min_final_cltv_expiry_delta_arg, long payment_hash_arg);
	// MUST_USE_RES struct LDKBolt11InvoiceParameters Bolt11InvoiceParameters_default(void);
	public static native long Bolt11InvoiceParameters_default();
	// MUST_USE_RES struct LDKCResult_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ ChannelManager_create_offer_builder(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKCOption_u64Z absolute_expiry);
	public static native long ChannelManager_create_offer_builder(long this_arg, long absolute_expiry);
	// MUST_USE_RES struct LDKCResult_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ ChannelManager_create_refund_builder(const struct LDKChannelManager *NONNULL_PTR this_arg, uint64_t amount_msats, uint64_t absolute_expiry, struct LDKThirtyTwoBytes payment_id, struct LDKRetry retry_strategy, struct LDKCOption_u64Z max_total_routing_fee_msat);
	public static native long ChannelManager_create_refund_builder(long this_arg, long amount_msats, long absolute_expiry, byte[] payment_id, long retry_strategy, long max_total_routing_fee_msat);
	// MUST_USE_RES struct LDKCResult_NoneBolt12SemanticErrorZ ChannelManager_pay_for_offer(const struct LDKChannelManager *NONNULL_PTR this_arg, const struct LDKOffer *NONNULL_PTR offer, struct LDKCOption_u64Z quantity, struct LDKCOption_u64Z amount_msats, struct LDKCOption_StrZ payer_note, struct LDKThirtyTwoBytes payment_id, struct LDKRetry retry_strategy, struct LDKCOption_u64Z max_total_routing_fee_msat);
	public static native long ChannelManager_pay_for_offer(long this_arg, long offer, long quantity, long amount_msats, long payer_note, byte[] payment_id, long retry_strategy, long max_total_routing_fee_msat);
	// MUST_USE_RES struct LDKCResult_Bolt12InvoiceBolt12SemanticErrorZ ChannelManager_request_refund_payment(const struct LDKChannelManager *NONNULL_PTR this_arg, const struct LDKRefund *NONNULL_PTR refund);
	public static native long ChannelManager_request_refund_payment(long this_arg, long refund);
	// MUST_USE_RES struct LDKCResult_NoneNoneZ ChannelManager_pay_for_offer_from_human_readable_name(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKHumanReadableName name, uint64_t amount_msats, struct LDKThirtyTwoBytes payment_id, struct LDKRetry retry_strategy, struct LDKCOption_u64Z max_total_routing_fee_msat, struct LDKCVec_DestinationZ dns_resolvers);
	public static native long ChannelManager_pay_for_offer_from_human_readable_name(long this_arg, long name, long amount_msats, byte[] payment_id, long retry_strategy, long max_total_routing_fee_msat, long[] dns_resolvers);
	// MUST_USE_RES struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ ChannelManager_create_inbound_payment(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKCOption_u64Z min_value_msat, uint32_t invoice_expiry_delta_secs, struct LDKCOption_u16Z min_final_cltv_expiry_delta);
	public static native long ChannelManager_create_inbound_payment(long this_arg, long min_value_msat, int invoice_expiry_delta_secs, long min_final_cltv_expiry_delta);
	// MUST_USE_RES struct LDKCResult_ThirtyTwoBytesNoneZ ChannelManager_create_inbound_payment_for_hash(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKThirtyTwoBytes payment_hash, struct LDKCOption_u64Z min_value_msat, uint32_t invoice_expiry_delta_secs, struct LDKCOption_u16Z min_final_cltv_expiry);
	public static native long ChannelManager_create_inbound_payment_for_hash(long this_arg, byte[] payment_hash, long min_value_msat, int invoice_expiry_delta_secs, long min_final_cltv_expiry);
	// MUST_USE_RES struct LDKCResult_ThirtyTwoBytesAPIErrorZ ChannelManager_get_payment_preimage(const struct LDKChannelManager *NONNULL_PTR this_arg, struct LDKThirtyTwoBytes payment_hash, struct LDKThirtyTwoBytes payment_secret);
	public static native long ChannelManager_get_payment_preimage(long this_arg, byte[] payment_hash, byte[] payment_secret);
	// MUST_USE_RES uint64_t ChannelManager_get_phantom_scid(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_get_phantom_scid(long this_arg);
	// MUST_USE_RES struct LDKPhantomRouteHints ChannelManager_get_phantom_route_hints(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_get_phantom_route_hints(long this_arg);
	// MUST_USE_RES uint64_t ChannelManager_get_intercept_scid(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_get_intercept_scid(long this_arg);
	// MUST_USE_RES struct LDKInFlightHtlcs ChannelManager_compute_inflight_htlcs(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_compute_inflight_htlcs(long this_arg);
	// struct LDKMessageSendEventsProvider ChannelManager_as_MessageSendEventsProvider(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_as_MessageSendEventsProvider(long this_arg);
	// struct LDKEventsProvider ChannelManager_as_EventsProvider(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_as_EventsProvider(long this_arg);
	// struct LDKListen ChannelManager_as_Listen(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_as_Listen(long this_arg);
	// struct LDKConfirm ChannelManager_as_Confirm(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_as_Confirm(long this_arg);
	// MUST_USE_RES struct LDKFuture ChannelManager_get_event_or_persistence_needed_future(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_get_event_or_persistence_needed_future(long this_arg);
	// MUST_USE_RES bool ChannelManager_get_and_clear_needs_persistence(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native boolean ChannelManager_get_and_clear_needs_persistence(long this_arg);
	// MUST_USE_RES struct LDKBestBlock ChannelManager_current_best_block(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_current_best_block(long this_arg);
	// MUST_USE_RES struct LDKNodeFeatures ChannelManager_node_features(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_node_features(long this_arg);
	// MUST_USE_RES struct LDKChannelFeatures ChannelManager_channel_features(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_channel_features(long this_arg);
	// MUST_USE_RES struct LDKChannelTypeFeatures ChannelManager_channel_type_features(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_channel_type_features(long this_arg);
	// MUST_USE_RES struct LDKInitFeatures ChannelManager_init_features(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_init_features(long this_arg);
	// struct LDKChannelMessageHandler ChannelManager_as_ChannelMessageHandler(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_as_ChannelMessageHandler(long this_arg);
	// struct LDKOffersMessageHandler ChannelManager_as_OffersMessageHandler(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_as_OffersMessageHandler(long this_arg);
	// struct LDKAsyncPaymentsMessageHandler ChannelManager_as_AsyncPaymentsMessageHandler(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_as_AsyncPaymentsMessageHandler(long this_arg);
	// struct LDKDNSResolverMessageHandler ChannelManager_as_DNSResolverMessageHandler(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_as_DNSResolverMessageHandler(long this_arg);
	// struct LDKNodeIdLookUp ChannelManager_as_NodeIdLookUp(const struct LDKChannelManager *NONNULL_PTR this_arg);
	public static native long ChannelManager_as_NodeIdLookUp(long this_arg);
	// struct LDKInitFeatures provided_init_features(const struct LDKUserConfig *NONNULL_PTR config);
	public static native long provided_init_features(long config);
	// struct LDKCVec_u8Z PhantomRouteHints_write(const struct LDKPhantomRouteHints *NONNULL_PTR obj);
	public static native byte[] PhantomRouteHints_write(long obj);
	// struct LDKCResult_PhantomRouteHintsDecodeErrorZ PhantomRouteHints_read(struct LDKu8slice ser);
	public static native long PhantomRouteHints_read(byte[] ser);
	// struct LDKCVec_u8Z BlindedForward_write(const struct LDKBlindedForward *NONNULL_PTR obj);
	public static native byte[] BlindedForward_write(long obj);
	// struct LDKCResult_BlindedForwardDecodeErrorZ BlindedForward_read(struct LDKu8slice ser);
	public static native long BlindedForward_read(byte[] ser);
	// struct LDKCVec_u8Z PendingHTLCRouting_write(const struct LDKPendingHTLCRouting *NONNULL_PTR obj);
	public static native byte[] PendingHTLCRouting_write(long obj);
	// struct LDKCResult_PendingHTLCRoutingDecodeErrorZ PendingHTLCRouting_read(struct LDKu8slice ser);
	public static native long PendingHTLCRouting_read(byte[] ser);
	// struct LDKCVec_u8Z PendingHTLCInfo_write(const struct LDKPendingHTLCInfo *NONNULL_PTR obj);
	public static native byte[] PendingHTLCInfo_write(long obj);
	// struct LDKCResult_PendingHTLCInfoDecodeErrorZ PendingHTLCInfo_read(struct LDKu8slice ser);
	public static native long PendingHTLCInfo_read(byte[] ser);
	// struct LDKCVec_u8Z BlindedFailure_write(const enum LDKBlindedFailure *NONNULL_PTR obj);
	public static native byte[] BlindedFailure_write(long obj);
	// struct LDKCResult_BlindedFailureDecodeErrorZ BlindedFailure_read(struct LDKu8slice ser);
	public static native long BlindedFailure_read(byte[] ser);
	// struct LDKCVec_u8Z ChannelManager_write(const struct LDKChannelManager *NONNULL_PTR obj);
	public static native byte[] ChannelManager_write(long obj);
	// void ChannelManagerReadArgs_free(struct LDKChannelManagerReadArgs this_obj);
	public static native void ChannelManagerReadArgs_free(long this_obj);
	// const struct LDKEntropySource *ChannelManagerReadArgs_get_entropy_source(const struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr);
	public static native long ChannelManagerReadArgs_get_entropy_source(long this_ptr);
	// void ChannelManagerReadArgs_set_entropy_source(struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr, struct LDKEntropySource val);
	public static native void ChannelManagerReadArgs_set_entropy_source(long this_ptr, long val);
	// const struct LDKNodeSigner *ChannelManagerReadArgs_get_node_signer(const struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr);
	public static native long ChannelManagerReadArgs_get_node_signer(long this_ptr);
	// void ChannelManagerReadArgs_set_node_signer(struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr, struct LDKNodeSigner val);
	public static native void ChannelManagerReadArgs_set_node_signer(long this_ptr, long val);
	// const struct LDKSignerProvider *ChannelManagerReadArgs_get_signer_provider(const struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr);
	public static native long ChannelManagerReadArgs_get_signer_provider(long this_ptr);
	// void ChannelManagerReadArgs_set_signer_provider(struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr, struct LDKSignerProvider val);
	public static native void ChannelManagerReadArgs_set_signer_provider(long this_ptr, long val);
	// const struct LDKFeeEstimator *ChannelManagerReadArgs_get_fee_estimator(const struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr);
	public static native long ChannelManagerReadArgs_get_fee_estimator(long this_ptr);
	// void ChannelManagerReadArgs_set_fee_estimator(struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr, struct LDKFeeEstimator val);
	public static native void ChannelManagerReadArgs_set_fee_estimator(long this_ptr, long val);
	// const struct LDKWatch *ChannelManagerReadArgs_get_chain_monitor(const struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr);
	public static native long ChannelManagerReadArgs_get_chain_monitor(long this_ptr);
	// void ChannelManagerReadArgs_set_chain_monitor(struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr, struct LDKWatch val);
	public static native void ChannelManagerReadArgs_set_chain_monitor(long this_ptr, long val);
	// const struct LDKBroadcasterInterface *ChannelManagerReadArgs_get_tx_broadcaster(const struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr);
	public static native long ChannelManagerReadArgs_get_tx_broadcaster(long this_ptr);
	// void ChannelManagerReadArgs_set_tx_broadcaster(struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr, struct LDKBroadcasterInterface val);
	public static native void ChannelManagerReadArgs_set_tx_broadcaster(long this_ptr, long val);
	// const struct LDKRouter *ChannelManagerReadArgs_get_router(const struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr);
	public static native long ChannelManagerReadArgs_get_router(long this_ptr);
	// void ChannelManagerReadArgs_set_router(struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr, struct LDKRouter val);
	public static native void ChannelManagerReadArgs_set_router(long this_ptr, long val);
	// const struct LDKMessageRouter *ChannelManagerReadArgs_get_message_router(const struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr);
	public static native long ChannelManagerReadArgs_get_message_router(long this_ptr);
	// void ChannelManagerReadArgs_set_message_router(struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr, struct LDKMessageRouter val);
	public static native void ChannelManagerReadArgs_set_message_router(long this_ptr, long val);
	// const struct LDKLogger *ChannelManagerReadArgs_get_logger(const struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr);
	public static native long ChannelManagerReadArgs_get_logger(long this_ptr);
	// void ChannelManagerReadArgs_set_logger(struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr, struct LDKLogger val);
	public static native void ChannelManagerReadArgs_set_logger(long this_ptr, long val);
	// struct LDKUserConfig ChannelManagerReadArgs_get_default_config(const struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr);
	public static native long ChannelManagerReadArgs_get_default_config(long this_ptr);
	// void ChannelManagerReadArgs_set_default_config(struct LDKChannelManagerReadArgs *NONNULL_PTR this_ptr, struct LDKUserConfig val);
	public static native void ChannelManagerReadArgs_set_default_config(long this_ptr, long val);
	// MUST_USE_RES struct LDKChannelManagerReadArgs ChannelManagerReadArgs_new(struct LDKEntropySource entropy_source, struct LDKNodeSigner node_signer, struct LDKSignerProvider signer_provider, struct LDKFeeEstimator fee_estimator, struct LDKWatch chain_monitor, struct LDKBroadcasterInterface tx_broadcaster, struct LDKRouter router, struct LDKMessageRouter message_router, struct LDKLogger logger, struct LDKUserConfig default_config, struct LDKCVec_ChannelMonitorZ channel_monitors);
	public static native long ChannelManagerReadArgs_new(long entropy_source, long node_signer, long signer_provider, long fee_estimator, long chain_monitor, long tx_broadcaster, long router, long message_router, long logger, long default_config, long[] channel_monitors);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ C2Tuple_ThirtyTwoBytesChannelManagerZ_read(struct LDKu8slice ser, struct LDKChannelManagerReadArgs arg);
	public static native long C2Tuple_ThirtyTwoBytesChannelManagerZ_read(byte[] ser, long arg);
	// void DelayedPaymentBasepoint_free(struct LDKDelayedPaymentBasepoint this_obj);
	public static native void DelayedPaymentBasepoint_free(long this_obj);
	// struct LDKPublicKey DelayedPaymentBasepoint_get_a(const struct LDKDelayedPaymentBasepoint *NONNULL_PTR this_ptr);
	public static native byte[] DelayedPaymentBasepoint_get_a(long this_ptr);
	// void DelayedPaymentBasepoint_set_a(struct LDKDelayedPaymentBasepoint *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void DelayedPaymentBasepoint_set_a(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKDelayedPaymentBasepoint DelayedPaymentBasepoint_new(struct LDKPublicKey a_arg);
	public static native long DelayedPaymentBasepoint_new(byte[] a_arg);
	// bool DelayedPaymentBasepoint_eq(const struct LDKDelayedPaymentBasepoint *NONNULL_PTR a, const struct LDKDelayedPaymentBasepoint *NONNULL_PTR b);
	public static native boolean DelayedPaymentBasepoint_eq(long a, long b);
	// uint64_t DelayedPaymentBasepoint_clone_ptr(LDKDelayedPaymentBasepoint *NONNULL_PTR arg);
	public static native long DelayedPaymentBasepoint_clone_ptr(long arg);
	// struct LDKDelayedPaymentBasepoint DelayedPaymentBasepoint_clone(const struct LDKDelayedPaymentBasepoint *NONNULL_PTR orig);
	public static native long DelayedPaymentBasepoint_clone(long orig);
	// uint64_t DelayedPaymentBasepoint_hash(const struct LDKDelayedPaymentBasepoint *NONNULL_PTR o);
	public static native long DelayedPaymentBasepoint_hash(long o);
	// MUST_USE_RES struct LDKPublicKey DelayedPaymentBasepoint_to_public_key(const struct LDKDelayedPaymentBasepoint *NONNULL_PTR this_arg);
	public static native byte[] DelayedPaymentBasepoint_to_public_key(long this_arg);
	// MUST_USE_RES struct LDKThirtyTwoBytes DelayedPaymentBasepoint_derive_add_tweak(const struct LDKDelayedPaymentBasepoint *NONNULL_PTR this_arg, struct LDKPublicKey per_commitment_point);
	public static native byte[] DelayedPaymentBasepoint_derive_add_tweak(long this_arg, byte[] per_commitment_point);
	// struct LDKCVec_u8Z DelayedPaymentBasepoint_write(const struct LDKDelayedPaymentBasepoint *NONNULL_PTR obj);
	public static native byte[] DelayedPaymentBasepoint_write(long obj);
	// struct LDKCResult_DelayedPaymentBasepointDecodeErrorZ DelayedPaymentBasepoint_read(struct LDKu8slice ser);
	public static native long DelayedPaymentBasepoint_read(byte[] ser);
	// void DelayedPaymentKey_free(struct LDKDelayedPaymentKey this_obj);
	public static native void DelayedPaymentKey_free(long this_obj);
	// struct LDKPublicKey DelayedPaymentKey_get_a(const struct LDKDelayedPaymentKey *NONNULL_PTR this_ptr);
	public static native byte[] DelayedPaymentKey_get_a(long this_ptr);
	// void DelayedPaymentKey_set_a(struct LDKDelayedPaymentKey *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void DelayedPaymentKey_set_a(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKDelayedPaymentKey DelayedPaymentKey_new(struct LDKPublicKey a_arg);
	public static native long DelayedPaymentKey_new(byte[] a_arg);
	// bool DelayedPaymentKey_eq(const struct LDKDelayedPaymentKey *NONNULL_PTR a, const struct LDKDelayedPaymentKey *NONNULL_PTR b);
	public static native boolean DelayedPaymentKey_eq(long a, long b);
	// uint64_t DelayedPaymentKey_clone_ptr(LDKDelayedPaymentKey *NONNULL_PTR arg);
	public static native long DelayedPaymentKey_clone_ptr(long arg);
	// struct LDKDelayedPaymentKey DelayedPaymentKey_clone(const struct LDKDelayedPaymentKey *NONNULL_PTR orig);
	public static native long DelayedPaymentKey_clone(long orig);
	// MUST_USE_RES struct LDKDelayedPaymentKey DelayedPaymentKey_from_basepoint(const struct LDKDelayedPaymentBasepoint *NONNULL_PTR countersignatory_basepoint, struct LDKPublicKey per_commitment_point);
	public static native long DelayedPaymentKey_from_basepoint(long countersignatory_basepoint, byte[] per_commitment_point);
	// MUST_USE_RES struct LDKDelayedPaymentKey DelayedPaymentKey_from_secret_key(const uint8_t (*sk)[32]);
	public static native long DelayedPaymentKey_from_secret_key(byte[] sk);
	// MUST_USE_RES struct LDKPublicKey DelayedPaymentKey_to_public_key(const struct LDKDelayedPaymentKey *NONNULL_PTR this_arg);
	public static native byte[] DelayedPaymentKey_to_public_key(long this_arg);
	// struct LDKCVec_u8Z DelayedPaymentKey_write(const struct LDKDelayedPaymentKey *NONNULL_PTR obj);
	public static native byte[] DelayedPaymentKey_write(long obj);
	// struct LDKCResult_DelayedPaymentKeyDecodeErrorZ DelayedPaymentKey_read(struct LDKu8slice ser);
	public static native long DelayedPaymentKey_read(byte[] ser);
	// void HtlcBasepoint_free(struct LDKHtlcBasepoint this_obj);
	public static native void HtlcBasepoint_free(long this_obj);
	// struct LDKPublicKey HtlcBasepoint_get_a(const struct LDKHtlcBasepoint *NONNULL_PTR this_ptr);
	public static native byte[] HtlcBasepoint_get_a(long this_ptr);
	// void HtlcBasepoint_set_a(struct LDKHtlcBasepoint *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void HtlcBasepoint_set_a(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKHtlcBasepoint HtlcBasepoint_new(struct LDKPublicKey a_arg);
	public static native long HtlcBasepoint_new(byte[] a_arg);
	// bool HtlcBasepoint_eq(const struct LDKHtlcBasepoint *NONNULL_PTR a, const struct LDKHtlcBasepoint *NONNULL_PTR b);
	public static native boolean HtlcBasepoint_eq(long a, long b);
	// uint64_t HtlcBasepoint_clone_ptr(LDKHtlcBasepoint *NONNULL_PTR arg);
	public static native long HtlcBasepoint_clone_ptr(long arg);
	// struct LDKHtlcBasepoint HtlcBasepoint_clone(const struct LDKHtlcBasepoint *NONNULL_PTR orig);
	public static native long HtlcBasepoint_clone(long orig);
	// uint64_t HtlcBasepoint_hash(const struct LDKHtlcBasepoint *NONNULL_PTR o);
	public static native long HtlcBasepoint_hash(long o);
	// MUST_USE_RES struct LDKPublicKey HtlcBasepoint_to_public_key(const struct LDKHtlcBasepoint *NONNULL_PTR this_arg);
	public static native byte[] HtlcBasepoint_to_public_key(long this_arg);
	// MUST_USE_RES struct LDKThirtyTwoBytes HtlcBasepoint_derive_add_tweak(const struct LDKHtlcBasepoint *NONNULL_PTR this_arg, struct LDKPublicKey per_commitment_point);
	public static native byte[] HtlcBasepoint_derive_add_tweak(long this_arg, byte[] per_commitment_point);
	// struct LDKCVec_u8Z HtlcBasepoint_write(const struct LDKHtlcBasepoint *NONNULL_PTR obj);
	public static native byte[] HtlcBasepoint_write(long obj);
	// struct LDKCResult_HtlcBasepointDecodeErrorZ HtlcBasepoint_read(struct LDKu8slice ser);
	public static native long HtlcBasepoint_read(byte[] ser);
	// void HtlcKey_free(struct LDKHtlcKey this_obj);
	public static native void HtlcKey_free(long this_obj);
	// struct LDKPublicKey HtlcKey_get_a(const struct LDKHtlcKey *NONNULL_PTR this_ptr);
	public static native byte[] HtlcKey_get_a(long this_ptr);
	// void HtlcKey_set_a(struct LDKHtlcKey *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void HtlcKey_set_a(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKHtlcKey HtlcKey_new(struct LDKPublicKey a_arg);
	public static native long HtlcKey_new(byte[] a_arg);
	// bool HtlcKey_eq(const struct LDKHtlcKey *NONNULL_PTR a, const struct LDKHtlcKey *NONNULL_PTR b);
	public static native boolean HtlcKey_eq(long a, long b);
	// uint64_t HtlcKey_clone_ptr(LDKHtlcKey *NONNULL_PTR arg);
	public static native long HtlcKey_clone_ptr(long arg);
	// struct LDKHtlcKey HtlcKey_clone(const struct LDKHtlcKey *NONNULL_PTR orig);
	public static native long HtlcKey_clone(long orig);
	// MUST_USE_RES struct LDKHtlcKey HtlcKey_from_basepoint(const struct LDKHtlcBasepoint *NONNULL_PTR countersignatory_basepoint, struct LDKPublicKey per_commitment_point);
	public static native long HtlcKey_from_basepoint(long countersignatory_basepoint, byte[] per_commitment_point);
	// MUST_USE_RES struct LDKHtlcKey HtlcKey_from_secret_key(const uint8_t (*sk)[32]);
	public static native long HtlcKey_from_secret_key(byte[] sk);
	// MUST_USE_RES struct LDKPublicKey HtlcKey_to_public_key(const struct LDKHtlcKey *NONNULL_PTR this_arg);
	public static native byte[] HtlcKey_to_public_key(long this_arg);
	// struct LDKCVec_u8Z HtlcKey_write(const struct LDKHtlcKey *NONNULL_PTR obj);
	public static native byte[] HtlcKey_write(long obj);
	// struct LDKCResult_HtlcKeyDecodeErrorZ HtlcKey_read(struct LDKu8slice ser);
	public static native long HtlcKey_read(byte[] ser);
	// struct LDKPublicKey add_public_key_tweak(struct LDKPublicKey base_point, const uint8_t (*tweak)[32]);
	public static native byte[] add_public_key_tweak(byte[] base_point, byte[] tweak);
	// void RevocationBasepoint_free(struct LDKRevocationBasepoint this_obj);
	public static native void RevocationBasepoint_free(long this_obj);
	// struct LDKPublicKey RevocationBasepoint_get_a(const struct LDKRevocationBasepoint *NONNULL_PTR this_ptr);
	public static native byte[] RevocationBasepoint_get_a(long this_ptr);
	// void RevocationBasepoint_set_a(struct LDKRevocationBasepoint *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void RevocationBasepoint_set_a(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKRevocationBasepoint RevocationBasepoint_new(struct LDKPublicKey a_arg);
	public static native long RevocationBasepoint_new(byte[] a_arg);
	// bool RevocationBasepoint_eq(const struct LDKRevocationBasepoint *NONNULL_PTR a, const struct LDKRevocationBasepoint *NONNULL_PTR b);
	public static native boolean RevocationBasepoint_eq(long a, long b);
	// uint64_t RevocationBasepoint_clone_ptr(LDKRevocationBasepoint *NONNULL_PTR arg);
	public static native long RevocationBasepoint_clone_ptr(long arg);
	// struct LDKRevocationBasepoint RevocationBasepoint_clone(const struct LDKRevocationBasepoint *NONNULL_PTR orig);
	public static native long RevocationBasepoint_clone(long orig);
	// uint64_t RevocationBasepoint_hash(const struct LDKRevocationBasepoint *NONNULL_PTR o);
	public static native long RevocationBasepoint_hash(long o);
	// MUST_USE_RES struct LDKPublicKey RevocationBasepoint_to_public_key(const struct LDKRevocationBasepoint *NONNULL_PTR this_arg);
	public static native byte[] RevocationBasepoint_to_public_key(long this_arg);
	// struct LDKCVec_u8Z RevocationBasepoint_write(const struct LDKRevocationBasepoint *NONNULL_PTR obj);
	public static native byte[] RevocationBasepoint_write(long obj);
	// struct LDKCResult_RevocationBasepointDecodeErrorZ RevocationBasepoint_read(struct LDKu8slice ser);
	public static native long RevocationBasepoint_read(byte[] ser);
	// void RevocationKey_free(struct LDKRevocationKey this_obj);
	public static native void RevocationKey_free(long this_obj);
	// struct LDKPublicKey RevocationKey_get_a(const struct LDKRevocationKey *NONNULL_PTR this_ptr);
	public static native byte[] RevocationKey_get_a(long this_ptr);
	// void RevocationKey_set_a(struct LDKRevocationKey *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void RevocationKey_set_a(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKRevocationKey RevocationKey_new(struct LDKPublicKey a_arg);
	public static native long RevocationKey_new(byte[] a_arg);
	// bool RevocationKey_eq(const struct LDKRevocationKey *NONNULL_PTR a, const struct LDKRevocationKey *NONNULL_PTR b);
	public static native boolean RevocationKey_eq(long a, long b);
	// uint64_t RevocationKey_clone_ptr(LDKRevocationKey *NONNULL_PTR arg);
	public static native long RevocationKey_clone_ptr(long arg);
	// struct LDKRevocationKey RevocationKey_clone(const struct LDKRevocationKey *NONNULL_PTR orig);
	public static native long RevocationKey_clone(long orig);
	// uint64_t RevocationKey_hash(const struct LDKRevocationKey *NONNULL_PTR o);
	public static native long RevocationKey_hash(long o);
	// MUST_USE_RES struct LDKRevocationKey RevocationKey_from_basepoint(const struct LDKRevocationBasepoint *NONNULL_PTR countersignatory_basepoint, struct LDKPublicKey per_commitment_point);
	public static native long RevocationKey_from_basepoint(long countersignatory_basepoint, byte[] per_commitment_point);
	// MUST_USE_RES struct LDKPublicKey RevocationKey_to_public_key(const struct LDKRevocationKey *NONNULL_PTR this_arg);
	public static native byte[] RevocationKey_to_public_key(long this_arg);
	// struct LDKCVec_u8Z RevocationKey_write(const struct LDKRevocationKey *NONNULL_PTR obj);
	public static native byte[] RevocationKey_write(long obj);
	// struct LDKCResult_RevocationKeyDecodeErrorZ RevocationKey_read(struct LDKu8slice ser);
	public static native long RevocationKey_read(byte[] ser);
	// enum LDKInboundHTLCStateDetails InboundHTLCStateDetails_clone(const enum LDKInboundHTLCStateDetails *NONNULL_PTR orig);
	public static native InboundHTLCStateDetails InboundHTLCStateDetails_clone(long orig);
	// enum LDKInboundHTLCStateDetails InboundHTLCStateDetails_awaiting_remote_revoke_to_add(void);
	public static native InboundHTLCStateDetails InboundHTLCStateDetails_awaiting_remote_revoke_to_add();
	// enum LDKInboundHTLCStateDetails InboundHTLCStateDetails_committed(void);
	public static native InboundHTLCStateDetails InboundHTLCStateDetails_committed();
	// enum LDKInboundHTLCStateDetails InboundHTLCStateDetails_awaiting_remote_revoke_to_remove_fulfill(void);
	public static native InboundHTLCStateDetails InboundHTLCStateDetails_awaiting_remote_revoke_to_remove_fulfill();
	// enum LDKInboundHTLCStateDetails InboundHTLCStateDetails_awaiting_remote_revoke_to_remove_fail(void);
	public static native InboundHTLCStateDetails InboundHTLCStateDetails_awaiting_remote_revoke_to_remove_fail();
	// struct LDKCVec_u8Z InboundHTLCStateDetails_write(const enum LDKInboundHTLCStateDetails *NONNULL_PTR obj);
	public static native byte[] InboundHTLCStateDetails_write(long obj);
	// struct LDKCResult_COption_InboundHTLCStateDetailsZDecodeErrorZ InboundHTLCStateDetails_read(struct LDKu8slice ser);
	public static native long InboundHTLCStateDetails_read(byte[] ser);
	// void InboundHTLCDetails_free(struct LDKInboundHTLCDetails this_obj);
	public static native void InboundHTLCDetails_free(long this_obj);
	// uint64_t InboundHTLCDetails_get_htlc_id(const struct LDKInboundHTLCDetails *NONNULL_PTR this_ptr);
	public static native long InboundHTLCDetails_get_htlc_id(long this_ptr);
	// void InboundHTLCDetails_set_htlc_id(struct LDKInboundHTLCDetails *NONNULL_PTR this_ptr, uint64_t val);
	public static native void InboundHTLCDetails_set_htlc_id(long this_ptr, long val);
	// uint64_t InboundHTLCDetails_get_amount_msat(const struct LDKInboundHTLCDetails *NONNULL_PTR this_ptr);
	public static native long InboundHTLCDetails_get_amount_msat(long this_ptr);
	// void InboundHTLCDetails_set_amount_msat(struct LDKInboundHTLCDetails *NONNULL_PTR this_ptr, uint64_t val);
	public static native void InboundHTLCDetails_set_amount_msat(long this_ptr, long val);
	// uint32_t InboundHTLCDetails_get_cltv_expiry(const struct LDKInboundHTLCDetails *NONNULL_PTR this_ptr);
	public static native int InboundHTLCDetails_get_cltv_expiry(long this_ptr);
	// void InboundHTLCDetails_set_cltv_expiry(struct LDKInboundHTLCDetails *NONNULL_PTR this_ptr, uint32_t val);
	public static native void InboundHTLCDetails_set_cltv_expiry(long this_ptr, int val);
	// const uint8_t (*InboundHTLCDetails_get_payment_hash(const struct LDKInboundHTLCDetails *NONNULL_PTR this_ptr))[32];
	public static native byte[] InboundHTLCDetails_get_payment_hash(long this_ptr);
	// void InboundHTLCDetails_set_payment_hash(struct LDKInboundHTLCDetails *NONNULL_PTR this_ptr, struct LDKThirtyTwoBytes val);
	public static native void InboundHTLCDetails_set_payment_hash(long this_ptr, byte[] val);
	// struct LDKCOption_InboundHTLCStateDetailsZ InboundHTLCDetails_get_state(const struct LDKInboundHTLCDetails *NONNULL_PTR this_ptr);
	public static native long InboundHTLCDetails_get_state(long this_ptr);
	// void InboundHTLCDetails_set_state(struct LDKInboundHTLCDetails *NONNULL_PTR this_ptr, struct LDKCOption_InboundHTLCStateDetailsZ val);
	public static native void InboundHTLCDetails_set_state(long this_ptr, long val);
	// bool InboundHTLCDetails_get_is_dust(const struct LDKInboundHTLCDetails *NONNULL_PTR this_ptr);
	public static native boolean InboundHTLCDetails_get_is_dust(long this_ptr);
	// void InboundHTLCDetails_set_is_dust(struct LDKInboundHTLCDetails *NONNULL_PTR this_ptr, bool val);
	public static native void InboundHTLCDetails_set_is_dust(long this_ptr, boolean val);
	// MUST_USE_RES struct LDKInboundHTLCDetails InboundHTLCDetails_new(uint64_t htlc_id_arg, uint64_t amount_msat_arg, uint32_t cltv_expiry_arg, struct LDKThirtyTwoBytes payment_hash_arg, struct LDKCOption_InboundHTLCStateDetailsZ state_arg, bool is_dust_arg);
	public static native long InboundHTLCDetails_new(long htlc_id_arg, long amount_msat_arg, int cltv_expiry_arg, byte[] payment_hash_arg, long state_arg, boolean is_dust_arg);
	// uint64_t InboundHTLCDetails_clone_ptr(LDKInboundHTLCDetails *NONNULL_PTR arg);
	public static native long InboundHTLCDetails_clone_ptr(long arg);
	// struct LDKInboundHTLCDetails InboundHTLCDetails_clone(const struct LDKInboundHTLCDetails *NONNULL_PTR orig);
	public static native long InboundHTLCDetails_clone(long orig);
	// struct LDKCVec_u8Z InboundHTLCDetails_write(const struct LDKInboundHTLCDetails *NONNULL_PTR obj);
	public static native byte[] InboundHTLCDetails_write(long obj);
	// struct LDKCResult_InboundHTLCDetailsDecodeErrorZ InboundHTLCDetails_read(struct LDKu8slice ser);
	public static native long InboundHTLCDetails_read(byte[] ser);
	// enum LDKOutboundHTLCStateDetails OutboundHTLCStateDetails_clone(const enum LDKOutboundHTLCStateDetails *NONNULL_PTR orig);
	public static native OutboundHTLCStateDetails OutboundHTLCStateDetails_clone(long orig);
	// enum LDKOutboundHTLCStateDetails OutboundHTLCStateDetails_awaiting_remote_revoke_to_add(void);
	public static native OutboundHTLCStateDetails OutboundHTLCStateDetails_awaiting_remote_revoke_to_add();
	// enum LDKOutboundHTLCStateDetails OutboundHTLCStateDetails_committed(void);
	public static native OutboundHTLCStateDetails OutboundHTLCStateDetails_committed();
	// enum LDKOutboundHTLCStateDetails OutboundHTLCStateDetails_awaiting_remote_revoke_to_remove_success(void);
	public static native OutboundHTLCStateDetails OutboundHTLCStateDetails_awaiting_remote_revoke_to_remove_success();
	// enum LDKOutboundHTLCStateDetails OutboundHTLCStateDetails_awaiting_remote_revoke_to_remove_failure(void);
	public static native OutboundHTLCStateDetails OutboundHTLCStateDetails_awaiting_remote_revoke_to_remove_failure();
	// struct LDKCVec_u8Z OutboundHTLCStateDetails_write(const enum LDKOutboundHTLCStateDetails *NONNULL_PTR obj);
	public static native byte[] OutboundHTLCStateDetails_write(long obj);
	// struct LDKCResult_COption_OutboundHTLCStateDetailsZDecodeErrorZ OutboundHTLCStateDetails_read(struct LDKu8slice ser);
	public static native long OutboundHTLCStateDetails_read(byte[] ser);
	// void OutboundHTLCDetails_free(struct LDKOutboundHTLCDetails this_obj);
	public static native void OutboundHTLCDetails_free(long this_obj);
	// struct LDKCOption_u64Z OutboundHTLCDetails_get_htlc_id(const struct LDKOutboundHTLCDetails *NONNULL_PTR this_ptr);
	public static native long OutboundHTLCDetails_get_htlc_id(long this_ptr);
	// void OutboundHTLCDetails_set_htlc_id(struct LDKOutboundHTLCDetails *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void OutboundHTLCDetails_set_htlc_id(long this_ptr, long val);
	// uint64_t OutboundHTLCDetails_get_amount_msat(const struct LDKOutboundHTLCDetails *NONNULL_PTR this_ptr);
	public static native long OutboundHTLCDetails_get_amount_msat(long this_ptr);
	// void OutboundHTLCDetails_set_amount_msat(struct LDKOutboundHTLCDetails *NONNULL_PTR this_ptr, uint64_t val);
	public static native void OutboundHTLCDetails_set_amount_msat(long this_ptr, long val);
	// uint32_t OutboundHTLCDetails_get_cltv_expiry(const struct LDKOutboundHTLCDetails *NONNULL_PTR this_ptr);
	public static native int OutboundHTLCDetails_get_cltv_expiry(long this_ptr);
	// void OutboundHTLCDetails_set_cltv_expiry(struct LDKOutboundHTLCDetails *NONNULL_PTR this_ptr, uint32_t val);
	public static native void OutboundHTLCDetails_set_cltv_expiry(long this_ptr, int val);
	// const uint8_t (*OutboundHTLCDetails_get_payment_hash(const struct LDKOutboundHTLCDetails *NONNULL_PTR this_ptr))[32];
	public static native byte[] OutboundHTLCDetails_get_payment_hash(long this_ptr);
	// void OutboundHTLCDetails_set_payment_hash(struct LDKOutboundHTLCDetails *NONNULL_PTR this_ptr, struct LDKThirtyTwoBytes val);
	public static native void OutboundHTLCDetails_set_payment_hash(long this_ptr, byte[] val);
	// struct LDKCOption_OutboundHTLCStateDetailsZ OutboundHTLCDetails_get_state(const struct LDKOutboundHTLCDetails *NONNULL_PTR this_ptr);
	public static native long OutboundHTLCDetails_get_state(long this_ptr);
	// void OutboundHTLCDetails_set_state(struct LDKOutboundHTLCDetails *NONNULL_PTR this_ptr, struct LDKCOption_OutboundHTLCStateDetailsZ val);
	public static native void OutboundHTLCDetails_set_state(long this_ptr, long val);
	// struct LDKCOption_u64Z OutboundHTLCDetails_get_skimmed_fee_msat(const struct LDKOutboundHTLCDetails *NONNULL_PTR this_ptr);
	public static native long OutboundHTLCDetails_get_skimmed_fee_msat(long this_ptr);
	// void OutboundHTLCDetails_set_skimmed_fee_msat(struct LDKOutboundHTLCDetails *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void OutboundHTLCDetails_set_skimmed_fee_msat(long this_ptr, long val);
	// bool OutboundHTLCDetails_get_is_dust(const struct LDKOutboundHTLCDetails *NONNULL_PTR this_ptr);
	public static native boolean OutboundHTLCDetails_get_is_dust(long this_ptr);
	// void OutboundHTLCDetails_set_is_dust(struct LDKOutboundHTLCDetails *NONNULL_PTR this_ptr, bool val);
	public static native void OutboundHTLCDetails_set_is_dust(long this_ptr, boolean val);
	// MUST_USE_RES struct LDKOutboundHTLCDetails OutboundHTLCDetails_new(struct LDKCOption_u64Z htlc_id_arg, uint64_t amount_msat_arg, uint32_t cltv_expiry_arg, struct LDKThirtyTwoBytes payment_hash_arg, struct LDKCOption_OutboundHTLCStateDetailsZ state_arg, struct LDKCOption_u64Z skimmed_fee_msat_arg, bool is_dust_arg);
	public static native long OutboundHTLCDetails_new(long htlc_id_arg, long amount_msat_arg, int cltv_expiry_arg, byte[] payment_hash_arg, long state_arg, long skimmed_fee_msat_arg, boolean is_dust_arg);
	// uint64_t OutboundHTLCDetails_clone_ptr(LDKOutboundHTLCDetails *NONNULL_PTR arg);
	public static native long OutboundHTLCDetails_clone_ptr(long arg);
	// struct LDKOutboundHTLCDetails OutboundHTLCDetails_clone(const struct LDKOutboundHTLCDetails *NONNULL_PTR orig);
	public static native long OutboundHTLCDetails_clone(long orig);
	// struct LDKCVec_u8Z OutboundHTLCDetails_write(const struct LDKOutboundHTLCDetails *NONNULL_PTR obj);
	public static native byte[] OutboundHTLCDetails_write(long obj);
	// struct LDKCResult_OutboundHTLCDetailsDecodeErrorZ OutboundHTLCDetails_read(struct LDKu8slice ser);
	public static native long OutboundHTLCDetails_read(byte[] ser);
	// void CounterpartyForwardingInfo_free(struct LDKCounterpartyForwardingInfo this_obj);
	public static native void CounterpartyForwardingInfo_free(long this_obj);
	// uint32_t CounterpartyForwardingInfo_get_fee_base_msat(const struct LDKCounterpartyForwardingInfo *NONNULL_PTR this_ptr);
	public static native int CounterpartyForwardingInfo_get_fee_base_msat(long this_ptr);
	// void CounterpartyForwardingInfo_set_fee_base_msat(struct LDKCounterpartyForwardingInfo *NONNULL_PTR this_ptr, uint32_t val);
	public static native void CounterpartyForwardingInfo_set_fee_base_msat(long this_ptr, int val);
	// uint32_t CounterpartyForwardingInfo_get_fee_proportional_millionths(const struct LDKCounterpartyForwardingInfo *NONNULL_PTR this_ptr);
	public static native int CounterpartyForwardingInfo_get_fee_proportional_millionths(long this_ptr);
	// void CounterpartyForwardingInfo_set_fee_proportional_millionths(struct LDKCounterpartyForwardingInfo *NONNULL_PTR this_ptr, uint32_t val);
	public static native void CounterpartyForwardingInfo_set_fee_proportional_millionths(long this_ptr, int val);
	// uint16_t CounterpartyForwardingInfo_get_cltv_expiry_delta(const struct LDKCounterpartyForwardingInfo *NONNULL_PTR this_ptr);
	public static native short CounterpartyForwardingInfo_get_cltv_expiry_delta(long this_ptr);
	// void CounterpartyForwardingInfo_set_cltv_expiry_delta(struct LDKCounterpartyForwardingInfo *NONNULL_PTR this_ptr, uint16_t val);
	public static native void CounterpartyForwardingInfo_set_cltv_expiry_delta(long this_ptr, short val);
	// MUST_USE_RES struct LDKCounterpartyForwardingInfo CounterpartyForwardingInfo_new(uint32_t fee_base_msat_arg, uint32_t fee_proportional_millionths_arg, uint16_t cltv_expiry_delta_arg);
	public static native long CounterpartyForwardingInfo_new(int fee_base_msat_arg, int fee_proportional_millionths_arg, short cltv_expiry_delta_arg);
	// uint64_t CounterpartyForwardingInfo_clone_ptr(LDKCounterpartyForwardingInfo *NONNULL_PTR arg);
	public static native long CounterpartyForwardingInfo_clone_ptr(long arg);
	// struct LDKCounterpartyForwardingInfo CounterpartyForwardingInfo_clone(const struct LDKCounterpartyForwardingInfo *NONNULL_PTR orig);
	public static native long CounterpartyForwardingInfo_clone(long orig);
	// struct LDKCVec_u8Z CounterpartyForwardingInfo_write(const struct LDKCounterpartyForwardingInfo *NONNULL_PTR obj);
	public static native byte[] CounterpartyForwardingInfo_write(long obj);
	// struct LDKCResult_CounterpartyForwardingInfoDecodeErrorZ CounterpartyForwardingInfo_read(struct LDKu8slice ser);
	public static native long CounterpartyForwardingInfo_read(byte[] ser);
	// void ChannelCounterparty_free(struct LDKChannelCounterparty this_obj);
	public static native void ChannelCounterparty_free(long this_obj);
	// struct LDKPublicKey ChannelCounterparty_get_node_id(const struct LDKChannelCounterparty *NONNULL_PTR this_ptr);
	public static native byte[] ChannelCounterparty_get_node_id(long this_ptr);
	// void ChannelCounterparty_set_node_id(struct LDKChannelCounterparty *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void ChannelCounterparty_set_node_id(long this_ptr, byte[] val);
	// struct LDKInitFeatures ChannelCounterparty_get_features(const struct LDKChannelCounterparty *NONNULL_PTR this_ptr);
	public static native long ChannelCounterparty_get_features(long this_ptr);
	// void ChannelCounterparty_set_features(struct LDKChannelCounterparty *NONNULL_PTR this_ptr, struct LDKInitFeatures val);
	public static native void ChannelCounterparty_set_features(long this_ptr, long val);
	// uint64_t ChannelCounterparty_get_unspendable_punishment_reserve(const struct LDKChannelCounterparty *NONNULL_PTR this_ptr);
	public static native long ChannelCounterparty_get_unspendable_punishment_reserve(long this_ptr);
	// void ChannelCounterparty_set_unspendable_punishment_reserve(struct LDKChannelCounterparty *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelCounterparty_set_unspendable_punishment_reserve(long this_ptr, long val);
	// struct LDKCounterpartyForwardingInfo ChannelCounterparty_get_forwarding_info(const struct LDKChannelCounterparty *NONNULL_PTR this_ptr);
	public static native long ChannelCounterparty_get_forwarding_info(long this_ptr);
	// void ChannelCounterparty_set_forwarding_info(struct LDKChannelCounterparty *NONNULL_PTR this_ptr, struct LDKCounterpartyForwardingInfo val);
	public static native void ChannelCounterparty_set_forwarding_info(long this_ptr, long val);
	// struct LDKCOption_u64Z ChannelCounterparty_get_outbound_htlc_minimum_msat(const struct LDKChannelCounterparty *NONNULL_PTR this_ptr);
	public static native long ChannelCounterparty_get_outbound_htlc_minimum_msat(long this_ptr);
	// void ChannelCounterparty_set_outbound_htlc_minimum_msat(struct LDKChannelCounterparty *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void ChannelCounterparty_set_outbound_htlc_minimum_msat(long this_ptr, long val);
	// struct LDKCOption_u64Z ChannelCounterparty_get_outbound_htlc_maximum_msat(const struct LDKChannelCounterparty *NONNULL_PTR this_ptr);
	public static native long ChannelCounterparty_get_outbound_htlc_maximum_msat(long this_ptr);
	// void ChannelCounterparty_set_outbound_htlc_maximum_msat(struct LDKChannelCounterparty *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void ChannelCounterparty_set_outbound_htlc_maximum_msat(long this_ptr, long val);
	// MUST_USE_RES struct LDKChannelCounterparty ChannelCounterparty_new(struct LDKPublicKey node_id_arg, struct LDKInitFeatures features_arg, uint64_t unspendable_punishment_reserve_arg, struct LDKCounterpartyForwardingInfo forwarding_info_arg, struct LDKCOption_u64Z outbound_htlc_minimum_msat_arg, struct LDKCOption_u64Z outbound_htlc_maximum_msat_arg);
	public static native long ChannelCounterparty_new(byte[] node_id_arg, long features_arg, long unspendable_punishment_reserve_arg, long forwarding_info_arg, long outbound_htlc_minimum_msat_arg, long outbound_htlc_maximum_msat_arg);
	// uint64_t ChannelCounterparty_clone_ptr(LDKChannelCounterparty *NONNULL_PTR arg);
	public static native long ChannelCounterparty_clone_ptr(long arg);
	// struct LDKChannelCounterparty ChannelCounterparty_clone(const struct LDKChannelCounterparty *NONNULL_PTR orig);
	public static native long ChannelCounterparty_clone(long orig);
	// struct LDKCVec_u8Z ChannelCounterparty_write(const struct LDKChannelCounterparty *NONNULL_PTR obj);
	public static native byte[] ChannelCounterparty_write(long obj);
	// struct LDKCResult_ChannelCounterpartyDecodeErrorZ ChannelCounterparty_read(struct LDKu8slice ser);
	public static native long ChannelCounterparty_read(byte[] ser);
	// void ChannelDetails_free(struct LDKChannelDetails this_obj);
	public static native void ChannelDetails_free(long this_obj);
	// struct LDKChannelId ChannelDetails_get_channel_id(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_channel_id(long this_ptr);
	// void ChannelDetails_set_channel_id(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void ChannelDetails_set_channel_id(long this_ptr, long val);
	// struct LDKChannelCounterparty ChannelDetails_get_counterparty(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_counterparty(long this_ptr);
	// void ChannelDetails_set_counterparty(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKChannelCounterparty val);
	public static native void ChannelDetails_set_counterparty(long this_ptr, long val);
	// struct LDKOutPoint ChannelDetails_get_funding_txo(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_funding_txo(long this_ptr);
	// void ChannelDetails_set_funding_txo(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKOutPoint val);
	public static native void ChannelDetails_set_funding_txo(long this_ptr, long val);
	// struct LDKChannelTypeFeatures ChannelDetails_get_channel_type(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_channel_type(long this_ptr);
	// void ChannelDetails_set_channel_type(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKChannelTypeFeatures val);
	public static native void ChannelDetails_set_channel_type(long this_ptr, long val);
	// struct LDKCOption_u64Z ChannelDetails_get_short_channel_id(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_short_channel_id(long this_ptr);
	// void ChannelDetails_set_short_channel_id(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void ChannelDetails_set_short_channel_id(long this_ptr, long val);
	// struct LDKCOption_u64Z ChannelDetails_get_outbound_scid_alias(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_outbound_scid_alias(long this_ptr);
	// void ChannelDetails_set_outbound_scid_alias(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void ChannelDetails_set_outbound_scid_alias(long this_ptr, long val);
	// struct LDKCOption_u64Z ChannelDetails_get_inbound_scid_alias(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_inbound_scid_alias(long this_ptr);
	// void ChannelDetails_set_inbound_scid_alias(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void ChannelDetails_set_inbound_scid_alias(long this_ptr, long val);
	// uint64_t ChannelDetails_get_channel_value_satoshis(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_channel_value_satoshis(long this_ptr);
	// void ChannelDetails_set_channel_value_satoshis(struct LDKChannelDetails *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelDetails_set_channel_value_satoshis(long this_ptr, long val);
	// struct LDKCOption_u64Z ChannelDetails_get_unspendable_punishment_reserve(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_unspendable_punishment_reserve(long this_ptr);
	// void ChannelDetails_set_unspendable_punishment_reserve(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void ChannelDetails_set_unspendable_punishment_reserve(long this_ptr, long val);
	// struct LDKU128 ChannelDetails_get_user_channel_id(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native byte[] ChannelDetails_get_user_channel_id(long this_ptr);
	// void ChannelDetails_set_user_channel_id(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKU128 val);
	public static native void ChannelDetails_set_user_channel_id(long this_ptr, byte[] val);
	// struct LDKCOption_u32Z ChannelDetails_get_feerate_sat_per_1000_weight(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_feerate_sat_per_1000_weight(long this_ptr);
	// void ChannelDetails_set_feerate_sat_per_1000_weight(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKCOption_u32Z val);
	public static native void ChannelDetails_set_feerate_sat_per_1000_weight(long this_ptr, long val);
	// uint64_t ChannelDetails_get_outbound_capacity_msat(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_outbound_capacity_msat(long this_ptr);
	// void ChannelDetails_set_outbound_capacity_msat(struct LDKChannelDetails *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelDetails_set_outbound_capacity_msat(long this_ptr, long val);
	// uint64_t ChannelDetails_get_next_outbound_htlc_limit_msat(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_next_outbound_htlc_limit_msat(long this_ptr);
	// void ChannelDetails_set_next_outbound_htlc_limit_msat(struct LDKChannelDetails *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelDetails_set_next_outbound_htlc_limit_msat(long this_ptr, long val);
	// uint64_t ChannelDetails_get_next_outbound_htlc_minimum_msat(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_next_outbound_htlc_minimum_msat(long this_ptr);
	// void ChannelDetails_set_next_outbound_htlc_minimum_msat(struct LDKChannelDetails *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelDetails_set_next_outbound_htlc_minimum_msat(long this_ptr, long val);
	// uint64_t ChannelDetails_get_inbound_capacity_msat(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_inbound_capacity_msat(long this_ptr);
	// void ChannelDetails_set_inbound_capacity_msat(struct LDKChannelDetails *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelDetails_set_inbound_capacity_msat(long this_ptr, long val);
	// struct LDKCOption_u32Z ChannelDetails_get_confirmations_required(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_confirmations_required(long this_ptr);
	// void ChannelDetails_set_confirmations_required(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKCOption_u32Z val);
	public static native void ChannelDetails_set_confirmations_required(long this_ptr, long val);
	// struct LDKCOption_u32Z ChannelDetails_get_confirmations(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_confirmations(long this_ptr);
	// void ChannelDetails_set_confirmations(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKCOption_u32Z val);
	public static native void ChannelDetails_set_confirmations(long this_ptr, long val);
	// struct LDKCOption_u16Z ChannelDetails_get_force_close_spend_delay(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_force_close_spend_delay(long this_ptr);
	// void ChannelDetails_set_force_close_spend_delay(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKCOption_u16Z val);
	public static native void ChannelDetails_set_force_close_spend_delay(long this_ptr, long val);
	// bool ChannelDetails_get_is_outbound(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native boolean ChannelDetails_get_is_outbound(long this_ptr);
	// void ChannelDetails_set_is_outbound(struct LDKChannelDetails *NONNULL_PTR this_ptr, bool val);
	public static native void ChannelDetails_set_is_outbound(long this_ptr, boolean val);
	// bool ChannelDetails_get_is_channel_ready(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native boolean ChannelDetails_get_is_channel_ready(long this_ptr);
	// void ChannelDetails_set_is_channel_ready(struct LDKChannelDetails *NONNULL_PTR this_ptr, bool val);
	public static native void ChannelDetails_set_is_channel_ready(long this_ptr, boolean val);
	// struct LDKCOption_ChannelShutdownStateZ ChannelDetails_get_channel_shutdown_state(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_channel_shutdown_state(long this_ptr);
	// void ChannelDetails_set_channel_shutdown_state(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKCOption_ChannelShutdownStateZ val);
	public static native void ChannelDetails_set_channel_shutdown_state(long this_ptr, long val);
	// bool ChannelDetails_get_is_usable(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native boolean ChannelDetails_get_is_usable(long this_ptr);
	// void ChannelDetails_set_is_usable(struct LDKChannelDetails *NONNULL_PTR this_ptr, bool val);
	public static native void ChannelDetails_set_is_usable(long this_ptr, boolean val);
	// bool ChannelDetails_get_is_announced(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native boolean ChannelDetails_get_is_announced(long this_ptr);
	// void ChannelDetails_set_is_announced(struct LDKChannelDetails *NONNULL_PTR this_ptr, bool val);
	public static native void ChannelDetails_set_is_announced(long this_ptr, boolean val);
	// struct LDKCOption_u64Z ChannelDetails_get_inbound_htlc_minimum_msat(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_inbound_htlc_minimum_msat(long this_ptr);
	// void ChannelDetails_set_inbound_htlc_minimum_msat(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void ChannelDetails_set_inbound_htlc_minimum_msat(long this_ptr, long val);
	// struct LDKCOption_u64Z ChannelDetails_get_inbound_htlc_maximum_msat(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_inbound_htlc_maximum_msat(long this_ptr);
	// void ChannelDetails_set_inbound_htlc_maximum_msat(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void ChannelDetails_set_inbound_htlc_maximum_msat(long this_ptr, long val);
	// struct LDKChannelConfig ChannelDetails_get_config(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long ChannelDetails_get_config(long this_ptr);
	// void ChannelDetails_set_config(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKChannelConfig val);
	public static native void ChannelDetails_set_config(long this_ptr, long val);
	// struct LDKCVec_InboundHTLCDetailsZ ChannelDetails_get_pending_inbound_htlcs(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long[] ChannelDetails_get_pending_inbound_htlcs(long this_ptr);
	// void ChannelDetails_set_pending_inbound_htlcs(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKCVec_InboundHTLCDetailsZ val);
	public static native void ChannelDetails_set_pending_inbound_htlcs(long this_ptr, long[] val);
	// struct LDKCVec_OutboundHTLCDetailsZ ChannelDetails_get_pending_outbound_htlcs(const struct LDKChannelDetails *NONNULL_PTR this_ptr);
	public static native long[] ChannelDetails_get_pending_outbound_htlcs(long this_ptr);
	// void ChannelDetails_set_pending_outbound_htlcs(struct LDKChannelDetails *NONNULL_PTR this_ptr, struct LDKCVec_OutboundHTLCDetailsZ val);
	public static native void ChannelDetails_set_pending_outbound_htlcs(long this_ptr, long[] val);
	// MUST_USE_RES struct LDKChannelDetails ChannelDetails_new(struct LDKChannelId channel_id_arg, struct LDKChannelCounterparty counterparty_arg, struct LDKOutPoint funding_txo_arg, struct LDKChannelTypeFeatures channel_type_arg, struct LDKCOption_u64Z short_channel_id_arg, struct LDKCOption_u64Z outbound_scid_alias_arg, struct LDKCOption_u64Z inbound_scid_alias_arg, uint64_t channel_value_satoshis_arg, struct LDKCOption_u64Z unspendable_punishment_reserve_arg, struct LDKU128 user_channel_id_arg, struct LDKCOption_u32Z feerate_sat_per_1000_weight_arg, uint64_t outbound_capacity_msat_arg, uint64_t next_outbound_htlc_limit_msat_arg, uint64_t next_outbound_htlc_minimum_msat_arg, uint64_t inbound_capacity_msat_arg, struct LDKCOption_u32Z confirmations_required_arg, struct LDKCOption_u32Z confirmations_arg, struct LDKCOption_u16Z force_close_spend_delay_arg, bool is_outbound_arg, bool is_channel_ready_arg, struct LDKCOption_ChannelShutdownStateZ channel_shutdown_state_arg, bool is_usable_arg, bool is_announced_arg, struct LDKCOption_u64Z inbound_htlc_minimum_msat_arg, struct LDKCOption_u64Z inbound_htlc_maximum_msat_arg, struct LDKChannelConfig config_arg, struct LDKCVec_InboundHTLCDetailsZ pending_inbound_htlcs_arg, struct LDKCVec_OutboundHTLCDetailsZ pending_outbound_htlcs_arg);
	public static native long ChannelDetails_new(long channel_id_arg, long counterparty_arg, long funding_txo_arg, long channel_type_arg, long short_channel_id_arg, long outbound_scid_alias_arg, long inbound_scid_alias_arg, long channel_value_satoshis_arg, long unspendable_punishment_reserve_arg, byte[] user_channel_id_arg, long feerate_sat_per_1000_weight_arg, long outbound_capacity_msat_arg, long next_outbound_htlc_limit_msat_arg, long next_outbound_htlc_minimum_msat_arg, long inbound_capacity_msat_arg, long confirmations_required_arg, long confirmations_arg, long force_close_spend_delay_arg, boolean is_outbound_arg, boolean is_channel_ready_arg, long channel_shutdown_state_arg, boolean is_usable_arg, boolean is_announced_arg, long inbound_htlc_minimum_msat_arg, long inbound_htlc_maximum_msat_arg, long config_arg, long[] pending_inbound_htlcs_arg, long[] pending_outbound_htlcs_arg);
	// uint64_t ChannelDetails_clone_ptr(LDKChannelDetails *NONNULL_PTR arg);
	public static native long ChannelDetails_clone_ptr(long arg);
	// struct LDKChannelDetails ChannelDetails_clone(const struct LDKChannelDetails *NONNULL_PTR orig);
	public static native long ChannelDetails_clone(long orig);
	// MUST_USE_RES struct LDKCOption_u64Z ChannelDetails_get_inbound_payment_scid(const struct LDKChannelDetails *NONNULL_PTR this_arg);
	public static native long ChannelDetails_get_inbound_payment_scid(long this_arg);
	// MUST_USE_RES struct LDKCOption_u64Z ChannelDetails_get_outbound_payment_scid(const struct LDKChannelDetails *NONNULL_PTR this_arg);
	public static native long ChannelDetails_get_outbound_payment_scid(long this_arg);
	// struct LDKCVec_u8Z ChannelDetails_write(const struct LDKChannelDetails *NONNULL_PTR obj);
	public static native byte[] ChannelDetails_write(long obj);
	// struct LDKCResult_ChannelDetailsDecodeErrorZ ChannelDetails_read(struct LDKu8slice ser);
	public static native long ChannelDetails_read(byte[] ser);
	// enum LDKChannelShutdownState ChannelShutdownState_clone(const enum LDKChannelShutdownState *NONNULL_PTR orig);
	public static native ChannelShutdownState ChannelShutdownState_clone(long orig);
	// enum LDKChannelShutdownState ChannelShutdownState_not_shutting_down(void);
	public static native ChannelShutdownState ChannelShutdownState_not_shutting_down();
	// enum LDKChannelShutdownState ChannelShutdownState_shutdown_initiated(void);
	public static native ChannelShutdownState ChannelShutdownState_shutdown_initiated();
	// enum LDKChannelShutdownState ChannelShutdownState_resolving_htlcs(void);
	public static native ChannelShutdownState ChannelShutdownState_resolving_htlcs();
	// enum LDKChannelShutdownState ChannelShutdownState_negotiating_closing_fee(void);
	public static native ChannelShutdownState ChannelShutdownState_negotiating_closing_fee();
	// enum LDKChannelShutdownState ChannelShutdownState_shutdown_complete(void);
	public static native ChannelShutdownState ChannelShutdownState_shutdown_complete();
	// bool ChannelShutdownState_eq(const enum LDKChannelShutdownState *NONNULL_PTR a, const enum LDKChannelShutdownState *NONNULL_PTR b);
	public static native boolean ChannelShutdownState_eq(long a, long b);
	// struct LDKCVec_u8Z ChannelShutdownState_write(const enum LDKChannelShutdownState *NONNULL_PTR obj);
	public static native byte[] ChannelShutdownState_write(long obj);
	// struct LDKCResult_ChannelShutdownStateDecodeErrorZ ChannelShutdownState_read(struct LDKu8slice ser);
	public static native long ChannelShutdownState_read(byte[] ser);
	// void ExpandedKey_free(struct LDKExpandedKey this_obj);
	public static native void ExpandedKey_free(long this_obj);
	// uint64_t ExpandedKey_hash(const struct LDKExpandedKey *NONNULL_PTR o);
	public static native long ExpandedKey_hash(long o);
	// uint64_t ExpandedKey_clone_ptr(LDKExpandedKey *NONNULL_PTR arg);
	public static native long ExpandedKey_clone_ptr(long arg);
	// struct LDKExpandedKey ExpandedKey_clone(const struct LDKExpandedKey *NONNULL_PTR orig);
	public static native long ExpandedKey_clone(long orig);
	// bool ExpandedKey_eq(const struct LDKExpandedKey *NONNULL_PTR a, const struct LDKExpandedKey *NONNULL_PTR b);
	public static native boolean ExpandedKey_eq(long a, long b);
	// MUST_USE_RES struct LDKExpandedKey ExpandedKey_new(struct LDKThirtyTwoBytes key_material);
	public static native long ExpandedKey_new(byte[] key_material);
	// struct LDKCResult_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ create(const struct LDKExpandedKey *NONNULL_PTR keys, struct LDKCOption_u64Z min_value_msat, uint32_t invoice_expiry_delta_secs, const struct LDKEntropySource *NONNULL_PTR entropy_source, uint64_t current_time, struct LDKCOption_u16Z min_final_cltv_expiry_delta);
	public static native long create(long keys, long min_value_msat, int invoice_expiry_delta_secs, long entropy_source, long current_time, long min_final_cltv_expiry_delta);
	// struct LDKCResult_ThirtyTwoBytesNoneZ create_from_hash(const struct LDKExpandedKey *NONNULL_PTR keys, struct LDKCOption_u64Z min_value_msat, struct LDKThirtyTwoBytes payment_hash, uint32_t invoice_expiry_delta_secs, uint64_t current_time, struct LDKCOption_u16Z min_final_cltv_expiry_delta);
	public static native long create_from_hash(long keys, long min_value_msat, byte[] payment_hash, int invoice_expiry_delta_secs, long current_time, long min_final_cltv_expiry_delta);
	// void DecodeError_free(struct LDKDecodeError this_ptr);
	public static native void DecodeError_free(long this_ptr);
	// uint64_t DecodeError_clone_ptr(LDKDecodeError *NONNULL_PTR arg);
	public static native long DecodeError_clone_ptr(long arg);
	// struct LDKDecodeError DecodeError_clone(const struct LDKDecodeError *NONNULL_PTR orig);
	public static native long DecodeError_clone(long orig);
	// struct LDKDecodeError DecodeError_unknown_version(void);
	public static native long DecodeError_unknown_version();
	// struct LDKDecodeError DecodeError_unknown_required_feature(void);
	public static native long DecodeError_unknown_required_feature();
	// struct LDKDecodeError DecodeError_invalid_value(void);
	public static native long DecodeError_invalid_value();
	// struct LDKDecodeError DecodeError_short_read(void);
	public static native long DecodeError_short_read();
	// struct LDKDecodeError DecodeError_bad_length_descriptor(void);
	public static native long DecodeError_bad_length_descriptor();
	// struct LDKDecodeError DecodeError_io(enum LDKIOError a);
	public static native long DecodeError_io(IOError a);
	// struct LDKDecodeError DecodeError_unsupported_compression(void);
	public static native long DecodeError_unsupported_compression();
	// struct LDKDecodeError DecodeError_dangerous_value(void);
	public static native long DecodeError_dangerous_value();
	// uint64_t DecodeError_hash(const struct LDKDecodeError *NONNULL_PTR o);
	public static native long DecodeError_hash(long o);
	// bool DecodeError_eq(const struct LDKDecodeError *NONNULL_PTR a, const struct LDKDecodeError *NONNULL_PTR b);
	public static native boolean DecodeError_eq(long a, long b);
	// void Init_free(struct LDKInit this_obj);
	public static native void Init_free(long this_obj);
	// struct LDKInitFeatures Init_get_features(const struct LDKInit *NONNULL_PTR this_ptr);
	public static native long Init_get_features(long this_ptr);
	// void Init_set_features(struct LDKInit *NONNULL_PTR this_ptr, struct LDKInitFeatures val);
	public static native void Init_set_features(long this_ptr, long val);
	// struct LDKCOption_CVec_ThirtyTwoBytesZZ Init_get_networks(const struct LDKInit *NONNULL_PTR this_ptr);
	public static native long Init_get_networks(long this_ptr);
	// void Init_set_networks(struct LDKInit *NONNULL_PTR this_ptr, struct LDKCOption_CVec_ThirtyTwoBytesZZ val);
	public static native void Init_set_networks(long this_ptr, long val);
	// struct LDKCOption_SocketAddressZ Init_get_remote_network_address(const struct LDKInit *NONNULL_PTR this_ptr);
	public static native long Init_get_remote_network_address(long this_ptr);
	// void Init_set_remote_network_address(struct LDKInit *NONNULL_PTR this_ptr, struct LDKCOption_SocketAddressZ val);
	public static native void Init_set_remote_network_address(long this_ptr, long val);
	// MUST_USE_RES struct LDKInit Init_new(struct LDKInitFeatures features_arg, struct LDKCOption_CVec_ThirtyTwoBytesZZ networks_arg, struct LDKCOption_SocketAddressZ remote_network_address_arg);
	public static native long Init_new(long features_arg, long networks_arg, long remote_network_address_arg);
	// uint64_t Init_clone_ptr(LDKInit *NONNULL_PTR arg);
	public static native long Init_clone_ptr(long arg);
	// struct LDKInit Init_clone(const struct LDKInit *NONNULL_PTR orig);
	public static native long Init_clone(long orig);
	// uint64_t Init_hash(const struct LDKInit *NONNULL_PTR o);
	public static native long Init_hash(long o);
	// bool Init_eq(const struct LDKInit *NONNULL_PTR a, const struct LDKInit *NONNULL_PTR b);
	public static native boolean Init_eq(long a, long b);
	// void ErrorMessage_free(struct LDKErrorMessage this_obj);
	public static native void ErrorMessage_free(long this_obj);
	// struct LDKChannelId ErrorMessage_get_channel_id(const struct LDKErrorMessage *NONNULL_PTR this_ptr);
	public static native long ErrorMessage_get_channel_id(long this_ptr);
	// void ErrorMessage_set_channel_id(struct LDKErrorMessage *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void ErrorMessage_set_channel_id(long this_ptr, long val);
	// struct LDKStr ErrorMessage_get_data(const struct LDKErrorMessage *NONNULL_PTR this_ptr);
	public static native String ErrorMessage_get_data(long this_ptr);
	// void ErrorMessage_set_data(struct LDKErrorMessage *NONNULL_PTR this_ptr, struct LDKStr val);
	public static native void ErrorMessage_set_data(long this_ptr, String val);
	// MUST_USE_RES struct LDKErrorMessage ErrorMessage_new(struct LDKChannelId channel_id_arg, struct LDKStr data_arg);
	public static native long ErrorMessage_new(long channel_id_arg, String data_arg);
	// uint64_t ErrorMessage_clone_ptr(LDKErrorMessage *NONNULL_PTR arg);
	public static native long ErrorMessage_clone_ptr(long arg);
	// struct LDKErrorMessage ErrorMessage_clone(const struct LDKErrorMessage *NONNULL_PTR orig);
	public static native long ErrorMessage_clone(long orig);
	// uint64_t ErrorMessage_hash(const struct LDKErrorMessage *NONNULL_PTR o);
	public static native long ErrorMessage_hash(long o);
	// bool ErrorMessage_eq(const struct LDKErrorMessage *NONNULL_PTR a, const struct LDKErrorMessage *NONNULL_PTR b);
	public static native boolean ErrorMessage_eq(long a, long b);
	// void WarningMessage_free(struct LDKWarningMessage this_obj);
	public static native void WarningMessage_free(long this_obj);
	// struct LDKChannelId WarningMessage_get_channel_id(const struct LDKWarningMessage *NONNULL_PTR this_ptr);
	public static native long WarningMessage_get_channel_id(long this_ptr);
	// void WarningMessage_set_channel_id(struct LDKWarningMessage *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void WarningMessage_set_channel_id(long this_ptr, long val);
	// struct LDKStr WarningMessage_get_data(const struct LDKWarningMessage *NONNULL_PTR this_ptr);
	public static native String WarningMessage_get_data(long this_ptr);
	// void WarningMessage_set_data(struct LDKWarningMessage *NONNULL_PTR this_ptr, struct LDKStr val);
	public static native void WarningMessage_set_data(long this_ptr, String val);
	// MUST_USE_RES struct LDKWarningMessage WarningMessage_new(struct LDKChannelId channel_id_arg, struct LDKStr data_arg);
	public static native long WarningMessage_new(long channel_id_arg, String data_arg);
	// uint64_t WarningMessage_clone_ptr(LDKWarningMessage *NONNULL_PTR arg);
	public static native long WarningMessage_clone_ptr(long arg);
	// struct LDKWarningMessage WarningMessage_clone(const struct LDKWarningMessage *NONNULL_PTR orig);
	public static native long WarningMessage_clone(long orig);
	// uint64_t WarningMessage_hash(const struct LDKWarningMessage *NONNULL_PTR o);
	public static native long WarningMessage_hash(long o);
	// bool WarningMessage_eq(const struct LDKWarningMessage *NONNULL_PTR a, const struct LDKWarningMessage *NONNULL_PTR b);
	public static native boolean WarningMessage_eq(long a, long b);
	// void Ping_free(struct LDKPing this_obj);
	public static native void Ping_free(long this_obj);
	// uint16_t Ping_get_ponglen(const struct LDKPing *NONNULL_PTR this_ptr);
	public static native short Ping_get_ponglen(long this_ptr);
	// void Ping_set_ponglen(struct LDKPing *NONNULL_PTR this_ptr, uint16_t val);
	public static native void Ping_set_ponglen(long this_ptr, short val);
	// uint16_t Ping_get_byteslen(const struct LDKPing *NONNULL_PTR this_ptr);
	public static native short Ping_get_byteslen(long this_ptr);
	// void Ping_set_byteslen(struct LDKPing *NONNULL_PTR this_ptr, uint16_t val);
	public static native void Ping_set_byteslen(long this_ptr, short val);
	// MUST_USE_RES struct LDKPing Ping_new(uint16_t ponglen_arg, uint16_t byteslen_arg);
	public static native long Ping_new(short ponglen_arg, short byteslen_arg);
	// uint64_t Ping_clone_ptr(LDKPing *NONNULL_PTR arg);
	public static native long Ping_clone_ptr(long arg);
	// struct LDKPing Ping_clone(const struct LDKPing *NONNULL_PTR orig);
	public static native long Ping_clone(long orig);
	// uint64_t Ping_hash(const struct LDKPing *NONNULL_PTR o);
	public static native long Ping_hash(long o);
	// bool Ping_eq(const struct LDKPing *NONNULL_PTR a, const struct LDKPing *NONNULL_PTR b);
	public static native boolean Ping_eq(long a, long b);
	// void Pong_free(struct LDKPong this_obj);
	public static native void Pong_free(long this_obj);
	// uint16_t Pong_get_byteslen(const struct LDKPong *NONNULL_PTR this_ptr);
	public static native short Pong_get_byteslen(long this_ptr);
	// void Pong_set_byteslen(struct LDKPong *NONNULL_PTR this_ptr, uint16_t val);
	public static native void Pong_set_byteslen(long this_ptr, short val);
	// MUST_USE_RES struct LDKPong Pong_new(uint16_t byteslen_arg);
	public static native long Pong_new(short byteslen_arg);
	// uint64_t Pong_clone_ptr(LDKPong *NONNULL_PTR arg);
	public static native long Pong_clone_ptr(long arg);
	// struct LDKPong Pong_clone(const struct LDKPong *NONNULL_PTR orig);
	public static native long Pong_clone(long orig);
	// uint64_t Pong_hash(const struct LDKPong *NONNULL_PTR o);
	public static native long Pong_hash(long o);
	// bool Pong_eq(const struct LDKPong *NONNULL_PTR a, const struct LDKPong *NONNULL_PTR b);
	public static native boolean Pong_eq(long a, long b);
	// void CommonOpenChannelFields_free(struct LDKCommonOpenChannelFields this_obj);
	public static native void CommonOpenChannelFields_free(long this_obj);
	// const uint8_t (*CommonOpenChannelFields_get_chain_hash(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr))[32];
	public static native byte[] CommonOpenChannelFields_get_chain_hash(long this_ptr);
	// void CommonOpenChannelFields_set_chain_hash(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, struct LDKThirtyTwoBytes val);
	public static native void CommonOpenChannelFields_set_chain_hash(long this_ptr, byte[] val);
	// struct LDKChannelId CommonOpenChannelFields_get_temporary_channel_id(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native long CommonOpenChannelFields_get_temporary_channel_id(long this_ptr);
	// void CommonOpenChannelFields_set_temporary_channel_id(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void CommonOpenChannelFields_set_temporary_channel_id(long this_ptr, long val);
	// uint64_t CommonOpenChannelFields_get_funding_satoshis(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native long CommonOpenChannelFields_get_funding_satoshis(long this_ptr);
	// void CommonOpenChannelFields_set_funding_satoshis(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, uint64_t val);
	public static native void CommonOpenChannelFields_set_funding_satoshis(long this_ptr, long val);
	// uint64_t CommonOpenChannelFields_get_dust_limit_satoshis(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native long CommonOpenChannelFields_get_dust_limit_satoshis(long this_ptr);
	// void CommonOpenChannelFields_set_dust_limit_satoshis(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, uint64_t val);
	public static native void CommonOpenChannelFields_set_dust_limit_satoshis(long this_ptr, long val);
	// uint64_t CommonOpenChannelFields_get_max_htlc_value_in_flight_msat(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native long CommonOpenChannelFields_get_max_htlc_value_in_flight_msat(long this_ptr);
	// void CommonOpenChannelFields_set_max_htlc_value_in_flight_msat(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, uint64_t val);
	public static native void CommonOpenChannelFields_set_max_htlc_value_in_flight_msat(long this_ptr, long val);
	// uint64_t CommonOpenChannelFields_get_htlc_minimum_msat(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native long CommonOpenChannelFields_get_htlc_minimum_msat(long this_ptr);
	// void CommonOpenChannelFields_set_htlc_minimum_msat(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, uint64_t val);
	public static native void CommonOpenChannelFields_set_htlc_minimum_msat(long this_ptr, long val);
	// uint32_t CommonOpenChannelFields_get_commitment_feerate_sat_per_1000_weight(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native int CommonOpenChannelFields_get_commitment_feerate_sat_per_1000_weight(long this_ptr);
	// void CommonOpenChannelFields_set_commitment_feerate_sat_per_1000_weight(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, uint32_t val);
	public static native void CommonOpenChannelFields_set_commitment_feerate_sat_per_1000_weight(long this_ptr, int val);
	// uint16_t CommonOpenChannelFields_get_to_self_delay(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native short CommonOpenChannelFields_get_to_self_delay(long this_ptr);
	// void CommonOpenChannelFields_set_to_self_delay(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, uint16_t val);
	public static native void CommonOpenChannelFields_set_to_self_delay(long this_ptr, short val);
	// uint16_t CommonOpenChannelFields_get_max_accepted_htlcs(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native short CommonOpenChannelFields_get_max_accepted_htlcs(long this_ptr);
	// void CommonOpenChannelFields_set_max_accepted_htlcs(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, uint16_t val);
	public static native void CommonOpenChannelFields_set_max_accepted_htlcs(long this_ptr, short val);
	// struct LDKPublicKey CommonOpenChannelFields_get_funding_pubkey(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native byte[] CommonOpenChannelFields_get_funding_pubkey(long this_ptr);
	// void CommonOpenChannelFields_set_funding_pubkey(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void CommonOpenChannelFields_set_funding_pubkey(long this_ptr, byte[] val);
	// struct LDKPublicKey CommonOpenChannelFields_get_revocation_basepoint(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native byte[] CommonOpenChannelFields_get_revocation_basepoint(long this_ptr);
	// void CommonOpenChannelFields_set_revocation_basepoint(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void CommonOpenChannelFields_set_revocation_basepoint(long this_ptr, byte[] val);
	// struct LDKPublicKey CommonOpenChannelFields_get_payment_basepoint(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native byte[] CommonOpenChannelFields_get_payment_basepoint(long this_ptr);
	// void CommonOpenChannelFields_set_payment_basepoint(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void CommonOpenChannelFields_set_payment_basepoint(long this_ptr, byte[] val);
	// struct LDKPublicKey CommonOpenChannelFields_get_delayed_payment_basepoint(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native byte[] CommonOpenChannelFields_get_delayed_payment_basepoint(long this_ptr);
	// void CommonOpenChannelFields_set_delayed_payment_basepoint(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void CommonOpenChannelFields_set_delayed_payment_basepoint(long this_ptr, byte[] val);
	// struct LDKPublicKey CommonOpenChannelFields_get_htlc_basepoint(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native byte[] CommonOpenChannelFields_get_htlc_basepoint(long this_ptr);
	// void CommonOpenChannelFields_set_htlc_basepoint(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void CommonOpenChannelFields_set_htlc_basepoint(long this_ptr, byte[] val);
	// struct LDKPublicKey CommonOpenChannelFields_get_first_per_commitment_point(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native byte[] CommonOpenChannelFields_get_first_per_commitment_point(long this_ptr);
	// void CommonOpenChannelFields_set_first_per_commitment_point(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void CommonOpenChannelFields_set_first_per_commitment_point(long this_ptr, byte[] val);
	// uint8_t CommonOpenChannelFields_get_channel_flags(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native byte CommonOpenChannelFields_get_channel_flags(long this_ptr);
	// void CommonOpenChannelFields_set_channel_flags(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, uint8_t val);
	public static native void CommonOpenChannelFields_set_channel_flags(long this_ptr, byte val);
	// struct LDKCOption_CVec_u8ZZ CommonOpenChannelFields_get_shutdown_scriptpubkey(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native long CommonOpenChannelFields_get_shutdown_scriptpubkey(long this_ptr);
	// void CommonOpenChannelFields_set_shutdown_scriptpubkey(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, struct LDKCOption_CVec_u8ZZ val);
	public static native void CommonOpenChannelFields_set_shutdown_scriptpubkey(long this_ptr, long val);
	// struct LDKChannelTypeFeatures CommonOpenChannelFields_get_channel_type(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr);
	public static native long CommonOpenChannelFields_get_channel_type(long this_ptr);
	// void CommonOpenChannelFields_set_channel_type(struct LDKCommonOpenChannelFields *NONNULL_PTR this_ptr, struct LDKChannelTypeFeatures val);
	public static native void CommonOpenChannelFields_set_channel_type(long this_ptr, long val);
	// MUST_USE_RES struct LDKCommonOpenChannelFields CommonOpenChannelFields_new(struct LDKThirtyTwoBytes chain_hash_arg, struct LDKChannelId temporary_channel_id_arg, uint64_t funding_satoshis_arg, uint64_t dust_limit_satoshis_arg, uint64_t max_htlc_value_in_flight_msat_arg, uint64_t htlc_minimum_msat_arg, uint32_t commitment_feerate_sat_per_1000_weight_arg, uint16_t to_self_delay_arg, uint16_t max_accepted_htlcs_arg, struct LDKPublicKey funding_pubkey_arg, struct LDKPublicKey revocation_basepoint_arg, struct LDKPublicKey payment_basepoint_arg, struct LDKPublicKey delayed_payment_basepoint_arg, struct LDKPublicKey htlc_basepoint_arg, struct LDKPublicKey first_per_commitment_point_arg, uint8_t channel_flags_arg, struct LDKCOption_CVec_u8ZZ shutdown_scriptpubkey_arg, struct LDKChannelTypeFeatures channel_type_arg);
	public static native long CommonOpenChannelFields_new(byte[] chain_hash_arg, long temporary_channel_id_arg, long funding_satoshis_arg, long dust_limit_satoshis_arg, long max_htlc_value_in_flight_msat_arg, long htlc_minimum_msat_arg, int commitment_feerate_sat_per_1000_weight_arg, short to_self_delay_arg, short max_accepted_htlcs_arg, byte[] funding_pubkey_arg, byte[] revocation_basepoint_arg, byte[] payment_basepoint_arg, byte[] delayed_payment_basepoint_arg, byte[] htlc_basepoint_arg, byte[] first_per_commitment_point_arg, byte channel_flags_arg, long shutdown_scriptpubkey_arg, long channel_type_arg);
	// uint64_t CommonOpenChannelFields_clone_ptr(LDKCommonOpenChannelFields *NONNULL_PTR arg);
	public static native long CommonOpenChannelFields_clone_ptr(long arg);
	// struct LDKCommonOpenChannelFields CommonOpenChannelFields_clone(const struct LDKCommonOpenChannelFields *NONNULL_PTR orig);
	public static native long CommonOpenChannelFields_clone(long orig);
	// uint64_t CommonOpenChannelFields_hash(const struct LDKCommonOpenChannelFields *NONNULL_PTR o);
	public static native long CommonOpenChannelFields_hash(long o);
	// bool CommonOpenChannelFields_eq(const struct LDKCommonOpenChannelFields *NONNULL_PTR a, const struct LDKCommonOpenChannelFields *NONNULL_PTR b);
	public static native boolean CommonOpenChannelFields_eq(long a, long b);
	// MUST_USE_RES struct LDKChannelParameters CommonOpenChannelFields_channel_parameters(const struct LDKCommonOpenChannelFields *NONNULL_PTR this_arg);
	public static native long CommonOpenChannelFields_channel_parameters(long this_arg);
	// void ChannelParameters_free(struct LDKChannelParameters this_obj);
	public static native void ChannelParameters_free(long this_obj);
	// uint64_t ChannelParameters_get_dust_limit_satoshis(const struct LDKChannelParameters *NONNULL_PTR this_ptr);
	public static native long ChannelParameters_get_dust_limit_satoshis(long this_ptr);
	// void ChannelParameters_set_dust_limit_satoshis(struct LDKChannelParameters *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelParameters_set_dust_limit_satoshis(long this_ptr, long val);
	// uint64_t ChannelParameters_get_max_htlc_value_in_flight_msat(const struct LDKChannelParameters *NONNULL_PTR this_ptr);
	public static native long ChannelParameters_get_max_htlc_value_in_flight_msat(long this_ptr);
	// void ChannelParameters_set_max_htlc_value_in_flight_msat(struct LDKChannelParameters *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelParameters_set_max_htlc_value_in_flight_msat(long this_ptr, long val);
	// uint64_t ChannelParameters_get_htlc_minimum_msat(const struct LDKChannelParameters *NONNULL_PTR this_ptr);
	public static native long ChannelParameters_get_htlc_minimum_msat(long this_ptr);
	// void ChannelParameters_set_htlc_minimum_msat(struct LDKChannelParameters *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ChannelParameters_set_htlc_minimum_msat(long this_ptr, long val);
	// uint32_t ChannelParameters_get_commitment_feerate_sat_per_1000_weight(const struct LDKChannelParameters *NONNULL_PTR this_ptr);
	public static native int ChannelParameters_get_commitment_feerate_sat_per_1000_weight(long this_ptr);
	// void ChannelParameters_set_commitment_feerate_sat_per_1000_weight(struct LDKChannelParameters *NONNULL_PTR this_ptr, uint32_t val);
	public static native void ChannelParameters_set_commitment_feerate_sat_per_1000_weight(long this_ptr, int val);
	// uint16_t ChannelParameters_get_to_self_delay(const struct LDKChannelParameters *NONNULL_PTR this_ptr);
	public static native short ChannelParameters_get_to_self_delay(long this_ptr);
	// void ChannelParameters_set_to_self_delay(struct LDKChannelParameters *NONNULL_PTR this_ptr, uint16_t val);
	public static native void ChannelParameters_set_to_self_delay(long this_ptr, short val);
	// uint16_t ChannelParameters_get_max_accepted_htlcs(const struct LDKChannelParameters *NONNULL_PTR this_ptr);
	public static native short ChannelParameters_get_max_accepted_htlcs(long this_ptr);
	// void ChannelParameters_set_max_accepted_htlcs(struct LDKChannelParameters *NONNULL_PTR this_ptr, uint16_t val);
	public static native void ChannelParameters_set_max_accepted_htlcs(long this_ptr, short val);
	// MUST_USE_RES struct LDKChannelParameters ChannelParameters_new(uint64_t dust_limit_satoshis_arg, uint64_t max_htlc_value_in_flight_msat_arg, uint64_t htlc_minimum_msat_arg, uint32_t commitment_feerate_sat_per_1000_weight_arg, uint16_t to_self_delay_arg, uint16_t max_accepted_htlcs_arg);
	public static native long ChannelParameters_new(long dust_limit_satoshis_arg, long max_htlc_value_in_flight_msat_arg, long htlc_minimum_msat_arg, int commitment_feerate_sat_per_1000_weight_arg, short to_self_delay_arg, short max_accepted_htlcs_arg);
	// uint64_t ChannelParameters_clone_ptr(LDKChannelParameters *NONNULL_PTR arg);
	public static native long ChannelParameters_clone_ptr(long arg);
	// struct LDKChannelParameters ChannelParameters_clone(const struct LDKChannelParameters *NONNULL_PTR orig);
	public static native long ChannelParameters_clone(long orig);
	// uint64_t ChannelParameters_hash(const struct LDKChannelParameters *NONNULL_PTR o);
	public static native long ChannelParameters_hash(long o);
	// bool ChannelParameters_eq(const struct LDKChannelParameters *NONNULL_PTR a, const struct LDKChannelParameters *NONNULL_PTR b);
	public static native boolean ChannelParameters_eq(long a, long b);
	// void OpenChannel_free(struct LDKOpenChannel this_obj);
	public static native void OpenChannel_free(long this_obj);
	// struct LDKCommonOpenChannelFields OpenChannel_get_common_fields(const struct LDKOpenChannel *NONNULL_PTR this_ptr);
	public static native long OpenChannel_get_common_fields(long this_ptr);
	// void OpenChannel_set_common_fields(struct LDKOpenChannel *NONNULL_PTR this_ptr, struct LDKCommonOpenChannelFields val);
	public static native void OpenChannel_set_common_fields(long this_ptr, long val);
	// uint64_t OpenChannel_get_push_msat(const struct LDKOpenChannel *NONNULL_PTR this_ptr);
	public static native long OpenChannel_get_push_msat(long this_ptr);
	// void OpenChannel_set_push_msat(struct LDKOpenChannel *NONNULL_PTR this_ptr, uint64_t val);
	public static native void OpenChannel_set_push_msat(long this_ptr, long val);
	// uint64_t OpenChannel_get_channel_reserve_satoshis(const struct LDKOpenChannel *NONNULL_PTR this_ptr);
	public static native long OpenChannel_get_channel_reserve_satoshis(long this_ptr);
	// void OpenChannel_set_channel_reserve_satoshis(struct LDKOpenChannel *NONNULL_PTR this_ptr, uint64_t val);
	public static native void OpenChannel_set_channel_reserve_satoshis(long this_ptr, long val);
	// MUST_USE_RES struct LDKOpenChannel OpenChannel_new(struct LDKCommonOpenChannelFields common_fields_arg, uint64_t push_msat_arg, uint64_t channel_reserve_satoshis_arg);
	public static native long OpenChannel_new(long common_fields_arg, long push_msat_arg, long channel_reserve_satoshis_arg);
	// uint64_t OpenChannel_clone_ptr(LDKOpenChannel *NONNULL_PTR arg);
	public static native long OpenChannel_clone_ptr(long arg);
	// struct LDKOpenChannel OpenChannel_clone(const struct LDKOpenChannel *NONNULL_PTR orig);
	public static native long OpenChannel_clone(long orig);
	// uint64_t OpenChannel_hash(const struct LDKOpenChannel *NONNULL_PTR o);
	public static native long OpenChannel_hash(long o);
	// bool OpenChannel_eq(const struct LDKOpenChannel *NONNULL_PTR a, const struct LDKOpenChannel *NONNULL_PTR b);
	public static native boolean OpenChannel_eq(long a, long b);
	// void OpenChannelV2_free(struct LDKOpenChannelV2 this_obj);
	public static native void OpenChannelV2_free(long this_obj);
	// struct LDKCommonOpenChannelFields OpenChannelV2_get_common_fields(const struct LDKOpenChannelV2 *NONNULL_PTR this_ptr);
	public static native long OpenChannelV2_get_common_fields(long this_ptr);
	// void OpenChannelV2_set_common_fields(struct LDKOpenChannelV2 *NONNULL_PTR this_ptr, struct LDKCommonOpenChannelFields val);
	public static native void OpenChannelV2_set_common_fields(long this_ptr, long val);
	// uint32_t OpenChannelV2_get_funding_feerate_sat_per_1000_weight(const struct LDKOpenChannelV2 *NONNULL_PTR this_ptr);
	public static native int OpenChannelV2_get_funding_feerate_sat_per_1000_weight(long this_ptr);
	// void OpenChannelV2_set_funding_feerate_sat_per_1000_weight(struct LDKOpenChannelV2 *NONNULL_PTR this_ptr, uint32_t val);
	public static native void OpenChannelV2_set_funding_feerate_sat_per_1000_weight(long this_ptr, int val);
	// uint32_t OpenChannelV2_get_locktime(const struct LDKOpenChannelV2 *NONNULL_PTR this_ptr);
	public static native int OpenChannelV2_get_locktime(long this_ptr);
	// void OpenChannelV2_set_locktime(struct LDKOpenChannelV2 *NONNULL_PTR this_ptr, uint32_t val);
	public static native void OpenChannelV2_set_locktime(long this_ptr, int val);
	// struct LDKPublicKey OpenChannelV2_get_second_per_commitment_point(const struct LDKOpenChannelV2 *NONNULL_PTR this_ptr);
	public static native byte[] OpenChannelV2_get_second_per_commitment_point(long this_ptr);
	// void OpenChannelV2_set_second_per_commitment_point(struct LDKOpenChannelV2 *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void OpenChannelV2_set_second_per_commitment_point(long this_ptr, byte[] val);
	// enum LDKCOption_NoneZ OpenChannelV2_get_require_confirmed_inputs(const struct LDKOpenChannelV2 *NONNULL_PTR this_ptr);
	public static native COption_NoneZ OpenChannelV2_get_require_confirmed_inputs(long this_ptr);
	// void OpenChannelV2_set_require_confirmed_inputs(struct LDKOpenChannelV2 *NONNULL_PTR this_ptr, enum LDKCOption_NoneZ val);
	public static native void OpenChannelV2_set_require_confirmed_inputs(long this_ptr, COption_NoneZ val);
	// MUST_USE_RES struct LDKOpenChannelV2 OpenChannelV2_new(struct LDKCommonOpenChannelFields common_fields_arg, uint32_t funding_feerate_sat_per_1000_weight_arg, uint32_t locktime_arg, struct LDKPublicKey second_per_commitment_point_arg, enum LDKCOption_NoneZ require_confirmed_inputs_arg);
	public static native long OpenChannelV2_new(long common_fields_arg, int funding_feerate_sat_per_1000_weight_arg, int locktime_arg, byte[] second_per_commitment_point_arg, COption_NoneZ require_confirmed_inputs_arg);
	// uint64_t OpenChannelV2_clone_ptr(LDKOpenChannelV2 *NONNULL_PTR arg);
	public static native long OpenChannelV2_clone_ptr(long arg);
	// struct LDKOpenChannelV2 OpenChannelV2_clone(const struct LDKOpenChannelV2 *NONNULL_PTR orig);
	public static native long OpenChannelV2_clone(long orig);
	// uint64_t OpenChannelV2_hash(const struct LDKOpenChannelV2 *NONNULL_PTR o);
	public static native long OpenChannelV2_hash(long o);
	// bool OpenChannelV2_eq(const struct LDKOpenChannelV2 *NONNULL_PTR a, const struct LDKOpenChannelV2 *NONNULL_PTR b);
	public static native boolean OpenChannelV2_eq(long a, long b);
	// void CommonAcceptChannelFields_free(struct LDKCommonAcceptChannelFields this_obj);
	public static native void CommonAcceptChannelFields_free(long this_obj);
	// struct LDKChannelId CommonAcceptChannelFields_get_temporary_channel_id(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native long CommonAcceptChannelFields_get_temporary_channel_id(long this_ptr);
	// void CommonAcceptChannelFields_set_temporary_channel_id(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void CommonAcceptChannelFields_set_temporary_channel_id(long this_ptr, long val);
	// uint64_t CommonAcceptChannelFields_get_dust_limit_satoshis(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native long CommonAcceptChannelFields_get_dust_limit_satoshis(long this_ptr);
	// void CommonAcceptChannelFields_set_dust_limit_satoshis(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, uint64_t val);
	public static native void CommonAcceptChannelFields_set_dust_limit_satoshis(long this_ptr, long val);
	// uint64_t CommonAcceptChannelFields_get_max_htlc_value_in_flight_msat(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native long CommonAcceptChannelFields_get_max_htlc_value_in_flight_msat(long this_ptr);
	// void CommonAcceptChannelFields_set_max_htlc_value_in_flight_msat(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, uint64_t val);
	public static native void CommonAcceptChannelFields_set_max_htlc_value_in_flight_msat(long this_ptr, long val);
	// uint64_t CommonAcceptChannelFields_get_htlc_minimum_msat(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native long CommonAcceptChannelFields_get_htlc_minimum_msat(long this_ptr);
	// void CommonAcceptChannelFields_set_htlc_minimum_msat(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, uint64_t val);
	public static native void CommonAcceptChannelFields_set_htlc_minimum_msat(long this_ptr, long val);
	// uint32_t CommonAcceptChannelFields_get_minimum_depth(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native int CommonAcceptChannelFields_get_minimum_depth(long this_ptr);
	// void CommonAcceptChannelFields_set_minimum_depth(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, uint32_t val);
	public static native void CommonAcceptChannelFields_set_minimum_depth(long this_ptr, int val);
	// uint16_t CommonAcceptChannelFields_get_to_self_delay(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native short CommonAcceptChannelFields_get_to_self_delay(long this_ptr);
	// void CommonAcceptChannelFields_set_to_self_delay(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, uint16_t val);
	public static native void CommonAcceptChannelFields_set_to_self_delay(long this_ptr, short val);
	// uint16_t CommonAcceptChannelFields_get_max_accepted_htlcs(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native short CommonAcceptChannelFields_get_max_accepted_htlcs(long this_ptr);
	// void CommonAcceptChannelFields_set_max_accepted_htlcs(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, uint16_t val);
	public static native void CommonAcceptChannelFields_set_max_accepted_htlcs(long this_ptr, short val);
	// struct LDKPublicKey CommonAcceptChannelFields_get_funding_pubkey(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native byte[] CommonAcceptChannelFields_get_funding_pubkey(long this_ptr);
	// void CommonAcceptChannelFields_set_funding_pubkey(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void CommonAcceptChannelFields_set_funding_pubkey(long this_ptr, byte[] val);
	// struct LDKPublicKey CommonAcceptChannelFields_get_revocation_basepoint(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native byte[] CommonAcceptChannelFields_get_revocation_basepoint(long this_ptr);
	// void CommonAcceptChannelFields_set_revocation_basepoint(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void CommonAcceptChannelFields_set_revocation_basepoint(long this_ptr, byte[] val);
	// struct LDKPublicKey CommonAcceptChannelFields_get_payment_basepoint(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native byte[] CommonAcceptChannelFields_get_payment_basepoint(long this_ptr);
	// void CommonAcceptChannelFields_set_payment_basepoint(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void CommonAcceptChannelFields_set_payment_basepoint(long this_ptr, byte[] val);
	// struct LDKPublicKey CommonAcceptChannelFields_get_delayed_payment_basepoint(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native byte[] CommonAcceptChannelFields_get_delayed_payment_basepoint(long this_ptr);
	// void CommonAcceptChannelFields_set_delayed_payment_basepoint(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void CommonAcceptChannelFields_set_delayed_payment_basepoint(long this_ptr, byte[] val);
	// struct LDKPublicKey CommonAcceptChannelFields_get_htlc_basepoint(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native byte[] CommonAcceptChannelFields_get_htlc_basepoint(long this_ptr);
	// void CommonAcceptChannelFields_set_htlc_basepoint(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void CommonAcceptChannelFields_set_htlc_basepoint(long this_ptr, byte[] val);
	// struct LDKPublicKey CommonAcceptChannelFields_get_first_per_commitment_point(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native byte[] CommonAcceptChannelFields_get_first_per_commitment_point(long this_ptr);
	// void CommonAcceptChannelFields_set_first_per_commitment_point(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void CommonAcceptChannelFields_set_first_per_commitment_point(long this_ptr, byte[] val);
	// struct LDKCOption_CVec_u8ZZ CommonAcceptChannelFields_get_shutdown_scriptpubkey(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native long CommonAcceptChannelFields_get_shutdown_scriptpubkey(long this_ptr);
	// void CommonAcceptChannelFields_set_shutdown_scriptpubkey(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, struct LDKCOption_CVec_u8ZZ val);
	public static native void CommonAcceptChannelFields_set_shutdown_scriptpubkey(long this_ptr, long val);
	// struct LDKChannelTypeFeatures CommonAcceptChannelFields_get_channel_type(const struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr);
	public static native long CommonAcceptChannelFields_get_channel_type(long this_ptr);
	// void CommonAcceptChannelFields_set_channel_type(struct LDKCommonAcceptChannelFields *NONNULL_PTR this_ptr, struct LDKChannelTypeFeatures val);
	public static native void CommonAcceptChannelFields_set_channel_type(long this_ptr, long val);
	// MUST_USE_RES struct LDKCommonAcceptChannelFields CommonAcceptChannelFields_new(struct LDKChannelId temporary_channel_id_arg, uint64_t dust_limit_satoshis_arg, uint64_t max_htlc_value_in_flight_msat_arg, uint64_t htlc_minimum_msat_arg, uint32_t minimum_depth_arg, uint16_t to_self_delay_arg, uint16_t max_accepted_htlcs_arg, struct LDKPublicKey funding_pubkey_arg, struct LDKPublicKey revocation_basepoint_arg, struct LDKPublicKey payment_basepoint_arg, struct LDKPublicKey delayed_payment_basepoint_arg, struct LDKPublicKey htlc_basepoint_arg, struct LDKPublicKey first_per_commitment_point_arg, struct LDKCOption_CVec_u8ZZ shutdown_scriptpubkey_arg, struct LDKChannelTypeFeatures channel_type_arg);
	public static native long CommonAcceptChannelFields_new(long temporary_channel_id_arg, long dust_limit_satoshis_arg, long max_htlc_value_in_flight_msat_arg, long htlc_minimum_msat_arg, int minimum_depth_arg, short to_self_delay_arg, short max_accepted_htlcs_arg, byte[] funding_pubkey_arg, byte[] revocation_basepoint_arg, byte[] payment_basepoint_arg, byte[] delayed_payment_basepoint_arg, byte[] htlc_basepoint_arg, byte[] first_per_commitment_point_arg, long shutdown_scriptpubkey_arg, long channel_type_arg);
	// uint64_t CommonAcceptChannelFields_clone_ptr(LDKCommonAcceptChannelFields *NONNULL_PTR arg);
	public static native long CommonAcceptChannelFields_clone_ptr(long arg);
	// struct LDKCommonAcceptChannelFields CommonAcceptChannelFields_clone(const struct LDKCommonAcceptChannelFields *NONNULL_PTR orig);
	public static native long CommonAcceptChannelFields_clone(long orig);
	// uint64_t CommonAcceptChannelFields_hash(const struct LDKCommonAcceptChannelFields *NONNULL_PTR o);
	public static native long CommonAcceptChannelFields_hash(long o);
	// bool CommonAcceptChannelFields_eq(const struct LDKCommonAcceptChannelFields *NONNULL_PTR a, const struct LDKCommonAcceptChannelFields *NONNULL_PTR b);
	public static native boolean CommonAcceptChannelFields_eq(long a, long b);
	// void AcceptChannel_free(struct LDKAcceptChannel this_obj);
	public static native void AcceptChannel_free(long this_obj);
	// struct LDKCommonAcceptChannelFields AcceptChannel_get_common_fields(const struct LDKAcceptChannel *NONNULL_PTR this_ptr);
	public static native long AcceptChannel_get_common_fields(long this_ptr);
	// void AcceptChannel_set_common_fields(struct LDKAcceptChannel *NONNULL_PTR this_ptr, struct LDKCommonAcceptChannelFields val);
	public static native void AcceptChannel_set_common_fields(long this_ptr, long val);
	// uint64_t AcceptChannel_get_channel_reserve_satoshis(const struct LDKAcceptChannel *NONNULL_PTR this_ptr);
	public static native long AcceptChannel_get_channel_reserve_satoshis(long this_ptr);
	// void AcceptChannel_set_channel_reserve_satoshis(struct LDKAcceptChannel *NONNULL_PTR this_ptr, uint64_t val);
	public static native void AcceptChannel_set_channel_reserve_satoshis(long this_ptr, long val);
	// MUST_USE_RES struct LDKAcceptChannel AcceptChannel_new(struct LDKCommonAcceptChannelFields common_fields_arg, uint64_t channel_reserve_satoshis_arg);
	public static native long AcceptChannel_new(long common_fields_arg, long channel_reserve_satoshis_arg);
	// uint64_t AcceptChannel_clone_ptr(LDKAcceptChannel *NONNULL_PTR arg);
	public static native long AcceptChannel_clone_ptr(long arg);
	// struct LDKAcceptChannel AcceptChannel_clone(const struct LDKAcceptChannel *NONNULL_PTR orig);
	public static native long AcceptChannel_clone(long orig);
	// uint64_t AcceptChannel_hash(const struct LDKAcceptChannel *NONNULL_PTR o);
	public static native long AcceptChannel_hash(long o);
	// bool AcceptChannel_eq(const struct LDKAcceptChannel *NONNULL_PTR a, const struct LDKAcceptChannel *NONNULL_PTR b);
	public static native boolean AcceptChannel_eq(long a, long b);
	// void AcceptChannelV2_free(struct LDKAcceptChannelV2 this_obj);
	public static native void AcceptChannelV2_free(long this_obj);
	// struct LDKCommonAcceptChannelFields AcceptChannelV2_get_common_fields(const struct LDKAcceptChannelV2 *NONNULL_PTR this_ptr);
	public static native long AcceptChannelV2_get_common_fields(long this_ptr);
	// void AcceptChannelV2_set_common_fields(struct LDKAcceptChannelV2 *NONNULL_PTR this_ptr, struct LDKCommonAcceptChannelFields val);
	public static native void AcceptChannelV2_set_common_fields(long this_ptr, long val);
	// uint64_t AcceptChannelV2_get_funding_satoshis(const struct LDKAcceptChannelV2 *NONNULL_PTR this_ptr);
	public static native long AcceptChannelV2_get_funding_satoshis(long this_ptr);
	// void AcceptChannelV2_set_funding_satoshis(struct LDKAcceptChannelV2 *NONNULL_PTR this_ptr, uint64_t val);
	public static native void AcceptChannelV2_set_funding_satoshis(long this_ptr, long val);
	// struct LDKPublicKey AcceptChannelV2_get_second_per_commitment_point(const struct LDKAcceptChannelV2 *NONNULL_PTR this_ptr);
	public static native byte[] AcceptChannelV2_get_second_per_commitment_point(long this_ptr);
	// void AcceptChannelV2_set_second_per_commitment_point(struct LDKAcceptChannelV2 *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void AcceptChannelV2_set_second_per_commitment_point(long this_ptr, byte[] val);
	// enum LDKCOption_NoneZ AcceptChannelV2_get_require_confirmed_inputs(const struct LDKAcceptChannelV2 *NONNULL_PTR this_ptr);
	public static native COption_NoneZ AcceptChannelV2_get_require_confirmed_inputs(long this_ptr);
	// void AcceptChannelV2_set_require_confirmed_inputs(struct LDKAcceptChannelV2 *NONNULL_PTR this_ptr, enum LDKCOption_NoneZ val);
	public static native void AcceptChannelV2_set_require_confirmed_inputs(long this_ptr, COption_NoneZ val);
	// MUST_USE_RES struct LDKAcceptChannelV2 AcceptChannelV2_new(struct LDKCommonAcceptChannelFields common_fields_arg, uint64_t funding_satoshis_arg, struct LDKPublicKey second_per_commitment_point_arg, enum LDKCOption_NoneZ require_confirmed_inputs_arg);
	public static native long AcceptChannelV2_new(long common_fields_arg, long funding_satoshis_arg, byte[] second_per_commitment_point_arg, COption_NoneZ require_confirmed_inputs_arg);
	// uint64_t AcceptChannelV2_clone_ptr(LDKAcceptChannelV2 *NONNULL_PTR arg);
	public static native long AcceptChannelV2_clone_ptr(long arg);
	// struct LDKAcceptChannelV2 AcceptChannelV2_clone(const struct LDKAcceptChannelV2 *NONNULL_PTR orig);
	public static native long AcceptChannelV2_clone(long orig);
	// uint64_t AcceptChannelV2_hash(const struct LDKAcceptChannelV2 *NONNULL_PTR o);
	public static native long AcceptChannelV2_hash(long o);
	// bool AcceptChannelV2_eq(const struct LDKAcceptChannelV2 *NONNULL_PTR a, const struct LDKAcceptChannelV2 *NONNULL_PTR b);
	public static native boolean AcceptChannelV2_eq(long a, long b);
	// void FundingCreated_free(struct LDKFundingCreated this_obj);
	public static native void FundingCreated_free(long this_obj);
	// struct LDKChannelId FundingCreated_get_temporary_channel_id(const struct LDKFundingCreated *NONNULL_PTR this_ptr);
	public static native long FundingCreated_get_temporary_channel_id(long this_ptr);
	// void FundingCreated_set_temporary_channel_id(struct LDKFundingCreated *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void FundingCreated_set_temporary_channel_id(long this_ptr, long val);
	// const uint8_t (*FundingCreated_get_funding_txid(const struct LDKFundingCreated *NONNULL_PTR this_ptr))[32];
	public static native byte[] FundingCreated_get_funding_txid(long this_ptr);
	// void FundingCreated_set_funding_txid(struct LDKFundingCreated *NONNULL_PTR this_ptr, struct LDKThirtyTwoBytes val);
	public static native void FundingCreated_set_funding_txid(long this_ptr, byte[] val);
	// uint16_t FundingCreated_get_funding_output_index(const struct LDKFundingCreated *NONNULL_PTR this_ptr);
	public static native short FundingCreated_get_funding_output_index(long this_ptr);
	// void FundingCreated_set_funding_output_index(struct LDKFundingCreated *NONNULL_PTR this_ptr, uint16_t val);
	public static native void FundingCreated_set_funding_output_index(long this_ptr, short val);
	// struct LDKECDSASignature FundingCreated_get_signature(const struct LDKFundingCreated *NONNULL_PTR this_ptr);
	public static native byte[] FundingCreated_get_signature(long this_ptr);
	// void FundingCreated_set_signature(struct LDKFundingCreated *NONNULL_PTR this_ptr, struct LDKECDSASignature val);
	public static native void FundingCreated_set_signature(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKFundingCreated FundingCreated_new(struct LDKChannelId temporary_channel_id_arg, struct LDKThirtyTwoBytes funding_txid_arg, uint16_t funding_output_index_arg, struct LDKECDSASignature signature_arg);
	public static native long FundingCreated_new(long temporary_channel_id_arg, byte[] funding_txid_arg, short funding_output_index_arg, byte[] signature_arg);
	// uint64_t FundingCreated_clone_ptr(LDKFundingCreated *NONNULL_PTR arg);
	public static native long FundingCreated_clone_ptr(long arg);
	// struct LDKFundingCreated FundingCreated_clone(const struct LDKFundingCreated *NONNULL_PTR orig);
	public static native long FundingCreated_clone(long orig);
	// uint64_t FundingCreated_hash(const struct LDKFundingCreated *NONNULL_PTR o);
	public static native long FundingCreated_hash(long o);
	// bool FundingCreated_eq(const struct LDKFundingCreated *NONNULL_PTR a, const struct LDKFundingCreated *NONNULL_PTR b);
	public static native boolean FundingCreated_eq(long a, long b);
	// void FundingSigned_free(struct LDKFundingSigned this_obj);
	public static native void FundingSigned_free(long this_obj);
	// struct LDKChannelId FundingSigned_get_channel_id(const struct LDKFundingSigned *NONNULL_PTR this_ptr);
	public static native long FundingSigned_get_channel_id(long this_ptr);
	// void FundingSigned_set_channel_id(struct LDKFundingSigned *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void FundingSigned_set_channel_id(long this_ptr, long val);
	// struct LDKECDSASignature FundingSigned_get_signature(const struct LDKFundingSigned *NONNULL_PTR this_ptr);
	public static native byte[] FundingSigned_get_signature(long this_ptr);
	// void FundingSigned_set_signature(struct LDKFundingSigned *NONNULL_PTR this_ptr, struct LDKECDSASignature val);
	public static native void FundingSigned_set_signature(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKFundingSigned FundingSigned_new(struct LDKChannelId channel_id_arg, struct LDKECDSASignature signature_arg);
	public static native long FundingSigned_new(long channel_id_arg, byte[] signature_arg);
	// uint64_t FundingSigned_clone_ptr(LDKFundingSigned *NONNULL_PTR arg);
	public static native long FundingSigned_clone_ptr(long arg);
	// struct LDKFundingSigned FundingSigned_clone(const struct LDKFundingSigned *NONNULL_PTR orig);
	public static native long FundingSigned_clone(long orig);
	// uint64_t FundingSigned_hash(const struct LDKFundingSigned *NONNULL_PTR o);
	public static native long FundingSigned_hash(long o);
	// bool FundingSigned_eq(const struct LDKFundingSigned *NONNULL_PTR a, const struct LDKFundingSigned *NONNULL_PTR b);
	public static native boolean FundingSigned_eq(long a, long b);
	// void ChannelReady_free(struct LDKChannelReady this_obj);
	public static native void ChannelReady_free(long this_obj);
	// struct LDKChannelId ChannelReady_get_channel_id(const struct LDKChannelReady *NONNULL_PTR this_ptr);
	public static native long ChannelReady_get_channel_id(long this_ptr);
	// void ChannelReady_set_channel_id(struct LDKChannelReady *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void ChannelReady_set_channel_id(long this_ptr, long val);
	// struct LDKPublicKey ChannelReady_get_next_per_commitment_point(const struct LDKChannelReady *NONNULL_PTR this_ptr);
	public static native byte[] ChannelReady_get_next_per_commitment_point(long this_ptr);
	// void ChannelReady_set_next_per_commitment_point(struct LDKChannelReady *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void ChannelReady_set_next_per_commitment_point(long this_ptr, byte[] val);
	// struct LDKCOption_u64Z ChannelReady_get_short_channel_id_alias(const struct LDKChannelReady *NONNULL_PTR this_ptr);
	public static native long ChannelReady_get_short_channel_id_alias(long this_ptr);
	// void ChannelReady_set_short_channel_id_alias(struct LDKChannelReady *NONNULL_PTR this_ptr, struct LDKCOption_u64Z val);
	public static native void ChannelReady_set_short_channel_id_alias(long this_ptr, long val);
	// MUST_USE_RES struct LDKChannelReady ChannelReady_new(struct LDKChannelId channel_id_arg, struct LDKPublicKey next_per_commitment_point_arg, struct LDKCOption_u64Z short_channel_id_alias_arg);
	public static native long ChannelReady_new(long channel_id_arg, byte[] next_per_commitment_point_arg, long short_channel_id_alias_arg);
	// uint64_t ChannelReady_clone_ptr(LDKChannelReady *NONNULL_PTR arg);
	public static native long ChannelReady_clone_ptr(long arg);
	// struct LDKChannelReady ChannelReady_clone(const struct LDKChannelReady *NONNULL_PTR orig);
	public static native long ChannelReady_clone(long orig);
	// uint64_t ChannelReady_hash(const struct LDKChannelReady *NONNULL_PTR o);
	public static native long ChannelReady_hash(long o);
	// bool ChannelReady_eq(const struct LDKChannelReady *NONNULL_PTR a, const struct LDKChannelReady *NONNULL_PTR b);
	public static native boolean ChannelReady_eq(long a, long b);
	// void Stfu_free(struct LDKStfu this_obj);
	public static native void Stfu_free(long this_obj);
	// struct LDKChannelId Stfu_get_channel_id(const struct LDKStfu *NONNULL_PTR this_ptr);
	public static native long Stfu_get_channel_id(long this_ptr);
	// void Stfu_set_channel_id(struct LDKStfu *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void Stfu_set_channel_id(long this_ptr, long val);
	// uint8_t Stfu_get_initiator(const struct LDKStfu *NONNULL_PTR this_ptr);
	public static native byte Stfu_get_initiator(long this_ptr);
	// void Stfu_set_initiator(struct LDKStfu *NONNULL_PTR this_ptr, uint8_t val);
	public static native void Stfu_set_initiator(long this_ptr, byte val);
	// MUST_USE_RES struct LDKStfu Stfu_new(struct LDKChannelId channel_id_arg, uint8_t initiator_arg);
	public static native long Stfu_new(long channel_id_arg, byte initiator_arg);
	// uint64_t Stfu_clone_ptr(LDKStfu *NONNULL_PTR arg);
	public static native long Stfu_clone_ptr(long arg);
	// struct LDKStfu Stfu_clone(const struct LDKStfu *NONNULL_PTR orig);
	public static native long Stfu_clone(long orig);
	// bool Stfu_eq(const struct LDKStfu *NONNULL_PTR a, const struct LDKStfu *NONNULL_PTR b);
	public static native boolean Stfu_eq(long a, long b);
	// void SpliceInit_free(struct LDKSpliceInit this_obj);
	public static native void SpliceInit_free(long this_obj);
	// struct LDKChannelId SpliceInit_get_channel_id(const struct LDKSpliceInit *NONNULL_PTR this_ptr);
	public static native long SpliceInit_get_channel_id(long this_ptr);
	// void SpliceInit_set_channel_id(struct LDKSpliceInit *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void SpliceInit_set_channel_id(long this_ptr, long val);
	// int64_t SpliceInit_get_funding_contribution_satoshis(const struct LDKSpliceInit *NONNULL_PTR this_ptr);
	public static native long SpliceInit_get_funding_contribution_satoshis(long this_ptr);
	// void SpliceInit_set_funding_contribution_satoshis(struct LDKSpliceInit *NONNULL_PTR this_ptr, int64_t val);
	public static native void SpliceInit_set_funding_contribution_satoshis(long this_ptr, long val);
	// uint32_t SpliceInit_get_funding_feerate_perkw(const struct LDKSpliceInit *NONNULL_PTR this_ptr);
	public static native int SpliceInit_get_funding_feerate_perkw(long this_ptr);
	// void SpliceInit_set_funding_feerate_perkw(struct LDKSpliceInit *NONNULL_PTR this_ptr, uint32_t val);
	public static native void SpliceInit_set_funding_feerate_perkw(long this_ptr, int val);
	// uint32_t SpliceInit_get_locktime(const struct LDKSpliceInit *NONNULL_PTR this_ptr);
	public static native int SpliceInit_get_locktime(long this_ptr);
	// void SpliceInit_set_locktime(struct LDKSpliceInit *NONNULL_PTR this_ptr, uint32_t val);
	public static native void SpliceInit_set_locktime(long this_ptr, int val);
	// struct LDKPublicKey SpliceInit_get_funding_pubkey(const struct LDKSpliceInit *NONNULL_PTR this_ptr);
	public static native byte[] SpliceInit_get_funding_pubkey(long this_ptr);
	// void SpliceInit_set_funding_pubkey(struct LDKSpliceInit *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void SpliceInit_set_funding_pubkey(long this_ptr, byte[] val);
	// enum LDKCOption_NoneZ SpliceInit_get_require_confirmed_inputs(const struct LDKSpliceInit *NONNULL_PTR this_ptr);
	public static native COption_NoneZ SpliceInit_get_require_confirmed_inputs(long this_ptr);
	// void SpliceInit_set_require_confirmed_inputs(struct LDKSpliceInit *NONNULL_PTR this_ptr, enum LDKCOption_NoneZ val);
	public static native void SpliceInit_set_require_confirmed_inputs(long this_ptr, COption_NoneZ val);
	// MUST_USE_RES struct LDKSpliceInit SpliceInit_new(struct LDKChannelId channel_id_arg, int64_t funding_contribution_satoshis_arg, uint32_t funding_feerate_perkw_arg, uint32_t locktime_arg, struct LDKPublicKey funding_pubkey_arg, enum LDKCOption_NoneZ require_confirmed_inputs_arg);
	public static native long SpliceInit_new(long channel_id_arg, long funding_contribution_satoshis_arg, int funding_feerate_perkw_arg, int locktime_arg, byte[] funding_pubkey_arg, COption_NoneZ require_confirmed_inputs_arg);
	// uint64_t SpliceInit_clone_ptr(LDKSpliceInit *NONNULL_PTR arg);
	public static native long SpliceInit_clone_ptr(long arg);
	// struct LDKSpliceInit SpliceInit_clone(const struct LDKSpliceInit *NONNULL_PTR orig);
	public static native long SpliceInit_clone(long orig);
	// bool SpliceInit_eq(const struct LDKSpliceInit *NONNULL_PTR a, const struct LDKSpliceInit *NONNULL_PTR b);
	public static native boolean SpliceInit_eq(long a, long b);
	// void SpliceAck_free(struct LDKSpliceAck this_obj);
	public static native void SpliceAck_free(long this_obj);
	// struct LDKChannelId SpliceAck_get_channel_id(const struct LDKSpliceAck *NONNULL_PTR this_ptr);
	public static native long SpliceAck_get_channel_id(long this_ptr);
	// void SpliceAck_set_channel_id(struct LDKSpliceAck *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void SpliceAck_set_channel_id(long this_ptr, long val);
	// int64_t SpliceAck_get_funding_contribution_satoshis(const struct LDKSpliceAck *NONNULL_PTR this_ptr);
	public static native long SpliceAck_get_funding_contribution_satoshis(long this_ptr);
	// void SpliceAck_set_funding_contribution_satoshis(struct LDKSpliceAck *NONNULL_PTR this_ptr, int64_t val);
	public static native void SpliceAck_set_funding_contribution_satoshis(long this_ptr, long val);
	// struct LDKPublicKey SpliceAck_get_funding_pubkey(const struct LDKSpliceAck *NONNULL_PTR this_ptr);
	public static native byte[] SpliceAck_get_funding_pubkey(long this_ptr);
	// void SpliceAck_set_funding_pubkey(struct LDKSpliceAck *NONNULL_PTR this_ptr, struct LDKPublicKey val);
	public static native void SpliceAck_set_funding_pubkey(long this_ptr, byte[] val);
	// enum LDKCOption_NoneZ SpliceAck_get_require_confirmed_inputs(const struct LDKSpliceAck *NONNULL_PTR this_ptr);
	public static native COption_NoneZ SpliceAck_get_require_confirmed_inputs(long this_ptr);
	// void SpliceAck_set_require_confirmed_inputs(struct LDKSpliceAck *NONNULL_PTR this_ptr, enum LDKCOption_NoneZ val);
	public static native void SpliceAck_set_require_confirmed_inputs(long this_ptr, COption_NoneZ val);
	// MUST_USE_RES struct LDKSpliceAck SpliceAck_new(struct LDKChannelId channel_id_arg, int64_t funding_contribution_satoshis_arg, struct LDKPublicKey funding_pubkey_arg, enum LDKCOption_NoneZ require_confirmed_inputs_arg);
	public static native long SpliceAck_new(long channel_id_arg, long funding_contribution_satoshis_arg, byte[] funding_pubkey_arg, COption_NoneZ require_confirmed_inputs_arg);
	// uint64_t SpliceAck_clone_ptr(LDKSpliceAck *NONNULL_PTR arg);
	public static native long SpliceAck_clone_ptr(long arg);
	// struct LDKSpliceAck SpliceAck_clone(const struct LDKSpliceAck *NONNULL_PTR orig);
	public static native long SpliceAck_clone(long orig);
	// bool SpliceAck_eq(const struct LDKSpliceAck *NONNULL_PTR a, const struct LDKSpliceAck *NONNULL_PTR b);
	public static native boolean SpliceAck_eq(long a, long b);
	// void SpliceLocked_free(struct LDKSpliceLocked this_obj);
	public static native void SpliceLocked_free(long this_obj);
	// struct LDKChannelId SpliceLocked_get_channel_id(const struct LDKSpliceLocked *NONNULL_PTR this_ptr);
	public static native long SpliceLocked_get_channel_id(long this_ptr);
	// void SpliceLocked_set_channel_id(struct LDKSpliceLocked *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void SpliceLocked_set_channel_id(long this_ptr, long val);
	// const uint8_t (*SpliceLocked_get_splice_txid(const struct LDKSpliceLocked *NONNULL_PTR this_ptr))[32];
	public static native byte[] SpliceLocked_get_splice_txid(long this_ptr);
	// void SpliceLocked_set_splice_txid(struct LDKSpliceLocked *NONNULL_PTR this_ptr, struct LDKThirtyTwoBytes val);
	public static native void SpliceLocked_set_splice_txid(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKSpliceLocked SpliceLocked_new(struct LDKChannelId channel_id_arg, struct LDKThirtyTwoBytes splice_txid_arg);
	public static native long SpliceLocked_new(long channel_id_arg, byte[] splice_txid_arg);
	// uint64_t SpliceLocked_clone_ptr(LDKSpliceLocked *NONNULL_PTR arg);
	public static native long SpliceLocked_clone_ptr(long arg);
	// struct LDKSpliceLocked SpliceLocked_clone(const struct LDKSpliceLocked *NONNULL_PTR orig);
	public static native long SpliceLocked_clone(long orig);
	// bool SpliceLocked_eq(const struct LDKSpliceLocked *NONNULL_PTR a, const struct LDKSpliceLocked *NONNULL_PTR b);
	public static native boolean SpliceLocked_eq(long a, long b);
	// void TxAddInput_free(struct LDKTxAddInput this_obj);
	public static native void TxAddInput_free(long this_obj);
	// struct LDKChannelId TxAddInput_get_channel_id(const struct LDKTxAddInput *NONNULL_PTR this_ptr);
	public static native long TxAddInput_get_channel_id(long this_ptr);
	// void TxAddInput_set_channel_id(struct LDKTxAddInput *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void TxAddInput_set_channel_id(long this_ptr, long val);
	// uint64_t TxAddInput_get_serial_id(const struct LDKTxAddInput *NONNULL_PTR this_ptr);
	public static native long TxAddInput_get_serial_id(long this_ptr);
	// void TxAddInput_set_serial_id(struct LDKTxAddInput *NONNULL_PTR this_ptr, uint64_t val);
	public static native void TxAddInput_set_serial_id(long this_ptr, long val);
	// struct LDKTransactionU16LenLimited TxAddInput_get_prevtx(const struct LDKTxAddInput *NONNULL_PTR this_ptr);
	public static native long TxAddInput_get_prevtx(long this_ptr);
	// void TxAddInput_set_prevtx(struct LDKTxAddInput *NONNULL_PTR this_ptr, struct LDKTransactionU16LenLimited val);
	public static native void TxAddInput_set_prevtx(long this_ptr, long val);
	// uint32_t TxAddInput_get_prevtx_out(const struct LDKTxAddInput *NONNULL_PTR this_ptr);
	public static native int TxAddInput_get_prevtx_out(long this_ptr);
	// void TxAddInput_set_prevtx_out(struct LDKTxAddInput *NONNULL_PTR this_ptr, uint32_t val);
	public static native void TxAddInput_set_prevtx_out(long this_ptr, int val);
	// uint32_t TxAddInput_get_sequence(const struct LDKTxAddInput *NONNULL_PTR this_ptr);
	public static native int TxAddInput_get_sequence(long this_ptr);
	// void TxAddInput_set_sequence(struct LDKTxAddInput *NONNULL_PTR this_ptr, uint32_t val);
	public static native void TxAddInput_set_sequence(long this_ptr, int val);
	// struct LDKCOption_ThirtyTwoBytesZ TxAddInput_get_shared_input_txid(const struct LDKTxAddInput *NONNULL_PTR this_ptr);
	public static native long TxAddInput_get_shared_input_txid(long this_ptr);
	// void TxAddInput_set_shared_input_txid(struct LDKTxAddInput *NONNULL_PTR this_ptr, struct LDKCOption_ThirtyTwoBytesZ val);
	public static native void TxAddInput_set_shared_input_txid(long this_ptr, long val);
	// MUST_USE_RES struct LDKTxAddInput TxAddInput_new(struct LDKChannelId channel_id_arg, uint64_t serial_id_arg, struct LDKTransactionU16LenLimited prevtx_arg, uint32_t prevtx_out_arg, uint32_t sequence_arg, struct LDKCOption_ThirtyTwoBytesZ shared_input_txid_arg);
	public static native long TxAddInput_new(long channel_id_arg, long serial_id_arg, long prevtx_arg, int prevtx_out_arg, int sequence_arg, long shared_input_txid_arg);
	// uint64_t TxAddInput_clone_ptr(LDKTxAddInput *NONNULL_PTR arg);
	public static native long TxAddInput_clone_ptr(long arg);
	// struct LDKTxAddInput TxAddInput_clone(const struct LDKTxAddInput *NONNULL_PTR orig);
	public static native long TxAddInput_clone(long orig);
	// uint64_t TxAddInput_hash(const struct LDKTxAddInput *NONNULL_PTR o);
	public static native long TxAddInput_hash(long o);
	// bool TxAddInput_eq(const struct LDKTxAddInput *NONNULL_PTR a, const struct LDKTxAddInput *NONNULL_PTR b);
	public static native boolean TxAddInput_eq(long a, long b);
	// void TxAddOutput_free(struct LDKTxAddOutput this_obj);
	public static native void TxAddOutput_free(long this_obj);
	// struct LDKChannelId TxAddOutput_get_channel_id(const struct LDKTxAddOutput *NONNULL_PTR this_ptr);
	public static native long TxAddOutput_get_channel_id(long this_ptr);
	// void TxAddOutput_set_channel_id(struct LDKTxAddOutput *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void TxAddOutput_set_channel_id(long this_ptr, long val);
	// uint64_t TxAddOutput_get_serial_id(const struct LDKTxAddOutput *NONNULL_PTR this_ptr);
	public static native long TxAddOutput_get_serial_id(long this_ptr);
	// void TxAddOutput_set_serial_id(struct LDKTxAddOutput *NONNULL_PTR this_ptr, uint64_t val);
	public static native void TxAddOutput_set_serial_id(long this_ptr, long val);
	// uint64_t TxAddOutput_get_sats(const struct LDKTxAddOutput *NONNULL_PTR this_ptr);
	public static native long TxAddOutput_get_sats(long this_ptr);
	// void TxAddOutput_set_sats(struct LDKTxAddOutput *NONNULL_PTR this_ptr, uint64_t val);
	public static native void TxAddOutput_set_sats(long this_ptr, long val);
	// struct LDKCVec_u8Z TxAddOutput_get_script(const struct LDKTxAddOutput *NONNULL_PTR this_ptr);
	public static native byte[] TxAddOutput_get_script(long this_ptr);
	// void TxAddOutput_set_script(struct LDKTxAddOutput *NONNULL_PTR this_ptr, struct LDKCVec_u8Z val);
	public static native void TxAddOutput_set_script(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKTxAddOutput TxAddOutput_new(struct LDKChannelId channel_id_arg, uint64_t serial_id_arg, uint64_t sats_arg, struct LDKCVec_u8Z script_arg);
	public static native long TxAddOutput_new(long channel_id_arg, long serial_id_arg, long sats_arg, byte[] script_arg);
	// uint64_t TxAddOutput_clone_ptr(LDKTxAddOutput *NONNULL_PTR arg);
	public static native long TxAddOutput_clone_ptr(long arg);
	// struct LDKTxAddOutput TxAddOutput_clone(const struct LDKTxAddOutput *NONNULL_PTR orig);
	public static native long TxAddOutput_clone(long orig);
	// uint64_t TxAddOutput_hash(const struct LDKTxAddOutput *NONNULL_PTR o);
	public static native long TxAddOutput_hash(long o);
	// bool TxAddOutput_eq(const struct LDKTxAddOutput *NONNULL_PTR a, const struct LDKTxAddOutput *NONNULL_PTR b);
	public static native boolean TxAddOutput_eq(long a, long b);
	// void TxRemoveInput_free(struct LDKTxRemoveInput this_obj);
	public static native void TxRemoveInput_free(long this_obj);
	// struct LDKChannelId TxRemoveInput_get_channel_id(const struct LDKTxRemoveInput *NONNULL_PTR this_ptr);
	public static native long TxRemoveInput_get_channel_id(long this_ptr);
	// void TxRemoveInput_set_channel_id(struct LDKTxRemoveInput *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void TxRemoveInput_set_channel_id(long this_ptr, long val);
	// uint64_t TxRemoveInput_get_serial_id(const struct LDKTxRemoveInput *NONNULL_PTR this_ptr);
	public static native long TxRemoveInput_get_serial_id(long this_ptr);
	// void TxRemoveInput_set_serial_id(struct LDKTxRemoveInput *NONNULL_PTR this_ptr, uint64_t val);
	public static native void TxRemoveInput_set_serial_id(long this_ptr, long val);
	// MUST_USE_RES struct LDKTxRemoveInput TxRemoveInput_new(struct LDKChannelId channel_id_arg, uint64_t serial_id_arg);
	public static native long TxRemoveInput_new(long channel_id_arg, long serial_id_arg);
	// uint64_t TxRemoveInput_clone_ptr(LDKTxRemoveInput *NONNULL_PTR arg);
	public static native long TxRemoveInput_clone_ptr(long arg);
	// struct LDKTxRemoveInput TxRemoveInput_clone(const struct LDKTxRemoveInput *NONNULL_PTR orig);
	public static native long TxRemoveInput_clone(long orig);
	// uint64_t TxRemoveInput_hash(const struct LDKTxRemoveInput *NONNULL_PTR o);
	public static native long TxRemoveInput_hash(long o);
	// bool TxRemoveInput_eq(const struct LDKTxRemoveInput *NONNULL_PTR a, const struct LDKTxRemoveInput *NONNULL_PTR b);
	public static native boolean TxRemoveInput_eq(long a, long b);
	// void TxRemoveOutput_free(struct LDKTxRemoveOutput this_obj);
	public static native void TxRemoveOutput_free(long this_obj);
	// struct LDKChannelId TxRemoveOutput_get_channel_id(const struct LDKTxRemoveOutput *NONNULL_PTR this_ptr);
	public static native long TxRemoveOutput_get_channel_id(long this_ptr);
	// void TxRemoveOutput_set_channel_id(struct LDKTxRemoveOutput *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void TxRemoveOutput_set_channel_id(long this_ptr, long val);
	// uint64_t TxRemoveOutput_get_serial_id(const struct LDKTxRemoveOutput *NONNULL_PTR this_ptr);
	public static native long TxRemoveOutput_get_serial_id(long this_ptr);
	// void TxRemoveOutput_set_serial_id(struct LDKTxRemoveOutput *NONNULL_PTR this_ptr, uint64_t val);
	public static native void TxRemoveOutput_set_serial_id(long this_ptr, long val);
	// MUST_USE_RES struct LDKTxRemoveOutput TxRemoveOutput_new(struct LDKChannelId channel_id_arg, uint64_t serial_id_arg);
	public static native long TxRemoveOutput_new(long channel_id_arg, long serial_id_arg);
	// uint64_t TxRemoveOutput_clone_ptr(LDKTxRemoveOutput *NONNULL_PTR arg);
	public static native long TxRemoveOutput_clone_ptr(long arg);
	// struct LDKTxRemoveOutput TxRemoveOutput_clone(const struct LDKTxRemoveOutput *NONNULL_PTR orig);
	public static native long TxRemoveOutput_clone(long orig);
	// uint64_t TxRemoveOutput_hash(const struct LDKTxRemoveOutput *NONNULL_PTR o);
	public static native long TxRemoveOutput_hash(long o);
	// bool TxRemoveOutput_eq(const struct LDKTxRemoveOutput *NONNULL_PTR a, const struct LDKTxRemoveOutput *NONNULL_PTR b);
	public static native boolean TxRemoveOutput_eq(long a, long b);
	// void TxComplete_free(struct LDKTxComplete this_obj);
	public static native void TxComplete_free(long this_obj);
	// struct LDKChannelId TxComplete_get_channel_id(const struct LDKTxComplete *NONNULL_PTR this_ptr);
	public static native long TxComplete_get_channel_id(long this_ptr);
	// void TxComplete_set_channel_id(struct LDKTxComplete *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void TxComplete_set_channel_id(long this_ptr, long val);
	// MUST_USE_RES struct LDKTxComplete TxComplete_new(struct LDKChannelId channel_id_arg);
	public static native long TxComplete_new(long channel_id_arg);
	// uint64_t TxComplete_clone_ptr(LDKTxComplete *NONNULL_PTR arg);
	public static native long TxComplete_clone_ptr(long arg);
	// struct LDKTxComplete TxComplete_clone(const struct LDKTxComplete *NONNULL_PTR orig);
	public static native long TxComplete_clone(long orig);
	// uint64_t TxComplete_hash(const struct LDKTxComplete *NONNULL_PTR o);
	public static native long TxComplete_hash(long o);
	// bool TxComplete_eq(const struct LDKTxComplete *NONNULL_PTR a, const struct LDKTxComplete *NONNULL_PTR b);
	public static native boolean TxComplete_eq(long a, long b);
	// void TxSignatures_free(struct LDKTxSignatures this_obj);
	public static native void TxSignatures_free(long this_obj);
	// struct LDKChannelId TxSignatures_get_channel_id(const struct LDKTxSignatures *NONNULL_PTR this_ptr);
	public static native long TxSignatures_get_channel_id(long this_ptr);
	// void TxSignatures_set_channel_id(struct LDKTxSignatures *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void TxSignatures_set_channel_id(long this_ptr, long val);
	// const uint8_t (*TxSignatures_get_tx_hash(const struct LDKTxSignatures *NONNULL_PTR this_ptr))[32];
	public static native byte[] TxSignatures_get_tx_hash(long this_ptr);
	// void TxSignatures_set_tx_hash(struct LDKTxSignatures *NONNULL_PTR this_ptr, struct LDKThirtyTwoBytes val);
	public static native void TxSignatures_set_tx_hash(long this_ptr, byte[] val);
	// struct LDKCVec_WitnessZ TxSignatures_get_witnesses(const struct LDKTxSignatures *NONNULL_PTR this_ptr);
	public static native byte[][] TxSignatures_get_witnesses(long this_ptr);
	// void TxSignatures_set_witnesses(struct LDKTxSignatures *NONNULL_PTR this_ptr, struct LDKCVec_WitnessZ val);
	public static native void TxSignatures_set_witnesses(long this_ptr, byte[][] val);
	// struct LDKCOption_ECDSASignatureZ TxSignatures_get_shared_input_signature(const struct LDKTxSignatures *NONNULL_PTR this_ptr);
	public static native long TxSignatures_get_shared_input_signature(long this_ptr);
	// void TxSignatures_set_shared_input_signature(struct LDKTxSignatures *NONNULL_PTR this_ptr, struct LDKCOption_ECDSASignatureZ val);
	public static native void TxSignatures_set_shared_input_signature(long this_ptr, long val);
	// MUST_USE_RES struct LDKTxSignatures TxSignatures_new(struct LDKChannelId channel_id_arg, struct LDKThirtyTwoBytes tx_hash_arg, struct LDKCVec_WitnessZ witnesses_arg, struct LDKCOption_ECDSASignatureZ shared_input_signature_arg);
	public static native long TxSignatures_new(long channel_id_arg, byte[] tx_hash_arg, byte[][] witnesses_arg, long shared_input_signature_arg);
	// uint64_t TxSignatures_clone_ptr(LDKTxSignatures *NONNULL_PTR arg);
	public static native long TxSignatures_clone_ptr(long arg);
	// struct LDKTxSignatures TxSignatures_clone(const struct LDKTxSignatures *NONNULL_PTR orig);
	public static native long TxSignatures_clone(long orig);
	// uint64_t TxSignatures_hash(const struct LDKTxSignatures *NONNULL_PTR o);
	public static native long TxSignatures_hash(long o);
	// bool TxSignatures_eq(const struct LDKTxSignatures *NONNULL_PTR a, const struct LDKTxSignatures *NONNULL_PTR b);
	public static native boolean TxSignatures_eq(long a, long b);
	// void TxInitRbf_free(struct LDKTxInitRbf this_obj);
	public static native void TxInitRbf_free(long this_obj);
	// struct LDKChannelId TxInitRbf_get_channel_id(const struct LDKTxInitRbf *NONNULL_PTR this_ptr);
	public static native long TxInitRbf_get_channel_id(long this_ptr);
	// void TxInitRbf_set_channel_id(struct LDKTxInitRbf *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void TxInitRbf_set_channel_id(long this_ptr, long val);
	// uint32_t TxInitRbf_get_locktime(const struct LDKTxInitRbf *NONNULL_PTR this_ptr);
	public static native int TxInitRbf_get_locktime(long this_ptr);
	// void TxInitRbf_set_locktime(struct LDKTxInitRbf *NONNULL_PTR this_ptr, uint32_t val);
	public static native void TxInitRbf_set_locktime(long this_ptr, int val);
	// uint32_t TxInitRbf_get_feerate_sat_per_1000_weight(const struct LDKTxInitRbf *NONNULL_PTR this_ptr);
	public static native int TxInitRbf_get_feerate_sat_per_1000_weight(long this_ptr);
	// void TxInitRbf_set_feerate_sat_per_1000_weight(struct LDKTxInitRbf *NONNULL_PTR this_ptr, uint32_t val);
	public static native void TxInitRbf_set_feerate_sat_per_1000_weight(long this_ptr, int val);
	// struct LDKCOption_i64Z TxInitRbf_get_funding_output_contribution(const struct LDKTxInitRbf *NONNULL_PTR this_ptr);
	public static native long TxInitRbf_get_funding_output_contribution(long this_ptr);
	// void TxInitRbf_set_funding_output_contribution(struct LDKTxInitRbf *NONNULL_PTR this_ptr, struct LDKCOption_i64Z val);
	public static native void TxInitRbf_set_funding_output_contribution(long this_ptr, long val);
	// MUST_USE_RES struct LDKTxInitRbf TxInitRbf_new(struct LDKChannelId channel_id_arg, uint32_t locktime_arg, uint32_t feerate_sat_per_1000_weight_arg, struct LDKCOption_i64Z funding_output_contribution_arg);
	public static native long TxInitRbf_new(long channel_id_arg, int locktime_arg, int feerate_sat_per_1000_weight_arg, long funding_output_contribution_arg);
	// uint64_t TxInitRbf_clone_ptr(LDKTxInitRbf *NONNULL_PTR arg);
	public static native long TxInitRbf_clone_ptr(long arg);
	// struct LDKTxInitRbf TxInitRbf_clone(const struct LDKTxInitRbf *NONNULL_PTR orig);
	public static native long TxInitRbf_clone(long orig);
	// uint64_t TxInitRbf_hash(const struct LDKTxInitRbf *NONNULL_PTR o);
	public static native long TxInitRbf_hash(long o);
	// bool TxInitRbf_eq(const struct LDKTxInitRbf *NONNULL_PTR a, const struct LDKTxInitRbf *NONNULL_PTR b);
	public static native boolean TxInitRbf_eq(long a, long b);
	// void TxAckRbf_free(struct LDKTxAckRbf this_obj);
	public static native void TxAckRbf_free(long this_obj);
	// struct LDKChannelId TxAckRbf_get_channel_id(const struct LDKTxAckRbf *NONNULL_PTR this_ptr);
	public static native long TxAckRbf_get_channel_id(long this_ptr);
	// void TxAckRbf_set_channel_id(struct LDKTxAckRbf *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void TxAckRbf_set_channel_id(long this_ptr, long val);
	// struct LDKCOption_i64Z TxAckRbf_get_funding_output_contribution(const struct LDKTxAckRbf *NONNULL_PTR this_ptr);
	public static native long TxAckRbf_get_funding_output_contribution(long this_ptr);
	// void TxAckRbf_set_funding_output_contribution(struct LDKTxAckRbf *NONNULL_PTR this_ptr, struct LDKCOption_i64Z val);
	public static native void TxAckRbf_set_funding_output_contribution(long this_ptr, long val);
	// MUST_USE_RES struct LDKTxAckRbf TxAckRbf_new(struct LDKChannelId channel_id_arg, struct LDKCOption_i64Z funding_output_contribution_arg);
	public static native long TxAckRbf_new(long channel_id_arg, long funding_output_contribution_arg);
	// uint64_t TxAckRbf_clone_ptr(LDKTxAckRbf *NONNULL_PTR arg);
	public static native long TxAckRbf_clone_ptr(long arg);
	// struct LDKTxAckRbf TxAckRbf_clone(const struct LDKTxAckRbf *NONNULL_PTR orig);
	public static native long TxAckRbf_clone(long orig);
	// uint64_t TxAckRbf_hash(const struct LDKTxAckRbf *NONNULL_PTR o);
	public static native long TxAckRbf_hash(long o);
	// bool TxAckRbf_eq(const struct LDKTxAckRbf *NONNULL_PTR a, const struct LDKTxAckRbf *NONNULL_PTR b);
	public static native boolean TxAckRbf_eq(long a, long b);
	// void TxAbort_free(struct LDKTxAbort this_obj);
	public static native void TxAbort_free(long this_obj);
	// struct LDKChannelId TxAbort_get_channel_id(const struct LDKTxAbort *NONNULL_PTR this_ptr);
	public static native long TxAbort_get_channel_id(long this_ptr);
	// void TxAbort_set_channel_id(struct LDKTxAbort *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void TxAbort_set_channel_id(long this_ptr, long val);
	// struct LDKCVec_u8Z TxAbort_get_data(const struct LDKTxAbort *NONNULL_PTR this_ptr);
	public static native byte[] TxAbort_get_data(long this_ptr);
	// void TxAbort_set_data(struct LDKTxAbort *NONNULL_PTR this_ptr, struct LDKCVec_u8Z val);
	public static native void TxAbort_set_data(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKTxAbort TxAbort_new(struct LDKChannelId channel_id_arg, struct LDKCVec_u8Z data_arg);
	public static native long TxAbort_new(long channel_id_arg, byte[] data_arg);
	// uint64_t TxAbort_clone_ptr(LDKTxAbort *NONNULL_PTR arg);
	public static native long TxAbort_clone_ptr(long arg);
	// struct LDKTxAbort TxAbort_clone(const struct LDKTxAbort *NONNULL_PTR orig);
	public static native long TxAbort_clone(long orig);
	// uint64_t TxAbort_hash(const struct LDKTxAbort *NONNULL_PTR o);
	public static native long TxAbort_hash(long o);
	// bool TxAbort_eq(const struct LDKTxAbort *NONNULL_PTR a, const struct LDKTxAbort *NONNULL_PTR b);
	public static native boolean TxAbort_eq(long a, long b);
	// void Shutdown_free(struct LDKShutdown this_obj);
	public static native void Shutdown_free(long this_obj);
	// struct LDKChannelId Shutdown_get_channel_id(const struct LDKShutdown *NONNULL_PTR this_ptr);
	public static native long Shutdown_get_channel_id(long this_ptr);
	// void Shutdown_set_channel_id(struct LDKShutdown *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void Shutdown_set_channel_id(long this_ptr, long val);
	// struct LDKCVec_u8Z Shutdown_get_scriptpubkey(const struct LDKShutdown *NONNULL_PTR this_ptr);
	public static native byte[] Shutdown_get_scriptpubkey(long this_ptr);
	// void Shutdown_set_scriptpubkey(struct LDKShutdown *NONNULL_PTR this_ptr, struct LDKCVec_u8Z val);
	public static native void Shutdown_set_scriptpubkey(long this_ptr, byte[] val);
	// MUST_USE_RES struct LDKShutdown Shutdown_new(struct LDKChannelId channel_id_arg, struct LDKCVec_u8Z scriptpubkey_arg);
	public static native long Shutdown_new(long channel_id_arg, byte[] scriptpubkey_arg);
	// uint64_t Shutdown_clone_ptr(LDKShutdown *NONNULL_PTR arg);
	public static native long Shutdown_clone_ptr(long arg);
	// struct LDKShutdown Shutdown_clone(const struct LDKShutdown *NONNULL_PTR orig);
	public static native long Shutdown_clone(long orig);
	// uint64_t Shutdown_hash(const struct LDKShutdown *NONNULL_PTR o);
	public static native long Shutdown_hash(long o);
	// bool Shutdown_eq(const struct LDKShutdown *NONNULL_PTR a, const struct LDKShutdown *NONNULL_PTR b);
	public static native boolean Shutdown_eq(long a, long b);
	// void ClosingSignedFeeRange_free(struct LDKClosingSignedFeeRange this_obj);
	public static native void ClosingSignedFeeRange_free(long this_obj);
	// uint64_t ClosingSignedFeeRange_get_min_fee_satoshis(const struct LDKClosingSignedFeeRange *NONNULL_PTR this_ptr);
	public static native long ClosingSignedFeeRange_get_min_fee_satoshis(long this_ptr);
	// void ClosingSignedFeeRange_set_min_fee_satoshis(struct LDKClosingSignedFeeRange *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ClosingSignedFeeRange_set_min_fee_satoshis(long this_ptr, long val);
	// uint64_t ClosingSignedFeeRange_get_max_fee_satoshis(const struct LDKClosingSignedFeeRange *NONNULL_PTR this_ptr);
	public static native long ClosingSignedFeeRange_get_max_fee_satoshis(long this_ptr);
	// void ClosingSignedFeeRange_set_max_fee_satoshis(struct LDKClosingSignedFeeRange *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ClosingSignedFeeRange_set_max_fee_satoshis(long this_ptr, long val);
	// MUST_USE_RES struct LDKClosingSignedFeeRange ClosingSignedFeeRange_new(uint64_t min_fee_satoshis_arg, uint64_t max_fee_satoshis_arg);
	public static native long ClosingSignedFeeRange_new(long min_fee_satoshis_arg, long max_fee_satoshis_arg);
	// uint64_t ClosingSignedFeeRange_clone_ptr(LDKClosingSignedFeeRange *NONNULL_PTR arg);
	public static native long ClosingSignedFeeRange_clone_ptr(long arg);
	// struct LDKClosingSignedFeeRange ClosingSignedFeeRange_clone(const struct LDKClosingSignedFeeRange *NONNULL_PTR orig);
	public static native long ClosingSignedFeeRange_clone(long orig);
	// uint64_t ClosingSignedFeeRange_hash(const struct LDKClosingSignedFeeRange *NONNULL_PTR o);
	public static native long ClosingSignedFeeRange_hash(long o);
	// bool ClosingSignedFeeRange_eq(const struct LDKClosingSignedFeeRange *NONNULL_PTR a, const struct LDKClosingSignedFeeRange *NONNULL_PTR b);
	public static native boolean ClosingSignedFeeRange_eq(long a, long b);
	// void ClosingSigned_free(struct LDKClosingSigned this_obj);
	public static native void ClosingSigned_free(long this_obj);
	// struct LDKChannelId ClosingSigned_get_channel_id(const struct LDKClosingSigned *NONNULL_PTR this_ptr);
	public static native long ClosingSigned_get_channel_id(long this_ptr);
	// void ClosingSigned_set_channel_id(struct LDKClosingSigned *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void ClosingSigned_set_channel_id(long this_ptr, long val);
	// uint64_t ClosingSigned_get_fee_satoshis(const struct LDKClosingSigned *NONNULL_PTR this_ptr);
	public static native long ClosingSigned_get_fee_satoshis(long this_ptr);
	// void ClosingSigned_set_fee_satoshis(struct LDKClosingSigned *NONNULL_PTR this_ptr, uint64_t val);
	public static native void ClosingSigned_set_fee_satoshis(long this_ptr, long val);
	// struct LDKECDSASignature ClosingSigned_get_signature(const struct LDKClosingSigned *NONNULL_PTR this_ptr);
	public static native byte[] ClosingSigned_get_signature(long this_ptr);
	// void ClosingSigned_set_signature(struct LDKClosingSigned *NONNULL_PTR this_ptr, struct LDKECDSASignature val);
	public static native void ClosingSigned_set_signature(long this_ptr, byte[] val);
	// struct LDKClosingSignedFeeRange ClosingSigned_get_fee_range(const struct LDKClosingSigned *NONNULL_PTR this_ptr);
	public static native long ClosingSigned_get_fee_range(long this_ptr);
	// void ClosingSigned_set_fee_range(struct LDKClosingSigned *NONNULL_PTR this_ptr, struct LDKClosingSignedFeeRange val);
	public static native void ClosingSigned_set_fee_range(long this_ptr, long val);
	// MUST_USE_RES struct LDKClosingSigned ClosingSigned_new(struct LDKChannelId channel_id_arg, uint64_t fee_satoshis_arg, struct LDKECDSASignature signature_arg, struct LDKClosingSignedFeeRange fee_range_arg);
	public static native long ClosingSigned_new(long channel_id_arg, long fee_satoshis_arg, byte[] signature_arg, long fee_range_arg);
	// uint64_t ClosingSigned_clone_ptr(LDKClosingSigned *NONNULL_PTR arg);
	public static native long ClosingSigned_clone_ptr(long arg);
	// struct LDKClosingSigned ClosingSigned_clone(const struct LDKClosingSigned *NONNULL_PTR orig);
	public static native long ClosingSigned_clone(long orig);
	// uint64_t ClosingSigned_hash(const struct LDKClosingSigned *NONNULL_PTR o);
	public static native long ClosingSigned_hash(long o);
	// bool ClosingSigned_eq(const struct LDKClosingSigned *NONNULL_PTR a, const struct LDKClosingSigned *NONNULL_PTR b);
	public static native boolean ClosingSigned_eq(long a, long b);
	// void UpdateAddHTLC_free(struct LDKUpdateAddHTLC this_obj);
	public static native void UpdateAddHTLC_free(long this_obj);
	// struct LDKChannelId UpdateAddHTLC_get_channel_id(const struct LDKUpdateAddHTLC *NONNULL_PTR this_ptr);
	public static native long UpdateAddHTLC_get_channel_id(long this_ptr);
	// void UpdateAddHTLC_set_channel_id(struct LDKUpdateAddHTLC *NONNULL_PTR this_ptr, struct LDKChannelId val);
	public static native void UpdateAddHTLC_set_channel_id(long this_ptr, long val);
	// uint64_t UpdateAddHTLC_get_htlc_id(const struct LDKUpdateAddHTLC *NONNULL_PTR this_ptr);
	public static native long UpdateAddHTLC_get_htlc_id(long this_pt