package org.ldk.structs;

import org.ldk.impl.bindings;
import org.ldk.enums.*;
import org.ldk.util.*;
import java.util.Arrays;
import java.lang.ref.Reference;
import javax.annotation.Nullable;


/**
 * An update generated by the underlying channel itself which contains some new information the
 * [`ChannelMonitor`] should be made aware of.
 * 
 * Because this represents only a small number of updates to the underlying state, it is generally
 * much smaller than a full [`ChannelMonitor`]. However, for large single commitment transaction
 * updates (e.g. ones during which there are hundreds of HTLCs pending on the commitment
 * transaction), a single update may reach upwards of 1 MiB in serialized size.
 */
@SuppressWarnings("unchecked") // We correctly assign various generic arrays
public class ChannelMonitorUpdate extends CommonBase {
	ChannelMonitorUpdate(Object _dummy, long ptr) { super(ptr); }
	@Override @SuppressWarnings("deprecation")
	protected void finalize() throws Throwable {
		super.finalize();
		if (ptr != 0) { bindings.ChannelMonitorUpdate_free(ptr); }
	}

	/**
	 * The sequence number of this update. Updates *must* be replayed in-order according to this
	 * sequence number (and updates may panic if they are not). The update_id values are strictly
	 * increasing and increase by one for each new update, with two exceptions specified below.
	 * 
	 * This sequence number is also used to track up to which points updates which returned
	 * [`ChannelMonitorUpdateStatus::InProgress`] have been applied to all copies of a given
	 * ChannelMonitor when ChannelManager::channel_monitor_updated is called.
	 * 
	 * Note that for [`ChannelMonitorUpdate`]s generated on LDK versions prior to 0.1 after the
	 * channel was closed, this value may be [`u64::MAX`]. In that case, multiple updates may
	 * appear with the same ID, and all should be replayed.
	 * 
	 * [`ChannelMonitorUpdateStatus::InProgress`]: super::ChannelMonitorUpdateStatus::InProgress
	 */
	public long get_update_id() {
		long ret = bindings.ChannelMonitorUpdate_get_update_id(this.ptr);
		Reference.reachabilityFence(this);
		return ret;
	}

	/**
	 * The sequence number of this update. Updates *must* be replayed in-order according to this
	 * sequence number (and updates may panic if they are not). The update_id values are strictly
	 * increasing and increase by one for each new update, with two exceptions specified below.
	 * 
	 * This sequence number is also used to track up to which points updates which returned
	 * [`ChannelMonitorUpdateStatus::InProgress`] have been applied to all copies of a given
	 * ChannelMonitor when ChannelManager::channel_monitor_updated is called.
	 * 
	 * Note that for [`ChannelMonitorUpdate`]s generated on LDK versions prior to 0.1 after the
	 * channel was closed, this value may be [`u64::MAX`]. In that case, multiple updates may
	 * appear with the same ID, and all should be replayed.
	 * 
	 * [`ChannelMonitorUpdateStatus::InProgress`]: super::ChannelMonitorUpdateStatus::InProgress
	 */
	public void set_update_id(long val) {
		bindings.ChannelMonitorUpdate_set_update_id(this.ptr, val);
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(val);
	}

	/**
	 * The channel ID associated with these updates.
	 * 
	 * Will be `None` for `ChannelMonitorUpdate`s constructed on LDK versions prior to 0.0.121 and
	 * always `Some` otherwise.
	 * 
	 * Note that the return value (or a relevant inner pointer) may be NULL or all-0s to represent None
	 */
	@Nullable
	public ChannelId get_channel_id() {
		long ret = bindings.ChannelMonitorUpdate_get_channel_id(this.ptr);
		Reference.reachabilityFence(this);
		if (ret >= 0 && ret <= 4096) { return null; }
		org.ldk.structs.ChannelId ret_hu_conv = null; if (ret < 0 || ret > 4096) { ret_hu_conv = new org.ldk.structs.ChannelId(null, ret); }
		if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(this); };
		return ret_hu_conv;
	}

	/**
	 * The channel ID associated with these updates.
	 * 
	 * Will be `None` for `ChannelMonitorUpdate`s constructed on LDK versions prior to 0.0.121 and
	 * always `Some` otherwise.
	 * 
	 * Note that val (or a relevant inner pointer) may be NULL or all-0s to represent None
	 */
	public void set_channel_id(@Nullable org.ldk.structs.ChannelId val) {
		bindings.ChannelMonitorUpdate_set_channel_id(this.ptr, val == null ? 0 : val.ptr);
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(val);
	}

	long clone_ptr() {
		long ret = bindings.ChannelMonitorUpdate_clone_ptr(this.ptr);
		Reference.reachabilityFence(this);
		return ret;
	}

	/**
	 * Creates a copy of the ChannelMonitorUpdate
	 */
	public ChannelMonitorUpdate clone() {
		long ret = bindings.ChannelMonitorUpdate_clone(this.ptr);
		Reference.reachabilityFence(this);
		if (ret >= 0 && ret <= 4096) { return null; }
		org.ldk.structs.ChannelMonitorUpdate ret_hu_conv = null; if (ret < 0 || ret > 4096) { ret_hu_conv = new org.ldk.structs.ChannelMonitorUpdate(null, ret); }
		if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(this); };
		return ret_hu_conv;
	}

	/**
	 * Checks if two ChannelMonitorUpdates contain equal inner contents.
	 * This ignores pointers and is_owned flags and looks at the values in fields.
	 * Two objects with NULL inner values will be considered "equal" here.
	 */
	public boolean eq(org.ldk.structs.ChannelMonitorUpdate b) {
		boolean ret = bindings.ChannelMonitorUpdate_eq(this.ptr, b.ptr);
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(b);
		if (this != null) { this.ptrs_to.add(b); };
		return ret;
	}

	@Override public boolean equals(Object o) {
		if (!(o instanceof ChannelMonitorUpdate)) return false;
		return this.eq((ChannelMonitorUpdate)o);
	}
	/**
	 * Serialize the ChannelMonitorUpdate object into a byte array which can be read by ChannelMonitorUpdate_read
	 */
	public byte[] write() {
		byte[] ret = bindings.ChannelMonitorUpdate_write(this.ptr);
		Reference.reachabilityFence(this);
		return ret;
	}

	/**
	 * Read a ChannelMonitorUpdate from a byte array, created by ChannelMonitorUpdate_write
	 */
	public static Result_ChannelMonitorUpdateDecodeErrorZ read(byte[] ser) {
		long ret = bindings.ChannelMonitorUpdate_read(ser);
		Reference.reachabilityFence(ser);
		if (ret >= 0 && ret <= 4096) { return null; }
		Result_ChannelMonitorUpdateDecodeErrorZ ret_hu_conv = Result_ChannelMonitorUpdateDecodeErrorZ.constr_from_ptr(ret);
		return ret_hu_conv;
	}

}
