package org.ldk.structs;

import org.ldk.impl.bindings;
import org.ldk.enums.*;
import org.ldk.util.*;
import java.util.Arrays;
import java.lang.ref.Reference;
import javax.annotation.Nullable;


/**
 * One counterparty's public keys which do not change over the life of a channel.
 */
@SuppressWarnings("unchecked") // We correctly assign various generic arrays
public class ChannelPublicKeys extends CommonBase {
	ChannelPublicKeys(Object _dummy, long ptr) { super(ptr); }
	@Override @SuppressWarnings("deprecation")
	protected void finalize() throws Throwable {
		super.finalize();
		if (ptr != 0) { bindings.ChannelPublicKeys_free(ptr); }
	}

	/**
	 * The public key which is used to sign all commitment transactions, as it appears in the
	 * on-chain channel lock-in 2-of-2 multisig output.
	 */
	public byte[] get_funding_pubkey() {
		byte[] ret = bindings.ChannelPublicKeys_get_funding_pubkey(this.ptr);
		Reference.reachabilityFence(this);
		return ret;
	}

	/**
	 * The public key which is used to sign all commitment transactions, as it appears in the
	 * on-chain channel lock-in 2-of-2 multisig output.
	 */
	public void set_funding_pubkey(byte[] val) {
		bindings.ChannelPublicKeys_set_funding_pubkey(this.ptr, InternalUtils.check_arr_len(val, 33));
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(val);
	}

	/**
	 * The base point which is used (with [`RevocationKey::from_basepoint`]) to derive per-commitment
	 * revocation keys. This is combined with the per-commitment-secret generated by the
	 * counterparty to create a secret which the counterparty can reveal to revoke previous
	 * states.
	 */
	public RevocationBasepoint get_revocation_basepoint() {
		long ret = bindings.ChannelPublicKeys_get_revocation_basepoint(this.ptr);
		Reference.reachabilityFence(this);
		if (ret >= 0 && ret <= 4096) { return null; }
		org.ldk.structs.RevocationBasepoint ret_hu_conv = null; if (ret < 0 || ret > 4096) { ret_hu_conv = new org.ldk.structs.RevocationBasepoint(null, ret); }
		if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(this); };
		return ret_hu_conv;
	}

	/**
	 * The base point which is used (with [`RevocationKey::from_basepoint`]) to derive per-commitment
	 * revocation keys. This is combined with the per-commitment-secret generated by the
	 * counterparty to create a secret which the counterparty can reveal to revoke previous
	 * states.
	 */
	public void set_revocation_basepoint(org.ldk.structs.RevocationBasepoint val) {
		bindings.ChannelPublicKeys_set_revocation_basepoint(this.ptr, val.ptr);
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(val);
	}

	/**
	 * The public key on which the non-broadcaster (ie the countersignatory) receives an immediately
	 * spendable primary channel balance on the broadcaster's commitment transaction. This key is
	 * static across every commitment transaction.
	 */
	public byte[] get_payment_point() {
		byte[] ret = bindings.ChannelPublicKeys_get_payment_point(this.ptr);
		Reference.reachabilityFence(this);
		return ret;
	}

	/**
	 * The public key on which the non-broadcaster (ie the countersignatory) receives an immediately
	 * spendable primary channel balance on the broadcaster's commitment transaction. This key is
	 * static across every commitment transaction.
	 */
	public void set_payment_point(byte[] val) {
		bindings.ChannelPublicKeys_set_payment_point(this.ptr, InternalUtils.check_arr_len(val, 33));
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(val);
	}

	/**
	 * The base point which is used (with derive_public_key) to derive a per-commitment payment
	 * public key which receives non-HTLC-encumbered funds which are only available for spending
	 * after some delay (or can be claimed via the revocation path).
	 */
	public DelayedPaymentBasepoint get_delayed_payment_basepoint() {
		long ret = bindings.ChannelPublicKeys_get_delayed_payment_basepoint(this.ptr);
		Reference.reachabilityFence(this);
		if (ret >= 0 && ret <= 4096) { return null; }
		org.ldk.structs.DelayedPaymentBasepoint ret_hu_conv = null; if (ret < 0 || ret > 4096) { ret_hu_conv = new org.ldk.structs.DelayedPaymentBasepoint(null, ret); }
		if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(this); };
		return ret_hu_conv;
	}

	/**
	 * The base point which is used (with derive_public_key) to derive a per-commitment payment
	 * public key which receives non-HTLC-encumbered funds which are only available for spending
	 * after some delay (or can be claimed via the revocation path).
	 */
	public void set_delayed_payment_basepoint(org.ldk.structs.DelayedPaymentBasepoint val) {
		bindings.ChannelPublicKeys_set_delayed_payment_basepoint(this.ptr, val.ptr);
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(val);
	}

	/**
	 * The base point which is used (with derive_public_key) to derive a per-commitment public key
	 * which is used to encumber HTLC-in-flight outputs.
	 */
	public HtlcBasepoint get_htlc_basepoint() {
		long ret = bindings.ChannelPublicKeys_get_htlc_basepoint(this.ptr);
		Reference.reachabilityFence(this);
		if (ret >= 0 && ret <= 4096) { return null; }
		org.ldk.structs.HtlcBasepoint ret_hu_conv = null; if (ret < 0 || ret > 4096) { ret_hu_conv = new org.ldk.structs.HtlcBasepoint(null, ret); }
		if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(this); };
		return ret_hu_conv;
	}

	/**
	 * The base point which is used (with derive_public_key) to derive a per-commitment public key
	 * which is used to encumber HTLC-in-flight outputs.
	 */
	public void set_htlc_basepoint(org.ldk.structs.HtlcBasepoint val) {
		bindings.ChannelPublicKeys_set_htlc_basepoint(this.ptr, val.ptr);
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(val);
	}

	/**
	 * Constructs a new ChannelPublicKeys given each field
	 */
	public static ChannelPublicKeys of(byte[] funding_pubkey_arg, org.ldk.structs.RevocationBasepoint revocation_basepoint_arg, byte[] payment_point_arg, org.ldk.structs.DelayedPaymentBasepoint delayed_payment_basepoint_arg, org.ldk.structs.HtlcBasepoint htlc_basepoint_arg) {
		long ret = bindings.ChannelPublicKeys_new(InternalUtils.check_arr_len(funding_pubkey_arg, 33), revocation_basepoint_arg.ptr, InternalUtils.check_arr_len(payment_point_arg, 33), delayed_payment_basepoint_arg.ptr, htlc_basepoint_arg.ptr);
		Reference.reachabilityFence(funding_pubkey_arg);
		Reference.reachabilityFence(revocation_basepoint_arg);
		Reference.reachabilityFence(payment_point_arg);
		Reference.reachabilityFence(delayed_payment_basepoint_arg);
		Reference.reachabilityFence(htlc_basepoint_arg);
		if (ret >= 0 && ret <= 4096) { return null; }
		org.ldk.structs.ChannelPublicKeys ret_hu_conv = null; if (ret < 0 || ret > 4096) { ret_hu_conv = new org.ldk.structs.ChannelPublicKeys(null, ret); }
		if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(ret_hu_conv); };
		return ret_hu_conv;
	}

	long clone_ptr() {
		long ret = bindings.ChannelPublicKeys_clone_ptr(this.ptr);
		Reference.reachabilityFence(this);
		return ret;
	}

	/**
	 * Creates a copy of the ChannelPublicKeys
	 */
	public ChannelPublicKeys clone() {
		long ret = bindings.ChannelPublicKeys_clone(this.ptr);
		Reference.reachabilityFence(this);
		if (ret >= 0 && ret <= 4096) { return null; }
		org.ldk.structs.ChannelPublicKeys ret_hu_conv = null; if (ret < 0 || ret > 4096) { ret_hu_conv = new org.ldk.structs.ChannelPublicKeys(null, ret); }
		if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(this); };
		return ret_hu_conv;
	}

	/**
	 * Generates a non-cryptographic 64-bit hash of the ChannelPublicKeys.
	 */
	public long hash() {
		long ret = bindings.ChannelPublicKeys_hash(this.ptr);
		Reference.reachabilityFence(this);
		return ret;
	}

	@Override public int hashCode() {
		return (int)this.hash();
	}
	/**
	 * Checks if two ChannelPublicKeyss contain equal inner contents.
	 * This ignores pointers and is_owned flags and looks at the values in fields.
	 * Two objects with NULL inner values will be considered "equal" here.
	 */
	public boolean eq(org.ldk.structs.ChannelPublicKeys b) {
		boolean ret = bindings.ChannelPublicKeys_eq(this.ptr, b.ptr);
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(b);
		if (this != null) { this.ptrs_to.add(b); };
		return ret;
	}

	@Override public boolean equals(Object o) {
		if (!(o instanceof ChannelPublicKeys)) return false;
		return this.eq((ChannelPublicKeys)o);
	}
	/**
	 * Serialize the ChannelPublicKeys object into a byte array which can be read by ChannelPublicKeys_read
	 */
	public byte[] write() {
		byte[] ret = bindings.ChannelPublicKeys_write(this.ptr);
		Reference.reachabilityFence(this);
		return ret;
	}

	/**
	 * Read a ChannelPublicKeys from a byte array, created by ChannelPublicKeys_write
	 */
	public static Result_ChannelPublicKeysDecodeErrorZ read(byte[] ser) {
		long ret = bindings.ChannelPublicKeys_read(ser);
		Reference.reachabilityFence(ser);
		if (ret >= 0 && ret <= 4096) { return null; }
		Result_ChannelPublicKeysDecodeErrorZ ret_hu_conv = Result_ChannelPublicKeysDecodeErrorZ.constr_from_ptr(ret);
		return ret_hu_conv;
	}

}
