package org.ldk.structs;

import org.ldk.impl.bindings;
import org.ldk.enums.*;
import org.ldk.util.*;
import java.util.Arrays;
import java.lang.ref.Reference;
import javax.annotation.Nullable;

/**
 * A handler provided to [`PeerManager`] for reading and handling custom messages.
 * 
 * [BOLT 1] specifies a custom message type range for use with experimental or application-specific
 * messages. `CustomMessageHandler` allows for user-defined handling of such types. See the
 * [`lightning_custom_message`] crate for tools useful in composing more than one custom handler.
 * 
 * [BOLT 1]: https://github.com/lightning/bolts/blob/master/01-messaging.md
 * [`lightning_custom_message`]: https://docs.rs/lightning_custom_message/latest/lightning_custom_message
 */
@SuppressWarnings("unchecked") // We correctly assign various generic arrays
public class CustomMessageHandler extends CommonBase {
	final bindings.LDKCustomMessageHandler bindings_instance;
	CustomMessageHandler(Object _dummy, long ptr) { super(ptr); bindings_instance = null; }
	private CustomMessageHandler(bindings.LDKCustomMessageHandler arg, bindings.LDKCustomMessageReader CustomMessageReader) {
		super(bindings.LDKCustomMessageHandler_new(arg, CustomMessageReader));
		this.ptrs_to.add(arg);
		this.ptrs_to.add(CustomMessageReader);
		this.bindings_instance = arg;
	}
	@Override @SuppressWarnings("deprecation")
	protected void finalize() throws Throwable {
		if (ptr != 0) { bindings.CustomMessageHandler_free(ptr); } super.finalize();
	}
	/**
	 * Destroys the object, freeing associated resources. After this call, any access
	 * to this object may result in a SEGFAULT or worse.
	 *
	 * You should generally NEVER call this method. You should let the garbage collector
	 * do this for you when it finalizes objects. However, it may be useful for types
	 * which represent locks and should be closed immediately to avoid holding locks
	 * until the GC runs.
	 */
	public void destroy() {
		if (ptr != 0) { bindings.CustomMessageHandler_free(ptr); }
		ptr = 0;
	}
	public static interface CustomMessageHandlerInterface {
		/**
		 * Handles the given message sent from `sender_node_id`, possibly producing messages for
		 * [`CustomMessageHandler::get_and_clear_pending_msg`] to return and thus for [`PeerManager`]
		 * to send.
		 */
		Result_NoneLightningErrorZ handle_custom_message(Type msg, byte[] sender_node_id);
		/**
		 * Returns the list of pending messages that were generated by the handler, clearing the list
		 * in the process. Each message is paired with the node id of the intended recipient. If no
		 * connection to the node exists, then the message is simply not sent.
		 */
		TwoTuple_PublicKeyTypeZ[] get_and_clear_pending_msg();
		/**
		 * Indicates a peer disconnected.
		 */
		void peer_disconnected(byte[] their_node_id);
		/**
		 * Handle a peer connecting.
		 * 
		 * May return an `Err(())` if the features the peer supports are not sufficient to communicate
		 * with us. Implementors should be somewhat conservative about doing so, however, as other
		 * message handlers may still wish to communicate with this peer.
		 * 
		 * [`Self::peer_disconnected`] will not be called if `Err(())` is returned.
		 */
		Result_NoneNoneZ peer_connected(byte[] their_node_id, Init msg, boolean inbound);
		/**
		 * Gets the node feature flags which this handler itself supports. All available handlers are
		 * queried similarly and their feature flags are OR'd together to form the [`NodeFeatures`]
		 * which are broadcasted in our [`NodeAnnouncement`] message.
		 * 
		 * [`NodeAnnouncement`]: crate::ln::msgs::NodeAnnouncement
		 */
		NodeFeatures provided_node_features();
		/**
		 * Gets the init feature flags which should be sent to the given peer. All available handlers
		 * are queried similarly and their feature flags are OR'd together to form the [`InitFeatures`]
		 * which are sent in our [`Init`] message.
		 * 
		 * [`Init`]: crate::ln::msgs::Init
		 */
		InitFeatures provided_init_features(byte[] their_node_id);
	}
	private static class LDKCustomMessageHandlerHolder { CustomMessageHandler held; }
	public static CustomMessageHandler new_impl(CustomMessageHandlerInterface arg, CustomMessageReader.CustomMessageReaderInterface CustomMessageReader_impl) {
		final LDKCustomMessageHandlerHolder impl_holder = new LDKCustomMessageHandlerHolder();
		impl_holder.held = new CustomMessageHandler(new bindings.LDKCustomMessageHandler() {
			@Override public long handle_custom_message(long msg, byte[] sender_node_id) {
				Type ret_hu_conv = new Type(null, msg);
				if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(this); };
				Result_NoneLightningErrorZ ret = arg.handle_custom_message(ret_hu_conv, sender_node_id);
				Reference.reachabilityFence(arg);
				long result = ret.clone_ptr();
				return result;
			}
			@Override public long[] get_and_clear_pending_msg() {
				TwoTuple_PublicKeyTypeZ[] ret = arg.get_and_clear_pending_msg();
				Reference.reachabilityFence(arg);
				long[] result = ret != null ? Arrays.stream(ret).mapToLong(ret_conv_25 -> ret_conv_25.clone_ptr()).toArray() : null;
				return result;
			}
			@Override public void peer_disconnected(byte[] their_node_id) {
				arg.peer_disconnected(their_node_id);
				Reference.reachabilityFence(arg);
			}
			@Override public long peer_connected(byte[] their_node_id, long msg, boolean inbound) {
				org.ldk.structs.Init msg_hu_conv = null; if (msg < 0 || msg > 4096) { msg_hu_conv = new org.ldk.structs.Init(null, msg); }
				Result_NoneNoneZ ret = arg.peer_connected(their_node_id, msg_hu_conv, inbound);
				Reference.reachabilityFence(arg);
				long result = ret.clone_ptr();
				return result;
			}
			@Override public long provided_node_features() {
				NodeFeatures ret = arg.provided_node_features();
				Reference.reachabilityFence(arg);
				long result = ret.clone_ptr();
				return result;
			}
			@Override public long provided_init_features(byte[] their_node_id) {
				InitFeatures ret = arg.provided_init_features(their_node_id);
				Reference.reachabilityFence(arg);
				long result = ret.clone_ptr();
				return result;
			}
		}, CustomMessageReader.new_impl(CustomMessageReader_impl).bindings_instance);
		return impl_holder.held;
	}

	/**
	 * Gets the underlying CustomMessageReader.
	 */
	public CustomMessageReader get_custom_message_reader() {
		CustomMessageReader res = new CustomMessageReader(null, bindings.LDKCustomMessageHandler_get_CustomMessageReader(this.ptr));
		res.ptrs_to.add(this);
		return res;
	}

	/**
	 * Handles the given message sent from `sender_node_id`, possibly producing messages for
	 * [`CustomMessageHandler::get_and_clear_pending_msg`] to return and thus for [`PeerManager`]
	 * to send.
	 */
	public Result_NoneLightningErrorZ handle_custom_message(org.ldk.structs.Type msg, byte[] sender_node_id) {
		long ret = bindings.CustomMessageHandler_handle_custom_message(this.ptr, msg.ptr, InternalUtils.check_arr_len(sender_node_id, 33));
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(msg);
		Reference.reachabilityFence(sender_node_id);
		if (ret >= 0 && ret <= 4096) { return null; }
		Result_NoneLightningErrorZ ret_hu_conv = Result_NoneLightningErrorZ.constr_from_ptr(ret);
		if (this != null) { this.ptrs_to.add(msg); };
		return ret_hu_conv;
	}

	/**
	 * Returns the list of pending messages that were generated by the handler, clearing the list
	 * in the process. Each message is paired with the node id of the intended recipient. If no
	 * connection to the node exists, then the message is simply not sent.
	 */
	public TwoTuple_PublicKeyTypeZ[] get_and_clear_pending_msg() {
		long[] ret = bindings.CustomMessageHandler_get_and_clear_pending_msg(this.ptr);
		Reference.reachabilityFence(this);
		int ret_conv_25_len = ret.length;
		TwoTuple_PublicKeyTypeZ[] ret_conv_25_arr = new TwoTuple_PublicKeyTypeZ[ret_conv_25_len];
		for (int z = 0; z < ret_conv_25_len; z++) {
			long ret_conv_25 = ret[z];
			TwoTuple_PublicKeyTypeZ ret_conv_25_hu_conv = new TwoTuple_PublicKeyTypeZ(null, ret_conv_25);
			if (ret_conv_25_hu_conv != null) { ret_conv_25_hu_conv.ptrs_to.add(this); };
			ret_conv_25_arr[z] = ret_conv_25_hu_conv;
		}
		return ret_conv_25_arr;
	}

	/**
	 * Indicates a peer disconnected.
	 */
	public void peer_disconnected(byte[] their_node_id) {
		bindings.CustomMessageHandler_peer_disconnected(this.ptr, InternalUtils.check_arr_len(their_node_id, 33));
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(their_node_id);
	}

	/**
	 * Handle a peer connecting.
	 * 
	 * May return an `Err(())` if the features the peer supports are not sufficient to communicate
	 * with us. Implementors should be somewhat conservative about doing so, however, as other
	 * message handlers may still wish to communicate with this peer.
	 * 
	 * [`Self::peer_disconnected`] will not be called if `Err(())` is returned.
	 */
	public Result_NoneNoneZ peer_connected(byte[] their_node_id, org.ldk.structs.Init msg, boolean inbound) {
		long ret = bindings.CustomMessageHandler_peer_connected(this.ptr, InternalUtils.check_arr_len(their_node_id, 33), msg.ptr, inbound);
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(their_node_id);
		Reference.reachabilityFence(msg);
		Reference.reachabilityFence(inbound);
		if (ret >= 0 && ret <= 4096) { return null; }
		Result_NoneNoneZ ret_hu_conv = Result_NoneNoneZ.constr_from_ptr(ret);
		if (this != null) { this.ptrs_to.add(msg); };
		return ret_hu_conv;
	}

	/**
	 * Gets the node feature flags which this handler itself supports. All available handlers are
	 * queried similarly and their feature flags are OR'd together to form the [`NodeFeatures`]
	 * which are broadcasted in our [`NodeAnnouncement`] message.
	 * 
	 * [`NodeAnnouncement`]: crate::ln::msgs::NodeAnnouncement
	 */
	public NodeFeatures provided_node_features() {
		long ret = bindings.CustomMessageHandler_provided_node_features(this.ptr);
		Reference.reachabilityFence(this);
		if (ret >= 0 && ret <= 4096) { return null; }
		org.ldk.structs.NodeFeatures ret_hu_conv = null; if (ret < 0 || ret > 4096) { ret_hu_conv = new org.ldk.structs.NodeFeatures(null, ret); }
		if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(this); };
		return ret_hu_conv;
	}

	/**
	 * Gets the init feature flags which should be sent to the given peer. All available handlers
	 * are queried similarly and their feature flags are OR'd together to form the [`InitFeatures`]
	 * which are sent in our [`Init`] message.
	 * 
	 * [`Init`]: crate::ln::msgs::Init
	 */
	public InitFeatures provided_init_features(byte[] their_node_id) {
		long ret = bindings.CustomMessageHandler_provided_init_features(this.ptr, InternalUtils.check_arr_len(their_node_id, 33));
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(their_node_id);
		if (ret >= 0 && ret <= 4096) { return null; }
		org.ldk.structs.InitFeatures ret_hu_conv = null; if (ret < 0 || ret > 4096) { ret_hu_conv = new org.ldk.structs.InitFeatures(null, ret); }
		if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(this); };
		return ret_hu_conv;
	}

}
