package org.ldk.structs;

import org.ldk.impl.bindings;
import org.ldk.enums.*;
import org.ldk.util.*;
import java.util.Arrays;
import java.lang.ref.Reference;
import javax.annotation.Nullable;


/**
 * Information communicated in the onion to the recipient for multi-part tracking and proof that
 * the payment is associated with an invoice.
 */
@SuppressWarnings("unchecked") // We correctly assign various generic arrays
public class FinalOnionHopData extends CommonBase {
	FinalOnionHopData(Object _dummy, long ptr) { super(ptr); }
	@Override @SuppressWarnings("deprecation")
	protected void finalize() throws Throwable {
		super.finalize();
		if (ptr != 0) { bindings.FinalOnionHopData_free(ptr); }
	}

	/**
	 * When sending a multi-part payment, this secret is used to identify a payment across HTLCs.
	 * Because it is generated by the recipient and included in the invoice, it also provides
	 * proof to the recipient that the payment was sent by someone with the generated invoice.
	 */
	public byte[] get_payment_secret() {
		byte[] ret = bindings.FinalOnionHopData_get_payment_secret(this.ptr);
		Reference.reachabilityFence(this);
		return ret;
	}

	/**
	 * When sending a multi-part payment, this secret is used to identify a payment across HTLCs.
	 * Because it is generated by the recipient and included in the invoice, it also provides
	 * proof to the recipient that the payment was sent by someone with the generated invoice.
	 */
	public void set_payment_secret(byte[] val) {
		bindings.FinalOnionHopData_set_payment_secret(this.ptr, InternalUtils.check_arr_len(val, 32));
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(val);
	}

	/**
	 * The intended total amount that this payment is for.
	 * 
	 * Message serialization may panic if this value is more than 21 million Bitcoin.
	 */
	public long get_total_msat() {
		long ret = bindings.FinalOnionHopData_get_total_msat(this.ptr);
		Reference.reachabilityFence(this);
		return ret;
	}

	/**
	 * The intended total amount that this payment is for.
	 * 
	 * Message serialization may panic if this value is more than 21 million Bitcoin.
	 */
	public void set_total_msat(long val) {
		bindings.FinalOnionHopData_set_total_msat(this.ptr, val);
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(val);
	}

	/**
	 * Constructs a new FinalOnionHopData given each field
	 */
	public static FinalOnionHopData of(byte[] payment_secret_arg, long total_msat_arg) {
		long ret = bindings.FinalOnionHopData_new(InternalUtils.check_arr_len(payment_secret_arg, 32), total_msat_arg);
		Reference.reachabilityFence(payment_secret_arg);
		Reference.reachabilityFence(total_msat_arg);
		if (ret >= 0 && ret <= 4096) { return null; }
		org.ldk.structs.FinalOnionHopData ret_hu_conv = null; if (ret < 0 || ret > 4096) { ret_hu_conv = new org.ldk.structs.FinalOnionHopData(null, ret); }
		if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(ret_hu_conv); };
		return ret_hu_conv;
	}

	long clone_ptr() {
		long ret = bindings.FinalOnionHopData_clone_ptr(this.ptr);
		Reference.reachabilityFence(this);
		return ret;
	}

	/**
	 * Creates a copy of the FinalOnionHopData
	 */
	public FinalOnionHopData clone() {
		long ret = bindings.FinalOnionHopData_clone(this.ptr);
		Reference.reachabilityFence(this);
		if (ret >= 0 && ret <= 4096) { return null; }
		org.ldk.structs.FinalOnionHopData ret_hu_conv = null; if (ret < 0 || ret > 4096) { ret_hu_conv = new org.ldk.structs.FinalOnionHopData(null, ret); }
		if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(this); };
		return ret_hu_conv;
	}

	/**
	 * Checks if two FinalOnionHopDatas contain equal inner contents.
	 * This ignores pointers and is_owned flags and looks at the values in fields.
	 * Two objects with NULL inner values will be considered "equal" here.
	 */
	public boolean eq(org.ldk.structs.FinalOnionHopData b) {
		boolean ret = bindings.FinalOnionHopData_eq(this.ptr, b.ptr);
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(b);
		if (this != null) { this.ptrs_to.add(b); };
		return ret;
	}

	@Override public boolean equals(Object o) {
		if (!(o instanceof FinalOnionHopData)) return false;
		return this.eq((FinalOnionHopData)o);
	}
	/**
	 * Serialize the FinalOnionHopData object into a byte array which can be read by FinalOnionHopData_read
	 */
	public byte[] write() {
		byte[] ret = bindings.FinalOnionHopData_write(this.ptr);
		Reference.reachabilityFence(this);
		return ret;
	}

	/**
	 * Read a FinalOnionHopData from a byte array, created by FinalOnionHopData_write
	 */
	public static Result_FinalOnionHopDataDecodeErrorZ read(byte[] ser) {
		long ret = bindings.FinalOnionHopData_read(ser);
		Reference.reachabilityFence(ser);
		if (ret >= 0 && ret <= 4096) { return null; }
		Result_FinalOnionHopDataDecodeErrorZ ret_hu_conv = Result_FinalOnionHopDataDecodeErrorZ.constr_from_ptr(ret);
		return ret_hu_conv;
	}

}
