package org.ldk.structs;

import org.ldk.impl.bindings;
import org.ldk.enums.*;
import org.ldk.util.*;
import java.util.Arrays;
import java.lang.ref.Reference;
import javax.annotation.Nullable;


/**
 * An enum which can either contain a crate::lightning::blinded_path::message::MessageContext or not
 */
@SuppressWarnings("unchecked") // We correctly assign various generic arrays
public class Option_MessageContextZ extends CommonBase {
	private Option_MessageContextZ(Object _dummy, long ptr) { super(ptr); }
	@Override @SuppressWarnings("deprecation")
	protected void finalize() throws Throwable {
		super.finalize();
		if (ptr != 0) { bindings.COption_MessageContextZ_free(ptr); }
	}
	static Option_MessageContextZ constr_from_ptr(long ptr) {
		bindings.LDKCOption_MessageContextZ raw_val = bindings.LDKCOption_MessageContextZ_ref_from_ptr(ptr);
		if (raw_val.getClass() == bindings.LDKCOption_MessageContextZ.Some.class) {
			return new Some(ptr, (bindings.LDKCOption_MessageContextZ.Some)raw_val);
		}
		if (raw_val.getClass() == bindings.LDKCOption_MessageContextZ.None.class) {
			return new None(ptr, (bindings.LDKCOption_MessageContextZ.None)raw_val);
		}
		assert false; return null; // Unreachable without extending the (internal) bindings interface
	}

	/**
	 * When we're in this state, this COption_MessageContextZ contains a crate::lightning::blinded_path::message::MessageContext
	 */
	public final static class Some extends Option_MessageContextZ {
		public final org.ldk.structs.MessageContext some;
		private Some(long ptr, bindings.LDKCOption_MessageContextZ.Some obj) {
			super(null, ptr);
			long some = obj.some;
			org.ldk.structs.MessageContext some_hu_conv = org.ldk.structs.MessageContext.constr_from_ptr(some);
			if (some_hu_conv != null) { some_hu_conv.ptrs_to.add(this); };
			this.some = some_hu_conv;
		}
	}
	/**
	 * When we're in this state, this COption_MessageContextZ contains nothing
	 */
	public final static class None extends Option_MessageContextZ {
		private None(long ptr, bindings.LDKCOption_MessageContextZ.None obj) {
			super(null, ptr);
		}
	}
	/**
	 * Constructs a new COption_MessageContextZ containing a crate::lightning::blinded_path::message::MessageContext
	 */
	public static Option_MessageContextZ some(org.ldk.structs.MessageContext o) {
		long ret = bindings.COption_MessageContextZ_some(o.ptr);
		Reference.reachabilityFence(o);
		if (ret >= 0 && ret <= 4096) { return null; }
		org.ldk.structs.Option_MessageContextZ ret_hu_conv = org.ldk.structs.Option_MessageContextZ.constr_from_ptr(ret);
		if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(ret_hu_conv); };
		return ret_hu_conv;
	}

	/**
	 * Constructs a new COption_MessageContextZ containing nothing
	 */
	public static Option_MessageContextZ none() {
		long ret = bindings.COption_MessageContextZ_none();
		if (ret >= 0 && ret <= 4096) { return null; }
		org.ldk.structs.Option_MessageContextZ ret_hu_conv = org.ldk.structs.Option_MessageContextZ.constr_from_ptr(ret);
		if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(ret_hu_conv); };
		return ret_hu_conv;
	}

	long clone_ptr() {
		long ret = bindings.COption_MessageContextZ_clone_ptr(this.ptr);
		Reference.reachabilityFence(this);
		return ret;
	}

	/**
	 * Creates a new COption_MessageContextZ which has the same data as `orig`
	 * but with all dynamically-allocated buffers duplicated in new buffers.
	 */
	public Option_MessageContextZ clone() {
		long ret = bindings.COption_MessageContextZ_clone(this.ptr);
		Reference.reachabilityFence(this);
		if (ret >= 0 && ret <= 4096) { return null; }
		org.ldk.structs.Option_MessageContextZ ret_hu_conv = org.ldk.structs.Option_MessageContextZ.constr_from_ptr(ret);
		if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(this); };
		return ret_hu_conv;
	}

}
