package org.ldk.structs;

import org.ldk.impl.bindings;
import org.ldk.enums.*;
import org.ldk.util.*;
import java.util.Arrays;
import java.lang.ref.Reference;
import javax.annotation.Nullable;

/**
 * Trait that handles persisting a [`ChannelManager`], [`NetworkGraph`], and [`WriteableScore`] to disk.
 * 
 * [`ChannelManager`]: crate::ln::channelmanager::ChannelManager
 */
@SuppressWarnings("unchecked") // We correctly assign various generic arrays
public class Persister extends CommonBase {
	final bindings.LDKPersister bindings_instance;
	Persister(Object _dummy, long ptr) { super(ptr); bindings_instance = null; }
	private Persister(bindings.LDKPersister arg) {
		super(bindings.LDKPersister_new(arg));
		this.ptrs_to.add(arg);
		this.bindings_instance = arg;
	}
	@Override @SuppressWarnings("deprecation")
	protected void finalize() throws Throwable {
		if (ptr != 0) { bindings.Persister_free(ptr); } super.finalize();
	}
	/**
	 * Destroys the object, freeing associated resources. After this call, any access
	 * to this object may result in a SEGFAULT or worse.
	 *
	 * You should generally NEVER call this method. You should let the garbage collector
	 * do this for you when it finalizes objects. However, it may be useful for types
	 * which represent locks and should be closed immediately to avoid holding locks
	 * until the GC runs.
	 */
	public void destroy() {
		if (ptr != 0) { bindings.Persister_free(ptr); }
		ptr = 0;
	}
	public static interface PersisterInterface {
		/**
		 * Persist the given ['ChannelManager'] to disk, returning an error if persistence failed.
		 * 
		 * [`ChannelManager`]: crate::ln::channelmanager::ChannelManager
		 */
		Result_NoneIOErrorZ persist_manager(ChannelManager channel_manager);
		/**
		 * Persist the given [`NetworkGraph`] to disk, returning an error if persistence failed.
		 */
		Result_NoneIOErrorZ persist_graph(NetworkGraph network_graph);
		/**
		 * Persist the given [`WriteableScore`] to disk, returning an error if persistence failed.
		 */
		Result_NoneIOErrorZ persist_scorer(WriteableScore scorer);
	}
	private static class LDKPersisterHolder { Persister held; }
	public static Persister new_impl(PersisterInterface arg) {
		final LDKPersisterHolder impl_holder = new LDKPersisterHolder();
		impl_holder.held = new Persister(new bindings.LDKPersister() {
			@Override public long persist_manager(long channel_manager) {
				org.ldk.structs.ChannelManager channel_manager_hu_conv = null; if (channel_manager < 0 || channel_manager > 4096) { channel_manager_hu_conv = new org.ldk.structs.ChannelManager(null, channel_manager); }
				Result_NoneIOErrorZ ret = arg.persist_manager(channel_manager_hu_conv);
				Reference.reachabilityFence(arg);
				long result = ret.clone_ptr();
				return result;
			}
			@Override public long persist_graph(long network_graph) {
				org.ldk.structs.NetworkGraph network_graph_hu_conv = null; if (network_graph < 0 || network_graph > 4096) { network_graph_hu_conv = new org.ldk.structs.NetworkGraph(null, network_graph); }
				Result_NoneIOErrorZ ret = arg.persist_graph(network_graph_hu_conv);
				Reference.reachabilityFence(arg);
				long result = ret.clone_ptr();
				return result;
			}
			@Override public long persist_scorer(long scorer) {
				WriteableScore ret_hu_conv = new WriteableScore(null, scorer);
				if (ret_hu_conv != null) { ret_hu_conv.ptrs_to.add(this); };
				Result_NoneIOErrorZ ret = arg.persist_scorer(ret_hu_conv);
				Reference.reachabilityFence(arg);
				long result = ret.clone_ptr();
				return result;
			}
		});
		return impl_holder.held;
	}
	/**
	 * Persist the given ['ChannelManager'] to disk, returning an error if persistence failed.
	 * 
	 * [`ChannelManager`]: crate::ln::channelmanager::ChannelManager
	 */
	public Result_NoneIOErrorZ persist_manager(org.ldk.structs.ChannelManager channel_manager) {
		long ret = bindings.Persister_persist_manager(this.ptr, channel_manager.ptr);
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(channel_manager);
		if (ret >= 0 && ret <= 4096) { return null; }
		Result_NoneIOErrorZ ret_hu_conv = Result_NoneIOErrorZ.constr_from_ptr(ret);
		if (this != null) { this.ptrs_to.add(channel_manager); };
		return ret_hu_conv;
	}

	/**
	 * Persist the given [`NetworkGraph`] to disk, returning an error if persistence failed.
	 */
	public Result_NoneIOErrorZ persist_graph(org.ldk.structs.NetworkGraph network_graph) {
		long ret = bindings.Persister_persist_graph(this.ptr, network_graph.ptr);
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(network_graph);
		if (ret >= 0 && ret <= 4096) { return null; }
		Result_NoneIOErrorZ ret_hu_conv = Result_NoneIOErrorZ.constr_from_ptr(ret);
		if (this != null) { this.ptrs_to.add(network_graph); };
		return ret_hu_conv;
	}

	/**
	 * Persist the given [`WriteableScore`] to disk, returning an error if persistence failed.
	 */
	public Result_NoneIOErrorZ persist_scorer(org.ldk.structs.WriteableScore scorer) {
		long ret = bindings.Persister_persist_scorer(this.ptr, scorer.ptr);
		Reference.reachabilityFence(this);
		Reference.reachabilityFence(scorer);
		if (ret >= 0 && ret <= 4096) { return null; }
		Result_NoneIOErrorZ ret_hu_conv = Result_NoneIOErrorZ.constr_from_ptr(ret);
		if (this != null) { this.ptrs_to.add(scorer); };
		return ret_hu_conv;
	}

}
