/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.menu.node;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.plugin.id.resource.CompanyResource;
import org.ligoj.app.resource.node.NodeResource;
import org.ligoj.bootstrap.core.json.ObjectMapperTrim;
import org.ligoj.bootstrap.core.plugin.FeaturePlugin;
import org.ligoj.bootstrap.model.system.SystemConfiguration;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationResource;
import org.ligoj.bootstrap.resource.system.session.ISessionSettingsProvider;
import org.ligoj.bootstrap.resource.system.session.SessionSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Transactional
public class ToolSessionSettingsProvider
implements ISessionSettingsProvider,
FeaturePlugin {
    private static final Logger log = LoggerFactory.getLogger(ToolSessionSettingsProvider.class);
    @Autowired
    private ConfigurationResource configuration;
    @Autowired
    protected CompanyResource companyResource;
    @Autowired
    private ObjectMapperTrim objectMapper;
    @Autowired
    protected NodeResource nodeResource;
    private static final TypeReference<List<Map<String, Object>>> LIST_MAP_TYPE = new TypeReference<List<Map<String, Object>>>(){};

    public void decorate(SessionSettings settings) {
        String source;
        Map userSetting = settings.getUserSettings();
        if (this.companyResource.isUserInternalCommpany()) {
            userSetting.put("internal", Boolean.TRUE);
            source = this.configuration.get("global.tools.internal");
        } else {
            userSetting.put("external", Boolean.TRUE);
            source = this.configuration.get("global.tools.external");
        }
        try {
            List rawGlobalTools = (List)this.objectMapper.readValue((String)StringUtils.defaultIfEmpty((CharSequence)source, (CharSequence)"[]"), LIST_MAP_TYPE);
            userSetting.put("globalTools", rawGlobalTools.stream().map(globalTool -> {
                globalTool.compute("node", (node, v) -> this.nodeResource.findAll().get(globalTool.get("id")));
                globalTool.remove("id");
                return globalTool;
            }).filter(globalTool -> globalTool.containsKey("node")).collect(Collectors.toList()));
        }
        catch (IOException ioe) {
            log.error("Unable to write the global tools configuration for user {}", (Object)settings.getUserName(), (Object)ioe);
        }
    }

    public String getKey() {
        return "feature:menu:node";
    }

    public List<Class<?>> getInstalledEntities() {
        return Collections.singletonList(SystemConfiguration.class);
    }
}

