/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.vm.aws;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.api.SubscriptionStatusWithData;
import org.ligoj.app.dao.NodeRepository;
import org.ligoj.app.plugin.vm.VmNetwork;
import org.ligoj.app.plugin.vm.VmServicePlugin;
import org.ligoj.app.plugin.vm.aws.AwsVm;
import org.ligoj.app.plugin.vm.aws.InstanceType;
import org.ligoj.app.plugin.vm.aws.auth.AWS4SignatureQuery;
import org.ligoj.app.plugin.vm.aws.auth.AWS4SignerVMForAuthorizationHeader;
import org.ligoj.app.plugin.vm.dao.VmScheduleRepository;
import org.ligoj.app.plugin.vm.model.VmOperation;
import org.ligoj.app.plugin.vm.model.VmStatus;
import org.ligoj.app.resource.plugin.AbstractXmlApiToolPluginResource;
import org.ligoj.app.resource.plugin.CurlProcessor;
import org.ligoj.app.resource.plugin.CurlRequest;
import org.ligoj.bootstrap.core.csv.CsvForBean;
import org.ligoj.bootstrap.core.resource.BusinessException;
import org.ligoj.bootstrap.core.security.SecurityHelper;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Path(value="/service/vm/aws")
@Service
@Produces(value={"application/json"})
public class VmAwsPluginResource
extends AbstractXmlApiToolPluginResource
implements VmServicePlugin,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(VmAwsPluginResource.class);
    private static final String API_VERSION = "2016-11-15";
    public static final String URL = "/service/vm/aws";
    public static final String KEY = "/service/vm/aws".replace('/', ':').substring(1);
    public static final String PARAMETER_ACCESS_KEY_ID = KEY + ":access-key-id";
    public static final String PARAMETER_SECRET_ACCESS_KEY = KEY + ":secret-access-key";
    public static final String PARAMETER_ACCOUNT = KEY + ":account";
    public static final String PARAMETER_INSTANCE_ID = KEY + ":id";
    public static final String CONF_REGION = KEY + ":region";
    private static final String DEFAULT_REGION = "eu-west-1";
    private static final int STATE_TERMINATED = 48;
    public static final Map<VmOperation, String> OPERATION_TO_ACTION = new EnumMap<VmOperation, String>(VmOperation.class);
    public static final Map<Integer, VmStatus> CODE_TO_STATUS;
    public static final int[] BUSY_CODES;
    @Autowired
    private AWS4SignerVMForAuthorizationHeader signer;
    @Autowired
    private SecurityHelper securityHelper;
    @Autowired
    private ConfigurationResource configuration;
    @Autowired
    private NodeRepository nodeRepository;
    @Autowired
    private CsvForBean csvForBean;
    @Autowired
    private VmScheduleRepository vmScheduleRepository;
    private Map<String, InstanceType> instanceTypes;

    public AwsVm getVmDetails(Map<String, String> parameters) throws Exception {
        String instanceId = parameters.get(PARAMETER_INSTANCE_ID);
        return (AwsVm)((Object)this.getDescribeInstances(parameters, "&Filter.1.Name=instance-id&Filter.1.Value.1=" + instanceId, this::toVmDetails).stream().findFirst().orElseThrow(() -> new ValidationJsonException(PARAMETER_INSTANCE_ID, (Serializable)((Object)"aws-instance-id"), new Serializable[]{instanceId})));
    }

    public void link(int subscription) throws Exception {
        this.getVmDetails(this.subscriptionResource.getParameters(subscription));
    }

    @GET
    @Path(value="{node:[a-z].*}/{criteria}")
    @Consumes(value={"application/json"})
    public List<AwsVm> findAllByNameOrId(@PathParam(value="node") String node, @PathParam(value="criteria") String criteria) throws XPathExpressionException, SAXException, IOException, ParserConfigurationException {
        if (this.nodeRepository.findOneVisible(node, this.securityHelper.getLogin()) == null) {
            return Collections.emptyList();
        }
        return this.getDescribeInstances(this.pvResource.getNodeParameters(node), "", this::toVm).stream().filter(vm -> StringUtils.containsIgnoreCase((CharSequence)vm.getName(), (CharSequence)criteria) || StringUtils.containsIgnoreCase((CharSequence)((CharSequence)((Object)vm.getId())), (CharSequence)criteria)).sorted().collect(Collectors.toList());
    }

    private List<AwsVm> getDescribeInstances(Map<String, String> parameters, String filter, Function<Element, AwsVm> parser) throws XPathExpressionException, SAXException, IOException, ParserConfigurationException {
        String query = "Action=DescribeInstances";
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            query = query + filter;
        }
        String response = (String)StringUtils.defaultIfEmpty((CharSequence)this.processEC2(parameters, query), (CharSequence)"<DescribeInstancesResponse><reservationSet><item><instancesSet></instancesSet></item></reservationSet></DescribeInstancesResponse>");
        return this.toVms(response, parser);
    }

    private List<AwsVm> toVms(String vmAsXml, Function<Element, AwsVm> parser) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException {
        NodeList items = this.getXmlTags(vmAsXml, "/DescribeInstancesResponse/reservationSet/item/instancesSet/item");
        return IntStream.range(0, items.getLength()).mapToObj(items::item).map(n -> (AwsVm)((Object)((Object)parser.apply((Element)n)))).collect(Collectors.toList());
    }

    private AwsVm toVm(Element record) {
        AwsVm result = new AwsVm();
        result.setId((Serializable)((Object)this.getTagText(record, "instanceId")));
        result.setName(Objects.toString(this.getName(record), (String)((Object)result.getId())));
        result.setDescription(this.getResourceTag(record, "description"));
        int state = this.getEc2State(record);
        result.setStatus(CODE_TO_STATUS.get(state));
        result.setBusy(Arrays.binarySearch(BUSY_CODES, state) >= 0);
        result.setVpc(this.getTagText(record, "vpcId"));
        result.setAz(this.getTagText((Element)record.getElementsByTagName("placement").item(0), "availabilityZone"));
        InstanceType type = this.instanceTypes.get(this.getTagText(record, "instanceType"));
        result.setRam(Optional.ofNullable(type).map(InstanceType::getRam).map(m -> (int)(m * 1024.0)).orElse(0));
        result.setCpu(Optional.ofNullable(type).map(InstanceType::getCpu).orElse(0));
        result.setDeployed(result.getStatus() == VmStatus.POWERED_ON);
        return result;
    }

    private AwsVm toVmDetails(Element record) {
        AwsVm result = this.toVm(record);
        result.setNetworks(new ArrayList());
        this.addNetworkDetails(record, result.getNetworks());
        return result;
    }

    private void addNetworkDetails(Element networkNode, Collection<VmNetwork> networks) {
        this.addNetworkDetails(networkNode, networks, "private", "privateIpAddress", "privateDnsName");
        this.addNetworkDetails(networkNode, networks, "public", "ipAddress", "dnsName");
    }

    private void addNetworkDetails(Element networkNode, Collection<VmNetwork> networks, String type, String ipAttr, String dnsAttr) {
        Optional.ofNullable(this.getTagText(networkNode, ipAttr)).ifPresent(i -> networks.add(new VmNetwork(type, i, this.getTagText(networkNode, dnsAttr))));
    }

    private int getEc2State(Element record) {
        return this.getEc2State(record, "instanceState");
    }

    private int getEc2State(Element record, String tag) {
        Element stateElement = (Element)record.getElementsByTagName(tag).item(0);
        return Integer.valueOf(this.getTagText(stateElement, "code"));
    }

    private String getTagText(Element element, String tag) {
        return Optional.ofNullable(Optional.ofNullable(element).map(e -> e.getElementsByTagName(tag).item(0)).map(n -> n.getTextContent()).orElse(null)).orElse(null);
    }

    private String getResourceTag(Element record, String name) {
        return Optional.ofNullable(record.getElementsByTagName("tagSet").item(0)).map(n -> ((Element)n).getElementsByTagName("item")).map(n -> IntStream.range(0, n.getLength()).mapToObj(n::item).map(t -> (Element)t).filter(t -> this.getTagText((Element)t, "key").equalsIgnoreCase(name)).map(t -> this.getTagText((Element)t, "value")).findFirst().orElse(null)).orElse(null);
    }

    private String getName(Element record) {
        return this.getResourceTag(record, "name");
    }

    protected NodeList getXmlTags(String input, String expression) throws XPathExpressionException, SAXException, IOException, ParserConfigurationException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        return (NodeList)xPath.compile(expression).evaluate(this.parse(IOUtils.toInputStream((String)((String)ObjectUtils.defaultIfNull((Object)input, (Object)"")), (Charset)StandardCharsets.UTF_8)), XPathConstants.NODESET);
    }

    public String getKey() {
        return KEY;
    }

    public boolean checkStatus(Map<String, String> parameters) throws Exception {
        return this.validateAccess(parameters);
    }

    public SubscriptionStatusWithData checkSubscriptionStatus(int subscription, String node, Map<String, String> parameters) throws Exception {
        SubscriptionStatusWithData status = new SubscriptionStatusWithData();
        status.put("vm", (Object)this.getVmDetails((Map)parameters));
        status.put("schedules", (Object)this.vmScheduleRepository.countBySubscription(subscription));
        return status;
    }

    public void execute(int subscription, VmOperation operation) throws Exception {
        String response = Optional.ofNullable(OPERATION_TO_ACTION.get(operation)).map(a -> this.processEC2(subscription, (Map<String, String> p) -> "Action=" + a + "&InstanceId.1=" + (String)p.get(PARAMETER_INSTANCE_ID))).orElse(null);
        if (!this.logTransitionState(response)) {
            throw new BusinessException("vm-operation-execute", new Object[0]);
        }
    }

    private boolean logTransitionState(String response) throws Exception {
        NodeList items = this.getXmlTags((String)ObjectUtils.defaultIfNull((Object)response, (Object)"<a></a>"), "/*[contains(local-name(),'InstancesResponse')]/instancesSet/item");
        return IntStream.range(0, items.getLength()).mapToObj(items::item).map(n -> (Element)n).peek(e -> log.info("Instance {} goes from {} to {} state", new Object[]{this.getTagText((Element)e, "instanceId"), this.getEc2State((Element)e, "previousState"), this.getEc2State((Element)e, "currentState")})).findFirst().isPresent();
    }

    private String processEC2(int subscription, Function<Map<String, String>, String> queryProvider) {
        Map parameters = this.pvResource.getSubscriptionParameters(subscription);
        return this.processEC2(parameters, queryProvider.apply(parameters));
    }

    private String processEC2(Map<String, String> parameters, String query) {
        AWS4SignatureQuery.AWS4SignatureQueryBuilder signatureQuery = AWS4SignatureQuery.builder().accessKey(parameters.get(PARAMETER_ACCESS_KEY_ID)).secretKey(parameters.get(PARAMETER_SECRET_ACCESS_KEY)).path("/").service("ec2").host("ec2." + this.getRegion() + ".amazonaws.com").body(query + "&Version=" + API_VERSION);
        CurlRequest request = this.newRequest(signatureQuery, parameters);
        new CurlProcessor().process(new CurlRequest[]{request});
        return request.getResponse();
    }

    protected CurlRequest newRequest(AWS4SignatureQuery.AWS4SignatureQueryBuilder signatureBuilder, int subscription) {
        return this.newRequest(signatureBuilder, this.subscriptionResource.getParameters(subscription));
    }

    protected CurlRequest newRequest(AWS4SignatureQuery.AWS4SignatureQueryBuilder signatureBuilder, Map<String, String> parameters) {
        AWS4SignatureQuery signatureQuery = signatureBuilder.accessKey(parameters.get(PARAMETER_ACCESS_KEY_ID)).secretKey(parameters.get(PARAMETER_SECRET_ACCESS_KEY)).region(this.getRegion()).build();
        String authorization = this.signer.computeSignature(signatureQuery);
        CurlRequest request = new CurlRequest(signatureQuery.getMethod(), "https://" + signatureQuery.getHost() + signatureQuery.getPath(), signatureQuery.getBody(), new String[0]);
        request.getHeaders().putAll(signatureQuery.getHeaders());
        request.getHeaders().put("Authorization", authorization);
        request.setSaveResponse(true);
        return request;
    }

    protected String getRegion() {
        return this.configuration.get(CONF_REGION, DEFAULT_REGION);
    }

    protected boolean validateAccess(Map<String, String> parameters) throws Exception {
        AWS4SignatureQuery.AWS4SignatureQueryBuilder signatureQueryBuilder = AWS4SignatureQuery.builder().method("GET").service("s3").host("s3-" + this.getRegion() + ".amazonaws.com").path("/");
        return new CurlProcessor().process(new CurlRequest[]{this.newRequest(signatureQueryBuilder, parameters)});
    }

    public void afterPropertiesSet() throws Exception {
        this.instanceTypes = this.csvForBean.toBean(InstanceType.class, "csv/instance-type-details.csv").stream().collect(Collectors.toMap(InstanceType::getId, Function.identity()));
    }

    static {
        OPERATION_TO_ACTION.put(VmOperation.OFF, "StopInstances&Force=true");
        OPERATION_TO_ACTION.put(VmOperation.SHUTDOWN, "StopInstances");
        OPERATION_TO_ACTION.put(VmOperation.ON, "StartInstances");
        OPERATION_TO_ACTION.put(VmOperation.REBOOT, "RebootInstances");
        OPERATION_TO_ACTION.put(VmOperation.RESET, "RebootInstances");
        CODE_TO_STATUS = new HashMap<Integer, VmStatus>();
        CODE_TO_STATUS.put(16, VmStatus.POWERED_ON);
        CODE_TO_STATUS.put(48, VmStatus.POWERED_OFF);
        CODE_TO_STATUS.put(80, VmStatus.POWERED_OFF);
        CODE_TO_STATUS.put(0, VmStatus.POWERED_ON);
        CODE_TO_STATUS.put(32, VmStatus.POWERED_OFF);
        CODE_TO_STATUS.put(64, VmStatus.POWERED_OFF);
        BUSY_CODES = new int[]{0, 32, 64};
    }
}

