/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.vm.aws.auth;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.bootstrap.core.resource.TechnicalException;

public abstract class AWS4SignerBase {
    public static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    public static final String SCHEME = "AWS4";
    public static final String ALGORITHM = "HMAC-SHA256";
    public static final String TERMINATOR = "aws4_request";
    private URLCodec urlCodec = new URLCodec();

    protected String getCanonicalizeHeaderNames(Map<String, String> headers) {
        return headers.keySet().stream().sorted(String.CASE_INSENSITIVE_ORDER).map(String::toLowerCase).collect(Collectors.joining(";"));
    }

    protected String getCanonicalizedHeaderString(Map<String, String> headers) {
        if (headers.isEmpty()) {
            return "";
        }
        return headers.keySet().stream().sorted(String.CASE_INSENSITIVE_ORDER).map(key -> key.toLowerCase().replaceAll("\\s+", " ") + ":" + ((String)headers.get(key)).replaceAll("\\s+", " ")).collect(Collectors.joining("\n")) + "\n";
    }

    protected String getCanonicalRequest(String path, String httpMethod, String queryParameters, String canonicalizedHeaderNames, String canonicalizedHeaders, String bodyHash) {
        return httpMethod + "\n" + this.getCanonicalizedResourcePath(path) + "\n" + queryParameters + "\n" + canonicalizedHeaders + "\n" + canonicalizedHeaderNames + "\n" + bodyHash;
    }

    protected String getCanonicalizedResourcePath(String path) {
        try {
            return StringUtils.prependIfMissing((String)this.urlCodec.encode(StringUtils.trimToEmpty((String)path)).replace("%2F", "/"), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        catch (EncoderException e) {
            throw new TechnicalException("Error during resource path encoding", (Throwable)e, new Object[0]);
        }
    }

    public String getCanonicalizedQueryString(Map<String, String> parameters) {
        return parameters.keySet().stream().sorted().map(key -> {
            try {
                return this.urlCodec.encode(key) + "=" + this.urlCodec.encode((String)parameters.get(key));
            }
            catch (EncoderException e) {
                throw new TechnicalException("Error during parameters encoding", (Throwable)e, new Object[0]);
            }
        }).collect(Collectors.joining("&"));
    }

    protected String getStringToSign(String dateTime, String scope, String canonicalRequest) {
        return "AWS4-HMAC-SHA256\n" + dateTime + "\n" + scope + "\n" + this.hash(canonicalRequest);
    }

    public String hash(String text) {
        return Hex.encodeHexString((byte[])DigestUtils.getSha256Digest().digest(org.apache.commons.codec.binary.StringUtils.getBytesUtf8((String)text)));
    }

    protected byte[] sign(String stringData, byte[] key) {
        return new HmacUtils(HmacAlgorithms.HMAC_SHA_256, key).hmac(stringData);
    }
}

