/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.vm.aws.auth;

import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.codec.binary.Hex;
import org.ligoj.app.plugin.vm.aws.auth.AWS4SignatureQuery;
import org.ligoj.app.plugin.vm.aws.auth.AWS4SignerBase;
import org.springframework.stereotype.Service;

@Service
public class AWS4SignerVMForAuthorizationHeader
extends AWS4SignerBase {
    public static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    public static final String ISO8601_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    public static final String DATE_FORMAT = "yyyyMMdd";
    private Clock clock = Clock.systemUTC();

    public String computeSignature(AWS4SignatureQuery query) {
        ZonedDateTime now = ZonedDateTime.now(this.clock);
        String dateTimeStamp = DateTimeFormatter.ofPattern(ISO8601_FORMAT).format(now);
        String bodyHash = query.getBody() == null ? EMPTY_BODY_SHA256 : this.hash(query.getBody());
        query.getHeaders().put("x-amz-date", dateTimeStamp);
        query.getHeaders().put("x-amz-content-sha256", bodyHash);
        query.getHeaders().put("Host", query.getHost());
        String canonicalizedHeaderNames = this.getCanonicalizeHeaderNames(query.getHeaders());
        String canonicalizedHeaders = this.getCanonicalizedHeaderString(query.getHeaders());
        String canonicalizedQueryParameters = this.getCanonicalizedQueryString(query.getQueryParameters());
        String canonicalRequest = this.getCanonicalRequest(query.getPath(), query.getMethod(), canonicalizedQueryParameters, canonicalizedHeaderNames, canonicalizedHeaders, bodyHash);
        String dateStamp = DateTimeFormatter.ofPattern(DATE_FORMAT).format(now);
        String scope = dateStamp + "/" + query.getRegion() + "/" + query.getService() + "/" + "aws4_request";
        String stringToSign = this.getStringToSign(dateTimeStamp, scope, canonicalRequest);
        byte[] kSecret = ("AWS4" + query.getSecretKey()).getBytes();
        byte[] kDate = this.sign(dateStamp, kSecret);
        byte[] kRegion = this.sign(query.getRegion(), kDate);
        byte[] kService = this.sign(query.getService(), kRegion);
        byte[] kSigning = this.sign("aws4_request", kService);
        byte[] signature = this.sign(stringToSign, kSigning);
        String credentialsAuthorizationHeader = "Credential=" + query.getAccessKey() + "/" + scope;
        String signedHeadersAuthorizationHeader = "SignedHeaders=" + canonicalizedHeaderNames;
        String signatureAuthorizationHeader = "Signature=" + Hex.encodeHexString((byte[])signature);
        return "AWS4-HMAC-SHA256 " + credentialsAuthorizationHeader + ", " + signedHeadersAuthorizationHeader + ", " + signatureAuthorizationHeader;
    }
}

