/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.client;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagUtils;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.client.RegistrationError;
import com.nimbusds.oauth2.sdk.id.SoftwareID;
import com.nimbusds.oauth2.sdk.id.SoftwareVersion;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class ClientMetadata {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private Set<URI> redirectURIs;
    private Scope scope;
    private Set<ResponseType> responseTypes;
    private Set<GrantType> grantTypes;
    private List<String> contacts;
    private final Map<LangTag, String> nameEntries;
    private final Map<LangTag, URI> logoURIEntries;
    private final Map<LangTag, URI> uriEntries;
    private Map<LangTag, URI> policyURIEntries;
    private final Map<LangTag, URI> tosURIEntries;
    private ClientAuthenticationMethod authMethod;
    private JWSAlgorithm authJWSAlg;
    private URI jwkSetURI;
    private JWKSet jwkSet;
    private SoftwareID softwareID;
    private SoftwareVersion softwareVersion;
    private JSONObject customFields;

    public ClientMetadata() {
        this.nameEntries = new HashMap<LangTag, String>();
        this.logoURIEntries = new HashMap<LangTag, URI>();
        this.uriEntries = new HashMap<LangTag, URI>();
        this.policyURIEntries = new HashMap<LangTag, URI>();
        this.policyURIEntries = new HashMap<LangTag, URI>();
        this.tosURIEntries = new HashMap<LangTag, URI>();
        this.customFields = new JSONObject();
    }

    public ClientMetadata(ClientMetadata metadata) {
        this.redirectURIs = metadata.redirectURIs;
        this.scope = metadata.scope;
        this.responseTypes = metadata.responseTypes;
        this.grantTypes = metadata.grantTypes;
        this.contacts = metadata.contacts;
        this.nameEntries = metadata.nameEntries;
        this.logoURIEntries = metadata.logoURIEntries;
        this.uriEntries = metadata.uriEntries;
        this.policyURIEntries = metadata.policyURIEntries;
        this.tosURIEntries = metadata.tosURIEntries;
        this.authMethod = metadata.authMethod;
        this.authJWSAlg = metadata.authJWSAlg;
        this.jwkSetURI = metadata.jwkSetURI;
        this.jwkSet = metadata.getJWKSet();
        this.softwareID = metadata.softwareID;
        this.softwareVersion = metadata.softwareVersion;
        this.customFields = metadata.customFields;
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public Set<URI> getRedirectionURIs() {
        return this.redirectURIs;
    }

    public Set<String> getRedirectionURIStrings() {
        if (this.redirectURIs == null) {
            return null;
        }
        HashSet<String> uriStrings = new HashSet<String>();
        for (URI uri : this.redirectURIs) {
            uriStrings.add(uri.toString());
        }
        return uriStrings;
    }

    public void setRedirectionURIs(Set<URI> redirectURIs) {
        if (redirectURIs != null) {
            for (URI uri : redirectURIs) {
                if (uri == null) {
                    throw new IllegalArgumentException("The redirect_uri must not be null");
                }
                if (uri.getFragment() == null) continue;
                throw new IllegalArgumentException("The redirect_uri must not contain fragment");
            }
            this.redirectURIs = redirectURIs;
        } else {
            this.redirectURIs = null;
        }
    }

    public void setRedirectionURI(URI redirectURI) {
        this.setRedirectionURIs(redirectURI != null ? Collections.singleton(redirectURI) : null);
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean hasScopeValue(Scope.Value scopeValue) {
        return this.scope != null && this.scope.contains(scopeValue);
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Set<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(Set<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public Set<GrantType> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(Set<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
    }

    @Deprecated
    public List<InternetAddress> getContacts() {
        if (this.contacts == null) {
            return null;
        }
        LinkedList<InternetAddress> addresses = new LinkedList<InternetAddress>();
        for (String s : this.contacts) {
            if (s == null) continue;
            try {
                addresses.add(new InternetAddress(s, false));
            }
            catch (AddressException addressException) {}
        }
        return addresses;
    }

    @Deprecated
    public void setContacts(List<InternetAddress> contacts) {
        if (contacts == null) {
            this.contacts = null;
            return;
        }
        LinkedList<String> addresses = new LinkedList<String>();
        for (InternetAddress a : contacts) {
            if (a == null) continue;
            addresses.add(a.toString());
        }
        this.contacts = addresses;
    }

    public List<String> getEmailContacts() {
        return this.contacts;
    }

    public void setEmailContacts(List<String> contacts) {
        this.contacts = contacts;
    }

    public String getName() {
        return this.getName(null);
    }

    public String getName(LangTag langTag) {
        return this.nameEntries.get(langTag);
    }

    public Map<LangTag, String> getNameEntries() {
        return this.nameEntries;
    }

    public void setName(String name) {
        this.nameEntries.put(null, name);
    }

    public void setName(String name, LangTag langTag) {
        this.nameEntries.put(langTag, name);
    }

    public URI getLogoURI() {
        return this.getLogoURI(null);
    }

    public URI getLogoURI(LangTag langTag) {
        return this.logoURIEntries.get(langTag);
    }

    public Map<LangTag, URI> getLogoURIEntries() {
        return this.logoURIEntries;
    }

    public void setLogoURI(URI logoURI) {
        this.logoURIEntries.put(null, logoURI);
    }

    public void setLogoURI(URI logoURI, LangTag langTag) {
        this.logoURIEntries.put(langTag, logoURI);
    }

    public URI getURI() {
        return this.getURI(null);
    }

    public URI getURI(LangTag langTag) {
        return this.uriEntries.get(langTag);
    }

    public Map<LangTag, URI> getURIEntries() {
        return this.uriEntries;
    }

    public void setURI(URI uri) {
        this.uriEntries.put(null, uri);
    }

    public void setURI(URI uri, LangTag langTag) {
        this.uriEntries.put(langTag, uri);
    }

    public URI getPolicyURI() {
        return this.getPolicyURI(null);
    }

    public URI getPolicyURI(LangTag langTag) {
        return this.policyURIEntries.get(langTag);
    }

    public Map<LangTag, URI> getPolicyURIEntries() {
        return this.policyURIEntries;
    }

    public void setPolicyURI(URI policyURI) {
        this.policyURIEntries.put(null, policyURI);
    }

    public void setPolicyURI(URI policyURI, LangTag langTag) {
        this.policyURIEntries.put(langTag, policyURI);
    }

    public URI getTermsOfServiceURI() {
        return this.getTermsOfServiceURI(null);
    }

    public URI getTermsOfServiceURI(LangTag langTag) {
        return this.tosURIEntries.get(langTag);
    }

    public Map<LangTag, URI> getTermsOfServiceURIEntries() {
        return this.tosURIEntries;
    }

    public void setTermsOfServiceURI(URI tosURI) {
        this.tosURIEntries.put(null, tosURI);
    }

    public void setTermsOfServiceURI(URI tosURI, LangTag langTag) {
        this.tosURIEntries.put(langTag, tosURI);
    }

    public ClientAuthenticationMethod getTokenEndpointAuthMethod() {
        return this.authMethod;
    }

    public void setTokenEndpointAuthMethod(ClientAuthenticationMethod authMethod) {
        this.authMethod = authMethod;
    }

    public JWSAlgorithm getTokenEndpointAuthJWSAlg() {
        return this.authJWSAlg;
    }

    public void setTokenEndpointAuthJWSAlg(JWSAlgorithm authJWSAlg) {
        this.authJWSAlg = authJWSAlg;
    }

    public URI getJWKSetURI() {
        return this.jwkSetURI;
    }

    public void setJWKSetURI(URI jwkSetURI) {
        this.jwkSetURI = jwkSetURI;
    }

    public JWKSet getJWKSet() {
        return this.jwkSet;
    }

    public void setJWKSet(JWKSet jwkSet) {
        this.jwkSet = jwkSet;
    }

    public SoftwareID getSoftwareID() {
        return this.softwareID;
    }

    public void setSoftwareID(SoftwareID softwareID) {
        this.softwareID = softwareID;
    }

    public SoftwareVersion getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(SoftwareVersion softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public Object getCustomField(String name) {
        return this.customFields.get(name);
    }

    public JSONObject getCustomFields() {
        return this.customFields;
    }

    public void setCustomField(String name, Object value) {
        this.customFields.put(name, value);
    }

    public void setCustomFields(JSONObject customFields) {
        if (customFields == null) {
            throw new IllegalArgumentException("The custom fields JSON object must not be null");
        }
        this.customFields = customFields;
    }

    public void applyDefaults() {
        if (this.responseTypes == null) {
            this.responseTypes = new HashSet<ResponseType>();
            this.responseTypes.add(ResponseType.getDefault());
        }
        if (this.grantTypes == null) {
            this.grantTypes = new HashSet<GrantType>();
            this.grantTypes.add(GrantType.AUTHORIZATION_CODE);
        }
        if (this.authMethod == null) {
            this.authMethod = this.grantTypes.contains(GrantType.IMPLICIT) && this.grantTypes.size() == 1 ? ClientAuthenticationMethod.NONE : ClientAuthenticationMethod.getDefault();
        }
    }

    public JSONObject toJSONObject() {
        return this.toJSONObject(true);
    }

    public JSONObject toJSONObject(boolean includeCustomFields) {
        URI uri;
        LangTag langTag;
        JSONObject o = includeCustomFields ? new JSONObject(this.customFields) : new JSONObject();
        if (this.redirectURIs != null) {
            JSONArray uriList = new JSONArray();
            for (URI uri2 : this.redirectURIs) {
                uriList.add(uri2.toString());
            }
            o.put("redirect_uris", uriList);
        }
        if (this.scope != null) {
            o.put("scope", this.scope.toString());
        }
        if (this.responseTypes != null) {
            JSONArray rtList = new JSONArray();
            for (ResponseType rt : this.responseTypes) {
                rtList.add(rt.toString());
            }
            o.put("response_types", rtList);
        }
        if (this.grantTypes != null) {
            JSONArray grantList = new JSONArray();
            for (GrantType grant : this.grantTypes) {
                grantList.add(grant.toString());
            }
            o.put("grant_types", grantList);
        }
        if (this.contacts != null) {
            o.put("contacts", this.contacts);
        }
        if (!this.nameEntries.isEmpty()) {
            for (Map.Entry<LangTag, String> entry : this.nameEntries.entrySet()) {
                langTag = entry.getKey();
                String name = entry.getValue();
                if (name == null) continue;
                if (langTag == null) {
                    o.put("client_name", entry.getValue());
                    continue;
                }
                o.put("client_name#" + langTag, entry.getValue());
            }
        }
        if (!this.logoURIEntries.isEmpty()) {
            for (Map.Entry<LangTag, Object> entry : this.logoURIEntries.entrySet()) {
                langTag = entry.getKey();
                uri = (URI)entry.getValue();
                if (uri == null) continue;
                if (langTag == null) {
                    o.put("logo_uri", ((URI)entry.getValue()).toString());
                    continue;
                }
                o.put("logo_uri#" + langTag, ((URI)entry.getValue()).toString());
            }
        }
        if (!this.uriEntries.isEmpty()) {
            for (Map.Entry<LangTag, Object> entry : this.uriEntries.entrySet()) {
                langTag = entry.getKey();
                uri = (URI)entry.getValue();
                if (uri == null) continue;
                if (langTag == null) {
                    o.put("client_uri", ((URI)entry.getValue()).toString());
                    continue;
                }
                o.put("client_uri#" + langTag, ((URI)entry.getValue()).toString());
            }
        }
        if (!this.policyURIEntries.isEmpty()) {
            for (Map.Entry<LangTag, Object> entry : this.policyURIEntries.entrySet()) {
                langTag = entry.getKey();
                uri = (URI)entry.getValue();
                if (uri == null) continue;
                if (langTag == null) {
                    o.put("policy_uri", ((URI)entry.getValue()).toString());
                    continue;
                }
                o.put("policy_uri#" + langTag, ((URI)entry.getValue()).toString());
            }
        }
        if (!this.tosURIEntries.isEmpty()) {
            for (Map.Entry<LangTag, Object> entry : this.tosURIEntries.entrySet()) {
                langTag = entry.getKey();
                uri = (URI)entry.getValue();
                if (uri == null) continue;
                if (langTag == null) {
                    o.put("tos_uri", ((URI)entry.getValue()).toString());
                    continue;
                }
                o.put("tos_uri#" + langTag, ((URI)entry.getValue()).toString());
            }
        }
        if (this.authMethod != null) {
            o.put("token_endpoint_auth_method", this.authMethod.toString());
        }
        if (this.authJWSAlg != null) {
            o.put("token_endpoint_auth_signing_alg", this.authJWSAlg.getName());
        }
        if (this.jwkSetURI != null) {
            o.put("jwks_uri", this.jwkSetURI.toString());
        }
        if (this.jwkSet != null) {
            o.put("jwks", this.jwkSet.toJSONObject(true));
        }
        if (this.softwareID != null) {
            o.put("software_id", this.softwareID.getValue());
        }
        if (this.softwareVersion != null) {
            o.put("software_version", this.softwareVersion.getValue());
        }
        return o;
    }

    public static ClientMetadata parse(JSONObject jsonObject) throws ParseException {
        return ClientMetadata.parseFromModifiableJSONObject(new JSONObject(jsonObject));
    }

    private static ClientMetadata parseFromModifiableJSONObject(JSONObject jsonObject) throws ParseException {
        ClientMetadata metadata = new ClientMetadata();
        if (jsonObject.get("redirect_uris") != null) {
            LinkedHashSet<URI> redirectURIs = new LinkedHashSet<URI>();
            for (String uriString : JSONObjectUtils.getStringArray(jsonObject, "redirect_uris")) {
                URI uri;
                try {
                    uri = new URI(uriString);
                }
                catch (URISyntaxException e) {
                    throw new ParseException("Invalid \"redirect_uris\" parameter: " + e.getMessage(), RegistrationError.INVALID_REDIRECT_URI.appendDescription(": " + e.getMessage()));
                }
                if (uri.getFragment() != null) {
                    String detail = "URI must not contain fragment";
                    throw new ParseException("Invalid \"redirect_uris\" parameter: " + detail, RegistrationError.INVALID_REDIRECT_URI.appendDescription(": " + detail));
                }
                redirectURIs.add(uri);
            }
            metadata.setRedirectionURIs(redirectURIs);
            jsonObject.remove("redirect_uris");
        }
        try {
            if (jsonObject.get("scope") != null) {
                metadata.setScope(Scope.parse(JSONObjectUtils.getString(jsonObject, "scope")));
                jsonObject.remove("scope");
            }
            if (jsonObject.get("response_types") != null) {
                LinkedHashSet<ResponseType> responseTypes = new LinkedHashSet<ResponseType>();
                for (String rt : JSONObjectUtils.getStringArray(jsonObject, "response_types")) {
                    responseTypes.add(ResponseType.parse(rt));
                }
                metadata.setResponseTypes(responseTypes);
                jsonObject.remove("response_types");
            }
            if (jsonObject.get("grant_types") != null) {
                LinkedHashSet<GrantType> grantTypes = new LinkedHashSet<GrantType>();
                for (String grant : JSONObjectUtils.getStringArray(jsonObject, "grant_types")) {
                    grantTypes.add(GrantType.parse(grant));
                }
                metadata.setGrantTypes(grantTypes);
                jsonObject.remove("grant_types");
            }
            if (jsonObject.get("contacts") != null) {
                metadata.setEmailContacts(JSONObjectUtils.getStringList(jsonObject, "contacts"));
                jsonObject.remove("contacts");
            }
            Map<LangTag, Object> matches = LangTagUtils.find("client_name", jsonObject);
            for (Map.Entry entry : matches.entrySet()) {
                try {
                    metadata.setName((String)entry.getValue(), (LangTag)entry.getKey());
                }
                catch (ClassCastException e) {
                    throw new ParseException("Invalid \"client_name\" (language tag) parameter");
                }
                ClientMetadata.removeMember(jsonObject, "client_name", (LangTag)entry.getKey());
            }
            matches = LangTagUtils.find("logo_uri", jsonObject);
            for (Map.Entry entry : matches.entrySet()) {
                if (entry.getValue() == null) continue;
                try {
                    metadata.setLogoURI(new URI((String)entry.getValue()), (LangTag)entry.getKey());
                }
                catch (Exception e) {
                    throw new ParseException("Invalid \"logo_uri\" (language tag) parameter");
                }
                ClientMetadata.removeMember(jsonObject, "logo_uri", (LangTag)entry.getKey());
            }
            matches = LangTagUtils.find("client_uri", jsonObject);
            for (Map.Entry entry : matches.entrySet()) {
                if (entry.getValue() == null) continue;
                try {
                    metadata.setURI(new URI((String)entry.getValue()), (LangTag)entry.getKey());
                }
                catch (Exception e) {
                    throw new ParseException("Invalid \"client_uri\" (language tag) parameter");
                }
                ClientMetadata.removeMember(jsonObject, "client_uri", (LangTag)entry.getKey());
            }
            matches = LangTagUtils.find("policy_uri", jsonObject);
            for (Map.Entry entry : matches.entrySet()) {
                if (entry.getValue() == null) continue;
                try {
                    metadata.setPolicyURI(new URI((String)entry.getValue()), (LangTag)entry.getKey());
                }
                catch (Exception e) {
                    throw new ParseException("Invalid \"policy_uri\" (language tag) parameter");
                }
                ClientMetadata.removeMember(jsonObject, "policy_uri", (LangTag)entry.getKey());
            }
            matches = LangTagUtils.find("tos_uri", jsonObject);
            for (Map.Entry entry : matches.entrySet()) {
                if (entry.getValue() == null) continue;
                try {
                    metadata.setTermsOfServiceURI(new URI((String)entry.getValue()), (LangTag)entry.getKey());
                }
                catch (Exception e) {
                    throw new ParseException("Invalid \"tos_uri\" (language tag) parameter");
                }
                ClientMetadata.removeMember(jsonObject, "tos_uri", (LangTag)entry.getKey());
            }
            if (jsonObject.get("token_endpoint_auth_method") != null) {
                metadata.setTokenEndpointAuthMethod(new ClientAuthenticationMethod(JSONObjectUtils.getString(jsonObject, "token_endpoint_auth_method")));
                jsonObject.remove("token_endpoint_auth_method");
            }
            if (jsonObject.get("token_endpoint_auth_signing_alg") != null) {
                metadata.setTokenEndpointAuthJWSAlg(new JWSAlgorithm(JSONObjectUtils.getString(jsonObject, "token_endpoint_auth_signing_alg")));
                jsonObject.remove("token_endpoint_auth_signing_alg");
            }
            if (jsonObject.get("jwks_uri") != null) {
                metadata.setJWKSetURI(JSONObjectUtils.getURI(jsonObject, "jwks_uri"));
                jsonObject.remove("jwks_uri");
            }
            if (jsonObject.get("jwks") != null) {
                try {
                    metadata.setJWKSet(JWKSet.parse(JSONObjectUtils.getJSONObject(jsonObject, "jwks")));
                }
                catch (java.text.ParseException e) {
                    throw new ParseException(e.getMessage(), e);
                }
                jsonObject.remove("jwks");
            }
            if (jsonObject.get("software_id") != null) {
                metadata.setSoftwareID(new SoftwareID(JSONObjectUtils.getString(jsonObject, "software_id")));
                jsonObject.remove("software_id");
            }
            if (jsonObject.get("software_version") != null) {
                metadata.setSoftwareVersion(new SoftwareVersion(JSONObjectUtils.getString(jsonObject, "software_version")));
                jsonObject.remove("software_version");
            }
        }
        catch (ParseException e) {
            throw new ParseException(e.getMessage(), RegistrationError.INVALID_CLIENT_METADATA.appendDescription(": " + e.getMessage()), e.getCause());
        }
        metadata.customFields = jsonObject;
        return metadata;
    }

    private static void removeMember(JSONObject jsonObject, String name, LangTag langTag) {
        if (langTag == null) {
            jsonObject.remove(name);
        } else {
            jsonObject.remove(name + "#" + langTag);
        }
    }

    static {
        HashSet<String> p = new HashSet<String>();
        p.add("redirect_uris");
        p.add("scope");
        p.add("response_types");
        p.add("grant_types");
        p.add("contacts");
        p.add("client_name");
        p.add("logo_uri");
        p.add("client_uri");
        p.add("policy_uri");
        p.add("tos_uri");
        p.add("token_endpoint_auth_method");
        p.add("token_endpoint_auth_signing_alg");
        p.add("jwks_uri");
        p.add("jwks");
        p.add("software_id");
        p.add("software_version");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(p);
    }
}

