/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.token;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class OIDCTokens
extends Tokens {
    private final JWT idToken;
    private final String idTokenString;

    public OIDCTokens(JWT idToken, AccessToken accessToken, RefreshToken refreshToken) {
        super(accessToken, refreshToken);
        if (idToken == null) {
            throw new IllegalArgumentException("The ID token must not be null");
        }
        this.idToken = idToken;
        this.idTokenString = null;
    }

    public OIDCTokens(String idTokenString, AccessToken accessToken, RefreshToken refreshToken) {
        super(accessToken, refreshToken);
        if (idTokenString == null) {
            throw new IllegalArgumentException("The ID token string must not be null");
        }
        this.idTokenString = idTokenString;
        this.idToken = null;
    }

    public JWT getIDToken() {
        if (this.idToken != null) {
            return this.idToken;
        }
        if (this.idTokenString != null) {
            try {
                return JWTParser.parse(this.idTokenString);
            }
            catch (java.text.ParseException e) {
                return null;
            }
        }
        return null;
    }

    public String getIDTokenString() {
        if (this.idTokenString != null) {
            return this.idTokenString;
        }
        if (this.idToken != null) {
            if (this.idToken.getParsedString() != null) {
                return this.idToken.getParsedString();
            }
            try {
                return this.idToken.serialize();
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Set<String> getParameterNames() {
        Set<String> paramNames = super.getParameterNames();
        paramNames.add("id_token");
        return paramNames;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        o.put("id_token", this.getIDTokenString());
        return o;
    }

    public static OIDCTokens parse(JSONObject jsonObject) throws ParseException {
        JWT idToken;
        try {
            idToken = JWTParser.parse(JSONObjectUtils.getString(jsonObject, "id_token"));
        }
        catch (java.text.ParseException e) {
            throw new ParseException("Couldn't parse ID token: " + e.getMessage(), e);
        }
        return new OIDCTokens(idToken, AccessToken.parse(jsonObject), RefreshToken.parse(jsonObject));
    }
}

