/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.vm.azure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.ClientCredential;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheResult;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.api.SubscriptionStatusWithData;
import org.ligoj.app.dao.NodeRepository;
import org.ligoj.app.plugin.vm.Vm;
import org.ligoj.app.plugin.vm.VmServicePlugin;
import org.ligoj.app.plugin.vm.azure.AzureCurlProcessor;
import org.ligoj.app.plugin.vm.azure.AzureVm;
import org.ligoj.app.plugin.vm.azure.AzureVmList;
import org.ligoj.app.plugin.vm.azure.VmSize;
import org.ligoj.app.plugin.vm.azure.VmSizes;
import org.ligoj.app.plugin.vm.dao.VmScheduleRepository;
import org.ligoj.app.plugin.vm.model.VmOperation;
import org.ligoj.app.plugin.vm.model.VmStatus;
import org.ligoj.app.resource.plugin.AbstractXmlApiToolPluginResource;
import org.ligoj.app.resource.plugin.CurlCacheToken;
import org.ligoj.app.resource.plugin.CurlProcessor;
import org.ligoj.app.resource.plugin.CurlRequest;
import org.ligoj.bootstrap.core.SpringUtils;
import org.ligoj.bootstrap.core.resource.BusinessException;
import org.ligoj.bootstrap.core.security.SecurityHelper;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Path(value="/service/vm/azure")
@Service
@Produces(value={"application/json"})
public class VmAzurePluginResource
extends AbstractXmlApiToolPluginResource
implements VmServicePlugin {
    private static final Logger log = LoggerFactory.getLogger(VmAzurePluginResource.class);
    public static final String URL = "/service/vm/azure";
    public static final String KEY = "/service/vm/azure".replace('/', ':').substring(1);
    public static final String PARAMETER_SUBSCRIPTION = KEY + ":subscription";
    public static final String PARAMETER_APPID = KEY + ":application";
    public static final String PARAMETER_KEY = KEY + ":key";
    public static final String PARAMETER_TENANT = KEY + ":tenant";
    public static final String PARAMETER_RESOURCE_GROUP = KEY + ":resource-group";
    public static final String PARAMETER_VM = KEY + ":name";
    public static final String CONF_API_VERSION = KEY + ":api";
    public static final String DEFAULT_API_VERSION = "2017-03-30";
    private static final String CONF_AUTHORITY = KEY + ":authority";
    public static final String DEFAULT_AUTHORITY = "https://login.windows.net/";
    private static final String CONF_MANAGEMENT_URL = KEY + ":management";
    private static final String DEFAULT_MANAGEMENT_URL = "https://management.azure.com/";
    private static final String COMPUTE_URL = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines";
    private static final String SIZES_URL = "subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/vmSizes?api-version={apiVersion}";
    private static final String VM_URL = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{vm}?$expand=instanceView&api-version={apiVersion}";
    private static final String FIND_VM_URL = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines?api-version={apiVersion}";
    private static final String OPERATION_VM = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{vm}/{operation}?api-version={apiVersion}";
    private static final Map<VmOperation, String> OPERATION_TO_AZURE = new EnumMap<VmOperation, String>(VmOperation.class);
    private static final Map<VmStatus, Map<VmOperation, VmOperation>> FAILSAFE_OPERATIONS;
    private static final String BUSY_CODE = "ing";
    private static final String UNDEPLOYED_CODE = "PowerState/deallocated";
    private static final Map<String, VmStatus> CODE_TO_STATUS;
    @Autowired
    private CurlCacheToken curlCacheToken;
    @Autowired
    private VmScheduleRepository vmScheduleRepository;
    @Autowired
    private SecurityHelper securityHelper;
    @Autowired
    private ConfigurationResource configuration;
    @Autowired
    private NodeRepository nodeRepository;
    @Autowired
    private ObjectMapper objectMapper;
    @Value(value="${saas.service-vm-azure-auth-retries:2}")
    private int retries;

    private static void registerOperation(VmStatus status, VmOperation operation, VmOperation operationFailSafe) {
        FAILSAFE_OPERATIONS.computeIfAbsent(status, s -> new EnumMap(VmOperation.class));
        FAILSAFE_OPERATIONS.get(status).put(operation, operationFailSafe);
    }

    protected String authenticate(String tenant, String principal, String key) {
        return this.curlCacheToken.getTokenCache(VmAzurePluginResource.class, tenant + "##" + principal + "/" + key, k -> this.getAccessTokenFromUserCredentials(tenant, principal, key), this.retries, () -> new ValidationJsonException(PARAMETER_KEY, (Serializable)((Object)"azure-login"), new Serializable[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAccessTokenFromUserCredentials(String tenant, String principal, String key) {
        ExecutorService service = this.newExecutorService();
        try {
            AuthenticationContext context = this.newAuthenticationContext(tenant, service);
            ClientCredential credential = new ClientCredential(principal, key);
            String string = context.acquireToken(this.getManagementUrl(), credential, null).get().getAccessToken();
            return string;
        }
        catch (InterruptedException | MalformedURLException | ExecutionException e) {
            log.info("Azure authentication failed for tenant {} and principal {}", new Object[]{tenant, principal, e});
        }
        finally {
            service.shutdown();
        }
        return null;
    }

    protected ExecutorService newExecutorService() {
        return Executors.newFixedThreadPool(1);
    }

    protected AuthenticationContext newAuthenticationContext(String tenant, ExecutorService service) throws MalformedURLException {
        return new AuthenticationContext(this.getAuthority() + tenant, true, service);
    }

    private String getAuthority() {
        return this.configuration.get(CONF_AUTHORITY, DEFAULT_AUTHORITY);
    }

    private String getManagementUrl() {
        return this.configuration.get(CONF_MANAGEMENT_URL, DEFAULT_MANAGEMENT_URL);
    }

    private String getApiVersion() {
        return this.configuration.get(CONF_API_VERSION, DEFAULT_API_VERSION);
    }

    protected void authenticate(Map<String, String> parameters, AzureCurlProcessor processor) {
        String principal = parameters.get(PARAMETER_APPID);
        String key = StringUtils.trimToEmpty((String)parameters.get(PARAMETER_KEY));
        String tenant = StringUtils.trimToEmpty((String)parameters.get(PARAMETER_TENANT));
        processor.setToken(this.authenticate(tenant, principal, key));
    }

    public void link(int subscription) throws Exception {
        this.validateVm(this.subscriptionResource.getParameters(subscription));
    }

    @GET
    @Path(value="{node:[a-z].*}/{criteria}")
    @Consumes(value={"application/json"})
    public List<AzureVm> findAllByName(@PathParam(value="node") String node, @PathParam(value="criteria") String criteria) throws IOException {
        if (this.nodeRepository.findOneVisible(node, this.securityHelper.getLogin()) == null) {
            return Collections.emptyList();
        }
        Map parameters = this.pvResource.getNodeParameters(node);
        String vmJson = StringUtils.defaultString((String)this.getAzureResource(parameters, FIND_VM_URL), (String)"{\"value\":[]}");
        AzureVmList azure = (AzureVmList)this.objectMapper.readValue(vmJson, AzureVmList.class);
        return azure.getValue().stream().filter(vm -> StringUtils.containsIgnoreCase((CharSequence)vm.getName(), (CharSequence)criteria)).map(v -> this.toVm((AzureVmList.AzureVmEntry)v, null)).sorted().collect(Collectors.toList());
    }

    private VmSize toVmSize(Map<String, String> parameters, String azSub, VmAzurePluginResource that, String type, String location) {
        try {
            return that.getInstanceSizes(azSub, location, parameters).getOrDefault(type, new VmSize(type));
        }
        catch (IOException ioe) {
            return new VmSize(type);
        }
    }

    private AzureVm toVm(AzureVmList.AzureVmEntry azureVm, BiFunction<String, String, VmSize> sizeProvider) {
        AzureVm result = new AzureVm();
        AzureVmList.AzureVmDetails properties = azureVm.getProperties();
        result.setId((Serializable)((Object)azureVm.getName()));
        result.setInternalId(properties.getVmId());
        result.setName(azureVm.getName());
        result.setLocation(azureVm.getLocation());
        if (sizeProvider != null) {
            String instanceType = properties.getHardwareProfile().get("vmSize");
            VmSize size = sizeProvider.apply(instanceType, azureVm.getLocation());
            result.setCpu(size.getNumberOfCores());
            result.setRam(size.getMemoryInMB());
        }
        AzureVmList.AzureVmOs image = properties.getStorageProfile().getImageReference();
        result.setOs(image.getOffer() + " " + image.getSku() + " " + image.getPublisher());
        return result;
    }

    protected AzureVm validateVm(Map<String, String> parameters) throws IOException {
        return this.toVm(this.getAzureVm(parameters), null);
    }

    public AzureVm getVmDetails(Map<String, String> parameters) throws IOException {
        AzureVmList.AzureVmEntry azure = this.getAzureVm(parameters);
        String azSub = parameters.get(PARAMETER_SUBSCRIPTION);
        VmAzurePluginResource that = (VmAzurePluginResource)((Object)SpringUtils.getBean(VmAzurePluginResource.class));
        BiFunction<String, String, VmSize> sizes = (t, l) -> this.toVmSize(parameters, azSub, that, (String)t, (String)l);
        return this.toVmStatus(azure, sizes);
    }

    protected AzureVmList.AzureVmEntry getAzureVm(Map<String, String> parameters) throws IOException {
        String name = parameters.get(PARAMETER_VM);
        String vmJson = this.getAzureResource(parameters, VM_URL.replace("{vm}", name));
        if (vmJson == null) {
            throw new ValidationJsonException(PARAMETER_VM, (Serializable)((Object)"azure-vm"), new Serializable[]{name});
        }
        return (AzureVmList.AzureVmEntry)this.objectMapper.readValue(vmJson, AzureVmList.AzureVmEntry.class);
    }

    private AzureVm toVmStatus(AzureVmList.AzureVmEntry azureVm, BiFunction<String, String, VmSize> sizeProvider) {
        AzureVm result = this.toVm(azureVm, sizeProvider);
        AzureVmList.AzureVmDetails properties = azureVm.getProperties();
        List<AzureVmList.VmStatus> statuses = properties.getInstanceView().getStatuses();
        result.setStatus(this.getStatus(statuses));
        result.setBusy(this.isBusy(statuses));
        result.setDeployed(this.isDeployed(statuses));
        return result;
    }

    private VmStatus getStatus(List<AzureVmList.VmStatus> statuses) {
        return statuses.stream().map(AzureVmList.VmStatus::getCode).map(CODE_TO_STATUS::get).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private boolean isBusy(List<AzureVmList.VmStatus> statuses) {
        return statuses.stream().map(AzureVmList.VmStatus::getCode).filter(c -> c.startsWith("ProvisioningState")).anyMatch(c -> c.endsWith(BUSY_CODE));
    }

    private boolean isDeployed(List<AzureVmList.VmStatus> statuses) {
        return statuses.stream().map(AzureVmList.VmStatus::getCode).anyMatch(UNDEPLOYED_CODE::equals);
    }

    protected String getAzureResource(Map<String, String> parameters, String resource) {
        return this.authenticateAndExecute(parameters, "GET", resource);
    }

    protected String authenticateAndExecute(Map<String, String> parameters, String method, String resource) {
        AzureCurlProcessor processor = new AzureCurlProcessor();
        this.authenticate(parameters, processor);
        return this.execute(processor, method, this.buildUrl(parameters, resource), "");
    }

    private String buildUrl(Map<String, String> parameters, String resource) {
        return this.getManagementUrl() + resource.replace("{apiVersion}", this.getApiVersion()).replace("{resourceGroup}", parameters.getOrDefault(PARAMETER_RESOURCE_GROUP, "-")).replace("{subscriptionId}", parameters.getOrDefault(PARAMETER_SUBSCRIPTION, "-")).replace("{vm}", parameters.getOrDefault(PARAMETER_VM, "-"));
    }

    protected String execute(CurlProcessor processor, String method, String url, String resource) {
        CurlRequest request = new CurlRequest(method, StringUtils.removeEnd((String)(StringUtils.appendIfMissing((String)url, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + StringUtils.removeStart((String)resource, (String)"/")), (String)"/"), null, new String[0]);
        request.setSaveResponse(true);
        processor.process(new CurlRequest[]{request});
        processor.close();
        return request.getResponse();
    }

    public String getKey() {
        return KEY;
    }

    private void validateAdminAccess(Map<String, String> parameters) {
        if (this.getAzureResource(parameters, FIND_VM_URL) == null) {
            throw new ValidationJsonException(PARAMETER_SUBSCRIPTION, (Serializable)((Object)"azure-admin"), new Serializable[0]);
        }
    }

    public String getVersion(Map<String, String> parameters) {
        return this.getApiVersion();
    }

    public boolean checkStatus(Map<String, String> parameters) throws Exception {
        this.validateAdminAccess(parameters);
        return true;
    }

    public SubscriptionStatusWithData checkSubscriptionStatus(int subscription, String node, Map<String, String> parameters) throws Exception {
        SubscriptionStatusWithData status = new SubscriptionStatusWithData();
        status.put("vm", (Object)this.getVmDetails((Map)parameters));
        status.put("schedules", (Object)this.vmScheduleRepository.countBySubscription(subscription));
        return status;
    }

    public void execute(int subscription, VmOperation operation) throws Exception {
        Map parameters = this.subscriptionResource.getParametersNoCheck(subscription);
        Vm vm = this.getVmDetails(parameters);
        VmStatus status = vm.getStatus();
        VmOperation operationF = this.failSafeOperation(status, operation);
        if (operationF == null) {
            log.info("Requested operation {} is marked as useless considering the status {} of vm {}", new Object[]{operation, status, parameters.get(PARAMETER_VM)});
            return;
        }
        this.checkSchedulerResponse(this.authenticateAndExecute(parameters, "POST", OPERATION_VM.replace("{operation}", OPERATION_TO_AZURE.get(operationF))));
    }

    private void checkSchedulerResponse(String response) {
        if (response == null) {
            throw new BusinessException("vm-operation-execute", new Serializable[0]);
        }
    }

    protected VmOperation failSafeOperation(VmStatus status, VmOperation operation) {
        return Optional.ofNullable(FAILSAFE_OPERATIONS.get(status)).map(m -> (VmOperation)m.get(operation)).orElse(null);
    }

    @CacheResult(cacheName="azure-sizes")
    public Map<String, VmSize> getInstanceSizes(@CacheKey String azSub, @CacheKey String location, Map<String, String> parameters) throws IOException {
        String jsonSizes = this.getAzureResource(parameters, SIZES_URL.replace("{subscriptionId}", azSub).replace("{location}", location));
        return ((VmSizes)this.objectMapper.readValue(StringUtils.defaultString((String)jsonSizes, (String)"{\"value\":[]}"), VmSizes.class)).getValue().stream().collect(Collectors.toMap(VmSize::getName, Function.identity()));
    }

    static {
        OPERATION_TO_AZURE.put(VmOperation.OFF, "powerOff");
        OPERATION_TO_AZURE.put(VmOperation.SHUTDOWN, "powerOff");
        OPERATION_TO_AZURE.put(VmOperation.ON, "start");
        OPERATION_TO_AZURE.put(VmOperation.REBOOT, "restart");
        OPERATION_TO_AZURE.put(VmOperation.RESET, "restart");
        FAILSAFE_OPERATIONS = new EnumMap<VmStatus, Map<VmOperation, VmOperation>>(VmStatus.class);
        CODE_TO_STATUS = new HashMap<String, VmStatus>();
        CODE_TO_STATUS.put("PowerState/running", VmStatus.POWERED_ON);
        CODE_TO_STATUS.put("PowerState/starting", VmStatus.POWERED_ON);
        CODE_TO_STATUS.put("PowerState/stopped", VmStatus.POWERED_OFF);
        CODE_TO_STATUS.put(UNDEPLOYED_CODE, VmStatus.POWERED_OFF);
        CODE_TO_STATUS.put("PowerState/deallocating", VmStatus.POWERED_OFF);
        CODE_TO_STATUS.put("PowerState/stopping", VmStatus.POWERED_OFF);
        VmAzurePluginResource.registerOperation(VmStatus.POWERED_OFF, VmOperation.ON, VmOperation.ON);
        VmAzurePluginResource.registerOperation(VmStatus.POWERED_OFF, VmOperation.RESET, VmOperation.ON);
        VmAzurePluginResource.registerOperation(VmStatus.POWERED_OFF, VmOperation.REBOOT, VmOperation.ON);
        VmAzurePluginResource.registerOperation(VmStatus.POWERED_ON, VmOperation.SHUTDOWN, VmOperation.SHUTDOWN);
        VmAzurePluginResource.registerOperation(VmStatus.POWERED_ON, VmOperation.OFF, VmOperation.OFF);
        VmAzurePluginResource.registerOperation(VmStatus.POWERED_ON, VmOperation.RESET, VmOperation.RESET);
        VmAzurePluginResource.registerOperation(VmStatus.POWERED_ON, VmOperation.REBOOT, VmOperation.REBOOT);
    }
}

