/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.dom.Style;
import java.util.Optional;
import java.util.function.BiConsumer;

public class ComponentStyles {
    private ComponentStyles() {
    }

    public static void setOverflowAuto(Component component) {
        ComponentStyles.setStyle(component, Style::setOverflow, Style.Overflow.AUTO);
    }

    public static void setFormItemLabelWidth(Component component, String width) {
        BiConsumer<Style, String> formLabelWidthConsumer = (style, s) -> style.set("--linkki-form-item-label-width", s);
        ComponentStyles.setStyle(component, formLabelWidthConsumer, width);
    }

    private static <T> void setStyle(Component component, BiConsumer<Style, T> styleConsumer, T value) {
        Optional.ofNullable(component).map(c -> c instanceof Dialog ? c.getElement().getStyle() : c.getStyle()).ifPresent(style -> styleConsumer.accept((Style)style, value));
    }
}

