/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.aspects;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.dispatcher.PropertyDispatcher;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.defaults.ui.aspects.types.AvailableValuesType;
import org.linkki.core.defaults.ui.element.AvailableValuesProvider;
import org.linkki.core.ui.aspects.ItemCache;
import org.linkki.util.Objects;
import org.linkki.util.handler.Handler;

public class AvailableValuesAspectDefinition<C>
implements LinkkiAspectDefinition {
    public static final String NAME = "availableValues";
    private final AvailableValuesType availableValuesType;
    private final BiConsumer<C, List<Object>> dataProviderSetter;

    public AvailableValuesAspectDefinition(AvailableValuesType availableValuesType, BiConsumer<C, List<Object>> dataProviderSetter) {
        this.availableValuesType = (AvailableValuesType)Objects.requireNonNull((Object)availableValuesType, (String)"availableValuesType must not be null");
        this.dataProviderSetter = (BiConsumer)Objects.requireNonNull(dataProviderSetter, (String)"dataProviderSetter must not be null");
    }

    public Handler createUiUpdater(PropertyDispatcher propertyDispatcher, ComponentWrapper componentWrapper) {
        this.setDataProvider(componentWrapper, Collections.emptyList());
        if (this.getAvailableValuesType() == AvailableValuesType.NO_VALUES) {
            return Handler.NOP_HANDLER;
        }
        Aspect<Collection<?>> aspect = this.createAspect(propertyDispatcher.getValueClass());
        ItemCache cache = new ItemCache();
        return () -> this.updateItems(propertyDispatcher.getProperty(), cache, (Collection)propertyDispatcher.pull(aspect), componentWrapper);
    }

    private void updateItems(String propertyName, ItemCache cache, @Nullable Collection<?> newItemsParam, ComponentWrapper componentWrapper) {
        if (newItemsParam == null) {
            if (this.availableValuesType == AvailableValuesType.DYNAMIC) {
                throw new NullPointerException("get" + propertyName + "AvailableValues() must not return null.");
            }
            throw new IllegalStateException("Cannot retrieve list of available values for " + propertyName);
        }
        ArrayList<Object> newItems = new ArrayList<Object>((Collection)Objects.requireNonNull(newItemsParam, (String)"List of available values must not be null"));
        this.handleNullItems(componentWrapper, newItems);
        boolean hasChanged = cache.replaceContent(newItems);
        if (hasChanged) {
            this.setDataProvider(componentWrapper, cache.getItems());
        }
    }

    public Aspect<Collection<?>> createAspect(Class<?> valueClass) {
        AvailableValuesType type = this.getAvailableValuesType();
        if (type == AvailableValuesType.DYNAMIC) {
            return Aspect.of((String)NAME);
        }
        if (type == AvailableValuesType.NO_VALUES) {
            return Aspect.of((String)NAME, new ArrayList());
        }
        return Aspect.of((String)NAME, this.getValuesDerivedFromDatatype(valueClass));
    }

    @CheckForNull
    protected <T extends Enum<T>> List<?> getValuesDerivedFromDatatype(Class<?> valueClass) {
        if (valueClass.isEnum()) {
            Class<?> enumType = valueClass;
            return AvailableValuesProvider.enumToValues(enumType, (this.getAvailableValuesType() == AvailableValuesType.ENUM_VALUES_INCL_NULL ? 1 : 0) != 0);
        }
        if (valueClass == Boolean.TYPE) {
            return AvailableValuesProvider.booleanPrimitiveToValues();
        }
        if (valueClass == Boolean.class) {
            return AvailableValuesProvider.booleanWrapperToValues();
        }
        return null;
    }

    protected void setDataProvider(ComponentWrapper componentWrapper, List<Object> data) {
        this.dataProviderSetter.accept(componentWrapper.getComponent(), data);
    }

    protected AvailableValuesType getAvailableValuesType() {
        return this.availableValuesType;
    }

    protected void handleNullItems(ComponentWrapper componentWrapper, List<?> items) {
    }
}

